/*
 * TestgetplatformCmd.java --
 *
 *	This file contains the Jacl implementation of the built-in Tcl test
 *	command:  testgetplatform.
 *
 * Copyright (c) 1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL
 * WARRANTIES.
 * 
 * SCCS: @(#) TestgetplatformCmd.java 1.1 97/11/03 10:27:20
 *
 */

package tcl.lang;

/*
 * This class implements the built-in test command:  testgetplatform.
 */

class TestgetplatformCmd implements Command {

    static Class procClass = null;

    static final private String validCmds[] = {
	"unix",
	"windows",
	"mac"
    };

    static final int OPT_UNIX		= 0;
    static final int OPT_WINDOWS	= 1;
    static final int OPT_MAC		= 2;


/*
 *----------------------------------------------------------------------
 *
 * CmdProc --
 *
 *	This procedure is invoked to process the "testgetplatform" Tcl command.
 *	This command is only used in the test suite.
 *
 * Results:
 *	The name of the platform which the fileCmd object thinks it is running
 *      on.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

public void 
cmdProc(
    Interp interp,  			// Current interp to eval the file cmd.
    TclObject argv[])
throws
    TclException
{
    if (argv.length != 1) {
	throw new TclNumArgsException(interp, 1, argv, "");
    }

    switch (JACL.PLATFORM) {
    case JACL.PLATFORM_WINDOWS:
	interp.setResult("windows");
	break;
    case JACL.PLATFORM_MAC:
	interp.setResult("mac");
	break;
    default:
	interp.setResult("unix");
    }
    return;
}

} // end class TestgetplatformCmd
