/* sys.h */

/*
 * ncftp may need work arounds for some things due to the differences
 * in implementations of unix.  The following systems are taken care
 * of automatically:
 *
 *    SunOS/Solaris (but use gcc)
 *    Silicon Graphics IRIX
 *    AIX
 *    SINIX
 *    Ultrix
 *    NeXT
 *
 * For those systems, you should be able to 'make' ncftp without any
 * problems.  Otherwise you will have to configure ncftp manually.
 * You will need to add these things to the SDEFS line in the Makefile
 * as applicable.
 *
 * For these systems, some things are taken care of automatically, but
 * you still need to add something to CFLAGS or SDEFS:
 *
 *     Hewlett-Packard HP-UX:  If you have 7.0, you'll need to find
 *       a copy of <ftp.h> from somewhere (8.0 has it though). Then
 *       set CFLAGS= -Aa.  You may also need to use gcc if your
 *       compiler is non-ANSI.
 *
 *     SCO Unix:  Add -DSCO324 to SDEFS, and -lsocket to MORELIBS.
 *
 *     Bull DPX/2: Add -DBULL to SDEFS, add -linet to MORELIBS, and
 *       use gcc.
 *
 *     Sequent's DYNIX: Use gcc and add -DDYNIX (if necessary) to SDEFS.
 *       You may also be short several string functions which you will
 *       have to get elsewhere.
 *
 * Is your system closer to System V or BSD?  Your SDEFS line should have
 * either -DBSD or -DSYSV.  If you don't know, try leaving it blank first;
 * some compilers automatically define it for you.  So far, defining
 * SYSV just defines a couple of macros for similar functions in BSD.
 *
 * You may need to add -DRINDEX if your system uses strrchr instead.
 * If SYSV is defined, RINDEX is defined automatically because System V
 * uses strrchr.
 *
 * Add -DCONST if your compiler chokes on the const directive.
 *
 * Add -DSYSSELECTH if you need <sys/select.h> included for definitions
 * of fd_set, etc.
 *
 * Add -DNO_UNISTDH if you don't have <unistd.h>.
 *
 * Add -DNO_STDLIBH if you don't have <stdlib.h>.
 *
 * Add -DGETPASS if you would rather use the standard getpass() system
 * call, instead of our version, getpass2(), which takes more than 8
 * characters.  You may want to define this if you are having problems
 * with compile errors in cmds.c where getpass2() is located.
 *
 * If you haven't given up on our getpass2(), you can try adding -DSGTTYB
 * if you want to use a struct sgttyb instead of a struct termio.  By default,
 * BSD systems define SGTTYB automatically.  You can also try adding -DTERMIOS
 * to use a POSIX compliant struct termios instead.  Don't pull your hair out
 * trying to get the getpass2 code to compile;  if it gives you problems just
 * define -DGETPASS and hope your system's getpass can handle passwords
 * longer than 8 characters.
 *
 * Add -DBAD_INETADDR if your inet_addr() function returns a struct in_addr
 * instead of a u_long, as it should (in DG/UX 5.4.1).
 *
 * (Optional) Add -DGETCWDSIZET if your system's getcwd() takes a size_t
 * as the second parameter instead of an int.
 *
 * (Optional) Add -DHERROR if you know you have the herror() system
 * call.
 *
 * (Optional) Add -DU_WAIT if you know your wait system call takes
 * a pointer to a 'union wait.'  Defined automatically if you define
 * BSD.
 *
 * (Optional) Add -DHOSTNAME=\"machine.domain.nam\" if your system
 * doesn't generate it's own hostname.  To check this, compile ncftp
 * then run it and type 'set.'  Look at the variable anon-password.
 * If the hostname is wrong, recompile it with HOSTNAME set to your
 * machine's address.
 */

#ifdef __sun
#	ifndef sun
#		define sun 1
#	endif
#endif

#ifdef sun
#	ifndef __GNUC__
#		error "You will need to use gcc since Sun's cc isn't ANSI.  Set CC=gcc in the Makefile." 
#	endif
#	define System "SunOS"
#	ifndef RINDEX
#		define RINDEX 1
#	endif
#endif /* sun */

#ifdef __sgi
#	ifndef sgi
#		define sgi 1
#	endif
#endif

#ifdef sgi
#	define System "IRIX"
#	ifndef SYSV
#		define SYSV 1
#	endif
#	ifndef HERROR
#		define HERROR 1
#	endif
#	ifndef U_WAIT
#		define U_WAIT 1
#	endif
#endif /* sgi */

#ifdef _AIX
#	define System "AIX"
#	define SYSSELECTH 1
#endif	/* _AIX */

#ifdef SCO324
#	define System "SCO Unix"
#	ifndef SYSV
#		define SYSV 1
#	endif
#endif	/* SCO */

#ifdef NeXT
#	ifndef RINDEX
#		define RINDEX 1
#	endif
#	ifndef BSD
#		define BSD 1
#	endif
#	ifndef NO_UNISTDH
#		define NO_UNISTDH 1
#	endif
#endif

#ifdef DYNIX
#	define System "Dynix"
#	ifndef BSD
#		define BSD 1
#	endif
#	ifndef SGTTYB
#		define SGTTYB 1
#	endif
#	ifndef NO_STDLIBH
#		define NO_STDLIBH 1
#	endif
#endif	/* DYNIX */

#ifdef ultrix
#	define System "Ultrix"
#	ifndef BSD
#		define BSD 1
#	endif
#	ifndef CONST
#		define CONST
#	endif
#endif	/* ultrix */

#ifdef __hpux
#	ifndef HPUX
#		define HPUX 1
#	endif
#endif

#ifdef HPUX 
#	define System "HP-UX"
#	ifndef _HPUX_SOURCE
#		define _HPUX_SOURCE 1
#	endif
#	ifndef GETCWDSIZET
#		define GETCWDSIZET 1
#	endif
#	define SYSV 1
#endif	/* HPUX */

#ifdef SINIX
#	define System "SINIX"
#	ifndef SYSV
#		define SYSV 1
#	endif
/* You may need to add -lresolv, -lport, -lcurses to MORELIBS in Makefile. */
#endif

#ifdef BULL          /* added 23nov92 for Bull DPX/2 */
#	define _POSIX_SOURCE
#	define _XOPEN_SOURCE
#	define _BULL_SOURCE
#	ifndef SYSV
#		define SYSV 1
#	endif
#	define bull
#	define System "Bull DPX/2 BOS"
#	include <sys/types.h>
#	define SYSSELECTH
#endif  /* BULL */   /* added 23nov92 for Bull DPX/2 */

#ifdef __dgux
#     ifndef DGUX
#             define DGUX 1
#     endif
#endif

#ifdef DGUX
#     ifndef _DGUX_SOURCE
#             define _DGUX_SOURCE
#     endif
#     define GETCWDSIZET 1
#     define BAD_INETADDR 1
#     define SYSV 1
#     define System "DG/UX"
#endif  /* DGUX */

#ifdef apollo
#	define TERMIOS
#	ifndef BSD
#		define BSD 1
#	endif
#endif

#ifdef linux
#  define USG
/* #  define SYSSELECTH */
#endif

/* -------------------------------------------------------------------- */

#ifdef _SYSV
#	ifndef SYSV
#		define SYSV 1
#	endif
#endif

#ifdef USG
#	ifndef SYSV
#		define SYSV 1
#	endif
#endif

#ifdef _BSD
#	ifndef BSD
#		define BSD 1
#	endif
#endif

#ifdef SYSV
#	ifndef RINDEX
#		define RINDEX 1
#	endif
#	define bcopy(s,d,l) memcpy((d),(s),(l))
#	define bzero(cp,l) memset((cp),0,(l))
#endif

#ifdef BSD
#	ifndef SYSDIRH
#		define SYSDIRH 1
#	endif
#	ifndef U_WAIT
#		define U_WAIT 1 /* Use a 'union wait' parameter with wait(). */
#	endif
#	ifndef SGTTYB
#		define SGTTYB
#	endif
#endif

/*
 * Some systems besides System V don't use rindex/index (like SunOS).
 * Add -DRINDEX to your SDEFS line if you need to.
 */
#ifdef RINDEX
	/* or #include <strings.h> if you have it. */
#	define rindex strrchr
#	define index strchr
#endif /* RINDEX */

/* Turn on the redir command. */
#ifndef REDIR
#	define REDIR 1
#endif

#ifdef GETPASS
#	define getpass2 getpass
#endif

#ifdef _POSIX_SOURCE
#	define TERMIOS
#endif

#include <stdio.h>
#ifndef NO_STDLIBH
#	include <stdlib.h>
#else
extern void *malloc(size_t);
extern void *calloc(size_t, size_t);
extern void *malloc(size_t);
extern void	free(void *);
extern void *realloc(void *, size_t);
extern void	exit(int);

#ifdef CONST
extern char *getenv(char *);
extern int atoi(char *);
#else
extern char *getenv(const char *);
extern int atoi(const char *);
#endif

#endif	/* NO_STDLIBH */

#ifdef NO_UNISTDH
char *getlogin (void);
#ifdef CONST
extern char *getenv(char *);
#else
extern char *getenv(const char *);
#endif
#endif	/* NO_UNISTDH */

/* eof sys.h */
