/* compatR4.h
   Some defines for compatability with X11R4 */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#ifndef COMPATR4_H
#define COMPATR4_H


#include <X11/Intrinsic.h>

#ifndef XtSpecificationRelease
	/* I can't tell what version of X this is.
	   Please confirm that you are using X11R5 or else
	   use #define to define the symbol XGOPHER_X11R4. */
#else

#if XtSpecificationRelease < 5
#define XGOPHER_X11R4
#endif

#if XtSpecificationRelease < 4
	DO NOT COMPILE XGOPHER WITH A VERSION OF X EARLIER THAN X11R4
#endif

#endif

#include <X11/Xaw/Form.h>

#ifdef XGOPHER_X11R4
	/*
		#define XawChainBottom	XtChainBottom
		#define XawChainTop	XtChainTop
		#define XawChainLeft	XtChainLeft
		#define XawChainRight	XtChainRight
		#define XtRubber	XawRubber
	*/

/* for pure R4 or R5 libraries I shouldn't need to be so picky
   in these tests.  But at least one SGI machine had some mixed
   R5 include files in with a mostly X11R4 system.  What a mess. */


#if !defined(XawChainBottom) && !defined(XtChainBottom)
#define XawChainBottom  XtChainBottom
#endif
#if !defined(XawChainTop) && !defined(XtChainTop)
#define XawChainTop     XtChainTop
#endif
#if !defined(XawChainLeft) && !defined(XtChainLeft)
#define XawChainLeft    XtChainLeft
#endif
#if !defined(XawChainRight) && !defined(XtChainRight)
#define XawChainRight   XtChainRight
#endif
#if !defined(XawRubber) && !defined(XtRubber)
#define XtRubber        XawRubber
#endif
#endif /* XGOPHER_X11R4 */

#endif /* COMPATR4_H */
