/* single.c
   make and handle callbacks for inserting a single (out of context)
   gopher item */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>

#include "gopher.h"
#include "item.h"
#include "misc.h"
#include "help.h"
#include "panel.h"
#include "single.h"
#include "compatR4.h"
#include "xglobals.h"
#include "globals.h"
#include "util.h"
#include "gui.h"


static Widget		topLevel, singlePanel;
static Widget		giType, giName, giPath, giHost, giPort;

#define	DEFAULT_NAME	"Specially entered Gopher item"



/* createTextFieldL
   create a labelled single-line text field widget pair */

static Widget
createTextFieldL(name, parent, below)
char	*name;
Widget	parent, below;
{
	char	tempName[50];
	Widget	theForm, theText, theLabel;
	Arg	args[8];
	Cardinal	n;
	Dimension	w, h;

	strcpy(tempName, name);
	strcat(tempName, "Form");
	n = 0;
	if (below != NULL) {
	    XtSetArg(args[n], XtNfromVert, XtParent(below));  n++;
	}
	theForm = XtCreateManagedWidget(tempName, formWidgetClass,
			parent, args, n);

	strcpy(tempName, name);
	strcat(tempName, "Label");
	n = 0;
	XtSetArg(args[n], XtNbottom, XawChainBottom);  n++;
	XtSetArg(args[n], XtNtop, XawChainTop);  n++;
	XtSetArg(args[n], XtNright, XawChainLeft);  n++;
	XtSetArg(args[n], XtNleft, XawChainLeft);  n++;
	theLabel = XtCreateManagedWidget(tempName, labelWidgetClass,
			theForm, args, n);
	getTextSize(theLabel, 10, 1, &w, &h);
	n = 0;
	XtSetArg(args[n], XtNwidth, w);  n++;
	XtSetArg(args[n], XtNheight, h);  n++;
	XtSetValues(theLabel, args, n);
	
	n = 0;
	XtSetArg(args[n], XtNresizable, True);  n++;
	XtSetArg(args[n], XtNeditType, XawtextEdit);  n++;
	XtSetArg(args[n], XtNfromHoriz, theLabel);  n++;
	XtSetArg(args[n], XtNbottom, XawChainBottom);  n++;
	XtSetArg(args[n], XtNtop, XawChainTop);  n++;
	XtSetArg(args[n], XtNright, XawChainRight);  n++;
	XtSetArg(args[n], XtNleft, XawChainLeft);  n++;
	theText = XtCreateManagedWidget(name, asciiTextWidgetClass,
			theForm, args, n);
	setTextWidgetSize(theText, 40, 1);
	XtOverrideTranslations(theText,
			XtParseTranslationTable(OneLineTextTr));  n++;

	return theText;
	
}


/* setText
   set the contents of a text field to a string */

static void
setText(w, value)
Widget	w;
String	value;
{
	Arg		args[2];
	Cardinal	n;

	n = 0;
	XtSetArg(args[n], XtNstring, value);  n++;
	XtSetValues(w, args, n);
}


/* getText
   get the current contents of a text field */

static char *
getText(w)
Widget	w;
{
	Arg		args[2];
	Cardinal	n;
	String		value;

	n = 0;
	XtSetArg(args[n], XtNstring, &value);  n++;
	XtGetValues(w, args, n);

	return value;
}


/* buildSingleItem
   build the gopher item supplied through this panel */

static gopherItemP
buildSingleItem()
{
	char	*type, *name, *path, *host, *value;
	int	port;


	type = getText(giType);

	name = getText(giName);
	if (strcmp(name, "") == 0) {
		name = DEFAULT_NAME;
	}

	path = getText(giPath);

	host = getText(giHost);

	value = getText(giPort);
	if ( 1 != sscanf (value, "%d", &port) ) {
		port = 0;
	}

	return makeItem(*type, name, path, host, port, FALSE);
}


/* processSingleItem
   process the gopher item supplied through this panel */

static void
processSingleItem()
{
	gopherItemP	gi;

	gi = buildSingleItem();

	processSelection(gi);
	checkButtonState(BS_changeSelected | BS_previous);

	freeItem(gi);
}


/* displaySinglePanel
   pop up the single gopher item panel window */

void
displaySinglePanel()
{
	/*
	Arg             args[3];
	Cardinal        n = 0;
	*/

	positionPopup(singlePanel, POS_appPanel,
			topLevel, 0, 10, 0, 0);

	XtPopup(singlePanel, XtGrabNone);

	return;
}


/* endSinglePanel
   pop down the single gopher item panel window */

static void
endSinglePanel()
{
	XtPopdown(singlePanel);

	return;
}


/* doneProc
   done callback for single gopher item panel */

static void
doneProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{

	endSinglePanel();

	processSingleItem();
}


/* cancelProc
   cancel callback for single gopher item panel */

static void
cancelProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	endSinglePanel();
}


/* singleMarkProc
   mark callback for single gopher item panel */

static void
singleMarkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	gopherItemP	gi;

	gi = buildSingleItem();
	markItem(gi);
	unselectAllProc();
	displayBookmarks();
	checkButtonState(BS_unmark | BS_unmarkAll | BS_saveMarks);
}


/* helpProc
   help callback for single gopher item panel. */

static void
helpProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	char	*string;

	showHelp("single help");
}


/* doneActionProc
   implement the done action */

static void
doneActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	doneProc(NULL, NULL, NULL);
}


/* markActionProc
   implement the mark action */

static void
markActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	singleMarkProc(NULL, NULL, NULL);
}


/* cancelActionProc
   implement the cancel action */

static void
cancelActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	cancelProc(NULL, NULL, NULL);
}


/* helpActionProc
   implement the help action */

static void
helpActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	helpProc(NULL, NULL, NULL);
}


/* makeSinglePanel
   create the elements of the single gopher item panel */

void
makeSinglePanel(top)
Widget	top;
{
	Widget		doneButton, helpButton, cancelButton, markButton,
			singleForm, buttonBox;
	Widget		itemsForm, previous;
	Arg		args[10];
	Cardinal	n;

	static XtActionsRec	actionsTable[] = {
				{"giDone",   doneActionProc},
				{"giCancel", cancelActionProc},
				{"giHelp",   helpActionProc},
				};
	/*
	static char		defaultTranslations[] = "Ctrl<Key>d:  done()";
	XtTranslations	transTable;
	*/



	topLevel = top;

	XtAppAddActions(appcon, actionsTable, XtNumber(actionsTable));


	/* create single gopher item panel */

	n = 0;
	XtSetArg(args[n], XtNtitle, "Special Gopher Item");  n++;
	singlePanel = XtCreatePopupShell("singlePanel", transientShellWidgetClass,
					topLevel, args, n);
		/*
		XtAugmentTranslations(singlePanel, transTable);
		*/

	/* create SINGLE ITEM form */

	singleForm = XtCreateManagedWidget("singleForm", formWidgetClass,
					singlePanel, NULL, (Cardinal) 0);


	/* create BUTTON box */

	buttonBox = XtCreateManagedWidget("buttonBox", boxWidgetClass,
					singleForm, NULL, (Cardinal) 0);



	/* create ITEMS form */

	itemsForm = XtCreateManagedWidget("itemsForm", formWidgetClass,
					singleForm, NULL, (Cardinal) 0);


	/* create text fields */

	giType = createTextFieldL("giType", itemsForm, NULL);
	giName = createTextFieldL("giName", itemsForm, giType);
	giPath = createTextFieldL("giPath", itemsForm, giName);
	giHost = createTextFieldL("giHost", itemsForm, giPath);
	giPort = createTextFieldL("giPort", itemsForm, giHost);

	setText(giType, "0");
	setText(giName, "");
	setText(giPath, "");
	setText(giHost, "");
	setText(giPort, "70");
				

	/* create QUIT button */

	doneButton = XtCreateManagedWidget("done", commandWidgetClass,
					buttonBox, NULL, (Cardinal) 0);
		XtAddCallback(doneButton, XtNcallback, doneProc, NULL);

	/* create CANCEL button */

	cancelButton = XtCreateManagedWidget("cancel", commandWidgetClass,
					buttonBox, NULL, (Cardinal) 0);
		XtAddCallback(cancelButton, XtNcallback, cancelProc, NULL);

	/* create MARK button */

	markButton = XtCreateManagedWidget("mark", commandWidgetClass,
					buttonBox, NULL, (Cardinal) 0);
		XtAddCallback(markButton, XtNcallback, singleMarkProc, NULL);

	/* create HELP button */

	helpButton = XtCreateManagedWidget("help", commandWidgetClass,
					buttonBox, NULL, (Cardinal) 0);
		XtAddCallback(helpButton, XtNcallback, helpProc, NULL);


	return;
}
