module PgQuery
  INTERNAL_PROTO_FIELD_NAME_TO_JSON_NAME = {
    [ParseResult, :version] => 'version',
    [ParseResult, :stmts] => 'stmts',
    [ScanResult, :version] => 'version',
    [ScanResult, :tokens] => 'tokens',
    [Node, :alias] => 'Alias',
    [Node, :range_var] => 'RangeVar',
    [Node, :table_func] => 'TableFunc',
    [Node, :expr] => 'Expr',
    [Node, :var] => 'Var',
    [Node, :param] => 'Param',
    [Node, :aggref] => 'Aggref',
    [Node, :grouping_func] => 'GroupingFunc',
    [Node, :window_func] => 'WindowFunc',
    [Node, :subscripting_ref] => 'SubscriptingRef',
    [Node, :func_expr] => 'FuncExpr',
    [Node, :named_arg_expr] => 'NamedArgExpr',
    [Node, :op_expr] => 'OpExpr',
    [Node, :distinct_expr] => 'DistinctExpr',
    [Node, :null_if_expr] => 'NullIfExpr',
    [Node, :scalar_array_op_expr] => 'ScalarArrayOpExpr',
    [Node, :bool_expr] => 'BoolExpr',
    [Node, :sub_link] => 'SubLink',
    [Node, :sub_plan] => 'SubPlan',
    [Node, :alternative_sub_plan] => 'AlternativeSubPlan',
    [Node, :field_select] => 'FieldSelect',
    [Node, :field_store] => 'FieldStore',
    [Node, :relabel_type] => 'RelabelType',
    [Node, :coerce_via_io] => 'CoerceViaIO',
    [Node, :array_coerce_expr] => 'ArrayCoerceExpr',
    [Node, :convert_rowtype_expr] => 'ConvertRowtypeExpr',
    [Node, :collate_expr] => 'CollateExpr',
    [Node, :case_expr] => 'CaseExpr',
    [Node, :case_when] => 'CaseWhen',
    [Node, :case_test_expr] => 'CaseTestExpr',
    [Node, :array_expr] => 'ArrayExpr',
    [Node, :row_expr] => 'RowExpr',
    [Node, :row_compare_expr] => 'RowCompareExpr',
    [Node, :coalesce_expr] => 'CoalesceExpr',
    [Node, :min_max_expr] => 'MinMaxExpr',
    [Node, :sqlvalue_function] => 'SQLValueFunction',
    [Node, :xml_expr] => 'XmlExpr',
    [Node, :null_test] => 'NullTest',
    [Node, :boolean_test] => 'BooleanTest',
    [Node, :coerce_to_domain] => 'CoerceToDomain',
    [Node, :coerce_to_domain_value] => 'CoerceToDomainValue',
    [Node, :set_to_default] => 'SetToDefault',
    [Node, :current_of_expr] => 'CurrentOfExpr',
    [Node, :next_value_expr] => 'NextValueExpr',
    [Node, :inference_elem] => 'InferenceElem',
    [Node, :target_entry] => 'TargetEntry',
    [Node, :range_tbl_ref] => 'RangeTblRef',
    [Node, :join_expr] => 'JoinExpr',
    [Node, :from_expr] => 'FromExpr',
    [Node, :on_conflict_expr] => 'OnConflictExpr',
    [Node, :into_clause] => 'IntoClause',
    [Node, :raw_stmt] => 'RawStmt',
    [Node, :query] => 'Query',
    [Node, :insert_stmt] => 'InsertStmt',
    [Node, :delete_stmt] => 'DeleteStmt',
    [Node, :update_stmt] => 'UpdateStmt',
    [Node, :select_stmt] => 'SelectStmt',
    [Node, :alter_table_stmt] => 'AlterTableStmt',
    [Node, :alter_table_cmd] => 'AlterTableCmd',
    [Node, :alter_domain_stmt] => 'AlterDomainStmt',
    [Node, :set_operation_stmt] => 'SetOperationStmt',
    [Node, :grant_stmt] => 'GrantStmt',
    [Node, :grant_role_stmt] => 'GrantRoleStmt',
    [Node, :alter_default_privileges_stmt] => 'AlterDefaultPrivilegesStmt',
    [Node, :close_portal_stmt] => 'ClosePortalStmt',
    [Node, :cluster_stmt] => 'ClusterStmt',
    [Node, :copy_stmt] => 'CopyStmt',
    [Node, :create_stmt] => 'CreateStmt',
    [Node, :define_stmt] => 'DefineStmt',
    [Node, :drop_stmt] => 'DropStmt',
    [Node, :truncate_stmt] => 'TruncateStmt',
    [Node, :comment_stmt] => 'CommentStmt',
    [Node, :fetch_stmt] => 'FetchStmt',
    [Node, :index_stmt] => 'IndexStmt',
    [Node, :create_function_stmt] => 'CreateFunctionStmt',
    [Node, :alter_function_stmt] => 'AlterFunctionStmt',
    [Node, :do_stmt] => 'DoStmt',
    [Node, :rename_stmt] => 'RenameStmt',
    [Node, :rule_stmt] => 'RuleStmt',
    [Node, :notify_stmt] => 'NotifyStmt',
    [Node, :listen_stmt] => 'ListenStmt',
    [Node, :unlisten_stmt] => 'UnlistenStmt',
    [Node, :transaction_stmt] => 'TransactionStmt',
    [Node, :view_stmt] => 'ViewStmt',
    [Node, :load_stmt] => 'LoadStmt',
    [Node, :create_domain_stmt] => 'CreateDomainStmt',
    [Node, :createdb_stmt] => 'CreatedbStmt',
    [Node, :dropdb_stmt] => 'DropdbStmt',
    [Node, :vacuum_stmt] => 'VacuumStmt',
    [Node, :explain_stmt] => 'ExplainStmt',
    [Node, :create_table_as_stmt] => 'CreateTableAsStmt',
    [Node, :create_seq_stmt] => 'CreateSeqStmt',
    [Node, :alter_seq_stmt] => 'AlterSeqStmt',
    [Node, :variable_set_stmt] => 'VariableSetStmt',
    [Node, :variable_show_stmt] => 'VariableShowStmt',
    [Node, :discard_stmt] => 'DiscardStmt',
    [Node, :create_trig_stmt] => 'CreateTrigStmt',
    [Node, :create_plang_stmt] => 'CreatePLangStmt',
    [Node, :create_role_stmt] => 'CreateRoleStmt',
    [Node, :alter_role_stmt] => 'AlterRoleStmt',
    [Node, :drop_role_stmt] => 'DropRoleStmt',
    [Node, :lock_stmt] => 'LockStmt',
    [Node, :constraints_set_stmt] => 'ConstraintsSetStmt',
    [Node, :reindex_stmt] => 'ReindexStmt',
    [Node, :check_point_stmt] => 'CheckPointStmt',
    [Node, :create_schema_stmt] => 'CreateSchemaStmt',
    [Node, :alter_database_stmt] => 'AlterDatabaseStmt',
    [Node, :alter_database_set_stmt] => 'AlterDatabaseSetStmt',
    [Node, :alter_role_set_stmt] => 'AlterRoleSetStmt',
    [Node, :create_conversion_stmt] => 'CreateConversionStmt',
    [Node, :create_cast_stmt] => 'CreateCastStmt',
    [Node, :create_op_class_stmt] => 'CreateOpClassStmt',
    [Node, :create_op_family_stmt] => 'CreateOpFamilyStmt',
    [Node, :alter_op_family_stmt] => 'AlterOpFamilyStmt',
    [Node, :prepare_stmt] => 'PrepareStmt',
    [Node, :execute_stmt] => 'ExecuteStmt',
    [Node, :deallocate_stmt] => 'DeallocateStmt',
    [Node, :declare_cursor_stmt] => 'DeclareCursorStmt',
    [Node, :create_table_space_stmt] => 'CreateTableSpaceStmt',
    [Node, :drop_table_space_stmt] => 'DropTableSpaceStmt',
    [Node, :alter_object_depends_stmt] => 'AlterObjectDependsStmt',
    [Node, :alter_object_schema_stmt] => 'AlterObjectSchemaStmt',
    [Node, :alter_owner_stmt] => 'AlterOwnerStmt',
    [Node, :alter_operator_stmt] => 'AlterOperatorStmt',
    [Node, :alter_type_stmt] => 'AlterTypeStmt',
    [Node, :drop_owned_stmt] => 'DropOwnedStmt',
    [Node, :reassign_owned_stmt] => 'ReassignOwnedStmt',
    [Node, :composite_type_stmt] => 'CompositeTypeStmt',
    [Node, :create_enum_stmt] => 'CreateEnumStmt',
    [Node, :create_range_stmt] => 'CreateRangeStmt',
    [Node, :alter_enum_stmt] => 'AlterEnumStmt',
    [Node, :alter_tsdictionary_stmt] => 'AlterTSDictionaryStmt',
    [Node, :alter_tsconfiguration_stmt] => 'AlterTSConfigurationStmt',
    [Node, :create_fdw_stmt] => 'CreateFdwStmt',
    [Node, :alter_fdw_stmt] => 'AlterFdwStmt',
    [Node, :create_foreign_server_stmt] => 'CreateForeignServerStmt',
    [Node, :alter_foreign_server_stmt] => 'AlterForeignServerStmt',
    [Node, :create_user_mapping_stmt] => 'CreateUserMappingStmt',
    [Node, :alter_user_mapping_stmt] => 'AlterUserMappingStmt',
    [Node, :drop_user_mapping_stmt] => 'DropUserMappingStmt',
    [Node, :alter_table_space_options_stmt] => 'AlterTableSpaceOptionsStmt',
    [Node, :alter_table_move_all_stmt] => 'AlterTableMoveAllStmt',
    [Node, :sec_label_stmt] => 'SecLabelStmt',
    [Node, :create_foreign_table_stmt] => 'CreateForeignTableStmt',
    [Node, :import_foreign_schema_stmt] => 'ImportForeignSchemaStmt',
    [Node, :create_extension_stmt] => 'CreateExtensionStmt',
    [Node, :alter_extension_stmt] => 'AlterExtensionStmt',
    [Node, :alter_extension_contents_stmt] => 'AlterExtensionContentsStmt',
    [Node, :create_event_trig_stmt] => 'CreateEventTrigStmt',
    [Node, :alter_event_trig_stmt] => 'AlterEventTrigStmt',
    [Node, :refresh_mat_view_stmt] => 'RefreshMatViewStmt',
    [Node, :replica_identity_stmt] => 'ReplicaIdentityStmt',
    [Node, :alter_system_stmt] => 'AlterSystemStmt',
    [Node, :create_policy_stmt] => 'CreatePolicyStmt',
    [Node, :alter_policy_stmt] => 'AlterPolicyStmt',
    [Node, :create_transform_stmt] => 'CreateTransformStmt',
    [Node, :create_am_stmt] => 'CreateAmStmt',
    [Node, :create_publication_stmt] => 'CreatePublicationStmt',
    [Node, :alter_publication_stmt] => 'AlterPublicationStmt',
    [Node, :create_subscription_stmt] => 'CreateSubscriptionStmt',
    [Node, :alter_subscription_stmt] => 'AlterSubscriptionStmt',
    [Node, :drop_subscription_stmt] => 'DropSubscriptionStmt',
    [Node, :create_stats_stmt] => 'CreateStatsStmt',
    [Node, :alter_collation_stmt] => 'AlterCollationStmt',
    [Node, :call_stmt] => 'CallStmt',
    [Node, :alter_stats_stmt] => 'AlterStatsStmt',
    [Node, :a_expr] => 'A_Expr',
    [Node, :column_ref] => 'ColumnRef',
    [Node, :param_ref] => 'ParamRef',
    [Node, :a_const] => 'A_Const',
    [Node, :func_call] => 'FuncCall',
    [Node, :a_star] => 'A_Star',
    [Node, :a_indices] => 'A_Indices',
    [Node, :a_indirection] => 'A_Indirection',
    [Node, :a_array_expr] => 'A_ArrayExpr',
    [Node, :res_target] => 'ResTarget',
    [Node, :multi_assign_ref] => 'MultiAssignRef',
    [Node, :type_cast] => 'TypeCast',
    [Node, :collate_clause] => 'CollateClause',
    [Node, :sort_by] => 'SortBy',
    [Node, :window_def] => 'WindowDef',
    [Node, :range_subselect] => 'RangeSubselect',
    [Node, :range_function] => 'RangeFunction',
    [Node, :range_table_sample] => 'RangeTableSample',
    [Node, :range_table_func] => 'RangeTableFunc',
    [Node, :range_table_func_col] => 'RangeTableFuncCol',
    [Node, :type_name] => 'TypeName',
    [Node, :column_def] => 'ColumnDef',
    [Node, :index_elem] => 'IndexElem',
    [Node, :constraint] => 'Constraint',
    [Node, :def_elem] => 'DefElem',
    [Node, :range_tbl_entry] => 'RangeTblEntry',
    [Node, :range_tbl_function] => 'RangeTblFunction',
    [Node, :table_sample_clause] => 'TableSampleClause',
    [Node, :with_check_option] => 'WithCheckOption',
    [Node, :sort_group_clause] => 'SortGroupClause',
    [Node, :grouping_set] => 'GroupingSet',
    [Node, :window_clause] => 'WindowClause',
    [Node, :object_with_args] => 'ObjectWithArgs',
    [Node, :access_priv] => 'AccessPriv',
    [Node, :create_op_class_item] => 'CreateOpClassItem',
    [Node, :table_like_clause] => 'TableLikeClause',
    [Node, :function_parameter] => 'FunctionParameter',
    [Node, :locking_clause] => 'LockingClause',
    [Node, :row_mark_clause] => 'RowMarkClause',
    [Node, :xml_serialize] => 'XmlSerialize',
    [Node, :with_clause] => 'WithClause',
    [Node, :infer_clause] => 'InferClause',
    [Node, :on_conflict_clause] => 'OnConflictClause',
    [Node, :common_table_expr] => 'CommonTableExpr',
    [Node, :role_spec] => 'RoleSpec',
    [Node, :trigger_transition] => 'TriggerTransition',
    [Node, :partition_elem] => 'PartitionElem',
    [Node, :partition_spec] => 'PartitionSpec',
    [Node, :partition_bound_spec] => 'PartitionBoundSpec',
    [Node, :partition_range_datum] => 'PartitionRangeDatum',
    [Node, :partition_cmd] => 'PartitionCmd',
    [Node, :vacuum_relation] => 'VacuumRelation',
    [Node, :inline_code_block] => 'InlineCodeBlock',
    [Node, :call_context] => 'CallContext',
    [Node, :integer] => 'Integer',
    [Node, :float] => 'Float',
    [Node, :string] => 'String',
    [Node, :bit_string] => 'BitString',
    [Node, :null] => 'Null',
    [Node, :list] => 'List',
    [Node, :int_list] => 'IntList',
    [Node, :oid_list] => 'OidList',
    [Integer, :ival] => 'ival',
    [Float, :str] => 'str',
    [String, :str] => 'str',
    [BitString, :str] => 'str',
    [List, :items] => 'items',
    [OidList, :items] => 'items',
    [IntList, :items] => 'items',
    [Alias, :aliasname] => 'aliasname',
    [Alias, :colnames] => 'colnames',
    [RangeVar, :catalogname] => 'catalogname',
    [RangeVar, :schemaname] => 'schemaname',
    [RangeVar, :relname] => 'relname',
    [RangeVar, :inh] => 'inh',
    [RangeVar, :relpersistence] => 'relpersistence',
    [RangeVar, :alias] => 'alias',
    [RangeVar, :location] => 'location',
    [TableFunc, :ns_uris] => 'ns_uris',
    [TableFunc, :ns_names] => 'ns_names',
    [TableFunc, :docexpr] => 'docexpr',
    [TableFunc, :rowexpr] => 'rowexpr',
    [TableFunc, :colnames] => 'colnames',
    [TableFunc, :coltypes] => 'coltypes',
    [TableFunc, :coltypmods] => 'coltypmods',
    [TableFunc, :colcollations] => 'colcollations',
    [TableFunc, :colexprs] => 'colexprs',
    [TableFunc, :coldefexprs] => 'coldefexprs',
    [TableFunc, :notnulls] => 'notnulls',
    [TableFunc, :ordinalitycol] => 'ordinalitycol',
    [TableFunc, :location] => 'location',
    [Var, :xpr] => 'xpr',
    [Var, :varno] => 'varno',
    [Var, :varattno] => 'varattno',
    [Var, :vartype] => 'vartype',
    [Var, :vartypmod] => 'vartypmod',
    [Var, :varcollid] => 'varcollid',
    [Var, :varlevelsup] => 'varlevelsup',
    [Var, :varnosyn] => 'varnosyn',
    [Var, :varattnosyn] => 'varattnosyn',
    [Var, :location] => 'location',
    [Param, :xpr] => 'xpr',
    [Param, :paramkind] => 'paramkind',
    [Param, :paramid] => 'paramid',
    [Param, :paramtype] => 'paramtype',
    [Param, :paramtypmod] => 'paramtypmod',
    [Param, :paramcollid] => 'paramcollid',
    [Param, :location] => 'location',
    [Aggref, :xpr] => 'xpr',
    [Aggref, :aggfnoid] => 'aggfnoid',
    [Aggref, :aggtype] => 'aggtype',
    [Aggref, :aggcollid] => 'aggcollid',
    [Aggref, :inputcollid] => 'inputcollid',
    [Aggref, :aggtranstype] => 'aggtranstype',
    [Aggref, :aggargtypes] => 'aggargtypes',
    [Aggref, :aggdirectargs] => 'aggdirectargs',
    [Aggref, :args] => 'args',
    [Aggref, :aggorder] => 'aggorder',
    [Aggref, :aggdistinct] => 'aggdistinct',
    [Aggref, :aggfilter] => 'aggfilter',
    [Aggref, :aggstar] => 'aggstar',
    [Aggref, :aggvariadic] => 'aggvariadic',
    [Aggref, :aggkind] => 'aggkind',
    [Aggref, :agglevelsup] => 'agglevelsup',
    [Aggref, :aggsplit] => 'aggsplit',
    [Aggref, :location] => 'location',
    [GroupingFunc, :xpr] => 'xpr',
    [GroupingFunc, :args] => 'args',
    [GroupingFunc, :refs] => 'refs',
    [GroupingFunc, :cols] => 'cols',
    [GroupingFunc, :agglevelsup] => 'agglevelsup',
    [GroupingFunc, :location] => 'location',
    [WindowFunc, :xpr] => 'xpr',
    [WindowFunc, :winfnoid] => 'winfnoid',
    [WindowFunc, :wintype] => 'wintype',
    [WindowFunc, :wincollid] => 'wincollid',
    [WindowFunc, :inputcollid] => 'inputcollid',
    [WindowFunc, :args] => 'args',
    [WindowFunc, :aggfilter] => 'aggfilter',
    [WindowFunc, :winref] => 'winref',
    [WindowFunc, :winstar] => 'winstar',
    [WindowFunc, :winagg] => 'winagg',
    [WindowFunc, :location] => 'location',
    [SubscriptingRef, :xpr] => 'xpr',
    [SubscriptingRef, :refcontainertype] => 'refcontainertype',
    [SubscriptingRef, :refelemtype] => 'refelemtype',
    [SubscriptingRef, :reftypmod] => 'reftypmod',
    [SubscriptingRef, :refcollid] => 'refcollid',
    [SubscriptingRef, :refupperindexpr] => 'refupperindexpr',
    [SubscriptingRef, :reflowerindexpr] => 'reflowerindexpr',
    [SubscriptingRef, :refexpr] => 'refexpr',
    [SubscriptingRef, :refassgnexpr] => 'refassgnexpr',
    [FuncExpr, :xpr] => 'xpr',
    [FuncExpr, :funcid] => 'funcid',
    [FuncExpr, :funcresulttype] => 'funcresulttype',
    [FuncExpr, :funcretset] => 'funcretset',
    [FuncExpr, :funcvariadic] => 'funcvariadic',
    [FuncExpr, :funcformat] => 'funcformat',
    [FuncExpr, :funccollid] => 'funccollid',
    [FuncExpr, :inputcollid] => 'inputcollid',
    [FuncExpr, :args] => 'args',
    [FuncExpr, :location] => 'location',
    [NamedArgExpr, :xpr] => 'xpr',
    [NamedArgExpr, :arg] => 'arg',
    [NamedArgExpr, :name] => 'name',
    [NamedArgExpr, :argnumber] => 'argnumber',
    [NamedArgExpr, :location] => 'location',
    [OpExpr, :xpr] => 'xpr',
    [OpExpr, :opno] => 'opno',
    [OpExpr, :opfuncid] => 'opfuncid',
    [OpExpr, :opresulttype] => 'opresulttype',
    [OpExpr, :opretset] => 'opretset',
    [OpExpr, :opcollid] => 'opcollid',
    [OpExpr, :inputcollid] => 'inputcollid',
    [OpExpr, :args] => 'args',
    [OpExpr, :location] => 'location',
    [DistinctExpr, :xpr] => 'xpr',
    [DistinctExpr, :opno] => 'opno',
    [DistinctExpr, :opfuncid] => 'opfuncid',
    [DistinctExpr, :opresulttype] => 'opresulttype',
    [DistinctExpr, :opretset] => 'opretset',
    [DistinctExpr, :opcollid] => 'opcollid',
    [DistinctExpr, :inputcollid] => 'inputcollid',
    [DistinctExpr, :args] => 'args',
    [DistinctExpr, :location] => 'location',
    [NullIfExpr, :xpr] => 'xpr',
    [NullIfExpr, :opno] => 'opno',
    [NullIfExpr, :opfuncid] => 'opfuncid',
    [NullIfExpr, :opresulttype] => 'opresulttype',
    [NullIfExpr, :opretset] => 'opretset',
    [NullIfExpr, :opcollid] => 'opcollid',
    [NullIfExpr, :inputcollid] => 'inputcollid',
    [NullIfExpr, :args] => 'args',
    [NullIfExpr, :location] => 'location',
    [ScalarArrayOpExpr, :xpr] => 'xpr',
    [ScalarArrayOpExpr, :opno] => 'opno',
    [ScalarArrayOpExpr, :opfuncid] => 'opfuncid',
    [ScalarArrayOpExpr, :use_or] => 'useOr',
    [ScalarArrayOpExpr, :inputcollid] => 'inputcollid',
    [ScalarArrayOpExpr, :args] => 'args',
    [ScalarArrayOpExpr, :location] => 'location',
    [BoolExpr, :xpr] => 'xpr',
    [BoolExpr, :boolop] => 'boolop',
    [BoolExpr, :args] => 'args',
    [BoolExpr, :location] => 'location',
    [SubLink, :xpr] => 'xpr',
    [SubLink, :sub_link_type] => 'subLinkType',
    [SubLink, :sub_link_id] => 'subLinkId',
    [SubLink, :testexpr] => 'testexpr',
    [SubLink, :oper_name] => 'operName',
    [SubLink, :subselect] => 'subselect',
    [SubLink, :location] => 'location',
    [SubPlan, :xpr] => 'xpr',
    [SubPlan, :sub_link_type] => 'subLinkType',
    [SubPlan, :testexpr] => 'testexpr',
    [SubPlan, :param_ids] => 'paramIds',
    [SubPlan, :plan_id] => 'plan_id',
    [SubPlan, :plan_name] => 'plan_name',
    [SubPlan, :first_col_type] => 'firstColType',
    [SubPlan, :first_col_typmod] => 'firstColTypmod',
    [SubPlan, :first_col_collation] => 'firstColCollation',
    [SubPlan, :use_hash_table] => 'useHashTable',
    [SubPlan, :unknown_eq_false] => 'unknownEqFalse',
    [SubPlan, :parallel_safe] => 'parallel_safe',
    [SubPlan, :set_param] => 'setParam',
    [SubPlan, :par_param] => 'parParam',
    [SubPlan, :args] => 'args',
    [SubPlan, :startup_cost] => 'startup_cost',
    [SubPlan, :per_call_cost] => 'per_call_cost',
    [AlternativeSubPlan, :xpr] => 'xpr',
    [AlternativeSubPlan, :subplans] => 'subplans',
    [FieldSelect, :xpr] => 'xpr',
    [FieldSelect, :arg] => 'arg',
    [FieldSelect, :fieldnum] => 'fieldnum',
    [FieldSelect, :resulttype] => 'resulttype',
    [FieldSelect, :resulttypmod] => 'resulttypmod',
    [FieldSelect, :resultcollid] => 'resultcollid',
    [FieldStore, :xpr] => 'xpr',
    [FieldStore, :arg] => 'arg',
    [FieldStore, :newvals] => 'newvals',
    [FieldStore, :fieldnums] => 'fieldnums',
    [FieldStore, :resulttype] => 'resulttype',
    [RelabelType, :xpr] => 'xpr',
    [RelabelType, :arg] => 'arg',
    [RelabelType, :resulttype] => 'resulttype',
    [RelabelType, :resulttypmod] => 'resulttypmod',
    [RelabelType, :resultcollid] => 'resultcollid',
    [RelabelType, :relabelformat] => 'relabelformat',
    [RelabelType, :location] => 'location',
    [CoerceViaIO, :xpr] => 'xpr',
    [CoerceViaIO, :arg] => 'arg',
    [CoerceViaIO, :resulttype] => 'resulttype',
    [CoerceViaIO, :resultcollid] => 'resultcollid',
    [CoerceViaIO, :coerceformat] => 'coerceformat',
    [CoerceViaIO, :location] => 'location',
    [ArrayCoerceExpr, :xpr] => 'xpr',
    [ArrayCoerceExpr, :arg] => 'arg',
    [ArrayCoerceExpr, :elemexpr] => 'elemexpr',
    [ArrayCoerceExpr, :resulttype] => 'resulttype',
    [ArrayCoerceExpr, :resulttypmod] => 'resulttypmod',
    [ArrayCoerceExpr, :resultcollid] => 'resultcollid',
    [ArrayCoerceExpr, :coerceformat] => 'coerceformat',
    [ArrayCoerceExpr, :location] => 'location',
    [ConvertRowtypeExpr, :xpr] => 'xpr',
    [ConvertRowtypeExpr, :arg] => 'arg',
    [ConvertRowtypeExpr, :resulttype] => 'resulttype',
    [ConvertRowtypeExpr, :convertformat] => 'convertformat',
    [ConvertRowtypeExpr, :location] => 'location',
    [CollateExpr, :xpr] => 'xpr',
    [CollateExpr, :arg] => 'arg',
    [CollateExpr, :coll_oid] => 'collOid',
    [CollateExpr, :location] => 'location',
    [CaseExpr, :xpr] => 'xpr',
    [CaseExpr, :casetype] => 'casetype',
    [CaseExpr, :casecollid] => 'casecollid',
    [CaseExpr, :arg] => 'arg',
    [CaseExpr, :args] => 'args',
    [CaseExpr, :defresult] => 'defresult',
    [CaseExpr, :location] => 'location',
    [CaseWhen, :xpr] => 'xpr',
    [CaseWhen, :expr] => 'expr',
    [CaseWhen, :result] => 'result',
    [CaseWhen, :location] => 'location',
    [CaseTestExpr, :xpr] => 'xpr',
    [CaseTestExpr, :type_id] => 'typeId',
    [CaseTestExpr, :type_mod] => 'typeMod',
    [CaseTestExpr, :collation] => 'collation',
    [ArrayExpr, :xpr] => 'xpr',
    [ArrayExpr, :array_typeid] => 'array_typeid',
    [ArrayExpr, :array_collid] => 'array_collid',
    [ArrayExpr, :element_typeid] => 'element_typeid',
    [ArrayExpr, :elements] => 'elements',
    [ArrayExpr, :multidims] => 'multidims',
    [ArrayExpr, :location] => 'location',
    [RowExpr, :xpr] => 'xpr',
    [RowExpr, :args] => 'args',
    [RowExpr, :row_typeid] => 'row_typeid',
    [RowExpr, :row_format] => 'row_format',
    [RowExpr, :colnames] => 'colnames',
    [RowExpr, :location] => 'location',
    [RowCompareExpr, :xpr] => 'xpr',
    [RowCompareExpr, :rctype] => 'rctype',
    [RowCompareExpr, :opnos] => 'opnos',
    [RowCompareExpr, :opfamilies] => 'opfamilies',
    [RowCompareExpr, :inputcollids] => 'inputcollids',
    [RowCompareExpr, :largs] => 'largs',
    [RowCompareExpr, :rargs] => 'rargs',
    [CoalesceExpr, :xpr] => 'xpr',
    [CoalesceExpr, :coalescetype] => 'coalescetype',
    [CoalesceExpr, :coalescecollid] => 'coalescecollid',
    [CoalesceExpr, :args] => 'args',
    [CoalesceExpr, :location] => 'location',
    [MinMaxExpr, :xpr] => 'xpr',
    [MinMaxExpr, :minmaxtype] => 'minmaxtype',
    [MinMaxExpr, :minmaxcollid] => 'minmaxcollid',
    [MinMaxExpr, :inputcollid] => 'inputcollid',
    [MinMaxExpr, :op] => 'op',
    [MinMaxExpr, :args] => 'args',
    [MinMaxExpr, :location] => 'location',
    [SQLValueFunction, :xpr] => 'xpr',
    [SQLValueFunction, :op] => 'op',
    [SQLValueFunction, :type] => 'type',
    [SQLValueFunction, :typmod] => 'typmod',
    [SQLValueFunction, :location] => 'location',
    [XmlExpr, :xpr] => 'xpr',
    [XmlExpr, :op] => 'op',
    [XmlExpr, :name] => 'name',
    [XmlExpr, :named_args] => 'named_args',
    [XmlExpr, :arg_names] => 'arg_names',
    [XmlExpr, :args] => 'args',
    [XmlExpr, :xmloption] => 'xmloption',
    [XmlExpr, :type] => 'type',
    [XmlExpr, :typmod] => 'typmod',
    [XmlExpr, :location] => 'location',
    [NullTest, :xpr] => 'xpr',
    [NullTest, :arg] => 'arg',
    [NullTest, :nulltesttype] => 'nulltesttype',
    [NullTest, :argisrow] => 'argisrow',
    [NullTest, :location] => 'location',
    [BooleanTest, :xpr] => 'xpr',
    [BooleanTest, :arg] => 'arg',
    [BooleanTest, :booltesttype] => 'booltesttype',
    [BooleanTest, :location] => 'location',
    [CoerceToDomain, :xpr] => 'xpr',
    [CoerceToDomain, :arg] => 'arg',
    [CoerceToDomain, :resulttype] => 'resulttype',
    [CoerceToDomain, :resulttypmod] => 'resulttypmod',
    [CoerceToDomain, :resultcollid] => 'resultcollid',
    [CoerceToDomain, :coercionformat] => 'coercionformat',
    [CoerceToDomain, :location] => 'location',
    [CoerceToDomainValue, :xpr] => 'xpr',
    [CoerceToDomainValue, :type_id] => 'typeId',
    [CoerceToDomainValue, :type_mod] => 'typeMod',
    [CoerceToDomainValue, :collation] => 'collation',
    [CoerceToDomainValue, :location] => 'location',
    [SetToDefault, :xpr] => 'xpr',
    [SetToDefault, :type_id] => 'typeId',
    [SetToDefault, :type_mod] => 'typeMod',
    [SetToDefault, :collation] => 'collation',
    [SetToDefault, :location] => 'location',
    [CurrentOfExpr, :xpr] => 'xpr',
    [CurrentOfExpr, :cvarno] => 'cvarno',
    [CurrentOfExpr, :cursor_name] => 'cursor_name',
    [CurrentOfExpr, :cursor_param] => 'cursor_param',
    [NextValueExpr, :xpr] => 'xpr',
    [NextValueExpr, :seqid] => 'seqid',
    [NextValueExpr, :type_id] => 'typeId',
    [InferenceElem, :xpr] => 'xpr',
    [InferenceElem, :expr] => 'expr',
    [InferenceElem, :infercollid] => 'infercollid',
    [InferenceElem, :inferopclass] => 'inferopclass',
    [TargetEntry, :xpr] => 'xpr',
    [TargetEntry, :expr] => 'expr',
    [TargetEntry, :resno] => 'resno',
    [TargetEntry, :resname] => 'resname',
    [TargetEntry, :ressortgroupref] => 'ressortgroupref',
    [TargetEntry, :resorigtbl] => 'resorigtbl',
    [TargetEntry, :resorigcol] => 'resorigcol',
    [TargetEntry, :resjunk] => 'resjunk',
    [RangeTblRef, :rtindex] => 'rtindex',
    [JoinExpr, :jointype] => 'jointype',
    [JoinExpr, :is_natural] => 'isNatural',
    [JoinExpr, :larg] => 'larg',
    [JoinExpr, :rarg] => 'rarg',
    [JoinExpr, :using_clause] => 'usingClause',
    [JoinExpr, :quals] => 'quals',
    [JoinExpr, :alias] => 'alias',
    [JoinExpr, :rtindex] => 'rtindex',
    [FromExpr, :fromlist] => 'fromlist',
    [FromExpr, :quals] => 'quals',
    [OnConflictExpr, :action] => 'action',
    [OnConflictExpr, :arbiter_elems] => 'arbiterElems',
    [OnConflictExpr, :arbiter_where] => 'arbiterWhere',
    [OnConflictExpr, :constraint] => 'constraint',
    [OnConflictExpr, :on_conflict_set] => 'onConflictSet',
    [OnConflictExpr, :on_conflict_where] => 'onConflictWhere',
    [OnConflictExpr, :excl_rel_index] => 'exclRelIndex',
    [OnConflictExpr, :excl_rel_tlist] => 'exclRelTlist',
    [IntoClause, :rel] => 'rel',
    [IntoClause, :col_names] => 'colNames',
    [IntoClause, :access_method] => 'accessMethod',
    [IntoClause, :options] => 'options',
    [IntoClause, :on_commit] => 'onCommit',
    [IntoClause, :table_space_name] => 'tableSpaceName',
    [IntoClause, :view_query] => 'viewQuery',
    [IntoClause, :skip_data] => 'skipData',
    [RawStmt, :stmt] => 'stmt',
    [RawStmt, :stmt_location] => 'stmt_location',
    [RawStmt, :stmt_len] => 'stmt_len',
    [Query, :command_type] => 'commandType',
    [Query, :query_source] => 'querySource',
    [Query, :can_set_tag] => 'canSetTag',
    [Query, :utility_stmt] => 'utilityStmt',
    [Query, :result_relation] => 'resultRelation',
    [Query, :has_aggs] => 'hasAggs',
    [Query, :has_window_funcs] => 'hasWindowFuncs',
    [Query, :has_target_srfs] => 'hasTargetSRFs',
    [Query, :has_sub_links] => 'hasSubLinks',
    [Query, :has_distinct_on] => 'hasDistinctOn',
    [Query, :has_recursive] => 'hasRecursive',
    [Query, :has_modifying_cte] => 'hasModifyingCTE',
    [Query, :has_for_update] => 'hasForUpdate',
    [Query, :has_row_security] => 'hasRowSecurity',
    [Query, :cte_list] => 'cteList',
    [Query, :rtable] => 'rtable',
    [Query, :jointree] => 'jointree',
    [Query, :target_list] => 'targetList',
    [Query, :override] => 'override',
    [Query, :on_conflict] => 'onConflict',
    [Query, :returning_list] => 'returningList',
    [Query, :group_clause] => 'groupClause',
    [Query, :grouping_sets] => 'groupingSets',
    [Query, :having_qual] => 'havingQual',
    [Query, :window_clause] => 'windowClause',
    [Query, :distinct_clause] => 'distinctClause',
    [Query, :sort_clause] => 'sortClause',
    [Query, :limit_offset] => 'limitOffset',
    [Query, :limit_count] => 'limitCount',
    [Query, :limit_option] => 'limitOption',
    [Query, :row_marks] => 'rowMarks',
    [Query, :set_operations] => 'setOperations',
    [Query, :constraint_deps] => 'constraintDeps',
    [Query, :with_check_options] => 'withCheckOptions',
    [Query, :stmt_location] => 'stmt_location',
    [Query, :stmt_len] => 'stmt_len',
    [InsertStmt, :relation] => 'relation',
    [InsertStmt, :cols] => 'cols',
    [InsertStmt, :select_stmt] => 'selectStmt',
    [InsertStmt, :on_conflict_clause] => 'onConflictClause',
    [InsertStmt, :returning_list] => 'returningList',
    [InsertStmt, :with_clause] => 'withClause',
    [InsertStmt, :override] => 'override',
    [DeleteStmt, :relation] => 'relation',
    [DeleteStmt, :using_clause] => 'usingClause',
    [DeleteStmt, :where_clause] => 'whereClause',
    [DeleteStmt, :returning_list] => 'returningList',
    [DeleteStmt, :with_clause] => 'withClause',
    [UpdateStmt, :relation] => 'relation',
    [UpdateStmt, :target_list] => 'targetList',
    [UpdateStmt, :where_clause] => 'whereClause',
    [UpdateStmt, :from_clause] => 'fromClause',
    [UpdateStmt, :returning_list] => 'returningList',
    [UpdateStmt, :with_clause] => 'withClause',
    [SelectStmt, :distinct_clause] => 'distinctClause',
    [SelectStmt, :into_clause] => 'intoClause',
    [SelectStmt, :target_list] => 'targetList',
    [SelectStmt, :from_clause] => 'fromClause',
    [SelectStmt, :where_clause] => 'whereClause',
    [SelectStmt, :group_clause] => 'groupClause',
    [SelectStmt, :having_clause] => 'havingClause',
    [SelectStmt, :window_clause] => 'windowClause',
    [SelectStmt, :values_lists] => 'valuesLists',
    [SelectStmt, :sort_clause] => 'sortClause',
    [SelectStmt, :limit_offset] => 'limitOffset',
    [SelectStmt, :limit_count] => 'limitCount',
    [SelectStmt, :limit_option] => 'limitOption',
    [SelectStmt, :locking_clause] => 'lockingClause',
    [SelectStmt, :with_clause] => 'withClause',
    [SelectStmt, :op] => 'op',
    [SelectStmt, :all] => 'all',
    [SelectStmt, :larg] => 'larg',
    [SelectStmt, :rarg] => 'rarg',
    [AlterTableStmt, :relation] => 'relation',
    [AlterTableStmt, :cmds] => 'cmds',
    [AlterTableStmt, :relkind] => 'relkind',
    [AlterTableStmt, :missing_ok] => 'missing_ok',
    [AlterTableCmd, :subtype] => 'subtype',
    [AlterTableCmd, :name] => 'name',
    [AlterTableCmd, :num] => 'num',
    [AlterTableCmd, :newowner] => 'newowner',
    [AlterTableCmd, :def] => 'def',
    [AlterTableCmd, :behavior] => 'behavior',
    [AlterTableCmd, :missing_ok] => 'missing_ok',
    [AlterDomainStmt, :subtype] => 'subtype',
    [AlterDomainStmt, :type_name] => 'typeName',
    [AlterDomainStmt, :name] => 'name',
    [AlterDomainStmt, :def] => 'def',
    [AlterDomainStmt, :behavior] => 'behavior',
    [AlterDomainStmt, :missing_ok] => 'missing_ok',
    [SetOperationStmt, :op] => 'op',
    [SetOperationStmt, :all] => 'all',
    [SetOperationStmt, :larg] => 'larg',
    [SetOperationStmt, :rarg] => 'rarg',
    [SetOperationStmt, :col_types] => 'colTypes',
    [SetOperationStmt, :col_typmods] => 'colTypmods',
    [SetOperationStmt, :col_collations] => 'colCollations',
    [SetOperationStmt, :group_clauses] => 'groupClauses',
    [GrantStmt, :is_grant] => 'is_grant',
    [GrantStmt, :targtype] => 'targtype',
    [GrantStmt, :objtype] => 'objtype',
    [GrantStmt, :objects] => 'objects',
    [GrantStmt, :privileges] => 'privileges',
    [GrantStmt, :grantees] => 'grantees',
    [GrantStmt, :grant_option] => 'grant_option',
    [GrantStmt, :behavior] => 'behavior',
    [GrantRoleStmt, :granted_roles] => 'granted_roles',
    [GrantRoleStmt, :grantee_roles] => 'grantee_roles',
    [GrantRoleStmt, :is_grant] => 'is_grant',
    [GrantRoleStmt, :admin_opt] => 'admin_opt',
    [GrantRoleStmt, :grantor] => 'grantor',
    [GrantRoleStmt, :behavior] => 'behavior',
    [AlterDefaultPrivilegesStmt, :options] => 'options',
    [AlterDefaultPrivilegesStmt, :action] => 'action',
    [ClosePortalStmt, :portalname] => 'portalname',
    [ClusterStmt, :relation] => 'relation',
    [ClusterStmt, :indexname] => 'indexname',
    [ClusterStmt, :options] => 'options',
    [CopyStmt, :relation] => 'relation',
    [CopyStmt, :query] => 'query',
    [CopyStmt, :attlist] => 'attlist',
    [CopyStmt, :is_from] => 'is_from',
    [CopyStmt, :is_program] => 'is_program',
    [CopyStmt, :filename] => 'filename',
    [CopyStmt, :options] => 'options',
    [CopyStmt, :where_clause] => 'whereClause',
    [CreateStmt, :relation] => 'relation',
    [CreateStmt, :table_elts] => 'tableElts',
    [CreateStmt, :inh_relations] => 'inhRelations',
    [CreateStmt, :partbound] => 'partbound',
    [CreateStmt, :partspec] => 'partspec',
    [CreateStmt, :of_typename] => 'ofTypename',
    [CreateStmt, :constraints] => 'constraints',
    [CreateStmt, :options] => 'options',
    [CreateStmt, :oncommit] => 'oncommit',
    [CreateStmt, :tablespacename] => 'tablespacename',
    [CreateStmt, :access_method] => 'accessMethod',
    [CreateStmt, :if_not_exists] => 'if_not_exists',
    [DefineStmt, :kind] => 'kind',
    [DefineStmt, :oldstyle] => 'oldstyle',
    [DefineStmt, :defnames] => 'defnames',
    [DefineStmt, :args] => 'args',
    [DefineStmt, :definition] => 'definition',
    [DefineStmt, :if_not_exists] => 'if_not_exists',
    [DefineStmt, :replace] => 'replace',
    [DropStmt, :objects] => 'objects',
    [DropStmt, :remove_type] => 'removeType',
    [DropStmt, :behavior] => 'behavior',
    [DropStmt, :missing_ok] => 'missing_ok',
    [DropStmt, :concurrent] => 'concurrent',
    [TruncateStmt, :relations] => 'relations',
    [TruncateStmt, :restart_seqs] => 'restart_seqs',
    [TruncateStmt, :behavior] => 'behavior',
    [CommentStmt, :objtype] => 'objtype',
    [CommentStmt, :object] => 'object',
    [CommentStmt, :comment] => 'comment',
    [FetchStmt, :direction] => 'direction',
    [FetchStmt, :how_many] => 'howMany',
    [FetchStmt, :portalname] => 'portalname',
    [FetchStmt, :ismove] => 'ismove',
    [IndexStmt, :idxname] => 'idxname',
    [IndexStmt, :relation] => 'relation',
    [IndexStmt, :access_method] => 'accessMethod',
    [IndexStmt, :table_space] => 'tableSpace',
    [IndexStmt, :index_params] => 'indexParams',
    [IndexStmt, :index_including_params] => 'indexIncludingParams',
    [IndexStmt, :options] => 'options',
    [IndexStmt, :where_clause] => 'whereClause',
    [IndexStmt, :exclude_op_names] => 'excludeOpNames',
    [IndexStmt, :idxcomment] => 'idxcomment',
    [IndexStmt, :index_oid] => 'indexOid',
    [IndexStmt, :old_node] => 'oldNode',
    [IndexStmt, :old_create_subid] => 'oldCreateSubid',
    [IndexStmt, :old_first_relfilenode_subid] => 'oldFirstRelfilenodeSubid',
    [IndexStmt, :unique] => 'unique',
    [IndexStmt, :primary] => 'primary',
    [IndexStmt, :isconstraint] => 'isconstraint',
    [IndexStmt, :deferrable] => 'deferrable',
    [IndexStmt, :initdeferred] => 'initdeferred',
    [IndexStmt, :transformed] => 'transformed',
    [IndexStmt, :concurrent] => 'concurrent',
    [IndexStmt, :if_not_exists] => 'if_not_exists',
    [IndexStmt, :reset_default_tblspc] => 'reset_default_tblspc',
    [CreateFunctionStmt, :is_procedure] => 'is_procedure',
    [CreateFunctionStmt, :replace] => 'replace',
    [CreateFunctionStmt, :funcname] => 'funcname',
    [CreateFunctionStmt, :parameters] => 'parameters',
    [CreateFunctionStmt, :return_type] => 'returnType',
    [CreateFunctionStmt, :options] => 'options',
    [AlterFunctionStmt, :objtype] => 'objtype',
    [AlterFunctionStmt, :func] => 'func',
    [AlterFunctionStmt, :actions] => 'actions',
    [DoStmt, :args] => 'args',
    [RenameStmt, :rename_type] => 'renameType',
    [RenameStmt, :relation_type] => 'relationType',
    [RenameStmt, :relation] => 'relation',
    [RenameStmt, :object] => 'object',
    [RenameStmt, :subname] => 'subname',
    [RenameStmt, :newname] => 'newname',
    [RenameStmt, :behavior] => 'behavior',
    [RenameStmt, :missing_ok] => 'missing_ok',
    [RuleStmt, :relation] => 'relation',
    [RuleStmt, :rulename] => 'rulename',
    [RuleStmt, :where_clause] => 'whereClause',
    [RuleStmt, :event] => 'event',
    [RuleStmt, :instead] => 'instead',
    [RuleStmt, :actions] => 'actions',
    [RuleStmt, :replace] => 'replace',
    [NotifyStmt, :conditionname] => 'conditionname',
    [NotifyStmt, :payload] => 'payload',
    [ListenStmt, :conditionname] => 'conditionname',
    [UnlistenStmt, :conditionname] => 'conditionname',
    [TransactionStmt, :kind] => 'kind',
    [TransactionStmt, :options] => 'options',
    [TransactionStmt, :savepoint_name] => 'savepoint_name',
    [TransactionStmt, :gid] => 'gid',
    [TransactionStmt, :chain] => 'chain',
    [ViewStmt, :view] => 'view',
    [ViewStmt, :aliases] => 'aliases',
    [ViewStmt, :query] => 'query',
    [ViewStmt, :replace] => 'replace',
    [ViewStmt, :options] => 'options',
    [ViewStmt, :with_check_option] => 'withCheckOption',
    [LoadStmt, :filename] => 'filename',
    [CreateDomainStmt, :domainname] => 'domainname',
    [CreateDomainStmt, :type_name] => 'typeName',
    [CreateDomainStmt, :coll_clause] => 'collClause',
    [CreateDomainStmt, :constraints] => 'constraints',
    [CreatedbStmt, :dbname] => 'dbname',
    [CreatedbStmt, :options] => 'options',
    [DropdbStmt, :dbname] => 'dbname',
    [DropdbStmt, :missing_ok] => 'missing_ok',
    [DropdbStmt, :options] => 'options',
    [VacuumStmt, :options] => 'options',
    [VacuumStmt, :rels] => 'rels',
    [VacuumStmt, :is_vacuumcmd] => 'is_vacuumcmd',
    [ExplainStmt, :query] => 'query',
    [ExplainStmt, :options] => 'options',
    [CreateTableAsStmt, :query] => 'query',
    [CreateTableAsStmt, :into] => 'into',
    [CreateTableAsStmt, :relkind] => 'relkind',
    [CreateTableAsStmt, :is_select_into] => 'is_select_into',
    [CreateTableAsStmt, :if_not_exists] => 'if_not_exists',
    [CreateSeqStmt, :sequence] => 'sequence',
    [CreateSeqStmt, :options] => 'options',
    [CreateSeqStmt, :owner_id] => 'ownerId',
    [CreateSeqStmt, :for_identity] => 'for_identity',
    [CreateSeqStmt, :if_not_exists] => 'if_not_exists',
    [AlterSeqStmt, :sequence] => 'sequence',
    [AlterSeqStmt, :options] => 'options',
    [AlterSeqStmt, :for_identity] => 'for_identity',
    [AlterSeqStmt, :missing_ok] => 'missing_ok',
    [VariableSetStmt, :kind] => 'kind',
    [VariableSetStmt, :name] => 'name',
    [VariableSetStmt, :args] => 'args',
    [VariableSetStmt, :is_local] => 'is_local',
    [VariableShowStmt, :name] => 'name',
    [DiscardStmt, :target] => 'target',
    [CreateTrigStmt, :trigname] => 'trigname',
    [CreateTrigStmt, :relation] => 'relation',
    [CreateTrigStmt, :funcname] => 'funcname',
    [CreateTrigStmt, :args] => 'args',
    [CreateTrigStmt, :row] => 'row',
    [CreateTrigStmt, :timing] => 'timing',
    [CreateTrigStmt, :events] => 'events',
    [CreateTrigStmt, :columns] => 'columns',
    [CreateTrigStmt, :when_clause] => 'whenClause',
    [CreateTrigStmt, :isconstraint] => 'isconstraint',
    [CreateTrigStmt, :transition_rels] => 'transitionRels',
    [CreateTrigStmt, :deferrable] => 'deferrable',
    [CreateTrigStmt, :initdeferred] => 'initdeferred',
    [CreateTrigStmt, :constrrel] => 'constrrel',
    [CreatePLangStmt, :replace] => 'replace',
    [CreatePLangStmt, :plname] => 'plname',
    [CreatePLangStmt, :plhandler] => 'plhandler',
    [CreatePLangStmt, :plinline] => 'plinline',
    [CreatePLangStmt, :plvalidator] => 'plvalidator',
    [CreatePLangStmt, :pltrusted] => 'pltrusted',
    [CreateRoleStmt, :stmt_type] => 'stmt_type',
    [CreateRoleStmt, :role] => 'role',
    [CreateRoleStmt, :options] => 'options',
    [AlterRoleStmt, :role] => 'role',
    [AlterRoleStmt, :options] => 'options',
    [AlterRoleStmt, :action] => 'action',
    [DropRoleStmt, :roles] => 'roles',
    [DropRoleStmt, :missing_ok] => 'missing_ok',
    [LockStmt, :relations] => 'relations',
    [LockStmt, :mode] => 'mode',
    [LockStmt, :nowait] => 'nowait',
    [ConstraintsSetStmt, :constraints] => 'constraints',
    [ConstraintsSetStmt, :deferred] => 'deferred',
    [ReindexStmt, :kind] => 'kind',
    [ReindexStmt, :relation] => 'relation',
    [ReindexStmt, :name] => 'name',
    [ReindexStmt, :options] => 'options',
    [ReindexStmt, :concurrent] => 'concurrent',
    [CreateSchemaStmt, :schemaname] => 'schemaname',
    [CreateSchemaStmt, :authrole] => 'authrole',
    [CreateSchemaStmt, :schema_elts] => 'schemaElts',
    [CreateSchemaStmt, :if_not_exists] => 'if_not_exists',
    [AlterDatabaseStmt, :dbname] => 'dbname',
    [AlterDatabaseStmt, :options] => 'options',
    [AlterDatabaseSetStmt, :dbname] => 'dbname',
    [AlterDatabaseSetStmt, :setstmt] => 'setstmt',
    [AlterRoleSetStmt, :role] => 'role',
    [AlterRoleSetStmt, :database] => 'database',
    [AlterRoleSetStmt, :setstmt] => 'setstmt',
    [CreateConversionStmt, :conversion_name] => 'conversion_name',
    [CreateConversionStmt, :for_encoding_name] => 'for_encoding_name',
    [CreateConversionStmt, :to_encoding_name] => 'to_encoding_name',
    [CreateConversionStmt, :func_name] => 'func_name',
    [CreateConversionStmt, :def] => 'def',
    [CreateCastStmt, :sourcetype] => 'sourcetype',
    [CreateCastStmt, :targettype] => 'targettype',
    [CreateCastStmt, :func] => 'func',
    [CreateCastStmt, :context] => 'context',
    [CreateCastStmt, :inout] => 'inout',
    [CreateOpClassStmt, :opclassname] => 'opclassname',
    [CreateOpClassStmt, :opfamilyname] => 'opfamilyname',
    [CreateOpClassStmt, :amname] => 'amname',
    [CreateOpClassStmt, :datatype] => 'datatype',
    [CreateOpClassStmt, :items] => 'items',
    [CreateOpClassStmt, :is_default] => 'isDefault',
    [CreateOpFamilyStmt, :opfamilyname] => 'opfamilyname',
    [CreateOpFamilyStmt, :amname] => 'amname',
    [AlterOpFamilyStmt, :opfamilyname] => 'opfamilyname',
    [AlterOpFamilyStmt, :amname] => 'amname',
    [AlterOpFamilyStmt, :is_drop] => 'isDrop',
    [AlterOpFamilyStmt, :items] => 'items',
    [PrepareStmt, :name] => 'name',
    [PrepareStmt, :argtypes] => 'argtypes',
    [PrepareStmt, :query] => 'query',
    [ExecuteStmt, :name] => 'name',
    [ExecuteStmt, :params] => 'params',
    [DeallocateStmt, :name] => 'name',
    [DeclareCursorStmt, :portalname] => 'portalname',
    [DeclareCursorStmt, :options] => 'options',
    [DeclareCursorStmt, :query] => 'query',
    [CreateTableSpaceStmt, :tablespacename] => 'tablespacename',
    [CreateTableSpaceStmt, :owner] => 'owner',
    [CreateTableSpaceStmt, :location] => 'location',
    [CreateTableSpaceStmt, :options] => 'options',
    [DropTableSpaceStmt, :tablespacename] => 'tablespacename',
    [DropTableSpaceStmt, :missing_ok] => 'missing_ok',
    [AlterObjectDependsStmt, :object_type] => 'objectType',
    [AlterObjectDependsStmt, :relation] => 'relation',
    [AlterObjectDependsStmt, :object] => 'object',
    [AlterObjectDependsStmt, :extname] => 'extname',
    [AlterObjectDependsStmt, :remove] => 'remove',
    [AlterObjectSchemaStmt, :object_type] => 'objectType',
    [AlterObjectSchemaStmt, :relation] => 'relation',
    [AlterObjectSchemaStmt, :object] => 'object',
    [AlterObjectSchemaStmt, :newschema] => 'newschema',
    [AlterObjectSchemaStmt, :missing_ok] => 'missing_ok',
    [AlterOwnerStmt, :object_type] => 'objectType',
    [AlterOwnerStmt, :relation] => 'relation',
    [AlterOwnerStmt, :object] => 'object',
    [AlterOwnerStmt, :newowner] => 'newowner',
    [AlterOperatorStmt, :opername] => 'opername',
    [AlterOperatorStmt, :options] => 'options',
    [AlterTypeStmt, :type_name] => 'typeName',
    [AlterTypeStmt, :options] => 'options',
    [DropOwnedStmt, :roles] => 'roles',
    [DropOwnedStmt, :behavior] => 'behavior',
    [ReassignOwnedStmt, :roles] => 'roles',
    [ReassignOwnedStmt, :newrole] => 'newrole',
    [CompositeTypeStmt, :typevar] => 'typevar',
    [CompositeTypeStmt, :coldeflist] => 'coldeflist',
    [CreateEnumStmt, :type_name] => 'typeName',
    [CreateEnumStmt, :vals] => 'vals',
    [CreateRangeStmt, :type_name] => 'typeName',
    [CreateRangeStmt, :params] => 'params',
    [AlterEnumStmt, :type_name] => 'typeName',
    [AlterEnumStmt, :old_val] => 'oldVal',
    [AlterEnumStmt, :new_val] => 'newVal',
    [AlterEnumStmt, :new_val_neighbor] => 'newValNeighbor',
    [AlterEnumStmt, :new_val_is_after] => 'newValIsAfter',
    [AlterEnumStmt, :skip_if_new_val_exists] => 'skipIfNewValExists',
    [AlterTSDictionaryStmt, :dictname] => 'dictname',
    [AlterTSDictionaryStmt, :options] => 'options',
    [AlterTSConfigurationStmt, :kind] => 'kind',
    [AlterTSConfigurationStmt, :cfgname] => 'cfgname',
    [AlterTSConfigurationStmt, :tokentype] => 'tokentype',
    [AlterTSConfigurationStmt, :dicts] => 'dicts',
    [AlterTSConfigurationStmt, :override] => 'override',
    [AlterTSConfigurationStmt, :replace] => 'replace',
    [AlterTSConfigurationStmt, :missing_ok] => 'missing_ok',
    [CreateFdwStmt, :fdwname] => 'fdwname',
    [CreateFdwStmt, :func_options] => 'func_options',
    [CreateFdwStmt, :options] => 'options',
    [AlterFdwStmt, :fdwname] => 'fdwname',
    [AlterFdwStmt, :func_options] => 'func_options',
    [AlterFdwStmt, :options] => 'options',
    [CreateForeignServerStmt, :servername] => 'servername',
    [CreateForeignServerStmt, :servertype] => 'servertype',
    [CreateForeignServerStmt, :version] => 'version',
    [CreateForeignServerStmt, :fdwname] => 'fdwname',
    [CreateForeignServerStmt, :if_not_exists] => 'if_not_exists',
    [CreateForeignServerStmt, :options] => 'options',
    [AlterForeignServerStmt, :servername] => 'servername',
    [AlterForeignServerStmt, :version] => 'version',
    [AlterForeignServerStmt, :options] => 'options',
    [AlterForeignServerStmt, :has_version] => 'has_version',
    [CreateUserMappingStmt, :user] => 'user',
    [CreateUserMappingStmt, :servername] => 'servername',
    [CreateUserMappingStmt, :if_not_exists] => 'if_not_exists',
    [CreateUserMappingStmt, :options] => 'options',
    [AlterUserMappingStmt, :user] => 'user',
    [AlterUserMappingStmt, :servername] => 'servername',
    [AlterUserMappingStmt, :options] => 'options',
    [DropUserMappingStmt, :user] => 'user',
    [DropUserMappingStmt, :servername] => 'servername',
    [DropUserMappingStmt, :missing_ok] => 'missing_ok',
    [AlterTableSpaceOptionsStmt, :tablespacename] => 'tablespacename',
    [AlterTableSpaceOptionsStmt, :options] => 'options',
    [AlterTableSpaceOptionsStmt, :is_reset] => 'isReset',
    [AlterTableMoveAllStmt, :orig_tablespacename] => 'orig_tablespacename',
    [AlterTableMoveAllStmt, :objtype] => 'objtype',
    [AlterTableMoveAllStmt, :roles] => 'roles',
    [AlterTableMoveAllStmt, :new_tablespacename] => 'new_tablespacename',
    [AlterTableMoveAllStmt, :nowait] => 'nowait',
    [SecLabelStmt, :objtype] => 'objtype',
    [SecLabelStmt, :object] => 'object',
    [SecLabelStmt, :provider] => 'provider',
    [SecLabelStmt, :label] => 'label',
    [CreateForeignTableStmt, :base_stmt] => 'base',
    [CreateForeignTableStmt, :servername] => 'servername',
    [CreateForeignTableStmt, :options] => 'options',
    [ImportForeignSchemaStmt, :server_name] => 'server_name',
    [ImportForeignSchemaStmt, :remote_schema] => 'remote_schema',
    [ImportForeignSchemaStmt, :local_schema] => 'local_schema',
    [ImportForeignSchemaStmt, :list_type] => 'list_type',
    [ImportForeignSchemaStmt, :table_list] => 'table_list',
    [ImportForeignSchemaStmt, :options] => 'options',
    [CreateExtensionStmt, :extname] => 'extname',
    [CreateExtensionStmt, :if_not_exists] => 'if_not_exists',
    [CreateExtensionStmt, :options] => 'options',
    [AlterExtensionStmt, :extname] => 'extname',
    [AlterExtensionStmt, :options] => 'options',
    [AlterExtensionContentsStmt, :extname] => 'extname',
    [AlterExtensionContentsStmt, :action] => 'action',
    [AlterExtensionContentsStmt, :objtype] => 'objtype',
    [AlterExtensionContentsStmt, :object] => 'object',
    [CreateEventTrigStmt, :trigname] => 'trigname',
    [CreateEventTrigStmt, :eventname] => 'eventname',
    [CreateEventTrigStmt, :whenclause] => 'whenclause',
    [CreateEventTrigStmt, :funcname] => 'funcname',
    [AlterEventTrigStmt, :trigname] => 'trigname',
    [AlterEventTrigStmt, :tgenabled] => 'tgenabled',
    [RefreshMatViewStmt, :concurrent] => 'concurrent',
    [RefreshMatViewStmt, :skip_data] => 'skipData',
    [RefreshMatViewStmt, :relation] => 'relation',
    [ReplicaIdentityStmt, :identity_type] => 'identity_type',
    [ReplicaIdentityStmt, :name] => 'name',
    [AlterSystemStmt, :setstmt] => 'setstmt',
    [CreatePolicyStmt, :policy_name] => 'policy_name',
    [CreatePolicyStmt, :table] => 'table',
    [CreatePolicyStmt, :cmd_name] => 'cmd_name',
    [CreatePolicyStmt, :permissive] => 'permissive',
    [CreatePolicyStmt, :roles] => 'roles',
    [CreatePolicyStmt, :qual] => 'qual',
    [CreatePolicyStmt, :with_check] => 'with_check',
    [AlterPolicyStmt, :policy_name] => 'policy_name',
    [AlterPolicyStmt, :table] => 'table',
    [AlterPolicyStmt, :roles] => 'roles',
    [AlterPolicyStmt, :qual] => 'qual',
    [AlterPolicyStmt, :with_check] => 'with_check',
    [CreateTransformStmt, :replace] => 'replace',
    [CreateTransformStmt, :type_name] => 'type_name',
    [CreateTransformStmt, :lang] => 'lang',
    [CreateTransformStmt, :fromsql] => 'fromsql',
    [CreateTransformStmt, :tosql] => 'tosql',
    [CreateAmStmt, :amname] => 'amname',
    [CreateAmStmt, :handler_name] => 'handler_name',
    [CreateAmStmt, :amtype] => 'amtype',
    [CreatePublicationStmt, :pubname] => 'pubname',
    [CreatePublicationStmt, :options] => 'options',
    [CreatePublicationStmt, :tables] => 'tables',
    [CreatePublicationStmt, :for_all_tables] => 'for_all_tables',
    [AlterPublicationStmt, :pubname] => 'pubname',
    [AlterPublicationStmt, :options] => 'options',
    [AlterPublicationStmt, :tables] => 'tables',
    [AlterPublicationStmt, :for_all_tables] => 'for_all_tables',
    [AlterPublicationStmt, :table_action] => 'tableAction',
    [CreateSubscriptionStmt, :subname] => 'subname',
    [CreateSubscriptionStmt, :conninfo] => 'conninfo',
    [CreateSubscriptionStmt, :publication] => 'publication',
    [CreateSubscriptionStmt, :options] => 'options',
    [AlterSubscriptionStmt, :kind] => 'kind',
    [AlterSubscriptionStmt, :subname] => 'subname',
    [AlterSubscriptionStmt, :conninfo] => 'conninfo',
    [AlterSubscriptionStmt, :publication] => 'publication',
    [AlterSubscriptionStmt, :options] => 'options',
    [DropSubscriptionStmt, :subname] => 'subname',
    [DropSubscriptionStmt, :missing_ok] => 'missing_ok',
    [DropSubscriptionStmt, :behavior] => 'behavior',
    [CreateStatsStmt, :defnames] => 'defnames',
    [CreateStatsStmt, :stat_types] => 'stat_types',
    [CreateStatsStmt, :exprs] => 'exprs',
    [CreateStatsStmt, :relations] => 'relations',
    [CreateStatsStmt, :stxcomment] => 'stxcomment',
    [CreateStatsStmt, :if_not_exists] => 'if_not_exists',
    [AlterCollationStmt, :collname] => 'collname',
    [CallStmt, :funccall] => 'funccall',
    [CallStmt, :funcexpr] => 'funcexpr',
    [AlterStatsStmt, :defnames] => 'defnames',
    [AlterStatsStmt, :stxstattarget] => 'stxstattarget',
    [AlterStatsStmt, :missing_ok] => 'missing_ok',
    [A_Expr, :kind] => 'kind',
    [A_Expr, :name] => 'name',
    [A_Expr, :lexpr] => 'lexpr',
    [A_Expr, :rexpr] => 'rexpr',
    [A_Expr, :location] => 'location',
    [ColumnRef, :fields] => 'fields',
    [ColumnRef, :location] => 'location',
    [ParamRef, :number] => 'number',
    [ParamRef, :location] => 'location',
    [A_Const, :val] => 'val',
    [A_Const, :location] => 'location',
    [FuncCall, :funcname] => 'funcname',
    [FuncCall, :args] => 'args',
    [FuncCall, :agg_order] => 'agg_order',
    [FuncCall, :agg_filter] => 'agg_filter',
    [FuncCall, :agg_within_group] => 'agg_within_group',
    [FuncCall, :agg_star] => 'agg_star',
    [FuncCall, :agg_distinct] => 'agg_distinct',
    [FuncCall, :func_variadic] => 'func_variadic',
    [FuncCall, :over] => 'over',
    [FuncCall, :location] => 'location',
    [A_Indices, :is_slice] => 'is_slice',
    [A_Indices, :lidx] => 'lidx',
    [A_Indices, :uidx] => 'uidx',
    [A_Indirection, :arg] => 'arg',
    [A_Indirection, :indirection] => 'indirection',
    [A_ArrayExpr, :elements] => 'elements',
    [A_ArrayExpr, :location] => 'location',
    [ResTarget, :name] => 'name',
    [ResTarget, :indirection] => 'indirection',
    [ResTarget, :val] => 'val',
    [ResTarget, :location] => 'location',
    [MultiAssignRef, :source] => 'source',
    [MultiAssignRef, :colno] => 'colno',
    [MultiAssignRef, :ncolumns] => 'ncolumns',
    [TypeCast, :arg] => 'arg',
    [TypeCast, :type_name] => 'typeName',
    [TypeCast, :location] => 'location',
    [CollateClause, :arg] => 'arg',
    [CollateClause, :collname] => 'collname',
    [CollateClause, :location] => 'location',
    [SortBy, :node] => 'node',
    [SortBy, :sortby_dir] => 'sortby_dir',
    [SortBy, :sortby_nulls] => 'sortby_nulls',
    [SortBy, :use_op] => 'useOp',
    [SortBy, :location] => 'location',
    [WindowDef, :name] => 'name',
    [WindowDef, :refname] => 'refname',
    [WindowDef, :partition_clause] => 'partitionClause',
    [WindowDef, :order_clause] => 'orderClause',
    [WindowDef, :frame_options] => 'frameOptions',
    [WindowDef, :start_offset] => 'startOffset',
    [WindowDef, :end_offset] => 'endOffset',
    [WindowDef, :location] => 'location',
    [RangeSubselect, :lateral] => 'lateral',
    [RangeSubselect, :subquery] => 'subquery',
    [RangeSubselect, :alias] => 'alias',
    [RangeFunction, :lateral] => 'lateral',
    [RangeFunction, :ordinality] => 'ordinality',
    [RangeFunction, :is_rowsfrom] => 'is_rowsfrom',
    [RangeFunction, :functions] => 'functions',
    [RangeFunction, :alias] => 'alias',
    [RangeFunction, :coldeflist] => 'coldeflist',
    [RangeTableSample, :relation] => 'relation',
    [RangeTableSample, :method] => 'method',
    [RangeTableSample, :args] => 'args',
    [RangeTableSample, :repeatable] => 'repeatable',
    [RangeTableSample, :location] => 'location',
    [RangeTableFunc, :lateral] => 'lateral',
    [RangeTableFunc, :docexpr] => 'docexpr',
    [RangeTableFunc, :rowexpr] => 'rowexpr',
    [RangeTableFunc, :namespaces] => 'namespaces',
    [RangeTableFunc, :columns] => 'columns',
    [RangeTableFunc, :alias] => 'alias',
    [RangeTableFunc, :location] => 'location',
    [RangeTableFuncCol, :colname] => 'colname',
    [RangeTableFuncCol, :type_name] => 'typeName',
    [RangeTableFuncCol, :for_ordinality] => 'for_ordinality',
    [RangeTableFuncCol, :is_not_null] => 'is_not_null',
    [RangeTableFuncCol, :colexpr] => 'colexpr',
    [RangeTableFuncCol, :coldefexpr] => 'coldefexpr',
    [RangeTableFuncCol, :location] => 'location',
    [TypeName, :names] => 'names',
    [TypeName, :type_oid] => 'typeOid',
    [TypeName, :setof] => 'setof',
    [TypeName, :pct_type] => 'pct_type',
    [TypeName, :typmods] => 'typmods',
    [TypeName, :typemod] => 'typemod',
    [TypeName, :array_bounds] => 'arrayBounds',
    [TypeName, :location] => 'location',
    [ColumnDef, :colname] => 'colname',
    [ColumnDef, :type_name] => 'typeName',
    [ColumnDef, :inhcount] => 'inhcount',
    [ColumnDef, :is_local] => 'is_local',
    [ColumnDef, :is_not_null] => 'is_not_null',
    [ColumnDef, :is_from_type] => 'is_from_type',
    [ColumnDef, :storage] => 'storage',
    [ColumnDef, :raw_default] => 'raw_default',
    [ColumnDef, :cooked_default] => 'cooked_default',
    [ColumnDef, :identity] => 'identity',
    [ColumnDef, :identity_sequence] => 'identitySequence',
    [ColumnDef, :generated] => 'generated',
    [ColumnDef, :coll_clause] => 'collClause',
    [ColumnDef, :coll_oid] => 'collOid',
    [ColumnDef, :constraints] => 'constraints',
    [ColumnDef, :fdwoptions] => 'fdwoptions',
    [ColumnDef, :location] => 'location',
    [IndexElem, :name] => 'name',
    [IndexElem, :expr] => 'expr',
    [IndexElem, :indexcolname] => 'indexcolname',
    [IndexElem, :collation] => 'collation',
    [IndexElem, :opclass] => 'opclass',
    [IndexElem, :opclassopts] => 'opclassopts',
    [IndexElem, :ordering] => 'ordering',
    [IndexElem, :nulls_ordering] => 'nulls_ordering',
    [Constraint, :contype] => 'contype',
    [Constraint, :conname] => 'conname',
    [Constraint, :deferrable] => 'deferrable',
    [Constraint, :initdeferred] => 'initdeferred',
    [Constraint, :location] => 'location',
    [Constraint, :is_no_inherit] => 'is_no_inherit',
    [Constraint, :raw_expr] => 'raw_expr',
    [Constraint, :cooked_expr] => 'cooked_expr',
    [Constraint, :generated_when] => 'generated_when',
    [Constraint, :keys] => 'keys',
    [Constraint, :including] => 'including',
    [Constraint, :exclusions] => 'exclusions',
    [Constraint, :options] => 'options',
    [Constraint, :indexname] => 'indexname',
    [Constraint, :indexspace] => 'indexspace',
    [Constraint, :reset_default_tblspc] => 'reset_default_tblspc',
    [Constraint, :access_method] => 'access_method',
    [Constraint, :where_clause] => 'where_clause',
    [Constraint, :pktable] => 'pktable',
    [Constraint, :fk_attrs] => 'fk_attrs',
    [Constraint, :pk_attrs] => 'pk_attrs',
    [Constraint, :fk_matchtype] => 'fk_matchtype',
    [Constraint, :fk_upd_action] => 'fk_upd_action',
    [Constraint, :fk_del_action] => 'fk_del_action',
    [Constraint, :old_conpfeqop] => 'old_conpfeqop',
    [Constraint, :old_pktable_oid] => 'old_pktable_oid',
    [Constraint, :skip_validation] => 'skip_validation',
    [Constraint, :initially_valid] => 'initially_valid',
    [DefElem, :defnamespace] => 'defnamespace',
    [DefElem, :defname] => 'defname',
    [DefElem, :arg] => 'arg',
    [DefElem, :defaction] => 'defaction',
    [DefElem, :location] => 'location',
    [RangeTblEntry, :rtekind] => 'rtekind',
    [RangeTblEntry, :relid] => 'relid',
    [RangeTblEntry, :relkind] => 'relkind',
    [RangeTblEntry, :rellockmode] => 'rellockmode',
    [RangeTblEntry, :tablesample] => 'tablesample',
    [RangeTblEntry, :subquery] => 'subquery',
    [RangeTblEntry, :security_barrier] => 'security_barrier',
    [RangeTblEntry, :jointype] => 'jointype',
    [RangeTblEntry, :joinmergedcols] => 'joinmergedcols',
    [RangeTblEntry, :joinaliasvars] => 'joinaliasvars',
    [RangeTblEntry, :joinleftcols] => 'joinleftcols',
    [RangeTblEntry, :joinrightcols] => 'joinrightcols',
    [RangeTblEntry, :functions] => 'functions',
    [RangeTblEntry, :funcordinality] => 'funcordinality',
    [RangeTblEntry, :tablefunc] => 'tablefunc',
    [RangeTblEntry, :values_lists] => 'values_lists',
    [RangeTblEntry, :ctename] => 'ctename',
    [RangeTblEntry, :ctelevelsup] => 'ctelevelsup',
    [RangeTblEntry, :self_reference] => 'self_reference',
    [RangeTblEntry, :coltypes] => 'coltypes',
    [RangeTblEntry, :coltypmods] => 'coltypmods',
    [RangeTblEntry, :colcollations] => 'colcollations',
    [RangeTblEntry, :enrname] => 'enrname',
    [RangeTblEntry, :enrtuples] => 'enrtuples',
    [RangeTblEntry, :alias] => 'alias',
    [RangeTblEntry, :eref] => 'eref',
    [RangeTblEntry, :lateral] => 'lateral',
    [RangeTblEntry, :inh] => 'inh',
    [RangeTblEntry, :in_from_cl] => 'inFromCl',
    [RangeTblEntry, :required_perms] => 'requiredPerms',
    [RangeTblEntry, :check_as_user] => 'checkAsUser',
    [RangeTblEntry, :selected_cols] => 'selectedCols',
    [RangeTblEntry, :inserted_cols] => 'insertedCols',
    [RangeTblEntry, :updated_cols] => 'updatedCols',
    [RangeTblEntry, :extra_updated_cols] => 'extraUpdatedCols',
    [RangeTblEntry, :security_quals] => 'securityQuals',
    [RangeTblFunction, :funcexpr] => 'funcexpr',
    [RangeTblFunction, :funccolcount] => 'funccolcount',
    [RangeTblFunction, :funccolnames] => 'funccolnames',
    [RangeTblFunction, :funccoltypes] => 'funccoltypes',
    [RangeTblFunction, :funccoltypmods] => 'funccoltypmods',
    [RangeTblFunction, :funccolcollations] => 'funccolcollations',
    [RangeTblFunction, :funcparams] => 'funcparams',
    [TableSampleClause, :tsmhandler] => 'tsmhandler',
    [TableSampleClause, :args] => 'args',
    [TableSampleClause, :repeatable] => 'repeatable',
    [WithCheckOption, :kind] => 'kind',
    [WithCheckOption, :relname] => 'relname',
    [WithCheckOption, :polname] => 'polname',
    [WithCheckOption, :qual] => 'qual',
    [WithCheckOption, :cascaded] => 'cascaded',
    [SortGroupClause, :tle_sort_group_ref] => 'tleSortGroupRef',
    [SortGroupClause, :eqop] => 'eqop',
    [SortGroupClause, :sortop] => 'sortop',
    [SortGroupClause, :nulls_first] => 'nulls_first',
    [SortGroupClause, :hashable] => 'hashable',
    [GroupingSet, :kind] => 'kind',
    [GroupingSet, :content] => 'content',
    [GroupingSet, :location] => 'location',
    [WindowClause, :name] => 'name',
    [WindowClause, :refname] => 'refname',
    [WindowClause, :partition_clause] => 'partitionClause',
    [WindowClause, :order_clause] => 'orderClause',
    [WindowClause, :frame_options] => 'frameOptions',
    [WindowClause, :start_offset] => 'startOffset',
    [WindowClause, :end_offset] => 'endOffset',
    [WindowClause, :start_in_range_func] => 'startInRangeFunc',
    [WindowClause, :end_in_range_func] => 'endInRangeFunc',
    [WindowClause, :in_range_coll] => 'inRangeColl',
    [WindowClause, :in_range_asc] => 'inRangeAsc',
    [WindowClause, :in_range_nulls_first] => 'inRangeNullsFirst',
    [WindowClause, :winref] => 'winref',
    [WindowClause, :copied_order] => 'copiedOrder',
    [ObjectWithArgs, :objname] => 'objname',
    [ObjectWithArgs, :objargs] => 'objargs',
    [ObjectWithArgs, :args_unspecified] => 'args_unspecified',
    [AccessPriv, :priv_name] => 'priv_name',
    [AccessPriv, :cols] => 'cols',
    [CreateOpClassItem, :itemtype] => 'itemtype',
    [CreateOpClassItem, :name] => 'name',
    [CreateOpClassItem, :number] => 'number',
    [CreateOpClassItem, :order_family] => 'order_family',
    [CreateOpClassItem, :class_args] => 'class_args',
    [CreateOpClassItem, :storedtype] => 'storedtype',
    [TableLikeClause, :relation] => 'relation',
    [TableLikeClause, :options] => 'options',
    [FunctionParameter, :name] => 'name',
    [FunctionParameter, :arg_type] => 'argType',
    [FunctionParameter, :mode] => 'mode',
    [FunctionParameter, :defexpr] => 'defexpr',
    [LockingClause, :locked_rels] => 'lockedRels',
    [LockingClause, :strength] => 'strength',
    [LockingClause, :wait_policy] => 'waitPolicy',
    [RowMarkClause, :rti] => 'rti',
    [RowMarkClause, :strength] => 'strength',
    [RowMarkClause, :wait_policy] => 'waitPolicy',
    [RowMarkClause, :pushed_down] => 'pushedDown',
    [XmlSerialize, :xmloption] => 'xmloption',
    [XmlSerialize, :expr] => 'expr',
    [XmlSerialize, :type_name] => 'typeName',
    [XmlSerialize, :location] => 'location',
    [WithClause, :ctes] => 'ctes',
    [WithClause, :recursive] => 'recursive',
    [WithClause, :location] => 'location',
    [InferClause, :index_elems] => 'indexElems',
    [InferClause, :where_clause] => 'whereClause',
    [InferClause, :conname] => 'conname',
    [InferClause, :location] => 'location',
    [OnConflictClause, :action] => 'action',
    [OnConflictClause, :infer] => 'infer',
    [OnConflictClause, :target_list] => 'targetList',
    [OnConflictClause, :where_clause] => 'whereClause',
    [OnConflictClause, :location] => 'location',
    [CommonTableExpr, :ctename] => 'ctename',
    [CommonTableExpr, :aliascolnames] => 'aliascolnames',
    [CommonTableExpr, :ctematerialized] => 'ctematerialized',
    [CommonTableExpr, :ctequery] => 'ctequery',
    [CommonTableExpr, :location] => 'location',
    [CommonTableExpr, :cterecursive] => 'cterecursive',
    [CommonTableExpr, :cterefcount] => 'cterefcount',
    [CommonTableExpr, :ctecolnames] => 'ctecolnames',
    [CommonTableExpr, :ctecoltypes] => 'ctecoltypes',
    [CommonTableExpr, :ctecoltypmods] => 'ctecoltypmods',
    [CommonTableExpr, :ctecolcollations] => 'ctecolcollations',
    [RoleSpec, :roletype] => 'roletype',
    [RoleSpec, :rolename] => 'rolename',
    [RoleSpec, :location] => 'location',
    [TriggerTransition, :name] => 'name',
    [TriggerTransition, :is_new] => 'isNew',
    [TriggerTransition, :is_table] => 'isTable',
    [PartitionElem, :name] => 'name',
    [PartitionElem, :expr] => 'expr',
    [PartitionElem, :collation] => 'collation',
    [PartitionElem, :opclass] => 'opclass',
    [PartitionElem, :location] => 'location',
    [PartitionSpec, :strategy] => 'strategy',
    [PartitionSpec, :part_params] => 'partParams',
    [PartitionSpec, :location] => 'location',
    [PartitionBoundSpec, :strategy] => 'strategy',
    [PartitionBoundSpec, :is_default] => 'is_default',
    [PartitionBoundSpec, :modulus] => 'modulus',
    [PartitionBoundSpec, :remainder] => 'remainder',
    [PartitionBoundSpec, :listdatums] => 'listdatums',
    [PartitionBoundSpec, :lowerdatums] => 'lowerdatums',
    [PartitionBoundSpec, :upperdatums] => 'upperdatums',
    [PartitionBoundSpec, :location] => 'location',
    [PartitionRangeDatum, :kind] => 'kind',
    [PartitionRangeDatum, :value] => 'value',
    [PartitionRangeDatum, :location] => 'location',
    [PartitionCmd, :name] => 'name',
    [PartitionCmd, :bound] => 'bound',
    [VacuumRelation, :relation] => 'relation',
    [VacuumRelation, :oid] => 'oid',
    [VacuumRelation, :va_cols] => 'va_cols',
    [InlineCodeBlock, :source_text] => 'source_text',
    [InlineCodeBlock, :lang_oid] => 'langOid',
    [InlineCodeBlock, :lang_is_trusted] => 'langIsTrusted',
    [InlineCodeBlock, :atomic] => 'atomic',
    [CallContext, :atomic] => 'atomic',
    [ScanToken, :start] => 'start',
    [ScanToken, :end] => 'end',
    [ScanToken, :token] => 'token',
    [ScanToken, :keyword_kind] => 'keyword_kind',
  }
end
