/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.tool;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import jd.util.Arguments;
import jd.xml.util.XmlSource;
import jd.xml.util.XmlWriter;
import jd.xml.xpath.VariableName;
import jd.xml.xpath.XPathContext;
import jd.xml.xpath.XPathException;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.ModelReader;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.build.ModelBuilder;
import jd.xml.xpath.model.build.ModelBuilderFactory;
import jd.xml.xpath.model.visit.Serializer;
import jd.xml.xpath.object.XBoolean;
import jd.xml.xpath.object.XNodeSet;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XString;
import jd.xml.xpath.parser.ExpressionParser;
import jd.xml.xpath.parser.XPathParseContext;
import jd.xml.xpath.parser.XPathParseException;
import jd.xml.xpath.tool.XPathNamespaces;

public class XPath {
    private int dependencies_;
    private String exprString_;
    private Expression expr_;
    private Hashtable variables_;
    private Context context_ = new Context();
    static /* synthetic */ Class class$jd$xml$xpath$tool$XPath;

    public XPath(String string) throws XPathParseException {
        this(string, null);
    }

    public XPath(String string, XPathNamespaces xPathNamespaces) throws XPathParseException {
        if (string == null) {
            throw new IllegalArgumentException("expression is null");
        }
        ExpressionParser expressionParser = xPathNamespaces == null ? new ExpressionParser() : new ExpressionParser(new ParseContext(xPathNamespaces));
        this.init(expressionParser.parseExpression(string));
    }

    public XPath(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression is null");
        }
        this.init(expression);
    }

    private void init(Expression expression) {
        this.expr_ = expression;
        this.context_ = new Context();
        this.dependencies_ = expression.getContextDependencies();
    }

    public Expression getExpression() {
        return this.expr_;
    }

    public void setVariable(String string, boolean bl) {
        this.setVariable(string, XBoolean.getBoolean(bl));
    }

    public void setVariable(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.setVariable(string, new XString(string2));
    }

    public void setVariable(String string, double d) {
        this.setVariable(string, new XNumber(d));
    }

    public void setVariable(String string, XObject xObject) {
        if (xObject == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (this.variables_ == null) {
            this.variables_ = new Hashtable();
        }
        this.variables_.put(string, xObject);
    }

    public void clearVariables() {
        if (this.variables_ != null) {
            this.variables_.clear();
        }
    }

    public void clearVariable(String string) {
        if (this.variables_ != null) {
            this.variables_.remove(string);
        }
    }

    public void setContext(XPathNode xPathNode) {
        this.context_.setNode(xPathNode);
        this.context_.setPosition(1);
        this.context_.setSize(1);
    }

    public XPathContext getContext() {
        return this.context_;
    }

    public boolean toBooleanValue() {
        this.checkContext();
        return this.expr_.toBooleanValue(this.context_);
    }

    public String toStringValue() {
        this.checkContext();
        return this.expr_.toStringValue(this.context_);
    }

    public double toNumberValue() {
        this.checkContext();
        return this.expr_.toNumberValue(this.context_);
    }

    public XNodeSet toNodeSet() {
        this.checkContext();
        return this.expr_.toNodeSet(this.context_, 0);
    }

    public XObject toXObject() {
        this.checkContext();
        return this.expr_.toXObject(this.context_);
    }

    public void printVerboseResult(XObject xObject, XmlWriter xmlWriter) {
        xmlWriter.println();
        xmlWriter.println("epxression  : " + this.getExpression());
        xmlWriter.println("result type : " + xObject.getTypeName());
        xmlWriter.print("result value: ");
        if (xObject.getType() != 3) {
            xmlWriter.println(xObject);
        } else {
            XNodeSet xNodeSet = xObject.toNodeSet();
            xmlWriter.println("size " + xNodeSet.size());
            xmlWriter.println("{ ");
            for (int i = 0; i < xNodeSet.size(); ++i) {
                System.out.print("  ");
                xmlWriter.println(xNodeSet.getNode(i));
            }
            xmlWriter.println("}");
        }
        xmlWriter.println();
        xmlWriter.flush();
    }

    public void printResult(XObject xObject, XmlWriter xmlWriter) throws IOException {
        if (xObject.getType() != 3) {
            xmlWriter.print(xObject.toStringValue());
        } else {
            XNodeSet xNodeSet = xObject.toNodeSet();
            Serializer serializer = new Serializer(xmlWriter);
            for (int i = 0; i < xNodeSet.size(); ++i) {
                serializer.write(xNodeSet.getNode(i));
            }
        }
        xmlWriter.flush();
    }

    private void checkContext() {
        int n = this.context_.getSize();
        int n2 = this.context_.getPosition();
        if (this.hasDependency(8) && this.context_.getNode() == null) {
            throw new XPathException("expression needs a context node");
        }
        if (this.hasDependency(2) && n < 1) {
            throw new XPathException("expression needs a valid context size");
        }
        if (this.hasDependency(4)) {
            if (n2 < 1) {
                throw new XPathException("expression needs a valid context position");
            }
            if (n2 > n) {
                throw new XPathException("context position is greater than the context size: " + n2 + ">" + n);
            }
        }
    }

    private boolean hasDependency(int n) {
        return (this.dependencies_ & n) > 0;
    }

    private static int error(String string) {
        System.err.println(string);
        return 1;
    }

    public static int run(String[] stringArray) throws Exception {
        Object object;
        XPathRootNode xPathRootNode;
        Object object2;
        String string;
        Arguments arguments = new Arguments(stringArray);
        if (!arguments.hasMore()) {
            System.err.println();
            System.err.println("Usage: java " + (class$jd$xml$xpath$tool$XPath == null ? (class$jd$xml$xpath$tool$XPath = XPath.class$("jd.xml.xpath.tool.XPath")) : class$jd$xml$xpath$tool$XPath).getName() + " [options] <expression> [xml-file]");
            System.err.println();
            System.err.println("Options:");
            System.err.println("-e <encoding>      define the output encoding");
            System.err.println("-n <prefix> <uri>  define a namespace");
            System.err.println("-v                 print expression and result info");
            System.err.println();
            return 1;
        }
        XPathNamespaces xPathNamespaces = null;
        boolean bl = false;
        String string2 = "UTF-8";
        while (arguments.startsWith("-")) {
            string = arguments.next();
            if (string.equals("-v")) {
                bl = true;
                continue;
            }
            if (string.equals("-n")) {
                if (!arguments.hasMore(2)) {
                    return XPath.error("no namespace prefix or uri provided");
                }
                if (xPathNamespaces == null) {
                    xPathNamespaces = new XPathNamespaces();
                }
                xPathNamespaces.declare(arguments.next(), arguments.next());
                continue;
            }
            if (string.equals("-e")) {
                if (!arguments.hasMore()) {
                    return XPath.error("no encoding provided");
                }
                string2 = arguments.next();
                continue;
            }
            return XPath.error("unknown option '" + string + "'");
        }
        string = arguments.next();
        String string3 = arguments.next();
        if (string == null) {
            return XPath.error("no expression specified");
        }
        if (arguments.hasMore()) {
            return XPath.error("unexpected argument '" + arguments.next() + "'");
        }
        XPath xPath = new XPath(string, xPathNamespaces);
        if (string3 == null) {
            object2 = ModelBuilderFactory.getDefaultInstance().createModelBuilder();
            ((ModelBuilder)object2).startBuild("", new NodeNamePool(), 0, null, false);
            xPathRootNode = ((ModelBuilder)object2).endBuild();
        } else {
            object2 = new ModelReader();
            object = string3.equals("-") ? new XmlSource("", System.in, false) : new XmlSource(string3);
            xPathRootNode = ((ModelReader)object2).read((XmlSource)object);
        }
        xPath.setContext(xPathRootNode);
        object2 = xPath.toXObject();
        object = new XmlWriter((OutputStream)System.out, string2, true);
        if (bl) {
            xPath.printVerboseResult((XObject)object2, (XmlWriter)object);
        } else {
            xPath.printResult((XObject)object2, (XmlWriter)object);
        }
        return 0;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = XPath.run(stringArray);
        System.exit(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ParseContext
    extends XPathParseContext {
        private XPathNamespaces namespaces_;

        public ParseContext(XPathNamespaces xPathNamespaces) {
            this.namespaces_ = xPathNamespaces;
        }

        public String getNamespaceUri(String string) {
            String string2 = this.namespaces_.getUri(string);
            return string2 != null ? string2 : super.getNamespaceUri(string);
        }
    }

    private class Context
    extends XPathContext {
        private Context() {
        }

        public XObject getVariable(VariableName variableName) {
            XObject xObject = null;
            if (XPath.this.variables_ != null) {
                xObject = (XObject)XPath.this.variables_.get(variableName.getName());
            }
            if (xObject == null) {
                throw new XPathException("no variable defined for " + variableName.getName());
            }
            return xObject;
        }
    }
}

