/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class AnnotationsForMemberHolder {
    private boolean annotationTypesCorrect = false;
    private ResolvedType[] annotationTypes;
    private boolean annotationXsCorrect = false;
    private AnnotationX[] annotationXs;
    public List annotations = null;
    private World world;

    public AnnotationsForMemberHolder(World w) {
        this.world = w;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationXsUnpacked();
        return this.annotationXs;
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationsUnpacked();
        return this.annotationTypes;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationsUnpacked();
        for (int i = 0; i < this.annotationTypes.length; ++i) {
            if (!this.annotationTypes[i].equals(ofType)) continue;
            return true;
        }
        return false;
    }

    private void ensureAnnotationXsUnpacked() {
        if (this.annotationTypesCorrect && this.annotationXsCorrect) {
            return;
        }
        this.ensureAnnotationsUnpacked();
        if (this.annotations == null) {
            this.annotationXs = AnnotationX.NONE;
        } else {
            this.annotationXs = new AnnotationX[this.annotations.size()];
            int pos = 0;
            Iterator iter = this.annotations.iterator();
            while (iter.hasNext()) {
                AnnotationAJ element = (AnnotationAJ)iter.next();
                this.annotationXs[pos++] = new AnnotationX(element, this.world);
            }
            this.annotations = null;
        }
        this.annotationXsCorrect = true;
    }

    private void ensureAnnotationsUnpacked() {
        if (this.annotationTypesCorrect) {
            return;
        }
        if (this.annotations == null) {
            this.annotationTypes = ResolvedType.NONE;
        } else {
            this.annotationTypes = new ResolvedType[this.annotations.size()];
            int pos = 0;
            Iterator iter = this.annotations.iterator();
            while (iter.hasNext()) {
                AnnotationAJ element = (AnnotationAJ)iter.next();
                this.annotationTypes[pos++] = this.world.resolve(UnresolvedType.forSignature(element.getTypeSignature()));
            }
        }
        this.annotationTypesCorrect = true;
    }

    public void addAnnotation(AnnotationAJ oneAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(oneAnnotation);
    }
}

