# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mongocluster.aio import MongoClusterMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMongoClusterMgmtMongoClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MongoClusterMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_get(self, resource_group):
        response = await self.client.mongo_clusters.get(
            resource_group_name=resource_group.name,
            mongo_cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.mongo_clusters.begin_create_or_update(
                resource_group_name=resource_group.name,
                mongo_cluster_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "administrator": {"password": "str", "userName": "str"},
                        "authConfig": {"allowedModes": ["str"]},
                        "backup": {"earliestRestoreTime": "str"},
                        "clusterStatus": "str",
                        "compute": {"tier": "str"},
                        "connectionString": "str",
                        "createMode": "str",
                        "dataApi": {"mode": "str"},
                        "highAvailability": {"targetMode": "str"},
                        "infrastructureVersion": "str",
                        "previewFeatures": ["str"],
                        "privateEndpointConnections": [
                            {
                                "id": "str",
                                "name": "str",
                                "properties": {
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",
                                        "description": "str",
                                        "status": "str",
                                    },
                                    "groupIds": ["str"],
                                    "privateEndpoint": {"id": "str"},
                                    "provisioningState": "str",
                                },
                                "systemData": {
                                    "createdAt": "2020-02-20 00:00:00",
                                    "createdBy": "str",
                                    "createdByType": "str",
                                    "lastModifiedAt": "2020-02-20 00:00:00",
                                    "lastModifiedBy": "str",
                                    "lastModifiedByType": "str",
                                },
                                "type": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "publicNetworkAccess": "str",
                        "replica": {"replicationState": "str", "role": "str", "sourceResourceId": "str"},
                        "replicaParameters": {"sourceLocation": "str", "sourceResourceId": "str"},
                        "restoreParameters": {"pointInTimeUTC": "2020-02-20 00:00:00", "sourceResourceId": "str"},
                        "serverVersion": "str",
                        "sharding": {"shardCount": 0},
                        "storage": {"iops": 0, "sizeGb": 0, "throughput": 0, "type": "str"},
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_begin_update(self, resource_group):
        response = await (
            await self.client.mongo_clusters.begin_update(
                resource_group_name=resource_group.name,
                mongo_cluster_name="str",
                properties={
                    "properties": {
                        "administrator": {"password": "str", "userName": "str"},
                        "authConfig": {"allowedModes": ["str"]},
                        "backup": {"earliestRestoreTime": "str"},
                        "compute": {"tier": "str"},
                        "dataApi": {"mode": "str"},
                        "highAvailability": {"targetMode": "str"},
                        "previewFeatures": ["str"],
                        "publicNetworkAccess": "str",
                        "serverVersion": "str",
                        "sharding": {"shardCount": 0},
                        "storage": {"iops": 0, "sizeGb": 0, "throughput": 0, "type": "str"},
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_begin_delete(self, resource_group):
        response = await (
            await self.client.mongo_clusters.begin_delete(
                resource_group_name=resource_group.name,
                mongo_cluster_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_list_by_resource_group(self, resource_group):
        response = self.client.mongo_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_list(self, resource_group):
        response = self.client.mongo_clusters.list()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_list_connection_strings(self, resource_group):
        response = await self.client.mongo_clusters.list_connection_strings(
            resource_group_name=resource_group.name,
            mongo_cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_check_name_availability(self, resource_group):
        response = await self.client.mongo_clusters.check_name_availability(
            location="str",
            body={"name": "str", "type": "str"},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_mongo_clusters_begin_promote(self, resource_group):
        response = await (
            await self.client.mongo_clusters.begin_promote(
                resource_group_name=resource_group.name,
                mongo_cluster_name="str",
                body={"promoteOption": "str", "mode": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
