/*
 * $Id: getcap.c,v 1.1.2.2 1999/05/01 23:26:31 morgan Exp $
 *
 * Copyright (c) 1997 Andrew G. Morgan  <morgan@ftp.kernel.org>
 *
 * This displays the capabilities of a given file.
 */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/capability.h>

static void usage(void)
{
    fprintf(stderr,
	    "usage: getcap <filename> [<filename> ...]\n"
	    "\n"
	    "\tdisplays the capabilities on the queried file(s).\n"
	);
    exit(1);
}

int main(int argc, char **argv)
{
    char *result=NULL;

    if (argc < 2) {
	usage();
    }

    for ( ++argv; --argc > 0; ++argv ) {
	ssize_t length;
	cap_t cap_d;

	cap_d = cap_get_file(argv[0]);

	if (cap_d == NULL) {
	    fprintf(stderr,
		    "Failed to get capabilities for file `%s'\n"
		    " (%s)\n", argv[0], strerror(errno));
	    continue;
	}

	result = cap_to_text(cap_d, &length);

	fprintf(stderr, "Capabilities for `%s': %s\n", *argv, result);
    }

    return 0;
}

/*
 * $Log: getcap.c,v $
 * Revision 1.1.2.2  1999/05/01 23:26:31  morgan
 * added list of things to ignore in this directory
 * altered command line syntax of sucap and also made it work (sometimes)
 * getcap output is now one line per file
 *
 * Revision 1.1.2.1  1999/04/23 05:00:31  morgan
 * resurecting from the dead for kernels with fcap support
 *
 */
