
#define MAXFILES 1024

typedef struct {

    /* File attributes */

    int  fnamelen;
    char *fname;
    struct stat  buf;

    /* Flags */
    struct { 
	unsigned int marked:1;		/* File marked in pane window */
	unsigned int exists:1;		/* Use for rereading file */
    } f;
} file_entry;

typedef file_entry dir_list [MAXFILES];

typedef int sortfn (const void *, const void*);
int do_load_dir (dir_list *list, sortfn *sort);
void do_sort (dir_list *list, sortfn *sort, int top);
dir_list *do_collect_stat (dir_list *dir, int top);
int do_reload_dir (dir_list *list, sortfn *sort, int count);
void clean_dir (dir_list *list, int count);

/* Sorting functions */
int unsorted (const void *a, const void *b);
int sort_name (const file_entry *a, const file_entry *b);
int sort_ext (const file_entry *a, const file_entry *b);
int sort_time (const file_entry *a, const file_entry *b);
int sort_size (const file_entry *a, const file_entry *b);

int link_isdir (file_entry *);
extern int show_backups;
extern int show_dot_files;
extern int show_backups;
