#include <stddef.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <termios.h>
#include <curses.h>
#include <fcntl.h>


int
bcmp(const void* s1, const void* s2, size_t len)
{return (len > 0 ? memcmp(s1, s2, (size_t) len) : 0);}

char*
index(const char* s, int c)
{ return strchr(s, c); }

char*
rindex(const char* s, int c)
{ return strrchr(s, c); }

void
bcopy(const void* s, void* d, size_t n) 
{ if (n > 0) memmove (d, s, (size_t) n); }

void
bzero(void* s, size_t l)
{ if (l > 0) memset(s, 0, (size_t) l); }


void nodelay(WINDOW *win, bool flag)
{
	fcntl(0,F_SETFL,(flag?O_NONBLOCK:~O_NONBLOCK));
}

