.\" +----------
.\" |
.\" |	      UIT/UITPS/UITVIEW/UITCMP man page. Release 4.2a. May 1994
.\" |
.\" |		Copyright 1993, 1994 by Tudor Hulubei & Andrei Pitis.
.\" |
.\" |	This file is part of UIT (UNIX Interactive Tools)
.\" |
.\" |	UIT is free software; you can redistribute it and/or modify it under
.\" | the terms of the GNU General Public License as published by the Free
.\" | Software Foundation; either version 2, or (at your option) any later
.\" | version.
.\" |
.\" | UIT is distributed in the hope that it will be useful, but WITHOUT ANY
.\" | WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
.\" | FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
.\" | details.
.\" |
.\" | You should have received a copy of the GNU General Public License along
.\" | with UIT; see the file COPYING. If not, write to the Free Software
.\" | Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.\" |
.\" |
.TH uit 1 "May 1994" "Release 4.2a"
.SH NAME
uit \- UNIX Interactive Tools version 4.2a
.SH SYNTAX
.I uit
.br
.I uitps
.IR "" "  [" ps (1)
like parameters]
.br
.I uitview
filename
.br
.I uitcmp
.IR "" "  "
file1 file2

.SH NOTE
The main configuration file of the
.I UIT 4.2a
package is
.B ".uitrc.TERM"
where
.B TERM
is the value of the environment
variable
.BR "" ' TERM '
e.g for Linux console your environment contains something like
.BR "" ' "TERM=console" '
so the configuration file name is
.BR ".uitrc.console" " ."
You can have a configuration file for each terminal type you use.

.SH DESCRIPTION
.I uit
is a
.B file system browser
with some shell facilities which was designed to make your work much
easier and much efficient.

.I uitps
is an interactive process viewer/killer. It calls internally the
.IR ps (1)
utility so that's the reason why
.I uitps
parameters are in fact
.IR ps (1)
ones. Running
.I uitps
it is self explanatory. Use the
arrows, PageUp, PageDown, Home, End, ^Y, ^B, ^Ku, ^Kv to move in
the list, ^R to refresh it and F10 or ^C to leave. You can change
these keys, just read the sections
.B [UITPS-Setup], [UITPS-Color], [UITPS-Monochrome] and [UITPS-Keys]
in the configuration file
.BR ".uitrc.TERM" .
See also 
.BR "CONFIGURATION FILES" .

.I uitview
is an hex/ascii file viewer. Too simple to need a separate manual page. Use
the arrows, PageUp, PageDown, Home, End, ^Y, ^B, ^Ku, ^Kv to move in
the file, ^R to refresh the screen and F10 or ^C to leave. You can
change those keys, just read the sections
.B [UITVIEW-Setup], [UITVIEW-Color], [UITVIEW-Monochrome] and [UITVIEW-Keys]
in the configuration file
.BR ".uitrc.TERM" .
See also 
.BR "CONFIGURATION FILES" .

.I uitcmp
is a file compare utility. It outputs to
.BR stderr ,
.I uit
catching its error messages this way.
.I uitcmp
was designed to be used in
.B "$HOME/.uitrc.TERM"
.BR "" ( uit
configuration file) and should not be used as a stand alone program.
See also 
.BR "CONFIGURATION FILES" .

.SH FILE-SYSTEM BROWSER
.I uit
is made of two panels. The left one and the right one. Each
one contains a file system directory. You can browse the
directory tree with the usual cursor keys and pressing
.B ENTER
when you want to enter or leave a directory.
You may change the panels by pressing
.BR TAB .
See also 
.BR "BUILT-IN COMMANDS" .

.SH COMMAND LINE
Under the two panels there is a shell like command line which
you can use to type normal shell commands. The command line
supports up to 256 characters and 32 commands in the history
list.
See also 
.BR "BUILT-IN COMMANDS" .

.SH WARNINGS AND ERRORS REPORTING
Under the command line there is a status bar. You can see there
the status of the currently executed command, the warnings and
errors and you will be prompted if a decision has to be taken.

.SH CONFIGURATION FILES
There are two configuration files in
.IR uit / uitps / uitview
:
.B ".uitrc.TERM"
and
.BR .uittermcap .
Their place is in the user's
.B HOME
directory.
.B "UIT 4.2a"
allows each terminal type to have its own configuration file
.BR "" ( TERM
is the value of the '
.BR TERM '
environment variable (e.g vt102). For the 
Linux console the configuration file is
.BR ".uitrc.console" ")."
You can run
.IR uit / uitps / uitview
without
.B .uittermcap
but on systems with very large termcap databases, copying the
definitions of the most used terminals in 
.B .uittermcap
will result in
.IR uit / uitps / uitview
starting faster. For even faster access, you may put in
.B .uittermcap
only the terminal capabilities that
.IR uit / uitps / uitview
uses. These capabilities are
.BR cm , us , ue , so , mr , se , cl , md , me
and, of course,
.BR tc .
.IR uit / uitps / uitview
doesn't use termcap key definitions. You must define the keys you
want directly in the
.B ".uit.TERM"
file in 
.B "[UITxxx-Keys]"
sections.
See also the sections
.BR "[UITxxx-Keys]" .

.br
The
.B .uittermcap
is a
.BR "local termcap database" ,
which allows
.IR uit / uitps / uitview
to find very fast the termcap description of the terminal specified
in the
.B TERM
environment variable. You can copy your terminal description
from
.B /etc/termcap
and put it in the
.B .uittermcap
because
.B /etc/termcap
is ussualy a very large and hard to search file.

.I uit
uses
.B .uittermcap
to find a terminal description
.B *BEFORE*
trying to read
.BR /etc/termcap .
If
.B .uittermcap
is found in the user's
.B HOME
directory,
.B /etc/termcap
will be ignored. The main advantage of the
.B .uittermcap
file is that it allows faster access and can be modified without special
permission. You can use only one of
.B .uittermcap
and
.B /etc/termcap
at a time. Take care: if you are using
.B .uittermcap
and your terminal description can't be found there,
.I uit
will fail because the
.B /etc/termcap
database won't be searched.

The configuration file
.B ".uitrc.TERM"
is the file searched by
.IR uit / uitps / uitview
each time they are started, in order to configure themselfs.
.B ".uitrc.TERM"
it is searched in the home directory. The configuration file is structured
on sections, each section containing variables in the following format:

.in +.5i
.B variable_name
=
.BR first_field ; second_field ; " ..."
.in -.5i

After the variable_name at least one space or tab is required.
All characters after a 
.BR "" \' # \'
are ignored and if you comment
a section name, the whole section is ignored.

The configuration file contains the following sections:

.B "1. [Setup]"

In this section the variables have only one field.

a. 
.B TempDirectory
.br
 - this variable specifies the location of the temporary files created by
.BR uit .

b.
.B LinuxConsole
.br
 - this variable should be set to
.B ON
on
.B Linux
systems if you are working on a
.BR "Linux virtual tty" .
If you are connected to a
.B Linux
system with a serial b/w tty, you should set this to
.BR OFF .
.B LinuxConsole
is meaningless if
.I uit
was compiled without
.BR "" ' HAVE_LINUX "'."

c.
.B ColorMonitor
.br
 - this variable should be set to
.B ON
on
.B Linux
systems if you are working on a
.B "Linux virtual tty"
and you have a
.BR "color monitor" .
If your monitor is
.BR monochrome ,
you should set this to
.BR OFF .
.B ColorMonitor
is meaningless if
.I UIT
was compiled without
.BR "" ' HAVE_LINUX '
or
.B LinuxConsole
is
.BR OFF .

If
. B LinuxConsole
and
.B ColorMonitor
are both
.BR ON ,
.B [UITxxx-Color]
sections
will be used in the configuration file
.BR ".uitrc.TERM" .
Otherwise,
.IR uit / uitps / uitview
will use the
.B [UITxxx-Monochrome]
sections.
The discussion above applies to
.IR uit ,
.I uitps
and
.I uitview
utilities.

.B "2. [UIT-Setup]"

In this section the variables have only one field.

a. 
.B StartupFileDisplayMode
 - this variable specifies the file specific information
displayed at startup. It can be any of 
.B OwnerGroup
,
.B DateTime
,
.B Size
,
.B Mode
or
.BR FullName .
 - this value initially affects both panels but it can be changed separately
afterwards.

b. 
.B StartupLeftPanelPath
.br
c.
.B StartupRightPanelPath
 - those variables specifies the startup path for each panel.

d.
.B NormalModeHelp
.br
e.
.B CommandLineModeHelp
 - those variables describe the status bar contents for each
.I uit
mode when no errors occurred. See also
.BR <ShowTty> .

f.
.B InfoDisplay
 - if this variable is OFF, auxiliary file informations are not displayed.
This can be useful if you are using a very slow terminal.

g.
.B FrameDisplay
 - if this variable is OFF, the uit frame is not displayed. This can be
useful if you are using a very slow terminal.

.B "3. [UITPS-Setup]"

In this section the variables have only one field.

a.
.B UitPsModeHelp
 - this variable describe the
.I uitps
status bar contents.

.B "4. [UITVIEW-Setup]"

In this section the variables have only one field.

a.
.B UitViewModeHelp
 - this variable describe the
.I uitview
status bar contents.

.B "5. [UITxxx-Color] / [UITxxx-Monochrome]"

In this sections the variables have only one field.

These sections permits you to customize the colors of
.IR uit ,
.I uitps
and
.IR uitview .
Reading the
.B ".uitrc.TERM"
configuration file should be self explanatory.
See also the
.B [Setup]
section.

.B "6. [UIT-Keys]"

This section describes the actions
.I uit
takes when a specified
key is pressed. In this section a variable can have up to 6
fields separated by \';\'.
Each line in this section looks like:

.BR key_sequence " " "" = " " "" command_name ; formatted_command ; new_dir ;
.br
.BR "               " "" save_screen ; pause ; hide

.B WARNING
: you can't continue the variable fields description on the next line.


a.
.B key_sequence
 -
.B key_sequence
is the key sequence associated with the given command. You can use any key
sequence wich doesn't start with an ascii character (0x20 to 0x7e). You
can specify the
.B ESC
character as
.B "^[" 
, the
.B ^
character as
.BR ^^
and
.B space
as
.BR ^@ " ."
Ascii characters are used by the command line.

b.
.B command_name
 -
.B command_name
is a command generic name. Even if it is not always used, the
.B command_name
must be present (if a command is associated with
.BR key_sequence ).
If it is not, no action will be taken when pressing
.B key_sequence.
There are two types of commands in
.I uit
:
.B built-in
commands and
.B user defined
commands.
.B Built-in
commands
are specified between <>
.BR "" ( <Copy> , " " "" <RenameMove> , " " "" <MkDir>
etc) and if the
.B command_name
section contains a built-in command specification, the other fields are
ignored.


The
.B BUILT-IN COMMANDS
are:

.B <Copy>
 - copies files from one panel to another.

.B <RenameMove>
 - moves files from one panel to another.

.B <MkDir>
 - makes directories.

.B <Delete>
 - deletes files and empty directories.

.B <Exit>
 - exits
.IR uit .

.B <HistoryBack>
 - copies to the command line the previous command in the history list.

.B <ShowTty>
 - switches between the two
.I uit
modes (starting with Linux 0.99.12 this option is completely used only if
you are super user because normal users can't do a screen dump).

.B <Refresh>
 - refreshes the contents of the current panel.

.B <GotoRoot>
 - changes the current directory to root.

.B <SwitchPanels>
 - switches the left panel with the right one.

.B <HistoryNext>
 - copies the next command in the history list to the command line.

.B <FileDisplayMode>
 - changes the file display mode.

.B <DeleteCmdLn>
 - deletes the command line contents.

.B <FileSelect>
 - selects/unselects files. All the files can be selected by pressing
.BR "" ' + '
(and ENTER) or unselected by pressing
.BR "" ' - "'."
By pressing
.BR "" ' * '
selected files becomes unselected and unselected files becomes selected.

.B <CopyFileToCmdLn>
 - copies to the command line the current file name .

.B <Home>
 - puts the cursor onto the first entry in the current directory list.

.B <End>
 - puts the cursor onto the last entry in the current directory list.

.B <PageUp>
 - puts the cursor up one page in the current directory file list.

.B <PageDown>
 - puts the cursor down one page in the current directory file list.

.B <CursorLeft>
 - acts like
.BR <PageUp> .

.B <CursorRight>
 - acts like
.BR <PageDown> .

.B <CursorUp>
 - puts the cursor up one entry in the current directory file list.

.B <CursorDown>
 - puts the cursor down one entry in the current directory file list.

.B <ChangePanel>
 - puts the cursor in the other panel.

c.
.B formatted_command
 -
.B formatted_command
is a shell command which can contain some scanf like format specifiers.
With their help you can get the current directory entry name (the directory
entry under the cursor), owner, group and mode. These are the available
.BR "format specifiers" :

 -
.B %s{question,default_answer}
.br
When
.I uit
encounters a
.B %s
in the formatted_command
asks the user the question 'question' whose default
answer is 'default_answer' and replaces the
.B %s{ , }
with the user answer. Both 'question' and 'default_answer' can
contain any other format specifiers except
.BR %s .

.B WARNING
: no spaces between
.B %s
and
.BR "" \' { \' "" .

 -
.B %f
.br
.I uit
will replace
.B %f
with the current directory entry name only if it is a file (not a directory).

 -
.B %d
.br
.I uit
will replace 
.B %d
with the current directory entry name only if it is a directory (not a file).

 -
.B %l
.br
.I uit
will replace
.B %l
with the current directory entry name only if it is a symbolic link.

 -
.B %t
.br
.I uit
will replace
.B %t
with the current directory entry name only if it is a named pipe.

 -
.B %z
.br
.I uit
will replace
.B %z
with the current directory entry name only if it is a socket.

 -
.B %a
.br
.I uit
will always replace
.B %a
with the current directory entry name.

 -
.B %m
.br
.I uit
will always replace
.B %m
in the formatted_command with the current file mode.

 -
.B %g
.br
.I uit
will always replace
.B %g
in the formatted_command with the current file group.

 -
.B %o
.br
.I uit
will always replace
.B %o
in the formatted_command with the current file owner.

 -
.B %p
.br
.I uit
will always replace
.B %p
in the formatted_command with the current panel path.

 -
.B %b
.br
.I uit
will always replace
.B %b
in the formatted_command with the current panel directory name.
.br

Using
.B uppercase format specifiers
you will be able to access the other panel path, file and directory names.

d.
.B new_dir
 - if the
.B formatted_command
successfully exits (exit code = 0) and this field is present then
.B new_dir
will become the current panel directory.

e.
.B save_screen
 - this field is an integer (usually 0 or 1) who tells
.I uit
to save (1) or not to save (0) the terminal screen
after executing the
.B formatted_command.
Saving the screen is not necessary while editing or viewing a 
file because the information left after the editor or
the viewer exits is not important. Saving the screen 
means that that screen will be restored before the
execution of the next command. This field is used only if you are
super user under Linux and you are working on a virtual console.
By default this field is 1.

f.
.B pause
 - for some commands you may wish to read their results	before
repainting the panels. If this field is present
.I uit
will wait for a key to be pressed before restoring the panels.
By default this field is 0.

g.
.B hide
 - there are some commands that aren't displaying any
useful information if successfully complete their
execution: mount, chmod, chown, chgrp, sync ... and if
an error occurs then a line or two are sended to
stderr.	If this option is 1, the stdout and stderr
will be redirected to some files
.BR "" ( stdout.pid
and
.B stderr.pid
, where
.B pid
is
.I uit
.IR pid )
and only if the command exit code is not 0, the
.B stderr.pid
file will be displayed, line by line, onto the status bar. This
way the panels will not be deleted and then repainted
and the command appears to be built-in. 
.B stdout.pid
and
.B stderr.pid
are created in the
.B TempDirectory
specified in the
.B [Setup]
section. By default this field is 0.

The default configuration file
.B "$HOME/.uitrc.TERM"
supports most of the usual commands. To find out more about them please
read it.
.I uit
allows you to change both the utility used to perform
a particular operation (using compress instead of gzip :-) ) and
the key associated with it. There is also possible to
.BR remove / add
new commands.

.B 7. [UITPS-Keys]

This section describes the actions
.I uitps
takes when a specified key is pressed. In this sections the variables
have only one field. Only built-in operations are available in
.BR uitps .
Each line in this section looks like:

.BR key_sequence " " "" = " " "" built_in_command_name


a.
.B key_sequence
 -
.B key_sequence
is the key sequence associated with the given command. You can use any key
sequence wich doesn't start with an ascii character (0x20 to 0x7e). You 
can specify the
.B ESC
character as
.B "^[" 
, the
.B ^
character as
.BR ^^
and
.B space
as
.BR ^@ " ."

b.
.B built_in_command_name
 -
.B built_in_command_name
is the name of the built-in operation to run when
.B key_sequence
is pressed. The built-in operations are:

.BR "" "- " <CursorUp>
- moves to the previous process in the processes list
.br
.BR "" "- " <CursorDown>
- moves to the next process in the processes list
.br
.BR "" "- " <PageUp>
- moves one page up in the processes list
.br
.BR "" "- " <PageDown>
- moves one page down in the processes list
.br
.BR "" "- " <Home>
- moves to the first process in the processes list
.br
.BR "" "- " <End>
- moves to the last process in the processes list
.br
.BR "" "- " <NextSignal>
- sets the next signal in the signals list as the current signal
.br
.BR "" "- " <SIGHUP>
.br
.BR "" "- " <SIGINT>
.br
.BR "" "- " <SIGQUIT>
.br
.BR "" "- " <SIGILL>
.br
.BR "" "- " <SIGFPE>
.br
.BR "" "- " <SIGKILL>
.br
.BR "" "- " <SIGUSR1>
.br
.BR "" "- " <SIGSEGV>
.br
.BR "" "- " <SIGUSR2>
.br
.BR "" "- " <SIGPIPE>
.br
.BR "" "- " <SIGALRM>
.br
.BR "" "- " <SIGTERM>
.br
.BR "" "- " <SIGCHLD>
.br
.BR "" "- " <SIGCONT>
- sets the SIG... signal as the current signal
.br
.BR "" "- " <KillProcess>
- sends the current signal to the current process
.br
.BR "" "- " <Refresh>
- refresh the processes list by recalling
.BR ps "(1)"
.br
.BR "" "- " <Exit>
- exits

.B 8. [UITVIEW-Keys]

This section describes the actions
.I uitview
takes when a specified key is pressed. In this sections the variables
have only one field. Only built-in operations are available in
.BR uitview .
Each line in this section looks like:

.BR key_sequence " " "" = " " "" built_in_command_name


a.
.B key_sequence
 -
.B key_sequence
is the key sequence associated with the given command. You can use any key
sequence wich doesn't start with an ascii character (0x20 to 0x7e). You 
can specify the
.B ESC
character as
.B "^[" 
, the
.B ^
character as
.BR ^^
and
.B space
as
.BR ^@ " ."


b.
.B built_in_command_name
 -
.B built_in_command_name
is the name of the built-in operation to run when
.B key_sequence
is pressed. The built-in operations are:

.BR "" "- " <CursorUp>
- moves to the previous line (16 bytes) in the file
.br
.BR "" "- " <CursorDown>
- moves to the next line (16 bytes) in the file
.br
.BR "" "- " <PageUp>
- moves one page up (0x100 bytes) in the file
.br
.BR "" "- " <PageDown>
- moves one page down (0x100 bytes) in the file
.br
.BR "" "- " <Home>
- moves to the beginning of the file
.br
.BR "" "- " <End>
- moves to the end of the file
.br
.BR "" "- " <Refresh>
- refresh the screen by re-reading the file
.br
.BR "" "- " <Exit>
- exits



.SH CANCELING OPERATIONS
Built-in cyclic operations can be stopped by pressing
.BR ^C .
.br
.I uit
can be suspended by pressing
.BR ^Z .

.SH MOUSE SUPPORT
.I uit
doesn't use the mouse, but, if you are running Linux, you can use the
.B selection
utility to get characters from the screen and insert them in the terminal
keyboard queue.

.SH MINUSES
.B "1."
Files can't be moved from a file system to another. You have
to copy/delete them instead. Before trying to make a
link from the destination file to the source file,
.I uit
deletes the destination file (if existent), so take care not
to lose some data trying to move files in a wrong way.

.B "2."
Background execution is not fully supported. That means you
may specify an 
.B &
terminated command line in the
configuration file but the result of the background executed
command (stdout and stderr redirection, as explained before)
will be overwritten by the result of newer commands and, if
an error occurs, you will not see it.

.B "3."
No command line editing is provided. You can only modify the contents
of the command line by appending new characters or deleting them with
backspace.

.B "4."
When
.I uit
is compiled for
.BR Linux ,
the default built-in color descriptions are for color monitors,
so you can't (decently) run
.I uit
on a b/w monitor without the
.B ".uitrc.TERM"
file correctly configured.
.B ".uitrc.TERM"
should be configured with
.BR "ColorMonitor = OFF" .
If you are working on a serial b/w tty,
.B LinuxConsole
should be
.B OFF
too.

.B "5."
Only
.B POSIX
terminals are supported.

.B "6."
No 
.B terminfo
support is provided. No problems, you can use the
.B .uittermcap
file to get termcap support.

.SH BUGS
.B "1."
Only the
.B ANSI
.BR "" ' cm '
terminal capability is supported. So, if your
.B cm
capability is not
.BR "ESC [%i%d;%dH" ,
.I uit
won't work. In order to make
.I uit
work with a different
.B cm
definition a small modification is required in
.B tty.c
(
.BR "tty_cursormove(int, int)" )
to suit your
.BR "" ' cm '
definition.

Please send bug reports to
.IR tudor@ulise.cs.pub.ro " or to " tudor@habarnam.cs.pub.ro "."

.SH SEE ALSO
termcap(5) ps(1)

.SH FILES
/usr/bin/uit
.br
/usr/bin/uitps
.br
/usr/bin/uitview
.br
/usr/bin/uitcmp
.br
/usr/man/man1/uit.1
.br
$HOME/.uitrc.console
.br
$HOME/.uitrc.xterm
.br
$HOME/.uitrc.vt102
.br
$HOME/.uittermcap

.SH AUTHORS
.I Tudor Hulubei
.br
- tudor@ulise.cs.pub.ro, tudor@habarnam.cs.pub.ro
.br
.I Andrei Pitis
.br
- pink@ulise.cs.pub.ro
.br
.B Politechnic University of Bucharest
.br
.B Romania
