/*
    Terminal interface header file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _TTY_H
#define _TTY_H


#include "termcap.h"


#define OFF			0
#define ON			1

#define BLACK			0
#define RED			1
#define GREEN			2
#define YELLOW			3
#define BLUE			4
#define MAGENTA			5
#define CYAN			6
#define WHITE			7


#define KEY_NOKEY		0000		/* No key (error)	*/

#define KEY_CTRL_H		0010		/* Ctrl-H		*/
#define KEY_TAB 	       	0011		/* Tab			*/
#define KEY_ENTER       	0012           	/* Enter		*/
#define KEY_ESC			0033		/* Esc			*/
#define KEY_SPACE		0040		/* Space		*/

#define KEY_BACKSPACE   	0177    	/* Backspace		*/


#define is_print(c)		((c) >= ' ' && (c) <= '~')


struct key_struct
{
    char *key_seq;
    struct key_struct *next;
    void *aux_data;
};


typedef struct 
{
    int	fg_color;
    int	bg_color;
    int	br_status;
    int	rv_status;
    unsigned char attribute;
} tty_status;


void tty_startup(void);
void tty_exit(void);
void tty_init(void);
void tty_end(void);
void tty_kbdinit(int mode);
void tty_clrscr(void);
void tty_touch(void);
void tty_cursormove(int y, int x);
void tty_cursormove_notify(int y, int x);
void tty_foreground(int color);
void tty_background(int color);
void tty_bright(int status);
void tty_reverse(int status);
void tty_blink(int status);
void tty_beep(void);
void tty_defaults(void);
void tty_save(tty_status *status);
void tty_restore(tty_status *status);
int  tty_write(char *buf, int length);
int  tty_read(char *buf, int length);
char tty_getch(void);
int  tty_putch(char c);
void tty_getsize(int *columns, int *rows);
void tty_getscreen(char *buf);
void tty_putscreen(char *buf);
int  tty_getcolorindex(char *colorname);
void tty_key_list_insert(char *key_seq, void *aux_data);
void tty_key_search_restart(void);
void tty_key_list_delete(void);

struct key_struct *tty_key_search(char *key_seq);
struct key_struct *tty_getkey(int *repeat_count);


#endif	/* _TTY_H */
