/* defaults.h: default values for ftp's common variables */

#ifndef _DEFAULTS_H_
#define _DEFAULTS_H_

#ifndef NEWMAILMESSAGE			/* For english speakers, "You have new mail." */
#define NEWMAILMESSAGE "You have new mail."
#endif

#ifndef ZCAT					/* Usually "zcat," but use the full pathname */
								/* if possible. */
#define ZCAT "zcat"
#endif

#ifndef MAX_XFER_BUFSIZE
#define MAX_XFER_BUFSIZE 32768
#endif

#ifndef dDEBUG					/* 1 or 0, usually 0 */
#define dDEBUG 0
#endif

#ifndef dMPROMPT				/* Usually 1, I prefer 0... */
#define dMPROMPT 0
#endif

#ifndef dVERBOSE				/* V_QUIET, V_ERRS, V_TERSE, V_VERBOSE */
#include "cmds.h"				/* for definitions of the above */
#define dVERBOSE V_TERSE
#endif

#ifndef dPROMPT					/* short: "@Bftp@P>" */
								/* long: "@B@E @UNcFTP@P @B@M@D@P ->" */
#define dPROMPT "@B@E @UNcFTP@P @B@M@D@P ->"
#endif

#ifndef dPAGER					/* if set to empty string, act like 'cat' */
#define dPAGER "more"
#endif

#ifndef dLOGNAME				/* put in the user's home directory. */
#define dLOGNAME ".ftplog"
#endif

								/* Do you want logging on by default? */
#ifndef dLOGGING				/* usually 0 */
#define dLOGGING 0
#endif

#ifndef dTYPE					/* usually TYPE_A */
#define dTYPE TYPE_A
#endif

#ifndef dTYPESTR				/* usually "ascii" */
#define dTYPESTR "ascii"
#endif

#ifndef dREDIALDELAY			/* usu. 60 (seconds). */
#define dREDIALDELAY 60
#endif

#ifndef CMDLINELEN
#define CMDLINELEN 256
#endif

#ifndef RECEIVEDLINELEN
#define RECEIVEDLINELEN 256
#endif

#ifndef MAXMACROS
#define MAXMACROS 16
#endif

#ifndef MACBUFLEN				/* usually 4096. */
#define MACBUFLEN 4096
#endif

/* Do you want binary transfers by default? */
#ifndef dAUTOBINARY				/* usually 1 */
#define dAUTOBINARY 1
#endif

#endif	/* _DEFAULTS_H_ */

/* eof */
