/*
 * USE_SETSID use setsid() instead of TCIONOCTTYY
 *
 * USE_TERMIOS uses the termios struct to control terminals.
 *   Comment this out if you want to use sgtty instead.
 * 
 * USE_FCNTL use fcntl() to set non blocking I/O as opposed to ioctl()'s.
 *
 * ERR_BLOCK sets the errno that is returned for an operation
 * that blocked.
 *
 * USE_VHANGUP says to run vhangup() on the new pty's.
 *
 * USE_TCATTR uses tc{get/set}attr() instead of ioctl's to set
 * termios.
 *
 * USE_SIGWINCH tells trsh to watch for SIGWINCH. Only define it if
 * your system supports it.
 *
 * USE_WINCHKILL if you sigwinch is broken, and doesn't send the
 * signal when the window size gets changed.
 *
 * USE_SETGID use setgid() instead of setregid()
 */

#ifdef linux
#define USE_SIGWINCH
#define USE_SETSID
#define USE_TERMIOS
#define USE_FCNTL
#define USE_NONBLOCK
#define USE_VHANGUP
#define USE_STRERROR
#define ERR_BLOCK  EAGAIN
/* #define USE_BSDJOBS */
#endif

#ifdef SVR4
#ifndef SYSV
# define SYSV
#endif
#define USE_SIGWINCH
#define USE_SETSID
#define USE_TERMIOS
#define USE_FCNTL
#define USE_NONBLOCK
#define USE_TCATTR
#define USE_STRERROR
#define ERR_BLOCK  EAGAIN
#define USE_SETGID
#endif

#ifdef SCO
#ifndef SYSV
#define SYSV
#endif
#define USE_SETSID
#define USE_FCNTL
#define USE_NONBLOCK
#define USE_TERMIOS
#define USE_NOBLOCK
#define USE_TCATTR
#define USE_STRERROR
#define USE_WINCHKILL
#define ERR_BLOCK EAGAIN
#define STREAMS_PIPE
#define X_STREAMS_PIPE
#ifndef NO_UNIX_DOMAIN
#define NO_UNIX_DOMAIN
#endif
#endif

#ifdef ultrix
#define USE_SIGWINCH
#define USE_TIOCNOTTY
#define USE_VHANGUP
#define USE_TERMIOS
#define USE_STRERROR
#define ERR_BLOCK EWOULDBLOCK
#endif

#ifdef NeXT
#define USE_VHANGUP
#define USE_FCNTL
#define USE_TCATTR
#define USE_STRERROR
#define ERR_BLOCK EWOULDBLOCK
#define USE_SIGWINCH
#define USE_TIOCNOTTY
#endif

#ifdef BSDI
#define USE_FCNTL
#define USE_TCATTR
#define USE_STRERROR
#define ERR_BLOCK EWOULDBLOCK
#define USE_SIGWINCH
#define USE_TIOCNOTTY
#endif

#ifndef SVR4
#if defined(sun) || defined(convex) || defined(__NetBSD__)
#define USE_SIGWINCH
#ifndef amiga
#define USE_VHANGUP
#endif
#define USE_TERMIOS
#define USE_NONBLOCK
#define USE_TCATTR
#ifdef sun
#define CONN_NONBLOCK
#define HAS_SETSID
#else
#define USE_FCNTL
#define USE_STRERROR
#endif
#define ERR_BLOCK EAGAIN
#define USE_SETPGRP
#ifdef sun
#define USE_WINCHKILL
#endif
#endif
#endif /* SVR4 was undefined */

#if defined(__hpux) 
#ifndef SIGWINCH
#define SIGWINCH SIGWINDOW 
#endif
#define USE_SIGWINCH
#define USE_STRERROR
#define USE_TERMIOS
#define USE_FCNTL
#define USE_NONBLOCK
#define USE_TCATTR
#define ERR_BLOCK EAGAIN
#define USE_SETSID
#define USE_SETGID
#endif

#ifdef _AIX
#define USE_SIGWINCH
#define USE_STRERROR
#define USE_TERMIOS
#define USE_FCNTL
#define USE_NONBLOCK
#define USE_TCATTR
#define ERR_BLOCK EAGAIN
#define USE_SETPGRP
#define USE_TIOCNOTTY
#endif

#ifdef sgi
#define	USE_SETSID
#define	USE_VHANGUP
#define USE_STRERROR
#define	USE_TERMIOS
#define	USE_FCNTL
#define	USE_NONBLOCK
#define	USE_TCATTR
#define ERR_BLOCK EAGAIN
#endif

#if defined(titan)
#define USE_VARARGS
#define	USE_SETIDS
#define NO_PTYEXEC
#else
#define USE_STRERROR
#endif

#ifndef BSDI
#if defined(BSD) || defined(___386BSD___) || defined(__386BSD__)
#if !defined(titan) && !defined(___386BSD___) && !defined(__386BSD__)
#define USE_VHANGUP
#endif
#define USE_FCNTL
#define USE_TCATTR
#define ERR_BLOCK EWOULDBLOCK
#define USE_SETPGRP
#define USE_SIGWINCH
#endif
#endif


#if defined(__OSF1__)  || defined(__OSF__) || defined(__osf__)
#define USE_FCNTL
#define USE_TCATTR
#define ERR_BLOCK EWOULDBLOCK
#define USE_SETPGRP
#define USE_SIGWI        
#undef USE_VHANGUP
#endif 

#ifdef hcx
/* Note that these defines only work correctly in the ucb universe. */
#define USE_FCNTL
#define USE_NONBLOCK
#define USE_SETSID
#define ERR_BLOCK EAGAIN
#define USE_SIGWINCH
#define USE_STRERROR
#ifdef att_universe
#define USE_VHANGUP
#define USE_TERMIOS
#define USE_TCATTR
#else /* ucb_universe */
#define NO_VSPRINTF
#endif
#endif

#ifndef seteuid
#define seteuid setuid
#endif

#ifndef setegid
#define setegid setgid
#endif

#if !defined(ERR_BLOCK) /* if no OS defined */
/* 
#error "Need to define an OS" 
Ultrix MIPS compiler chokes on this, even though ERR_BLOCK is defined!
*/
"Compilation directive: You need to define an OS"

/* If your OS isn't defined you need to work out which of the above defines */
/* you need and build and entry for it. Please send me the diff if you do so */
/* I am oreillym@tartarus.uwa.edu.au */
#endif

