/*
   Speedup routines

   Author: Dan Oscarsson    (Dan@dna.lth.se)
*/

#include <sys/param.h>
#ifndef _TYPES
 /* assume included by param.h */
# include <sys/types.h>
#endif
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <netat/appletalk.h>
#include <netat/compat.h>
#include "afps.h" 

#ifdef STAT_CACHE

struct statobj {
	char * NAME;
	struct stat STAT;
	int FN,RS;
	time_t	VAL_TIME;
};

#define VAL_OK 1
#define VAL_NO 0
#define VAL_INVALID 2

#define MAX_LEVEL 20

private struct statobj STATS[MAX_LEVEL+1];

private time_t CUR_TIME;


#define EXP_TIME 120;

private char CUR_DIR_STR[1024];
private char * CUR_DIR = NULL;
private int CUR_DIR_LEN;

OScd(path)
	char * path;
{
	if (CUR_DIR != NULL && strlen(path) == CUR_DIR_LEN-1 && strncmp(path,CUR_DIR,CUR_DIR_LEN-1) == 0)
		return;
	if (chdir(path) < 0)
		return;
	CUR_DIR = CUR_DIR_STR;
	strcpy(CUR_DIR,path);
	strcat(CUR_DIR,"/");
	CUR_DIR_LEN = strlen(CUR_DIR);
	if (DBOSI)
		printf("OScd=%s\n",CUR_DIR);
}

cwd_stat(path,buf)
	char * path;
	struct stat *buf;
{
	if (CUR_DIR != NULL && strncmp(path,CUR_DIR,CUR_DIR_LEN) == 0) {
		if (DBOSI)
			printf("OScwd_stat=%s\n",path+CUR_DIR_LEN);
		return(stat(path+CUR_DIR_LEN,buf));
	}
	if (DBOSI)
		printf("OScwd_stat=%s\n",path);
	return(stat(path,buf));
}

cwd_open(path,flags,mode)
	char * path;
	int flags,mode;
{
	if (CUR_DIR != NULL && strncmp(path,CUR_DIR,CUR_DIR_LEN) == 0)
		return(open(path+CUR_DIR_LEN,flags,mode));
	return(open(path,flags,mode));
}

char * cwd_path(path)
	char * path;
{
	if (DBOSI)
		printf("OScwd_path=%s\n",path+CUR_DIR_LEN);
	if (CUR_DIR != NULL && strncmp(path,CUR_DIR,CUR_DIR_LEN) == 0) {
		if (DBOSI)
			printf("OScwd_path=%s\n",path+CUR_DIR_LEN);
		return path+CUR_DIR_LEN;
	} else
		return path;
}

private release_stats(K)
	int K;
{
	int P;

	if (DBOSI)
		printf("release_stats=%d\n",K);

	for (P = K; STATS[P].NAME != NULL; P++) {
		free(STATS[P].NAME);
		STATS[P].STAT.st_nlink = -1;
		STATS[P].FN = VAL_INVALID;
		STATS[P].RS = VAL_INVALID;
		STATS[P].NAME = NULL;
	}
}

private int EXPIRE_REQ;

private expire_stats(K)
	int K;
{
	if (!EXPIRE_REQ)
		return;
	EXPIRE_REQ = 0;
	for (K = 0; STATS[K].NAME != NULL; K++) {
		if (STATS[K].VAL_TIME > CUR_TIME) {
			STATS[K].STAT.st_nlink = -1;
			STATS[K].FN = VAL_INVALID;
			STATS[K].RS = VAL_INVALID;
			if (DBOSI)
				printf("expired=%d(%s)\n",K,STATS[K].NAME);
		}
	}
}

private char * newstr(STR)
	char * STR;
{
	char * P;

	P = (char *) malloc(strlen(STR)+1);
	if (P != NULL) {
		strcpy(P,STR);
		return P;
	}
	return NULL;
}

private struct statobj * locate_statobj(path)
	char * path;
{
	char STR[1024];
	char * PART[20];
	int K,P,LC;
	char * S;

	if (*path != '/' || strcmp(path,"/") == 0)
		return NULL;
	strcpy(STR,path);
	S = STR+1;
	K = 0;
	PART[K] = S;
	while ((S = (char*)index(S,'/')) != NULL) {
		*S++ = NULL;
		PART[++K] = S;
		if (K >= MAX_LEVEL)
			return NULL;
	}
	LC = K+1;
	expire_stats();
	
	for (K = 0; K < LC && STATS[K].NAME != NULL && strcmp(STATS[K].NAME,PART[K]) == 0; K++);
	if (K == LC) {
		K--;
		return &STATS[K];
	} else {
		release_stats(K);
		for (P = K; P < LC; P++) {
			STATS[P].NAME = newstr(PART[P]);
			STATS[P].STAT.st_nlink = -1;
			STATS[P].FN = VAL_INVALID;
			STATS[P].RS = VAL_INVALID;
		}
		return &STATS[LC-1];
	}
}
	
OSstat(path,buf)
	char * path;
	struct stat *buf;
{
	struct stat B;
	struct statobj * CE;

	if (DBOSI)
		printf("OSstat=%s\n",path);

	CE = locate_statobj(path);
	if (CE != NULL) {
		if (CE->STAT.st_nlink != -1) {
			if (DBOSI)
				printf("OSstat=cache path\n");
			bcopy(&CE->STAT,buf,sizeof(struct stat));
			return 0;
		}
		if (cwd_stat(path,&B) == 0) {
			if (DBOSI)
				printf("OSstat=caching path\n");
			bcopy(&B,&CE->STAT,sizeof(struct stat));
			CE->VAL_TIME = CUR_TIME+EXP_TIME;
			bcopy(&B,buf,sizeof(struct stat));
			return 0;
		}
		return -1;
	}
	if (DBOSI)
		printf("OSstat=not cached\n");
	return cwd_stat(path,buf);
}

OSfinderinfo(path)
	char * path;
{
	char pp[MAXPATHLEN];
	struct stat S;
	struct statobj * CE;

	CE = locate_statobj(path);
	if (CE != NULL) {
		if (CE->FN != VAL_INVALID)
			return CE->FN;
		strcpy(pp,path);
		toFinderInfo(pp,"");
		if (cwd_stat(pp,&S) < 0 || !S_ISDIR(S.st_mode))
			CE->FN = VAL_NO;
		else
			CE->FN = VAL_OK;
		CE->VAL_TIME = CUR_TIME+EXP_TIME;
		return CE->FN;
	}
	strcpy(pp,path);
	toFinderInfo(pp,"");
	if (cwd_stat(pp,&S) < 0 || !S_ISDIR(S.st_mode))
		return 0;
	else
		return 1;
}

OSresourcedir(path)
	char * path;
{
	char pp[MAXPATHLEN];
	struct stat S;
	struct statobj * CE;

	CE = locate_statobj(path);
	if (CE != NULL) {
		if (CE->RS != VAL_INVALID)
			return CE->RS;
		strcpy(pp,path);
		toResFork(pp,"");
		if (cwd_stat(pp,&S) < 0 || !S_ISDIR(S.st_mode))
			CE->RS = VAL_NO;
		else
			CE->RS = VAL_OK;
		CE->VAL_TIME = CUR_TIME+EXP_TIME;
		return CE->RS;
	}
	strcpy(pp,path);
	toResFork(pp,"");
	if (cwd_stat(pp,&S) < 0 || !S_ISDIR(S.st_mode))
		return 0;
	else
		return 1;
}

OSflush_stat()
{
	time(&CUR_TIME);
	if (DBOSI)
		printf("OSflush_stat\n");
	release_stats(0);
}

OSstat_cache_update()
{
	time(&CUR_TIME);
	EXPIRE_REQ = 1;
}

#endif STAT_CACHE
