/* Stuff specific to the 3-Com 3C503 Ethernet controller board
 *
 * Symbol prefix "EN" is for Ethernet, National chip
 * Symbol prefix "E33" is for _E_thernet, _3_Com 50_3_
 * Symbol prefix "E33G" is for registers in the Gate array ASIC.
 *
 * The E33 registers - For the ASIC on the 3C503 card:
 * Offsets from the board's base address, which can be set by
 * jumpers to be one of the following 8 values (hex):
 *  350, 330, 310, 300, 2E0, 2A0, 280, 250
 * Factory default address is 300H.
 * The card occupies a block of 16 I/O addresses.
 * It also occupies 16 addresses at base+400 through base+40F.
 * These high-addressed registers are in the ASIC.
 * Recall that the normal PC I/O decoding is only 10 bits. The 11'th
 * bit (400H) can be used on the same card for additional registers.
 * This offset requires word, not byte, arithmetic on the DX register.
 *
 * The card can also be jumpered to have the shared memory disabled
 * or enabled at one of four addresses: C8000, CC000, D8000 or DC000.
 * This version of the driver REQUIRES the shared memory to be 
 * enabled somewhere.
 * The card can be operated using direct I/O instructions or by
 * using the PC's DMA channels instead of the shared memory, but
 * the code for those other two methods is not included.
 * They would be needed in a system where all four possible addresses
 * for the shared memory are in use by other devices.
 */

#if (ETHERNET == ETH_3C503)

/* Blocks of I/O addresses: */

#define E33GA		0x0400	/* Registers in the gate array. */
#define E33_SAPROM	0x0000	/* Window on station addr prom
				 * (if E33G_CNTRL bits 3,2 = 0,1)
				 */

/* These appear at Base+0 through Base+0F when bits 3,2
 * of E33G_CNTRL are 0,0.
 */

#define EN_OFF		0x00	/* 8390 chip offset */

#define ENDCFG_BM8	0x48

/* Registers in the 3-Com custom Gate Array */

#define E33G_STARTPG	 E33GA+0x00	/* Start page, must match EN0_STARTPG */
#define E33G_STOPPG	 E33GA+0x01	/* Stop  page, must match EN0_STOPPG */
#define E33G_NBURST	 E33GA+0x02	/* Size of DMA burst before relinquishing bus */
#define E33G_IOBASE	 E33GA+0x03	/* Bit coded: where I/O regs are jumpered. */
				/* (Which you have to know already to read it) */
#define E33G_ROMBASE	 E33GA+0x04	/* Bit coded: Where/whether EEPROM&DPRAM exist */
#define E33G_GACFR	 E33GA+0x05	/* Config/setup bits for the ASIC GA */
#define E33G_CNTRL	 E33GA+0x06	/* Board's main control register */
#define E33G_STATUS	 E33GA+0x07	/* Status on completions. */
#define E33G_IDCFR	 E33GA+0x08	/* Interrupt/DMA config register */
				/* (Which IRQ to assert, DMA chan to use) */
#define E33G_DMAAH	 E33GA+0x09	/* High byte of DMA address reg */
#define E33G_DMAAL	 E33GA+0x0a	/* Low byte of DMA address reg */
#define E33G_VP2	 E33GA+0x0b	/* Vector pointer - for clearing RAM select */
#define E33G_VP1	 E33GA+0x0c	/*  on a system reset, to re-enable EPROM. */
#define E33G_VP0	 E33GA+0x0d	/*  3Com says set this to Ctrl-Alt-Del handler */
#define E33G_FIFOH	 E33GA+0x0e	/* FIFO for programmed I/O data moves ... */
#define E33G_FIFOL	 E33GA+0x0f	/* .. low byte of above. */

/* Bits in E33G_CNTRL register: */

#define ECNTRL_RESET	0x01	/* Software reset of the ASIC and 8390 */
#define ECNTRL_THIN	0x02	/* Onboard thin-net xcvr enable */
#define ECNTRL_SAPROM	0x04	/* Map the station address prom */
#define ECNTRL_DBLBFR	0x20	/* FIFO configuration bit */
#define ECNTRL_OUTPUT	0x40	/* PC-to-3C503 direction if 1 */
#define ECNTRL_START	0x80	/* Start the DMA logic */

/* Bits in E33G_STATUS register: */

#define ESTAT_DPRDY	0x80	/* Data port (of FIFO) ready */
#define ESTAT_UFLW	0x40	/* Tried to read FIFO when it was empty */
#define ESTAT_OFLW	0x20	/* Tried to write FIFO when it was full */
#define ESTAT_DTC	0x10	/* Terminal Count from PC bus DMA logic */
#define ESTAT_DIP	0x08	/* DMA In Progress */

/* Bits in E33G_GACFR register: */

#define EGACFR_NORM	0x49	/* Enable 8K shared mem, no DMA TC int */
#define EGACFR_IRQOFF	0xc9	/* Above, and disable 8390 IRQ line */

/* Shared memory management parameters */

#define SM_TSTART_PG	0x20	/* First page of TX buffer */
#define SM_RSTART_PG	0x26	/* Starting page of RX ring */
#define SM_RSTOP_PG	0x40	/* Last page +1 of RX ring */

/* End of 3C503 parameter definitions */

#endif /* 3C503 stuff */
