! exported symbols

.define begtext, _exit, _bios_putk, _bios_getk
.define _p_memsize, _HD_read, _dmaoverrun, _hdparam
.define begdata
.define begbss

! imported symbols

.text
.extern _main, _setparam
.data
.extern _edata, _boot_parameters, _errors
.bss
.extern _end

STACKSIZE = 8192

.text
#ifndef ASLD
entry crtso
#endif

begtext:
crtso:
start:
	mov	dx,bx		! save boot info.
	xor	ax,ax
	mov	bx,#_edata	! prepare to clear bss
	mov	cx,#_end
	sub	cx,bx
	sar	cx,*1
st.1:	mov	(bx),ax		! clear bss
	add	bx,#2
	loop	st.1

	mov	sp,#menustack+STACKSIZE	! bug: the stack was "random" before
				! this sort of works because interrupts
				! are off now
	sti			! turn on interrupts
				! this was not done explicitly in version 1.5
				! it must have been done as a side affect of
				! a BIOS call
	cmp	virgin,#0
	jz	menu

	mov	virgin,#0
	push	dx
	movb	al,dh
	push	ax		! boot drive
	movb	al,dl
	push	ax		! boot partition
	call	_setparam
	pop	ax
	pop	ax		! drop args
	pop	dx

#ifdef QUIET
	orb	dh,dh
	jz	menu
	cmp	_errors,#0
	jnz	menu
	movb	ah,*2
	int	0x16
	mov	bx,#_boot_parameters
	mov	bx,6(bx)		! boot_parameters.bp_scancode
	andb	al,*3
	jz	jmp_ker
#endif
menu:
	call	_main
	mov	bx,ax		! put scan code for '=' in bx
jmp_ker:
	xor	ax,ax
	mov	es,ax
	seg	es
	testb	0x043f,*0x0F
	jz	L001
	mov	dx,#0x3F2
	movb	al,*0x0C
	out
L001:	sub	ax,ax		! ax == 0 to show new boot (was scan code)
	mov	si,#_boot_parameters	! pointer to boot parameters in di:si
	mov	di,ds
	mov	cx,#10		! sizeof structure in cx
				! next 'cli' and setting up segs is redundant
				! and the segments are wrong for sep I&D
	cli
	mov	dx,#0x60
	mov	ds,dx
	mov	es,dx
	mov	ss,dx
	jmpf	0,0x60		! jmp to kernel

_exit:	jmp	start


_bios_putk:
	xor	ax,ax
	call	csv
	movb	al,4(bp)	! al contains char to be printed
	movb	ah,#14		! 14 = print char
	mov	bx,#0x0001	! graphics foreground color 1, text page 0
	push	bp		! not preserved
	int	0x10		! call BIOS VIDEO_IO
	pop	bp
	jmp	cret

_bios_getk:
	xorb	ah,ah		! 0 = read char from keyboard
	int	0x16		! call BIOS keyboard driver
	ret			! ASCII code in al, scan code in ah

csv:
	pop	bx
	push	bp
	mov	bp,sp
	push	di
	push	si
	sub	sp,ax
	jmp	(bx)

cret:
	lea	sp,*-4(bp)
	pop	si
	pop	di
	pop	bp
	ret

_p_memsize:	push	sp			! get extended memory size
		pop	ax
		cmp	ax,sp
		jz	i80x86
		xor	ax,ax
		ret
i80x86:		movb	ah,*0x88
		int	0x15
		ret

_dmaoverrun:	push	bp			! check DMA overrun
		mov	bp,sp
		mov	ax,ds
		movb	cl,*4
		shl	ax,cl
		add	ax,4(bp)
		add	ax,#1024 - 1
		mov	ax,#0
		jnc	dma_ok
		inc	ax
dma_ok:		pop	bp
		ret

!	HD_read(int drive, char *buff, long offset);
_HD_read:	push	bp
		mov	bp,sp
		push	di
		mov	di,#0x80
hd_read1:	mov	ax, 8(bp)	! offset Low
		mov	dx,10(bp)	! offset Hi
		div	cyl_size
		movb	ch,al		! cylinder number
		shr	ax,*1
		shr	ax,*1
		andb	al,*0xC0
		movb	cl,al		! cylinder-H
		mov	ax,dx
		xor	dx,dx
		div	trk_size
		movb	dh,al		! head address
		incb	dl		! sector start from 1
		orb	cl,dl		! cylinder + sector
		movb	dl,4(bp)	! drive
		mov	bx,6(bp)	! buffer address
		mov	ax,#0x0202	! read 1 block
		int	0x13
		jc	hd_retry
		mov	ax,1
		pop	di
		pop	bp
		ret

hd_retry:	shr	di,*1
		jc	dskerr
		movb	dl,4(bp)
		xor	ax,ax		! reset HDC
		int	0x13
		j	hd_read1
		pop	di
dskerr:		xor	ax,ax
		pop	bp
		ret

_hdparam:	push	bp
		mov	bp,sp
		movb	dl,4(bp)
		orb	dl,*0x80
		movb	ah,*8			! get drive parameter
		int	0x13
		jc	dskerr
		incb	dh			! heads
		andb	cl,*0x3F
		movb	trk_size,cl		! sectors / track
		xchg	ax,cx
		mulb	dh
		mov	cyl_size,ax		! sectors / cylinder
		pop	bp
		ret

.data
begdata:
cyl_size:	.data2	0
trk_size:	.data2	0
virgin:		.data2	1

.bss
begbss:
menustack:	.zerow STACKSIZE/2
