| int88.s

| exported routines

	.define	_db
	.define	_dbinit
	.define _exit		| DOS only
	.define	.fat		| DOS only & Minix cc only
	.define	_main		| DOS only

| imported routines

	.extern	_db_main

| exported variables

	.define	begdata		| DOS only & Minix cc only
	.define	begbss		| DOS only & Minix cc only
	.define	_db_stacktop	| temp exported for 386 protected mode init

| imported variables

	.data
	.extern	_db_processor	| processor type 86, 186, 286, 386
	.extern	_edata
	.extern	_end
	.extern	_protected

BIOS_DATA_SEG	=	0x40
  KB_FLAG	=	0x17	| byte
    ALT_SHIFT	=	8	| state bits
    CTL_SHIFT	=	4
    LEFT_SHIFT	=	2
BREAK_VECTOR	=	4*3	| offset for breakpoint interrupt vector
CLICK_SHIFT	=	4	| log2 CLICK_SIZE
CLICK_SIZE	=	16	| allocation unit for TSR's
COM_OFFSET	=	0x100	| offset of program in an MS DOS .COM file
| DB_DS		=	4	| db data seg held here in kernel code seg
FARI1_CALL	=	0xFF	| as386 doesn't have far indirect calls yet
FARI2_CALL	=	0x1E
KEYBOARD_VECTOR	=	4*9	| PC BIOS hardware keyboard interrupt number
MS_DOS		=	0x21	| MS DOS main software interrupt number
  TSR		=	0x31
OS		=	0x66	| operand size override for 386
PE		=	0x00000001	| protected mode cr0 flag bit for 386
SSTEP_VECTOR	=	4*1	| offset for single step interrupt vector
STACK_SIZE	=	256
TF		=	0x0100	| trap bit in flags
VECTOR_SEG	=	0	| segment for interrupt vectors

	.text

.space	COM_OFFSET	| DOS only (COM program)

| enter here for startup code (DOS only)

_main:				| DOS only
	jmp	dos_init

| call this to enter db
| initialisation is done automatically

_db:
	call	_dbinit
	int	BREAK_VECTOR/4
	ret

_dbinit:
	pushf
	push	ax
	call	_get_processor
	cmp	ax,#386
	jne	db_setvect	| only support protected mode for 386
|	push	eax
	.byte	OS
	push	ax
|	mov	eax,cr0
	.byte	0x0F,0x20,0xC0
	andb	al,#PE
|	pop	eax
	.byte	OS
	pop	ax
	jne	over_db_setvect	| protected init is too hard here, assume it
db_setvect:
	push	ds
	call	setvect
	pop	ds
over_db_setvect:
	pop	ax
	popf
	ret

setvect:
	mov	ax,#VECTOR_SEG
	mov	ds,ax
	mov	ax,#sstep_int
	cli
	mov	SSTEP_VECTOR,ax
	mov	SSTEP_VECTOR+2,cs
	mov	ax,#break_int
	mov	BREAK_VECTOR,ax
	mov	BREAK_VECTOR+2,cs
	ret			| leave ds = VECTOR_SEG and cli

| enter here for hardware keyboard int (DOS only)
| do a breakpoint if CTRL - ALT - LEFT_SHIFT

kb_int:
	pushf
	seg	cs
|	call	far old_kb_vector
	.byte	FARI1_CALL
	.byte	FARI2_CALL
	.word	old_kb_vector
	push	ax
	push	ds
	mov	ax,*BIOS_DATA_SEG
	mov	ds,ax
	movb	al,KB_FLAG
	andb	al,*CTL_SHIFT+ALT_SHIFT+LEFT_SHIFT
	cmpb	al,*CTL_SHIFT+ALT_SHIFT+LEFT_SHIFT
	pop	ds
	pop	ax
	jnz	db_iret

| enter here from software breakpoint int

break_int:
	seg	cs
	sarb	db_enable,*1	| test and set to 0xFF
	jc	db_iret		| it was and remains set at 0xFF
	seg	cs
	movb	is_sstep,*0
	j	db_int

db_iret:
	iret

| enter here from hardware single step int

sstep_int:
	seg	cs
	sarb	db_enable,*1
	jc	db_iret
	seg	cs
	movb	is_sstep,*1

| common entry point
| this code writes to the code segment, so only works in real mode (286/386)
| it also assumes operand size == 16, again limiting it to real mode
| but it decides if the processor is a 386 and records 32 bit registers if so

| go through lots of contortions to avoid using current stack
| an earlier version of db attempted to be reentrant by switching the
| stack, but that is not feasible because there are too many global
| variables (like 8K of screen buffers!) which would have to be switched too

db_int:
	seg	cs
	mov	old_ds,ds
	seg	cs
	mov	ds,DB_DS
	pop	old_ip		| set up sp:ss:ip:cs:f at top of local stack
	pop	old_cs
	pop	old_f
	mov	old_sp,sp
	mov	old_ss,ss
	seg	cs
	mov	ss,DB_DS
	mov	sp,#stacktop

	push	es		| continue setting up local stack
	seg	cs
	push	old_ds
	push	zero		| place holder (prepare for not 80386)
	push	bp
	pushf			| test trace flag
	pop	bp		| it should be clear (was cleared by int)
	and	bp,*TF		| but if int is traced it will be set
	jnz	to_db_exit	| resist attempt to trace self or breakpoint

	push	ax
	call	_get_processor
	mov	_db_processor,ax
	cmp	ax,#386
	pop	ax
	jne	save16

| 386, fix up saved flags, ip, sp and bp to 32 bits
| then save rest of (full 32 bit) regs

	.byte	OS		| operand size override to 32 bits
	pushf			| top 16 bits of old flags are current
	add	sp,*2		| discard non-current low 16 bits
	pop	old_f+2
	mov	old_ip+2,*0	| it's too hard to get at ip, assume top is 0
	.byte	OS
	push	sp
	add	sp,*2
	pop	old_sp+2	| this should be 0 too
	pop	bp
	add	sp,*2
	.byte	OS
	push	bp

	.byte	OS
	push	di
	.byte	OS
	push	si
	.byte	OS
	push	dx
	.byte	OS
	push	cx
	.byte	OS
	push	bx
	.byte	OS
	push	ax
	j	call_C

to_db_exit:
	j	db_exit

save16:
	sub	bp,bp
	push	bp
	push	di
	push	bp
	push	si
	push	bp
	push	dx
	push	bp
	push	cx
	push	bp
	push	bx
	push	bp
	push	ax

call_C:
	cld			| direction UP for C
	mov	ax,ds
	mov	es,ax		| es == ds for C
	seg	cs
	push	is_sstep
	call	_db_main
	add	sp,*2

	cmp	_db_processor,#386
	jnz	restore16
	.byte	OS
	pop	ax
	.byte	OS
	pop	bx
	.byte	OS
	pop	cx
	.byte	OS
	pop	dx
	.byte	OS
	pop	si
	.byte	OS
	pop	di
	.byte	OS
	pop	bp
	seg	cs
	pop	old_ds
	pop	es
	mov	ss,old_ss
	.byte	OS		| fatal if no longer 16 bits?
	mov	sp,old_sp
	j	db_1exit

restore16:
	pop	ax
	add	sp,*2
	pop	bx
	add	sp,*2
	pop	cx
	add	sp,*2
	pop	dx
	add	sp,*2
	pop	si
	add	sp,*2
	pop	di
	add	sp,*2
db_exit:
	pop	bp
	add	sp,*2
	seg	cs
	pop	old_ds
	pop	es
	mov	ss,old_ss
	mov	sp,old_sp

db_1exit:
	push	old_f
	push	old_cs
	push	old_ip
	seg	cs
	mov	ds,old_ds
	seg	cs
	shlb	db_enable,*1	| unset to 0xFE
	jmp	db_iret

| some variables are in code seg for more convenient (probably faster) access

db_enable:
	.byte	0xFE		| special value for test-and-set flag
	.even
DB_DS:				| DOS only
	.zerow	1
is_sstep:
	.word	0		| top half is constant 0
old_ds:
	.zerow	1
old_kb_vector:
	.zerow	2

| dos_init is only used for DOS initialisation
| it becomes a safe overflow error for the stack

dos_init:
	mov	DB_DS,ds
	mov	di,#_edata
	mov	cx,#_end
	sub	cx,di
	subb	al,al
	cld
	rep
	stob
	call	setvect		| returns ds = VECTOR_SEG and cli
	les	ax,KEYBOARD_VECTOR
	seg	cs
	mov	old_kb_vector,ax
	seg	cs
	mov	old_kb_vector+2,es
	mov	ax,#kb_int
	mov	KEYBOARD_VECTOR,ax
	mov	KEYBOARD_VECTOR+2,cs
	sti
	mov	dx,#_end+CLICK_SIZE-1
	movb	cl,*CLICK_SHIFT
	shr	dx,cl
	movb	ah,*TSR
	int	MS_DOS
	ret

_exit:				| DOS only - should never be called
.fat:				| DOS only - should never be called
	j	_exit		| DOS only

	.data
	.even
begdata:			| DOS only & Minix cc only
zero:
	.word	0
stack:
	.space	STACK_SIZE
stacktop:
old_sp:				| following "old" variables are really on stack
	.zerow	1		| and order is important
	.word	0
old_ss:
	.zerow	1
old_ip:
	.zerow	1
	.word	0
old_cs:
	.zerow	1
old_f:
	.zerow	1
	.word	0
_db_stacktop:

	.bss
begbss:				| DOS only & Minix cc only
