/* unasm.c */

#define Ib() outget8()
#define Iw() outget16()

typedef int su8_pt;
typedef int su16_t;

#include "const.h"
#include "type.h"
#include "var.h"
#include "/usr/include/a.out.h"		/* full pathname to get right one! */

#define LINDIRECT '['
#define RINDIRECT ']'

#define BASE_MASK 0x07
#define INDEX_MASK 0x38
#define INDEX_SHIFT 3
#define MOD_MASK 0xC0       /* mod reg r/m  is  mmrrr/// */
# define REG_MOD 0xC0
# define MEM0_MOD 0x00
# define MEM1_MOD 0x40
# define MEM2_MOD 0x80
#define REG_MASK 0x38
#define REG_SHIFT 3
#define RM_MASK 0x07
#define SREG_MASK 0x38
#define SREG_SHIFT 3
#define SS_MASK 0xC0
#define SS_SHIFT 6

#define SIGNBIT 0x02        /* opcode bits xxxxxxsw for immediates */
#define WORDBIT 0x01
#define TOREGBIT 0x02       /* opcode bit for non-immediates */

#define MAX_SIGNED_CHAR 0x7F  /* will assume 2's complement */
#define MAX_UNSIGNED_CHAR 0xFF

FORWARD void i_00_to_3f();
FORWARD void i_40_to_5f();
FORWARD void i_60_to_6f();
FORWARD void i_70_to_7f();
FORWARD void i_80();
FORWARD void i_88();
FORWARD void i_90();
FORWARD void i_98();
FORWARD void i_a0();;
FORWARD void i_a8();
FORWARD void i_b0();
FORWARD void i_b8();
FORWARD void i_c0();
FORWARD void i_c8();;
FORWARD void i_d0();
FORWARD void i_d8();;
FORWARD void i_e0();
FORWARD void i_e8();
FORWARD void i_f0();
FORWARD void i_f8();

PRIVATE pfv_t optable[] =
{
	i_00_to_3f,
	i_00_to_3f,
	i_00_to_3f,
	i_00_to_3f,
	i_00_to_3f,
	i_00_to_3f,
	i_00_to_3f,
	i_00_to_3f,
	i_40_to_5f,
	i_40_to_5f,
	i_40_to_5f,
	i_40_to_5f,
	i_60_to_6f,
	i_60_to_6f,
	i_70_to_7f,
	i_70_to_7f,
	i_80,
	i_88,
	i_90,
	i_98,
	i_a0,
	i_a8,
	i_b0,
	i_b8,
	i_c0,
	i_c8,
	i_d0,
	i_d8,
	i_e0,
	i_e8,
	i_f0,
	i_f8
};

PRIVATE char bttab[] = "bt\t";
PRIVATE char btctab[] = "btc\t";
PRIVATE char btrtab[] = "btr\t";
PRIVATE char btstab[] = "bts\t";
PRIVATE char calltab[] = "call\t";
PRIVATE char dectab[] = "dec\t";
PRIVATE char empty[] = "";

PRIVATE char f2xm1[] = "f2xm1";
PRIVATE char fabs[] = "fabs";
PRIVATE char fadd[] = "fadd";
PRIVATE char faddp[] = "faddp";
PRIVATE char fbld[] = "fbld";
PRIVATE char fbstp[] = "fbstp";
PRIVATE char fchs[] = "fchs";
PRIVATE char fclex[] = "fclex";
PRIVATE char fcom[] = "fcom";
PRIVATE char fcomp[] = "fcomp";
PRIVATE char fdecstp[] = "fdecstp";
PRIVATE char fdisi[] = "fdisi";
PRIVATE char fdiv[] = "fdiv";
PRIVATE char fdivp[] = "fdivp";
PRIVATE char fdivr[] = "fdivr";
PRIVATE char fdivrp[] = "fdivrp";
PRIVATE char feni[] = "feni";
PRIVATE char ffree[] = "ffree";
PRIVATE char fiadd[] = "fiadd";
PRIVATE char ficom[] = "ficom";
PRIVATE char ficomp[] = "ficomp";
PRIVATE char fidiv[] = "fidiv";
PRIVATE char fidivr[] = "fidivr";
PRIVATE char fild[] = "fild";
PRIVATE char fimul[] = "fimul";
PRIVATE char fincstp[] = "fincstp";
PRIVATE char finit[] = "finit";
PRIVATE char fist[] = "fist";
PRIVATE char fistp[] = "fistp";
PRIVATE char fisub[] = "fisub";
PRIVATE char fisubr[] = "fisubr";
PRIVATE char fld[] = "fld";
PRIVATE char fld1[] = "fld1";
PRIVATE char fldcw[] = "fldcw";
PRIVATE char fldenv[] = "fldenv";
PRIVATE char fldl2e[] = "fldl2e";
PRIVATE char fldl2t[] = "fldl2t";
PRIVATE char fldlg2[] = "fldlg2";
PRIVATE char fldln2[] = "fldln2";
PRIVATE char fldpi[] = "fldpi";
PRIVATE char fldz[] = "fldz";
PRIVATE char fmul[] = "fmul";
PRIVATE char fmulp[] = "fmulp";
PRIVATE char fnop[] = "fnop";
PRIVATE char fpatan[] = "fpatan";
PRIVATE char fprem[] = "fprem";
PRIVATE char fptan[] = "fptan";
PRIVATE char frndint[] = "frndint";
PRIVATE char frstor[] = "frstor";
PRIVATE char fsave[] = "fsave";
PRIVATE char fscale[] = "fscale";
PRIVATE char fsqrt[] = "fsqrt";
PRIVATE char fst[] = "fst";
PRIVATE char fstcw[] = "fstcw";
PRIVATE char fstenv[] = "fstenv";
PRIVATE char fstp[] = "fstp";
PRIVATE char fstsw[] = "fstsw";
PRIVATE char fsub[] = "fsub";
PRIVATE char fsubp[] = "fsubp";
PRIVATE char fsubr[] = "fsubr";
PRIVATE char fsubrp[] = "fsubrp";
PRIVATE char ftst[] = "ftst";
PRIVATE char fxam[] = "fxam";
PRIVATE char fxch[] = "fxch";
PRIVATE char fxtract[] = "fxtract";
PRIVATE char fyl2x[] = "fyl2x";
PRIVATE char fyl2xp1[] = "fyl2xp1";

PRIVATE char fishy[] = "???";
PRIVATE char fishytab[] = "???\t";
PRIVATE char imultab[] = "imul\t";
PRIVATE char intab[] = "in\t";
PRIVATE char inctab[] = "inc\t";
PRIVATE char jmptab[] = "jmp\t";
PRIVATE char movtab[] = "mov\t";
PRIVATE char movsxtab[] = "movsx\t";
PRIVATE char movzxtab[] = "movzx\t";
PRIVATE char pushtab[] = "push\t";
PRIVATE char s_outtab[] = "out\t";
PRIVATE char shldtab[] = "shld\t";
PRIVATE char shrdtab[] = "shrd\t";
PRIVATE char testtab[] = "test\t";
PRIVATE char xchgtab[] = "xchg\t";

PRIVATE char *genreg[] =
{
	"al",	"cl",	"dl",	"bl",
	"ah",	"ch",	"dh",	"bh",
	"ax",	"cx",	"dx",	"bx",
	"sp",	"bp",	"si",	"di",
	"eax",	"ecx",	"edx",	"ebx",
	"esp",	"ebp",	"esi",	"edi"
};
PRIVATE char *segreg[] =
{
	"es",	"cs",	"ss",	"ds",
	"fs",	"gs",	"?s",	"?s",
};
PRIVATE char *indreg[] =
{
	"bx+si",	"bx+di",	"bp+si",	"bp+di",
	"si",	"di",	"bp",	"bx",
};

PRIVATE char *str_00_to_3f[] =
{
	/* index by (opcode >> 3) & 7 */
	"add",	"or",	"adc",	"sbb",
	"and",	"sub",	"xor",	"cmp"
};
PRIVATE char *sstr_00_to_3f[] =
{
	/* index ((opc>>2) & 0xE) + (opc & 7) - 6 */
	"push\tes",	"pop\tes",	"push\tcs",	"pop\tcs",
	"push\tss",	"pop\tss",	"push\tds",	"pop\tds",
	"es:",	"daa",	"cs:",	"das",
	"ss:",	"aaa",	"ds:",	"aas"
};
PRIVATE char *sstr_0f[] =
{
	"push\tfs",	"pop\tfs",	fishy,	bttab,
	shldtab,	shldtab,	fishy,	fishy,
	"push\tgs",	"pop\tgs",	fishy,	btstab,
	shrdtab,	shrdtab,	fishy,	imultab,
	fishy,	fishy,	"lss\t",	btrtab,
	"lfs\t",	"lgs\t",	movzxtab,	movzxtab,
	fishy,	fishy,	empty,	btctab,
	"bsf\t",	"bsr\t",	movsxtab,	movsxtab
};
PRIVATE char *ssstr_0f[] =
{
	"sldt\t",	"str\t",	"lldt\t",	"ltr\t",
	"verr\t",	"verw\t", fishy, fishy,
	"sgdt\t",	"sidt\t",	"lgdt\t",	"lidt\t",
	"smsw\t",	fishy, "lmsw\t", fishy,
	fishy,	fishy, fishy,	fishy,
	bttab,	btstab,	btrtab,	btctab
};
PRIVATE char *str_40_to_5f[] =
{
	/* index by (opcode >> 3) & 3 */
	inctab,	dectab,	pushtab,	"pop\t"
};
PRIVATE char *str_60_to_6f[] =
{
	"pusha",	"popa",	"bound\t",	"arpl\t",
	"fs:",	"gs:",	"os:",	"as:",
	pushtab,	imultab,	pushtab,	imultab,
	"insb",	"insw",	"outsb",	"outsw"
};
PRIVATE char *str_flags[] =
{
	/* opcodes 0x70 to 0x7F, and 0x0F80 to 0x0F9F */
	"o",	"no",	"b",	"nb",
	"z",	"nz",	"be",	"a",
	"s",	"ns",	"pe",	"po",
	"l",	"ge",	"le",	"g"
};
PRIVATE char *str_98[] =
{
	"cbw",	"cwd",	calltab,	"wait",
	"pushf",	"popf",	"sahf",	"lahf"
};
PRIVATE char *str_a0[] =
{
	movtab,	movtab,	movtab,	movtab,
	"movsb",	"movsw",	"cmpsb",	"cmpsw"
};
PRIVATE char *str_a8[] =
{
	testtab,	testtab,	"stosb",	"stosw",
	"lodsb",	"lodsw",	"scasb",	"scasw"
};
PRIVATE char *str_c0[] = 
{
	empty,	empty,	"ret\t",	"ret",
	"les\t",	"lds\t",	movtab,	movtab
};
PRIVATE char *str_c8[] =
{
	"enter\t",	"leave",	"retf\t",	"retf",
	"int\t3",	"int\t",	"into",	"iret"
};
PRIVATE char *str_d0[] =
{
	"aam",	"aad",	"db\td6",	"xlat"
};
PRIVATE char *sstr_d0[] =
{
	"rol",	"ror",	"rcl",	"rcr",
	"shl",	"shr",	fishy,	"sar"
};
PRIVATE char *str_d8[] =
{
	fadd,	fmul,	fcom,	fcomp,
	fsub,	fsubr,	fdiv,	fdivr,
	fld,	NULL,	fst,	fstp,
	fldenv,	fldcw,	fstenv,	fstcw,
	fiadd,	fimul,	ficom,	ficomp,
	fisub,	fisubr,	fidiv,	fidivr,
	fild,	NULL,	fist,	fistp,
	NULL,	fld,	NULL,	fstp,
	fadd,	fmul,	fcom,	fcomp,
	fsub,	fsubr,	fdiv,	fdivr,
	fld,	NULL,	fst,	fstp,
	frstor,	NULL,	fsave,	fstsw,
	fiadd,	fimul,	ficom,	ficomp,
	fisub,	fisubr,	fidiv,	fidivr,
	fild,	NULL,	fist,	fistp,
	fbld,	fild,	fbstp,	fistp
};
PRIVATE char *str1_d8[] =
{
	fadd,	fmul,	fcom,	fcomp,
	fsub,	fsubr,	fdiv,	fdivr,
	fld,	fxch,	empty,	fstp,
	empty,	empty,	empty,	empty,
	NULL,	NULL,	NULL,	NULL,
	NULL,	NULL,	NULL,	NULL,
	NULL,	NULL,	NULL,	NULL,
	empty,	NULL,	NULL,	NULL,
	fadd,	fmul,	fcom,	fcomp,
	fsubr,	fsub,	fdivr,	fdiv,
	ffree,	fxch,	fst,	fstp,
	NULL,	NULL,	NULL,	NULL,
	faddp,	fmulp,	fcomp,	empty,
	fsubrp,	fsubp,	fdivrp,	fdivp,
	ffree,	fxch,	fst,	fstp,
	NULL,	NULL,	NULL,	NULL,
};
PRIVATE char *sstr1_d8[] =
{
	fnop,	NULL,	NULL,	NULL,
	NULL,	NULL,	NULL,	NULL,
};
PRIVATE char *sstr2_d8[] =
{
	fchs,	fabs,	empty,	empty,
	ftst,	fxam,	empty,	empty,
	fld1,	fldl2t,	fldl2e,	fldpi,
	fldlg2,	fldln2,	fldz,	empty,
	f2xm1,	fyl2x,	fptan,	fpatan,
	fxtract,	empty,	fdecstp,	fincstp,
	fprem,	fyl2xp1,	fsqrt,	empty,
	frndint,	fscale,	empty,	empty,
};
PRIVATE char *sstr3_d8[] =
{
	feni,	fdisi,	fclex,	finit,
	NULL,	NULL,	NULL,	NULL,
};
PRIVATE char *str_e0[] =
{
	"loopnz\t",	"loopz\t",	"loop\t",	"jcxz\t",
	intab,	intab,	s_outtab,	s_outtab
};
PRIVATE char *str_e8[] =
{
	calltab,	jmptab,	jmptab,	jmptab,
	intab,	intab,	s_outtab,	s_outtab
};
PRIVATE char *str_f0[] =
{
	"lock\t",	"db\tf1",	"repnz\t",	"repz\t",
	"hlt",	"cmc",
	/* other 2 from sstr_f0 */
};
PRIVATE char *sstr_f0[] =
{
	testtab,	fishy,	"not\t",	"neg\t",
	"mul\t",	imultab,	"div\t",	"idiv\t"
};
PRIVATE char *str_f8[] =
{
	"clc",	"stc",	"cli",	"sti",
	"cld",	"std",
	/* other 2 from sstr_f8 */
};
PRIVATE char *sstr_f8[] =
{
	inctab,	dectab,	calltab,	"call\tfar ",
	jmptab,	"jmp\tfar ",	pushtab, fishytab
};

PRIVATE int data_seg;          /* data segment (munged name for asld) */
PRIVATE count_t hasize;        /* half address size in bits */
PRIVATE count_t hdefsize;
PRIVATE count_t hosize;        /* half operand size in bits */
                               /* for easy index into reg tables */
PRIVATE opcode_pt modregrm;
PRIVATE offset_t offtable[2];
PRIVATE offset_t *offptr;
PRIVATE offset_t *off1ptr;

PRIVATE su8_pt get8s()
{
	u8_pt got;

	if ( (got = get8()) > MAX_SIGNED_CHAR )
		got -= (MAX_UNSIGNED_CHAR + 1);
	return got;
}

PRIVATE offset_t getasize()
{
	if ( hasize == 16 )
		return get32();
	return get16();
}

PRIVATE void getmodregrm()
{
	modregrm = get8();
}

PRIVATE void i_00_to_3f( opc )
opcode_pt opc;
{
	opcode_pt sub;

	if ( opc == 15 )
		pagef();
	else if ( (sub = opc & 7) >= 6 )
	{
		outustr( (sstr_00_to_3f - 6)[((opc >> 2) & 0xE) + sub] );
		if ( !(opc & 1) )
			data_seg = opc;	
	}
	else
	{
		oututstr( str_00_to_3f[(opc >> 3) & 7] );
		if ( sub == 4 )
		{
			outustr( genreg[0] );
			outcomma();
			Ib();
		}
		else if ( sub == 5 )
		{
			outax();
			outcomma();
			Iv();
		}
		else
			outad( sub );
	}
}

PRIVATE void i_40_to_5f( opc )
opcode_pt opc;
{
	outustr( str_40_to_5f[(opc >> 3) & 3] );
	outustr( genreg[hosize + (opc & 7)] );
}

PRIVATE void i_60_to_6f( opc )
opcode_pt opc;
{
	/* for 386, some for 286 */

	outustr( (str_60_to_6f - 0x60)[opc] );
	switch( opc )
	{
	case 0x62: GvMa(); break;
	case 0x63: EwRw(); break;
	case 0x64:
	case 0x65: data_seg = opc; break;
	case 0x66: hosize = (16 + 8) - hdefsize; break;
	case 0x67: hasize = (16 + 8) - hdefsize; break;
	case 0x68: outword();Iv(); break;
	case 0x6A: outword(); outimmed( SIGNBIT | WORDBIT ); break;
	case 0x69:
		/* IMUL /r iw-id like MOV iw */
	case 0x6B:
		/* IMUL /r ib like MOV ib but target is w not b */
		getmodregrm();
		outbwptr( opc );  /* like C6, C7 but this differs */
		outea( opc );
		outcomma();
		if ( opc == 0x69 )
			/* also differs from C6, C7 */
			Iv();
		else
			outimmed( SIGNBIT | WORDBIT );
		if ( modregrm & REG_MASK )
			/* not completely decoded (like DEBUG) */
			outfishy();
		break;
	}
}

PRIVATE void i_70_to_7f( opc )
opcode_pt opc;
{
	outustr( "j" );
	oututstr( (str_flags - 0x70)[opc] );
	Jb();
}

PRIVATE void i_80( opc )
opcode_pt opc;
{
	opcode_pt sub;

	if ( opc >= 4 )
	{
		outustr( opc >=6 ? xchgtab : testtab );
		outad( opc );
	}
	else
	{
		getmodregrm();
		oututstr( str_00_to_3f[sub = (modregrm & REG_MASK) >> REG_SHIFT] );
		outbwptr( opc );
		outea( opc );
		outcomma();
		outimmed( opc );
		if ( opc & SIGNBIT && (sub == 1 || sub == 4 || sub == 6) )
			/*
				and, or and xor are technically illegal with sign extension
				but make sense and are produced by MASM!
			*/
			outfishy();
	}
}

PRIVATE void i_88( opc )
opcode_pt opc;
{
	if ( opc < 4 )
	{
		outustr( movtab );
		outad( opc );
	}
	else if ( opc == 5 )
	{
		oututstr( "lea" );
		GvM();
	}
	else if ( opc == 7 )
	{
		oututstr( "pop" );
		getmodregrm();
		outwptr();
		Ev();
		if ( modregrm & REG_MASK )
			outfishy();
	}
	else
	{
		getmodregrm();
		outustr( movtab );
		if ( !(opc & TOREGBIT) )
		{
			Ev();
			outcomma();
		}
		outustr( segreg[(modregrm & SREG_MASK) >> SREG_SHIFT] );
		if ( opc & TOREGBIT )
		{
			outcomma();
			Ev();
		}
	}
}

PRIVATE void i_90( opc )
opcode_pt opc;
{
	if ( opc == 0 )
		outustr("nop");
	else
	{
		outustr( xchgtab );
		outax();
		outcomma();
		outustr( genreg[hosize + opc] );
	}
}

PRIVATE void i_98( opc )
opcode_pt opc;
{
	outustr( str_98[opc] );
	if ( opc == 2 )
		outsegpc();
}

PRIVATE void i_a0( opc )
opcode_pt opc;
{
	outustr( str_a0[opc] );
	if ( opc < 4 )
	{
		/* fake mod == MEM0_MOD, reg = 0 (ax) and rm == 6 or 5 ([d32] or [d16]) */
		if ( hasize == 16 )
			modregrm = 5;
		else
			modregrm = 6;
		outad1( opc ^ TOREGBIT );
	}
}

PRIVATE void i_a8( opc )
opcode_pt opc;
{
	outustr( str_a8[opc] );
	if ( opc < 2 )
	{
		outalorx( opc );
		outcomma();
		outimmed( opc );
	}
}

PRIVATE void i_b0( opc )
opcode_pt opc;
{
	outustr( movtab );
	outustr( genreg[opc] );
	outcomma();
	Ib();
}

PRIVATE void i_b8( opc )
opcode_pt opc;
{
	outustr( movtab );
	outustr( genreg[hosize + opc] );
	outcomma();
	Iv();
}

PRIVATE void i_c0( opc )
opcode_pt opc;
{
	outustr( str_c0[opc] );
	if ( opc >= 6 )
	{
		getmodregrm();
		outbwptr( opc );
		outea( opc );
		outcomma();
		outimmed( opc & WORDBIT );
		if ( modregrm & REG_MASK )
			/* not completely decoded (like DEBUG) */
			outfishy();
	}
	else if ( opc >= 4 )
		GvMp();
	else if ( opc == 2 )
		Iv();
	else if ( opc < 2 )
		shift( opc );
}

PRIVATE void i_c8( opc )
opcode_pt opc;
{
	outustr( str_c8[opc] );
	if ( opc == 0 )
	{
		Iw();
		outcomma();
		Ib();
	}
	if ( opc == 2 )
		Iv();
	else if ( opc == 5 )
		Ib();
}

PRIVATE void i_d0( opc )
opcode_pt opc;
{
	opcode_pt aabyte;

	if ( opc < 4 )
		shift( opc | 0xD0 );
	else
	{
		outustr( (str_d0 - 4)[opc] );
		if ( opc < 6 && (aabyte = get8()) != 0xA )
		{
			outtab();
			outh8( aabyte );
			outfishy();
		}
	}
}

PRIVATE void i_d8( opc )
opcode_pt opc;
{
	opcode_pt esc;
	char *str;
	opcode_pt sub;

	getmodregrm();
	sub = (modregrm & REG_MASK) >> REG_SHIFT;
	esc = (opc << 3) | sub;
	if ( (str = ((modregrm & MOD_MASK) == REG_MOD ? str1_d8 : str_d8)[esc])
		 == NULL )
	{
escape:
		oututstr( "esc" );
		outh8( esc );
		outcomma();
		outea( opc );
		return;
	}
	outustr( str );
	if ( (modregrm & MOD_MASK) == REG_MOD )
	{
		if ( opc == 0 )
		{
			if ( sub == 2 || sub == 3 )
				outtab();
			else
				outustr( "\tst," );
			outf1();
		}
		else if ( opc == 1 )
		{
			if ( *str == 0 )
			{
				if ( sub == 2 )
				{
					str = sstr1_d8[modregrm & 7];
					if ( str == NULL )
						goto escape;
				}
				else
					str = sstr2_d8[modregrm & 0x1F];
				outustr( str );
			}
			else
			{
				outtab();
				outf1();
			}
		}
		else if ( opc < 4 )
		{
			if ( *str == 0 )
			{
				str = sstr3_d8[modregrm & 7];
				if ( str == NULL )
					goto escape;
				outustr( str );
			}
			else
				outea( opc );
		}
		else if ( !(opc & 1) )
		{
			if ( *str == 0 )
			{
				/* fcompp only */
				if ( (modregrm & RM_MASK) != 1 )
					goto escape;
				outustr( "fcompp\tst(1)" );
			}
			else
			{
				outtab();
				outf1();
				if ( sub != 2 && sub != 3 )
					outustr( ",st" );
			}
		}
		else
		{
			if ( sub < 4 )
			{
				outtab();
				outf1();
			}
			else
				outea( opc );
		}
	}
	else
	{
		outtab();
		if ( (esc & 0xC) == 0xC )
		{
			if ( esc & 0x10 )
			{
				if ( esc == 0x3D || esc == 0x3F )
				{
					outustr( "q" );
					outwptr();
				}
				else
				{
					outustr( "t" );
					outbptr();
				}
			}
			/* else environment stuff */
		}
		else
		{
			if ( opc < 4 )
				outustr( "d" );
			else if ( opc < 6 )
				outustr( "q" );
			outwptr();
		}
		outea( opc );
	}
}

PRIVATE void i_e0( opc )
opcode_pt opc;
{
	outustr( str_e0[opc] );
	if ( opc < 4 )
		Jb();
	else if ( opc < 6 )
	{
		outalorx( opc );
		outcomma();
		Ib();
	}
	else
	{
		Ib();
		outcomma();
		outalorx( opc );
	}
}

PRIVATE void i_e8( opc )
opcode_pt opc;
{
	outustr( str_e8[opc] );
	if ( opc < 2 )
		Jv();
	else if ( opc == 2 )
		outsegpc();
	else if ( opc == 3 )
		Jb();
	else
	{
		if ( opc & TOREGBIT )
		{
			outustr( genreg[10] );
			outcomma();
			outalorx( opc );
		}
		else
		{
			outalorx( opc );
			outcomma();
			outustr( genreg[10] );
		}
	}
}

PRIVATE void i_f0( opc )
opcode_pt opc;
{
	opcode_pt sub;

	if ( opc < 6 )
		outustr( str_f0[opc] );
	else
	{
		getmodregrm();
		sub = (modregrm & REG_MASK) >> REG_SHIFT;
		outustr( sstr_f0[sub] );
		outbwptr( opc );
		outea( opc );
		if ( sub == 0 )
		{
			outcomma();
			outimmed( opc & WORDBIT );
		}
	}
}

PRIVATE void i_f8( opc )
opcode_pt opc;
{
	opcode_pt sub;

	if ( opc < 6 )
		outustr( str_f8[opc] );
	else
	{
		getmodregrm();
		sub = (modregrm & REG_MASK) >> REG_SHIFT;
		if ( opc == 6 && sub >= 2 )
			outustr( fishytab );
		else
			outustr( sstr_f8[sub] );
		outbwptr( opc );
		outea( opc );
	}
}

PRIVATE void outad( opc )
opcode_pt opc;
{
	getmodregrm();
	outad1( opc );
}

PRIVATE void outad1( opc )
opcode_pt opc;
{
	if ( !(opc & TOREGBIT) )
	{
		outea( opc );
		outcomma();
	}
	if ( opc & WORDBIT )
		Gv1();
	else
		outustr( genreg[(modregrm & REG_MASK) >> REG_SHIFT] );
	if ( opc & TOREGBIT )
	{
		outcomma();
		outea( opc );
	}
}

PRIVATE void outasize( off )
offset_t off;
{
	if ( hasize == 16 )
		outh32( off );
	else
		outh16( (u16_t) off );
}

PRIVATE void outalorx( opc )
opcode_pt opc;
{
	if ( opc & WORDBIT )
		outax();
	else
		outustr( genreg[0] );
}

PRIVATE void outax()
{
	outustr( genreg[hosize] );
}

PRIVATE void outbptr()
{
	outustr( "byte ptr " );
}

PRIVATE void outbwptr( opc )
opcode_pt opc;
{
	if ( (modregrm & MOD_MASK) != REG_MOD )
	{
		if ( opc & WORDBIT )
			outwptr();
		else
			outbptr();
	}
}

PRIVATE void outea( wordflags )
opcode_pt wordflags;
{
	reg_pt base;
	reg_pt index;
	opcode_pt mod;
	reg_pt reg;
	opcode_pt ss;
	opcode_pt ssindexbase;

	reg = modregrm & RM_MASK;
	if ( (mod = modregrm & MOD_MASK) == REG_MOD )
		outustr( genreg[hosize * (wordflags & WORDBIT) + reg] );
	else
	{
		outbyte( LINDIRECT );
		if ( hasize == 16 )
		{
			if ( reg == 4 )
			{
				base = (ssindexbase = get8()) & BASE_MASK;
				if ( mod == MEM0_MOD && base == 5 )
					outgetadr();
				else
					outustr( (genreg + 16)[base] );
				ss = (ssindexbase & SS_MASK) >> SS_SHIFT;
				if ( (index = (ssindexbase & INDEX_MASK) >> INDEX_SHIFT) != 4 )
				{
					outbyte( '+' );
					outustr( (genreg + 16)[index] );
					outstr( "\0\0\0*2\0*4\0*8\0" + (3 * ss) );
				}
			}
			else if ( mod == MEM0_MOD && reg == 5 )
				outgetadr();
			else
				outustr( (genreg + 16)[reg] );
		}
		else if ( mod == MEM0_MOD && reg == 6 )
			outgetadr();
		else
			outustr( indreg[reg] );
		if ( mod == MEM1_MOD )
			/* fake sign extension to get +- */
			outimmed( SIGNBIT | WORDBIT );
		else if ( mod == MEM2_MOD )
		{
			outbyte( '+' );
			outgetadr();
		}
		outbyte( RINDIRECT );
		if ( hasize == 16 && reg == 4 && index == 4 && ss != 0 )
			outfishy();
	}
}

PRIVATE void outf1()
{
	outustr( "st(" );
	outbyte( (int) ((modregrm & RM_MASK) + '0') );
	outbyte( ')' );
}

PRIVATE void outfishy()
{
	outustr( "\t???" );
}

PRIVATE void outgetadr()
{
	offset_t off;
	struct nlist *sp;

	off = getasize();
	if ( (sp = findsval( off, data_seg )) != NULL )
	{
		outsym( sp, off );
		*offptr++ = off;
	}
	else
		outasize( off );
}

PRIVATE void outimmed( signwordflag )
opcode_pt signwordflag;
{
	su8_pt byte;

	if ( signwordflag & WORDBIT )
	{
		if ( signwordflag & SIGNBIT )
		{
			if ( (byte = get8s()) < 0 )
			{
				outbyte( '-' );
				byte = -byte;
			}
			else
				outbyte( '+' );
			outh8( (u8_pt) byte );
		}
		else
			Iv();
	}
	else
		Ib();
}

PRIVATE void outpc( pc )
offset_t pc;
{
	struct nlist *sp;

	if ( hasize == 8 )
		pc = (u16_t) pc;
	if ( (sp = findsval( pc, CSEG )) != NULL )
	{
		outsym( sp, pc );
		*offptr++ = pc;
	}
	else if ( hasize == 16 )
		outh32( pc );
	else
		outh16( (u16_t) pc );
}

PRIVATE void outsegpc()
{
	segment_t oldseg;
	offset_t pc;

	pc = getasize();
	oldseg = uptr.seg;
	outh16( uptr.seg = get16() );  /* fake segment for lookup of pc */
	outcolon();
	outpc( pc );
	uptr.seg = oldseg;
}

PRIVATE void oututstr( s )
char *s;
{
	outustr( s );
	outtab();
}

PRIVATE void outword()
{
	outustr( "dword " + ((16 - hosize) >> 3) );
}

PRIVATE void outwptr()
{
	outword();
	outustr( "ptr " );
}

PRIVATE bool_pt pagef()
{
	opcode_pt opc;
	opcode_pt reg;
	bool_t regbad;

	if ( (opc = get8()) <= 1 || opc == 0xBA )
	{
		if ( opc == 0xBA )
			opc = 16;
		else
			opc *= 8;
		getmodregrm();
		outustr( ssstr_0f[opc += (modregrm & REG_MASK) >> REG_SHIFT] );
		if ( opc < 6 || opc == 12 || opc == 14 )
			Ew();
		else if ( opc >= 8 && opc < 13 )
			Ms();
		else if ( opc >= 20 )
		{
			outbwptr( WORDBIT );
			EvIb();
		}
	}
	else if ( opc < 4 )
	{
		oututstr( "lar\0lsl" + 4 * (opc - 2) );
		GvEw();
	}
	else if ( opc == 6 )
		outustr( "clts" );
	else if ( opc < 0x20 )
		outstr( fishy );
	else if ( opc < 0x27 && opc != 0x25 )
	{
		outustr( movtab );
		getmodregrm();
		reg = (modregrm & REG_MASK) >> REG_SHIFT;
		hosize = 16;
		if ( !(opc & TOREGBIT) )
		{
			Ev();				/* Rd() since hosize is 16 */
			outcomma();
		}
		regbad = FALSE;
		if ( opc & 1 )
		{
			outustr( "dr" );
			if ( reg == 4 || reg == 5 )
				regbad = TRUE;
		}
		else if ( opc < 0x24 )
		{
			outustr( "cr" );
			if ( reg >= 4 || reg == 1 )
				regbad = TRUE;
		}
		else
		{
			outustr( "tr" );
			if ( reg < 6  )
				regbad = TRUE;
		}
		outbyte( (int) (reg + '0') );
		if ( opc & TOREGBIT )
		{
			outcomma();
			Ev();
		}
		if ( regbad || (modregrm & MOD_MASK) != REG_MOD )
			outfishy();
	}
	else if ( opc < 0x80 )
		outstr( fishy );
	else if ( opc < 0x90 )
	{
		outustr( "j" );
		oututstr( (str_flags - 0x80)[opc] );
		Jv();
	}
	else if ( opc < 0xA0 )
	{
		outustr( "set" );
		oututstr( (str_flags - 0x90)[opc] );
		getmodregrm();
		outbwptr( 0 );
		Eb();
	}
	else if ( opc < 0xC0 )
	{
		outustr( (sstr_0f - 0xA0)[opc] );
		switch( opc )
		{
		case 0xA3: case 0xAB: case 0xB3: case 0xBB:
			EvGv();
			break;
		case 0xA4: case 0xAC:
			EvGv();
			outcomma();
			Ib();
			break;
		case 0xA5: case 0xAD:
			EvGv();
			outcomma();
			CL();
			break;
		case 0xAF: case 0xBC: case 0xBD:
			GvEv();
			break;
		case 0xB2: case 0xB4: case 0xB5:
			GvMp();
			break;
		case 0xB6: case 0xBE:
			Gv();
			outcomma();
			outbwptr( opc );
			Eb();
			break;
		case 0xB7: case 0xBF:
			Gv();
			outcomma();
			hosize = 8;  /* done in Ew(), but too late */
			outbwptr( opc );
			Ew();
			break;
		}
	}
	else
		outstr( fishy );
}

PUBLIC bool_pt puti()
{
	static bool_t hadprefix;
	opcode_pt opcode;

	offptr = offtable;
	opcode = get8();
	if ( !hadprefix )
	{
		data_seg = DSEG;
		hdefsize = 8;
		if ( bits32 )
			hdefsize = 16;
		hosize =
		hasize = hdefsize;
	}
	(*optable[opcode >> 3]) ( opcode < 0x80 ? opcode: opcode & 7 );
	if ( offptr > offtable )
	{
		if ( stringtab() >= 31 )
			out2space();
		else
			while ( stringtab() < 32 )
				outtab();
		outbyte( ';' );
		for ( off1ptr = offtable; off1ptr < offptr; ++off1ptr )
		{
			outspace();
			outh32( *off1ptr );
		}
		offptr = offtable;
	}
	if ( (opcode & 0xE7) == 0x26 ||
	     opcode >= 0x64 && opcode < 0x68 ||
	     opcode == 0xF0 || opcode == 0xF2 || opcode == 0xF3 )
		/*
			not finished instruction for 0x26, 0x2E, 0x36, 0x3E seg overrides
			and 0x64, 0x65 386 seg overrides
			and 0x66, 0x67 386 size prefixes
			and 0xF0 lock, 0xF2 repne, 0xF3 rep
		*/
	{
		hadprefix = TRUE;
		return FALSE;
	}
	hadprefix = FALSE;
	return TRUE;
}

PRIVATE void shift( opc )
opcode_pt opc;
{
	reg_pt reg;

	getmodregrm();
	reg = (modregrm & REG_MASK) >> REG_SHIFT;
	oututstr( sstr_d0[reg] );
	outbwptr( opc );
	outea( opc );
	outcomma();
	if ( opc < 0xD0 )
		Ib();
	else if ( opc & 2 )
		CL();
	else
		outbyte( '1' );
}

PRIVATE void checkmemory()
{
	if ( (modregrm & MOD_MASK) == REG_MOD )
		outfishy();
}

PRIVATE void CL()
{
	outustr( genreg[1] );
}

PRIVATE void Eb()
{
	outea( 0 );
}

PRIVATE void Ev()
{
	outea( WORDBIT );
}

PRIVATE void EvGv()
{
	getmodregrm();
	Ev();
	outcomma();
	Gv1();
}

PRIVATE void EvIb()
{
	Ev();
	outcomma();
	Ib();
}

PRIVATE void Ew()
{
	hosize = 8;
	Ev();
}

PRIVATE void EwRw()
{
	hosize = 8;
	EvGv();
}

PRIVATE void Gv()
{
	getmodregrm();
	Gv1();
}

PRIVATE void Gv1()
{
	outustr( genreg[hosize + ((modregrm & REG_MASK) >> REG_SHIFT)] );
}

PRIVATE void GvEv()
{
	Gv();
	outcomma();
	Ev();
}

PRIVATE void GvEw()
{
	Gv();
	outcomma();
	Ew();
}

PRIVATE void GvM()
{
	GvEv();
	checkmemory();
}

PRIVATE void GvMa()
{
	GvM();
}

PRIVATE void GvMp()
{
	GvM();
}

PRIVATE void Iv()
{
	if ( hosize == 16 )
		outh32( get32() );
	else
		Iw();
}

PRIVATE void Jb()
{
	offset_t pcjump;

	pcjump = get8s();
	outpc( pcjump + uptr.off );
}

PRIVATE void Jv()
{
	offset_t pcjump;

	if ( hasize == 16 )
		pcjump = get32();
	else
		pcjump = (su16_t) get16();
	outpc( pcjump + uptr.off );
}

PRIVATE void Ms()
{
	Ev();
	checkmemory();
}
