/* Function prototypes. */

struct proc;		/* need types outside of parameter list --kub */
struct tty_struct;

/* amoeba.c */
_PROTOTYPE( void amint_task, (void)					);
_PROTOTYPE( void amoeba_task, (void)					);

/* at_wini.c, bios_wini.c, ps_wini.c, xt_wini.c, stwini.c */
_PROTOTYPE( void winchester_task, (void)				);

/* clock.c */
_PROTOTYPE( void clock_handler, (void)					);
_PROTOTYPE( void clock_task, (void)					);

/* dmp.c, stdmp.c */
_PROTOTYPE( void map_dmp, (void)					);
_PROTOTYPE( void p_dmp, (void)						);
_PROTOTYPE( void set_name, (int proc_nr , char *ptr)			);

/* floppy.c, stfloppy.c */
_PROTOTYPE( void floppy_task, (void)					);

/* main.c, stmain.c */
_PROTOTYPE( void main, (void)						);
_PROTOTYPE( void panic, (char *s, int n)				);

/* memory.c */
_PROTOTYPE( void mem_task, (void)					);

/* misc.c */
_PROTOTYPE( int do_vrdwt, (message *m_ptr, int (*do_rdwt)())		);

/* printer.c, stprint.c */
_PROTOTYPE( void printer_task, (void)					);

/* proc.c */
_PROTOTYPE( void interrupt, (int task)					);
_PROTOTYPE( int lock_mini_send, (struct proc *caller_ptr,
			int dest, message *m_ptr)			);
_PROTOTYPE( void lock_pick_proc, (void)					);
_PROTOTYPE( void lock_ready, (struct proc *rp)				);
_PROTOTYPE( void lock_sched, (void)					);
_PROTOTYPE( void lock_unready, (struct proc *rp)			);
_PROTOTYPE( int sys_call, (int function, int src_dest, message *m_ptr)	);
_PROTOTYPE( void unhold, (void)						);

/* rs232.c */
_PROTOTYPE( void rs_inhibit, (int minor, int inhibit)			);
_PROTOTYPE( int rs_init, (int minor)					);
_PROTOTYPE( int rs_ioctl, (int minor, int mode, int speeds)		);
_PROTOTYPE( int rs_read, (int minor, char **bufindirect,
			char *odoneindirect)				);
_PROTOTYPE( void rs_istart, (int minor)					);
_PROTOTYPE( void rs_istop, (int minor)					);
_PROTOTYPE( void rs_ocancel, (int minor)				);
_PROTOTYPE( void rs_setc, (int minor, int xoff)				);
_PROTOTYPE( void rs_write, (int minor, char *buf, int nbytes)		);

/* system.c */
_PROTOTYPE( void cause_sig, (int proc_nr, int sig_nr)			);
_PROTOTYPE( void inform, (void)						);
_PROTOTYPE( phys_bytes numap, (int proc_nr, vir_bytes vir_addr,
			vir_bytes bytes)				);
_PROTOTYPE( void sys_task, (void)					);
_PROTOTYPE( phys_bytes umap, (struct proc *rp, int seg, vir_bytes vir_addr,
			vir_bytes bytes)				);

/* tty.c */
_PROTOTYPE( void finish, (struct tty_struct *tp, int code)		);
_PROTOTYPE( void sigchar, (struct tty_struct *tp, int sig)		);
_PROTOTYPE( void tty_task, (void)					);
_PROTOTYPE( void tty_wakeup, (void)					);

/* library */
_PROTOTYPE( void *memcpy, (void *_s1, const void *_s2, size_t _n)	);
_PROTOTYPE( void printk, (char *_fmt, ...)				);
_PROTOTYPE( int receive, (int _src, message *_m_ptr)			);
_PROTOTYPE( int send, (int _dest, message *_m_ptr)			);
_PROTOTYPE( int sendrec, (int _src_dest, message *_m_ptr)		);

#if (CHIP == INTEL)

struct segdesc_s;

/* clock.c */
_PROTOTYPE( void milli_delay, (unsigned millisec)			);
_PROTOTYPE( unsigned read_counter, (void)				);

/* console.c */
_PROTOTYPE( void console, (struct tty_struct *tp)			);
_PROTOTYPE( void flush, (struct tty_struct *tp)				);
_PROTOTYPE( void out_char, (struct tty_struct *tp, int c)		);
_PROTOTYPE( void putc, (int c)						);
_PROTOTYPE( void scr_init, (int minor)					);
_PROTOTYPE( void toggle_scroll, (void)					);

/* cstart.c */
_PROTOTYPE( void cstart, (u16_t ax, u16_t bx, u16_t cx, u16_t dx,
			u16_t si, u16_t di, u16_t cs, u16_t ds)		);

/* exception.c */
_PROTOTYPE( void exception, (unsigned vec_nr)				);

/* i8259.c */
_PROTOTYPE( void enable_irq, (unsigned irq_nr)				);
_PROTOTYPE( void init_8259, (unsigned master_base, unsigned slave_base)	);

/* keyboard.c */
_PROTOTYPE( int func_key, (int ch)					);
_PROTOTYPE( void kb_init, (int minor)					);
_PROTOTYPE( int kb_read, (int minor, char **bufindirect,
			unsigned char *odoneindirect)			);
_PROTOTYPE( void keyboard, (void)					);
_PROTOTYPE( int letter_code, (int scode)				);
_PROTOTYPE( int make_break, (int ch)					);
_PROTOTYPE( void reboot, (void)						);
_PROTOTYPE( void wreboot, (void)					);

/* klib*.x */
_PROTOTYPE( void bios13, (void)						);
_PROTOTYPE( void build_sig, (char *sig_stuff, struct proc *rp, int sig)	);
_PROTOTYPE( phys_bytes check_mem, (phys_bytes base, phys_bytes size)	);
_PROTOTYPE( void cim_at_wini, (void)					);
_PROTOTYPE( void cim_floppy, (void)					);
_PROTOTYPE( void cim_printer, (void)					);
_PROTOTYPE( void cim_xt_wini, (void)					);
_PROTOTYPE( void cp_mess, (int src, phys_clicks src_clicks,vir_bytes src_offset,
			phys_clicks dst_clicks, vir_bytes dst_offset)	);
_PROTOTYPE( unsigned in_byte, (unsigned port)				);
_PROTOTYPE( void klib_1hook, (void)					);
_PROTOTYPE( void klib_2hook, (void)					);
_PROTOTYPE( void lock, (void)						);
_PROTOTYPE( void out_byte, (unsigned port, int value)			);
_PROTOTYPE( void phys_copy, (phys_bytes source, phys_bytes destination,
			phys_bytes bytecount)				);
_PROTOTYPE( void port_read, (unsigned port, phys_bytes destination,
			unsigned bytcount)				);
_PROTOTYPE( void port_write, (unsigned port, phys_bytes source,
			unsigned bytcount)				);
_PROTOTYPE( void reset, (void)						);
_PROTOTYPE( void scr_down, (unsigned videoseg, int source,int dest,int count) );
_PROTOTYPE( void scr_up, (unsigned videoseg, int source, int dest, int count) );
_PROTOTYPE( void sim_printer, (void)					);
_PROTOTYPE( unsigned tasim_printer, (void)				);
_PROTOTYPE( int test_and_set, (int *flag)				);
_PROTOTYPE( void unlock, (void)						);
_PROTOTYPE( void vid_copy, (char *buffer, unsigned videobase,
			int offset, int words)				);
_PROTOTYPE( void wait_retrace, (void)					);

/* main.c */
_PROTOTYPE( void dp8390_int, (void)					);
_PROTOTYPE( void eth_stp, (void)					);

/* misc.c */
_PROTOTYPE( void mem_init, (void)					);

/* mpx*.x */
_PROTOTYPE( void mpx_1hook, (void)					);
_PROTOTYPE( void mpx_2hook, (void)					);
_PROTOTYPE( void idle_task, (void)					);
_PROTOTYPE( void restart, (void)					);
/* The following are never called from C (pure asm procs), hence no protos */
void int00(), divide_error();	/* exception handlers, in numerical order */
void int01(), single_step_exception();
void int02(), nmi();
void int03(), breakpoint_exception();
void int04(), overflow();
void int05(), bounds_check();
void int06(), inval_opcode();
void int07(), copr_not_available();
void int08(), double_fault();
void int09(), copr_seg_overrun();
void int10(), inval_tss();
void int11(), segment_not_present();
void int12(), stack_exception();
void int13(), general_protection();
void int14(), page_fault();
void int15();
void int16(), copr_error();	/* end of exception handlers */
void clock_int();		/* hardware interrupt handlers, in order */
void tty_int();
void secondary_int(), psecondary_int(), eth_int();
void rs232_int(), prs232_int();
void disk_int();
void lpr_int();
void wini_int();		/* end of hardware interrupt handlers */
void trp();			/* software interrupt handlers, in order */
void s_call(), p_s_call();	/* end of software interrupt handlers */

/* printer.c */
_PROTOTYPE( void pr_char, (void)					);
_PROTOTYPE( void pr_restart, (void)					);

/* protect.c */
_PROTOTYPE( void prot_init, (void)					);

/* protect1.c */
_PROTOTYPE( void init_codeseg, (struct segdesc_s *segdp, phys_bytes base,
			phys_bytes size, int privilege)			);
_PROTOTYPE( void init_dataseg, (struct segdesc_s *segdp, phys_bytes base,
			phys_bytes size, int privilege)			);
_PROTOTYPE( void ldt_init, (void)					);

/* rs232.c */
_PROTOTYPE( void rs232_1handler, (void)					);
_PROTOTYPE( void rs232_2handler, (void)					);

/* start.x */
_PROTOTYPE( void db, (void)                                             );
_PROTOTYPE( u16_t get_chrome, (void)                                    );
_PROTOTYPE( u16_t get_ega, (void)                                       );      
_PROTOTYPE( u16_t get_ext_memsize, (void)                               );      
_PROTOTYPE( u16_t get_low_memsize, (void)                               );      
_PROTOTYPE( u16_t get_processor, (void)                                 );      
_PROTOTYPE( u16_t get_word, (u16_t segment, u16_t *offset)              );      
_PROTOTYPE( void put_word, (u16_t segment, u16_t *offset, u16_t value)  );      

/* system.c */
_PROTOTYPE( void alloc_segments, (struct proc *rp)			);

#endif /* (CHIP == INTEL) */

#if (CHIP == M68000)

/* stdmp.c */
_PROTOTYPE( void prname, (int i)					);
_PROTOTYPE( void reg_dmp, (struct proc *rp)				);
_PROTOTYPE( void mem_dmp, (char *adr, int len)				);
_PROTOTYPE( void tty_dmp, (void)					);

/* stfloppy.c */
_PROTOTYPE( void fd_timer, (void)					);

/* stmain.c */
_PROTOTYPE( void none, (void)						);
_PROTOTYPE( void rupt, (void)						);
_PROTOTYPE( void trap, (void)						);
_PROTOTYPE( void checksp, (void)					);
_PROTOTYPE( void aciaint, (void)					);
_PROTOTYPE( void fake_int, (char *s, int t)				);
_PROTOTYPE( void timint, (int t)					);
_PROTOTYPE( void mdiint, (void)						);
_PROTOTYPE( void iob, (int t)						);
_PROTOTYPE( void idle_task, (void)					);

/* proc.c */

/* rs232.c */
_PROTOTYPE( void siaint, (int type)					);

/* stcon.c */
_PROTOTYPE( void func_key, (void)					);
_PROTOTYPE( void dump, (void)						);
_PROTOTYPE( void putc, (int c)						);

/* stdma.c */
_PROTOTYPE( void dmagrab, (int p, void (*func)())			);
_PROTOTYPE( void dmafree, (int p)					);
_PROTOTYPE( void dmaint, (void)						);
_PROTOTYPE( void dmaaddr, (phys_bytes ad)				);
_PROTOTYPE( int dmardat, (int mode, int delay)				);
_PROTOTYPE( void dmawdat, (int mode, int data, int delay)		);
_PROTOTYPE( void dmawcmd, (int data, unsigned mode)			);
_PROTOTYPE( void dmacomm, (int mode, int data, int delay)		);
_PROTOTYPE( int dmastat, (int mode, int delay)				);

/* stdskclk.c */
_PROTOTYPE( int do_xbms, (phys_bytes address, int count, int rw, int minor) );
 
/* stfnt.c */

/* stkbd.c */
_PROTOTYPE( void kbdint, (void)						);
_PROTOTYPE( void kb_timer, (void)					);
_PROTOTYPE( int kb_read, (int minor, char **bufindirect,
			unsigned char *odoneindirect)			);
_PROTOTYPE( void kbdinit, (int minor)					);

/* stshadow.c */
_PROTOTYPE( void mkshadow, (struct proc *p, phys_clicks c2)		);
_PROTOTYPE( void rmshadow, (struct proc *p, phys_clicks *basep,
			phys_clicks *sizep)				);
_PROTOTYPE( void unshadow, (struct proc *p)				);
 
/* stvdu.c */
_PROTOTYPE( void flush, (struct tty_struct *tp)				);
_PROTOTYPE( void console, (struct tty_struct *tp)			);
_PROTOTYPE( void out_char, (struct tty_struct *tp, int c)		);
_PROTOTYPE( void vduinit, (struct tty_struct *tp)			);
_PROTOTYPE( void vduswitch, (struct tty_struct *tp)			);

/* copy68k.s */
_PROTOTYPE( void flipclicks, (phys_clicks c1, phys_clicks c2, phys_clicks n) );
_PROTOTYPE( void copyclicks, (phys_clicks src, phys_clicks dest,
			phys_clicks nclicks)				);
_PROTOTYPE( void zeroclicks, (phys_clicks dest, phys_clicks nclicks)	);
_PROTOTYPE( void phys_copy, (phys_bytes src, phys_bytes dest, phys_bytes n) );

/* stdskclks.s */
_PROTOTYPE( int rd1byte, (void)						);
_PROTOTYPE( int wr1byte, (int)						);
_PROTOTYPE( long getsupra, (void)					);
_PROTOTYPE( long geticd, (void)						);

/* stmpx.s */
_PROTOTYPE( int lock, (void)						);
_PROTOTYPE( void unlock, (void)						);
_PROTOTYPE( void restore, (int oldsr)					);
_PROTOTYPE( void reboot, (void)						);
_PROTOTYPE( int test_and_set, (char *flag)				);

/* stprint.c */
#ifdef DEBOUT
_PROTOTYPE( void prtc, (int c)						);
#endif

#endif /* (CHIP == M68000) */
