/* LocaleInformation_zh_Hant.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_zh_Hant extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|ITL|USN|GHC|SGD|PAB|LAK|KGS|ATS|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|XFU|BTR|ZRZ|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|SHP|VNN";

  private static final String currenciesDisplayNameValues = "\u7d04\u65e6\u7b2c\u7d0d\u723e|\u73bb\u5229\u7dad\u4e9e \u5e55\u591a|\u9ec3\u91d1|\u6cd5\u7f85\u5cf6\u514b\u6717|\u9ece\u5df4\u5ae9\u938a|\u6b50\u5143|\u5766\u6851\u5c3c\u4e9e \u5148\u4ee4|\u73bb\u5229\u7dad\u4e9e\u62ab\u7d22|\u67ec\u57d4\u5be8\u745e\u723e|\u4e9e\u6d32\u8ca8\u5e63\u55ae\u4f4d|\u73bb\u5229\u7dad\u4e9e\u820a\u8ca8\u5e63\u55ae\u4f4d (1863-1962)|\u67ec\u57d4\u5be8\u820a\u745e\u723e|\u8d0a\u6bd4\u4e9e\u938a|\u6fb3\u5927\u5229\u4e9e\u938a|\u897f\u975e \u6cd5\u90ce BEAC|\u99ac\u723e\u4ed6\u938a|\u8fe6\u7d0d\u91cd\u65b0\u4f30\u4ef7\u5f8c\u7684\u4ed9\u8515|\u5c1a\u6bd4\u4e9e\u514b\u74e6\u67e5|\u4e9e\u6d32\u7b2c\u7d0d\u723e\u6703\u8a08\u55ae\u4f4d|\u8fe6\u7d0d\u938a|\u73bb\u5229\u7dad\u4e9e\u8ca8\u5e63\u55ae\u4f4d|\u8fe6\u7d0d\u820a\u4ed9\u8515|\u99ac\u723e\u4ed6\u91cc\u62c9|\u6fb3\u5e63|\u7fa9\u5927\u5229\u91cc\u62c9|\u7f8e\u5143 (\u7b2c\u4e8c\u5929)|\u8fe6\u7d0d\u4ed9\u8515|\u65b0\u52a0\u5761\u5e63|\u5df4\u62ff\u99ac\u5df4\u6ce2\u4e9e|\u8001\u64be \u958b\u666e|\u5409\u723e\u5409\u65af\u7d22\u99ac|\u5967\u5730\u5229\u5148\u4ee4|\u57c3\u8cfd\u4fc4\u6bd4\u4e9e\u5143|\u6c76\u840a\u5143|\u7259\u8cb7\u52a0\u938a|\u8863\u7d22\u6bd4\u4e9e\u6bd4\u723e|\u963f\u723e\u53ca\u5229\u4e9e\u6cd5\u90ce Germinal|\u963f\u723e\u53ca\u5229\u4e9e\u65b0\u6cd5\u90ce|\u963f\u723e\u53ca\u5229\u4e9e\u7b2c\u7d0d\u723e|\u5df4\u62c9\u572d\u74dc\u62c9\u5c3c|\u5229\u6bd4\u4e9e\u938a|\u7259\u8cb7\u52a0\u5143|\u51b0\u5cf6\u514b\u6717|\u897f\u73ed\u7259\u966a\u58eb\u7279|\u767e\u6155\u9054\u938a|\u5229\u6bd4\u4e9e\u7b2c\u7d0d\u723e|\u5229\u6bd4\u4e9e\u82f1\u570b\u7684\u8ecd\u4e8b\u7576\u5c40\u91cc\u62c9|\u767e\u6155\u9054\u5e63|\u8377\u862d\u76fe|\u8305\u5229\u5854\u5c3c\u4e9e\u70cf\u5409\u4e9e|\u4f0a\u6717\u91cc\u4e9e\u723e|\u745e\u5178\u514b\u7f85\u7d0d|\u5384\u7acb\u7279\u91cc\u4e9e\u7d0d\u514b\u6cd5|\u80af\u5c3c\u4e9e\u5148\u4ee4|\u4e2d\u975e\u5171\u548c\u570b\u897f\u975e\u6cd5\u90ce|\u963f\u6839\u5ef7\u62ab\u7d22|\u963f\u6839\u5ef7\u62ab\u7d22(1983-1985)|\u963f\u6839\u5ef7\u62ab\u7d22 Moneda Nacional|\u65b0\u81fa\u5e63|\u8607\u4e39\u938a|\u55ac\u6cbb\u62c9\u91cc|\u55ac\u6cbb \u5eab\u65c1 \u62c9\u91cc|\u99ac\u63d0\u5c3c\u514b\u5cf6\u6cd5\u90ce|\u798f\u514b\u862d\u7fa4\u5cf6\u938a|\u963f\u6839\u5ef7\u5967\u65af\u7279\u7d0d\u723e|\u8607\u4e39\u7b2c\u7d0d\u723e|\u4f0a\u62c9\u514b\u7b2c\u7d0d\u723e|\u5410\u74e6\u9b6f\u7f8e\u5143|\u585e\u820c\u723e\u7fa4\u5cf6\u76e7\u5e03|\u62c9\u812b\u7dad\u4e9e\u76e7\u5e03|\u6590\u6fdf\u938a|\u62c9\u812b\u7dad\u4e9e\u62c9\u7279\u9280\u5e63|\u525b\u679c\u624e\u4f0a\u723e|\u525b\u679c\u5171\u548c\u570b\u6cd5\u90ce|\u525b\u679c\u6cd5\u90ce|\u6590\u6fdf\u5143|\u5c3c\u52a0\u62c9\u74dc \u91d1\u54e5\u591a\u83ef|\u6fb3\u9580\u5143|\u5c3c\u52a0\u62c9\u74dc\u91d1\u91d1\u54e5\u591a\u83ef|COMECON \u53ef\u8f49\u79fb\u76e7\u5e03|\u82ac\u862d\u99ac\u514b (1860-1962)|\u82ac\u862d\u99ac\u514b|\u7d22\u7f85\u9580\u7fa4\u5cf6\u5143|\u76e7\u68ee\u5821\u6cd5\u90ce|\u7279\u7acb\u5c3c\u9054\u548c\u591a\u5df4\u54e5\u820a\u5143r|\u5b89\u54e5\u62c9\u57c3\u65af\u5eab\u591a|\u5b89\u54e5\u62c9\u65b0\u5bec\u624e Reajustado (1995-1999)|\u8499\u53e4\u5716\u683c\u91cc\u514b|\u5308\u7259\u5229 - \u798f\u6797|\u84b2\u9686\u5730\u6cd5\u90ce|\u5b89\u54e5\u62c9\u65b0\u5bec\u624e (1990-2000)|\u5b89\u54e5\u62c9\u5bec\u624e(1977-1990)|\u5343\u91cc\u9054\u53ca\u6258\u5df4\u54e5r|\u65af\u5a01\u58eb\u862d \u91cc\u90ce|\u65b0\u8d6b\u5e03\u91cc\u5e95\u7fa4\u5cf6 CFP \u6cd5\u90ce|\u82f1\u938a|\u6c99\u70cf\u5730\u5b97\u4e3b\u91cc\u96c5|\u6c99\u70cf\u5730\u91cc\u96c5|\u7acb\u9676\u5b9b\u7279\u7f85|\u5370\u5ea6\u76e7\u5e03|\u8461\u8404\u7259\u57c3\u65af\u5eab\u591a|\u5b89\u54e5\u62c9\u5bec\u624e|\u8461\u8404\u7259 \u5eb7\u62d6|\u7acb\u9676\u5b9b\u91cc\u5854|\u5361\u624e\u514b\u65af\u5766\u5766\u5409|\u5361\u624e\u514b\u65af\u5766\u76e7\u5e03|\u82f1\u5c6c\u7dad\u723e\u65af\u7fa4\u5cf6\u5143|\u5948\u53ca\u5229\u4e9e\u938a|\u7dec\u7538\u7f8e\u5143\u5916\u532f\u5238|\u5948\u53ca\u5229\u4e9e\u5948\u62c9|\u6558\u5229\u4e9e\u938a|\u5df4\u52d2\u65af\u5766\u938a|\u5df4\u6797\u7b2c\u7d0d\u723e|\u7dec\u7538\u5143|\u8377\u862d \u5b89\u68af\u862d \u76fe|\u6377\u514b\u514b\u6717|\u66fc\u57ce\u5cf6\u82f1\u938a|\u4fdd\u52a0\u5229\u4e9e\u5217\u5f17\u5916\u532f\u5238|\u8cf4\u7d22\u6258\u7f85\u8482|\u52a0\u84ec\u897f\u975e\u6cd5\u90ce|\u4fdd\u52a0\u5229\u4e9e\u5217\u5f17 (1879-1952)|\u4fdd\u52a0\u5229\u4e9e\u65b0\u5217\u5f17|\u4fdd\u52a0\u5229\u4e9e \u793e\u6703\u4e3b\u7fa9\u5217\u5f17|\u52a0\u5e63|\u4fdd\u52a0\u5229\u4e9e\u786c\u5217\u5f17|\u958b\u66fc\u7fa4\u5cf6\u7f8e\u5143|\u8cfd\u6d66\u8def\u65af\u938a|\u4ee5\u8272\u5217\u65b0\u8b1d\u514b\u723e|\u572d\u4e9e\u90a3\u5143|\u4e9e\u7f8e\u5c3c\u4e9e\u5fb7\u62c9\u59c6|\u4ee5\u8272\u5217\u938a|\u99ac\u91cc\u6cd5\u90ce|\u4ee5\u8272\u5217\u8b1d\u5ba2\u723e|\u59d4\u5167\u745e\u62c9\u535a\u5229\u74e6|\u963f\u723e\u5df4\u5c3c\u4e9e\u5143\u5916\u532f\u5238|\u8cf4\u6bd4\u745e\u4e9e\u5143|\u963f\u723e\u5df4\u5c3c\u4e9e\u5217\u514b\u5e63|\u514b\u7f85\u5730\u4e9e\u5eab\u7d0d|\u7559\u5c3c\u6c6a\u5cf6\u6cd5\u90ce|\u514b\u7f85\u5730\u4e9e\u7b2c\u7d0d\u723e|\u963f\u723e\u5df4\u5c3c\u4e9e\u5217\u514b|\u6fa4\u897f\u938a|\u963f\u723e\u5df4\u5c3c\u4e9e\u5217\u514b (1946-1961)|\u99ac\u5176\u9813\u7b2c\u7d0d\u723e(1992-1993)|\u5317\u8d8a\u5357 \u540d \u76ae\u963f\u65af\u7279\u8d8a\u5357\u76fe|\u5317\u8d8a\u5357\u65b0\u76fe|\u99ac\u5176\u9813\u7b2c\u7d0d\u723e|\u5317\u8d8a\u5357 \u76ae\u963f\u65af\u7279\u8d8a\u5357\u76fe|\u5e1d\u6c76\u5143|CFP \u6cd5\u90ce|\u6bd4\u5229\u6642\u6cd5\u90ce \uff08\u91d1\u878d\uff09|\u5e7e\u5167\u4e9e\u62ab\u7d22\u62ab\u7d22|\u79d1\u5a01\u7279\u7b2c\u7d0d\u723e|\u8461\u5c6c\u5e7e\u5167\u4e9e\u7c73\u723e\u91cc\u65af|\u6bd4\u5229\u6642\u6cd5\u90ce|\u5e1d\u6c76 \u57c3\u65af\u5eab\u591a|\u6bd4\u5229\u6642\u6cd5\u90ce \uff08\u53ef\u8f49\u63db\uff09|\u8461\u5c6c\u5e7e\u5167\u4e9e\u57c3\u65af\u5eab\u591a|\u611b\u723e \u85a9\u723e\u74e6\u591a\u79d1\u90ce|\u5eab\u62c9\u514b \u76fe|\u5b5f\u52a0\u62c9\u5854\u5361|\u6e6f\u52a0\u82f1\u938a|\u6771\u52a0\u6f58\u52a0|\u897f\u975e \u6cd5\u90ce BCEAO|\u8607\u806f\u76e7\u5e03|\u8607\u806f\u65b0\u76e7\u5e03|\u8d6b\u5e03\u91cc\u5e95\u7fa4\u5cf6 CFP \u6cd5\u90ce|\u7dad\u5fb7\u89d2\u57c3\u65af\u5eab\u591a|\u6cd5\u570b\u5b89\u7684\u5217\u65af\u7fa4\u5cf6 \u897f\u975e \u6cd5\u90ce|\u5357\u975e\u862d\u7279|\u591a\u660e\u5c3c\u52a0\u62ab\u7d22|\u53e4\u5df4\u4eba\u5916\u532f\u5238|\u5357\u975e\u938a|\u5357\u975e - \u862d\u7279 (\u91d1\u878d)|\u7a81\u5c3c\u897f\u4e9e\u7b2c\u7d0d\u723e|\u53e4\u5df4\u62ab\u7d22|\u6cd5\u5c6c\u572d\u4e9e\u90a3\u6cd5\u90ce\u572d\u4e9e\u90a3|\u70cf\u5e72\u9054\u5148\u4ee4|\u932b\u862d\u76e7\u5e03|\u963f\u6cd5\u723e\u548c\u4f0a\u85a9\u6cd5\u90ce|\u68b5\u8482\u5ca1\u57ce\u91cc\u62c9|\u8056\u591a\u7f8e\u5cf6\u548c\u666e\u6797\u897f\u6bd4\u5cf6\u57c3\u65af\u5eab\u591a|\u70cf\u5e72\u9054\u5148\u4ee4 (1966-1987)|\u8056\u591a\u7f8e\u5cf6\u548c\u666e\u6797\u897f\u6bd4\u5cf6\u591a\u5e03\u62c9|\u99ac\u7d39\u723e\u7fa4\u5cf6\u7f8e\u5143|\u7d10\u897f\u862d\u938a|\u897f\u85a9\u6469\u4e9e\u5854\u62c9|\u897f\u85a9\u6469\u4e9e\u938a|\u6d2a\u90fd\u62c9\u65af\u502b\u76ae\u62c9|\u6cd5\u570b\u5927\u57ce\u5e02\u65b0 \u6cd5\u90ce|\u571f\u5eab\u66fc\u99ac\u7d0d\u7279|\u74dc\u5730\u99ac\u62c9\u683c\u67e5\u723e|\u7d10\u897f\u862d\u5e63|\u8607\u683c\u862d\u938a|\u5df4\u8c9d\u591a\u5143|\u7d0d\u7c73\u6bd4\u4e9e\u5143|\u99ac\u9054\u52a0\u65af\u52a0\u6cd5\u90ce|\u99ac\u9054\u52a0\u65af\u52a0\u827e\u745e\u723e|\u57c3\u53ca\u938a|\u82f1\u570b\u7684\u6d2a\u90fd\u62c9\u65af\u5143r|\u6ce2\u862d\u8332\u7f85\u63d0 (1950-1995)|\u6ce2\u58eb\u5c3c\u4e9e-\u9ed1\u585e\u54e5\u7dad\u90a3\u65b0\u7b2c\u7d0d\u723e|\u6ce2\u862d\u7f8e\u5143\u5916\u532f\u5238|\u6ce2\u58eb\u5c3c\u4e9e-\u9ed1\u585e\u54e5\u7dad\u90a3\u53ef\u8f49\u63db\u99ac\u514b|\u4f2f\u5229\u8332\u5143|\u6ce2\u58eb\u5c3c\u4e9e-\u9ed1\u585e\u54e5\u7dad\u90a3\u7b2c\u7d0d\u723e|\u6ce2\u862d\u8332\u7f85\u63d0|\u4e5f\u9580\u91cc\u4e9e\u723e|\u8607\u91cc\u5357\u76fe|\u6377\u514b\u65af\u6d1b\u4f10\u514b\u786c\u514b\u6717|\u97d3\u570b\u571c|\u767d\u4fc4\u7f85\u65af\u76e7\u5e03|\u4e5f\u9580\u963f\u99ac\u8fea\u91cc\u4e9e\u723e|\u767d\u4fc4\u7f85\u65af\u76e7\u5e03 (1992-1994)|\u6377\u514b\u514b\u6717|\u5357\u97d3\u820a\u5e63|\u97d3\u570b \u54c8\u74e6|\u767d\u4fc4\u7f85\u65af\u65b0\u76e7\u5e03 (1994-1999)|\u7d22\u99ac\u91cc\u862d\u5148\u4ee4|\u5e0c\u81d8\u65b0\u5fb7\u62c9\u514b\u99ac|\u5df4\u57fa\u65af\u5766\u76e7\u5e03|\u8f9b\u5df4\u5a01\u5143|\u65af\u91cc\u862d\u5361\u76e7\u5e03|\u5e0c\u81d8\u5fb7\u62c9\u514b\u99ac|\u611b\u723e\u862d\u938a|\u8449\u9580\u7b2c\u7d0d\u723e|\u76e7\u5b89\u9054\u6cd5\u90ce|\u54e5\u65af\u5927\u9ece\u52a0\u79d1\u90ce|\u5854\u5409\u514b\u65af\u5766 \u7d22\u83ab\u5c3c|\u5854\u5409\u514b\u65af\u5766\u76e7\u5e03|\u611b\u6c99\u5c3c\u4e9e\u514b\u6717|\u8d64\u9053\u5e7e\u5167\u4e9e\u6bd4\u585e\u5854|\u6469\u675c\u96f2\u76e7\u5e03\u5eab\u65c1|\u4e39\u9ea5\u514b\u7f85\u7d0d|\u6469\u675c\u96f2\u5217\u4f0a|\u8d64\u9053\u5e7e\u5167\u4e9e\u4f5b\u6717\u54e5|\u8d64\u9053\u5e7e\u5167\u4e9e\u57c3\u594e\u52d2|\u5370\u5c3c - \u76e7\u5e03|\u963f\u62c9\u4f2f\u806f\u5408\u5927\u516c\u570b\u8fea\u723e\u6c57|\u5317\u671d\u9bae\u5e63|\u5370\u5ea6\u5c3c\u897f\u4e9e\u65b0\u76e7\u5e03|\u6ce2\u672d\u90a3 - \u666e\u62c9|\u6469\u675c\u96f2\u5217\u4f0a\u5eab\u65c1|\u5370\u5ea6\u5c3c\u897f\u4e9e\u722a\u54c7\u76e7\u5e03|\u5317\u671d\u9bae\u4eba\u6c11\u5e63|\u5370\u5ea6\u5c3c\u897f\u4e9e\u5c3c\u53ef\u76fe|\u842c\u90a3\u675c\u842c\u675c|\u4f0a\u65af\u862d\u7b2c\u7d0d\u723e|\u7d22\u99ac\u5229\u4e9e\u5148\u4ee4|\u5b89\u9053\u723e\u966a\u58eb\u7279|\u4fc4\u7f85\u65af\u76e7\u5e03 (1991-1998)|\u74dc\u5fb7\u7f85\u666e\u5cf6\u6cd5\u90ce|\u5409\u5e03\u5730\u6cd5\u90ce|\u5b89\u9053\u723e\u7b2c\u7d0d\u723e|\u6469\u7d0d\u54e5\u6cd5\u90ce \u5091\u7c73\u90a3|\u6469\u7d0d\u54e5\u65b0\u6cd5\u90ce|\u5384\u74dc\u591a\u723e\u7531\u91cc\u9054\u74e6\u5eb7\u65af\u5766 (UVC)|\u5384\u74dc\u591a\u8607\u514b\u96f7|\u5217\u652f\u6566\u65af\u767b\u6cd5\u90ce|\u4fc4\u7f85\u65af\u76e7\u5e03|\u83f2\u5f8b\u8cd3\u62ab\u7d22|\u70cf\u8332\u5225\u514b\u65af\u5766 \u85a9\u6728|\u54e5\u502b\u6bd4\u4e9e\u62ab\u7d22|\u6cf0\u9296|\u5317\u611b\u723e\u862d\u938a|\u7dec\u7538\u76e7\u5e03|\u525b\u679c\u897f\u975e\u6cd5\u90ce|\u7dec\u7538\u5143|\u54e5\u502b\u6bd4\u4e9e\u62ab\u7d22\u9214|\u70cf\u8332\u5225\u514b\u65af\u5766 \u5eab\u90a6 \u7d22\u99ac|\u70cf\u514b\u862d \u5361\u672c\u74e6\u90a3\u8332|\u5361\u9054\u723e\u91cc\u4e9e\u723e|\u70cf\u514b\u862d\u683c\u91cc\u592b\u90a3|\u5e7e\u5167\u4e9e\u897f\u91cc|\u4eba\u6c11\u5e63|\u83ab\u4e09\u6bd4\u514b\u6885\u8482\u5361\u723e|\u4e2d\u570b\u7f8e\u5143\u5916\u532f\u5238|\u70cf\u62c9\u572d\u62ab\u7d22|\u5e7e\u5167\u4e9e\u6cd5\u90ce (1960-1972)|\u8056\u99ac\u5229\u8afe\u91cc\u62c9|\u83ab\u6851\u6bd4\u514b\u57c3\u65af\u5eab\u591a|\u4e2d\u570b\u4eba\u6c11\u5e63\u5143|\u5df4\u5e03\u4e9e\u7d10\u5e7e\u5167\u4e9e\u57fa\u90a3|\u963f\u66fc\u91cc\u4e9e\u723e\u4ed9\u8515i|\u5e7e\u5167\u4e9e\u6cd5\u90ce|\u70cf\u62c9\u572d\u62ab\u7d22 (1975-1993)|\u963f\u66fc\u91cc\u5967|\u6cd5\u570b UIC \u6cd5\u90ce|\u4e0d\u4e39\u76e7\u5e03|\u624e\u4f0a\u723e\u624e\u4f0a\u723e|\u6cd5\u570b\u91d1\u6cd5\u90ce|\u70cf\u62c9\u572d\u62ab\u7d22\u798f\u5384\u7279|\u99ac\u4f86\u897f\u4e9e - \u6797\u5409\u7279|\u85a9\u4f0a\u624e\u65b0\u4f0a\u723e|\u963f\u585e\u62dc\u5f4a\u99ac\u7279\u7d0d|\u5ca1\u6bd4\u4e9e\u938a|\u79d1\u6469\u7f85\u6cd5\u90ce|\u7345\u5b50\u5c71\u5229\u6602|\u7518\u6bd4\u4e9e\u9054\u62c9\u897f|\u6b50\u6d32\u8ca8\u5e63\u55ae\u4f4d|\u5df4\u54c8\u99ac\u938a|\u5361\u9ea5\u9686\u897f\u975e\u6cd5\u90ce|\u58a8\u897f\u54e5\u6cd5\u5f8b\u53cd\u8f49(UDI)|\u897f\u975e \u6cd5\u90ce BCEAEC|\u5df4\u54c8\u99ac\u5143|\u58a8\u897f\u54e5\u9280\u62ab\u7d22 (1861-1992)|\u58a8\u897f\u54e5 - \u62ab\u7d22|\u79d8\u9b6f\u592a\u967d\u5e63|\u683c\u9675\u862d\u514b\u7f85\u9209|\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1942-1967)|\u79d8\u9b6f\u65b0\u592a\u967d\u5e63|\u667a\u5229\u62ab\u7d22|\u65af\u6d1b\u4f10\u514b\u514b\u6717|\u7955\u9b6f\u56e0\u8482|\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85|\u7279\u6b8a\u63d0\u6b3e\u6b0a|\u6cd5\u570b\u6cd5\u90ce \u6377\u7c73\u90a3/\u9f90\u52a0\u840a\u6cd5\u90ce|\u6cd5\u570b\u6cd5\u90ce|\u5df4\u897f \u514b\u5982\u723e\u9054 \u8fb2\u74e6|\u5361\u6797\u6cb9\u9054\u4f5b\u66fc\u8dce|\u667a\u5229\u57c3\u65af\u5eab\u591a|\u5df4\u897f\u91cc\u62c9|\u667a\u5229 \u5eb7\u5c0e|\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1990-1993)|\u5fb7\u570b \u8607\u99ac\u514bSperrmark|\u99ac\u62c9\u7dad\u938a|\u5df4\u897f\u514b\u9b6f\u8cfd\u7f85 (1986-1989)|\u5df4\u897f\u514b\u9b6f\u85a9\u591a \u8fb2\u74e6 (1967-1986)|\u99ac\u62c9\u7dad\u514b\u74e6\u67e5|\u8eca\u57ce\u76e7\u5e03|\u5fb7\u570b\u99ac\u514b|\u4e4d\u5f97 \u897f\u975e \u6cd5\u90ce|\u8eca\u57ce\u65b0\u76e7\u5e03|\u8eca\u57ce\u76e7\u5e03 Kupon|\u5c3c\u6cca\u723e\u76e7\u5e03|\u5eab\u514b\u7fa4\u5cf6\u5143|\u65e5\u5713|\u99ac\u723e\u5730\u592b\u6d77\u5cf6\u76e7\u975e\u4e9e|\u897f\u975e \u65b0 \u6cd5\u90ce|\u99ac\u723e\u5730\u592b\u76e7\u5e03|\u683c\u745e\u90a3\u9054\u5143|\u65af\u6d1b\u7dad\u5c3c\u4e9e\u6258\u52d2|\u5357\u65af\u62c9\u592b\u6539\u5236\u5f8c\u7684\u7b2c\u7d0d\u723e|\u963f\u9b6f\u5df4\u76fe|\u5357\u65af\u62c9\u592b\u5341\u6708 \u7b2c\u7d0d\u723e|\u6771\u5fb7\u6771\u5fb7\u99ac\u514b|\u5357\u65af\u62c9\u592b \u53ef\u8f49\u63db\u7b2c\u7d0d\u723e|\u5357\u65af\u62c9\u592b\u632a\u5a01\u4e9e\u7b2c\u7d0d\u723e|\u571f\u8033\u5176\u4eba\u548c\u51f1\u79d1\u65af\u51a0|\u5357\u65af\u62c9\u592b\u4eba1994 \u7b2c\u7d0d\u723e|\u5357\u65af\u62c9\u592b\u806f\u90a6\u7b2c\u7d0d\u723e|\u7f85\u99ac\u5c3c\u4e9e\u65b0\u5217\u4f0a|\u5357\u65af\u62c9\u592b\u7b2c\u7d0d\u723e\u786c\u5e63|\u7f85\u99ac\u5c3c\u4e9e\u5217\u4f0a|\u65af\u6d1b\u6587\u5c3c\u4e9e Tolar Bons|\u632a\u5a01\u514b\u7f85\u7d0d|\u6a21\u91cc\u897f\u65af\u76e7\u5e03|\u6b50\u6d32\u6703\u8a08\u55ae\u4f4d(XBD)|\u76f4\u5e03\u7f85\u9640\u938a|\u8d8a\u5357\u570b\u5bb6\u76fe|\u6b50\u6d32\u6703\u8a08\u55ae\u4f4d(XBC)|\u8d8a\u5357\u5171\u548c\u570b \u76fe|\u6b50\u6d32\u8ca8\u5e63\u55ae\u4f4d|\u6b50\u6d32\u7d9c\u5408\u55ae\u4f4d|\u8056\u8d6b\u52d2\u62ff \u938a|\u8d8a\u5357\u65b0\u76fe";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "GBP|XOF|TDF|ECV|XAF|NZD|EUR|XPF|XTR|KRW|BOV|SGD|XEF|XBD|XFU|XBC|MXV|CNY|MOP|GAF|AZM|XCF";

  private static final String currenciesSymbolValues = "GBP|XOF|TDF|ECV|XAF|$NZ|EUR|XPF|XTR|KRW|BOV|SGD|XEF|XBD|XFU|XBC|MXV|CNY|MOP|GAF|AZM|XCF";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[][] zoneStrings =
  {
    { "", "\u592a\u5e73\u6d0b\u6a19\u6e96\u6642\u9593", "", "\u592a\u5e73\u6d0b\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/Los_Angeles" },
    { "", "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593", "", "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593",  "Africa/Casablanca" },
    { "", "\u6771\u90e8\u6a19\u6e96\u6642\u9593", "", "\u6771\u90e8\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/New_York" },
    { "", "\u963f\u62c9\u65af\u52a0\u6a19\u6e96\u6642\u9593", "", "\u963f\u62c9\u65af\u52a0\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/Anchorage" },
    { "", "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593", "", "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593",  "Etc/GMT" },
    { "", "\u4e2d\u570b\u6a19\u6e96\u6642\u9593", "", "\u4e2d\u570b\u6a19\u6e96\u6642\u9593",  "Asia/Shanghai" },
    { "", "\u5927\u897f\u6d0b\u6a19\u6e96\u6642\u9593", "", "\u5927\u897f\u6d0b\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/Halifax" },
    { "", "\u4e2d\u6b50\u6a19\u6e96\u6642\u9593", "", "\u4e2d\u6b50\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "Europe/Paris" },
    { "", "\u5c71\u5340\u6a19\u6e96\u6642\u9593", "", "\u5c71\u5340\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/Denver" },
    { "", "\u4ee5\u8272\u5217\u6a19\u6e96\u6642\u9593", "", "\u4ee5\u8272\u5217\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "Asia/Jerusalem" },
    { "", "\u590f\u5a01\u5937\u6a19\u6e96\u6642\u9593", "", "\u590f\u5a01\u5937\u6a19\u6e96\u6642\u9593",  "Pacific/Honolulu" },
    { "", "\u7d10\u82ac\u862d\u6a19\u6e96\u6642\u9593", "", "\u7d10\u82ac\u862d\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/St_Johns" },
    { "", "\u6771\u90e8\u6a19\u6e96\u6642\u9593", "", "\u6771\u90e8\u6a19\u6e96\u6642\u9593",  "America/Indianapolis" },
    { "", "\u4e2d\u90e8\u6a19\u6e96\u6642\u9593", "", "\u4e2d\u90e8\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "America/Chicago" },
    { "", "\u6771\u6b50\u6a19\u6e96\u6642\u9593", "", "\u6771\u6b50\u65e5\u5149\u7bc0\u7d04\u6642\u9593",  "Europe/Bucharest" },
    { "", "\u65e5\u672c\u6a19\u6e96\u6642\u9593", "", "\u65e5\u672c\u6a19\u6e96\u6642\u9593",  "Asia/Tokyo" },
    { "", "\u5c71\u5340\u6a19\u6e96\u6642\u9593", "", "\u5c71\u5340\u6a19\u6e96\u6642\u9593",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SJ|SI|SH|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ER|EE|EC|DZ|QA|DO|DM|PW|DK|DJ|PS|PR|DE|PN|PM|PL|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CR|CO|CN|CM|CK|CI|CG|CF|CD|CC|OM|BZ|BY|BW|BV|BS|NZ|BO|BN|BM|NU|BJ|BI|NR|BG|BF|NP|BE|BD|BB|ZW|NL|BA|NG|NF|AZ|NE|NC|AW|ZM|AU|NA|AT|AS|AQ|MZ|MY|AN|AM|MW|AL|MV|MU|MT|AI|MS|MR|AG|MQ|MP|AE|MO|AD|MM|ML|MK|YT|MH|MG|MD|MC|YE|LY|LV|LU|LS|LR|LK|LI|LC|LA|KZ|KY|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JO|JM|VU|VI|VG|VE|VC|VA|IT|IS|UZ|IO|UY|US|IE|ID|UM|UG|UA|HR|TZ|HN|HM|TW|TV|HK|TT|TO|TN|TM";

  private static final String territoriesValues = "\u6771\u5e1d\u6587|\u6258\u514b\u52de\u7fa4\u5cf6|\u5854\u5409\u514b|\u6cf0\u570b|\u591a\u54e5\u5171\u548c\u570b|\u6cd5\u570b\u5357\u5c6c\u5730|\u84cb\u4e9e\u7d0d|\u67e5\u5fb7|\u571f\u514b\u65af\u53ca\u958b\u79d1\u65af\u7fa4\u5cf6|\u5e7e\u5167\u4e9e\u6bd4\u7d22|\u95dc\u5cf6|\u74dc\u5730\u99ac\u62c9|\u5357\u55ac\u6cbb\u4e9e\u8207\u5357\u4e09\u660e\u6cbb\u7fa4\u5cf6|\u5e0c\u81d8|\u8d64\u9053\u5e7e\u5167\u4e9e|\u54e5\u5fb7\u666e\u6d1b|\u53f2\u74e6\u6fdf\u862d|\u6558\u5229\u4e9e|\u5e7e\u5167\u4e9e|\u7518\u6bd4\u4e9e|\u683c\u9675\u862d|\u85a9\u723e\u74e6\u591a|\u8056\u591a\u7f8e\u53ca\u666e\u6797\u897f\u6bd4|\u76f4\u5e03\u7f85\u9640|\u8fe6\u7d0d|\u8607\u5229\u5357|\u6cd5\u5c6c\u572d\u4e9e\u90a3|\u585e\u723e\u7dad\u4e9e|\u55ac\u6cbb\u4e9e\u5171\u548c\u570b|\u7d22\u99ac\u5229\u4e9e|\u683c\u745e\u7d0d\u9054|\u585e\u5167\u52a0\u723e|\u8056\u99ac\u5229\u8afe|\u82f1\u570b|\u7345\u5b50\u5c71|\u52a0\u5f6d|\u51b7\u5cb8\u53ca\u592e\u9ea5\u6069\u7fa4\u5cf6|\u65af\u6d1b\u7dad\u5c3c\u4e9e|\u8056\u8d6b\u52d2\u62ff\u5cf6|\u8607\u4e39|\u585e\u5e2d\u723e|\u7d22\u7f85\u9580\u7fa4\u5cf6|\u6c99\u70cf\u5730\u963f\u62c9\u4f2f|\u6cd5\u570b|\u6cd5\u7f85\u7fa4\u5cf6|\u5bc6\u514b\u7f85\u5c3c\u897f\u4e9e\u7fa4\u5cf6|\u76e7\u5b89\u9054|\u798f\u514b\u862d\u7fa4\u5cf6|\u4fc4\u7f85\u65af|\u6590\u6fdf|\u82ac\u862d|\u7f85\u99ac\u5c3c\u4e9e|\u7559\u5c3c\u65fa|\u8863\u7d22\u6bd4\u4e9e|\u5384\u5229\u5782\u4e9e|\u611b\u6c99\u5c3c\u4e9e|\u5384\u74dc\u591a\u723e|\u963f\u723e\u53ca\u5229\u4e9e|\u5361\u9054|\u591a\u660e\u5c3c\u52a0\u5171\u548c\u570b|\u591a\u660e\u5c3c\u52a0|\u5e1b\u7409|\u4e39\u9ea5|\u5409\u5e03\u5730|\u5df4\u52d2\u65af\u5766|\u73bb\u591a\u9ece\u514b|\u5fb7\u570b|\u76ae\u7279\u5eb7|\u8056\u5f7c\u5fb7\u8207\u5bc6\u555f\u5d19|\u6ce2\u862d|\u83f2\u5f8b\u8cd3|\u5df4\u5e03\u4e9e\u7d10\u5e7e\u5167\u4e9e|\u6cd5\u5c6c\u73bb\u91cc\u5c3c\u897f\u4e9e|\u6377\u514b\u5171\u548c\u570b|\u79d8\u9b6f|\u8cfd\u666e\u52d2\u65af|\u8056\u8a95\u5cf6|\u7dad\u5fb7\u89d2|\u5df4\u62ff\u99ac|\u54e5\u65af\u5927\u9ece\u52a0|\u54e5\u502b\u6bd4\u4e9e|\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u570b|\u5580\u9ea5\u9686|\u5eab\u514b\u7fa4\u5cf6|\u79d1\u7279\u8fea\u74e6|\u525b\u679c|\u4e2d\u975e\u5171\u548c\u570b|\u525b\u679c\u6c11\u4e3b\u5171\u548c\u570b|\u53ef\u53ef\u65af\u7fa4\u5cf6|\u963f\u66fc\u738b\u570b|\u8c9d\u91cc\u65af|\u767d\u4fc4\u7f85\u65af|\u6ce2\u672d\u90a3|\u5e03\u5a01\u5cf6|\u5df4\u54c8\u99ac|\u7d10\u897f\u862d|\u73bb\u5229\u7dad\u4e9e|\u6c76\u840a|\u767e\u6155\u9054|\u7d10\u5a01\u5cf6|\u8c9d\u5357|\u6d66\u9686\u5730|\u8afe\u9b6f|\u4fdd\u52a0\u5229\u4e9e|\u5e03\u57fa\u7d0d\u6cd5\u7d22|\u5c3c\u6cca\u723e|\u6bd4\u5229\u6642|\u5b5f\u52a0\u62c9|\u5df4\u8c9d\u591a|\u8f9b\u5df4\u5a01|\u8377\u862d|\u6ce2\u58eb\u5c3c\u4e9e\u8207\u8d6b\u585e\u683c\u7dad\u7d0d|\u5948\u53ca\u5229\u4e9e|\u8afe\u798f\u514b\u5cf6|\u4e9e\u585e\u62dc\u7136|\u5c3c\u65e5|\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u7fa4\u5cf6|\u963f\u8def\u5df4|\u5c1a\u6bd4\u4e9e|\u6fb3\u6d32|\u7d0d\u7c73\u6bd4\u4e9e|\u5967\u5730\u5229|\u7f8e\u5c6c\u85a9\u6469\u4e9e\u7fa4\u5cf6|\u5357\u6975\u6d32|\u83ab\u4e09\u6bd4\u514b|\u99ac\u4f86\u897f\u4e9e|\u8377\u5c6c\u5b89\u5730\u5217\u65af|\u4e9e\u7f8e\u5c3c\u4e9e|\u99ac\u62c9\u5a01|\u963f\u723e\u5df4\u5c3c\u4e9e|\u99ac\u723e\u5730\u592b|\u6a21\u91cc\u897f\u65af|\u99ac\u723e\u4ed6|\u5b89\u572d\u62c9\u5cf6|\u8499\u7279\u8272\u62c9\u7279\u5cf6|\u8305\u5229\u5854\u5c3c\u4e9e|\u5b89\u5730\u5361\u53ca\u5df4\u5e03\u9054|\u99ac\u4e01\u5c3c\u514b\u5cf6|\u5317\u99ac\u91cc\u5b89\u7d0d|\u963f\u62c9\u4f2f\u806f\u5408\u5927\u516c\u570b|\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u570b\u6fb3\u9580\u7279\u5225\u884c\u653f\u5340|\u5b89\u9053\u723e|\u7dec\u7538|\u99ac\u5229|\u99ac\u5176\u9813|\u99ac\u7d04\u7279|\u99ac\u7d39\u723e\u7fa4\u5cf6|\u99ac\u9054\u52a0\u65af\u52a0|\u6469\u723e\u591a\u74e6|\u6469\u7d0d\u54e5|\u8449\u9580|\u5229\u6bd4\u4e9e|\u62c9\u812b\u7dad\u4e9e|\u76e7\u68ee\u5821|\u8cf4\u7d22\u6265|\u8cf4\u6bd4\u745e\u4e9e|\u65af\u91cc\u862d\u5361|\u5217\u652f\u6566\u65af\u767b|\u8056\u9732\u897f\u4e9e|\u5bee\u570b|\u54c8\u85a9\u514b|\u958b\u66fc\u7fa4\u5cf6|\u5357\u97d3|\u5317\u97d3|\u8056\u514b\u91cc\u65af\u591a\u798f\u53ca\u5c3c\u7dad\u65af|\u79d1\u6469\u7f85\u7fa4\u5cf6|\u5409\u91cc\u5df4\u65af|\u85a9\u6469\u4e9e\u7fa4\u5cf6|\u9ad8\u68c9|\u5409\u723e\u5409\u65af|\u80af\u4e9e|\u74e6\u5229\u65af\u548c\u798f\u675c\u7d0d\u7fa4\u5cf6|\u7d04\u65e6|\u7259\u8cb7\u52a0|\u842c\u90a3\u675c|\u7f8e\u5c6c\u7dad\u723e\u4eac\u7fa4\u5cf6|\u82f1\u5c6c\u7dad\u723e\u4eac\u7fa4\u5cf6|\u59d4\u5167\u745e\u62c9|\u8056\u6587\u68ee\u53ca\u683c\u745e\u90a3\u4e01|\u68b5\u5e1d\u5ca1|\u7fa9\u5927\u5229|\u51b0\u5cf6|\u70cf\u8332\u5225\u514b|\u82f1\u5c6c\u5370\u5ea6\u6d0b\u9818\u571f|\u70cf\u62c9\u572d|\u7f8e\u570b|\u611b\u723e\u862d|\u5370\u5c3c|\u7f8e\u5c6c\u908a\u7586\u7fa4\u5cf6|\u70cf\u5e72\u9054|\u70cf\u514b\u862d|\u514b\u7f85\u57c3\u897f\u4e9e|\u5766\u5c1a\u5c3c\u4e9e|\u5b8f\u90fd\u62c9\u65af|\u8d6b\u5fb7\u8207\u9ea5\u514b\u7576\u8afe\u7fa4\u5cf6|\u81fa\u7063|\u5410\u74e6\u9b6f|\u4e2d\u83ef\u4eba\u6c11\u5171\u548c\u570b\u9999\u6e2f\u7279\u5225\u884c\u653f\u5340|\u5343\u91cc\u9054\u53ca\u6258\u5df4\u54e5|\u6771\u52a0|\u7a81\u5c3c\u897f\u4e9e|\u571f\u5eab\u66fc";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|kut|mic|wa|kum|zap|cus|jbo|doi|oto|vai|rar|ve|rap|raj|ota|nzi|uz|uga|tmh|nai|nah|ur|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|ty|tw|srr|tli|tt|bad|to|tn|tk|ti|kru|te|kro|csb|ta|tkl|efi|sw|su|krc|sr|sq|men|crp|so|sn|sm|sl|grc|grb|si|sh|crh|afa|se|sd|udm|sc|rw|mdr|ro|rm|tiv|ady|zun|qu|tig|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|nub|ps|phn|goh|ach|yao|phi|ace|pl|pi|bug|sms|bua|mas|smn|map|os|or|smj|smi|mak|mai|mag|oj|mad|sma|oc|myv|dgr|myn|ny|nv|nr|gmh|nn|nl|ng|sla|ne|nd|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|mo|jrb|ml|mk|mh|mg|mwr|den|lu|del|lo|li|ewo|lg|lb|jpr|sit|ky|kw|ku|sio|ks|kr|ko|kn|km|kl|kk|kj|rom|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|gil|znd|shn|fon|xal|aus|kho|pau|chy|iu|it|pap|sgn|is|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|ik|pag|chk|ii|lam|ig|sga|ie|paa|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|ht|dak|hr|ho|hi|he|ast|wen|gv|gu|sem|iro|sel|gl|gez|art|gd|ira|ga|arn|fy|bla|gem|ypk|fo|cel|fj|fi|ff|tvl|ceb|et|eo|el|tut|niu|tup|ee|tum|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|lua|bik|was|und|war|da|dum|mno|wak|sat|cy|sas|kbd|cv|mni|sam|cr|sal|dua|mnc|sah|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|tsi|ang|cau|kab|kaa|bs|bo|gaa|cai|bi|bh|bg|be|ba|zu|zen|pro|az|ay|av|as|dsb|ilo|elx|an|pra|new|ak|za|af|ae|ab|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "\u572d\u5951\u6587|\u827e\u5361\u6731\u514b\u6587|\u4f0a\u55ac\u6587|\u73ed\u5716\u6587|\u8607\u7f8e\u6587|\u8607\u8607\u6587|\u5176\u4ed6\u8a9e\u8a00|\u6d1b\u9f4a\u6587|\u6e6f\u52a0\u6587(\u5c3c\u4e9e\u85a9\u6587)|\u6ce2\u90a3\u8c9d\u6587|\u7c73\u5357\u5361\u5821\u6587|\u8607\u5eab\u99ac\u6587|\u6c83\u723e\u592b\u6587|\u5eab\u7279\u5948\u6587|\u7c73\u514b\u99ac\u514b\u6587|\u74e6\u9686\u6587|\u5eab\u5bc6\u514b\u6587|\u85a9\u6ce2\u7279\u514b\u6587|\u5eab\u65bd\u7279\u8a9e\u7cfb\uff08\u5176\u4ed6\uff09|\u908f\u8f2f\u6587|\u591a\u683c\u4f86\u6587|\u5967\u6258\u7c73\u6587|\u8d8a\u5357\u6587|\u62c9\u7f85\u901a\u52a0\u6587|\u6eab\u9054\u6587|\u5fa9\u6d3b\u5cf6\u6587|\u62c9\u8cc8\u65af\u5766\u8af8\u6587|\u9102\u5716\u66fc\u571f\u8033\u5176\u6587 (1500-1928)|\u5c3c\u8332\u99ac\u6587|\u70cf\u8332\u5225\u514b\u6587|\u70cf\u52a0\u5217\u6587|\u5854\u99ac\u5947\u514b\u6587|\u5176\u4ed6\u5317\u7f8e\u5370\u5730\u5b89\u6587|\u7d0d\u74e6\u7279\u6587|\u70cf\u723e\u90fd\u6587|\u70cf\u514b\u862d\u6587|\u53e4\u57c3\u53ca\u6587)|\u7dad\u543e\u723e\u6587|\u82b3\u65cf\u6587|\u975e\u6d32\u6492\u54c8\u62c9\u6c99\u6f20\u908a\u7de3\u5730\u5e36\u6587|\u611b\u723e\u862d\u6587\uff0c\u4e2d\u53e4 (900-1200)|\u6ce2\u7f85\u7684\u6587\uff08\u5176\u4ed6\uff09|\u5c3c\u5967\u56c9\u6587|\u5df4\u85a9\u6587|\u5c3c\u63da\u79d1\u840a\u6587|\u5c3c\u63da\u97cb\u9f4a\u6587|\u5b5f\u6587|\u5df4\u5398\u6587|\u6b50\u585e\u5947\u6587|\u5927\u6eaa\u5730\u6587|\u7e41\u9ad4\u4e2d\u6587|\u585e\u96f7\u723e\u6587|\u7279\u6797\u57fa\u7279\u6587|\u97c3\u977c\u6587|\u73ed\u9054\u6587|\u6771\u52a0\u6587|\u7a81\u5c3c\u897f\u4e9e\u6587|\u571f\u5eab\u66fc\u6587|\u63d0\u683c\u5229\u5c3c\u4e9e\u6587|\u5eab\u9b6f\u79d1\u6587|\u6cf0\u76e7\u56fa\u6587|\u514b\u9b6f\u6587|\u5361\u8212\u5e03\u6587|\u5766\u7c73\u723e\u6587|\u6258\u514b\u52de\u6587|\u57c3\u83f2\u514b\u6587|\u53f2\u74e6\u5e0c\u91cc\u6587|\u8607\u4e39\u6587|\u5361\u62c9\u67f4-\u5305\u723e\u5361\u723e\u6587|\u585e\u723e\u7dad\u4e9e\u6587|\u963f\u723e\u5df4\u5c3c\u4e9e\u6587|\u9580\u5fb7\u6587|\u514b\u91cc\u5967\u723e\u6587\u548c\u76ae\u6b3d\u6587|\u7d22\u99ac\u5229\u6587|\u585e\u5167\u52a0\u723e\u6587|\u85a9\u6469\u4e9e\u6587|\u65af\u6d1b\u7dad\u5c3c\u4e9e\u6587|\u53e4\u5e0c\u81d8\u6587 (\u81f3 1453)|\u54e5\u535a\u8a9e|\u50e7\u4f3d\u7f85\u6587|\u585e\u723e\u7dad\u4e9e\u514b\u7f85\u57c3\u897f\u4e9e\u6587|\u514b\u91cc\u7c73\u4e9e\u534a\u5cf6\u7684\u571f\u8033\u5176\u6587\uff1b\u514b\u91cc\u7c73\u4e9e\u534a\u5cf6\u7684\u5854\u5854\u723e\u6587|\u975e\u9583\u65cf\u53ca\u975e\u4e9e\u8a9e\u8a00|\u5317\u65b9\u85a9\u7c73\u6587|\u8607\u4e39\u6587|\u6c83\u8482\u827e\u514b\u6587|\u6492\u4e01\u6587|\u76e7\u5b89\u9054\u6587|\u66fc\u9054\u6587|\u7f85\u99ac\u5c3c\u4e9e\u6587|\u91cc\u6258\u7f85\u66fc\u65af\u6587|\u63d0\u592b\u6587|\u963f\u8fea\u5404\u6587|\u7956\u5c3c\u6587|\u84cb\u4e18\u4e9e\u6587|\u8482\u683c\u96f7\u6587|\u6b50\u6d32\u8154\u8abf\u548c\u6d0b\u6d87\u6ff1\uff0c\u6e90\u81ea\u8461\u8404\u7259\u6587\u7684(\u5176\u4ed6)|\u7d22\u683c\u5e95\u4e9e\u7d0d\u6587|\u963f\u7576\u83ab\u6587|\u79d1\u65af\u96f7\u6069\u6587|\u8d6b\u68af\u6587|\u6b50\u6d32\u8154\u8abf\u548c\u6d0b\u6d87\u6ff1\uff0c\u6e90\u81ea\u6cd5\u6587\u7684(\u5176\u4ed6)|\u6b50\u6d32\u8154\u8abf\u548c\u6d0b\u6d87\u6ff1\uff0c\u6e90\u81ea\u82f1\u6587\u7684(\u5176\u4ed6)|\u8d6b\u99ac\u67e5\u5229\u6587|\u8ca2\u6839\u6587|\u5e0c\u5229\u84cb\u8fb2\u6587|\u54e5\u7279\u6587|\u79d1\u9686\u9054\u7f85\u6587|\u5ca1\u5fb7\u6587|\u52aa\u6bd4\u4e9e\u6587|\u666e\u4ec0\u5716\u6587|\u8153\u5c3c\u57fa\u6587|\u5fb7\u6587,\u4e0a\u53e4\u5168\u76db\u6642\u671f (ca.750-1050)|\u963f\u50d1\u5229\u6587|\u7464\u6587|\u5176\u4ed6\u83f2\u5f8b\u8cd3\u6587|\u4e9e\u9f4a\u6587|\u6ce2\u862d\u6587|\u5df4\u5229\u6587|\u5e03\u5409\u65af\u6587|\u65af\u79d1\u7279\u85a9\u7c73\u6587|\u5e03\u91cc\u963f\u7279\u6587|\u99ac\u8cfd\u6587|\u4f0a\u7d0d\u88e1\u85a9\u7c73\u6587|\u5357\u5cf6\u6587|\u5967\u585e\u63d0\u6587|\u6b50\u91cc\u4e9e\u6587|\u9b6f\u52d2\u85a9\u7c73\u6587|\u5176\u4ed6\u85a9\u7c73\u6587|\u671b\u52a0\u932b\u6587|\u9081\u8482\u5229\u6587|\u99ac\u52a0\u4f0a\u6587|\u5967\u6770\u5e03\u74e6\u6587|\u99ac\u90fd\u62c9\u6587|\u5357\u85a9\u7c73\u6587|\u5967\u897f\u5766\u6587|\u5384\u723e\u8332\u4e9e\u6587|\u591a\u683c\u91cc\u5e03\u6587|\u99ac\u96c5\u6587|\u5c3c\u63da\u8cc8\u6587|\u7d0d\u74e6\u7d04\u6587|\u5357\u5730\u7562\u5217\u6587|\u5fb7\u6587, \u4e2d\u53e4\u5168\u76db\u6642\u671f (ca.1050-1500)|\u65b0\u632a\u5a01\u6587|\u8377\u862d\u6587|\u6069\u6771\u52a0\u6587|\u5176\u4ed6\u65af\u62c9\u592b\u6587|\u5c3c\u6cca\u723e\u6587|\u5317\u5730\u7562\u5217\u6587|\u6cf0\u9813\u6587|\u632a\u5a01\u6ce2\u514b\u9ed8\u723e\u6587|\u8afe\u9b6f\u6587|\u6cf0\u96f7\u8afe\u6587|\u63d0\u59c6\u6587|\u7dec\u7538\u6587|\u7acb\u9676\u5b9b\u6587|\u99ac\u723e\u4ed6\u6587|\u53e4\u6ce2\u65af\u6587 (ca.600-400 B.C.)|\u99ac\u4f86\u6587|\u99ac\u62c9\u5730\u6587|\u6469\u723e\u591a\u74e6\u6587|\u7336\u592a\u6559-\u963f\u62c9\u4f2f\u6587|\u99ac\u4f86\u4e9e\u62c9\u59c6\u6587|\u99ac\u5176\u9813\u6587|\u99ac\u7d39\u723e\u6587|\u99ac\u723e\u52a0\u4ec0\u6587|\u99ac\u723e\u5c3c\u88e1\u6587|\u65af\u62c9\u592b|\u9b6f\u5df4\u52a0\u4e39\u52a0\u6587|\u5fb7\u62c9\u74e6|\u5bee\u570b\u6587|\u6797\u5821\u6587|\u4f9d\u6c6a\u90fd\u6587|\u5e72\u9054\u6587|\u76e7\u68ee\u5821\u6587|\u7336\u592a\u6559-\u6ce2\u65af\u6587|\u5176\u4ed6\u6f22\u85cf\u6587|\u5409\u723e\u5409\u65af\u6587|\u5eb7\u74e6\u8033\u6587|\u5eab\u723e\u5fb7\u6587|\u5927\u8607\u6587|\u514b\u4ec0\u7c73\u723e\u6587|\u5361\u52aa\u88e1\u6587|\u97d3\u6587|\u574e\u90a3\u9054\u6587|\u9ad8\u68c9\u6587|\u683c\u9675\u862d\u6587|\u54c8\u85a9\u514b\u6587|\u5ee3\u4e9e\u99ac\u6587|\u5409\u666e\u8cfd\u6587|\u5e0c\u9054\u6469\u6587|\u5409\u5eab\u5c24\u4eba|\u525b\u679c\u6587|\u53e4\u8afe\u723e\u65af\u6587|\u55ac\u6cbb\u4e9e\u6587|\u514b\u91cc\u514b\u6587|\u5176\u4ed6\u7f85\u66fc\u6587|\u8afe\u84cb\u6587|\u8499\u9054\u6587|\u591a\u7a2e\u8a9e\u8a00|\u5409\u723e\u4f2f\u7279\u7fa4\u5cf6\u6587|\u8d0a\u5fb7\u6587|\u64a3\u6587|\u8c50\u6587|\u5361\u723e\u6885\u514b\u6587|\u6fb3\u6d32\u82f1\u6587|\u548c\u95d0[\u8207\u95d0]\u6587|\u5e1b\u7409\u6587|\u6c99\u4f0a\u5b89\u6587|\u56e0\u7d10\u7279\u6587|\u7fa9\u5927\u5229\u6587|\u5e15\u76ae\u963f\u9580\u6258\u6587|\u624b\u8a9e|\u51b0\u5cf6\u6587|\u67f4\u7f85\u57fa\u6587|\u6f58\u5e15\u5609\u6587|\u5df4\u5217\u7dad\u6587|\u5947\u4f69\u74e6\u63da\u6587|\u4f0a\u6717\u6587|\u55ac\u514b\u6258\u6587|\u5951\u5974\u514b\u6587|\u99ac\u91cc\u6587|\u571f\u51e1\u6587|\u73ed\u5716\u6587|\u4f9d\u5974\u76ae\u7dad\u514b\u6587|\u6f58\u52a0\u8f9b\u6587|\u8655\u5947\u65af\u6587|\u56db\u5ddd\u8a71|\u862d\u5df4\u6587|\u4f0a\u5e03\u6587|\u53e4\u611b\u723e\u862d\u6587\uff08\u81f3 900\uff09|\u62c9\u4e01\u570b\u969b\u6587|\u5176\u4ed6\u5df4\u5e03\u4e9e\u8af8\u8a9e\u8a00|\u5370\u5c3c\u6587|\u62c9\u4ea8\u9054\u6587|\u8fea\u96c5\u514b\u6587|\u5947\u5e03\u67e5\u6587|\u62c9\u4e01\u570b\u969b\u6587|\u62c9\u8fea\u8afe\u6587|\u8d6b\u96f7\u7f85\u6587|\u6d77\u9054\u6587|\u9054\u723e\u683c\u74e6\u6587|\u4e9e\u7f8e\u5c3c\u4e9e\u6587|\u963f\u85a9\u5df4\u65af\u5361\u6587|\u6d77\u5730\u4eba|\u9054\u79d1\u4ed6\u6587|\u514b\u7f85\u57c3\u897f\u4e9e\u6587|\u897f\u91cc\u83ab\u5716\u571f\u6587|\u5317\u5370\u5ea6\u6587|\u5e0c\u4f2f\u4f86\u6587|\u963f\u65af\u5716\u91cc\u4e9e\u6587|\u6587\u5fb7\u6587|\u66fc\u5cf6\u6587|\u5409\u4e9e\u62c9\u5854\u6587|\u5176\u4ed6\u9583\u65cf\u8a9e\u8a00|\u6613\u6d1b\u9b41\u6587|\u745f\u723e\u5361\u666e\u6587|\u52a0\u91cc\u897f\u4e9e\u6587|\u5409\u8332\u6587|\u5176\u4ed6\u4eba\u5de5\u8a9e\u8a00|\u8607\u683c\u862d - \u84cb\u723e\u6587|\u4f0a\u82b3\u6717\u6587|\u611b\u723e\u862d\u6587|\u963f\u52de\u574e\u6587|\u5f17\u91cc\u65af\u862d\u6587|\u932b\u514b\u932b\u5361\u6587|\u5fb7\u570b\u7684(\u5176\u4ed6)|\u611b\u65af\u57fa\u6469\u6587|\u6cd5\u7f85\u6587|\u514b\u723e\u7279\u6587\uff08\u5176\u4ed6\uff09|\u6590\u6fdf\u6587|\u82ac\u862d\u6587|\u5bcc\u62c9\u6587|\u5410\u74e6\u9b6f\u6587|\u5bbf\u52d9\u65cf\u6587|\u611b\u6c99\u5c3c\u4e9e\u6587|\u4e16\u754c\u8a9e|\u5e0c\u81d8\u6587|\u5176\u4ed6\u963f\u723e\u6cf0\u8af8\u6587|\u7d10\u57c3\u6587|\u5716\u76ae\u6587|\u57c3\u7def\u6587|\u5716\u59c6\u5e03\u5361\u6587|\u5176\u4ed6\u5c3c\u65e5\u525b\u679c\u8a9e\u7cfb|\u76e7\u6652\u6587|\u82ac\u862d-\u70cf\u6208\u723e\u65cf\u6587(\u5176\u4ed6)|\u8fea\u7dad\u897f\u6587|\u5c3c\u4e9e\u65af\u6587|\u83ab\u970d\u514b\u6587|\u76e7\u5967\u6587|\u76e7\u6069\u9054\u6587|\u963f\u5e15\u5947\u8a9e\u8a00|\u8def\u6613\u585e\u8afe\u6587|\u9b6f\u5df4\u9b6f\u9b6f\u4e9e\u6587|\u6bd4\u79d1\u723e\u6587|\u74e6\u7d39\u6587|\u672a\u78ba\u5b9a\u7684|\u74e6\u745e\u6587|\u4e39\u9ea5\u6587|\u8377\u862d\uff0c\u4e2d\u53e4 (ca. 1050-1350)|\u99ac\u8afe\u6ce2\u6587|\u5938\u57fa\u6b66\u7279\u6587|\u6563\u5854\u5229\u6587|\u5a01\u723e\u58eb\u6587|\u6492\u6492\u514b\u6587|\u5361\u5df4\u723e\u9054\u6587|\u695a\u74e6\u751a\u6587|\u66fc\u5c3c\u666e\u88e1\u6587|\u85a9\u746a\u5229\u4e9e\u963f\u62c9\u59c6\u6587|\u514b\u88e1\u6587|\u85a9\u5229\u751a\u6587|\u675c\u4e9e\u62c9\u6587|\u6eff\u65cf\u6587|\u96c5\u5eab\u7279\u6587|\u845b\u5df4\u4e9e\u6587|\u6851\u9054\u97cb\u6587|\u67e5\u83ab\u6d1b\u6587|\u5370\u6b50\u8a9e\u7cfb\uff08\u5176\u4ed6\uff09|\u535a\u5091\u666e\u723e\u6587|\u82f1\u6587\uff0c\u4e2d\u4e16\u7d00 (1100-1500)|\u514b\u502b\u6587|\u5370\u5ea6\u8a9e\u7cfb\uff08\u5176\u4ed6\uff09|\u8eca\u81e3\u6587|\u52a0\u7d04\u6587|\u52a0\u6cf0\u7f85\u5c3c\u4e9e\u6587|\u59c6\u672c\u675c\u6587|\u53e4\u6558\u5229\u4e9e\u6587|\u6b3d\u897f\u5b89\u6587|\u53e4\u82f1\u6587 (ca.450-1100)|\u9ad8\u52a0\u7d22\u6587\uff08\u5176\u4ed6\uff09|\u5361\u6bd4\u723e\u6587|\u5361\u62c9\u5361\u723e\u5e15\u514b\u6587|\u6ce2\u58eb\u5c3c\u4e9e\u6587|\u85cf\u6587|\u52a0\u65cf\u6587|\u4e2d\u7f8e\u5370\u7b2c\u5b89\u6587\uff08\u5176\u4ed6\uff09|\u6bd4\u65af\u62c9\u99ac\u6587|\u6bd4\u54c8\u723e\u6587|\u4fdd\u52a0\u5229\u4e9e\u6587|\u767d\u4fc4\u7f85\u65af\u6587|\u5df4\u4ec0\u5ba2\u723e\u6587|\u7956\u9b6f\u6587|\u6fa4\u7d0d\u52a0\u6587|\u666e\u7f85\u6587\u65af\u6587 (to 1500)|\u4e9e\u585e\u62dc\u7136\u6587|\u827e\u99ac\u62c9\u6587|\u963f\u6cd5\u6587|\u963f\u85a9\u59c6\u6587|\u4e0b\u7d22\u5e03\u6587|\u4f0a\u6d1b\u95ca\u6587|\u57c3\u862d\u6587|\u963f\u62c9\u8ca2\u6587|\u5370\u5ea6\u53e4\u4ee3\u53ca\u4e2d\u4e16\u7d00\u4e4b\u4e2d\u90e8\u53ca\u5317\u90e8\u65b9\u8a00|\u5c3c\u74e6\u723e\u6587|\u963f\u574e\u6587|\u58ef\u6587|\u5357\u975e\u8377\u862d\u6587|\u963f\u7def\u65af\u9640\u6587|\u963f\u5e03\u54c8\u897f\u4e9e\u6587|\u7d04\u9b6f\u5df4\u6587|\u963f\u723e\u5ca1\u6606\u6587|\u963f\u7559\u7533\u6587|\u5176\u4ed6\u9ad8\u68c9\u8a9e\u7cfb|\u610f\u7b2c\u7dd2\u6587|\u5fb7\u62c9\u5a01\u6587\uff08\u5176\u4ed6\uff09|\u67cf\u67cf\u723e\u6587|\u5fb7\u570b\u5317\u90e8\u7684\u5fb7\u6587; \u85a9\u514b\u905c\u6587|\u5225\u59c6\u5df4\u6587|\u8c9d\u624e\u6587|\u6258\u6bd4\u8f9b\u6587";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "\u5df2\u4fee\u8a02";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortDateFormat", "yyyy/M/d" },
    { "mediumDateFormat", "yyyy/M/d" },
    { "longDateFormat", "yyyy'\u5e74'M'\u6708'd'\u65e5'" },
    { "fullDateFormat", "yyyy'\u5e74'M'\u6708'd'\u65e5'EEEE" },
    { "shortTimeFormat", "a h:mm" },
    { "mediumTimeFormat", "a h:mm:ss" },
    { "longTimeFormat", "ahh'\u6642'mm'\u5206'ss'\u79d2'" },
    { "fullTimeFormat", "ahh'\u6642'mm'\u5206'ss'\u79d2' z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
