
/*  A Bison parser, made from /home/gray/new-gnu/mailutils/mh/mh_alias.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	STRING	257

#line 1 "mh_alias.y"

/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 2003 Free Software Foundation, Inc.

   GNU Mailutils is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Mailutils is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Mailutils; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

#include <mh.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
  
struct mh_alias
{
  char *name;
  list_t rcpt_list;
  int inclusive;
};

static list_t alias_list;

static list_t
list_create_or_die ()
{
  int status;
  list_t list;

  status = list_create (&list);
  if (status)
    {
      ali_parse_error (_("can't create list: %s"), mu_strerror (status));
      exit (1);
    }
  return list;
}

static char *
ali_list_to_string (list_t *plist)
{
  size_t n;
  char *string;
  
  list_count (*plist, &n);
  if (n == 1)
    {
      list_get (*plist, 0, (void **)&string);
    }
  else
    {
      char *p;
      size_t length = 0;
      iterator_t itr;
      iterator_create (&itr, *plist);
      for (iterator_first (itr); !iterator_is_done (itr); iterator_next(itr))
	{
	  char *s;
	  iterator_current (itr, (void**) &s);
	  length += strlen (s) + 1;
	}
  
      string = xmalloc (length + 1);
      p = string;
      for (iterator_first (itr); !iterator_is_done (itr); iterator_next(itr))
	{
	  char *s;
	  iterator_current (itr, (void**) &s);
	  strcpy (p, s);
	  p += strlen (s);
	  *p++ = ' ';
	}
      *--p = 0;
      iterator_destroy (&itr);
    }
  list_destroy (plist);
  return string;
}

static list_t unix_group_to_list __P((char *name));
static list_t unix_gid_to_list __P((char *name));
static list_t unix_passwd_to_list __P((void));

int ali_yyerror __P((char *s));
int ali_yylex __P((void));


#line 98 "mh_alias.y"
typedef union {
  char *string;
  list_t list;
  struct mh_alias *alias;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		31
#define	YYFLAG		-32768
#define	YYNTBASE	11

#define YYTRANSLATE(x) ((unsigned)(x) <= 257 ? ali_yytranslate[x] : 21)

static const char ali_yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     4,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     9,     8,    10,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     5,     6,     2,
     7,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3
};

#if YYDEBUG != 0
static const short ali_yyprhs[] = {     0,
     0,     1,     3,     6,     9,    13,    15,    19,    21,    24,
    25,    30,    31,    36,    38,    41,    44,    46,    48,    52,
    54,    56
};

static const short ali_yyrhs[] = {    -1,
    12,     0,    12,    13,     0,    13,    12,     0,    13,    12,
    13,     0,    14,     0,    12,    13,    14,     0,     4,     0,
    13,     4,     0,     0,     3,     5,    15,    17,     0,     0,
     3,     6,    16,    17,     0,    18,     0,     7,     3,     0,
     8,     3,     0,     9,     0,    19,     0,    18,    10,    19,
     0,    20,     0,     3,     0,    20,     3,     0
};

#endif

#if YYDEBUG != 0
static const short ali_yyrline[] = { 0,
   111,   112,   113,   114,   115,   118,   124,   130,   131,   134,
   135,   142,   143,   152,   153,   158,   163,   169,   174,   181,
   187,   192
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const ali_yytname[] = {   "$","error","$undefined.","STRING",
"'\\n'","':'","';'","'='","'+'","'*'","','","input","alias_list","nl","alias",
"@1","@2","address_group","address_list","address","string_list", NULL
};
#endif

static const short ali_yyr1[] = {     0,
    11,    11,    11,    11,    11,    12,    12,    13,    13,    15,
    14,    16,    14,    17,    17,    17,    17,    18,    18,    19,
    20,    20
};

static const short ali_yyr2[] = {     0,
     0,     1,     2,     2,     3,     1,     3,     1,     2,     0,
     4,     0,     4,     1,     2,     2,     1,     1,     3,     1,
     1,     2
};

static const short ali_yydefact[] = {     1,
     0,     8,     2,     0,     6,    10,    12,     3,     9,     4,
     0,     0,     7,     5,    21,     0,     0,    17,    11,    14,
    18,    20,    13,    15,    16,     0,    22,    19,     0,     0,
     0
};

static const short ali_yydefgoto[] = {    29,
     3,     4,     5,    11,    12,    19,    20,    21,    22
};

static const short ali_yypact[] = {    -1,
     8,-32768,     7,    12,-32768,-32768,-32768,    12,-32768,     7,
     1,     1,-32768,    12,-32768,     2,    14,-32768,-32768,    -9,
-32768,    15,-32768,-32768,-32768,    16,-32768,-32768,    20,    21,
-32768
};

static const short ali_yypgoto[] = {-32768,
    18,    -3,    -2,-32768,-32768,    11,-32768,     0,-32768
};


#define	YYLAST		26


static const short ali_yytable[] = {     8,
    26,     1,     2,    15,    24,    13,    14,    16,    17,    18,
     2,    13,     6,     7,     1,     9,    25,    27,    15,    30,
    31,    10,    23,     0,     0,    28
};

static const short ali_yycheck[] = {     3,
    10,     3,     4,     3,     3,     8,    10,     7,     8,     9,
     4,    14,     5,     6,     3,     4,     3,     3,     3,     0,
     0,     4,    12,    -1,    -1,    26
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define ali_yyerrok		(ali_yyerrstatus = 0)
#define ali_yyclearin	(ali_yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto ali_yyacceptlab
#define YYABORT 	goto ali_yyabortlab
#define YYERROR		goto ali_yyerrlab1
/* Like YYERROR except do call ali_yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto ali_yyerrlab
#define YYRECOVERING()  (!!ali_yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (ali_yychar == YYEMPTY && ali_yylen == 1)				\
    { ali_yychar = (token), ali_yylval = (value);			\
      ali_yychar1 = YYTRANSLATE (ali_yychar);				\
      YYPOPSTACK;						\
      goto ali_yybackup;						\
    }								\
  else								\
    { ali_yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		ali_yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		ali_yylex(&ali_yylval, &ali_yylloc, YYLEX_PARAM)
#else
#define YYLEX		ali_yylex(&ali_yylval, &ali_yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		ali_yylex(&ali_yylval, YYLEX_PARAM)
#else
#define YYLEX		ali_yylex(&ali_yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	ali_yychar;			/*  the lookahead symbol		*/
YYSTYPE	ali_yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE ali_yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int ali_yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int ali_yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __ali_yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __ali_yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__ali_yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__ali_yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into ali_yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int ali_yyparse (void *);
#else
int ali_yyparse (void);
#endif
#endif

int
ali_yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int ali_yystate;
  register int ali_yyn;
  register short *ali_yyssp;
  register YYSTYPE *ali_yyvsp;
  int ali_yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int ali_yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	ali_yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE ali_yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *ali_yyss = ali_yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *ali_yyvs = ali_yyvsa;	/*  to allow ali_yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE ali_yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *ali_yyls = ali_yylsa;
  YYLTYPE *ali_yylsp;

#define YYPOPSTACK   (ali_yyvsp--, ali_yyssp--, ali_yylsp--)
#else
#define YYPOPSTACK   (ali_yyvsp--, ali_yyssp--)
#endif

  int ali_yystacksize = YYINITDEPTH;
  int ali_yyfree_stacks = 0;

#ifdef YYPURE
  int ali_yychar;
  YYSTYPE ali_yylval;
  int ali_yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE ali_yylloc;
#endif
#endif

  YYSTYPE ali_yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int ali_yylen;

#if YYDEBUG != 0
  if (ali_yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  ali_yystate = 0;
  ali_yyerrstatus = 0;
  ali_yynerrs = 0;
  ali_yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  ali_yyssp = ali_yyss - 1;
  ali_yyvsp = ali_yyvs;
#ifdef YYLSP_NEEDED
  ali_yylsp = ali_yyls;
#endif

/* Push a new state, which is found in  ali_yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
ali_yynewstate:

  *++ali_yyssp = ali_yystate;

  if (ali_yyssp >= ali_yyss + ali_yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *ali_yyvs1 = ali_yyvs;
      short *ali_yyss1 = ali_yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *ali_yyls1 = ali_yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = ali_yyssp - ali_yyss + 1;

#ifdef ali_yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if ali_yyoverflow is a macro.  */
      ali_yyoverflow("parser stack overflow",
		 &ali_yyss1, size * sizeof (*ali_yyssp),
		 &ali_yyvs1, size * sizeof (*ali_yyvsp),
		 &ali_yyls1, size * sizeof (*ali_yylsp),
		 &ali_yystacksize);
#else
      ali_yyoverflow("parser stack overflow",
		 &ali_yyss1, size * sizeof (*ali_yyssp),
		 &ali_yyvs1, size * sizeof (*ali_yyvsp),
		 &ali_yystacksize);
#endif

      ali_yyss = ali_yyss1; ali_yyvs = ali_yyvs1;
#ifdef YYLSP_NEEDED
      ali_yyls = ali_yyls1;
#endif
#else /* no ali_yyoverflow */
      /* Extend the stack our own way.  */
      if (ali_yystacksize >= YYMAXDEPTH)
	{
	  ali_yyerror("parser stack overflow");
	  if (ali_yyfree_stacks)
	    {
	      free (ali_yyss);
	      free (ali_yyvs);
#ifdef YYLSP_NEEDED
	      free (ali_yyls);
#endif
	    }
	  return 2;
	}
      ali_yystacksize *= 2;
      if (ali_yystacksize > YYMAXDEPTH)
	ali_yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      ali_yyfree_stacks = 1;
#endif
      ali_yyss = (short *) YYSTACK_ALLOC (ali_yystacksize * sizeof (*ali_yyssp));
      __ali_yy_memcpy ((char *)ali_yyss, (char *)ali_yyss1,
		   size * (unsigned int) sizeof (*ali_yyssp));
      ali_yyvs = (YYSTYPE *) YYSTACK_ALLOC (ali_yystacksize * sizeof (*ali_yyvsp));
      __ali_yy_memcpy ((char *)ali_yyvs, (char *)ali_yyvs1,
		   size * (unsigned int) sizeof (*ali_yyvsp));
#ifdef YYLSP_NEEDED
      ali_yyls = (YYLTYPE *) YYSTACK_ALLOC (ali_yystacksize * sizeof (*ali_yylsp));
      __ali_yy_memcpy ((char *)ali_yyls, (char *)ali_yyls1,
		   size * (unsigned int) sizeof (*ali_yylsp));
#endif
#endif /* no ali_yyoverflow */

      ali_yyssp = ali_yyss + size - 1;
      ali_yyvsp = ali_yyvs + size - 1;
#ifdef YYLSP_NEEDED
      ali_yylsp = ali_yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (ali_yydebug)
	fprintf(stderr, "Stack size increased to %d\n", ali_yystacksize);
#endif

      if (ali_yyssp >= ali_yyss + ali_yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (ali_yydebug)
    fprintf(stderr, "Entering state %d\n", ali_yystate);
#endif

  goto ali_yybackup;
 ali_yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* ali_yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  ali_yyn = ali_yypact[ali_yystate];
  if (ali_yyn == YYFLAG)
    goto ali_yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* ali_yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (ali_yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (ali_yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      ali_yychar = YYLEX;
    }

  /* Convert token to internal form (in ali_yychar1) for indexing tables with */

  if (ali_yychar <= 0)		/* This means end of input. */
    {
      ali_yychar1 = 0;
      ali_yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (ali_yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      ali_yychar1 = YYTRANSLATE(ali_yychar);

#if YYDEBUG != 0
      if (ali_yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", ali_yychar, ali_yytname[ali_yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, ali_yychar, ali_yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  ali_yyn += ali_yychar1;
  if (ali_yyn < 0 || ali_yyn > YYLAST || ali_yycheck[ali_yyn] != ali_yychar1)
    goto ali_yydefault;

  ali_yyn = ali_yytable[ali_yyn];

  /* ali_yyn is what to do for this token type in this state.
     Negative => reduce, -ali_yyn is rule number.
     Positive => shift, ali_yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (ali_yyn < 0)
    {
      if (ali_yyn == YYFLAG)
	goto ali_yyerrlab;
      ali_yyn = -ali_yyn;
      goto ali_yyreduce;
    }
  else if (ali_yyn == 0)
    goto ali_yyerrlab;

  if (ali_yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (ali_yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", ali_yychar, ali_yytname[ali_yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (ali_yychar != YYEOF)
    ali_yychar = YYEMPTY;

  *++ali_yyvsp = ali_yylval;
#ifdef YYLSP_NEEDED
  *++ali_yylsp = ali_yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (ali_yyerrstatus) ali_yyerrstatus--;

  ali_yystate = ali_yyn;
  goto ali_yynewstate;

/* Do the default action for the current state.  */
ali_yydefault:

  ali_yyn = ali_yydefact[ali_yystate];
  if (ali_yyn == 0)
    goto ali_yyerrlab;

/* Do a reduction.  ali_yyn is the number of a rule to reduce with.  */
ali_yyreduce:
  ali_yylen = ali_yyr2[ali_yyn];
  if (ali_yylen > 0)
    ali_yyval = ali_yyvsp[1-ali_yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (ali_yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       ali_yyn, ali_yyrline[ali_yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = ali_yyprhs[ali_yyn]; ali_yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", ali_yytname[ali_yyrhs[i]]);
      fprintf (stderr, " -> %s\n", ali_yytname[ali_yyr1[ali_yyn]]);
    }
#endif


  switch (ali_yyn) {

case 6:
#line 119 "mh_alias.y"
{
		 if (!alias_list)
		   alias_list = list_create_or_die ();
		 list_append (alias_list, ali_yyvsp[0].alias);
	       ;
    break;}
case 7:
#line 125 "mh_alias.y"
{
		 list_append (alias_list, ali_yyvsp[0].alias);
	       ;
    break;}
case 10:
#line 134 "mh_alias.y"
{ ali_verbatim (1); ;
    break;}
case 11:
#line 135 "mh_alias.y"
{
		 ali_verbatim (0);
		 ali_yyval.alias = xmalloc (sizeof (*ali_yyval.alias));
		 ali_yyval.alias->name = ali_yyvsp[-3].string;
		 ali_yyval.alias->rcpt_list = ali_yyvsp[0].list;
		 ali_yyval.alias->inclusive = 0;
	       ;
    break;}
case 12:
#line 142 "mh_alias.y"
{ ali_verbatim (1); ;
    break;}
case 13:
#line 143 "mh_alias.y"
{
		 ali_verbatim (0);
		 ali_yyval.alias = xmalloc (sizeof (*ali_yyval.alias));
		 ali_yyval.alias->name = ali_yyvsp[-3].string;
		 ali_yyval.alias->rcpt_list = ali_yyvsp[0].list;
		 ali_yyval.alias->inclusive = 1;
	       ;
    break;}
case 15:
#line 154 "mh_alias.y"
{
		 ali_yyval.list = unix_group_to_list (ali_yyvsp[0].string);
		 free (ali_yyvsp[0].string);
	       ;
    break;}
case 16:
#line 159 "mh_alias.y"
{
		 ali_yyval.list = unix_gid_to_list (ali_yyvsp[0].string);
		 free (ali_yyvsp[0].string);
	       ;
    break;}
case 17:
#line 164 "mh_alias.y"
{
		 ali_yyval.list = unix_passwd_to_list ();
	       ;
    break;}
case 18:
#line 170 "mh_alias.y"
{
		 ali_yyval.list = list_create_or_die ();
		 list_append (ali_yyval.list, ali_yyvsp[0].string);
	       ;
    break;}
case 19:
#line 175 "mh_alias.y"
{
		 list_append (ali_yyvsp[-2].list, ali_yyvsp[0].string);
		 ali_yyval.list = ali_yyvsp[-2].list;
	       ;
    break;}
case 20:
#line 182 "mh_alias.y"
{
		 ali_yyval.string = ali_list_to_string (&ali_yyvsp[0].list);
	       ;
    break;}
case 21:
#line 188 "mh_alias.y"
{
		 list_create(&ali_yyval.list);
		 list_append(ali_yyval.list, ali_yyvsp[0].string);
	       ;
    break;}
case 22:
#line 193 "mh_alias.y"
{
		 list_append(ali_yyvsp[-1].list, ali_yyvsp[0].string);
		 ali_yyval.list = ali_yyvsp[-1].list;
	       ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  ali_yyvsp -= ali_yylen;
  ali_yyssp -= ali_yylen;
#ifdef YYLSP_NEEDED
  ali_yylsp -= ali_yylen;
#endif

#if YYDEBUG != 0
  if (ali_yydebug)
    {
      short *ssp1 = ali_yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != ali_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++ali_yyvsp = ali_yyval;

#ifdef YYLSP_NEEDED
  ali_yylsp++;
  if (ali_yylen == 0)
    {
      ali_yylsp->first_line = ali_yylloc.first_line;
      ali_yylsp->first_column = ali_yylloc.first_column;
      ali_yylsp->last_line = (ali_yylsp-1)->last_line;
      ali_yylsp->last_column = (ali_yylsp-1)->last_column;
      ali_yylsp->text = 0;
    }
  else
    {
      ali_yylsp->last_line = (ali_yylsp+ali_yylen-1)->last_line;
      ali_yylsp->last_column = (ali_yylsp+ali_yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  ali_yyn = ali_yyr1[ali_yyn];

  ali_yystate = ali_yypgoto[ali_yyn - YYNTBASE] + *ali_yyssp;
  if (ali_yystate >= 0 && ali_yystate <= YYLAST && ali_yycheck[ali_yystate] == *ali_yyssp)
    ali_yystate = ali_yytable[ali_yystate];
  else
    ali_yystate = ali_yydefgoto[ali_yyn - YYNTBASE];

  goto ali_yynewstate;

ali_yyerrlab:   /* here on detecting error */

  if (! ali_yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++ali_yynerrs;

#ifdef YYERROR_VERBOSE
      ali_yyn = ali_yypact[ali_yystate];

      if (ali_yyn > YYFLAG && ali_yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -ali_yyn if nec to avoid negative indexes in ali_yycheck.  */
	  for (x = (ali_yyn < 0 ? -ali_yyn : 0);
	       x < (sizeof(ali_yytname) / sizeof(char *)); x++)
	    if (ali_yycheck[x + ali_yyn] == x)
	      size += strlen(ali_yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (ali_yyn < 0 ? -ali_yyn : 0);
		       x < (sizeof(ali_yytname) / sizeof(char *)); x++)
		    if (ali_yycheck[x + ali_yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, ali_yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      ali_yyerror(msg);
	      free(msg);
	    }
	  else
	    ali_yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	ali_yyerror("parse error");
    }

  goto ali_yyerrlab1;
ali_yyerrlab1:   /* here on error raised explicitly by an action */

  if (ali_yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (ali_yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (ali_yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", ali_yychar, ali_yytname[ali_yychar1]);
#endif

      ali_yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  ali_yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto ali_yyerrhandle;

ali_yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  ali_yyn = ali_yydefact[ali_yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (ali_yyn) goto ali_yydefault;
#endif

ali_yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (ali_yyssp == ali_yyss) YYABORT;
  ali_yyvsp--;
  ali_yystate = *--ali_yyssp;
#ifdef YYLSP_NEEDED
  ali_yylsp--;
#endif

#if YYDEBUG != 0
  if (ali_yydebug)
    {
      short *ssp1 = ali_yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != ali_yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

ali_yyerrhandle:

  ali_yyn = ali_yypact[ali_yystate];
  if (ali_yyn == YYFLAG)
    goto ali_yyerrdefault;

  ali_yyn += YYTERROR;
  if (ali_yyn < 0 || ali_yyn > YYLAST || ali_yycheck[ali_yyn] != YYTERROR)
    goto ali_yyerrdefault;

  ali_yyn = ali_yytable[ali_yyn];
  if (ali_yyn < 0)
    {
      if (ali_yyn == YYFLAG)
	goto ali_yyerrpop;
      ali_yyn = -ali_yyn;
      goto ali_yyreduce;
    }
  else if (ali_yyn == 0)
    goto ali_yyerrpop;

  if (ali_yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (ali_yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++ali_yyvsp = ali_yylval;
#ifdef YYLSP_NEEDED
  *++ali_yylsp = ali_yylloc;
#endif

  ali_yystate = ali_yyn;
  goto ali_yynewstate;

 ali_yyacceptlab:
  /* YYACCEPT comes here.  */
  if (ali_yyfree_stacks)
    {
      free (ali_yyss);
      free (ali_yyvs);
#ifdef YYLSP_NEEDED
      free (ali_yyls);
#endif
    }
  return 0;

 ali_yyabortlab:
  /* YYABORT comes here.  */
  if (ali_yyfree_stacks)
    {
      free (ali_yyss);
      free (ali_yyvs);
#ifdef YYLSP_NEEDED
      free (ali_yyls);
#endif
    }
  return 1;
}
#line 199 "mh_alias.y"


static list_t
ali_list_dup (list_t src)
{
  list_t dst;
  iterator_t itr;

  if (list_create (&dst))
    return NULL;

  if (iterator_create (&itr, src))
    {
      list_destroy (&dst);
      return NULL;
    }
  
  for (iterator_first (itr); !iterator_is_done (itr); iterator_next (itr))
    {
      void *data;
      iterator_current (itr, (void **)&data);
      list_append (dst, data);
    }
  iterator_destroy (&itr);
  return dst;
}

static int
ali_member (list_t list, char *name)
{
  iterator_t itr;
  int found = 0;

  if (iterator_create (&itr, list))
    return 0;
  for (iterator_first (itr); !found && !iterator_is_done (itr);
       iterator_next (itr))
    {
      char *item;
      address_t tmp;
      
      iterator_current (itr, (void **)&item);
      if (strcmp (item, name) == 0)
	found = 1;
      else if (address_create (&tmp, item) == 0)
	{
	  found = address_contains_email (tmp, name);
	  address_destroy (&tmp);
	}
    }
  iterator_destroy (&itr);
  return found;
}

int
aliascmp (char *pattern, char *name)
{
  int len = strlen (pattern);

  if (len > 1 && pattern[len - 1] == '*')
    return strncmp (pattern, name, len - 2);
  return strcmp (pattern, name);
}


int
_insert_list (list_t list, void *prev, list_t new_list)
{
  iterator_t itr;

  if (iterator_create (&itr, new_list))
    return 1;
  for (iterator_first (itr); !iterator_is_done (itr); iterator_next (itr))
    {
      void *item;
      
      iterator_current (itr, &item);
      list_insert (list, prev, item);
      prev = item;
    }
  iterator_destroy (&itr);
  return 0;
}

static int mh_alias_get_internal __P((char *name, iterator_t start,
				      list_t *return_list, int *inclusive));

int
alias_expand_list (list_t name_list, iterator_t orig_itr, int *inclusive)
{
  iterator_t itr;

  if (iterator_create (&itr, name_list))
    return 1;
  for (iterator_first (itr); !iterator_is_done (itr); iterator_next (itr))
    {
      char *name;
      list_t exlist;
      
      iterator_current (itr, (void **)&name);
      if (mh_alias_get_internal (name, orig_itr, &exlist, inclusive) == 0)
	{
	  _insert_list (name_list, name, exlist);
	  list_remove (name_list, name);
	  list_destroy (&exlist);
	}
    }
  iterator_destroy (&itr);
  return 0;
}  

/* Look up the named alias. If found, return the list of recipient
   names associated with it */
static int
mh_alias_get_internal (char *name, iterator_t start, list_t *return_list,
		       int *inclusive) 
{
  iterator_t itr;
  int rc = 1;

  if (!start)
    {
      if (iterator_create (&itr, alias_list))
	return 1;
      iterator_first (itr);
    }
  else
    {
      iterator_dup (&itr, start);
      iterator_next (itr);
    }
	
  for (; !iterator_is_done (itr); iterator_next (itr))
    {
      struct mh_alias *alias;
      iterator_current (itr, (void **)&alias);
      if (inclusive)
	*inclusive |= alias->inclusive;
      if (aliascmp (alias->name, name) == 0)
	{
	  *return_list = ali_list_dup (alias->rcpt_list);
	  alias_expand_list (*return_list, itr, inclusive);
	  rc = 0;
	  break;
	}
    }
  
  iterator_destroy (&itr);
  return rc;
}

int
mh_alias_get (char *name, list_t *return_list)
{
  return mh_alias_get_internal (name, NULL, return_list, NULL);
}

int
mh_alias_get_address (char *name, address_t *paddr, int *incl)
{
  iterator_t itr;
  list_t list;
  const char *domain = NULL;
  
  if (mh_alias_get_internal (name, NULL, &list, incl))
    return 1;
  if (list_is_empty (list))
    {
      list_destroy (&list);
      return 1;
    }
  
  if (iterator_create (&itr, list) == 0)
    {
      for (iterator_first (itr); !iterator_is_done (itr); iterator_next (itr))
	{
	  char *item;
	  address_t a;
	  char *ptr = NULL; 

	  iterator_current (itr, (void **)&item);
	  if (incl && *incl)
	    {
	      if (strchr (item, '@') == 0)
		{
		  if (!domain)
		    mu_get_user_email_domain (&domain);
		  asprintf (&ptr, "\"%s\" <%s@%s>", name, item, domain);
		}
	      else
		asprintf (&ptr, "\"%s\" <%s>", name, item);
	      item = ptr;
	    }
	  if (address_create (&a, item))
	    {
	      mh_error (_("Error expanding aliases -- invalid address `%s'"),
			item);
	    }
	  else
	    {
	      address_union (paddr, a);
	      address_destroy (&a);
	    }
	  if (ptr)
	    free (ptr);
	}
      iterator_destroy (&itr);
    }
  list_destroy (&list);
  return 0;
}

/* Look up the given user name in the aliases. Return the list of
   alias names this user is member of */
int
mh_alias_get_alias (char *uname, list_t *return_list)
{
  iterator_t itr;
  int rc = 1;
  
  if (iterator_create (&itr, alias_list))
    return 1;
  for (iterator_first (itr); !iterator_is_done (itr); iterator_next (itr))
    {
      struct mh_alias *alias;
      iterator_current (itr, (void **)&alias);
      if (ali_member (alias->rcpt_list, uname))
	{
	  if (*return_list == NULL && list_create (return_list))
	    break;
	  list_append (*return_list, alias->name);
	  rc = 0;
	}
    }
  
  iterator_destroy (&itr);
  return rc;
}

void
mh_alias_enumerate (mh_alias_enumerator_t fun, void *data)
{
  iterator_t itr;
  int rc = 0;
  
  if (iterator_create (&itr, alias_list))
    return ;
  for (iterator_first (itr);
       rc == 0 && !iterator_is_done (itr);
       iterator_next (itr))
    {
      struct mh_alias *alias;
      list_t tmp;
      
      iterator_current (itr, (void **)&alias);

      tmp = ali_list_dup (alias->rcpt_list);
      alias_expand_list (tmp, itr, NULL);

      rc = fun (alias->name, tmp, data);
      list_destroy (&tmp);
    }
  iterator_destroy (&itr);
}

static list_t
unix_group_to_list (char *name)
{
  struct group *grp = getgrnam (name);
  list_t lst = list_create_or_die ();
  
  if (grp)
    {
      char **p;

      for (p = grp->gr_mem; *p; p++)
	list_append (lst, strdup (*p));
    }      
  
  return lst;
}

static list_t
unix_gid_to_list (char *name)
{
  struct group *grp = getgrnam (name);
  list_t lst = list_create_or_die ();

  if (grp)
    {
      struct passwd *pw;
      setpwent();
      while ((pw = getpwent ()))
	{
	  if (pw->pw_gid == grp->gr_gid)
	    list_append (lst, strdup (pw->pw_name));
	}
      endpwent();
    }
  return lst;
}

static list_t
unix_passwd_to_list ()
{
  list_t lst = list_create_or_die ();
  struct passwd *pw;

  setpwent();
  while ((pw = getpwent ()))
    {
      if (pw->pw_uid > 200)
	list_append (lst, strdup (pw->pw_name));
    }
  endpwent();
  return lst;
}

int
mh_read_aliases ()
{
  char *p, *sp;
  
  p = mh_global_profile_get ("Aliasfile", NULL);
  if (p)
    for (p = strtok_r (p, " \t", &sp); p; p = strtok_r (NULL, " \t", &sp))
      mh_alias_read (p, 1);
  mh_alias_read (DEFAULT_ALIAS_FILE, 0);
  return 0;
}
