/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Idref
extends SystemFunction
implements MappingFunction {
    public Expression simplify() throws XPathException {
        Idref idref = (Idref)super.simplify();
        idref.addContextDocumentArgument(1, "idref+");
        return idref;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.argument[0] = ExpressionTool.unsorted(this.argument[0], false);
    }

    public int computeSpecialProperties() {
        return 196608;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Item item = this.argument[1].evaluateItem(xPathContext);
        if (!(item instanceof DocumentInfo)) {
            this.dynamicError("In the idref() function, the context node must be in a tree whose root is a document node");
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)item;
        int n = 562;
        Expression expression = this.argument[0];
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
            if (atomicValue == null) {
                return EmptyIterator.getInstance();
            }
            KeyManager keyManager = controller.getKeyManager();
            return keyManager.selectByKey(n, documentInfo, atomicValue, controller);
        }
        KeyContextInfo keyContextInfo = new KeyContextInfo();
        keyContextInfo.document = documentInfo;
        keyContextInfo.controller = controller;
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, this, null, keyContextInfo);
        return new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        KeyContextInfo keyContextInfo = (KeyContextInfo)object;
        KeyManager keyManager = keyContextInfo.controller.getKeyManager();
        AtomicValue atomicValue = item instanceof AtomicValue ? (AtomicValue)item : new StringValue(item.getStringValue());
        return keyManager.selectByKey(562, keyContextInfo.document, atomicValue, keyContextInfo.controller);
    }

    private class KeyContextInfo {
        public DocumentInfo document;
        public Controller controller;

        private KeyContextInfo() {
        }
    }
}

