#include <stdio.h>

typedef char		Nybble;
typedef unsigned int	NAddr;

#define NOADDR		0xffffffff

extern char	hex[];

#ifdef ANSI
int	GetInt(char *mem, NAddr *addr, int n);
Nybble	GetNybble(char *mem, NAddr addr);

char	*Append16(char *buf, int n);
char	*AppendAddr(char *buf, NAddr addr);
char	*AppendRAddr(char *buf, NAddr pc, int disp, int n, int offset);
char	*AppendField(char *buf, Nybble fn);
char	*AppendDecInt(char *buf, int n);
char	*AppendHexNyb(char *buf, char *mem, NAddr *addr, int n);
char	*AppendImmNyb(char *buf, char *mem, NAddr *addr, int n);
char	*AppendStBits(char *buf, int n);
char	*AppendStr(char *buf, char *str);
#else
int	GetInt();
Nybble	GetNybble();

char	*Append16();
char	*AppendAddr();
char	*AppendRAddr();
char	*AppendField();
char	*AppendDecInt();
char	*AppendHexNyb();
char	*AppendImmNyb();
char	*AppendStBits();
char	*AppendStr();
#endif

typedef char	*Bitmap;

#define BITS(s)		((s) /  8)
#define BITSET(m, b)	m[b >> 3] |= (1 << (b & 7))
#define BITCLR(m, b)	m[b >> 3] &= ~(1 << (b & 7))
#define BITTEST(m, b)	(m[b >> 3] & (1 << (b & 7)))

extern Bitmap	completed;

typedef enum {other, branch, call, jump, ujump}	IType;

extern IType	itype;
extern NAddr	target;

#define APPEND_BDIGIT(x, d)	*(x)++ = (d) + '0'
#define APPEND_CHAR(x, c)	*(x)++ = (c)
#define APPEND_COMMA(x)		*(x)++ = ','; *(x)++ = ' '
#define APPEND_HEXMARK(x)	*(x)++ = '$'
#define APPEND_IMMMARK(x)	*(x)++ = '#'
#define APPEND_TAB(x)		*(x)++ = '\t'
#define TERMINATE(x)		*(x) = '\0'
