/*
    Mines

    Copyright (c) 1979, 2005 James L. Dean

    Version 2.4 released October 25, 2005

    This Java applet may be distributed or used without payment to its author.
Derivative works must credit its author.

    "Mines" lets you explore mines. The mine you explore is determined by a
mine number specified at the beginning of a game.

    The object of a game is to visit all of the rooms and return all of the
treasures to the entrance without making too many moves.

    In a mine, the passages are straight.  So, for example, if you go North to
leave a room, you can go South to reenter it.  The rooms are not evenly spaced.
However, the distance between adjacent rooms is always a multiple of the
minimum distance between adjacent rooms.
*/

public class Mines extends java.applet.Applet implements java.awt.event.ActionListener
  {
    private class Room
      {
        String     strDescription;
        int        nChokepoint;
        boolean    bMined;
        boolean    bVisited;
        Passage [] passage = new Passage [6];

        public Room()
          {
            strDescription=null;
            nChokepoint=-1;
            bMined=false;
            bVisited=false;
            passage[0]=null;
            passage[1]=null;
            passage[2]=null;
            passage[3]=null;
            passage[4]=null;
            passage[5]=null;
          }
      }

    private class Treasure
      {
        String  strTreasure;
        Room    roomTreasure;
        String  strGuardian;
        boolean bSlain;
        String  strWeapon;
        Room    roomWeapon;

        public Treasure()
          {
            strTreasure=null;
            roomTreasure=null;
            strGuardian=null;
            bSlain=false;
            strWeapon=null;
            roomWeapon=null;
          }

        public Treasure(
         String strTreasure,
         String strGuardian,
         String strWeapon)
          {
            this.strTreasure=strTreasure;
            this.strGuardian=strGuardian;
            this.strWeapon=strWeapon;
            roomTreasure=null;
            bSlain=false;
            roomWeapon=null;
          }
      }

    private class Passage
      {
        boolean  bBlocked;
        Treasure treasureGuardian;
        Room     room1;
        Room     room2;

        public Passage()
          {
            bBlocked=true;
            treasureGuardian=null;
            room1=null;
            room2=null;
          }
      }

    private class PathStack
      {
        Room      room;
        Passage   passageUsedToEnterRoom;
        int       nDirectionUsedToEnterRoom;
        PathStack pathStackNext;

        public PathStack()
          {
            room=null;
            passageUsedToEnterRoom=null;
            nDirectionUsedToEnterRoom=0;
            pathStackNext=null;
          }
      }

    private java.awt.Button    m_buttonAbout;
    private java.awt.Button    m_buttonAboutOk;
    private java.awt.Button    m_buttonCarry;
    private java.awt.Button    m_buttonDown;
    private java.awt.Button    m_buttonDrop;
    private java.awt.Button    m_buttonEast;
    private java.awt.Button    m_buttonMineNumberOk;
    private java.awt.Button    m_buttonNorth;
    private java.awt.Button    m_buttonSouth;
    private java.awt.Button    m_buttonUp;
    private java.awt.Button    m_buttonWayOut;
    private java.awt.Button    m_buttonWest;
    private char               m_cDirection [] = {'N','S','E','W','U','D'};
    private java.awt.Label     m_labelInstructions;
    private java.awt.Label     m_labelInventory;
    private java.awt.Label     m_labelLocation;
    private java.awt.Label     m_labelMineNumber;
    private java.awt.Label     m_labelStatus;
    private int                m_nAddIndex;
    private int                m_nChokepoints;
    private int                m_nDirectionOpposite [] = {1,0,3,2,5,4};
    private int                m_nMoves;
    private int                m_nReplaceIndex;
    private int []             m_nRN = new int [8];
    private int                m_nRNPartialSum;
    private int                m_nRooms;
    private int                m_nTreasures;
    private PathStack          m_pathStackHead;
    private Room               m_room;
    private Room               m_roomEntrance;
    private Room []            m_roomWithName;
    private StringBuffer       m_sbWayOut;
    private String             m_strAbout =
      "    Mines\n\n"+
      "    Copyright (c) 1979, 2005 James L. Dean\n\n"+
      "    Version 2.4 released October 25, 2005\n\n"+
      "    This Java applet may be distributed or used without payment "+
      "to its author.  Derivative works must credit its author.\n\n"+
      "    \"Mines\" lets you explore mines. The mine you explore "+
      "is determined by a mine number specified at the beginning of "+
      "a game.\n\n"+
      "    The object of a game is to visit all of the rooms and return "+
      "all of the treasures to the entrance without making too many "+
      "moves.\n\n"+
      "    In a mine, the passages are straight.  So, for example, if "+
      "you go North to leave a room, you can go South to reenter "+
      "it.  The rooms are not evenly spaced.  However, the distance "+
      "between adjacent rooms is always a multiple of the minimum "+
      "distance between adjacent rooms.";
    private String             m_strDirection [] =
                  {"north","south","east","west","up","down"};
    private String             m_strGuardian [] =
      {
        "gorgon",
        "grizzly bear",
        "vampire",
        "crocodile",
        "giant crayfish",
        "troll",
        "werewolf",
        "harpy",
        "cobra",
        "ferocious snail",
        "vicious Doberman pinscher",
        "colossal cockroach",
        "giant",
        "Trekkie",
        "titanic ant",
        null
      };
    private String             m_strRoom [] =
      {
        "a spherical room.",
        "the hall of bones.  Dinosaur bones are everywhere.",
        "a subway tunnel.  Don't touch that third rail!",
        "a railroad tunnel.  A whistle wails in the distance.",
        "an elfin quiche factory.  The elves are out mowing spinach.",
        "an abandoned Plymouth plant.  Beware of Road Runners and Barracudas.",
        "an abandoned Dodge plant.  There is a Dart embedded in the North wall.",
        "a mouse's nest.  You'd best exhale; this is a small room.",
        "a giant crayfish hole.  An immense chicken neck is hanging from a rope.",
        "an abandoned coal mine.  Beware of methane.",
        "the hall of winds.  Presently, the wind is from the south.",
        "a stove pipe!",
        "a totally darkened room.  Although you can see nothing, the sound of dripping water echoes from the walls.",
        "an industrial waste site.  Hold your breath and don't touch anything.",
        "the warehouse for an extremely popular brand of home computer.  Tacky plastic enclosures abound.",
        "a hobbit's bedroom.  The hobbit does not look pleased!",
        "a troll sewerage processing plant.  The air quality is not good.",
        "a rabbit hole.  There is a jar of marmalade on a shelf in the wall.",
        "the giant's oven.  Fortunately, it hasn't been used for years.",
        "a hobbit's drying room.  Tobacco leaves abound.",
        "a large circular room.  It is dark in here.",
        "the Crystal Palace.  Quartz crystals cover the walls.",
        "the Emerald Room.  Green crystals cover the ceiling.",
        "a curtained room.",
        "an air conditioning duct!",
        "a giant kiln.  Smoke stains the walls.",
        "the Hall of Mists.  Wisps of white vapor rise from the floor.",
        "an Aztec pyramid.  A mummy lies in the northwest corner.",
        "the Room of the Eternal Flame.  A large natural gas flame burns in the center of the room.  Coming from the west wall you can barely hear the words, 'Fee Fye Foe Fum'.",
        "the Giant's store room.  You are surrounded by old rugs, books, chairs, etc.",
        "the Leprechaun's Treasure Room.  Unfortunately, the leprechaun's treasure was stolen years ago.",
        "a large tiled room.  A girl is inquiring after a rabbit.  Feel free to ignore her.",
        "a former nuclear test site.  There is a large pile of rubble in the center of the floor.  The walls are streaked with a multitude of colors.",
        "a drainage system holding tank.  Either it is no longer used, or it hasn't rained in a long time; the room is dry.",
        "Mayor Schiro's bomb shelter.",
        "a room with a waterfall.  It is not very impressive; it looks like someone left a water faucet running.",
        "an abandoned Neanderthal home.",
        "a volcanic chimney.  The air is getting warmer.",
        "a pit full of snakes.  Let's get out of here!!!!",
        "a salt dome.",
        "Eleanor Roosevelt's privy.  Wendell Wilkie buttons cover the wall.",
        "Napoleon's wine cellar.  German wines line the shelves.",
        "the space behind the giant's bathroom wall. Large razor blades litter the floor.  Step lightly.",
        "the room where all old toe nail clipping come to rest.  Used corn pads litter the floor.",
        "the Den of the Horta.  The walls are covered with a sticky fluid.  Don't touch it; it is extremely corrosive.",
        "a damp room.  A small creek runs into a crack in the West wall.",
        "what appears to be a NOPSI manhole.",
        "the cafeteria of Mammoth Cave.  The aroma of rancid corned beef assails your nostrils.",
        "a small room with a large table.  On the table is a bottle that says, 'Drink me.'",
        "a Confederate States of America bank vault.  Once worthless currency papers the walls.",
        "an abandoned subway station.",
        "a mine shaft.  In the distance you can hear seven high pitched voices singing, 'Hi Ho, Hi Ho, ...'",
        "a Minuteman missile silo.",
        "the giant's mouse trap.  Fortunately, you are small enough to escape.",
        "Adolph Hitler's summer bunker.",
        "a dwarf work site.  A sign says, \"Under construction. Enter at your own risk.\"",
        "the giant's refrigerator.  Dwarf bodies hang from hooks.",
        "the Dragon's Lair.  Slightly melted suits of armor litter the floor.",
        "a nuclear waste depository.  The walls glow faintly.",
        "Millard Fillmore's tomb.  It is dull.",
        "an abandoned corridor of the Strategic Air Command Headquarters.  A graffito reads, \"Beware of Bat Guano.\"",
        "a gnome's workshop.  Half-completed whoopee cushions line the tables.",
        "the Mummy's Tomb.  You've triggered some mechanism and the ceiling is slowly descending.",
        "the Underground Gourmet's retreat.  Twinkie and King Don wrappers are piled knee deep.",
        "a Hoola Hoop warehouse.  The words \"Shoop Shoop\" echo from the walls.",
        "the first circle of hell.  The living are not allowed here.",
        "the hall of the pixies.  The furniture appears to have been made from cradles.",
        "a sulfur mine.  Molten sulfur churns in a nearby pit. It is becoming difficult to breath.",
        "a fairy mushroom farm.  Brilliantly colored mushrooms cover the floor.",
        "an ice cave.  Along the western wall, a brontosaurus is defrosting.",
        "the giant's stove.  Fortunately, the giant now owns a microwave oven.",
        "the rib cage of a long deceased whale.",
        "a room with six walls.  The walls appear to be made of wax.  A loud buzzing noise can be heard.",
        "the tomb of a Pharaoh.  It has obviously been visited by others; the tomb is in a state of total disarray.",
        "a coal bin.  There is a fossilized fern stump here.",
        "a diamond mine.  It is uncomfortably hot here.",
        "the bottom of an oil well.  The walls are slick.",
        "the lowest level of Project Mohole.  The funding bubble burst before the earth did.",
        "the giant's cesspool.  Fortunately, the giant was connected to the city sewerage system years ago.",
        "an eighteenth century sewer.  The walls are crumbling brick.  Small alligators snap at your feet.",
        "the lair of a giant trapdoor spider.",
        "a giant gopher tunnel.",
        "a shell -- the sole remains of a prehistoric turtle.",
        "a small chamber.  The walls are made of earth.  The air smells of formic acid.  A strange squeaking noise can be heard in the distance.",
        "a chamber of columns.  The stalagmites and stalactites join here.",
        "a service tunnel.  Ducts, pipes, and cables are everywhere.",
        "a gas tank below an abandoned service station.  No smoking!",
        "a huge dark chamber.  To one side, a dark, muddy river moves sluggishly.  A sign written in ancient Greek says, \"Ferry out of order.\"",
        "a small chamber. It is brightly lit by a peculiar lichen growing on the walls and ceiling.  The floor is rocky and steeply sloping.  Nearby, a cold, clear creek boils into the floor and out of sight.",
        "the nest of a very large pack rat.  There are discarded aluminum Christmas trees, broken steel utility poles, and other shiny, worthless items here.",
        "a dungeon.  An iron maiden, a rack, a piano, and other machines of torture can be seen.",
        "the hall of bats.  Thousands of bats hang from the ceiling.  Watch your step; the droppings are quite deep in places.",
        "a hobgoblin's hideaway.",
        "an electrical substation.  A transformer is humming loudly.  Nearby, cables crackle with high voltage.",
        "the \"gold\" room.  The walls are covered with iron pyrite.",
        "a room with one of Dracula's emergency coffins.  The Count is out.",
        "a saltpeter mine.  To one side there is a huge wooden evaporation vat.  Small crystals of saltpeter cause the walls to sparkle.",
        "the basement cafeteria of a local hospital.  Some say that there has been nothing edible here for years.",
        "a troll arsenal.  Kegs of gun powder surround you.",
        null
      };
    private String             m_strTreasure [] =
      {
        "bag full of gold coins",
        "large blue-white diamond",
        "sixty carat emerald",
        "platinum crucifix",
        "string of pearls",
        "Ming vase",
        "list of the next ten winners of the Kentucky Derby",
        "pile of rubies",
        "previously undiscovered Rembrandt painting",
        "ounce of antimatter in magnetic containment",
        "stack of silver bars",
        "set of ivory tusks",
        "Holland and Holland double rifle chambered for .600 Nitro Express",
        "ancient Greek statue",
        "five kilograms of plutonium in a lead container",
        null
      };
    private String             m_strWeapon [] =
      {
        "mirror",
        "pepper spray dispenser",
        "wooden stake",
        "roll of duct tape",
        "jar of Zatarain's Crab Boil",
        "elfin sword",
        "silver bullet",
        "crossbow",
        "flute fashioned from a dried-out pumpkin",
        "bag of salt",
        "soporific-laced dog biscuit",
        "block of boric acid",
        "slingshot",
        "recording of Leonard Nimoy singing \"Proud Mary\"",
        "Fresnel lens",
        null
      };
    private java.awt.TextArea  m_textAreaAbout;
    private java.awt.TextArea  m_textAreaInventory;
    private java.awt.TextArea  m_textAreaLocation;
    private java.awt.TextArea  m_textAreaStatus;
    private java.awt.TextField m_textFieldMineNumber;
    private Treasure []        m_treasure;

    private int RandomNumber()
      {
        int nResult;
        /*
            Each pseudo-random number is the modulo sum of the
          previous eight pseudo-random numbers.  A prime modulus
          makes it likely that the pseudo-random numbers will be
          uniformly distributed.  To speed computation, a partial
          sum of 7 of the 8 previous pseudo-random numbers is maintained.
               For a given set of initial values m_nRN[i], i=0,1,2,...,7,
          this random number generator should produce the same sequence
          of random numbers, no matter what 32-bit compiler it is compiled
          under.
        */
        do
          {
            nResult=m_nRNPartialSum+m_nRN[m_nAddIndex];
            if (nResult >= 32771)
              nResult-=32771;
            m_nRNPartialSum=nResult-m_nRN[m_nReplaceIndex];
            if (m_nRNPartialSum < 0)
              m_nRNPartialSum+=32771;
            m_nRN[m_nReplaceIndex]=nResult;
            m_nAddIndex=m_nReplaceIndex;
            if (++m_nReplaceIndex >= 8)
              m_nReplaceIndex=0;
          }
        while (nResult > 32767);
        return nResult;
      }

    private void SeedRandomNumberGenerator(
     String strMine)
      {
        int  nKeyIndex;
        int  nKeyStart;
        int  nKeyLength;

        nKeyLength=strMine.length();
        nKeyIndex=0;
        for (nKeyStart=nKeyLength; nKeyStart < 8; ++nKeyStart)
          m_nRN[nKeyIndex++]=1+(int) '0';
        nKeyStart=0;
        for (nKeyStart=0; ((nKeyStart < 8) && (nKeyStart < nKeyLength));
         ++nKeyStart)
          m_nRN[nKeyIndex++]=1+(int) (strMine.charAt(nKeyStart));
        m_nRNPartialSum=0;
        for (nKeyIndex=7; nKeyIndex > 0; --nKeyIndex)
          {
            m_nRNPartialSum+=m_nRN[nKeyIndex];
            if (m_nRNPartialSum >= 32771)
              m_nRNPartialSum-=32771;
          }
        m_nReplaceIndex=1;
        m_nAddIndex=0;
        for (nKeyIndex=256; nKeyIndex-- > 0;)
          RandomNumber();
        return;
      }

    private void ShuffleRoomDescriptions()
      {
        int    nRoom1;
        int    nRoom2;
        String str;

        for (nRoom1=m_nRooms-1; nRoom1 > 0; --nRoom1)
          {
            nRoom2=RandomNumber()%nRoom1;
            str=m_strRoom[nRoom1];
            m_strRoom[nRoom1]=m_strRoom[nRoom2];
            m_strRoom[nRoom2]=str;
          }
        return;
      }

    private void ExcavateMine()
      {
        int     nChokepoint;
        int     nDirectionOpposite;
        int     nDirection1;
        int     nDirection2;
        int     nDistance;
        int     nHeight;
        int     nLen;
        int     nMax;
        int     nRoom;
        int     nStep;
        int     nTreasure;
        int     nUnblocked;
        int     nWidth;
        int     nX;
        int     nXFirstRoom;
        int     nY;
        int     nYFirstRoom;
        int     nZ;
        int     nZFirstRoom;
        Passage passage;
        Room    room;
        Room    roomDown;
        Room    roomNext;
        Room    roomStart;
        Room    roomSouth;
        Room    roomSouthBase;
        Room    roomWest;
        Room    roomWestBase;
        Room    roomWestBaseBase;

        nMax=(int) (10.0+Math.exp(Math.log((double) m_nRooms)/3.0));
        do
          {
            nLen=RandomNumber()%(nMax-3)+3;
            nWidth=RandomNumber()%(nMax-3)+3;
            nHeight=RandomNumber()%(nMax-3)+3;
          }
        while ((nLen*nWidth*nHeight < 2*(m_nRooms-1))
        ||     (nLen*nWidth*nHeight > 3*(m_nRooms-1)));
        nXFirstRoom=0;
        nYFirstRoom=RandomNumber()%nLen;
        nZFirstRoom=RandomNumber()%nHeight;
        roomWestBase=null;
        roomWestBaseBase=null;
        for (nX=0; nX < nWidth; ++nX)
          {
            roomSouthBase=null;
            for (nY=0; nY < nLen; ++nY)
              {
                roomWest=roomWestBase;
                roomSouth=roomSouthBase;
                roomDown=null;
                for (nZ=0; nZ < nHeight; ++nZ)
                  {
                    room=new Room();
/*
  (X,Y,Z) gets linked to (X-1,Y,Z); (X,Y-1,Z); and (X,Y,Z-1)
                         roomWest   roomSouth      roomDown
*/
                    if (nZ == 0)
                      {
                        roomSouthBase=room;
                        if (nY == 0)
                          roomWestBaseBase=room;
                      }
                    if (roomDown != null)
                      {
                      /* link room to one below it */
                        passage=new Passage();
                        passage.room1=room;
                        passage.room2=roomDown;
                        room.passage[5]=passage;
                        roomDown.passage[4]=passage;
                      }
                    if (roomSouth != null)
                      {
                        /* link to room to the south */
                        passage=new Passage();
                        passage.room1=room;
                        passage.room2=roomSouth;
                        room.passage[1]=passage;
                        roomSouth.passage[0]=passage;
                        if (roomSouth.passage[4] != null)
                          if (roomSouth.passage[4].room1
                           == roomSouth)
                            roomSouth
                             =roomSouth.passage[4].room2;
                          else
                            roomSouth
                             =roomSouth.passage[4].room1;
                        else
                          roomSouth=null;
                      }
                    if (roomWest != null)
                      {
                      /* link to the room to the west */
                        passage=new Passage();
                        passage.room1=room;
                        passage.room2=roomWest;
                        room.passage[3]=passage;
                        roomWest.passage[2]=passage;
                        if (roomWest.passage[4] != null)
                          if (roomWest.passage[4].room1
                           == roomWest)
                            roomWest=roomWest.passage[4].
                             room2;
                          else
                            roomWest=roomWest.passage[4].
                             room1;
                        else
                          roomWest=null;
                       }
                    /* If this is the first room, connect it to the entrance. */
                    if ((nX == nXFirstRoom)
                    &&  (nY == nYFirstRoom)
                    &&  (nZ == nZFirstRoom))
                      {
                        passage=new Passage();
                        passage.bBlocked=false;
                        passage.room1=room;
                        passage.room2=m_roomEntrance;
                        room.passage[3]=passage;
                        m_roomEntrance.passage[2]
                         =passage;
                      }
                    roomDown=room;
                  }
                if (roomWestBase != null)
                  {
                    if (roomWestBase.passage[0] != null)
                      {
                        if (roomWestBase.passage[0].room1
                         == roomWestBase)
                          roomWestBase
                           =roomWestBase.passage[0].room2;
                        else
                          roomWestBase
                           =roomWestBase.passage[0].room1;
                      }
                  }
              }
            roomWestBase=roomWestBaseBase;
          }
        nChokepoint=-1;
        nTreasure=0;
        room=m_roomEntrance;
        nRoom=0;
        while (nRoom < m_nRooms)
          {
            roomStart=room;
            nDirection1=RandomNumber()%6;
            nDirectionOpposite=m_nDirectionOpposite[nDirection1];
            nDistance=RandomNumber()%3+1;
            nStep=0;
            while ((room.passage[nDirection1] != null)
            &&     (nStep < nDistance))
              {
                passage=room.passage[nDirection1];
                if (passage.room1 == room)
                  roomNext=passage.room2;
                else
                  roomNext=passage.room1;
                if (passage.bBlocked)
                  if ((roomNext.nChokepoint == nChokepoint)
                  ||  (! roomNext.bMined))
                    {
                      room=roomNext;
                      room.bMined=true;
                      room.nChokepoint=nChokepoint;
                      passage.bBlocked=false;
                      if (room.strDescription != null)
                        ++nStep;
                      else
                        {
                          nUnblocked=0;
                          for (nDirection2=6;
                           ((nUnblocked < 2) && (nDirection2-- > 0));)
                            if (nDirection2 != nDirectionOpposite)
                              if (room.passage[nDirection2] != null)
                                if (! room.passage[nDirection2].bBlocked)
                                  ++nUnblocked;
                          if (nUnblocked < 2)
                            ++nStep;
                          else
                            nStep=nDistance;
                        }
                    }
                  else
                    nStep=nDistance;
                else
                  {
                    ++nStep;
                    room=roomNext;
                    nChokepoint=room.nChokepoint;
                  }
              }
            if (nStep != 0)
              {
                if (room.strDescription == null)
                  {
                    room.strDescription=m_strRoom[nRoom];
                    nDirection1=0;
                    nUnblocked=0;
                    for (nDirection2=6;
                     ((nUnblocked < 2) && (nDirection2-- > 0));)
                      if (room.passage[nDirection2] != null)
                        if (! room.passage[nDirection2].bBlocked)
                          {
                            nDirection1=nDirection2;
                            ++nUnblocked;
                          }
                    if (nUnblocked == 1)
                      {
                        if ((m_nRooms-nRoom)*RandomNumber()
                         < 32768*(m_nTreasures-nTreasure))
                          {
                            nChokepoint=nTreasure;
                            room.passage[nDirection1].
                             treasureGuardian=m_treasure[nTreasure];
                            ++nTreasure;
                          }
                      }
                    room.nChokepoint=nChokepoint;
                    m_roomWithName[nRoom]=room;
                    ++nRoom;
                  }
              }
          }
        m_roomWithName[nRoom]=m_roomEntrance;
        m_nChokepoints=nTreasure;
        return;
      }

    private void HideTreasuresAndWeapons()
      {
        int nRoom;
        int nTreasure;

        for (nTreasure=0; nTreasure < m_nChokepoints; ++nTreasure)
          {
            do
              nRoom=RandomNumber()%m_nRooms;
            while (m_roomWithName[nRoom].nChokepoint != nTreasure);
            m_treasure[nTreasure].roomTreasure=m_roomWithName[nRoom];
            do
              nRoom=RandomNumber()%(m_nRooms+1);
            while (m_roomWithName[nRoom].nChokepoint >= nTreasure);
            m_treasure[nTreasure].roomWeapon=m_roomWithName[nRoom];
          }
        for (nTreasure=m_nChokepoints; nTreasure < m_nTreasures; ++nTreasure)
          {
            nRoom=RandomNumber()%m_nRooms;
            m_treasure[nTreasure].roomTreasure=m_roomWithName[nRoom];
          }
        return;
      }

    private void ListPassages()
      {
        char     cFirstChar;
        int      nDirection;
        int      nPassage;
        Room     roomAlongPassage;
        Treasure treasure;
        String   strDescription;

        m_buttonNorth.setEnabled(false);
        m_buttonSouth.setEnabled(false);
        m_buttonEast.setEnabled(false);
        m_buttonWest.setEnabled(false);
        m_buttonUp.setEnabled(false);
        m_buttonDown.setEnabled(false);
        for (nDirection=0; nDirection < 6; ++nDirection)
          if ((m_room.passage[nDirection] != null)
          &&  (! m_room.passage[nDirection].bBlocked))
            switch (nDirection)
              {
                case 0:
                  m_buttonNorth.setEnabled(true);
                  break;
                case 1:
                  m_buttonSouth.setEnabled(true);
                  break;
                case 2:
                  m_buttonEast.setEnabled(true);
                  break;
                case 3:
                  m_buttonWest.setEnabled(true);
                  break;
                case 4:
                  m_buttonUp.setEnabled(true);
                  break;
                default:
                  m_buttonDown.setEnabled(true);
                  break;
              }
        for (nDirection=0; nDirection < 6; ++nDirection)
          {
            strDescription=null;
            roomAlongPassage=m_room;
            while ((roomAlongPassage.passage[nDirection] != null)
            &&     (! roomAlongPassage.passage[nDirection].bBlocked)
            &&     (strDescription == null))
              {
                if ((treasure=roomAlongPassage.passage[
                 nDirection].treasureGuardian) != null)
                  {
                    m_textAreaLocation.append("     The passage ");
                    m_textAreaLocation.append(m_strDirection[nDirection]);
                    m_textAreaLocation.append(" is guarded by a");
                    cFirstChar=treasure.strGuardian.charAt(0);
                    if ((cFirstChar == 'A')
                    ||  (cFirstChar == 'a')
                    ||  (cFirstChar == 'E')
                    ||  (cFirstChar == 'e')
                    ||  (cFirstChar == 'I')
                    ||  (cFirstChar == 'i')
                    ||  (cFirstChar == 'O')
                    ||  (cFirstChar == 'o')
                    ||  (cFirstChar == 'U')
                    ||  (cFirstChar == 'u'))
                      m_textAreaLocation.append("n");
                    m_textAreaLocation.append(" ");
                    m_textAreaLocation.append(treasure.strGuardian);
                    m_textAreaLocation.append(".\n");
                  }
                if (roomAlongPassage.passage[nDirection].room1
                 == roomAlongPassage)
                  roomAlongPassage
                   =roomAlongPassage.passage[nDirection].room2;
                else
                  roomAlongPassage
                   =roomAlongPassage.passage[nDirection].room1;
                strDescription=roomAlongPassage.strDescription;
              }
          }
        return;
      }

    private void ListTreasures()
      {
        char cFirstChar;
        int  nTreasure;

        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == m_room)
            {
              m_buttonCarry.setEnabled(true);
              m_textAreaLocation.append("     There is a");
              cFirstChar=m_treasure[nTreasure].strTreasure.charAt(0);
              if ((cFirstChar == 'A')
              ||  (cFirstChar == 'a')
              ||  (cFirstChar == 'E')
              ||  (cFirstChar == 'e')
              ||  (cFirstChar == 'I')
              ||  (cFirstChar == 'i')
              ||  (cFirstChar == 'O')
              ||  (cFirstChar == 'o')
              ||  (cFirstChar == 'U')
              ||  (cFirstChar == 'u'))
                m_textAreaLocation.append("n");
              m_textAreaLocation.append(" ");
              m_textAreaLocation.append(m_treasure[nTreasure].strTreasure);
              m_textAreaLocation.append(" here.\n");
            }
        return;
      }

    private void ListWeapons()
      {
        char cFirstChar;
        int  nTreasure;

        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomWeapon == m_room)
            {
              m_buttonCarry.setEnabled(true);
              m_textAreaLocation.append("     There is a");
              cFirstChar=m_treasure[nTreasure].strTreasure.charAt(0);
              if ((cFirstChar == 'A')
              ||  (cFirstChar == 'a')
              ||  (cFirstChar == 'E')
              ||  (cFirstChar == 'e')
              ||  (cFirstChar == 'I')
              ||  (cFirstChar == 'i')
              ||  (cFirstChar == 'O')
              ||  (cFirstChar == 'o')
              ||  (cFirstChar == 'U')
              ||  (cFirstChar == 'u'))
                m_textAreaLocation.append("n");
              m_textAreaLocation.append(" ");
              m_textAreaLocation.append(m_treasure[nTreasure].strWeapon);
              m_textAreaLocation.append(" here.\n");
            }
        return;
      }

    private void UpdateInventory()
      {
        boolean bFirstLine;
        int     nTreasure;

        bFirstLine=true;
        m_textAreaInventory.setText("");
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == null)
            {
              if (bFirstLine)
                {
                  bFirstLine=false;
                  m_buttonDrop.setEnabled(true);
                }
              m_textAreaInventory.append("     ");
              m_textAreaInventory.append(m_treasure[nTreasure].strTreasure);
              m_textAreaInventory.append("\n");
            }
        for (nTreasure=m_nChokepoints; nTreasure-- > 0;)
          if ((m_treasure[nTreasure].roomWeapon == null)
          &&  (! m_treasure[nTreasure].bSlain))
            {
              m_textAreaInventory.append("     ");
              m_textAreaInventory.append(m_treasure[nTreasure].strWeapon);
              m_textAreaInventory.append("\n");
            }
        return;
      }

    private void UpdateStatus()
      {
        Integer integerMoves;
        Integer integerRooms;
        Integer integerRoomsVisited;
        Integer integerScore;
        Integer integerTreasures;
        Integer integerTreasuresCarried;
        Integer integerTreasuresRecovered;
        int     nRoom;
        int     nRoomsVisited;
        int     nScore;
        int     nTreasure;
        int     nTreasuresCarried;
        int     nTreasuresRecovered;

        integerRooms=new Integer(m_nRooms+1);
        nScore=0;
        nTreasuresRecovered=0;
        nTreasuresCarried=0;
        nRoomsVisited=0;
        for (nRoom=0; nRoom <= m_nRooms; ++nRoom)
          if (m_roomWithName[nRoom].bVisited)
            ++nRoomsVisited;
        integerRoomsVisited=new Integer(nRoomsVisited);
        integerMoves=new Integer(m_nMoves);
        m_textAreaStatus.setText("     You have moved ");
        m_textAreaStatus.append(integerMoves.toString());
        m_textAreaStatus.append(" times to visit ");
        m_textAreaStatus.append(integerRoomsVisited.toString());
        m_textAreaStatus.append(" of ");
        m_textAreaStatus.append(integerRooms.toString());
        m_textAreaStatus.append(" locations.\n");
        integerTreasures=new Integer(m_nTreasures);
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == null)
            ++nTreasuresCarried;
        integerTreasuresCarried=new Integer(nTreasuresCarried);
        m_textAreaStatus.append("     You hold ");
        m_textAreaStatus.append(integerTreasuresCarried.toString());
        m_textAreaStatus.append(" of ");
        m_textAreaStatus.append(integerTreasures.toString());
        m_textAreaStatus.append(" treasures.\n");
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == m_roomEntrance)
            ++nTreasuresRecovered;
        integerTreasuresRecovered=new Integer(nTreasuresRecovered);
        m_textAreaStatus.append("     You have returned ");
        m_textAreaStatus.append(integerTreasuresRecovered.toString());
        m_textAreaStatus.append(" of ");
        m_textAreaStatus.append(integerTreasures.toString());
        m_textAreaStatus.append(" treasures to the entrance of the mine.\n");
        nScore=25*nRoomsVisited/(m_nRooms+1)
         +75*nTreasuresRecovered/m_nTreasures
         +45*nTreasuresCarried/m_nTreasures;
        if (nRoomsVisited > 5*m_nRooms)
          {
            nScore=nScore-nRoomsVisited/(5*m_nRooms);
            if (nScore < 0)
              nScore=0;
          }
        integerScore=new Integer(nScore);
        m_textAreaStatus.append("     You have scored ");
        m_textAreaStatus.append(integerScore.toString());
        m_textAreaStatus.append(" of 100 points.\n");
        if (nScore < 25)
          m_textAreaStatus.append(
           "     Your score ranks you as a beginner.\n");
        else if (nScore < 50)
          m_textAreaStatus.append(
           "     Your score ranks you as a novice adventurer.\n");
        else if (nScore < 75)
          m_textAreaStatus.append(
           "     Your score ranks you as a seasoned explorer.\n");
        else if (nScore < 100)
          m_textAreaStatus.append(
           "     Your score ranks you as a grissly old prospector.\n");
        else
          m_textAreaStatus.append(
           "     Your score ranks you as an expert treasure hunter; there is no higher rating.\n");
        return;
      }

    private void UpdateScreen(boolean bSomethingAlreadyWritten)
      {
        if (bSomethingAlreadyWritten)
          m_textAreaLocation.append("     You\'re in ");
        else
          m_textAreaLocation.setText("     You\'re in ");
        m_textAreaLocation.append(m_room.strDescription);
        m_textAreaLocation.append("\n");
        ListPassages();
        m_buttonCarry.setEnabled(false);
        ListTreasures();
        ListWeapons();
        m_buttonDrop.setEnabled(false);
        UpdateInventory();
        UpdateStatus();
        m_textAreaStatus.setCaretPosition(0);
        m_textAreaInventory.setCaretPosition(0);
        m_textAreaLocation.setCaretPosition(0);
      }

    private void Move(int nDirection)
      {
        boolean bGuarded;
        boolean bSomethingWritten;
        Room    roomAlongPassage;
        String  strDescription;

        bSomethingWritten=false;
        if ((m_room.passage[nDirection] != null)
        &&  (! m_room.passage[nDirection].bBlocked))
          {
            bGuarded=false;
            strDescription=null;
            roomAlongPassage=m_room;
            while((roomAlongPassage.passage[nDirection] != null)
            &&    (strDescription == null))
              {
                if (roomAlongPassage.passage[nDirection].treasureGuardian
                 != null)
                  {
                    if (roomAlongPassage.passage[
                     nDirection].treasureGuardian.roomWeapon != null)
                      {
                        bGuarded=true;
                        m_textAreaLocation.setText(
                         "     You carry nothing to overcome the ");
                        bSomethingWritten=true;
                        m_textAreaLocation.append(roomAlongPassage.passage[
                         nDirection].treasureGuardian.strGuardian);
                        m_textAreaLocation.append(".\n");
                      }
                    else
                      {
                        m_textAreaLocation.setText("     Your ");
                        bSomethingWritten=true;
                        m_textAreaLocation.append(roomAlongPassage.passage[
                         nDirection].treasureGuardian.strWeapon);
                        m_textAreaLocation.append(" overcomes the ");
                        m_textAreaLocation.append(roomAlongPassage.passage[
                         nDirection].treasureGuardian.strGuardian);
                        m_textAreaLocation.append(".\n");
                        roomAlongPassage.passage[
                         nDirection].treasureGuardian.bSlain=true;
                        roomAlongPassage.passage[
                         nDirection].treasureGuardian=null;
                      }
                  }
                if (roomAlongPassage.passage[nDirection].room1
                 == roomAlongPassage)
                  roomAlongPassage=roomAlongPassage.passage[nDirection].room2;
                else
                  roomAlongPassage=roomAlongPassage.passage[nDirection].room1;
                strDescription=roomAlongPassage.strDescription;
              }
            if (! bGuarded)
              {
                ++m_nMoves;
                roomAlongPassage.bVisited=true;
                m_room=roomAlongPassage;
              }
          }
        else
          {
            m_textAreaLocation.setText("     You can\'t go that way.\n");
            bSomethingWritten=true;
          }
        UpdateScreen(bSomethingWritten);
        return;
      }

    private void FindPathToEntrance(
     Room      room,
     int       nDirectionUsedToEnterRoom)
      {
        boolean   bRoomAlreadyInStack;
        int       nDirection1;
        int       nDirection2;
        int       nDirection3;
        int []    nDirectionRandom = new int [6];
        int       nPathLen;
        PathStack pathStack;

        if (room == m_roomEntrance)
          {
            nPathLen=0;
            pathStack=m_pathStackHead;
            while (pathStack != null)
              {
                if (pathStack.room.strDescription != null)
                  ++nPathLen;
                pathStack=pathStack.pathStackNext;
              }
            m_sbWayOut=new StringBuffer(nPathLen);
            for (int nChar=0; nChar < nPathLen; ++nChar)
              m_sbWayOut.append(' ');
            m_sbWayOut.setCharAt(--nPathLen,
            m_cDirection[nDirectionUsedToEnterRoom]);
            pathStack=m_pathStackHead;
            while (pathStack != null)
              {
                if (pathStack.pathStackNext != null)
                  {
                    if (pathStack.room.strDescription != null)
                      m_sbWayOut.setCharAt(--nPathLen,
                       m_cDirection[pathStack.nDirectionUsedToEnterRoom]);
                  }
                pathStack=pathStack.pathStackNext;
              }
          }
        else
          {
            bRoomAlreadyInStack=false;
            pathStack=m_pathStackHead;
            while ((pathStack != null) && (! bRoomAlreadyInStack))
              {
                bRoomAlreadyInStack=(pathStack.room == room);
                pathStack=pathStack.pathStackNext;
              }
            if (! bRoomAlreadyInStack)
              {
                pathStack=new PathStack();
                pathStack.room=room;
                pathStack.nDirectionUsedToEnterRoom=nDirectionUsedToEnterRoom;
                pathStack.pathStackNext=m_pathStackHead;
                m_pathStackHead=pathStack;
                for (nDirection1=6; nDirection1-- > 0;)
                  nDirectionRandom[nDirection1]=nDirection1;
                for (nDirection1=5; nDirection1 > 0; --nDirection1)
                  {
                    nDirection2=RandomNumber()%nDirection1;
                    nDirection3=nDirectionRandom[nDirection1];
                    nDirectionRandom[nDirection1]=nDirectionRandom[nDirection2];
                    nDirectionRandom[nDirection2]=nDirection3;
                  }
                for (nDirection1=6;
                 ((m_sbWayOut == null) && (nDirection1-- > 0));)
                  {
                    nDirection2=nDirectionRandom[nDirection1];
                    if (room.passage[nDirection2] != null)
                      {
                        if (! room.passage[nDirection2].bBlocked)
                          {
                            if (room.passage[nDirection2].room1
                             == room)
                              FindPathToEntrance(
                               room.passage[nDirection2].room2,
                               nDirection2);
                            else
                              FindPathToEntrance(
                               room.passage[nDirection2].room1,
                               nDirection2);
                          }
                      }
                  }
                m_pathStackHead=pathStack.pathStackNext;
              }
          }
        return;
      }

    public void init()
      {
        m_textAreaAbout=new java.awt.TextArea("",0,0,
         java.awt.TextArea.SCROLLBARS_VERTICAL_ONLY);
        m_buttonAboutOk=new java.awt.Button();
        m_labelInstructions=new java.awt.Label();
        m_labelStatus=new java.awt.Label();
        m_textAreaStatus=new java.awt.TextArea("",0,0,
         java.awt.TextArea.SCROLLBARS_VERTICAL_ONLY);
        m_labelInventory=new java.awt.Label();
        m_textAreaInventory=new java.awt.TextArea("",0,0,
         java.awt.TextArea.SCROLLBARS_VERTICAL_ONLY);
        m_labelLocation=new java.awt.Label();
        m_textAreaLocation=new java.awt.TextArea("",0,0,
         java.awt.TextArea.SCROLLBARS_VERTICAL_ONLY);
        m_buttonWest=new java.awt.Button();
        m_buttonEast=new java.awt.Button();
        m_buttonNorth=new java.awt.Button();
        m_buttonSouth=new java.awt.Button();
        m_buttonDown=new java.awt.Button();
        m_buttonUp=new java.awt.Button();
        m_buttonCarry=new java.awt.Button();
        m_buttonDrop=new java.awt.Button();
        m_buttonWayOut=new java.awt.Button();
        m_buttonAbout=new java.awt.Button();
        m_labelMineNumber=new java.awt.Label();
        m_textFieldMineNumber=new java.awt.TextField();
        m_buttonMineNumberOk=new java.awt.Button();

        setLayout(null);

        m_textAreaAbout.setBackground(new java.awt.Color(255,255,255));
        m_textAreaAbout.setEditable(false);
        m_textAreaAbout.setVisible(false);
        add(m_textAreaAbout);
        m_textAreaAbout.setBounds(10,10,610,250);

        m_buttonAboutOk.setLabel("Ok");
        m_buttonAboutOk.setVisible(false);
        m_buttonAboutOk.addActionListener(this);
        add(m_buttonAboutOk);
        m_buttonAboutOk.setBounds(290,270,31,24);

        m_labelInstructions.setText("Visit all of the rooms and move all of the treasures to the entrance.");
        add(m_labelInstructions);
        m_labelInstructions.setBounds(10,90,592,20);

        m_labelStatus.setText("Status");
        m_labelStatus.setVisible(false);
        add(m_labelStatus);
        m_labelStatus.setBounds(10,10,78,20);

        m_textAreaStatus.setBackground(new java.awt.Color(255,255,255));
        m_textAreaStatus.setEditable(false);
        m_textAreaStatus.setVisible(false);
        add(m_textAreaStatus);
        m_textAreaStatus.setBounds(10,34,280,116);

        m_labelInventory.setText("Inventory");
        m_labelInventory.setVisible(false);
        add(m_labelInventory);
        m_labelInventory.setBounds(12,156,88,20);

        m_textAreaInventory.setBackground(new java.awt.Color(255,255,255));
        m_textAreaInventory.setEditable(false);
        m_textAreaInventory.setVisible(false);
        add(m_textAreaInventory);
        m_textAreaInventory.setBounds(10,180,280,120);

        m_labelLocation.setText("Location");
        m_labelLocation.setVisible(false);
        add(m_labelLocation);
        m_labelLocation.setBounds(310,10,88,20);

        m_textAreaLocation.setBackground(new java.awt.Color(255,255,255));
        m_textAreaLocation.setEditable(false);
        m_textAreaLocation.setVisible(false);
        add(m_textAreaLocation);
        m_textAreaLocation.setBounds(310,34,310,116);

        m_buttonWest.setLabel("West");
        m_buttonWest.setVisible(false);
        m_buttonWest.addActionListener(this);

        add(m_buttonWest);
        m_buttonWest.setBounds(360,220,50,24);

        m_buttonEast.setLabel("East");
        m_buttonEast.setVisible(false);
        m_buttonEast.addActionListener(this);

        add(m_buttonEast);
        m_buttonEast.setBounds(460,220,50,24);

        m_buttonNorth.setLabel("North");
        m_buttonNorth.setVisible(false);
        m_buttonNorth.addActionListener(this);

        add(m_buttonNorth);
        m_buttonNorth.setBounds(410,190,50,24);

        m_buttonSouth.setLabel("South");
        m_buttonSouth.setVisible(false);
        m_buttonSouth.addActionListener(this);

        add(m_buttonSouth);
        m_buttonSouth.setBounds(410,250,50,24);

        m_buttonDown.setLabel("Down");
        m_buttonDown.setVisible(false);
        m_buttonDown.addActionListener(this);

        add(m_buttonDown);
        m_buttonDown.setBounds(340,260,50,24);

        m_buttonUp.setLabel("Up");
        m_buttonUp.setVisible(false);
        m_buttonUp.addActionListener(this);

        add(m_buttonUp);
        m_buttonUp.setBounds(480,180,50,24);

        m_buttonCarry.setForeground(new java.awt.Color(0,0,0));
        m_buttonCarry.setLabel("Carry");
        m_buttonCarry.setVisible(false);
        m_buttonCarry.addActionListener(this);

        add(m_buttonCarry);
        m_buttonCarry.setBounds(560,170,60,24);

        m_buttonDrop.setLabel("Drop");
        m_buttonDrop.setVisible(false);
        m_buttonDrop.addActionListener(this);

        add(m_buttonDrop);
        m_buttonDrop.setBounds(560,200,60,24);

        m_buttonWayOut.setLabel("Way Out");
        m_buttonWayOut.setVisible(false);
        m_buttonWayOut.addActionListener(this);

        add(m_buttonWayOut);
        m_buttonWayOut.setBounds(560,230,61,24);

        m_buttonAbout.setLabel("About");
        m_buttonAbout.setVisible(false);
        m_buttonAbout.addActionListener(this);

        add(m_buttonAbout);
        m_buttonAbout.setBounds(560,260,60,24);

        m_labelMineNumber.setAlignment(java.awt.Label.RIGHT);
        m_labelMineNumber.setText("Mine Number:");
        add(m_labelMineNumber);
        m_labelMineNumber.setBounds(120,10,90,20);

        m_textFieldMineNumber.setText("1");
        add(m_textFieldMineNumber);
        m_textFieldMineNumber.setBounds(220,8,70,22);

        m_buttonMineNumberOk.setLabel("Ok");
        m_buttonMineNumberOk.addActionListener(this);

        add(m_buttonMineNumberOk);
        m_buttonMineNumberOk.setBounds(290,160,31,24);

        super.init();
      }

    private void buttonAboutOkClicked()
      {
        m_textAreaAbout.setVisible(false);
        m_buttonAboutOk.setVisible(false);
        m_labelMineNumber.setVisible(true);
        m_textFieldMineNumber.setVisible(true);
        m_labelStatus.setVisible(true);
        m_textAreaStatus.setVisible(true);
        m_labelInventory.setVisible(true);
        m_textAreaInventory.setVisible(true);
        m_labelLocation.setVisible(true);
        m_textAreaLocation.setVisible(true);
        m_buttonWest.setVisible(true);
        m_buttonEast.setVisible(true);
        m_buttonNorth.setVisible(true);
        m_buttonSouth.setVisible(true);
        m_buttonUp.setVisible(true);
        m_buttonDown.setVisible(true);
        m_buttonCarry.setVisible(true);
        m_buttonDrop.setVisible(true);
        m_buttonWayOut.setVisible(true);
        m_buttonAbout.setVisible(true);
      }

    private void buttonAboutClicked()
      {
        m_labelMineNumber.setVisible(false);
        m_textFieldMineNumber.setVisible(false);
        m_labelStatus.setVisible(false);
        m_textAreaStatus.setVisible(false);
        m_labelInventory.setVisible(false);
        m_textAreaInventory.setVisible(false);
        m_labelLocation.setVisible(false);
        m_textAreaLocation.setVisible(false);
        m_buttonWest.setVisible(false);
        m_buttonEast.setVisible(false);
        m_buttonNorth.setVisible(false);
        m_buttonSouth.setVisible(false);
        m_buttonUp.setVisible(false);
        m_buttonDown.setVisible(false);
        m_buttonCarry.setVisible(false);
        m_buttonDrop.setVisible(false);
        m_buttonWayOut.setVisible(false);
        m_buttonAbout.setVisible(false);
        m_labelInstructions.setVisible(false);
        m_textAreaAbout.setText(m_strAbout);
        m_textAreaAbout.setCaretPosition(0);
        m_textAreaAbout.setVisible(true);
        m_buttonAboutOk.setVisible(true);
      }

    private void buttonMineNumberOkClicked()
      {
        m_labelInstructions.setVisible(false);
        m_buttonMineNumberOk.setVisible(false);
        m_textFieldMineNumber.setEnabled(false);
        m_roomEntrance=new Room();
        m_roomEntrance.strDescription=new String("the entrance to the mine.");
        m_roomEntrance.bMined=true;
        m_roomEntrance.bVisited=true;
        SeedRandomNumberGenerator(m_textFieldMineNumber.getText());
        m_nRooms=0;
        while (m_strRoom[m_nRooms] != null)
          ++m_nRooms;
        ShuffleRoomDescriptions();
        m_nTreasures=0;
        while (m_strTreasure[m_nTreasures] != null)
          ++m_nTreasures;
        m_treasure=new Treasure [m_nTreasures];
        for (int nTreasure=m_nTreasures; nTreasure-- > 0;)
          m_treasure[nTreasure]=new Treasure(m_strTreasure[nTreasure],
           m_strGuardian[nTreasure],m_strWeapon[nTreasure]);
        m_nChokepoints=0;
        m_roomWithName=new Room [m_nRooms+1];
        ExcavateMine();
        HideTreasuresAndWeapons();
        m_nMoves=0;
        m_room=m_roomEntrance;
        UpdateScreen(false);
        m_labelStatus.setVisible(true);
        m_textAreaStatus.setVisible(true);
        m_labelInventory.setVisible(true);
        m_textAreaInventory.setVisible(true);
        m_labelLocation.setVisible(true);
        m_textAreaLocation.setVisible(true);
        m_buttonWest.setVisible(true);
        m_buttonEast.setVisible(true);
        m_buttonNorth.setVisible(true);
        m_buttonSouth.setVisible(true);
        m_buttonUp.setVisible(true);
        m_buttonDown.setVisible(true);
        m_buttonCarry.setVisible(true);
        m_buttonDrop.setVisible(true);
        m_buttonWayOut.setVisible(true);
        m_buttonAbout.setVisible(true);
      }

    private void buttonWayOutClicked()
      {
        boolean bCarryingTreasure;
        int     nRoom;
        int     nTreasure;

        if (m_room == m_roomEntrance)
          m_textAreaLocation.setText(
           "     You\'re already at the entrance.\n");
        else
          {
            bCarryingTreasure=false;
            for (nTreasure=m_nTreasures;
             ((! bCarryingTreasure) && (nTreasure-- > 0));)
              bCarryingTreasure=(m_treasure[nTreasure].roomTreasure == null);
            if (bCarryingTreasure)
              {
                m_pathStackHead=null;
                m_sbWayOut=null;
                FindPathToEntrance(m_room,0);
                do
                  nRoom=RandomNumber()%m_nRooms;
                while (m_roomWithName[nRoom] == m_room);
                m_treasure[nTreasure].roomTreasure=m_roomWithName[nRoom];
                m_textAreaLocation.setText(
                 "     The pirate takes one of your treasures.  ");
                if (m_sbWayOut.length() == 1)
                  m_textAreaLocation.append(
                   "  As he leaves, he shouts the letter \"");
                else
                  m_textAreaLocation.append(
                   "  As he leaves, he shouts the letters \"");
                m_textAreaLocation.append(m_sbWayOut.toString());
                m_textAreaLocation.append("\".\n");
              }
            else
              m_textAreaLocation.setText("     Nothing happens.\n");
          }
        UpdateScreen(true);
    }

    private void buttonDropClicked()
      {
        for (int nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == null)
            m_treasure[nTreasure].roomTreasure=m_room;
        m_buttonDrop.setEnabled(false);
        UpdateScreen(false);
      }

    private void buttonCarryClicked()
      {
        int nTreasure;

        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          {
            if (m_treasure[nTreasure].roomWeapon == m_room)
              m_treasure[nTreasure].roomWeapon=null;
            if (m_treasure[nTreasure].roomTreasure == m_room)
              m_treasure[nTreasure].roomTreasure=null;
          }
        m_buttonCarry.setEnabled(false);
        UpdateScreen(false);
      }

    private void buttonUpClicked()
      {
        Move(4);
      }

    private void buttonEastClicked()
      {
        Move(2);
      }

    private void buttonNorthClicked()
      {
        Move(0);
      }

    private void buttonWestClicked()
      {
        Move(3);
      }

    private void buttonDownClicked()
      {
        Move(5);
      }

    private void buttonSouthClicked()
      {
        Move(1);
      }

    public void actionPerformed(
      java.awt.event.ActionEvent ev)
        {
          if (ev.getSource() instanceof java.awt.Button)
            {
              if (ev.getSource() == m_buttonAboutOk)
                buttonAboutOkClicked();
              else if (ev.getSource() == m_buttonMineNumberOk)
                buttonMineNumberOkClicked();
              else if (ev.getSource() == m_buttonAbout)
                buttonAboutClicked();
              else if (ev.getSource() == m_buttonWayOut)
                buttonWayOutClicked();
              else if (ev.getSource() == m_buttonDrop)
                buttonDropClicked();
              else if (ev.getSource() == m_buttonCarry)
                buttonCarryClicked();
              else if (ev.getSource() == m_buttonDown)
                buttonDownClicked();
              else if (ev.getSource() == m_buttonSouth)
                buttonSouthClicked();
              else if (ev.getSource() == m_buttonEast)
                buttonEastClicked();
              else if (ev.getSource() == m_buttonWest)
                buttonWestClicked();
              else if (ev.getSource() == m_buttonNorth)
                buttonNorthClicked();
              else
                {
                  if (ev.getSource() == m_buttonUp)
                    buttonUpClicked();
                }
              requestFocus();
            }
        }
  }
