window.onload = function () {
	_commandline = document.getElementById("commandline")
	_autocomplete = document.getElementById("autocomplete")
	_output = document.getElementById("output")
	_history = document.getElementById("history")
	
	boxes = document.getElementsByClassName("box")
	floats = document.getElementsByClassName("float")

	_commandline.onkeydown = Keypress
	document.onclick = ClickAnywhere
	document.body.addEventListener('touchstart', ClickAnywhere)
	document.onmousewheel = MouseWheel
	
	//_commandline.addEventListener('keydown', function () { Say("DING") } )
	//document.addEventListener('click', function () { Say("DING") } )
	
	//setInterval(Drift, 16)
	//setInterval(UpdateAutocomplete, 16)

	//window.addEventListener("resize", sizeOutput)
	window.addEventListener("beforeunload", Close)
	
	_commandline.focus()
	
	Save()
	
	Read()
	
	Main()
	
	Do ('debug|all', 'at the disco')
}

function Read() {
	try {
		code = document.getElementById("frmfile").contentWindow.document.body.childNodes[0].innerHTML
		fruits = htmlDecode(code).replace(/\t+\n/g, "\n").replace(/\n\n+/g, "\n\n").split("\n\n")
	} catch (e) {
		Say("Whoops! Could not load script file. If you are playing offline, you could try another browser (in particular, Chrome is grouchy.) If you are playing online, yell at me by email.", "box error")
	}
	
	for (var i = 0; i < fruits.length; i++) {
		//fruits[i] = fruits[i].replace(/\n/g, "</br>")
		
		var fruit = fruits[i]
		
		if (fruit[fruit.length - 1] == ":") {
			fruits.splice(i, 1)
			i--
			
			fruit = fruit.slice(0, -1).toLowerCase()
			
			if (labels[fruit]) Say("Duplicate label " + fruit, "box error")
			labels[fruit] = i
		}
		
		if (fruit.match(/->/)) {
			var split = fruit.split("->")
			
			if (split[0] == "\t") fruits[i] = "\tGo('" + split[1].trim() + "')"
			else {
				var s = "\tDo('" + split[0].trim() + "', '" + split[1].trim() + "')"
				//console.log (s)
				fruits[i] = s
			}
		} else if (fruit.match(/=>/)) {
			var split = fruit.split("=>")
			
			fruits[i] = "\tDo('" + split[0].trim() + "', function () {" + split[1].trim() + "})"
		}
	}
	
	labels.start = 0
}

function htmlDecode(input) {
	var e = document.createElement('div')
	e.innerHTML = input
	return e.childNodes[0].nodeValue
}

var saves = []

function Save(name) {
	if (name == undefined) name = "savestate"
	
	save = {}
	
	for (value in state) {
		save[value] = state[value]
	}
		
	saves[name] = save
}

function Load(name) {
	if (name == undefined) name = "savestate"
	
	save = saves[name]
	state = {}

	for (value in save) {
		state[value] = save[value]
	}
}

function Preload() {
	var i = 0
	
	while (i < 10 && state.head + i < fruits.length) {
		var imageFiles = fruits[state.head+i].match(/".*\.(jpe?g|png|gif)"/gi)
		if (imageFiles) {
			for(var j = 0; j < imageFiles.length; j++) {
				Cache(imageFiles[j].slice(1, -1))
			}
		}
/* 		var soundFiles = fruits[state.head+i].match(/".*\.(mp3|wav)"/gi)
 * 		if (soundFiles) {
 * 			for(var j = 0; j < soundFiles.length; j++) {
 * 				Audio(soundFiles[j].slice(1, -1))
 * 			}
 * 		}
 */
		i++
	}
}

function Cache (source) {
	if (backgrounds[source]) return
	
	var image = document.createElement("img")
	image.src = source
	image.style.position = "fixed"
	image.style.left = "99.99%"
	image.style.zIndex = "-100"
	
	backgrounds[source] = image
	
	document.body.appendChild(image)
}

function ScreenHeight () {
	 return Math.max (document.body.clientHeight, document.documentElement.clientHeight)
}

function ScreenWidth () {
	 return Math.max (document.body.clientWidth, document.documentElement.clientWidth)
}

function Close (e) {

}