\ newloc.f for advtr.f  Leo Wong 12 June 02003 fyj +
(( Figure out the new location.

Given the current location in "loc", and a motion verb number in "k",
put the new location in "newloc".  The current loc is save in "oldloc"
in case the adventurer wants to retreat.  The current oldloc is saved
in oldloc2, in case he dies.  (If he does, newloc will be limbo, and
oldloc will be what killed him, so oldloc2 -- the last place is was safe -- is needed.) ))

\ Special motions come here.  Labelling convention: statement numbers
\ nnnxx (xx=00-99( are used for special case number nnn (nnn=301-500). 

\ Travel 301.  Plover-alcove passage.  Can carry only emerald.  Note:
\ Travel table must include "useless" entries going through pasage,
\ which can never be used for actual motion, but can be spotted by
\ "go back".
: newloc30100
   \ ." newloc30100 "
   199 loc - TO newloc
   holdng 0= holdng 1 = emerald toting? AND OR not
   IF loc TO newloc  117 rspeak THEN  ;

\ Travel 302.  Plover transport.  Drop the emerald ( only use special
\ travel if toting it), so the adventurer is forced to use plover-
\ passage to get it out.  Having dropped it, go back and pretend he
\ wasn't carrying it after all.
: newloc30200
   \ ." newloc30200 "
   emerald loc drop-object newloc12 ;

(( Travel 303.  Troll bridge.  Must be done only as special motion so
that dwarfs won't wander across and encounter the bear.  (They won't
follow the player there becasue that region is forbidden to the
pirate).  If prop(troll)=1, he's crossed since paying, so step out and
block him.  (Standard travel entries check for prop(troll)=0.  Special
stuff for bear. ))

: newloc30310
   \ ." newloc30310 "
   troll plac @ troll fixd @ + loc - TO newloc
   troll prop @ 0= IF 1 troll prop ! THEN
   bear toting? 
   IF 162 rspeak
      1 chasm prop !
      2 troll prop !
      bear newloc drop-object
      -1 bear fixed !
      3 bear prop !
      spice prop @ 0< IF tally2 1+ TO tally2 THEN
      newloc TO oldloc2
      dead THEN ;

: newloc30300
   \ ." newloc30300 "
   troll prop @ 1 <> IF newloc30310 EXIT THEN
   troll 1 pspeak
   0 troll prop !
   troll2 0 move-object
   troll2 100 + 0 move-object
   troll troll plac @ move-object
   troll 100 + troll fixd @ move-object
   chasm juggle-object
   loc to newloc ;

3 20 vet (newloc3000) :: ', newloc30100 newloc30200 newloc30300 ;
: newloc3000
   \ ." newloc3000 "
   newloc 300 - TO newloc  newloc (newloc3000) ;

\ Handle "go back".  Look for verb which goes from loc to oldloc, or to
\ oldloc2 if oldloc has force-motion.  k2 saves entry -> forced loc ->
\ previous loc.
0 VALUE k2
0 VALUE ll
: newloc25 
   \ ." newloc25 "
   kk travel @ ABS 1000 MOD TO k
   loc key @ TO kk
   newloc9 ;

: newloc23
   \ ." newloc23 "
   k2 TO kk
   kk IF newloc25 EXIT THEN
   140 rspeak ;

: newloc21
   \ ." newloc21 "
   BEGIN
      \ ." innewloc21 "
      kk travel @ ABS 1000 / 1000 MOD TO ll
      ll k = IF newloc25 EXIT THEN
      ll 300 > not
      IF ll key @ TO jj
        ll forced? jj travel @ ABS 1000 / 1000 mod k = AND
        IF kk TO k2 THEN THEN
        kk travel @ 0< IF newloc23 EXIT THEN  \ 23
        kk 1+ TO kk
   AGAIN ;

: "back" \  20
   \ ." back "
   oldloc TO k
   k forced? IF oldloc2 TO k THEN
   oldloc TO oldloc2
   loc TO oldloc
   0 TO k2
   k loc <> IF newloc21
            ELSE 91 rspeak THEN ;

: "not-applicable" \ 50
  \ ." not applicable "
  \ Non-applicable motion.  Various messages depending on the word
  \ given.
                        k 17 = IF 80 ELSE
             k 62 =  k 65 = OR IF 42 ELSE
 verb find =  verb invent = OR IF 59 ELSE
             k 11 =  k 19 = OR IF 11 ELSE
   k 7 =  K 36 = OR  k 37 = OR IF 10 ELSE
             k 29 =  k 30 = OR IF  9 ELSE
            k 42 >  k 51 < AND IF  9 ELSE
                                  12 
       THEN THEN THEN THEN THEN THEN THEN rspeak ;

: "cave" \ 40
  \ ." cave "
   \ Cave.  Different messages depending on whether above ground
   loc 8 < IF 57 ELSE 58 then rspeak ;

: "look" \ 30
  \ ." look "
   \ Look.  Can't give more detail.  Pretend it wasn't dark (though it
   \ may "now" be dark ) se he won't fall into a pit while staring at
   \ the gloom.
   detail 3 < IF 15 rspeak THEN
   detail 1+ TO detail  FALSE TO wzdark  0 loc abb ! ;

: newloc16
   ll 1000 MOD TO newloc 
   db? IF ." newloc16 " ." loc*" loc . ." newloc=" newloc .
          ." kk=" kk . THEN
   newloc 300 > not IF EXIT THEN
   newloc 500 > not IF newloc3000 EXIT THEN
   newloc 500 - rspeak 
   loc TO newloc  ;

: newloc14
   \ ." newloc14 "
   newloc  newloc pct? not AND IF newloc12 ELSE newloc16 THEN ;

: newloc13 
   \ ." newloc13 "
                           newloc 101 < IF newloc14 ELSE
   k toting?  newloc 200 > k at? AND OR IF newloc16 ELSE
                                           newloc12 THEN THEN ;

defer newloc11
:NONAME  \ 12
   \ ." newloc12 "
   BEGIN
      \ ." innewloc12 "
      kk travel @ 0< IF 25 bug THEN
      kk 1+ TO kk
      kk travel @ ABS 1000 / TO newloc
      newloc ll <> UNTIL
      newloc TO ll
      newloc11 
     ; IS newloc12

:NONAME  \ 11
  \ ." newloc11 "
   BEGIN
   \ ." innewloc11 "
      ll 1000 / TO newloc
      newloc 100 MOD TO k
      newloc 301 < IF newloc13 EXIT THEN
      k prop @ newloc 100 / 3 - <> IF newloc16 EXIT THEN
      newloc12
      newloc TO ll
      AGAIN 
; IS newloc11

:NONAME \ 9
  \ ." newloc9 "
  BEGIN
     \ ." innewloc9 "
     kk travel @ ABS TO ll
     ll 1000 MOD DUP 1 = SWAP k = OR not WHILE
     kk travel @ 0< IF "not-applicable" EXIT THEN
     kk 1+ TO kk REPEAT
     ll 1000 / TO ll \ 10
     newloc11
   ; IS newloc9

:NONAME \ 8
   \ ." newloc8 "
   loc  DUP TO newloc  key @ TO kk
   kk 0= IF 26 bug THEN
   k null = IF EXIT THEN
   k back = IF "back" EXIT THEN
   k look = IF "look" EXIT THEN
   k cave = IF "cave" EXIT THEN
   oldloc TO oldloc2
   loc TO oldloc 
   newloc9 ; IS newloc8

 