#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


riverDaemon : SimpleDaemonEvent
	startDaemon() {
		if(allowedToStart) {
			if(daemon==nil) {
//				daemon = new PromptDaemon(self, &doStuff);
				daemon = new Daemon(self, &doStuff, 1);
				daemon.eventOrder = 75;
			}
		}
	}
	
	doStuff() {
		local canSeeTurtleBefore = gPlayerChar.canSee(turtle);
		local turtleLocationBefore = turtle.location;
		local canSeeLogBefore = gPlayerChar.canSee(log);
		local logLocationBefore = log.location;


		local turtleAndLogAreSeparateBefore = (turtle.location!=log.location);
		turtle.doStuff();
		local turtleAndLogMeet = (turtle.location==log.location);
		log.doStuff();
		local turtleAndLogAreSeparateAfter = (turtle.location!=log.location);
		local turtleAndLogPassEachOtherby = turtleAndLogAreSeparateBefore && turtleAndLogMeet && turtleAndLogAreSeparateAfter;
		
		
		local canSeeTurtleAfter = gPlayerChar.canSee(turtle);
		local turtleLocationAfter = turtle.location;
		local canSeeLogAfter = gPlayerChar.canSee(log);
		local logLocationAfter = log.location;
		
				
		if(canSeeTurtleBefore!=canSeeTurtleAfter) {
			if(canSeeTurtleAfter)
				callWithSenseContext(gPlayerChar,sight,{:"\bA turtle swims into view from the east. "});
			else
				callWithSenseContext(gPlayerChar,sight,{:"\bA turtle swims out of view to the west. "});
		}
		
		if(canSeeLogBefore!=canSeeLogAfter) {
			if(canSeeLogAfter)
				callWithSenseContext(gPlayerChar,sight,{:"\bA log floats into view from the west. "});
			else
				callWithSenseContext(gPlayerChar,sight,{:"\bA log floats out of view to the east. "});
		}
		
		if(turtleAndLogPassEachOtherby) {
			if(gPlayerChar.isIn(log)) {
				callWithSenseContext(gPlayerChar,sight,{:"\bA turtle swims into view from the east, passes quickly by you, and then swims out of sight to the west. "});
			} else if(gPlayerChar.isIn(turtle)) {
				callWithSenseContext(gPlayerChar,sight,{:"\bA log floats into view from the west, passes by quickly by you, and floats out of sight to the east. "});
			}
		}
		
		if(gPlayerChar.isIn(log)) {
			if(logLocationBefore!=logLocationAfter)
				callWithSenseContext(gPlayerChar,sight,{:"\bThe log floats east. "});
//			nestedAction(Look);
		} else if(gPlayerChar.isIn(turtle)) {
			if(turtleLocationBefore!=turtleLocationAfter)
				callWithSenseContext(gPlayerChar,sight,{:"\bThe turtle swims west. "});
//			nestedAction(Look);
		}
	}
;

log : FroggerRoomSet,RoomAutoConnector,Platform 'fallen log/tree' 'log'
	"The log appears to be a fallen tree. It is rapidly floating east along the river. "
	
	location = froggerRiver1C
//	location = froggerRiverbankC

	sightSize = large
	
	specialDesc {
		if(gPlayerChar.isIn(location))
			"You are riding a log as it floats rapidly eastward along the river. ";
		else if(gPlayerChar.isIn(location.secretNorth))
			"A log is floating rapidly eastward along in the river to the south of you. ";
		else if(gPlayerChar.isIn(location.secretSouth))
			"A log is floating rapidly eastward along in the river to the north of you. ";
		else
			"A log is floating rapidly eastward along in the river. ";
	}
	
	daemonDelay = 3
	daemonCountdown = daemonDelay
//	locationLastTurn = location
	
//	willMoveNext() {
//		return daemonCountdown<=1;
//	}
	// This returns true if it moved last turn.
//	justMoved() {
//		return location!=locationLastTurn;
//	}
	
	doStuff() {
		--daemonCountdown;
		
//		if(!gPlayerChar.isIn(self))
//			callWithSenseContext(self,sight,{:"A log floats out of view to the east. "});
//		else
//			callWithSenseContext(self,sight,{:"The log floats east. "});
		
		if(daemonCountdown<=0) {
			moveIntoForTravel(location.secretEast);
			daemonCountdown = daemonDelay;
		}
		
//		if(!gPlayerChar.isIn(self))
//			callWithSenseContext(self,sight,{:"A log floats into view from the west. "});
	}

	canObjReachSelf(obj) {return true;}
	canReachSelfFromInside(obj) {return true;}
	

	dobjFor(GetOutOf) {
		verify() {
			illogical('It would not be wise to try swimming in the river. ');
		}
	}
	
	dobjFor(JumpTo) {
		verify() {
			if(gDobj==gActor.roomLocation)
				illogical('You are already on it. ');
		}
		check() {}
		action() {
			"You crouch down and spring towards the log with all of your strength.
			You sail through the air with grace until you land on the log with your
			legs on either side of it.
			OUCH! After a few moments you recover your ability to think. ";
			nestedAction(TravelVia,self);
//			gPlayerChar.posture = sitting;
		}
	}

//	checkMoveViaPath (obj, dest, op) {
//		return checkStatusSuccess;
//	}
//	checkMovingActorInto
;

turtle : FroggerRoomSet,RoomAutoConnector,Platform 'turtle' 'turtle'
	"The only part of the turtle that is visible is its shell. It's quite large
	and seems content to continually swim westward. "
	
	location = froggerRiver2D
	
	sightSize = large
	
	specialDesc {
		if(gPlayerChar.isIn(location))
			"You are riding on a turtle as it swims lazily westward. ";
		else if(gPlayerChar.isIn(location.secretNorth))
			"A turtle swims lazily westward along the river to the south of you. ";
		else if(gPlayerChar.isIn(location.secretSouth))
			"A turtle swims lazily westward along the river to the north of you. ";
		else
			"A turtle swims lazily westward along the river. ";
	}
	
	daemonDelay = 5
	daemonCountdown = daemonDelay
	
	doStuff() {
		--daemonCountdown;
		
//		if(!gPlayerChar.isIn(self))
//			callWithSenseContext(self,sight,{:"A turtle swims out of view to the west. "});
//		else
//			callWithSenseContext(self,sight,{:"The turtle swims west. "});
		
//		travelerTravelTo(location.secretWest, location.secretWest, location.secretEast);
//		travelerTravelTo
		if(daemonCountdown<=0) {
			moveIntoForTravel(location.secretWest);
			daemonCountdown = daemonDelay;
		}
		
//		if(!gPlayerChar.isIn(self))
//			callWithSenseContext(self,sight,{:"A turtle swims into view from the east. "});
	}

	
	canObjReachSelf(obj) {return true;}
	canReachSelfFromInside(obj) {return true;}

	dobjFor(GetOutOf) {
		verify() {
			illogical('It would not be wise to try swimming in the river. ');
		}
	}
	
	dobjFor(JumpTo) {
		verify() {
			if(gDobj==gActor.roomLocation)
				illogical('You are already on it. ');
		}
		check() {}
		action() {
			"You crouch down and spring towards the turtle with all of your strength.
			You sail through the air and land neatly on the turtle. ";
			
			nestedAction(TravelVia,self);
			
//			gPlayerChar.posture = lying;
		}
	}
;
+ Decoration '(turtle) shell' 'shell'
	"It's quite large and appears to be suitable for standing on. "
;



class FroggerExitRow : FroggerRoomSet,OutdoorRoom
	desc = "This is the other side of the river. The only exit is south back over the river.
	To the north is the bottom of a tall cliff that stretches far into the sky.
	Directly to the north is a small square hole at the base of the cliff. Perhaps
	the mice around here have superior engineering ability which allows them to
	build perfectly square holes? "
//	south = froggerRiverbankC

	dobjFor(JumpTo) {
		verify() {
			if(gDobj==gActor.roomLocation)
				illogical('You are already on it. ');
		}
		check() {}
		action() {
			"You crouch down and spring towards the riverbank with all of your strength.
			You sail through the air and this time manage to land on your feet. ";

			nestedAction(TravelVia,self);
		}
	}
;
+ Decoration 'base tall cliff' 'cliff'
	"This is a tall sheer cliff that stretches overhead and out of site. There's a small hole
	in the base of the cliff. "
;

class FrogCliffHole : Container,Fixture 'perfectly small square mouse hole*holes' 'hole'
	"It's a small square mouse-sized hole in the base of the cliff. "
	
	dobjFor(LookIn) {
		action() {
			"The hole doesn't go very deep. It's just a cubical hole in the base of
			the cliff. ";
		}
	}
	
	iobjFor(PutIn) {
		action() {
			if(gDobj==frog) {
				froggerMachine.winGame();
				nestedAction(StopPlaying);
			}
			inherited;
		}
	}
;


froggerExitRowB : FroggerExitRow
	name = 'Riverside Across River West'
	vocabWords = '(west) (across) bank/riverbank/riverside'
	west = froggerExitRowD
	east = froggerExitRowC
;
	+ frogCliffHoleB : FrogCliffHole;
froggerExitRowC : FroggerExitRow
	name = 'Riverside Across River'
	vocabWords = '(across) bank/riverbank/riverside'
	west = froggerExitRowB
	east = froggerExitRowD
;
	+ frogCliffHoleC : FrogCliffHole;
froggerExitRowD : FroggerExitRow
	name = 'Riverside Across River East'
	vocabWords = '(east) (across) bank/riverbank/riverside'
	west = froggerExitRowC
	east = froggerExitRowB
;
	+ frogCliffHoleD : FrogCliffHole;



class FroggerRiver : Floorless,FroggerRoomSet,OutdoorRoom

//	vocabWords = 'hriver'

	dobjFor(SwimIn) {
		verify() {}
		check() {}
		action() {
			"This would not be a safe river to take a swim in. ";
		}
	}
/*	
	iobjFor(Drop) {
		verify() {}
		check() {}
		action() {
			"DROPPED\n";
		}
	}
	iobjFor(PutIn) {
		verify() {}
		check() {}
		action() {
			"DROPPED\n";
		}
	}
	iobjFor(ThrowAt) {
		verify() {}
		check() {}
		action() {
			"DROPPED\n";
		}
	}
*/	
/*	
	roomBeforeAction() {
		if(gActionIs(JumpTo)) {
"JUMPING TO\n";		
			gPlayerChar.moveIntoForTravel(gDobj);
		}
//		 else if(gActionIs(ThrowAt)) {
//		}
	}
*/

    checkMovingActorInto(allowImplicit) {
//		"checkMovingActorInto\n";
		if(gActionIs(JumpTo)) {
			return checkStatusSuccess;
		} else {
			OutdoorRoom.checkMovingActorInto(allowImplicit);
//			return new CheckStatusFailure(cannotTouchThroughMsg, obj, self);
			exit;
		}
	}

//	roomAfterAction() {
//		if(gActionIs(TravelVia)) {
//			nestedAction(Look);
//		}
//	}	


	receiveDrop(projectile, desc) {
		if(projectile.ofKind(Pebble)) {
			"{The dobj/he} sails out a little ways then lands in the water and sinks out of sight. ";
			obj.moveInto(nil);
		} else {
			"{The dobj/he} sails out a little ways then lands in the water and, lucky for you, floats to the riverbank. ";
			if(!secretSouth.ofKind(FroggerRiver)) {
				projectile.moveInto(secretSouth);
			} else {
				projectile.moveInto(secretNorth);
			}
		}
	}
;
/*
MultiInstance
	initialLocationClass = FroggerRiver
	instanceObject : Decoration {
			'water/river' 'river'
			"The water is deep and moving fast here. "
			distantDesc = desc
		}
;
*/

froggerRiver1B : FroggerRiver
	desc = "The river is madly rushing eastward and taking the log (and you) with it.
		To the south is the riverbank and to the north is more river. "
	name = 'river'
	
	secretWest = froggerRiver1D
	secretEast = froggerRiver1C
	secretSouth = froggerRiverbankB
	secretNorth = froggerRiver2B
;
froggerRiver1C : FroggerRiver
	desc = "The river is madly rushing eastward and taking the log (and you) with it.
		To the south is the riverbank and to the north is more river. "
	name = 'river'
	
	secretWest = froggerRiver1B
	secretEast = froggerRiver1D
	secretSouth = froggerRiverbankC
	secretNorth = froggerRiver2C
;
froggerRiver1D : FroggerRiver
	desc = "The river is madly rushing eastward and taking the log (and you) with it.
		To the south is the riverbank and to the north is more river. "
	name = 'river'
	
	secretWest = froggerRiver1C
	secretEast = froggerRiver1B
	secretSouth = froggerRiverbankD
	secretNorth = froggerRiver2D
;
froggerRiver2B : FroggerRiver
	desc = "The river is madly rushing eastward, but the turtle is swimming against the
		current and taking you slowly westward. To the north is the riverbank and
		to the south is more river. "
	name = 'river'
	
	secretWest = froggerRiver2D
	secretEast = froggerRiver2C
	secretSouth = froggerRiver1B
	secretNorth = froggerExitRowB
;
froggerRiver2C : FroggerRiver
	desc = "The river is madly rushing eastward, but the turtle is swimming against the
		current and taking you slowly westward. To the north is the riverbank and
		to the south is more river. "
	name = 'river'
	
	secretWest = froggerRiver2B
	secretEast = froggerRiver2D
	secretSouth = froggerRiver1C
	secretNorth = froggerExitRowC
;
froggerRiver2D : FroggerRiver
	desc = "The river is madly rushing eastward, but the turtle is swimming against the
		current and taking you slowly westward. To the north is the riverbank and
		to the south is more river. "
	name = 'river'
	
	secretWest = froggerRiver2C
	secretEast = froggerRiver2B
	secretSouth = froggerRiver1D
	secretNorth = froggerExitRowD
;




RoomPairSenseConnector template [locationList];
//RoomPairSenseConnector [froggerRiverbankB,froggerRiver1B,froggerRiver2B,froggerExitRowB];
//RoomPairSenseConnector [froggerRiverbankC,froggerRiver1C,froggerRiver2C,froggerExitRowC];
//RoomPairSenseConnector [froggerRiverbankD,froggerRiver1D,froggerRiver2D,froggerExitRowD];


RiverRoomPairSenseConnector [froggerRiverbankB,froggerRiver1B];
RiverRoomPairSenseConnector [froggerRiverbankC,froggerRiver1C];
RiverRoomPairSenseConnector [froggerRiverbankD,froggerRiver1D];

RiverRoomPairSenseConnector [froggerRiver1B,froggerRiver2B];
RiverRoomPairSenseConnector [froggerRiver1C,froggerRiver2C];
RiverRoomPairSenseConnector [froggerRiver1D,froggerRiver2D];

RiverRoomPairSenseConnector [froggerRiver2B,froggerExitRowB];
RiverRoomPairSenseConnector [froggerRiver2C,froggerExitRowC];
RiverRoomPairSenseConnector [froggerRiver2D,froggerExitRowD];


class RiverRoomPairSenseConnector : SenseConnector, Intangible
	name = 'river'

	transSensingThru(sense) {
 		if(gActionIs(JumpTo)) {
			return transparent;
		} else {
			return distant;
		}
	}
	
	locationList = nil
	
	
	iobjFor(ThrowAt) {
		verify() {}
		check() {
			"There's really no reason to throw things in or across the river. ";
			exit;
		}
	}
	

//addDirectConnections (tab)   OVERRIDDEN 	sense.t[450]
//    Add the direct containment connections for this item to a lookup table. * Since we provide a sense connection among all of our containers, add each of our containers to the list.
/*
	checkMoveThrough (obj, dest) {
		"checkMoveThrough\n";
		return checkStatusSuccess;
	}
//    Check moving an object through me. This is called when we try to move an object from one of our containers to another of our containers through me. By default, we don't allow it.
*/
	checkMoveViaPath (obj, dest, op) {
//		"checkMoveViaPath\n";
 		if(gActionIs(ThrowAt)) {
			return checkStatusSuccess;
//			return new CheckStatusFailure('You cannot throw. ', obj, self);
		} else {
			return SenseConnector.checkMoveViaPath(obj,dest,op);
		}
	}
/*
	checkTouchThrough (obj, dest) {
		"checkTouchThrough\n";
		return checkStatusSuccess;
	}
//    Check touching an object through me. This is called when an actor tries to reach from one of my containers through me into another of my containers. By default, we don't allow it.
*/

	checkTouchViaPath(obj, dest, op) {
 		if(gActionIs(JumpTo)) {
//"checkTouchViaPath\n";
			return checkStatusSuccess;
		} else {
			return SenseConnector.checkTouchViaPath(obj,dest,op);
		}
	}

//	canThrowViaPath(obj, dest, op) {
//		return new CheckStatusFailure('You cannot throw. ', obj, self);
//	}

//sensePathFromWithout (fromParent, sense, trans, obs, fill)   	sense.t[534]
//    Build a sense path from a container to me

//sensePathToLoc (sense, trans, obs, fill)   OVERRIDDEN 	sense.t[483]
;
