#charset "us-ascii"
#include <advlite.h>

tSadness: PDtopic 'sadness; sad; mood burden problem'
    familiar = true
;

archibald: Actor 'sad man; pale mournful depressed art glum; dealer connoisseur shopkeeper; him' @galleryChair
    desc() {
        if (hasBeenNamed) "Archibald Snead";
        else if (curState == archibaldSad) "The mournful-looking man";
        else "The shopkeeper";
        " is pale and slightly
        built. He has wispy light-brown hair and the beginnings of
        a receding hairline. He's dressed in a well-tailored suit. ";
    }
    kissResponseMsg = 'He might misunderstand your intentions. '
    cannotEatMsg = 'Cannibalism? Really? '
    attackResponseMsg = 'He looks so frail you might actually be able to injure him. Better not. '
    cannotTakeMsg = 'You\'ve never properly learned the fireman\'s carry. '
    cannotTakeFromActorMsg (obj) {
        if (gDobj == brownSuit) return 'The brown suit wouldn\'t fit you. ';
        else return '{The archibald} won\'t let you have {the dobj}. ';
    }
    globalParamName = 'archibald'
    hasBeenNamed = nil
    hasSeenFish = nil
    makeProper() {
        if (!happy)
            replaceVocab ('Archibald Snead; (art) sad pale mournful depressed glum; man archie dealer connoisseur shopkeeper; him');
        else
            replaceVocab ('Archibald Snead; (art) cheerful pale happy; man archie dealer connoisseur shopkeeper; him');
        proper = true;
        hasBeenNamed = true;
    }
    happy = nil
    makeHappy() {
        "{The archibald} gasps. <q>My goodness! <<if (hasSeenFish)>>And you mean
        to leave it here?<<end>> How wonderful! A singing fish!
        I've dreamt of such a thing, but I never hoped to see one. It will be 
        the <i>piece de resistance</i> of my gallery. Oh, I'm so very happy!
        You've entirely restored my faith in humanity. If you\'d like me to
        show you my collection of paintings, you need only ask.</q> ";
        if (!hasBeenNamed)
            replaceVocab('art dealer; happy pale cheerful; man archie dealer connoisseur shopkeeper; him');
        archibaldAch.awardPointsOnce();
        setState (archibaldCheerful);
        happy = true;
    }
;

// TO DO: Archibald needs to not let you into the studio until he's happy.

//--------------------------------------------------------------------------
// sad
//--------------------------------------------------------------------------

+ archibaldSad: ActorState
    // Note: This specialDesc needs to switch from "A" to "The" the second time this description appears.
    specialDesc = "<<one of>>{A archibald}<<or>>{The archibald}<<stopping>> is sitting slumped in the straight-backed chair, staring glumly at the floor. "
    stateDesc = "At the moment, he looks like he's about to cry. "
    isInitState = true
;

++ DefaultAnyTopic, ShuffledEventList
    [
        '<q>What\'s the use?</q> he murmurs. ',
        
        '<q>Does it matter?</q> he says with a shrug. ',
        
        '<q>As to that,</q> he replies, <q>I can\'t say I really care. I\'m very sorry.</q> ',
        
        '{The archibald} only sighs in response. '
    ]
;

++ AskTopic, StopEventList @tSadness
    [
        '<q>You seem awfully downcast,</q> you say.
        <.p><q>Yes,</q> he replies. <q>Yes, that\'s true.</q> 
        <.p><q>Can you tell me why?</q>
        <.p><q>Life,</q> he says. <q>Every bit of it. If only there were something in my life
        --- something delightful here in the shop, perhaps --- that had the power to cheer me up!</q> ',
        
        'He has already told you he wishes there were something delightful
        that had the power to cheer him up. '
    ]
;

++ AskTopic, StopEventList @archibald
    [
        '<q>I\'m the curator of this dreary and insignificant little exhibit. A shopkeeper, no more than that. My
        name <<archibald.makeProper>>is Archibald Snead. Not that that matters to anyone.</q> ',
        
        '<q>You seem not very happy,</q> you venture. <q>I hope I\'m not being too personal.</q><.p>
        <q>Not at all,</q> he replies. <q>Why should I mind? It doesn\'t matter. Nothing does,
        in the end. You\'re quite right, of course. From time to time these melancholy moods
        overtake me. It seems I\'m able to do nothing to banish the mood. But perhaps you ...
        no, I shouldn\'t even ask. Please, pretend I said nothing.</q> ',
        
        '<q>Oh, I don\'t matter,</q> he says. <q>Pay no attention to me.</q> ',
        
        'In response to your continued curiosity, Archibald only sighs and says nothing. He has
        made it clear that he\'s depressed, and he seems to have hinted that you might be able
        somehow to cheer him up. Beyond that, he seems to have little personal information to
        impart. '
    ]
;

++ HelloTopic, StopEventList
    [
        '<q>Hello,</q> you say. <q>Are you the shopkeeper?</q><.p>
        He sighs deeply. <q>I bear that burden, yes,</q> he replies. ',
        
        '<q>Hello again,</q> you say to the shopkeeper.<.p>
        <q>Oh, are you back?</q> he says. <q>Were you gone? I\'m afraid I didn\'t notice.
        Dreadfully sorry.</q> '
    ]
;

++ GiveShowTopic @bunchOfMarigolds
    "<q>Oh, those are pretty,</q> he says with a sigh. <q>But all too swiftly they would wither and
    die. Please --- you must keep them.</q> "
;

// Due to the nature of give/show, this will only happen if you're holding the helmet,
// not if you've already put the fish in its new home.
++ GiveShowTopic @singingFish
    topicResponse () {
        "<q>I found this fish downstairs in the pet store,</q> you say, holding out the helmet
        so he can inspect its contents. ";
        if (singingFish.singDaemonID) {
            archibald.hasSeenFish = true;
            "<q>I think it's a singing fish.</q><.p>
            <q>A singing fish?</q> His eyebrows rise. But then he shrugs and looks away. <q>You'll
            be taking it away again, I'm sure, not leaving it here.
            Life's pleasures are all too fleeting.</q> ";
        }
        else "<.p><q>Really,</q> he says tonelessly. <q>A fish. I hope you'll forgive me
            lack of interest.</q> ";
    }
;

++ AskTopic @paintings
    "<q>Those daubs?</q> He shrugs. <q>Trivia. Kitsch. I really don't see why anybody would be
    interested in them. The bartender in the pub across the way was quite enthusiastic about
    the ... oh, what does it matter? You don't care about that.</q> "
;

++ AskTellTopic [tSamantha, tPromDress]
        "<q>I came here this afternoon to get a dress for my daughter for the senior prom,</q>
        you say.<.p>
        <q>To see the young, so carefree, dancing so blissfully unaware,</q> he says. <q>It breaks my heart.</q> "
;

++ AskTellTopic @masterKey
    "<q>Do you know if that key in the Security Office opens all of the shop doors?</q> you ask.
    <.p><q>I\'m sure it does,</q> the art dealer replies. <q>But what does it matter? Open, closed,
    ultimately it\'s all the same, isn\'t it?</q> "
;
+++ AltTopic
    "Maybe you shouldn\'t be asking people questions about that. You wouldn't want them to get suspicious. "
    isActive = (masterKey.moved)
;


//----------------------------------------------------------------------------
// archibaldCheerful
//----------------------------------------------------------------------------

+ archibaldCheerful: ActorState
    specialDesc = "{A archibald} is gazing around his gallery with muted pride. "
    stateDesc = "He's gazing contentedly around his art gallery. "
;

++ AskTopic, StopEventList @archibald
    [
        '<q>I have the honor to be the proprietor of this unpretentious but delightful gallery,</q> he
        replies promptly. <q>Did I tell you my name is Archibald Snead? <<archibald.makeProper()>>
        Yes, I\'m fairly sure I did. If I may be of assistance in any way, you need only ask.</q> ',
        
        '<q>Oh, I\'m not a very interesting person. May I show you the paintings? If you have any
        questions about them, any questions at all, you must not hesitate to ask.</q> '
    ]
;

++ AskTellTopic @singingFish
    "<q>Do you like the fish?</q> you ask.<.p>
    <q>Like it? I could listen to it for hours! If there's anything I can do in return, anything
    at all.... Would you like to ask me about the paintings in the gallery? You have only to ask,
    and I'll be happy to give you the complete tour.</q> "
;

++ AskTopic, StopEventList @paintings
    [
        '<<paintings.giveDetails()>><q>Do you care at all for my little collection? I\'m rather 
        proud of it. Let me show you.</q> He
        leads you slowly around the room, indicating one painting after another. In short order you
        have gazed upon realistic renderings of a vineyard, a sailing ship, a circus clown,
        a wolf baying at the moon, a golden sunset, a race car, a vase filled with flowers, a
        waterfall, a woman sitting on a bench, some ice skaters on a frozen pond, a butterfly,
        and a child reaching out to catch a ball.<.p>
        
        {The archibald} pauses before the painting of the ice skaters. <q>This one,</q> he mentions,
        <q>is a special favorite of Stephen. Have you met Steve? He\'s the bartender at the charming
        little Irish pub across the way. He said the ice skaters remind him of something in his
        childhood. He wanted to buy it, but it\'s only here on loan, you see, from a private
        collection. It\'s not for sale. He was so <i>very</i> disappointed.</q> ',
        
        '<q>Oh, I\'ve already shown you around. If you care to continue looking at the paintings,
        please feel free to do so.</q> ',
        
        '{The archibald} has already given you a tour of the paintings. You recall vaguely that he
        mentioned something about the bartender being fond of the painting of the ice skaters. '
    ]
;

++ AskTellTopic @tPromDress
        "<q>I don\'t know if I told you,</q> you say. <q>I came here this afternoon hoping to be
        able to buy a dress for my daughter, for her senior prom.</q><.p>
        <q>How marvelous!</q> he says. <q>To see the young dancing, so blissful, so carefree,
        it warms my heart! I expect you\'ll be able to manage to acquire the gown somehow, even 
        though the shops are closed. But I really wouldn\'t know how to advise you.</q> "
;

