/* Perdition's Flames - Heaven */
// copyright (c) 1993, 2002 by Michael J. Roberts.

towerRoof: room
    sdesc = "Roof of Tower"
    north = elevator
    south = gatesOfHeaven
    east = burgerLord
    west = giftShop
    ldesc = "You're on the roof of the tower.  You can walk into
        the clouds to the south.  To the east is a fast-food
        restaurant called \"Burger Lord\", and to the west is
        the Heavenly Gift Shop.
        The elevator lies to the north; the doors are open."
;

giftHalos: fixeditem
    sdesc = "halo" 
    noun = 'halo' 'halos' 'haloes'
    location = giftShop
    ldesc = "They're shining rings of light.  You can't seem
       to find one in your size." 
    verDoTake(actor) =
    {
        "You try a few on, but you can't find one in your hat size.";
    }
;

giftWings:  fixeditem
    sdesc = "angel wing"
    noun = 'wing' 'wings'
    adjective = 'angel'
    location = giftShop
    ldesc = "They're large, white, feathery wings. You can't seem
        to find any in your wing size."
    verDoTake(actor) =
    {
        "You try a few on, but you can't find one in your wing size.";
    }
;

giftHarps: fixeditem
    sdesc = "harp"
    noun = 'harp' 'harps'
    adjective = 'golden'
    location = giftShop
    ldesc = "They're all very nice golden harps."
    verDoTake(actor) =
    {
        "You never did keep up with those harp lessons from your
        childhood; without being able to play angelic music, you
        really don't have much use for a harp.";
    }
    verDoPlay(actor) = {}
    doPlay(actor) =
    {
        "You can only manage a terrible squealing noise.  Not
        very angelic, but then again, we all know where you
        ended up.";
    }
;

giftShelves: fixeditem
    sdesc = "shelf"
    noun = 'shelves' 'shelf'
    location = giftShop
    ldesc = "The shelves are well-stocked with novelty items."
;

giftShop: room
    sdesc = "Gift Shop"
    ldesc = "You're in a small gift shop.  The shelves are
        filled with all sorts of novelty items:  halos, angel wings,
        harps.
        The exit is to the east."
    east = towerRoof
;

burgerCounter: fixeditem, surface
    sdesc = "counter"
    noun = 'counter'
    location = burgerLord
;

burgerTable: fixeditem, surface
    sdesc = "table"
    noun = 'table' 'tables'
    location = burgerLord
;

burgerChair: chairitem
    sdesc = "chair"
    noun = 'chair' 'chairs'
    location = burgerLord
;

burgerPoster: readable, fixeditem
    sdesc = "poster"
    noun = 'poster'
    location = burgerLord
    ldesc = "The poster has a picture of a hamburger, fries,
        soda, and a white ivory carving of a rowboat.
        \"Buy a RaptureMeal, and get this amulet of protection
        against nausea FREE!\""
;

burgerMenu: readable, fixeditem
    sdesc = "menu"
    noun = 'menu'
    location = burgerLord
    ldesc = "The menu shows a large variety of food, none of
        which looks very appetizing to you."
;

fries: fooditem
    location = raptureMeal
    sdesc = "fries"
    noun = 'fry' 'fries'
    adjective = 'french'
    doEat(actor) =
    {
        "They're not all that bad, but you can't seem to
        make very much progress. No matter how many you eat,
        you seem to have the same amount left. After a while,
        they start to get pretty disgusting, so you give up.";
    }
;

ivoryBoat: amuletItem
    sdesc = "genuine ivory carving"
    adesc = "an ivory carving"
    noun = 'carving' 'boat' 'chain' 'amulet'
    adjective = 'ivory' 'gold' 'genuine'
    ldesc = "The carving depicts what looks like a rowboat.  It's
        attached to a gold chain for wearing it around the neck."
    location = raptureMeal
;

hamburger: fooditem
    location = raptureMeal
    noun = 'hamburger' 'burger'
    sdesc = "hamburger"
    doEat(actor) =
    {
        if (self.isbitten)
            "You can't bear to have any more.";
        else
        {
            "You take one bite, and suddenly realize why they
            had to include the free amulet of protection against
            nausea.  You can't manage to eat any more.";
            isbitten := true;
        }
    }
    ldesc =
    {
        "It's a plain hamburger, which doesn't look very good. ";
        if (isbitten) "It has one bite taken out of it.";
    }
;

raptureMeal: container
    noun = 'rapturemeal' 'meal' 'box'
    adjective = 'rapture'
    sdesc = "rapture meal"
    ldesc =
    {
        "It's a cheerful blue box. ";
        pass ldesc;
    }
;

class burgerButton: buttonitem
    location = burgerLord
    doPush(actor) =
    {
        if (burgerTerminal.awaitPayment)
            "The video screen changes back to the main order menu.";
        else
            "The video screen changes to read:
            \b*** Please insert payment ***
            \bPress any button to cancel order.";
        burgerTerminal.awaitPayment := not burgerTerminal.awaitPayment;
        burgerTerminal.raptureOrdered := nil;
    }
;

blueButton: burgerButton
    adjective = 'blue'
    sdesc = "blue button"
;

greenButton: burgerButton
    adjective = 'green'
    sdesc = "green button"
;

orangeButton: burgerButton
    adjective = 'orange'
    sdesc = "orange button"
;

purpleButton: burgerButton
    adjective = 'purple'
    sdesc = "purple button"
;

redButton: burgerButton
    adjective = 'red'
    sdesc = "red button"
    doPush(actor) =
    {
        inherited.doPush(actor);
        if (burgerTerminal.awaitPayment)
            burgerTerminal.raptureOrdered := true;
    }
;

burgerSlot: fixeditem
    noun = 'slot'
    adjective = 'payment'
    sdesc = "payment slot"
    location = burgerLord
    ldesc = "It looks suitable for small pieces of paper, such as
        currency or coupons."
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj <> coupon) "It doesn't fit.";
        else if (burgerTerminal.awaitPayment
                 and burgerTerminal.raptureOrdered)
        {
            coupon.moveInto(nil);
            burgerTerminal.awaitPayment := nil;
            raptureMeal.moveInto(burgerCounter);
            
            "The coupon disappears into the slot.  The monitor
            displays:
            \b\t\tThank you! One moment please...
            \bA few seconds later, a cheerful blue box smelling
            of fried food materializes on the counter in front of you.";
        }
        else
            "The slot takes it in, then immediately spits it back out.";
    }
;

burgerTerminal: fixeditem
    sdesc = "terminal"
    noun = 'terminal' 'monitor' 'display' 'computer' 'screen'
    adjective = 'computer' 'video'
    location = burgerLord
    ldesc =
    {
        "The terminal has a video display and a set of buttons.
        There's also a slot marked \"INSERT PAYMENT HERE\".
        The monitor is currently displaying:\b";

        if (self.awaitPayment)
            "*** Please insert payment ***
            \bPress any button to cancel order.";
        else
            "\t*** Welcome to Burger Lord ***
            \bPlease make your selection:
            \bBlue button: Hamburger
            \nGreen button: Fries
            \nOrange button: Medium Soda
            \nPurple button: Regular Soda
            \nRed button: RaptureMeal";
    }
;

burgerLord: room
    west = towerRoof
    out = towerRoof
    sdesc = "Burger Lord"
    ldesc = "You're in Burger Lord, a fast-food restaurant.     
       Several tables are available in the dining area.
       On the wall behind the counter, there's a menu, and a poster
       advertising a special offer.  The exit is to the west.
       \n\tThis establishment seems to have dispensed with
       costly and troublesome employees.  Instead, there is
       a computer terminal on the counter which you apparently
       use for ordering."
;

gatesOfHeaven: room
    north = towerRoof
    sdesc = "Gates of Heaven"
    ldesc = "You're floating among the clouds just south of the tower.
        To the south is a huge set of gates, made of pearl and gold.  The
        gates are open, and several tourists are posing for photographs
        at the gate.
        The roof of the tower is to the north."
    south =
    {
        if (not self.ispassed)
        {
            quote(['Paradise is a place'
                   'exactly like where you are right now,'
                   'only much, much better.'], 'Laurie Anderson');
            ispassed := true;
        }
        return(cloudtops);
    }
;

cloudtops: room
    sdesc = "Cloud Tops"
    ldesc = "You're among the clouds inside heaven.  To the
        east is a magnificent cathedral that looks to be built
        entirely from gold; the gigantic doorway leads inward to the east.
        The Gates of Heaven lie to the north."
    north = gatesOfHeaven
    east = waitingRoom
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);
        awardPoints(13, self);
    }
;

numberCard: item
    sdesc = "number card"
    location = waitingWoman
    noun = 'card' 'square'
    adjective = 'number' 'plastic'
    ldesc = "It's a small square of plastic with the number
        \"12\" printed on it."
;

// advance counter to 12 and open door to audience hall
serve12: function(parm)
{
    waitingDisplay.displayState++;
    waitingDoor.isopen := true;
    
    if (Me.location = waitingRoom)
        "\bFrom some hidden speaker system, a female voice announces,
        \"Number twelve, please.  Now serving number twelve.\"  The
        \"Now Serving\" display changes to \"12\", and the door to
        the south slowly swings open.";
    else
        "\bYou hear a female voice in the distance announce,
        \"Number twelve, please. Now serving number twelve.\"";
}

earrings: clothingItem
    location = airplaneHole
    sdesc = "pair of earrings"
    noun = 'pair' 'earring' 'earrings'
    ldesc = "They look expensive."
    doTake(actor) =
    {
        inherited.doTake(actor);
        awardPoints(13, self);
    }
;

waitingWoman: Actor
    location = waitingRoom
    sdesc = "young woman"
    ldesc = "She looks to be in her mid-thirties. You recognize
        her -- she was the woman filling out the application
        at the Celestial Security office."
    actorDesc = "There's a young woman here, sitting in one of the chairs."
    noun = 'woman'
    adjective = 'young'
    isHer = true
    actorAction(v, d, p, i) =
    {
        "\"I'd better just wait here.\"";
        exit;
    }
    disavow = "She doesn't seem to be paying any attention to you."
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        if (dobj = appointmentCard)
        {
            "Her face lights up.  \"Why thank you!  How kind!\"
            She takes <<dobj.thedesc>> and looks at it. \"I've
            had so much trouble getting one of these!\"";

            dobj.moveInto(self);
        }
        else if (dobj = earrings)
        {
            "\"Oh, my!  Those are my earrings!  Where did you find
            them?\"  She takes them from you and clips them to
            her earlobes.  \"Thank you so much!\"  She
            gets up and starts to leave, then turns around and
            hands you a small plastic square.  \"I guess I
            won't be needing this.  Maybe you'd like to use it.\"
            She turns back around and walks out the door.";

            dobj.moveInto(nil);
            numberCard.moveInto(Me);
            self.moveInto(nil);
            unnotify(self, &actorDaemon);
            setfuse(serve12, 3, nil);

            awardPoints(13, self);
        }
        else
            "\"No, thanks.\"";
    }
    ioSynonym('GiveTo') = 'ShowTo'
    state = 0
    actorMsg =
    [
        'Have you noticed how slow all of the bureaucracies are here?'
        'I mean, the bureaucracies are worse than in California.
        And California was pretty bad, believe me.  I used to work
        in a California DMV office.  Now *that* was fast-paced work!'
        'But here, it\'s terrible!  It took hours to get my Celestial
        Security card.'
        'Now I need a driver\'s license.  They won\'t take my
        California license in trade -- they say I need to take their
        test.  The problem is I can\'t get an appointment for it --
        they say that you need an appointment to get an appointment!'
        'Anyway, the reason I\'m here is that I lost my earrings
        somewhere.'
        'I was just exploring, trying to find my way around, and
        at some point I noticed my earrings were gone.'
        'I\'m hoping that God will be able to tell me where they
        went.'
    ]
    actorDaemon =
    {
        ++state;
        if (state > length(actorMsg))
            "\bThe woman sits and waits.";
        else
            "\bThe woman turns to you and says, \"<<actorMsg[state]>>\"";
    }
;

waitingDisplay: fixeditem
    sdesc = "numeric display"
    displayState = 11
    ldesc = "\"Now Serving: << displayState >>.\""
    location = waitingRoom
    noun = 'display' 'sign'
    adjective = 'numeric'
;

waitingChairs: chairitem
    noun = 'chair' 'chairs'
    sdesc = "chair"
    location = waitingRoom
    ldesc = "They look pretty uncomfortable."
    reachable = (inherited.reachable + self.location.contents)
;

waitingRoom: room
    sdesc = "Waiting Room"
    ldesc = "You're in a small room lined with uncomfortable-looking
        chairs.  The room is clearly a waiting room.  A door
        (<< waitingDoor.isopen ? "open" : "closed" >>) is to
        the south; over the door is a numeric display. The exit
        is to the west."
    west = cloudtops
    south = waitingDoor
    enterRoom(actor) =
    {
        if (waitingWoman.location = self)
            notify(waitingWoman, &actorDaemon, 0);
        pass enterRoom;
    }
    leaveRoom(actor) =
    {
        if (waitingWoman.location = self)
            unnotify(waitingWoman, &actorDaemon);
    }
;

waitingDoor: doorway
    location = waitingRoom
    isopen = nil
    noAutoOpen = true
    sdesc = "door"
    noun = 'door'
    ldesc = "It's << isopen ? "open" : "closed" >>."
    doordest = audienceHall
    doOpen(actor) = { "You see no way to do that."; }
    doClose(actor) = { "You see no way to do that."; }
;

audienceAltar: decoration
    sdesc = "altar"
    noun = 'altar'
    location = audienceHall
;

audienceCarpet: decoration
    sdesc = "red carpet"
    noun = 'carpet'
    adjective = 'red'
    location = audienceHall
;

audienceLight: decoration
    sdesc = "blinding light"
    noun = 'light'
    adjective = 'blinding'
    location = audienceHall
;

audienceHall: room
    sdesc = "Hall of Audiences"
    ldesc =
    {
        "You're in a huge room floating among the clouds.
        A red carpet leads up to a high altar; from the altar
        comes a blinding white light.  You are forced to avert
        your eyes from the light.  The exit is to the north.";

        if (prayerPad.location = self)
            " Floating in mid-air in front of you is a telephone-style
            keypad.";
    }
    roomAction(a, v, d, p, i) =
    {
        if (v = standVerb)
        {
            "You don't need to do that until you leave.";
            exit;
        }
        else pass roomAction;
    }
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);

        "\n\tYou slowly walk toward the altar, and
        kneel.  As you do, you are greeted by a deep, resonant
        voice that comes from the direction of the altar.
        \"I am the Lord thy God,\" the voice begins.
        \"I'm sorry that I'm unable to take your prayer
        right now.  Your call is being transferred to
        my Automated Prayer Mail System.\"
        \n\tIn front of you, a telephone-style keypad
        materializes in thin air.\b";

        prayerMail.curmenu := prayerMenu1;
        prayerMail.showmenu;
        prayerPad.moveInto(self);
    }
    north = waitingRoom
;

prayerMenuItem: object
    chooseKey(num) =
    {
        local ind, typ;

        ind := find(self.keylist, num);
        if (ind = nil)
            "\"Invalid option. Please try again.\"";
        else
        {
            typ := datatype(self.jumplist[ind]);
            if (typ = 2 /* object */)
            {
                // just select the new menu object
                prayerMail.curmenu := self.jumplist[ind];
            }
            else if (typ = 5 /* nil */)
            {
                // default end of tree - "function unavailable"
                "\"We're sorry, but that function is temporarily
                unavailable. Please make a different choice.\"";
            }
            else if (typ = 13 /* property pointer */)
            {
                // special handling - evaluate the property
                self.(self.jumplist[ind]);
            }
            else
                "\"We're sorry, but an internal error has occurred
                in the voice mail system. Please make a different choice.\"";
        }

        // show where we are
        "\b";
        prayerMail.showmenu;
    }
;

prayerMenu1: prayerMenuItem
    menu = "From somewhere near the altar, a precise and pleasant
        female voice says, \"Main Menu.  If you'd like to
        ask for divine intervention, press 1.  To make a
        confession, press 2.  For advice, press 3.  To learn
        the meaning of life, press 4.\""
    keylist = [1 2 3 4]
    jumplist = [prayerMenu2 prayerMenu3 prayerMenu4 nil]
;

prayerMenu2: prayerMenuItem
    menu = "The female voice says, \"Divine Intervention Menu.
        If you'd like to suspend the laws of physics, press 1.
        To request favorable outcome of a random event for
        gambling or other game, press 2.  To spare the life
        of your cow or other livestock animal, press 3.  To
        kill your neighbor's cow or other livestock animal,
        press 4. To return to the main menu, press the star key.\""
    keylist = [1 2 3 4 12]
    cowmessage = "\"We're sorry, but livestock health requests are no
        longer handled by this department. Please contact your local
        veterinarian.\""
    jumplist = [nil prayerMenu5 &cowmessage &cowmessage prayerMenu1]
;

prayerMenu3: prayerMenuItem
    menu = "\"Confessions.  Please enter the one-digit number of the
        commandment
        involved, using zero for the tenth commandment.  If your
        confession does not involve a commandment, or involves
        more than one commandment, press the pound key. To return
        to the main menu, press the star key.\""
    keylist = [1 2 3 4 5 6 7 8 9 10 11 12]
    confess = "\"We're sorry, but the confession recording disk is
        full. No space is available to take your confession. Please
        contact your clergyman or local police authorities.\""
    jumplist = [&confess &confess &confess &confess &confess &confess 
        &confess &confess &confess &confess prayerMenu3a prayerMenu1]
;

prayerMenu3a: prayerMenuItem
    menu = "\"Press the key of the next commandment involved. Press
        the pound key when done.\""
    keylist = [1 2 3 4 5 6 7 8 9 10 11]
    jumplist = [prayerMenu3a prayerMenu3a prayerMenu3a prayerMenu3a 
        prayerMenu3a prayerMenu3a prayerMenu3a prayerMenu3a 
        prayerMenu3a prayerMenu3a &confess]
    confess =
    {
        "\"We're sorry, but the confession recording disk is
        full. No space is available to take your confession. Please
        contact your clergyman or local police authorities.\"";
        prayerMail.curmenu := prayerMenu3;
    }
;

prayerMenu4: prayerMenuItem
    menu = "\"Advice.  For help with a business decision,
        press 1.  For questions about with your marriage, press 2.
        If you'd like a hint about this or any other High Energy
        Software game, press 3. To return to the main menu,
        press the star key.\""
    keylist = [1 2 3 12]
    hintmenu = "\"We're sorry, but the High Energy Software hint line is
        a toll '900' call.  Due to abuse, this extension has 900 blocking
        in effect. We cannot complete your call as dialed.\""
    jumplist = [nil nil &hintmenu prayerMenu1]
;

coupon: readable
    sdesc = "valuable coupon"
    noun = 'coupon'
    adjective = 'valuable' 'discount'
    ldesc = "It's a valuable discount coupon good for one free
        RaptureMeal at Burger Lord."
;

prayerMenu5: prayerMenuItem
    menu ="\"Game Intervention Menu.  To improve your card-counting
        ability for Blackjack, press 1.  To improve your odds in a
        state lottery, press 2.  For today's special, press 3.
        To return to the Divine Intervention menu, press the Star key.\""
    lotteryMessage = "\"We're sorry, but your odds in a state lottery
        are so low that they round down to zero, even after all
        available improvements are applied.\""
    specialMessage =
    {
        if (self.isTaken)
            "\"Only one special per customer, please.\"";
        else
        {
            "\"Today's special is:  a valuable coupon good for
            one free RaptureMeal at Burger Lord.\" A valuable
            discount coupon materializes in the air in front
            of you, and you snatch it.";

            isTaken := true;
            coupon.moveInto(Me);
            awardPoints(13, self);
        }
    }
    bjMessage =
    {
        if (self.bjScored)
            "\"Your card-counting ability cannot be increased further.\"";
        else
        {
            bjScored := true;
            "\"You are now 25\% better at counting cards.\"";
        }
    }
    keylist = [1 2 3 12]
    jumplist = [&bjMessage &lotteryMessage &specialMessage prayerMenu2]
;

prayerMail: object
    curmenu = prayerMenu1
    showmenu = { curmenu.menu; }
    pushKey(value) = { curmenu.chooseKey(value); }
;

class prayerKey: fixeditem
    noun = 'key' 'button'
    sdesc = "<< self.value >> key"
    verDoPush(actor) = {}
    doPush(actor) = { prayerMail.pushKey(self.value); }
    doSynonym('Push') = 'Touch'
    location = audienceHall
;

prayerKey1: prayerKey
    value = 1
    adjective = '1' 'one'
;

prayerKey2: prayerKey
    value = 2
    adjective = '2' 'two'
;

prayerKey3: prayerKey
    value = 3
    adjective = '3' 'three'
;

prayerKey4: prayerKey
    value = 4
    adjective = '4' 'four'
;

prayerKey5: prayerKey
    value = 5
    adjective = '5' 'five'
;

prayerKey6: prayerKey
    value = 6
    adjective = '6' 'six'
;

prayerKey7: prayerKey
    value = 7
    adjective = '7' 'seven'
;

prayerKey8: prayerKey
    value = 8
    adjective = '8' 'eight'
;

prayerKey9: prayerKey
    value = 9
    adjective = '9' 'nine'
;

prayerKey0: prayerKey
    value = 10
    adjective = '0' 'zero'
;

prayerKeyPound: prayerKey
    value = 11
    adjective = 'pound'
;

prayerKeyStar: prayerKey
    value = 12
    adjective = 'star'
;

prayerPad: fixeditem
    noun = 'keypad' 'pad'
    adjective = 'telephone' 'style' 'telephone-style'
    sdesc = "keypad"
    ldesc = "It's a telephone-style keypad, with buttons
        numbered 0 through 9, plus a star key (labeled '*')
        and a pound key ('#')."
;

heavenTourists: fixeditem
    sdesc = "tourists"
    adesc = "any tourists"
    ldesc = "It's a group of eight or ten people.
        They're busy posing for photographs at the Gates of Heaven."
    noun = 'tourist' 'tourists'
    location = gatesOfHeaven
;

pearlyGates: fixeditem
    sdesc = "gates of heaven"
    noun = 'gate' 'gates' 'heaven'
    adjective = 'pearly' 'large' 'huge' 'pearl' 'gold'
    location = gatesOfHeaven
    ldesc = "The gates are at least fifty feet high, and are
        somehow just floating among the clouds.  They're open."
;

elevOperator: Actor
    isHim = true
    sdesc = "elevator operator"
    adesc = "an elevator operator"
    location = elevator
    noun = 'operator' 'himself' 'man'
    adjective = 'elevator' 'old'
    actorDesc =
    {
        "An old, white-bearded man wearing a white robe
        is standing in the corner of the elevator near the
        controls.  He is evidently the elevator operator.";

        if (not self.ridiculed and parachute.isworn and flippers.isworn)
        {
            "\n\tThe operator looks at you for several moments,
            as though there's
            something wrong with you and he's trying to decide whether to
            tell you. \"You'd be surprised at the number of people I see
            who never bother to take off the parachute,\" he finally says,
            \"but most people find the flippers hard to walk around in.\"";
            ridiculed := true;
        }
    }
    ldesc = "He looks quite old, and seems very energetic,
        especially given what you think must be a boring job."
    actorAction(v, d, p, i) =
    {
        if (v = helloVerb)
            "\"Hello.\"";
        else if (v = uVerb and not ticket.istaken)
            "\"Ticket, please.\"";
        else
            "He smiles and points to a small sign:
            \"For safety reasons, please do not talk to
            operator unnecessarily.\"";
        exit;
    }
    ioSynonym('GiveTo') = 'ShowTo'
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        if (dobj = ticket)
        {
            if (ticket.istaken)
                "\"That's okay - it's an all-day pass, and I've already
                seen it once.\"";
            else
            {
                ticket.istaken := true;
                "He looks your ticket over \"Why, thank you!\" he says,
                handing the ticket back. \"That pass is good all day,
                so come back any time you like. And you know,\" he
                says, winking, \"the sun never rises in Hell, so the
                day is never over!  The company would make a lot more
                money if they could figure that out.  Anyway, let's go!\"
                \n\tHe reaches over to the controls and pushes the
                \"Heaven\" button.  The doors slowly slide shut, and you
                feel a gentle upward acceleration.  The old man fiddles
                with some controls, and the previously opaque rear wall of
                the elevator car becomes transparent; you turn around and
                look out to see that you've already risen thousands of
                feet -- you're high above the other buildings in the
                city, and high above even the mountain range off in
                the distance to the east.  Strangely, even from this
                altitude, you can't see any curvature to the plain
                below; it just seems to extend to infinity in all
                directions.  Above, though, you can see a sky filled
                with bright, numerous stars.
                \n\tBefore long, the ground below becomes so distant
                that you can no longer make out any details, so you
                direct your gaze upward at the stars.  Suddenly, your
                view of the brilliant night sky
                is interrupted as the elevator plunges into a dense cloud
                bank.  The elevator
                travels at terrifying speed through the thick
                clouds, then abruptly emerges into bright sunlight.
                The elevator seems to slow down a bit.  All around,
                you see golden beams of sunlight bursting from behind
                billowing white clouds, all against a deep blue sky.
                \n\t\"Ninety-nine thousandth floor,\" the operator
                says, \"Gates of Heaven, Restaurant, Gift Shop.
                Watch your step, please.\" The rear wall turns opaque
                again, and the doors slowly slide open.";
                elevator.inheaven := true;
            }
        }
        else
            "He politely refuses your offer.";
    }
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "He points to a small sign: \"For safety reasons,
        please do not talk to operator unnecessarily.\"";
    }
;

ticket: item
    sdesc = "ticket"
    noun = 'ticket'
    ldesc = "It's a piece of heavy white paper, about two inches by
        six inches; the background is printed with an elaborate,
        very colorful picture of a
        rainbow against a blue sky filled with fluffy white
        clouds.  Printed across the top in bright gold script letters
        is the legend, \"Elevator pass to HEAVEN,\" with the \"H\"
        in \"Heaven\" inside a big ornate box with little cherubs
        with harps and trumpets flying around it. On the back, in
        black sans serif type, is a bunch of fine print: \"Good all
        day.  Admit one Adult (Deceased).  Not transferable.
        Not responsible for lost or stolen articles.  Service
        provided by HadesCorp -- not affiliated with God.  HEAVEN
        and the HEAVEN logo are trademarks of God licensed exclusively
        to the Celestial Property Management Corporation. 
        Used by permission.\""
;

