#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

/*
 *   HyperEnumSugg
 *   by Eric Eve
 *   Version 1.0 (08-Jul-2007)
 *
 *   This module implements two options for the conversational interface. Both
 *   work with SuggestedTopics. The first works only on HTML interpreters,
 *   and allows the options in a topic inventory display to be hyperlinked
 *   so that a conversational topic can be selected just by clicking on
 *   a hyperlink. The second should work on any interpreter, and allows 
 *   the options in a topic inventory display to be enumerated so that
 *   they can be selected simply by typing the number of the topic at
 *   the command prompt. Both options may be active at the same time and
 *   neither prevents players entering conversational commands in the normal
 *   manner.
 */

suggestionEnumerator: object
  count = 0
  initialize()
  {
    count = 0;
    suggestionList = new Vector(20);
  }
  suggestionList = nil;
;

modify TopicDatabase
  showSuggestedTopicList(lst, asker, askee, explicit)
     {
        suggestionEnumerator.initialize();
        inherited(lst, asker, askee, explicit);
     }
;

modify SuggestedTopic
  htmlName = (aHref(fullName, name, fullName))  
  htmlFullName = (aHref(fullName, fullName, fullName))  
  suggestionNumber = 0
  noteSuggestion()
  {
    suggestionNumber = ++ suggestionEnumerator.count;
    suggestionEnumerator.suggestionList[suggestionNumber] = self;
    inherited();
  }
;

modify SpecialTopic
  noteSuggestion()
  {
    inherited SuggestedTopic();
    inherited();
  }
;


modify SuggestedTopicLister
   showListItem(obj, options, pov, infoTab)
     {
         /* note that we're showing the suggestion */
         obj.noteSuggestion();
         if(gameMain.enumerateSuggestedTopics)
           "[<<obj.suggestionNumber>>] ";
         if(gameMain.hyperlinkSuggestedTopics)
           say(obj.htmlFullName);
         else     
           say(obj.fullName);
     }
;

modify SuggestionListGroup
  showGroupItem(sublister, obj, options, pov, infoTab)
  {
     obj.noteSuggestion();
     if(gameMain.enumerateSuggestedTopics)
           "[<<obj.suggestionNumber>>] ";
     if(gameMain.hyperlinkSuggestedTopics)
       say(obj.htmlName);
     else
       say(obj.name);
  }
;

modify suggestionYesNoGroup
     showGroupList(pov, lister, lst, options, indent, infoTab)
     {
         /* 
          *   if we have one each of YES and NO responses, make the entire
          *   list "say yes or no"; otherwise, use the default behavior 
          */
         if (lst.length() == 2
             && lst.indexWhich({x: x.ofKind(SuggestedYesTopic)}) != nil
             && lst.indexWhich({x: x.ofKind(SuggestedNoTopic)}) != nil
             && gameMain.enumerateSuggestedTopics == nil
             && gameMain.hyperlinkSuggestedTopics == nil)
         {
             /* we have a [yes, no] group - use the simple message */
             sayYesOrNo;
         }
         else
         {
             /* inherit the default behavior */
             inherited SuggestionListGroup(pov, lister, lst, options, indent, infoTab);
         }
     }
     
 ;

 /*
  *  HyperEnumSugg_en_us.t defines commands the player can use to turn
  *  enumeration and hyperlinking of suggested topics on and off. The
  *  initial state of these options can be set on gameMain
  */

modify GameMainDef
  hyperlinkSuggestedTopics = nil
  enumerateSuggestedTopics = nil
  hyperlinkOrEnumerateConvNodes = nil
;

 /*
  *  The StringPreParser below is used to convert a number into a
  *  conversational command. It assumes that a previous display of
  *  a topic inventory has placed a set of SuggestedTopic objects in
  *  the Vector suggestionEnumerator.suggestionList. It also assumes
  *  that the fullName of each SuggestedTopic in this Vector is a
  *  (more or less) valid conversational command that can be executed
  *  to invoke the SuggestedTopic in question. 
  *
  *  For the qualification "more or less" see the processStr() method below.
  */

suggestionEnumerationPreParser: StringPreParser
  doParsing(str, which)
  {
    if(which == rmcCommand && gameMain.enumerateSuggestedTopics
    && rexMatch(pat, str))
    {
       local i = toInteger(str);
       local showTopics;
       if(i > 0 && i <= suggestionEnumerator.count) 
       {
         if(str.endsWith('t'))
         {
            str = str.substr(1, str.length() - 1);
            showTopics = true;
         }
         str = processStr(suggestionEnumerator.suggestionList[i].fullName);
         "(<<str>>)\n";
         if(showTopics || menuMode)
           "<.topics>";
       }
    }    
    
      return str.findReplace('`', '\'', ReplaceAll);
  }
  
  pat = static new RexPattern('^<Space>*<Digit>+<Space>*(t|T){0,1}$')
  
  /*
   *  In some games you may want enumeration to work just like a conversation
   *  menu throughout, by showing the topic inventory on each turn. This will
   *  happen it menuMode is set to true. We set this as the default since
   *  using numbers to choose conversation topics can quickly descend into
   *  a blind guessing game once the last topic inventory scrolls off the
   *  screen, or if a change of circumstances (e.g. leaving the current
   *  conversation node) changes the options available. In most games,
   *  displaying the available options each turn should make the selection 
   *  of a topic by number a more meaningful exercise.
   *
   *  Note that if this option is set to nil, the players can still request
   *  a new list of topics simply by appending 't' the number they select.
   */
   
  menuMode = true
  
  /*
   *   At least with the English language library, the fullName of a 
   *   SuggestedTopic may contain a parameter substitution string such as 
   *   '{it targetActor/him}', which won't evaluate correctly in the context 
   *   of this StringPreParser. The processStr() method is provided to deal 
   *   with this. Here we simply assume that any such parameter substitution 
   *   string is meant to evaluate to a pronoun referring to the PC's 
   *   current interlocutor as the target of the conversation command, so if 
   *   such a string is found we simply substitute the appropriate command. 
   *   If this extension is to be used with languages for which this 
   *   assumption does not hold good, this method can be overridden in the 
   *   language-specific file.
   *
   *   MODIFICATION. Actually, the assumption stated above could all too 
   *   easily be false, since the {} pattern could easily refer to some 
   *   other actor (or object), so we just need to replace the string {it 
   *   targetactor/him} with the relevant pronoun and then expand any other 
   *   parameter substitution strings.  
   */
  
  processStr(str)
  {
       
     local actor = gPlayerChar.getCurrentInterlocutor();
     local pron = actor != nil ? actor.itObj : '';
//     str = rexReplace(patB, str, pron, ReplaceAll);     
        str = str.findReplace('{it targetActor/him}', pron, ReplaceAll);
     return langMessageBuilder.generateMessage(str);

  }
  
//  patB = static new RexPattern('{it targetactor/him}')
  
  runOrder = 50 // make sure we come before the specialTopicPreParser
;

/*==================================================================
 *  Give ConvNodes the ability to hyperlink (or, on a non-HTML interpreter,
 *  enumerate) their SuggestedTopics if there are active SpecialTopics,
 *  regardless of whether the hyperlink/enumeration option is otherwise
 *  on.
 */

modify ConvNode
  noteActive()
  {
     oldHyperlink = gameMain.hyperlinkSuggestedTopics;
     oldEnumerate = gameMain.enumerateSuggestedTopics;
     if(gameMain.hyperlinkOrEnumerateConvNodes && autoShowTopics())
     {
        if(systemInfo(SysInfoInterpClass) == SysInfoIClassHTML)
          gameMain.hyperlinkSuggestedTopics = true;     
        else
          gameMain.enumerateSuggestedTopics = true;
     }
     inherited();
  }
  
  noteLeaving()
  {
     gameMain.hyperlinkSuggestedTopics = oldHyperlink;
     gameMain.enumerateSuggestedTopics = oldEnumerate;
  }
  
  oldHyperlink = nil
  oldEnumerate = nil
;

   

