#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// DEBUG STUFF
// ACHIEVEMENTS: achievement.t modifications
// ACHIEVEMENTS: Achievements
// ACHIEVEMENTS: Achievement-scope variables
// BUILDING: PRELIMINARIES
// BUILDING: ROOMS: CLASSES
// BUILDING: ROOMS: HALLWAYS 1, 2, 3, 4, 7, AND 8
// BUILDING: ROOMS: HALLWAY 5
// BUILDING: ROOMS: HALLWAY 6, including slowing field and drain
// BUILDING: ROOMS: STAIRS, HALLWAY 9, & SKYWAY
// BUILDING: ROOMS: DREAM ROOM
// BUILDING: ROOMS: OFFICE, including books, desks, scenery, stapler, ary/T transformed objects, etc.
// BUILDING: ROOMS: CELL
// BUILDING: ROOMS: BREAK ROOM, including G.E. fridge, etc.
// BUILDING: ROOMS: BATHROOM
// BUILDING: ROOMS: CONFERENCE ROOM
// BUILDING: ROOMS: MUSEUM
// BUILDING: DOORS AND DOORWAYS (including the frontDoors victory sequence)
// BUILDING: MISCELLANEOUS: ALIEN SENSE CONNECTOR
// BUILDING: MISCELLANEOUS: BULK STUFF
// INTRA-ROOM STUFF: xValue, yValue, etc.
// INTRA-ROOM STUFF: absoluteXValue, absoluteYValue
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: Core code
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: implicitAnnouncementGrouper
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: TouchObjCondition
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: actorReadyToGoNear
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: actorNotStretchingGunCable
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: Implicit actions
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: Drop/throw consequences
// INTER-ROOM STUFF: endgameOccluder
// INTER-ROOM STUFF: SometimesDistant class
// INTER-ROOM STUFF: ShadowCaster class
// INTER-ROOM STUFF: Room symbols
// JUNK: Notes to myself
// DEBUG STUFF

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

// At this point most debugging stuff is at the end of the file, under
// "junk."

#ifdef __DEBUG

//modify ExamineAction
//  // My kludge way of finding out what all is in scope.
//  actionAllowsAll = true
//;

DefineIAction(Doorman)
  execAction() {
    if (!glob.doormanActivated) {
      "<h2>Testing h2!!!</h2>";
      "Doorman activated. ";
      glob.doormanActivated = true;
    }
    else {
      "Doorman deactivated. ";
      glob.doormanActivated = nil;
    }
  }
;
VerbRule(Doorman)
  'doorman'
  : DoormanAction
  verbPhrase = 'call/calling the doorman'
;

/*
stairsFloor: FormerRoomShadowCaster, Floor
  vocabWords       = 'stairs/stair/stairway/staircase/(set)/floor'
  shadowVocabWords = 'stairs/stair/stairway/staircase/(set)'
;
skyway: FormerRoomShadowCaster, AlienRoom 'Skyway'
  vocabWords       = 'skyway/room'
  shadowVocabWords = 'skyway'
;
dreamRoom: FormerRoomShadowCaster, AlienRoom 'Dream Room'
  vocabWords       = 'dream room'
  shadowVocabWords = 'dream (room)'
;
office: FormerRoomShadowCaster, AlienRoom 'Office'
  vocabWords       = 'office/room'
  shadowVocabWords = 'office'
;
officeBooks: Readable, Fixture
  vocabWords       = 'book books title titles -'
  shadowVocabWords = 'book books -'
;
modify cell
  vocabWords       = 'cell/room'
  shadowVocabWords = 'cell'
;
breakRoom: FormerRoomShadowCaster, AlienRoom 'Break Room'
  vocabWords       = 'break room'
  shadowVocabWords = 'break (room)'
;
geFridge: FormerShadowCaster, Fixture, ComplexContainer
  vocabWords       = 'ge (human) (human-style) g.e. general electric fridge/refrigerator'
  shadowVocabWords = 'ge (human) (human-style) g.e. general electric fridge/refrigerator/freezer'
;
bathroom: FormerRoomShadowCaster, AlienRoom 'Bathroom'
  vocabWords       = 'bath bathroom/room'
  shadowVocabWords = 'bath bathroom/(room)'
;
modify confRoom
  vocabWords       = 'conference room'
  shadowVocabWords = 'conference (room)'
;
museum: FormerRoomShadowCaster, AlienRoom 'Museum'
  vocabWords       = 'museum/room'
  shadowVocabWords = 'museum'
;
westPlatform: AlienPlatform
  vocabWords       = 'west platform'
;

eastPlatform: AlienPlatform
  vocabWords       = 'east platform'
;


confTable: FormerShadowCaster, ConfFurniture, Platform, Fixture
  vocabWords       = '(shiny) (black) stone (conference) table'
  shadowVocabWords = '(shiny) (black) (stone) (conference) table'
;


bunkBed: FormerShadowCaster, Soft, Fixture 
  vocabWords       = ' metal   frame                                          (bunk) bed bunkbed ladder -' 
  shadowVocabWords = '(metal) (frame) (lower) (bottom) (middle) (upper) (top)  bunk bed bunkbed ladder -'
;

*/

//DefineIAction(Rest)
//  execAction() {
//    "Just a short rest, you think. But it turns out to be more 
//      than that. ";
//    // No <br> or <p> wanted here:
//    nestedAction(Sleep);
//  }
//;
//
//VerbRule(Rest)
//  'rest'
//  : RestAction
//  verbPhrase = 'rest/resting'
//;
//   
//modify me
//  goToSleep() {
//    "You fall asleep. And out here in the frozen arctic tundra,
//      that can be a deadly mistake. ";
//    finishGameMsg(ftDeath, [finishOptionUndo]);
//  }
//;

//class HandCannon: Thing
//  name = 'hand cannon'
//  isEquivalent = true
//;
//oldGuardHandCannon: HandCannon
//  vocabWords = 'hand cannon*cannons'
//  location = dreamRoom
//;
//youngGuardHandCannon: HandCannon
//  vocabWords = 'hand cannon*cannons'
//  location = dreamRoom
//;


//class FooBar: Thing
//  isEquivalent = true
//  name = 'foobar'
//  vocabWords = '(metal) foo bar/foobar/thing*foos*bars*foobars*things' 
//  location = dreamRoom
//;
//
//FooBar
//  //location = oldGuard
//  //asscGuard = oldGuard
//;
//
//FooBar
//  //location = youngGuard
//  //asscGuard = youngGuard
//;


//class Sming: Thing
//  'sming*smings' 'sming'
//  "A sming is a small thing. "
//  isEquivalent = true
//  bulk = 1
//;
//
//sming1: Sming
//  location = dreamRoom
//;
//sming2: Sming
//  location = dreamRoom
//;
//sming3: Sming
//  location = dreamRoom
//;


//smox: Container
//  'smox' 'smox'
//  "A smox is a small box. "
//  bulkCapacity = 10
//;
//
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;
//Sming location = dreamRoom;

#endif // __DEBUG

// -------------------------------------------------------------------
// ACHIEVEMENTS: achievement.t modifications
// -------------------------------------------------------------------

// This feels like as good a place as any to include my achievement.t achivements.

modify achievementScopeFileManager
  achievementFilename = 'mazesachievement.sav'
;

// This should run just once upon entering the endgame.
function initializeAchievementsForEndgame() {
  mazeWinAchievement.achieve();
}

function achievementTasksForVictory() {
  gameWinAchievement.achieve();
  
  local curObj = nil;
  for (curObj = firstObj(ASAchievement); curObj != nil; 
       curObj = nextObj(curObj, ASObject))
  {
    curObj.setVisible();
  }
}

modify AchievementsAction
  execAction() {
    if (gPlayerChar == bot) {
      //say(botPlayerMessages.commandNotUnderstood(me));
      "There are no achievements in this part of the game. ";
    }
    else if (!glob.isInEndgame) {
      "There are no achievements in this part of the game. ";
    }
    else {
      inherited();
    }
  }
;

// Modifications to make autosave.t play better with achievement.t:

modify libMessages
  autoSave_beginChallengeReport =
    "<.p><.notification>"
;

modify Actor
  // This is an autosave.t-specific method
  beforePlayerCharNonIdleTurn()
  {
    // Here's the hack: Run achievementScopeDaemon.executeDaemon() first.
    // It's okay if it runs twice per turn.
    achievementScopeDaemon.executeDaemon();
    
    challengeManager.beforePlayerCharNonIdleTurn();
  }
;

//modify achievementScopeDaemon
//  executeDaemon() {
//    inherited();
//     challengeManager.beforePlayerCharNonIdleTurn();
//  }
//;

// The ASDF action is designed to try to do every T-removing and ary ung 
// transformation in the game.

modify glob
  hackedToPreventAryConsequences = nil
;

#ifdef __DEBUG

DefineIAction(Qwer)
  execAction() {
    "qwer!! ";
    local messageProp = &noMatch;
    local args = [];
    //gAction = predicate(SpecialTopic);
    gPlayerChar.getParserMessageObj().(messageProp)(nil, args);
  }
  actionTime = 0
;

VerbRule(Qwer)
  'qwer'
  : QwerAction
  verbPhrase = 'qwer/qwering'
;

DefineIAction(AsdfAsdf)
  execAction() {
    local count = 0;
    local obj;
    for (obj = firstObj(Thing); obj != nil; 
         obj = nextObj(obj, Thing))
    {
      count++;
      local prevLocation = obj.location;
      glob.hackedToPreventAryConsequences = true;
      obj.baseMoveInto(gPlayerChar.getOutermostRoom);
      obj.handleBlast(&zapAry);
      obj.handleBlast(&zapAry2);
      obj.handleBlast(&zapT);
      obj.handleBlast(&zapT2);
      obj.baseMoveInto(prevLocation);
      glob.hackedToPreventAryConsequences = nil;
      if (count % 40 == 0) { nbmPause(); }
    }
    
    //// In case I decide I want to magically get every achievement:
    //mazeWinAchievement.achieve();
    //gameWinAchievement.achieve();
    //aryUngAchievement.achieve();
    //tRemoverAchievement.achieve();
    //cheeseAchievement.achieve();
    //weaponAchievement.achieve();
  }
  actionTime = 0
;

VerbRule(AsdfAsdf)
  'asdfasdf'
  : AsdfAsdfAction
  verbPhrase = 'asdfasdf/asdfasdfing'
;

#endif // __DEBUG


// -------------------------------------------------------------------
// ACHIEVEMENTS: Achievement classes
// -------------------------------------------------------------------

modify ASAchievement
  // this is something that individual achievements can override if desired
  shouldBeMadeVisibleUponVictory = true
;

class GunAchievement: ASAchievement
  asscGun = nil // override
  asscList = nil // override
  countThreshold = 0 // override
  visible = nil
  asscAchievements = [] // override
  desc {
    local str = 'Perform ' + countThreshold + ' transformations using the ' 
      + asscGun.name + '. ';
    if (asscList.value.length > 0) {
      str += '(Actual so far: ' + asscList.value.length + ') ';
    }
    return str;
  }
  addToList(str) {
    // Add the value to the associated list
    asscList.addValue(str);
    
    // Set any associated achievements to visible. Also, check to 
    // see which, if any, of the achievements need to be achieved.
    for (local i = 1; i <= asscAchievements.length; i++) {
      local asscAchievement = asscAchievements[i];
      asscAchievement.setVisible();
      if (asscList.value.length >= asscAchievement.countThreshold) {
        asscAchievement.achieve();
      }
    }
  }
;

class AryUngAchievement: GunAchievement
  asscGun = aryUng
  asscList = aryUngList
  asscAchievements = [aryUngAchievement1, aryUngAchievement2]
;

class TRemoverAchievement: GunAchievement
  asscGun = tRemovingGun
  asscList = tRemoverList
  asscAchievements = [tRemoverAchievement1, tRemoverAchievement2]
;

// -------------------------------------------------------------------
// ACHIEVEMENTS: Achievements
// -------------------------------------------------------------------

transient mazeWinAchievement: ASAchievement
  asName = 'mazeWinAchievement'
  name = 'Earth Maze Master'
  desc = 'Escape the aliens<./s> maze game. '
  listOrder = 10
;

transient gameWinAchievement: ASAchievement
  asName = 'gameWinAchievement'
  name = 'Best Day in 163 Years'
  desc = 'Win the game. '
  listOrder = 20
;

transient cheeseAchievement: ASAchievement
  asName = 'cheeseAchievement'
  name = 'Cheese: The Final Verdict'
  desc = 'Prove beyond a reasonable doubt whether or not this game contains cheese. '
  listOrder = 30
;

transient weaponAchievement: ASAchievement
  asName = 'weaponAchievement'
  name = 'It<./s>s Not Impossible, Just Really Hard'
  desc = 'Defeat all five aliens without activating the slowing field. '
  listOrder = 40
  visible = nil
;

//transient tRemoverAchievement: ASAchievement
//  name = 'T-Removing Trailblazer'
//  desc {
//    local str = 'Perform ' + countThreshold + ' transformations using the T-removing gun. ';
//    if (tRemoverList.value.length > 0) {
//      str += '(Actual so far: ' + tRemoverList.value.length + ') ';
//    }
//    return str;
//  }
//  listOrder = 40
//  visible = nil
//  countThreshold = 50
//  addToList(str) {
//    setVisible();
//    tRemoverList.addValue(str);
//    if (tRemoverList.value.length >= countThreshold) {
//      achieve();
//    }
//  }
//;

transient tRemoverAchievement1: TRemoverAchievement
  asName = 'tRemoverAchievement1'
  name = 'T-Removing Trailblazer'
  listOrder = 50
  countThreshold = 8
;

transient tRemoverAchievement2: TRemoverAchievement
  asName = 'tRemoverAchievement2'
  name = 'T-Removing Tour de Force'
  listOrder = 60
  countThreshold = 16
;

//transient aryUngAchievement: ASAchievement
//  name = 'Ary Ung Aficionado'
//  desc {
//    local str = 'Perform ' + countThreshold + ' transformations using the ary ung. ';
//    if (aryUngList.value.length > 0) {
//      str += '(Actual so far: ' + aryUngList.value.length + ') ';
//    }
//    return str;
//  }
//  listOrder = 30
//  visible = nil
//  countThreshold = 50
//  addToList(str) {
//    setVisible();
//    aryUngList.addValue(str);
//    if (aryUngList.value.length >= countThreshold) {
//      achieve();
//    }
//  }
//;

transient aryUngAchievement1: AryUngAchievement
  asName = 'aryUngAchievement1'
  name = 'Ary Ung Aficionado'
  listOrder = 70
  countThreshold = 32
;

transient aryUngAchievement2: AryUngAchievement
  asName = 'aryUngAchievement2'
  name = 'Ary Ung Ace Accomplishment'
  listOrder = 80
  countThreshold = 64
;


// -------------------------------------------------------------------
// ACHIEVEMENTS: Achievement-scope variables
// -------------------------------------------------------------------

transient aryUngList: ASStringList
  allowDuplicates = nil
;

transient tRemoverList: ASStringList
  allowDuplicates = nil
;

transient asIntTest: ASInteger
  value = 0
;

// -------------------------------------------------------------------
// BUILDING: PRELIMINARIES
// -------------------------------------------------------------------

// This is what to do when we are transitioning from the end of the
// argument (in which you falsely appear to have woken up) 
// to the actual endgame (where you really do wake up).

transitionToEndgame() {
  nbmPause();
  nbmCls();
  
  // The "beach"/"empty room" stuff
  if (virtualMe.getOutermostRoom != beachRoom &&
      virtualMe.getOutermostRoom != emptyRoom) {
    if (beachChairM.isInExe) {
      virtualMe.moveIntoForTravel(beachChair);
      virtualMe.makePosture(sitting);
      beachPda.moveInto(virtualMe);
    }
    else {
      virtualMe.moveIntoForTravel(emptyRoom);
      emptyRoomPda.moveInto(virtualMe);
    }
  }
  setPlayer(virtualMe);
  nbmBanner.updateMe;
  statusLine.showStatusLineDaemon();
  "Just as the game crashes, you notice something strange. 
    You return your attention to your surroundings. ";
  "<p>";
  gPlayerChar.lookAround(true);
  "<.p>But then, within seconds, the scene begins to fade\ .\ .\ . ";
  nbmPause();
  nbmCls();
}

function doStuffForEndgame() {
  if (!glob.endgameStuffAlreadyDone) {
    glob.endgameStuffAlreadyDone = true;
    vicki.hasBeenIdentified = true;
    diane.hasBeenIdentified = true;
    ovan.hasBeenIdentified = true;
    neton.hasBeenIdentified = true;
    
    if (endgameDaemon.daemonID == nil) endgameDaemon.startDaemon();
    //if (endgameDaemon.daemonID != nil) endgameDaemon.endDaemon();
    //endgameDaemon.startDaemon();
    
    if (endgameOccluder.location != me) endgameOccluder.moveInto(me);
    neton     .setCurState(netonEndgameState);
    ovan      .setCurState(ovanEndgameState);
    oldGuard  .setCurState(oldGuardEndgameState);
    youngGuard.setCurState(youngGuardEndgameState);
    assistant .setCurState(assistantEndgameState);
    oldGuardSandwich.moveInto(oldGuard);
    dagger.moveInto(assistant);
  }
}

modify glob
  endgameStuffAlreadyDone = nil
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: CLASSES
// -------------------------------------------------------------------

class AlienRoom: Room
  isAlienRoom = true
  bannerValue = endgame
  enteringRoom(traveler) {
    if ((glob.isInEndgame || gPlayerChar.isIn(dreamRoom)) && !doGlimpseFromHereNoMore)
      doGlimpseFromHere;
    adjustValues(traveler);
    if (vicki.rescued && !vicki.leaving) {
      if (vicki.getOutermostRoom && 
          vicki.getOutermostRoom.north && 
          vicki.getOutermostRoom.north.getDestination(
          vicki.getOutermostRoom, vicki) == me.getOutermostRoom) {
        "Vicki and Diane follow you from the south. ";
        vicki.scMoveInto(me.getOutermostRoom);
        diane.scMoveInto(me.getOutermostRoom);
        if (vicki.waitList == waitTwelve && waitLength >= 7 ||
            vicki.waitList == waitNine && waitLength >= 4)
          vicki.waitList = vicki.waitSix;
        vicki.waitLength = -1;
      }
      else if (traveler == me && me.prevLoc == vicki.getOutermostRoom) {
        vicki.askWhereGoing;
      }
    }
//    if (self == hallway5 && !me.hasSeen(hallway5)) {
//      nbmBanner.updateMe;
//    }
//    if (traveler == me && glob.endgameJeopardy && glob.enemyState == arguing) {
//      "As you step through the door, you hear Ovan say 
//          behind your back, <.q>What the&mdash;! 
//          He<./s>s escaping!<./q>
//        <p><.q>Grab your weapon!<./q> Neton cries. <.q>After him!<./q> ";
//      glob.enemyState = waiting;
//      officeDoor.makeOpen(true);
//      neton.scMoveInto(hallway8);
//      ovan.scMoveInto(hallway8);
//    }
  }
  adjustValues(traveler) {
    if (traveler.isActor) {
      traveler.xBaseValue = 0;
      traveler.yBaseValue = 0;
      //callWithSenseContext(nil, nil, new function { "[AlienRoom.adjustValues] "; } );
      traveler.xOffset = 0;
      traveler.yOffset = 0;
    }
  }
  //These are the default roomParts anyway.
  //roomParts = [defaultWalls, defaultCeiling, defaultFloor]
  leavingRoom(traveler) {
    traveler.prevLoc = traveler.getOutermostRoom();
  }
  roomAfterAction() {
    doStuffForEndgame();
  }
  roomBeforeAction {
    // Before going south in the "fish corridor", make sure there aren't 
    // slowed aliens standing right there south of you in the room you're in,
    // waiting to kill you. If that happens, let them kill you.
    if (gActor == gPlayerChar && isInFishCorridor /* && slowingField.isOn */
        && gActionIs(TravelVia) && gDobj == self.south) {
      local guys = aliensToPreventSouthwardMovement;
      if (guys) {
        if (self == museum)
          "You start to head southward, trying very hard to avoid ";
        else
          "You start to head southward, but soon run into ";
        simpleLister(guys, &theNameWrtStunning);
        ". ";
        // The southward-motion-preventing aliens should always be
        // slowed, and sometimes will also be stunned.
        if (guys[1].isStunned) {
          endgameDaemon.killPcByStunnedCloseNpcs(guys);
        }
        else if (guys[1].isSlowed) {
          "Unfortunately for you, although the 
            <<guys.length == 1 ? 'alien is' : 'aliens are'>>
            slowed, ";
          endgameDaemon.killPcBySlowedCloseNpcs(guys);
        }
        else {
          endgameDaemon.killPcByOrdinaryCloseNpcs(guys);
        }
      }
    }
  }
  aliensToPreventSouthwardMovement {
    local guys = [neton, ovan, oldGuard, youngGuard, assistant];
    local guysInNorthernmostRow = [];
    local guysInSecondNorthernmostRow = [];
    local stunnedGuys = [];
    local nonStunnedGuys = [];
    local northernmostYVal = 10000;
    // Determine the northernmost Y value, and remove from the "guys" list 
    // any NPCs who are not in the same room as the PC.
    for (local a = guys.length; a >= 1; a--) {
      if (guys[a].getOutermostRoom != self) {
        guys = guys.removeElementAt(a);
      }
      else {
        if (guys[a].absoluteYValue < northernmostYVal) {
          northernmostYVal = guys[a].absoluteYValue;
        }
      }
    }
    if (!guys.length)
      return nil;
    // Get lists for (1) the northernmost NPCs in this room,
    // (2) any NPCs in this room who might have a yValue of exactly 1 less than
    // the northernmost NPCs in this room, (3) stunned NPCs in this room,
    // and (4) non-stunned NPCs in this room.
    for (local a = 1; a <= guys.length; a++) {
      if (guys[a].absoluteYValue == northernmostYVal)
        guysInNorthernmostRow = guysInNorthernmostRow + guys[a];
      else if (guys[a].absoluteYValue == northernmostYVal + 25)
        guysInSecondNorthernmostRow = guysInSecondNorthernmostRow + guys[a];
      if (guys[a].isStunned)
        stunnedGuys = stunnedGuys + guys[a];
      else
        nonStunnedGuys = nonStunnedGuys + guys[a];
    }
    // If there are any non-stunned NPCs who are northernmost in this 
    // room, it is they who will prevent southward movement.
    if (guysInNorthernmostRow.intersect(nonStunnedGuys).length)
      return guysInNorthernmostRow.intersect(nonStunnedGuys);
    // If all northernmost NPCs are stunned, and if there are NPCs
    // directly south of them who are not stunned, the non-stunned
    // ones will prevent southward movement.
    if (guysInSecondNorthernmostRow.intersect(nonStunnedGuys).length)
      return guysInSecondNorthernmostRow.intersect(nonStunnedGuys);
    // Otherwise, let the northernmost NPCs prevent southward
    // movement even if they are stunned.
    return guysInNorthernmostRow;
  }
  northernmostAliensHere {
    local guys = [neton, ovan, oldGuard, youngGuard, assistant];
    local northernmostYVal = 10000;
    for (local a = guys.length; a >= 1; a--) {
      if (guys[a].getOutermostRoom != self) {
        guys = guys.removeElementAt(a);
      }
      else {
        if (guys[a].absoluteYValue < northernmostYVal)
          northernmostYVal = guys[a].absoluteYValue;
      }
    }
    if (!guys.length)
      return nil;
    for (local a = guys.length; a >= 1; a--) {
      if (guys[a].absoluteYValue > northernmostYVal) {
        guys = guys.removeElementAt(a);
      }
    }
    return guys;
  }
  isInColumn = 0
  isInRow = 0
  // If firing at this room with, e.g., the T-removing gun, hit a wall
  // instead if possible.
  transformObj {
    local idx;
    idx = roomParts.indexWhich({x: x.isWall});
    if (!idx)
      idx = roomParts.indexWhich({x: !x.ofKind(Floor)});
    if (idx)
      return roomParts[idx];
    else
      return self;
  }
;

// The following modification is a horrid kludge. Don't try this
// at home. Or if you do, don't blame me for the result.

modify AlienRoom
    lookAroundWithin(actor, pov, verbose) {
        local illum;
        local infoTab;
        local info;
        local specialList;
        local specialBefore, specialAfter;
        if (verbose == true) {
            verbose = (LookRoomName | LookRoomDesc
                       | LookListSpecials | LookListPortables);
        }
        else if (verbose == nil) {
            verbose = (LookRoomName | LookListSpecials | LookListPortables);
        }
        if (!actor.hasSeen(self))
            verbose |= LookRoomDesc;
        infoTab = actor.visibleInfoTableFromPov(pov);
        info = infoTab[pov];
        if (info != nil) {
            illum = info.ambient;
        }
        else {
            illum = 0;
        }
        adjustLookAroundTable(infoTab, pov, actor);
        if ((verbose & LookRoomName) != 0) {
            "<.roomname>";
            lookAroundWithinName(actor, illum);
            "<./roomname>";
        }
        if ((verbose & LookRoomDesc) != 0) {
            "<.roomdesc>";
            lookAroundWithinDesc(actor, illum);
            "<./roomdesc>";
        }
        if ((verbose & LookListSpecials) != 0) {
            local plst;
            specialList = specialDescList(
                infoTab,
                {obj: obj.useSpecialDescInRoom(self) && !obj.isIn(actor)
                
                
                // BEGIN HORRID KLUDGE
                && !(obj.ofKind(Npc) //&& glob.isInEndgame
                )
                // END HORRID KLUDGE
                
                
                });
            plst = partitionList(specialList,
                                 {obj: obj.specialDescBeforeContents});
            specialBefore = plst[1];
            specialAfter = plst[2];
            specialContentsLister.showList(pov, nil, specialBefore,
                                           0, 0, infoTab, nil);
        }
        if ((verbose & LookListPortables) != 0) {
            lookAroundWithinContents(actor, illum, infoTab);
        }
        
        
        //BEGIN HACK
        if (gPlayerChar.isIn(dreamRoom) && glob.endgameJeopardy && 
            !endgameProfSequence.netonMentionedCrash) {
          "<.p>";
          endgameProfSequence.seeProfs;
        }
        else {
          if ((verbose & LookListSpecials) != 0) {
            specialContentsLister.showList(pov, nil, specialAfter,
                                           0, 0, infoTab, nil);
          }
          glob.giveNpcReport;
          //if (me.getOutermostRoom != vicki.getOutermostRoom) {
          //  glob.giveNpcReport;
          //}
        }
        //END HACK
        
        
        lookAroundWithinSense(actor, pov, sound, roomListenLister);
        lookAroundWithinSense(actor, pov, smell, roomSmellLister);
        lookAroundWithinShowExits(actor, illum);
        if (illum > 1)
            actor.setHasSeen(self);
        
        
        
        // BEGIN HACK
        if (glob.doormanActivated) {
          "<.p>getDoorForLeavingBuilding = <<sayDoorName(me.getOutermostRoom.getDoorForLeavingBuilding)>>";
          "<.p>getDoorForLeavingRoom = <<sayDoorName(me.getOutermostRoom.getDoorForLeavingRoom)>>";
        }
        // END HACK
        
        
        
        
    }
;

sayDoorName(dr) {
  if (!dr)
    return 'nil';
  else
    return dr.name;
}

modify defaultWalls
;

modify Thing
  isOrIsIn(obj) {
    if (self == obj)
      return true;
    else
      return isIn(obj);
  }
;

modify Room
  nearestHallway = hallway5
  // getDoorForLeavingBuilding will give the door to be opened from this room 
  // if you want to leave the building.
  getDoorForLeavingBuilding = (getDoorForLeavingRoom)
  // getDoorForLeavingRoom will give the door to be opened 
  // if you want to leave the room, but not necessarily the building,
  // and would prefer not to open a door.
  getDoorForLeavingRoom = nil
  roomIdentifierStr = roomName
;
modify glob
  doormanActivated = nil
;

// MultiLoc is modified here to fix a possible bug in the library, 
// where MultiLoc.canSee(obj) tends to be nil for almost any obj,
// even if obj can see the multi-located thing just fine.
// 
// With my NPCs being MultiLoc's, this bug created horrendous
// problems with the NPCs not ever being able to, for instance, 
// see or hear anything.

// With the newer versions of the TADS 3 library, there is no reason 
// to do this hack; TADS 3 has now got this fixed.

/*
modify MultiLoc
  addDirectConnections(tab) {
    tab[self] = true;
    foreach (local cur in collectiveGroups)
      tab[cur] = true;
    foreach (local cur in contents) {
      if (tab[cur] == nil)
        cur.addDirectConnections(tab);
    }
    // BEGIN HACK
    if (senseTmp.pointOfView == self || senseTmp.pointOfView.isIn(self)) {
    // END HACK
      foreach (local cur in locationList) {
        if (tab[cur] == nil)
          cur.addDirectConnections(tab);
      }
    }
  }
;
*/

// -------------------------------------------------------------------
// BUILDING: ROOMS: HALLWAYS 1, 2, 3, 4, 7, AND 8
// -------------------------------------------------------------------

class AlienHallway: AlienRoom
  nearestHallway = self
  initializeVocabWith(str) {
    str = str + '/hallway/hall/corridor';
    inherited(str);
  }
;

hallway1: AlienHallway 'Hallway'
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway1'
  roomDesc() {
    "The hallway here extends to the south. ";
    if (!frontDoors.isOpen /*&& !frontDoors.obviouslyLeadOutside*/ )
      "To the north 
        stands a set of closed doors, which appear to be 
        the front doors of the building. ";
    //else if (!frontDoors.isOpen) // frontDoors.obviouslyLeadOutside
    //  "To the north stand the front doors of the building. ";
    else
      "To the north, the front doors are open, leading
        outside. ";
  }
  getDoorForLeavingBuilding = frontDoors
  isInColumn = 1
  isInRow = 3
  south = hallway2
  north = frontDoors
;

hallway2: AlienHallway 'Hallway'
  "The hallway continues to the 
    north, while to the south 
    <<hallDoors.isOpen 
      ? 'a set of open doors leads to another part of the hallway.' 
      : 'there is a closed set of doors.'>> "
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway2'
  isInColumn = 1
  isInRow = 4
  north = hallway1
  south =   hallDoors2
;

hallway3: AlienHallway 'Hallway'
  roomDesc() {
    if (hallDoors.isOpen) {
      "The hallway here extends to the east, while a set of open doors
        leads north to another part of the hallway. ";
      if (!cellDoor.isOpen) {
        "To the south stands a closed 
          door<<slotlikePassingReference>>. ";
      }
      else {
        "Another open door<<slotlikePassingReference>> 
          leads south to a 
          cell. ";
      }
    }
    else {
      "The hallway here extends to the east, while a set of closed 
        doors stands to the north. ";
      if (!cellDoor.isOpen) {
        "To the south stands a closed door<<slotlikePassingReference>>. ";
      }
      else {
        "An open door<<slotlikePassingReference>> leads south to a cell. ";
      }
    }
  }
  slotlikePassingReference {
    if (!cellDoor2.asscSlotlike)
      return '';
    else if (cellDoor2.isOpen)
      return ', which has a ' + cellDoor2.asscSlotlike.nameForRoom + ' beside it,';
    else 
      return ' with a ' + cellDoor2.asscSlotlike.nameForRoom + ' beside it';
  }
  getDoorForLeavingBuilding = hallDoors
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway3'
  isInColumn = 1
  isInRow = 5
  north =   hallDoors
  east  = hallway4
  south =   cellDoor2
;

hallway4: AlienHallway 'Hallway'
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway4'
  roomDesc() {
    "The hallway branches off here to the north, west, and east. ";
    if (breakDoor.isOpen)
      "To the south, an open door leads to 
        <<seenByPc ? 'a' : 'what appears to be some kind of'>>
        break room. ";
    else
      "To the south stands a closed door. ";
    if (!seenByPc && (youngGuard.isIn(breakRoom) || oldGuard.isIn(breakRoom)))
      "<p>You are standing on the far eastern edge of this part
        of the hallway, so as not to attract the attention of 
        the guard to the south. ";
    seenByPc = true;
  }
  seenByPc = nil
  adjustValues(traveler) {
    if (traveler == gPlayerChar) {
      if (youngGuard.isIn(breakRoom) || oldGuard.isIn(breakRoom)) {
        traveler.xBaseValue = 1;
        if (!seenByPc)
          "You walk west into the next section of hallway. 
            Then, suddenly, your heart
            leaps. Directly through an open door to the south,
            an alien guard is sitting in what appears to be
            some kind of break room. \b
            You remain very still, and you take great care to
            stay on the eastern side of that door. ";
        else
          "You walk into the hallway, taking great care to
            remain far to the east, hopefully out of sight
            of the guard to the south. ";
      }
      else
        traveler.xBaseValue = 0;
      traveler.yBaseValue = 0;
      traveler.xOffset = 0;
      traveler.yOffset = 0;
      seenByPc = true;
    }
    else if (traveler.isActor) {
      traveler.xBaseValue = 0;
      traveler.yBaseValue = 0;
      traveler.xOffset = 0;
      traveler.yOffset = 0;
    }
    //callWithSenseContext(nil, nil, new function { "[hallway4.adjustValues] "; } );
  }
  isInColumn = 2
  isInRow = 5
  south = breakDoor2
  east  = hallway5
  north : OneWayRoomConnector { -> hallway7 travelBarrier=guardBarrier }
  west  : OneWayRoomConnector { -> hallway3 travelBarrier=guardBarrier }
  //north = hallway7
  //west  = hallway3
;

guardBarrier: TravelBarrier 
  canTravelerPass(traveler) {
    if (!youngGuard.isIn(breakRoom) && !oldGuard.isIn(breakRoom))
      return true;
    else
      return nil;
  }
  explainTravelBarrier(traveler) { 
    youDie;
  }
  youDie() {
    "As you start to move in that direction, the alien guard turns
      and sees you! In a flash he grabs his gun and fires
      at you. For a moment you are engulfed in blinding light
      and agonizing pain. Then <<glob.youCollapseToTheFloor>>. ";
    youngGuard.killPcAmusingly;
    //"In case it matters to you, the guard did not intend to
    //  kill you. His weapon was set to <.q>stun,<.q> but it was 
    //  incorrectly callibrated for human beings. When Neton and
    //  Ovan find out about this, they sigh in frustration, 
    //  but they get over it soon enough. What<./s>s one human being, 
    //  more or less? ";
    //reportFailure('');
    endGame(ftDeath);
  }
;

hallway7: AlienHallway 'Hallway'
  "This hallway leads south, to an east-west hallway; 
    and north, further down this part of the hallway. "
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway7'
  isInColumn = 2
  isInRow = 4
  north = hallway8
  south = hallway4
;

hallway8: AlienHallway 'Hallway'
  "The hallway here extends to the south, while 
    <<officeDoor.isOpen 
      ? 'an open door leads east to an office.' 
      : 'a closed door stands to the east.'>> "
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway8'
  isInColumn = 2
  isInRow = 3
  east  =   officeDoor2
  south = hallway7
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: HALLWAY 5
// -------------------------------------------------------------------

hallway5: AlienHallway 'Hallway'
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway5'
  roomDesc() {
    if (!seenByPc)
      "This is an empty, sterile hallway, which ";
    else
      "This hallway ";
    "extends to the west, 
      while a wide doorway leads east to another part of the hallway. ";
    if (dreamDoor.isOpen && bathDoor.isOpen)
      "An open door leads north to the dream room, while another 
        open door leads south to a bathroom. ";
    else if (dreamDoor.isOpen)
      "An open door leads north to the dream room, while a closed
        door leads south. ";
    else if (bathDoor.isOpen)
      "A closed door leads north, while an open door leads south
        to a bathroom. ";
    else 
      "Closed doors lead both north and south. ";
    seenByPc = true;
  }
  seenByPc = nil
  isInColumn = 3
  isInRow = 5
  north =   dreamDoor2
  east  =   hallDoorway2
  south =   bathDoor2
  west  = hallway4
  roomAfterAction {
    if (gActionIs(Open) && gDobj == bathDoor2 && youngGuard.isIn(bathroom)) {
      // Because this output will pre-empt the 'Opened. ' defaultReport,
      // we need to add that report here, but only when 
      // the player types OPEN DOOR, not when the opening
      // is the result of a nested action.
      if (!gAction.parentAction)
        "Opened.<p>";
      "Through the open doorway, the young guard sees you!
          Though he is sitting in an undignified position on a toilet,
          he swiftly rises, grabs his hand cannon, and shoots 
          straight at you. 
        <p>For a moment you are engulfed in blinding light and 
          agonizing pain. Then <<glob.youCollapseToTheFloor>>.";
      youngGuard.killPcAmusingly;
      endGame(ftDeath);
    }
  }
;
//      Two weeks later, the young guard is awarded the 
//          Pin of Competence, <.q>for perfectly 
//          adequate use of force in the elimination of a 
//          human being no longer deemed useful.<./q>
//        <p>These words will be typed and saved within the university
//          archives, where, twenty thousand years later,
//          they will be discovered by historians. 
//          The historians will read this reference to you 
//          with some bemusement.
//        <p>Thus, you can be proud. You have secured for yourself 
//          a kind of immortality. 

//mazePainting: Fixture '(maze) painting/canvas' 'painting'
//  @hallway5
//  "The painting shows a vast and fantastically complicated
//    maze. You decide not to inspect it too closely, as 
//    you<./s>ve spent enough time lately looking at mazes. "
//  specialDesc() {
//    "Adorning the wall here is a painting of a ";
//    if (seenByPc)
//      "maze. ";
//    else
//      "fantastically complicated maze. 
//        As your eyes hit the painting, suddenly you feel a 
//        stab of despair. With the aliens pursuing you
//        in their own building, where could you possibly go
//        to escape them, much less find a way to
//        fight back? ";
//    seenByPc = true;
//  }
//  seenByPc = nil
//  specialDescOrder = 80
//  cannotTakeFixtureMsg = 'The painting is attached to the wall.
//    Even if you grabbed it and pulled as hard as you could,
//    it wouldn<./s>t budge. '
//;

class Sign: Readable
  wordName = 'sign'
;

arrowSign: Sign, Heavy 
  'huge monumental colossal gigantic bright blinking
    sign/arrow/lights'
  'huge sign'
  @hallway5
  "The sign is six feet tall. 
    In bright blinking lights it says, <.q>This way to the 
    Interactive Fiction Museum!<./q> 
    It is shaped like a monumental arrow, and is pointing due east. "
  specialDesc() {
    if (!seenByPc) {
      "As you step out into the hallway, suddenly you feel a 
        stab of despair. With the aliens pursuing you
        in their own building, where could you possibly go
        to escape them, much less find a way to
        fight back? ";
      "<p>Then you see a huge, six-foot-tall sign
        standing nearby. In bright blinking lights
        it says, <.q>This way to the Interactive Fiction Museum!<./q> 
        It is shaped like a 
        monumental arrow, and is pointing due east. ";
    }
    else {
      "A six-foot-tall, arrow-shaped sign is here, pointing 
        to the east. ";
    }
    seenByPc = true;
  }
  seenByPc = nil
  specialDescOrder = 85
  cannotTakeHeavyMsg = 'That sign is bigger than you are. 
    There<./s>s no way you<./s>ll ever budge it. '
  cannotMoveHeavyMsg = cannotTakeHeavyMsg
  cannotTurnOnMsg = 'The sign is already illuminated with bright, 
    blinking lights. I guess that means it<./s>s as on as it<./s>s ever
    going to be. '
  cannotTurnOffMsg = 'There<./s>s no power cord or on/off switch. 
    Looks like you can<./s>t turn it off. '
  dobjFor(Follow) {
    verify { }
    check { }
    action {
      replaceAction(East);
    }
  }
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: HALLWAY 6, including slowing field and drain
// -------------------------------------------------------------------

hallway6: AlienHallway 'Hallway'
  isInFishCorridor = true
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway6'
  roomDesc() {
    "From this hallway, you can go west, through a doorway
      to another part of the hallway; south, ";
    if (confDoor.isOpen)
      "through an open door into a conference room; ";
    else
      "where there is a closed door; ";
    "and north, up a shallow set of stairs to a hallway beyond. ";
    
    if (apparatusThing) {
      "<p>";
      apparatusThing.pseudoSpecialDesc;
      if (buttonThing)
        "Just to the left of it is a <<buttonThing.name>>. ";
      if (slowingSign.isIn(self))
        "<p>To the right of the device is another sign. ";
    }
    else if (slowingSign.isIn(self)) {
      "<p>On the east wall is another sign. ";
      if (buttonThing)
        "To the left of it is a <<buttonThing.name>>. ";
    }
    else if (buttonThing) {
      "On the east wall is a <<buttonThing.name>>. ";
    }
  }
  apparatusThing {
    if (apparatus.isIn(self))
      return apparatus;
    if (apparaus.isIn(self))
      return apparaus;
    return nil;
  }
  buttonThing {
    if (slowingButton.isIn(self))
      return slowingButton;
    if (slowingBuon.isIn(self))
      return slowingBuon;
    return nil;
  }
  adjustValues(traveler) {
    traveler.xOffset = 0;
    traveler.yOffset = 0;
    if (traveler == gPlayerChar && traveler.prevLoc == stairs && slowingField.isOn) {
      traveler.yBaseValue = 2;
      "You enter the hallway, taking care to stop 
        just short of the slowing field. ";
      //traveler.moveIntoForTravel(hallway6North);
    }
    else
      traveler.yBaseValue = 0;
    //callWithSenseContext(nil, nil, new function { "[hallway6.adjustValues] "; } );
    switch (traveler) {
      case neton:  traveler.xBaseValue = -1; break;
      case ovan:   traveler.xBaseValue =  1; break;
      case youngGuard: traveler.xBaseValue = -1; break;
      case oldGuard: traveler.xBaseValue =  1; break;
      default:     traveler.xBaseValue =  0; break;
    }
  }
  roomBeforeAction() {
    local dProblem = nil;
    local iProblem = nil;
    local dAcross = nil;
    local iAcross = nil;
    if (gDobj && ((gActor.yValue>1 && gDobj.yValue<1) 
               || (gActor.yValue<1 && gDobj.yValue>1)))
      dAcross = true;
    if (gIobj && ((gActor.yValue>1 && gIobj.yValue<1) 
               || (gActor.yValue<1 && gIobj.yValue>1)))
      iAcross = true;
    // If the slowing field is not on, there's never any 
    // problem wit the dobj.
    if (!slowingField.isOn)
      dProblem = nil;
    // If it's an implicit action or any other case where there
    // is no dobj, there's no problem.
    else if (!gDobj)
      dProblem = nil;
    // If gDobj is one of a select number of special objects,
    // there's no problem.
    else if (gDobj == slowingField
          || gDobj == noTravel)
      dProblem = nil;
    // If gDobj and gActor are on the same side of the 
    // slowing field (or if one of them is in the slowing
    // field), there's no problem.
    else if (!dAcross)
      dProblem = nil;
    // If gDobj and gActor are by any chance not in the 
    // same room, then we don't need to introduce any 
    // further restrictions here; we already can't usually 
    // deal with any distant things.
    else if (gDobj.getOutermostRoom != gActor.getOutermostRoom)
      dProblem = nil;
    // At this point we know that gDobj and gActor are on 
    // opposite sides of the slowing field.
    // Still, if the action is one of a select group of 
    // actions where interacting with the dobj does not 
    // require touching the dobj, then there's no problem.
    else if (gAction.baseActionClass == ExamineAction
          || gAction.baseActionClass == ReadAction
          || gAction.baseActionClass == ListenToAction
          || gAction.baseActionClass == SmellAction
          || gAction.baseActionClass == AskForAction
          || gAction.baseActionClass == TalkToAction
          || gAction.baseActionClass == AskAboutAction
          || gAction.baseActionClass == TellAboutAction
          || gAction.baseActionClass == ShootWithAction
          || gAction.baseActionClass == ShootAction
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          || gAction.resemblesShoveAction
          )
      dProblem = nil;
    // At this point we know that gDobj and gActor are on
    // opposite sides of the slowing field. Furthermore,
    // we know that the action is one where this type of
    // situation is not permitted. We have a problem.
    else
      dProblem = true;
    // If the slowing field is not on, there's never any 
    // problem with the iobj.
    if (!slowingField.isOn)
      iProblem = nil;
    // If there is no iobj, there's no problem with the iobj.
    else if (!gIobj)
      iProblem = nil;
    // If gIobj is one of a select number of special objects,
    // there's no problem.
    else if (gIobj == slowingField
          || gIobj == noTravel)
      iProblem = nil;
    // If gIobj and gActor are on the same side of the 
    // slowing field (or if one of them is in the slowing
    // field), there's no problem.
    else if (!iAcross)
      iProblem = nil;
    // At this point we know that gIobj and gActor are on 
    // opposite sides of the slowing field.
    // Still, if the action is one of a select group of 
    // actions where interacting with the iobj does not 
    // require touching the iobj, then there's no problem.
    else if (gAction.baseActionClass == ThrowAtAction
          || gAction.baseActionClass == ThrowToAction
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          //|| gAction.baseActionClass == Action
          )
      iProblem = nil;
    // If gIobj and gActor are by any chance not in the 
    // same room, then we don't need to introduce any 
    // further restrictions here; we already can't usually 
    // deal with any distant things.
    else if (gIobj.getOutermostRoom != gActor.getOutermostRoom)
      iProblem = nil;
    // At this point we know that gDobj and gActor are on
    // opposite sides of the slowing field. Furthermore,
    // we know that the action is one where this type of
    // situation is not permitted. We have a problem.
    else
      iProblem = true;
    
    
    
    
    if (dProblem) {
      queryAboutSlowingField(gDobj);
    }
    else if (iProblem) {
      queryAboutSlowingField(gIobj);
    }
      
    //if (dProblem || iProblem) {
    //  "You can<./s>t do that, because ";
    //  if (dProblem)
    //    "{the dobj/he} ";
    //  else
    //    "{the iobj/he} ";
    //  "is on the other side of the slowing field. ";
    //  reportFailure('');
    //  exit;
    //}
    
    
    
    
    
    //if (dProblem) {
    //  "You can<./s>t do that, because {the dobj/he}
    //    is on the other side of the slowing field. ";
    //  reportFailure('');
    //  exit;
    //}
    //else if (iProblem) {
    //  "You can<./s>t do that, because {the iobj/he}
    //    is on the other side of the slowing field. ";
    //  reportFailure('');
    //  exit;
    //}
  }
  roomAfterAction {
    if (gActionIs(Open) && gDobj == confDoor2 && assistant.isIn(confRoom)) {
      // Because this output will pre-empt the 'Opened. ' defaultReport,
      // we need to add that report here, but only when 
      // the player types OPEN DOOR, not when the opening
      // is the result of a nested action.
      if (!gAction.parentAction)
        "Opened.<p>";
      "Through the open doorway, the assistant sees you!
        <p>Swiftly, before you can resist, he rises, jumps, 
          and delivers a lethal blow to your head. ";
      assistant.killPcAmusingly;
      endGame(ftDeath);
    }
  }
  isInColumn = 4
  isInRow = 5
  north : OneWayRoomConnector { ->stairs yValue=2 }
  south = confDoor2
  west  = hallDoorway
  down  = drain
  up      asExit(north)
;

slowingSign: Sign, Fixture
  '(somewhat) large sign'
  'large sign'
  @hallway6
  "The sign reads: \b
    <tt><b>No Running!</b>\n
    We realize you are extremely eager to get
    to the Interactive Fiction Museum. 
    However, please walk carefully. Do not run.
    Some visitors have been trampled 
    and seriously injured by overzealous IF fans. 
    If this happens again, we will be forced
    to activate our slowing field. Thank you.</tt> "
  "Something put up to convey a simple message. "
  yValue = 0
  //specialDescOrder = 85
  //specialDesc =
  //  "To the right of the device is another sign. "
;

apparatus: Fixture
  'tall slowing narrow generator/device/apparatus/machine/circuitry'
  'apparatus'
  @hallway6
  desc {
    "The narrow <<name>> runs all the way from the floor to the ceiling
      along the east wall.
      It consists of metal, glass, and a bit of circuitry. ";
    if (hallway6.buttonThing)
      "There is a <<hallway6.buttonThing.name>> next to it on the left. ";
  }
  //"A large piece of machinery. "
  isOn = slowingField.isOn
  //locationList = [hallway6]
  yValue = 1
  //specialDescOrder = 80
  //specialDesc =
  //  "Along the east wall, a tall, narrow 
  //    apparatus extends from floor to ceiling. 
  //    Just to the left of it is a small button. "
  pseudoSpecialDesc = 
    "Along the east wall, a tall, narrow 
      <<name>> extends from floor to ceiling. "
  cannotTakeFixtureMsg = 'The ' + name + ' is attached to the 
    wall&mdash;indeed, part of the wall. It<./s>s not going
    anywhere. '
  dobjFor(TurnOn) {
    verify() {
      if (slowingField.isOn) 
        illogicalNow('The ' + name + ' is already projecting
          a slowing field at full force. I guess that means it<./s>s
          as on as it<./s>s ever going to get. ');
    }
    check() {
      if (!slowingButton.isIn(hallway6)) {
        "Without a button to push, it<./s>s hard to see
          how you<./s>d activate the <<name>>. ";
        exit;
      }
    }
    action() {
      nestedAction(Push, slowingButton);
    }
  }
  dobjFor(TurnOff) {
    verify() {
      if (!slowingField.isOn) 
        illogicalNow('The ' + name + ' seems totally inert
          right now. I guess that means it<./s>s as off as it<./s>s 
          ever going to get. ');
    }
    check() {
      if (!slowingButton.isIn(hallway6)) {
        "Without a button to push, it<./s>s hard to see
          how you<./s>d deactivate the slowing field. ";
        exit;
      }
    }
    action() {
      nestedAction(Push, slowingButton);
    }
  }
  // Basically, a Y value of either 0, 1, or 2 is acceptable;
  // therefore, return whichever is easiest for the actor.
  proxyYValueForGoingNear {
    if (gActor.isIn(hallway6)) {
      if (gActor.yValue == 1) return 1;
      if (gActor.yValue == 2) return 2;
      return 0;
    }
    else if (gActor.getOutermostRoom is in 
             (museum, skyway, hallway9, stairs))
      return 2;
    else
      return 0;
  }
  // Just get within 1 yValue unit of the apparatus/slowing field.
  // Don't worry about anything beyond that.
  moveActorNearThis(actor) {
    if (getOutermostRoom != museum)
      return;
    if (actor.xValue == xValue && actor.yValue == yValue)
      return;
    actor.yBaseValue = self.yValue;
    actor.xBaseValue = proxyXValueForGoingNear;
    //callWithSenseContext(nil, nil, new function { "[Pedestal.moveActorNearThis] "; } );
    actor.doXYConsequences;
  }
  zapT = transform(self, apparaus)
  zapTCq {
    if (slowingField.isOn) {
      "<.p>Abruptly, the slowing field disappears. 
        Apparently apparauses aren<./s>t very good at
        emitting such fields. ";
      if (slowingField.ofKind(ShadowCaster))
        slowingField.scMoveInto(nil);
      else
        slowingField.moveInto(nil);
    }
  }
  zapRemoveCq {
    if (slowingField.isOn) {
      "<.p>Abruptly, the slowing field disappears as well. ";
      if (slowingField.ofKind(ShadowCaster))
        slowingField.scMoveInto(nil);
      else
        slowingField.moveInto(nil);
    }
  }
;

apparaus: Fixture, Nonsense
  'apparaus'
  'apparaus'
  pseudoSpecialDesc = 
    "On the east wall is an apparaus. "
  yValue = 1
;

class Buon: Fixture, Nonsense
  dobjFor(Push) {
    verify { }
    action { reportFailure(&pushNoEffectMsg); }
  }
;
slowingBuon: Buon
  'small buon'
  'small buon'
  yValue = 2
;

slowingButton: Button, Fixture
  'tiny small little button'
  'small button'
  @hallway6
  desc {
    "It<./s>s a small button";
    if (hallway6.apparatusThing)
      ", just to the left of <<hallway6.apparatusThing.theName>>";
    ". ";
  }
  //"A key you can push. "
  yValue = 2
  //warningValue = 0
  isOn = slowingField.isOn
  //hasBeenPushed = nil
  dobjFor(Push) {
    verify {
      nonObvious;
    }
    action {
      if (!apparatus.isIn(hallway6)) {
        "You push the button. Nothing seems to happen. ";
      }
      // Slowing field is presently OFF and we need to
      // decide if we want to turn it on.
      else if (!isOn) {
        nbmBanner.updateMe;
        //sfActivateMenu.select;
        "You push the button. 
          <p>From somewhere above, a voice says, 
            <.q>Welcome to the SlowTron 3,
            by EmitterSolutions. If you wish to activate 
            the slowing field, please signal your 
            confirmation by pressing the button 
            once more.<./q> ";
        "<p>Do you wish to push the button again? 
          <p>Please type yes or no >> ";
        if (!yesOrNo()) {
          "Deciding not to push the button again, you 
            turn your attention back to the room. ";
        }
        else {
          "You push the button again.
            <p>From somewhere above, a voice says,
              <.q>Attention. The slowing field is now
              being activated. Please stand clear.<./q>
            <p>And with that, a curtain of blue light
              instantly comes from the 
              <<hallway6.apparatusThing 
              ? hallway6.apparatusThing.theName + ' on' : ''>>
              the east wall, completely blocking off the northern extremity
              of this hallway";
          if (gPlayerChar.isIn(hallway6) && gPlayerChar.yValue > 1)
            " (where you<./s>re standing)";
          " from the rest of the room";
          if (gPlayerChar.isIn(hallway6) && gPlayerChar.yValue < 1)
            " (where you<./s>re standing)";
          ". ";
          slowingField.scMoveInto(hallway6);
          slowingField.hasEverBeenOn = true;
        }
      }
      // Slowing field is presently ON and we need to
      // decide if we want to turn it off.
      else {
        "You push the button. 
          <p>From somewhere above, a voice says, 
            <.q>Welcome to the SlowTron 3,
            by EmitterSolutions. Retinal scan
            confirms that you are the one who
            activated the slowing field.
            If you wish to deactivate 
            the slowing field, please signal your 
            confirmation by pressing the button 
            once more.<./q> ";
        "<p>Do you wish to push the button again? 
          <p>Please type yes or no >> ";
        if (!yesOrNo()) {
          "Deciding not to push the button again, you 
            turn your attention back to the room. ";
        }
        else {
          "You push the button again.
            <p>From somewhere above, a voice says,
              <.q>Attention. The slowing field is now
              being deactivated. Please stand clear.<./q>
            <p>With that, the blue curtain of light
              instantly disappears. ";
          "";
          slowingField.scMoveInto(nil);
        }
      }
    }
  }
  //dobjFor(Push) {
  //  action {
  //    if (!apparatus.isIn(hallway6)) {
  //      "You push the button. Nothing seems to happen. ";
  //    }
  //    else if (!isOn) {
  //      nbmBanner.updateMe;
  //      sfActivateMenu.select;
  //    }
  //    else { // presently on; turn it off
  //      nbmBanner.updateMe;
  //      sfDeactivateMenu.select;
  //    }
  //  }
  //}
  zapT = transform(self, slowingBuon)
;

// Note to self: Having this object inherit from TravelBarrier
// and ThroughPassage caused a lot of bugs, including some 
// game-crashing bugs, with no apparent advantages that I could
// discern as of Dec. 9, 2008. So don't reinstate inheritance
// from TravelBarrier and ThroughPassage unless you *really,
// really* know what you're doing.

slowingField: ShadowCaster, /*TravelBarrier, ThroughPassage,*/ Vaporous
  'blue curtain light slowing (force) field/forcefield'
  'slowing field'
  //realLocation = hallway6
  nearDesc {
    "A curtain of blue light, apparently a slowing field, 
        is being emitted across the hallway from 
        <<hallway6.apparatusThing 
        ? hallway6.apparatusThing.theName + ' on' : ''>>
        the east wall. Extending from floor to ceiling and
        wall to wall, it completely blocks off the northern extremity
        of this hallway";
    if (gPlayerChar.isIn(hallway6) && gPlayerChar.yValue > 1)
      " (where you<./s>re standing)";
    " from the rest of the room";
    if (gPlayerChar.isIn(hallway6) && gPlayerChar.yValue < 1)
      " (where you<./s>re standing)";
    ". ";
    "It looks incorporeal enough to allow someone to walk through
      it, though such an action would not necessarily be advisable. ";
  }
  //whatDesc = "It<./s>s hard to say what that is. "
  //shadowLocation = hallway6
  //scLocationList = [hallway6, museum, skyway, hallway9, stairs, confRoom]
  occludeShadow {
    if (isIn(hallway6))
      return nil;
    else
      return true;
  }
  isOn = (realLocation == hallway6)
  hasEverBeenOn = nil
  yValue = 1
  //yesActive = nil
  yesState = 0
  canTravelerPass(traveler) { return !isOn; }
  k = 2 // Note to self: why is this here?
  k2 = 10000 // Note to self: why is this here?
  prevActionClass = nil
  prevActionPhrase = ''
  prevDobj = nil
  prevIobj = nil
  //explainTravelBarrier(traveler) {
  //  if (yesActive == nil) {
  //    "Are you sure you want to step into that slowing field";
  //    if ( neton.location != nil ||
  //          ovan.location != nil ||
  //    youngGuard.location != nil ||
  //      oldGuard.location != nil ||
  //     assistant.location != nil)
  //      " while the aliens are pursuing you? ";
  //    else
  //      "? ";
  //    yesState = 1;
  //    yesActive = true;
  //    ncYesNo.set(
  //      // YES:
  //      new function { nestedAction(TravelVia, self); },
  //      // NO:
  //      'Wise decision. '
  //    );
  //  }
  //  else {
  //    "Okay. The slowing field kills you. ";
  //    gPlayerChar.yBaseValue = 1;
  //    //callWithSenseContext(nil, nil, new function { "[slowingField.explainTravelBarrier] "; } );
  //    endGame(ftDeath);
  //  }
  //}
  dobjFor(TurnOff) remapTo(TurnOff, apparatus)
  hasSlowedNpcs = nil
  dobjFor(TravelVia) {
    verify { }
    preCond = []
    check { }
    action {
      queryAboutSlowingField(nil);
      //if (slowingField.yesActive == nil) {
      //  "Are you sure you want to step into that slowing field";
      //  if ( neton.realLocation != nil ||
      //        ovan.realLocation != nil ||
      //  youngGuard.realLocation != nil ||
      //    oldGuard.realLocation != nil ||
      //   assistant.realLocation != nil)
      //    " while the aliens are pursuing you";
      //  "? ";
      //  slowingField.yesState = 1;
      //  slowingField.yesActive = true;
      //  // Force this to be a meta-verb.
      //  gAction.actionTime = 0;
      //  ncYesNo.set(
      //    // YES:
      //    new function { nestedAction(TravelVia, slowingField); },
      //    // NO:
      //    'Wise decision. '
      //  );
      //}
      //else {
      //  deathBySlowingField();
      //}
    }
  }
  dobjFor(GoThrough) asDobjFor(TravelVia)
  dobjFor(Enter) asDobjFor(TravelVia)
  dobjFor(Shoot) {
    verify {
      inherited;
    }
  }
  dobjFor(ShootWith) {
    verify {
      inherited;
    }
  }
  shootEffectProp = &shootEffectWindow
;

tellOfSlowingQueryInfo() {
  //"slowingField.yesActive == <<slowingField.yesActive ? 'true' : 'nil'>> ";
  "<font color=blue>";
  "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td align=\"right\"><<slowingField.yesState>></td>
      <td>&nbsp;= sf.yesState</td>
    </tr>
    <tr> 
      <td align=\"right\">sf.prevAction (phrase) =&nbsp;</td>
      <td><<slowingField.prevActionPhrase ? slowingField.prevActionPhrase : 'nil or unknown'>></td>
      <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td align=\"right\"><<gAction && gAction.verbPhrase ? gAction.verbPhrase : 'nil or unknown'>></td>
      <td>&nbsp;= gAction (phrase)</td>
    </tr>
    <tr> 
      <td align=\"right\">sf.prevDobj (name) =&nbsp;</td>
      <td><<slowingField.prevDobj ? slowingField.prevDobj.theName : 'nil'>></td>
      <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td align=\"right\"><<gDobj ? gDobj.theName : 'nil'>></td>
      <td>&nbsp;= gDobj (name)</td>
    </tr>
    <tr> 
      <td align=\"right\">sf.prevIobj (name) =&nbsp;</td>
      <td><<slowingField.prevIobj ? slowingField.prevIobj.theName : 'nil'>></td>
      <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
      <td align=\"right\"><<gIobj ? gIobj.theName : 'nil'>></td>
      <td>&nbsp;= gIobj (name)</td>
    </tr>
  </table>";
  "</font>";
  //"sf.yesState == <<slowingField.yesState>> ";
  //"<br>sf.prevActionPhrase == \"<<slowingField.prevActionPhrase ? slowingField.prevActionPhrase : 'nil or unknown'>>\" /
  //    gAction's phrase == \"<<gAction && gAction.verbPhrase ? gAction.verbPhrase : 'nil or unknown'>>\"
  //  <br>sf.prevDobj == <<slowingField.prevDobj ? slowingField.prevDobj.theName : 'nil'>> /
  //    gDobj == <<gDobj ? gDobj.theName : 'nil'>>
  //  <br>sf.prevIobj == <<slowingField.prevIobj ? slowingField.prevIobj.theName : 'nil'>> /
  //    gIobj == <<gIobj ? gIobj.theName : 'nil'>> 
  //  <br>";
}

queryAboutSlowingField(obj) {
  //tellOfSlowingQueryInfo();
  
  ////"slowingField.yesActive == <<slowingField.yesActive ? 'true' : 'nil'>> ";
  //"slowingField.yesState == <<slowingField.yesState>> ";
  //"<br>sf.prevActionPhrase == \"<<slowingField.prevActionPhrase ? slowingField.prevActionPhrase : 'nil or unknown'>>\" /
  //    gAction's phrase == \"<<gAction && gAction.verbPhrase ? gAction.verbPhrase : 'nil or unknown'>>\"
  //  <br>sf.prevDobj == <<slowingField.prevDobj ? slowingField.prevDobj.theName : 'nil'>> /
  //    gDobj == <<gDobj ? gDobj.theName : 'nil'>>
  //  <br>sf.prevIobj == <<slowingField.prevIobj ? slowingField.prevIobj.theName : 'nil'>> /
  //    gIobj == <<gIobj ? gIobj.theName : 'nil'>> 
  //  <br>";
  if (!slowingField.yesState || 
      slowingField.prevActionClass != gAction.baseActionClass ||
      slowingField.prevDobj != gDobj ||
      slowingField.prevIobj != gIobj) {
    if (!obj) {
      //"<<gAction.getParticiplePhrase()>>: ";
      "Are you sure you want to step into that slowing field";
      if ( neton.realLocation != nil ||
            ovan.realLocation != nil ||
      youngGuard.realLocation != nil ||
        oldGuard.realLocation != nil ||
       assistant.realLocation != nil)
        " while the aliens are pursuing you";
      "? ";
    }
    else {
      //"<<gAction.getParticiplePhrase()>>: ";
      "To reach <<obj.theName>>, you<./s>d have to go 
        through the slowing field. Are you sure you want 
        to do that? ";
      reportFailure('');
    }
    //slowingField.yesState = 2;
    slowingField.yesState = 2;
    slowingField.prevActionClass = gAction.baseActionClass;
    slowingField.prevActionPhrase = gAction.verbPhrase;
    slowingField.prevDobj = gDobj;
    slowingField.prevIobj = gIobj;
    
    // Force this to be a meta-verb.
    gAction.actionTime = 0;
    ncYesNo.set(
      // YES:
      //new function { nestedAction(TravelVia, slowingField); },
      //'No! Bad! Don\'t! ',
      new function { deathBySlowingField(); },
      // NO:
      'Wise decision. '
    );
    //tellOfSlowingQueryInfo();
    
    ////"<p>slowingField.yesActive == <<slowingField.yesActive ? 'true' : 'nil'>> ";
    //"<p>slowingField.yesState == <<slowingField.yesState>> ";
    //"<br>sf.prevActionPhrase == \"<<slowingField.prevActionPhrase ? slowingField.prevActionPhrase : 'nil or unknown'>>\" /
    //    gAction's phrase == \"<<gAction && gAction.verbPhrase ? gAction.verbPhrase : 'nil or unknown'>>\"
    //  <br>sf.prevDobj == <<slowingField.prevDobj ? slowingField.prevDobj.theName : 'nil'>> /
    //    gDobj == <<gDobj ? gDobj.theName : 'nil'>>
    //  <br>sf.prevIobj == <<slowingField.prevIobj ? slowingField.prevIobj.theName : 'nil'>> /
    //    gIobj == <<gIobj ? gIobj.theName : 'nil'>> 
    //  <br>";
  }
  else {
    deathBySlowingField();
  }
}

deathBySlowingField() {
  //"<<gAction.getParticiplePhrase()>>: ";
  reportFailure('');
  "Boldly, you stride into the slowing field, 
    which freezes you in your tracks. ";
  if (slowingField.hasSlowedNpcs)
    "In fact, it slows you a lot more strongly than
      it did the aliens. Perhaps its effect 
      is more powerful on humans, but in any case, 
      the upshot is that you are effectively paralyzed. ";
  else
    "So greatly are you slowed, in fact, that
      you are effectively paralyzed. ";
  local livingNpcs = [neton, ovan, oldGuard, youngGuard, assistant];
  local livingNpcLists = 
    [[neton, ovan], [youngGuard, oldGuard], [assistant]];
  for (local a = livingNpcs.length; a >= 1; a--) {
    if (!livingNpcs[a].realLocation)
      livingNpcs = livingNpcs.removeElementAt(a);
  }
  for (local a = livingNpcLists.length; a >= 1; a--) {
    livingNpcLists[a] = livingNpcLists[a].intersect(livingNpcs);
    if (livingNpcLists[a].length == 0) {
      livingNpcLists = livingNpcLists.removeElementAt(a);
    }
  }
  if (livingNpcLists.length >= 3) {
    livingNpcs = livingNpcs.removeElementAt(livingNpcs.length);
    livingNpcLists = livingNpcLists.removeElementAt(3);
  }
  for (local a = livingNpcs.length; a >= 1; a--) {
    if (livingNpcs[a].realLocation == bathroom)
      bathDoor.makeOpen(true);
    if (livingNpcs[a].realLocation == confRoom)
      confDoor.makeOpen(true);
    livingNpcs[a].moveIntoForTravel(hallway6);
    livingNpcs[a].yBaseValue = 0;
  }
  local usePronoun = true;
  //local k = 0; k=k/k;
  if (livingNpcs.length) {
    "<p>As a result, there is plenty of time for ";
    for (local a = 1; a <= livingNpcLists.length; a++) {
      simpleLister(livingNpcLists[a], &theName);
      if (a == 1)
        " to<<livingNpcLists[a][1].isStunned 
          ? ' wake up and then' : ''>> stride over to you";
      if (a < livingNpcLists.length)
        ", followed by ";
    }
    ". ";
    if (livingNpcLists[1].indexOf(neton) ||
        livingNpcLists[1].indexOf(ovan)) {
      if (livingNpcLists[1].indexOf(neton)) {
        "<p><.q>So,<./q> says Neton. <.q>The human is 
            smart enough to finish our maze game,
            but not smart enough to keep from slowing
            himself to a stand-still.<./q> ";
        if (livingNpcLists[1].indexOf(ovan)) {
          "<p><.q>What a fool!<./q> cries Ovan.
            <p>";
          usePronoun = nil;
        }
      }
      else {
        "<p><.q>I don<./s>t believe it!<./q> cries Ovan.
            <.q>He doesn<./s>t even know enough to keep
            from slowing himself to a stand-still? 
            What a fool!<./q> ";
      }
      "With that, 
          <<usePronoun ? 'he' : livingNpcLists[1][1].theName>> ";
      if (livingNpcLists.length <= 1) {
        "casually leans over and pokes his icepick into
            your ribs. ";
        livingNpcLists[1][1].standardWeapon.deathParagraph(nil, nil);
        livingNpcLists[1][1].killPcAmusingly;
        endGame(ftDeath);
      }
      else {
        "turns to <<livingNpcLists[2][1].theName>> and says, ";
        if (livingNpcLists[1].indexOf(neton))
          "<.q>Please dispose of the prisoner.<./q> ";
        else
          "<.q>You can go ahead and kill him whenever.<./q> ";
        livingNpcLists[2][1].standardWeapon.attackUnderOrdersParagraph;
        livingNpcLists[2][1].killPcAmusingly;
        endGame(ftDeath);
      }
    }
    else {
      "<p>Unfortunately for you, university policy
          clearly states that although humans are
          sometimes useful, they are not worth keeping 
          if they cause a lot of trouble. Accordingly, 
          <<livingNpcLists[1][1].theName>>
          wastes no time, promptly ";
      glob.imminentDeathBySlowingField = true;
      livingNpcLists[1][1].standardWeapon.assaultingYouDesc;
      livingNpcLists[1][1].standardWeapon.deathParagraph(nil, nil);
      livingNpcLists[1][1].killPcAmusingly;
      endGame(ftDeath);
    }
  }
  else {
    "<p>As a result, in two hours, when a visitor arrives
        to take a tour of the museum and finds a
        paralyzed human on the loose, there is plenty of time 
        for him to flee and speed-dial campus security.
        And there is plenty of time for a guard to come 
        and deal with the situation. 
      <p>Unfortunately for you, university policy
        clearly states that although humans are
        sometimes useful, they are not worth keeping 
        if they cause a lot of trouble. Accordingly, 
        the guard wastes no time, promptly ";
    glob.imminentDeathBySlowingField = true;
    youngGuard.standardWeapon.assaultingYouDesc;
    youngGuard.standardWeapon.deathParagraph(nil, nil);
    youngGuard.killPcAmusingly;
  }
  glob.imminentDeathBySlowingField = true;
  gPlayerChar.yBaseValue = 1;
  endGame(ftDeath);
}

modify glob
  imminentDeathBySlowingField = nil
;

//slowingFieldShadow: Shadow, PresentLater, Distant
//  locationList = [hallway4, hallway5, hallway6, hallway1, hallway2]
//  asscThing = slowingField
//;

noDrain: MultiLoc, Unthing
  '(hitherto) (previously) (unnoticed) (large) (small) (big) (hole) pit/drain'
  'large drain'
  locationList = [museum, skyway, hallway9, stairs, //confRoom, 
    hallway3, hallway4, hallway5, hallway6]
  whatDesc = "A hole in a floor. "
  notHereMsg = 'What drain? There<./s>s no drain here. At least,
    none that you notice. '
;

//drainShadow: Shadow
//  '(hitherto) (previously) unnoticed (large) (big) drain/hole/pit'
//  'large drain'
//  locationList = [museum, skyway, hallway9, stairs, confRoom, 
//    hallway3, hallway4, hallway5]
//  asscThing = drain
//;

class Drainlike: object
  //@hallway6
  //shadowLocation = hallway6
  //realLocation = hallway6
  occludeShadow {
    if (location == nil)
      return true;
    else
      return nil;
  }
  //isScrambled = nil
  yValue = 0
  //desc {
  nearDesc{
    if (!drain.referredToByPC) {
      "By God, there is a huge drain here";
      //if (isScrambled)
      //  ", which represents the nadir, or lowest point, in the room";
      ". ";
      "You didn<./s>t notice it the first time you were here. ";
      "The drain ";
    }
    //else if (isScrambled) {
    //  "This drain represents the nadir, or lowest point, in the room. 
    //    It ";
    //}
    else {
      "The drain ";
    }
    "is about three feet across, and it is impossible 
      to tell how deep it is. Your footsteps echo as you walk 
      near it, making you a bit nervous. ";
    drain.referredToByPC = true;
  }
  whatDesc = "A hole in a floor. "
  soundDesc = "Your footsteps produce echoes from very deep,
    seemingly from miles down below this drain.
    Also, is that a slithering sound down there? You think
    you hear something from deep in the pit beneath the drain.
    On the other hand, it might just be your imagination. "
  smellDesc = "Now that you mention it, there is a faint smell
    of rankness coming up from the drain. "
  feelDesc = "Your self-preservation instinct kicks in, and you
    decide not to touch the drain. "
  tasteDesc = (feelDesc)
  dobjFor(Eat) asDobjFor(Taste)
  dobjFor(Drink) asDobjFor(Taste)
;

//drain: StairwayDown, NoTravelMessage // not a FormerShadowCaster. But why? Shouldn't it be?
drain: Drainlike, ShadowCaster, StairwayDown, NoTravelMessage // not a FormerShadowCaster. But why? Shouldn't it be?
  '(hitherto) (previously) unnoticed (large) (big) drain/hole/pit'
  'drain'
  //name {
  //  if (!isScrambled)
  //    return 'drain';
  //  else
  //    return 'nadir';
  //}
  yesState = 0
  yesActive = nil
  referredToByPC = nil
  travelDesc() {
    if (drain.location == nil)
      "You fail to notice any way of going down here. ";
    else if (yesState == 0) {
      self.referredToByPC = true;
      "Just one look at that drain";
      //"<<isScrambled ? ', which represents the nadir of the room,' : ''>>";
      " makes you shudder. First of all,
        it empties down into a pitch black hole, and who knows
        what<./s>s down there. Secondly, this might be your imagination,
        but you think you hear a sound down there, like that of
        monsters and snakes slithering, although it<./s>s hard to be sure.
        Furthermore, the sides of the hole 
        are slick with slime, so that there is absolutely no way of
        lowering yourself down safely; you would just have to drop and let
        yourself fall. On top of that, there is the sheer depth of the pit;
        from the way your footsteps echo endlessly inside,
        you bet you<./s>d surely die if you let yourself fall down.
        But even that is not the biggest reason
        to avoid the drain. The biggest reason is this: 
        you feel, more strongly than you have ever felt anything 
        in your life, that going down there would be utterly
        useless. And you generally prefer not to risk your life
        for no reason.\b
        Now, do you still want to go down the drain? ";
      yesState = 1;
      yesActive = true;
      ncYesNo.set(
        // YES:
        new function { nestedAction(TravelVia, gActor.location.down); },
        // NO:
        'Good choice. '
      );
    }
    else if (yesState == 1) {
      "You can<./s>t be serious. Are you absolutely positive you
        want to go down <i>there?</i> ";
      yesState = 2;
      yesActive = true;
      ncYesNo.set(
        // YES:
        new function {
          //nestedAction(TravelVia, gActor.location.down);
          drain.travelDesc;
        },
        // NO:
        'Good choice. '
      );
    }
    //else if (yesState == 2) {
    //  "Are you really, <i>really</i> sure? ";
    //  yesState = 3;
    //  yesActive = true;
    //  ncYesNo.set(
    //    // YES:
    //    new function {
    //      //nestedAction(TravelVia, gActor.location.down);
    //      drain.travelDesc;
    //    },
    //    // NO:
    //    'Wise decision. '
    //  );
    //}
    else {
      "Okay. You die. ";
      endGame(ftDeath);
    }
  }
  dobjFor(Enter) asDobjFor(ClimbDown)
  //wordName = (isScrambled ? 'nadir of the hallway' : 'drain')
  zapAry {
    if (glob.doAryText) {
      local drainIndex = aryUngList.value.indexOf('drain=nadir');
      local nadirIndex = aryUngList.value.indexOf('nadir=drain');
      if (!drainIndex) {
        "The drain is transformed into a nadir! However, since
          the drain already <i>is</i> the hallway<./s>s nadir, 
          or lowest point,
          this makes little noticeable difference. ";
        achieveTransformationAry('drain', 'nadir');
      }
      else if (!nadirIndex) {
        "The building<./s>s nadir is transformed into a drain!
          However, since the building<./s>s lowest point
          already <i>is</i> the drain, 
          this makes little noticeable difference. ";
        //"The nadir, or drain, or whatever it is, is transformed 
        //  into&mdash;well, it remains the same. That is, it<./s>s now a drain. Or a nadir. ";
        achieveTransformationAry('nadir', 'drain');
      }
      else {
        "The drain, or nadir, or whatever it is, remains as much of 
          a drain or a nadir as it's ever going to be. ";
      }
    }
    return true;
  }
;

nadir: Drainlike, ShadowCaster, Fixture
  'nadir'
  'nadir'
  dobjFor(Enter) remapTo(ClimbDown, drain)
  dobjFor(Climb) remapTo(ClimbDown, drain)
  dobjFor(ClimbDown) remapTo(ClimbDown, drain)
  dobjFor(TravelVia) remapTo(TravelVia, drain)
  nearDesc =
    "The nadir of the building&mdash;that is,
      its lowest point&mdash;is 
      the large drain here in the center of the floor. "
  zapAry {
    if (glob.doAryText) {
      "The building<./s>s nadir is transformed into a drain!
        However, since the building<./s>s lowest point
        already <i>is</i> the drain, the result
        is purely nominal. ";
      achieveTransformationAry('nadir', 'drain');
    }
    return true;
  }
;

modify Action
  resemblesShoveAction = nil
;

/*
sfActivateMenu: QMain
  reply {
    "You push the button. 
      <p>From somewhere above, a voice says, 
        <.q>Welcome to the SlowTron 3,
        by EmitterSolutions. If you wish to activate 
        the slowing field, please signal your 
        confirmation by pressing the button 
        once more.<./q> ";
  }
  options = [
    sfActivateYes,
    sfActivateNo
  ]
  killZ = true
  quipQuestion = 'What would you like to do?'
;

sfActivateYes: Quip
  desc = "Push the button again "
  reply {
    "You push the button again.
      <p>From somewhere above, a voice says,
        <.q>Attention. The slowing field is now
        being activated. Please stand clear.<./q>
      <p>And with that, a curtain of blue light
        instantly comes from the 
        <<hallway6.apparatusThing 
        ? hallway6.apparatusThing.theName + ' on' : ''>>
        the east wall, completely blocking off the northern extremity
        of this hallway";
    if (gPlayerChar.isIn(hallway6) && gPlayerChar.yValue > 1)
      " (where you<./s>re standing)";
    " from the rest of the room";
    if (gPlayerChar.isIn(hallway6) && gPlayerChar.yValue < 1)
      " (where you<./s>re standing)";
    ". ";
    slowingField.scMoveInto(hallway6);
  }
;

sfActivateNo: Quip
  desc = "Don<./s>t push the button again "
  reply {
    "Deciding not to push the button again, you turn your 
      attention back to the room. ";
  }
;

sfDeactivateMenu: QMain
  reply {
    "You push the button. 
      <p>From somewhere above, a voice says, 
        <.q>Welcome to the SlowTron 3,
        by EmitterSolutions. Retinal scan
        confirms that you are the one who
        activated the slowing field.
        If you wish to deactivate 
        the slowing field, please signal your 
        confirmation by pressing the button 
        once more.<./q> ";
  }
  options = [
    sfDeactivateYes,
    sfDeactivateNo
  ]
  killZ = true
  quipQuestion = 'What would you like to do?'
;

sfDeactivateYes: Quip
  desc = "Push the button again "
  reply {
    "You push the button again.
      <p>From somewhere above, a voice says,
        <.q>Attention. The slowing field is now
        being deactivated. Please stand clear.<./q>
      <p>And with that, the blue curtain of light
        instantly disappears. ";
    slowingField.scMoveInto(nil);
  }
;

sfDeactivateNo: Quip
  desc = "Don<./s>t push the button again "
  reply {
    "Deciding not to push the button again, you turn your 
      attention back to the room. ";
  }
;
*/

// -------------------------------------------------------------------
// BUILDING: ROOMS: STAIRS, HALLWAY 9, & SKYWAY
// -------------------------------------------------------------------

stairs: AlienHallway 'Stairs'
  "You are on a set of exceedingly shallow stairs; 
    the entire staircase ascends no more than four or five feet. 
    The stairs lead upwards to the north 
    and downwards to the south, each direction taking
    you to different parts of the same hallway. "
  vocabWords       = 'room'
  shadowVocabWords = ''
  isInColumn = 4
  isInRow = 4
  isInFishCorridor = true
  isPlural = true
  objInPrep = 'on'
  roomParts = [defaultCeiling, defaultWalls, stairsFloor]
  north = hallway9
  south = hallway6
  up      asExit(north)
  down    asExit(south)
;

// If a person types "examine stairs," they are unlikely to expect a 
// description of the room. Create a different 'stairs' object 
// to examine instead.
//
// I'm not sure how it will work to have a RoomPart as a ShadowCaster,
// but I'll try it out and see how it works.
stairsFloor: FormerRoomShadowCaster, Floor
  'stairs/stair/stairway/staircase/(set)/floor'
  'stairs'
  //@stairs
  "These stairs are exceedingly shallow; the entire staircase 
    ascends no more than four or five feet. "
  shadowVocabWords = 'stairs/stair/stairway/staircase/(set)'
  shadowList = [museum, skyway, hallway9, hallway6, confRoom]
  shadowDesc = "The stairs are shallow, and are visible 
    <<gActor.getOutermostRoom is in (museum, skyway, hallway9)
      ? 'to the south' : 'to the north'>>. "
  isPlural = true
  initShadow(obj) {
    obj.realLocation = stairs;
  }
  dobjFor(Enter) {
    verify {
      illogicalAlready('{You\'re} already on the stairs. ');
    }
  }
  dobjFor(GoThrough) asDobjFor(Enter)
  dobjFor(ClimbUp) {
    verify { }
    action {
      replaceAction(North);
    }
  }
  dobjFor(Climb) asDobjFor(ClimbUp)
  dobjFor(ClimbDown) {
    verify { }
    action {
      replaceAction(South);
    }
  }
  zapT = die(
    'The stairs are transformed into sairs, whatever they are.
      <p>Say what you will about sairs, but they do a very poor
        job of contributing to the structural integrity 
        of the building. With a creak, a groan, and finally
        a roar, some of the walls begin to collapse. After that
        the ceiling comes too, and you are hit by a massive chunk
        of falling debris. '
    , 'sairs', self, killEverybody, nonsenseTransformation
  )
  zapAry = die(
    'The stairs are transformed into a collection of sitars!
      <p>Say what you will about sitars, but they do a very poor
        job of contributing to the structural integrity 
        of the building. With a creak, a groan, and finally
        a roar, some of the walls begin to collapse. After that
        the ceiling comes too, and you are hit by a massive chunk
        of falling debris. '
    , 'sitars', self, killEverybody
  )
;

hallway9: AlienHallway 'Hallway'
  "This hallway extends north, into a kind of skyway;
    and south, to a set of stairs. "
  //"This is much like the other hallways in this
  //  building, except that its floor is made of green
  //  glass. To the north there is a kind of skyway, 
  //  and beyond it a museum. To the south, you can see 
  //  the stairs, the hallway, and the 
  //  <<confDoor.isOpen ? 'conference room' : 'closed door'>>
  //  beyond. "
  vocabWords       = 'room'
  shadowVocabWords = ''
  roomIdentifierStr = 'Hallway9'
  isInColumn = 4
  isInRow = 3
  isInFishCorridor = true
  north = skyway
  south = stairs
  down    asExit(south)
;

skyway: AlienHallway, FormerRoomShadowCaster, AlienRoom 'Skyway'
  "This skyway is lined on both sides with large windows 
    of clear plastic, offering
    you a fine view of the world outside. 
    For all the tantalizing view, however, the windows 
    are bolted tightly, and offer no means of escape. 
    From here you can only go south, 
    back to the building you started out in;
    or north, into the museum. "
  // vocabWords probably should include "passage". Same for hallways.
  //"This is a skyway, which stands one story up off the ground
  //  and allows passage between the building to the south 
  //  and the one to the north. It is quite a place,
  //  in that its floor, walls, and ceiling are all made of green
  //  glass, allowing you to see to the outside world all around
  //  you (although, alas, there seems to be no way out). 
  //  Directly to your north is the Interactive Fiction
  //  Museum, while to your south is a hallway, a set of stairs,
  //  another hallway, and finally 
  //  <<confDoor.isOpen
  //    ? 'a conference room'
  //    : 'a closed door'>> beyond. "
  vocabWords = 'skyway/room'
  nearStateTokens = ['room']
  //shadowVocabWords = 'skyway'
  //shadowList = [museum, hallway9, stairs, hallway6, confRoom]
  //nearestHallway = hallway9
  isInColumn = 4
  isInRow = 2
  isInFishCorridor = true
  north = museum
  south = hallway9
;

skywayWindows: Window
  '(skyway) large clear plastic (plate) glass window/windows'
  'windows'
  @skyway
  "Large windows take up most of the walls to the west and east.
    Through them you can see the grass and trees of the world outside.
    Unfortunately, however, the windows don<./s>t look to be 
    openable. "
  isPlural = true
  unfortunateBarrier = true
  dobjFor(LookThrough) {
    verify { }
    action {
      skywayOutside.desc;
    }
  }
;

class OutsideWorld: Distant
;

skywayOutside: OutsideWorld
  'grass trees sun sky clouds outside world scene university campus 
    road roads path paths lawn lawns tree trees buildings building 
    distant distance -'
  'outside world'
  @skyway
  "Through the windows to either side, you see a scene that reminds you
    of a university campus, with buildings stretching off 
    into the distance, and paths running between them, 
    amidst grassy lawns and a few trees. Too bad you are
    separated from it all by thick, sturdy windows. "
  dobjFor(ShootWith) maybeRemapTo(gIobj != nil, ShootWith, skywayWindows, gIobj)
  separatorFromPov(pov) {
    // No matter who or what other thing we are being considered
    // in relation to, that thing should be on the 
    // other side of the skywayWindows.
    return skywayWindows;
  }
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: DREAM ROOM
// -------------------------------------------------------------------

dreamRoom: FormerRoomShadowCaster, AlienRoom 'Dream Room'
  desc {
    "This is a spartan room, in the middle of which is a metal couch.
      <<dreamArm.isIn(dreamRoom) 
        ? 'A large articulated metal arm descends from the ceiling, 
            with a bulb that hovers a meter or so 
            above the raised part of the couch. '
        : ''>>
      A large window takes up most of the north wall, revealing an 
      office beyond. 
      <<dreamDoor.isOpen 
        ? 'An open door leads south to a hallway.' 
        : 'A closed door leads to the south.'>> ";
    hasDefinitelyBeenDescribed = true;
  }
  hasDefinitelyBeenDescribed = nil
  vocabWords       = 'dream room'
  shadowVocabWords = 'dream (room)'
  shadowList = [hallway5, office/*, bathroom*/]
  getDoorForLeavingRoom = dreamDoor
  isInColumn = 3
  isInRow = 4
  south = dreamDoor
  out asExit(south)
  nearestHallway = hallway5
  //getExtraScopeItems(actor) { return [pizza]; }
  //remoteRoomContentsLister
  //This roomAfterAction is now covered by all the endgame rooms.
  //roomAfterAction() {
  //  if (endgameDaemon.daemonID == nil) endgameDaemon.startDaemon();
  //}
//  // Hacked for the purpose of showing the endgameProfSequence
//  // at a time when endgameDaemon doesn't seem to want to run.
//  // While I'm at it, also use this hack to override the usual
//  // "Neton and Ovan are standing in the office" message.
//  lookAroundWithin(actor, pov, verbose)
//  {
//    local illum;
//    local infoTab;
//    local info;
//    local specialList;
//    local specialBefore, specialAfter;
//    //pleaseSay('<.p><font color=red><b>Beginning of hacked lookAroundWithin().</b></font><.p>');
//    if (verbose == true) {
//      verbose = (LookRoomName | LookRoomDesc
//                 | LookListSpecials | LookListPortables);
//    }
//    else if (verbose == nil) {
//      verbose = (LookRoomName | LookListSpecials | LookListPortables);
//    }
//    if (!actor.hasSeen(self))
//      verbose |= LookRoomDesc;
//    infoTab = actor.visibleInfoTableFromPov(pov);
//    info = infoTab[pov];
//    if (info != nil) {
//      illum = info.ambient;
//    }
//    else {
//      illum = 0;
//    }
//    adjustLookAroundTable(infoTab, pov, actor);
//    if ((verbose & LookRoomName) != 0) {
//      "<.roomname>";
//      lookAroundWithinName(actor, illum);
//      "<./roomname>";
//    }
//    if ((verbose & LookRoomDesc) != 0) {
//      "<.roomdesc>";
//      lookAroundWithinDesc(actor, illum);
//      "<./roomdesc>";
//    }
//    if ((verbose & LookListSpecials) != 0) {
//      local plst;
//      specialList = specialDescList(
//        infoTab,
//        {obj: obj.useSpecialDescInRoom(self) && !obj.isIn(actor)});
//      plst = partitionList(specialList,
//                           {obj: obj.specialDescBeforeContents});
//      specialBefore = plst[1];
//      specialAfter = plst[2];
//      specialContentsLister.showList(pov, nil, specialBefore,
//                                     0, 0, infoTab, nil);
//    }
//    if ((verbose & LookListPortables) != 0) {
//      lookAroundWithinContents(actor, illum, infoTab);
//    }
//    
//    
//    //BEGIN HACK
//    if (gPlayerChar.isIn(dreamRoom) && glob.endgameJeopardy && 
//        !endgameProfSequence.netonMentionedCrash) {
//      //pleaseSay('<.p><font color=red><b>LookAroundWithin() case 1 begin.</b></font><.p>');
//      "<.p>";
//      endgameProfSequence.seeProfs;
//      //pleaseSay('<.p><font color=red><b>LookAroundWithin() case 1 end.</b></font><.p>');
//    }
//    else {
//      //pleaseSay('<.p><font color=red><b>LookAroundWithin() case 2 begin.</b></font><.p>');
//      if ((verbose & LookListSpecials) != 0) {
//        specialContentsLister.showList(pov, nil, specialAfter,
//                                       0, 0, infoTab, nil);
//      }
//      //if (glob.isInEndgame)
//      //  glob.giveNpcReport;
//      //pleaseSay('<.p><font color=red><b>LookAroundWithin() case 2 end.</b></font><.p>');
//    }
//    //END HACK
//    
//    
//    lookAroundWithinSense(actor, pov, sound, roomListenLister);
//    lookAroundWithinSense(actor, pov, smell, roomSmellLister);
//    lookAroundWithinShowExits(actor, illum);
//    //if (endgameProfSequence.epsValue == 1) {
//    //  "<.p>";
//    //  endgameProfSequence.execute;
//    //}
//    if (illum > 1)
//      actor.setHasSeen(self);
//    //pleaseSay('<.p><font color=red><b>End of hacked lookAroundWithin().</b></font><.p>');
//  }
;

modify Actor
  // Hacked to make sure that the professor's sequence starts running
  // even on the first turn in the dream room.
  setHasSeen(obj) {
    if (!hasSeen(obj) && obj == dreamRoom) {
      //if (endgameProfSequence.epsValue == 1) endgameProfSequence.execute;
    }
    obj.noteSeenBy(self, seenProp);
  }
;

class SeeminglyFragile: object
  dobjFor(Break) asDobjFor(Attack)
  uselessToAttackMsg {
    return 'You deliver a solid blow to {the dobj/him}. '
      + attackWithstandMsg;
  }
  uselessToAttackWithMsg {
    return 'Wielding {the iobj/him}, you deliver a solid blow to {the dobj/him}. '
      + attackWithstandMsg;
  }
  attackWithstandMsg {
    return '\^' + (unfortunateBarrier ? 'A good effort, but ' : '') 
      + '{the dobj/he} withstand{s} your blow surprisingly well.
      In fact, you get the impression {it/he} could withstand a lot worse. ';
  }
  //uselessToAttackMsg {
  //  return 'You deliver a solid blow to '
  //    + (isPlural ? 'one of the windows' : 'the window') '. 
  //    \^' + (unfortunateBarrier ? 'A good effort, but ' : '') 
  //    + 'the window withstands your blow,
  //    and you get the impression it could withstand a lot worse. ';
  //}
  //uselessToAttackWithMsg {
  //  return 'Wielding {the iobj/him}, you deliver a solid blow to '
  //    + (isPlural ? 'one of the windows' : 'the window') '. 
  //    \^' + (unfortunateBarrier ? 'A good effort, but ' : '') 
  //    + 'the window withstands your blow,
  //    and you get the impression it could withstand a lot worse. ';
  //}
  unfortunateBarrier = nil
;

class Window: SeeminglyFragile, Fixture
  shootEffectProp = &shootEffectWindow
  // handle LookThrough on an ad hoc basis, not at this class level
  cannotOpenMsg = 'Inspecting {the dobj/him}, you conclude
    that there is no way of opening {it/him}. '
;

class DreamOfficeWindow: Window
  vocabWords = '(large) (plate) (glass) window mirror reflection -'
  name = 'window'
  windowDescStr = 
    'This window takes up almost the entirety of the '
      + sideOfRoom + 'ern wall. '
  reflectiveDescStr(explicitFlag) {
    return
      (explicitFlag ? 'The window is ' : 'It<./s>s also ')
      + 'very reflective, but still you can see through it to the '
      + otherSide.getOutermostRoom.name
      + ' on the other side. ';
  }
  dobjFor(KnockOn) {
    verify { }
    action {
      if (neton.isIn(otherSide.location))
        "You knock on <<theName>>. Neton and Ovan turn to face you,
            but seem little concerned,
            and soon turn back to each other. ";
      else
        inherited();
    }
  }
  //dobjFor(LookThrough) {
  //  verify() { }
  //  check() { }
  //  action() {
  //    local otherLocation;
  //    if (gActor.isIn(dreamRoom)) otherLocation = office;
  //    else otherLocation = dreamRoom;
  //    // This is how to list the contents of a remote room.
  //    // Ain't TADS 3 great? (Note that I would have had to
  //    // modify this if either office.contents or dreamRoom.contents
  //    // could ever be nil.)
  //    gActor.getOutermostRoom().remoteRoomContentsLister(otherLocation).showList(
  //      gActor, otherLocation, otherLocation.contents, ListRecurse, 0, 
  //      gActor.visibleInfoTableFromPov(gActor), nil);
  //  }
  //}
  //dobjFor(Break) {
  //  verify() { }
  //  check() { }
  //  action() {
  //    "You strike the window as hard as you can, but all you do
  //      is make a lot of noise. This glass is stronger
  //      than any you<./s>ve ever seen. ";
  //  }
  //}
  //dobjFor(Hit) asDobjFor(Break)
  //dobjFor(Attack) asDobjFor(Break)
  //dobjFor(HitWith) asDobjFor(Break)
  //dobjFor(AttackWith) asDobjFor(Break)
;

officeWindow: DreamOfficeWindow
  location = office
  otherSide = dreamWindow
  sideOfRoom = 'south'
  throughWindowDesc {
    "The window is 
      quite reflective, but you can still look through it
      to see the <.q>dream room<./q> on the other side. ";
  }
  //otherSideContentsDescStr {
  //  return
  //    'In the office you can see two desks in the center 
  //      of the room, as well as shelves containing 
  //      what must be thousands of books. '
  //      + (neton.isIn(office) ? '<p>Also in the office are Neton and Ovan. ' : '');
  //}
;

dreamWindow: DreamOfficeWindow 
  location = dreamRoom
  otherSide = officeWindow
  sideOfRoom = 'north'
  throughWindowDesc(nameIt) {
    "<<nameIt ? 'The window is' : 'It<./s>s'>> 
      quite reflective, but you can look through it
      and see the office on the other side. ";
  }
;

dreamCouch: Bed, Fixture
  'large metal examination raised (table) couch/sofa/bed'
  'couch'
  @dreamRoom
  "The couch is large and made of metal. It looks like an alien version
    of a doctor<./s>s examination table. An articulated arm
    extends from the ceiling, bending down over the couch 
    so that the end of the arm is about a meter above the
    raised end of the couch. "
  "A piece of furniture to sit or lie down on. "
  allowedPostures = [sitting, lying]
  obviousPostures = [lying]
  roomOkayPostureChangeMsg(posture, obj) {
    gMessageParams(obj);
    return '{You/he} ' + posture.msgVerbT + ' on the 
      metal couch. It is cold and uncomfortable. ';
  }
  cannotStandOnMsg = 'You can<./s>t stand on the couch, as the 
    metal arm is fixed in place right above it. '
;

dreamArm: Fixture
  'large articulated metal (round) thick arm/trunk/bulb/joint/joints'
  'metal arm'
  @dreamRoom
  "The articulated arm is thick, almost like a metal trunk,
    where it comes out of the ceiling. It 
    is covered with red wires, and its joints bend so that 
    the end of the arm is positioned over the raised end of 
    the couch. "
  "A long, jointed appendage. "
  cannotMoveFixtureMsg = 
    'The joints of the arm seem to be locked in place, 
      so that the arm cannot be moved. '
  zapAry = die(
    'The metal arm is transformed into a metal ram, which 
      unfortunately is already in operation at the time that it materializes, 
      smashing directly into your head. '
    , 'metal ram', self
  )
  zapT = lose(
    'The metal arm is transformed into a <.q>Me-Alarm<./q>!
        The Me-Alarm is designed to raise a deafening blare
        whenever it is visited by the person who
        set it off. In this case, that person is you.
      <p>Within moments, a squadron of security guards speed into 
        the building and descend upon you, guns raised high. 
        They quickly apprehend you before you can resist. '
    , ftCaptured, 'Me-Alarm', self
  )
;

ftCaptured: FinishType
  finishMsg = 'You have been recaptured'
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: OFFICE, including books, desks, scenery, stapler, ary/T transformed objects, etc.
// -------------------------------------------------------------------

office: FormerRoomShadowCaster, AlienRoom 'Office'
  vocabWords = 'office/room'
  nearStateTokens = ['room']
  nearestHallway = hallway8
  //shadowVocabWords = 'office'
  //shadowList = [hallway8, dreamRoom]
  roomDesc {
    "The south wall of this room is taken up by a 
      large plate glass window, which looks out to the 
      room beyond. 
      The other three walls are covered 
      from floor to ceiling with shelves
      that are crammed with thousands of books, plus ";
    if (stacksOfFiles.isIn(office))
      "tall stacks of files, ";
    else if (sacksOfFiles.isIn(office))
      "canvas sacks full of files, ";
    else if (casksOfFiles.isIn(office))
      "open casks full of files, ";
    "high-tech electronic devices, and other assorted 
      odds and ends. ";
    
    "On the north and south sides of the room
      sit Neton<./s>s and Ovan<./s>s desks, respectively, ";
    if (netonComputer.location == netonDesk && ovanComputer.location == ovanDesk) {
      "each with a computer on top and a chair behind. ";
    }
    else {
      "each with a chair behind. ";
      if (netonComputer.location == netonDesk) 
        "Neton<./s>s desk also has a computer on top. ";
      if (ovanComputer.location == ovanDesk) 
        "Ovan<./s>s desk also has a computer on top. ";
    }
    
    //"In the middle of the room sit two desks, ";
    //if (netonDesk.hasBeenIdentified && ovanDesk.hasBeenIdentified)
    //  "Neton<./s>s to the north, and Ovan<./s>s to the south. ";
    //else if (netonDesk.hasBeenIdentified)
    //  "Ovan<./s>s to the south, and another one to the north. ";
    //else if (ovanDesk.hasBeenIdentified)
    //  "Neton<./s>s to the north, and another one to the south. ";
    //else
    //  "one to the north, and another to the south. ";
    
    if (officeDoor.isOpen)
      "An open door leads west into the hallway. ";
    else
      "A closed door stands to the west. ";
  }
  getDoorForLeavingRoom = officeDoor
  isInRow = 3
  isInColumn = 3
  west  =   officeDoor
  out asExit(west)
;

class Inexhaustible: object
  removeName = name
  remainsPhrase = ''
  canBeVaporized = nil
  fireRemoverNoEffectMsg = 
    'One of the ' + removeName + ' disappears! However, '
      + remainsPhrase + '. '
  firePhaserNoEffectMsg =
    phaser.stunOrDestroyThingMsg(nil, nil)
;

// OfficeDecoration is for use with devices and stacks of files. Previously,
// I also used it for shelves. But heck, shelves are just shelves.
class OfficeDecoration: Inexhaustible, Fixture
  //hideFromAll(action) { return true; }
  //hideFromDefault(action) { return inherited(action); }
  dobjFor(Search) asDobjFor(Examine)
  dobjFor(LookIn) asDobjFor(Examine)
  dobjFor(Examine) {
    verify {
      if (hasBeenDescribed && gDobj && gActor.isIn(office)) illogical(descStr);
    }
    preCond {
      if (gPlayerChar.isIn(office))
        return [actorDirectlyInRoom];
      else
        return inherited;
    }
    //action {
    //}
  }
  nearDesc {
    say(initDescStr);
    hasBeenDescribed = true;
  }
  hasBeenDescribed = nil
  checkTravelerDirectlyInRoom(traveler, allowImplicit) {
    return office.checkTravelerDirectlyInRoom(traveler, allowImplicit);
  }
  cannotMoveMsg = 
    'Moving ' + theName + ' around won<./s>t achieve anything. '
  dobjFor(Take) {
    verify {
      // if something is logical to take, but you know you don't 
      // want to take it, rule it out only after it's been resolved
      if (gDobj && described)
        illogical(cannotTakeStr);
    }
    // if it's logical to take and you don't yet know it's not
    // worth taking, then perform any preconditions before giving
    // the message.
    check {
      say(initCannotTakeStr);
      exit;
    }
  }
  desc {
    if (isDistant)
      farDesc;
    else
      nearDesc;
  }
;

//officeDevices: /*FormerShadowCaster,*/ OfficeDecoration // a *former* FormerShadowCaster
//  'electronic odds (and) ends device/devices*devices'
//  'devices'
//  @office
//  isPlural = true
//  shadowList = [dreamRoom, hallway8]
//  remainsPhrase = 'innumerable devices remain'
//  initDescStr =
//    'You turn your attention to the devices on a 
//      nearby shelf. Before long, you realize that you have no
//      idea how any of them are supposed to work. You try turning 
//      them on, but you can<./s>t seem to do it, nor can you
//      figure out whether that is supposed to be possible. 
//      Then you turn your attention 
//      to all the other devices on all the shelves in the room. After
//      a long and painstaking examination, you determine that
//      not one of the devices makes any sense to you at all. 
//      Not only that, but they all seem perfectly useless.
//      As a result of all this, you conclude
//      that there is no point in examining the devices any further. '
//  descStr =
//    'No, no. As you already learned, the devices are
//      both useless and incomprehensible. You need not waste your
//      time examining them further. '
//  initCannotTakeStr =
//    'You pluck a random device off the shelf, but then you look
//      more closely at it, and you discover you have no idea how
//      to even begin to try to use it. So alien is it, and so
//      seemingly useless, that you decide to put it back. '
//  cannotTakeStr =
//    'No, no. As you already learned, the devices are
//      both useless and incomprehensible. There<./s>s no point
//      in picking up any of them. '
//;

officeShelves: ShadowCaster, MessyAlienThing, Fixture //OfficeDecoration
  '(office) shelf/shelves*shelves'
  'office shelves'
  realLocation = office
  desc {
    "The shelves themselves seem unremarkable, but they are stacked
      with thousands of books, plus ";
    if (stacksOfFiles.isIn(office))
      "tall stacks of files, ";
    else if (sacksOfFiles.isIn(office))
      "canvas sacks full of files, ";
    else if (casksOfFiles.isIn(office))
      "open casks full of files, ";
    "high-tech electronic devices, and other assorted 
      odds and ends. ";
  }
  //initDescStr =
  //  'At first glance you see nothing special about the shelves, 
  //    so you move up and scrutinize them closely, but this
  //    still reveals nothing special. Undeterred, 
  //    you decide to look behind all the books on the nearest shelf, 
  //    and while you<./s>re at it,
  //    you look underneath the shelf too. 
  //    You then repeat this process for each and every shelf in the
  //    room. Several long minutes later, when you get to the last shelf, 
  //    you<./s>ve still found nothing special. 
  //    After such a thorough examination, 
  //    it<./s>s hard to escape the conclusion that there is nothing
  //    special about the shelves. '
  //descStr =
  //  'No, no. You already examined the shelves as thoroughly
  //    as anyone could. You are absolutely certain that there is 
  //    nothing special about them. '
  //shadowList = [dreamRoom, hallway8]
  isPlural = true
  iobjFor(PutOn) {
    verify { }
    check {
      "The shelves are just about as full as they can possibly get. 
        Besides, if you put anything on there, it might
        get lost amidst the clutter. ";
      exit;
    }
  }
  canBeVaporized = nil
  dobjFor(Take) {
    verify {
      illogical(&cannotTakeFixtureMsg);
    }
  }
  cannotMoveMsg = &cannotMoveFixtureMsg
;

officeDevices: /*FormerShadowCaster,*/ OfficeDecoration // a *former* FormerShadowCaster
  'electronic odds (and) ends device/devices*devices'
  'devices'
  @office
  isPlural = true
  shadowList = [dreamRoom, hallway8]
  remainsPhrase = 'innumerable devices remain'
  initDescStr =
    'You turn your attention to the devices on a 
      nearby shelf. Before long, you realize that you have no
      idea how any of them are supposed to work. You try turning 
      them on, but you can<./s>t seem to do it, nor can you
      figure out whether that is supposed to be possible. 
      Then you turn your attention 
      to all the other devices on all the shelves in the room. After
      a long and painstaking examination, you determine that
      not one of the devices makes any sense to you at all. 
      Not only that, but they all seem perfectly useless.
      As a result of all this, you conclude
      that there is no point in examining the devices any further. '
  descStr =
    'No, no. As you already learned, the devices are
      both useless and incomprehensible. You need not waste your
      time examining them further. '
  initCannotTakeStr =
    'You pluck a random device off the shelf, but then you look
      more closely at it, and you discover you have no idea how
      to even begin to try to use it. So alien is it, and so
      seemingly useless, that you decide to put it back. '
  cannotTakeStr =
    'No, no. As you already learned, the devices are
      both useless and incomprehensible. There<./s>s no point
      in picking up any of them. '
;

class UnitsOfFiles: Stapleable, OfficeDecoration
  isPlural = true
  removeName = 'files'
  remainsPhrase = 'thousands of files remain'
  unitWord = '' // override
  // This weird-ass complicated thing was from when I wanted there
  // to be more variation in the initial description of the various
  // UnitsOfFiles objects.
  //leafVerb = 'leaf'
  //filesWord = (unitWord + 's')
  
  initDescStr {
    return
      'You turn to a nearby ' + unitWord 
        + ' and peruse the file labels, only to find
        what appears to be nothing but 
        boring bureaucratic paperwork. You even open up
        one or two of the files, only to find them as unimportant
        as you imagined. 
        Not satisfied, you then look at another ' + unitWord 
        + ', and then another, until after several long minutes
        you have examined all the ' + unitWord 
        + 's in the entire room. Without exception,
        they contain nothing but petty paperwork. 
        Based on this, you become firmly convinced that the ' 
        + unitWord + 's of files are entirely useless to you. ';
  }
  //initDescStr {
  //  return initDescStrPt1
  //       + initDescStrPt2
  //       + initDescStrPt3
  //       + initDescStrPt4
  //       + initDescStrPt5;
  //}
  //initDescStrPt1 = 
  //  'You turn to a nearby ' + unitWord 
  //  + ' and peruse the file labels, '
  //initDescStrPt2 = 
  //  'only to find nothing but 
  //    boring bureaucratic paperwork. You even open up
  //    one or two of the files, only to find them as unimportant
  //    as you imagined. '
  //initDescStrPt3 = 
  //  'Not satisfied, you then look at another ' + unitWord 
  //    + ', and then another, until after several long minutes
  //    you have glanced at all the ' + unitWord 
  //    + 's in the entire room. Without exception,
  //    the files are just petty paperwork. ') 
  //initDescStrPt4 = '' // override as needed
  //initDescStrPt5 = 
  //  'Based on this, you become firmly convinced that the ' 
  //    + unitWord + 's of files are entirely useless to you. '
  
  descStr =
    'No, no. The ' + unitWord + 's of files are entirely useless to you. 
      You need not bother with them any further. '
  cannotTakeStr =
    'No, no. The ' + unitWord + 's of files are entirely useless to you. 
      You need not bother with them any further. '
  okayStapleMsg =
    'Wielding the stapler like a pro, you grab a file, open it, 
      staple its contents, then put it back '
      + (unitWord == 'stack' ? 'onto' : 'into') 
      + ' the ' + unitWord + '. Cowabunga! '
  zapAry = disappear(
    'The files are transformed into a swarm of flies! 
      <p>The thousands of buzzing insects alight 
        from the shelves. To your alarm, some of them
        head straight towards you, but in a moment 
        you discover that they seem less 
        interested in you than in the ' 
        + (officeDoor.isOpen ? 'open ' : '')
        + 'door to the west. '
        + (officeDoor.isOpen 
            ? 'As one, they swarm out through the open door,
                buzzing angrily as they go, 
                continuing to stream out 
                in a steady cloud of insects.
                At length, every last one of them 
                has disappeared into the hallway.
                Finally, even their buzzing sound
                vanishes into the distance. '
            : 'Hundreds of flies swarm toward the door, 
                angrily making a useless attempt to 
                fly through it. Then, to your astonishment,
                you notice that some of the flies 
                have dropped to the floor 
                and are crawling underneath the door 
                and out of the room.
                More and more flies begin following their lead,
                until eventually the floor near the door
                is black with scurrying flies.
                It takes a long time for the flies 
                to crawl out underneath the door in this way,
                but these flies do not lack for determination. 
                At length, every last one of them 
                has disappeared under the door and out of sight.
                Before long, even the loud buzzing sound 
                outside vanishes into the distance. ')
      + 'You are left alone in a room whose shelves
          are considerably more barren than they were before. '
    , self, 'flies', 'files')
;

stacksOfFiles: UnitsOfFiles
  'file files paperwork stack/stacks'
  'stacks of files'
  @office
  unitWord = 'stack'
  //papersWord = 'papers'
  //initDescStrPt1 = 
  //  'You leaf through a nearby stack of paper, '
  descStr =
    'No, no. The files are entirely useless to you. 
      You need not bother with them any further. '
  initCannotTakeStr =
    'You pick up a few files, but then you notice 
      that they contain nothing but bureaucratic paperwork.
      Realizing you have no conceivable use for the files, you put them
      back again. '
  cannotTakeStr =
    'No, no. The stacks of files are entirely useless to you.
      You need not bother with them any further. '
  // On second thought, let's not bother with turning the 
  // stacks into sacks. But keep the transformation in zapT2
  // as a red herring for people who would try to cheat at the
  // "play my game" comp by decompiling my game.
  wordName = 'files'
  // Note to self: This is a red-herring for those who would
  // decompile my code and try to get answers to the Play-My-Game
  // contest I might run. It is not meant to do anything.
  zapT2 = transform(self, sacksOfFiles)
;

sacksOfFiles: UnitsOfFiles
  '(open) canvas file files paperwork sack/sacks'
  'sacks of files'
  @nil
  unitWord = 'sack'
  initCannotTakeStr =
    'You start to pick up one of the sacks, but then you realize 
      it<./s>s not very likely to be useful. 
      You<./s>re pretty good at carrying stuff with your bare hands. 
      Besides that, the files inside don<./s>t look all that 
      interesting. You decide to leave the sacks where they are. '
  zapAry = transform(self, casksOfFiles)
;

casksOfFiles: UnitsOfFiles
  '(open) file files paperwork cask/casks/barrel/barrels'
  'casks of files'
  @nil
  unitWord = 'cask'
  //leafVerb = 'look'
  initCannotTakeStr =
    'You could pick up one of the casks, but it<./s>d be 
      pretty awkward, and you can<./s>t imagine what possible use
      it might be. Besides that, the files inside don<./s>t look
      all that interesting. You decide to leave the casks where they are. '
  zapAry = transform(self, sacksOfFiles)
;

//class UnitsOfPapers: OfficeDecoration
//  isPlural = true
//  removeName = 'pieces of paper'
//  remainsPhrase = 'tens of thousands of papers remain'
//  unitWord = '' // override
//  // This weird-ass complicated thing was from when I wanted there
//  // to be more variation in the initial description of the various
//  // UnitsOfPapers objects.
//  initDescStr {
//    return initDescStrPt1
//         + initDescStrPt2
//         + initDescStrPt3
//         + initDescStrPt4
//         + initDescStrPt5;
//  }
//  leafVerb = 'leaf'
//  papersWord = (unitWord)
//  initDescStrPt1 = 
//    'You turn to one of the ' + unitWord 
//      + 's of papers and start to ' + leafVerb 
//      + ' through its contents, '
//  initDescStrPt2 = 
//    'only to find that it contains nothing but 
//      boring bureaucratic paperwork. '
//  initDescStrPt3 = 
//    'Not satisfied, you then look at another ' + unitWord 
//      + ', and then another, until after several long minutes
//      you have gone through all the ' + papersWord 
//      + ' in the entire room. Nothing but paperwork '
//      + (self == stacksOfPapers ? 'anywhere. ' : 'in any of them. ') 
//  initDescStrPt4 = '' // override as needed
//  initDescStrPt5 = 
//    'Based on this, you become firmly convinced that the ' 
//      + unitWord + 's of paper are entirely useless to you. '
//  descStr =
//    'No, no. The ' + unitWord + 's are entirely useless to you,
//      and so are their contents. You need not bother with them any 
//      further. '
//  cannotTakeStr =
//    'No, no. The ' + unitWord + 's are entirely useless to you,
//      and so are the papers inside. You need not bother with them
//      any further. '
//;
//
//stacksOfPapers: UnitsOfPapers
//  'paper papers paperwork stack/stacks'
//  'stacks of papers'
//  @office
//  unitWord = 'stack'
//  papersWord = 'papers'
//  initDescStrPt1 = 
//    'You leaf through a nearby stack of paper, '
//  descStr =
//    'No, no. The stacks of papers are entirely useless to you. 
//      You need not bother with them any further. '
//  initCannotTakeStr =
//    'You pick up one of the stacks of papers, but then you notice 
//      that they contain nothing but bureaucratic paperwork.
//      Realizing you have no conceivable use for them, you put them
//      back again. '
//  cannotTakeStr =
//    'No, no. The stacks of papers are entirely useless to you.
//      You need not bother with them any further. '
//  zapT = transform(self, sacksOfPapers)
//;
//
//sacksOfPapers: UnitsOfPapers
//  '(open) canvas paper papers paperwork sack/sacks'
//  'sacks of papers'
//  @nil
//  unitWord = 'sack'
//  initCannotTakeStr =
//    'You start to pick up one of the sacks, but then you realize 
//      it<./s>s not very likely to be useful. 
//      You<./s>re pretty good at carrying stuff with your bare hands. 
//      Besides that, the papers inside don<./s>t look all that 
//      interesting. You decide to leave the sacks where they are. '
//  zapAry = transform(self, casksOfPapers)
//;
//
//casksOfPapers: UnitsOfPapers
//  '(open) paper papers paperwork cask/casks/barrel/barrels'
//  'casks of papers'
//  @nil
//  unitWord = 'cask'
//  leafVerb = 'look'
//  initCannotTakeStr =
//    'You could pick up one of the casks, but it<./s>d be 
//      pretty awkward, and you can<./s>t imagine what possible use
//      it might be. Besides that, the papers inside don<./s>t look
//      all that interesting. You decide to leave the casks where they are. '
//  zapAry = transform(self, sacksOfPapers)
//;

officeBooks: Inexhaustible, Readable, Stapleable, Fixture
  'book books title titles -'
  'books'
  @office
  "You walk up to the books and scan the titles. They cover 
    everything from programming to astronomy to mazes,
    plus much more. "
  remainsPhrase = 'thousands of books remain'
  readDesc {
    local bk = nil;
    if (bookCounter < bookList.length) {
      bookCounter++;
      bk = bookList[bookCounter];
    }
    if (!bk) {
      "You walk over and look for any more books that might be worth
          taking and reading.
        <p>Nope, nothing catches your eye. ";
      pcKnowsBooksExhausted = true;
    }
    else {
      "You walk over and pick up a book that catches your eye. 
          It<./s>s called <i><<bk.title>>.</i> 
        <p><<bk.desc>>
          <<bk.putOnShelfDesc>>";
      
    }
  }
  shadowVocabWords = 'book books -'
  isPlural = true
  
  dobjFor(Examine) {
    preCond = [actorDirectlyInRoom]
  }
  dobjFor(Take) asDobjFor(Read) 
  dobjFor(Read) {
    verify {
      if (gDobj && pcKnowsBooksExhausted)
        illogical('No more of the books on the shelves catch your
          eye, and you have no further use for the ones you 
          already looked at. ');
    }
    preCond = [actorDirectlyInRoom]
  }
  pcKnowsBooksExhausted = nil
  bookCounter = 0
  bookList = [
     astronomyBook
    ,physicsBook
    ,programmingBook
    ,foodBook
    ,starshipBook
    ,miningBook
    ,nuclearBook
    ,hintBook
    ,symbologyBook
    ,mysticalBook
    ,scorpiiBook
    //,artBook
  ]
  okayStapleMsg =
    'Wielding the stapler like a pro, you grab a book, open it,
      staple its pages, then put it back on the shelf. 
      Cowabunga! '
;

class OfficeBook: object
  title = '[title]' // override
  titleItal = ('<i>' + title + '</i>')
  desc = "[desc]"
  putOnShelfDesc = "You put the book back on the shelf. "
;

astronomyBook: OfficeBook
  title = 'Atlas of the Milky Way'
  desc =
    "You eagerly flip through the pages. Most of the maps are 
        from a standpoint outside the Milky Way, 
        so they are not all that different from some other
        maps you<./s>ve seen by Earth
        astronomers. The major exception is that three stars have
        have been marked off as exceptional:
        <<ooStar.starName>> (which contains Oo), 
        Sol (which contains Earth),
        and 18 Scorpii (which contains Zdad).
      <p>Well, this is all very interesting, but in the end you decide 
        it has little to do with your present concerns. "
;
physicsBook: OfficeBook
  title = 'Theoretical Physics: Principles, Concepts, Methods, 
    Approaches'
  desc =
    "Flipping through the pages, you find that the book spends 
        an enormous amount of time talking about 
        <i>koroomaing toofomavalekeesokanos,</i>
        <i>oolesonaing avenatos,</i>
        <i>fofooning tooloval,</i> 
        and other equally incomprehensible things. 
      <p>Perhaps if you spent your entire life trying to understand
        this, you might be able to succeed. As it happens, however,
        you don<./s>t have that kind of time. "
;
programmingBook: OfficeBook
  title = 'The MIFS 9 Programming Manual'
  desc =
    "You eagerly flip through the book in an effort to learn more 
        about what Oo computer programming is like. 
      <p>The book starts out by telling you what you know already:
        MIFS 9 programming is done in a virtual reality environment.
        To create a computer program, you create and manipulate various 
        symbolic physical objects in various ways.
      <p>You start to read further, but the details are exceedingly 
        hard to fathom. Moreover, come to think of it,
        who really cares? It<./s>s not like you<./s>ll ever want 
        to use the <.q>Maze and Interactive Fiction System<./q>
        again anyway. "
;
foodBook: OfficeBook
  title = 'More Than Just Jell-O: A Guide to Earthling Cuisine'
  desc =
    "Skimming through the book, you discover that if there<./s>s 
        anything that the Oo actually do like about native
        Earth culture, it<./s>s the food. 
        Apparently the inhabitants of Oo did not have access to such 
        a wide variety of food as there was here on Earth
        (and apparently still is, at least for the Oo). 
      <p>However, you have no use for a cook book, and you don<./s>t
        really care what the Oo think of Earth cuisine. "
;
starshipBook: OfficeBook
  title = 'Spaceship Engineering: A Practical Guide'
  desc =
    "Flipping through the pages, you find references to
        <i>tooloval,</i> 
        <i>toofomavalekeesokanos,</i>
        and other such gibberish. 
        One thing does catch your attention, though. 
        It says that under the best of circumstances on planet Oo, 
        the construction of a single interstellar spaceship
        might take as long as 100 years. 
        It also says that on a backwater outpost like Earth, 
        such construction might easily take 10,000
        years or more.
      <p>Well, this is all well and good, but you<./s>re not 
        planning on building any spaceships in the near future. "
;
miningBook: OfficeBook
  title = 'Salt Mines: An Absentee Landlord<./s>s Guide'
  desc = 
    "Flipping through the pages, you come across the following passage:
        <.q>When seeking to excavate the most substantial deposits,
        it is advisable to instruct the project supervisor 
        to employ a process of repeated percussive charges,
        as opposed to simultaneous explosive blasts.<./q>
      <p>Yeah, this is of no interest to you whatsoever. "
;
nuclearBook: OfficeBook
  title = 'A Practical Guide to Surviving Nuclear Holocausts'
  desc =
    "Eager for some useful advice, 
        you flip through the little pamphlet. Unfortunately, 
        it is colossally stupid and unhelpful. 
        It all seems to boil down to two points: 
        (a) avoid nuclear holocausts, and
        (b) if you have to live on a planet where there was a nuclear
        holocaust, by all means avoid the hemisphere where
        most of it happened.
      <p>Well, this is clearly rubbish. "
;
hintBook: OfficeBook
  title = 'Cave Maze VII: The Essential Hint Book'
  desc =
    "You gingerly page through the book, knowing that Ovan
        must have done the same hundreds of times.
        Although this is described as a <.q>hint book,<./q>
        there are no progressive, step-by-step hints.
        The first 300 pages consist of an
        <.q>atlas,<./q> mapping out all the game<./s>s mazes,
        while the final 100 pages consist of the walkthrough.
      <p>Well, this is totally useless to you. "
;
symbologyBook: OfficeBook
  title = 'Symbology and Meaning in Cave Maze VII'
  desc =
    "You must have a perverse streak, because something 
        compels you to open up this book and read it.
      <p>Oh, my. In the chapter on the 
        <.q>serpent<./s>s maze,<./q> the author spends
        twenty pages discussing the <.q>famous<./q> issue 
        of whether that particular maze has 731 rooms or 732. 
        Apparently this issue makes a big difference to the 
        symbology and meaning of the game.
      <p>You make a mental note to come back and get this book
        if you ever need kindling. "
  putOnShelfDesc = "For now, however, you just put the book 
    back on the shelf. "
;
mysticalBook: OfficeBook
  title = 'Mazes: A Mystical Journey Unfolds'
  desc =
    "Flipping through the book, you find that it 
        reads like some New Age book, with phrases like
        <.q>spiritual healing,<./q> 
        <.q>mystical rejuvenation,<./q> and so on.
        Then, further on, it takes on more of the flavor
        of Eastern religion, discussing meditation
        as a way of exploring <.q>the divine mazes of the mind.<./q>
      <p>This is something you<./s>ll certainly never need
        to look at again. "
;
scorpiiBook: OfficeBook
  title = 'The Denizens of Zdad'
  desc =
    "You flip through the pages and skim the book. It talks about
        18 Scorpii II, which is known to its inhabitants as Zdad.
        It is the only planet which the Oo know to be 
        inhabited by intelligent life, aside from Earth and Oo. 
        It says here that Zdad is inhabited by an intelligent
        species of large, spider-shaped vertebrate animals.
        Apparently the planet is also known for its gigantic animals, 
        including its 500-ton fish, its huge mammoth-like livestock,
        its flamingo-like flying mammals, and so on.
      <p>Turning to the history section, you note that 
        about 20,000 years ago, the inhabitants of Oo 
        tried to conquer Zdad, but failed. 
        However, as the author of the book reflects, 
        <.q>It<./s>s just as well we didn<./s>t win the war. 
        Reliable intelligence indicates that there are no caves 
        on 18 Scorpii II, so it wouldn<./s>t have been any fun being 
        overlords there anyway.<./q>
      <p>While this is all very interesting, you decide it has little
        to do with your present concerns. "
;
//artBook: OfficeBook
//  title = 'Everything You Need to Know about Earth 
//    Literature, Music, and Art: A Concise Pamphlet'
//  desc =
//    "Flipping through the pages, you come across the following passage:
//        <.q>Text.<./q>
//      <p>Well, this won<./s>t help you. "
//;

class MessyAlienThing: object
  dobjFor(Clean) {
    verify {
      // This is a logical action, but one that should not be 
      // preceded by preconditions; hence, "if (gDobj)".
      if (gDobj)
        illogicalNow('Cleaning up after your alien captors? 
          It<./s>s hard to think of a more pointless task. ');
    }
  }
;

class AlienDesk: MessyAlienThing, AlienTable
  location = office
  isProperName = true
  //hasBeenIdentified = true
  asscDrawer = nil // override
  
  // ATTEMPT 5 TO MAP DESKS TO DRAWERS:
  // This works great, as long as you adjust the logicalRank()
  // as desired for the drawer that is being remapped to.
  dobjFor(Open) remapTo(Open, asscDrawer)
  dobjFor(Close) remapTo(Close, asscDrawer)
  dobjFor(LookIn) remapTo(LookIn, asscDrawer)
  dobjFor(Search) remapTo(LookIn, asscDrawer)
  iobjFor(PutIn) maybeRemapTo(gDobj != nil, PutIn, gDobj, asscDrawer)
  iobjFor(TakeFrom) maybeRemapTo(gDobj != nil && gDobj.isIn(asscDrawer), 
    TakeFrom, gDobj, asscDrawer)
  
  // ATTEMPT 4 TO MAP DESKS TO DRAWERS:
  //dobjFor(Open) remapTo(Open, asscDrawer)
  //dobjFor(Close) remapTo(Close, asscDrawer)
  //dobjFor(LookIn) {
  //  verify {
  //    inherited;
  //    logicalRank(120, 'extremely searchable desk');
  //  }
  //  preCond { return asscDrawer.preCondDobjLookIn; }
  //  check { asscDrawer.checkDobjLookIn; }
  //  action { asscDrawer.actionDobjLookIn; }
  //}
  //dobjFor(Search) asDobjFor(LookIn)
  //iobjFor(PutIn) maybeRemapTo(gDobj != nil, PutIn, gDobj, asscDrawer)
  //iobjFor(TakeFrom) maybeRemapTo(gDobj != nil && gDobj.isIn(asscDrawer), 
  //  TakeFrom, gDobj, asscDrawer)
  
  // ATTEMPT 3 TO MAP DESKS TO DRAWERS:
  // (Finally I found something that kind of seems to work.)
  //dobjFor(Open) {
  //  verify { asscDrawer.verifyDobjOpen; }
  //  action { asscDrawer.actionDobjOpen; }
  //}
  //dobjFor(Close) {
  //  verify { asscDrawer.verifyDobjClose; }
  //  action { asscDrawer.actionDobjClose; }
  //}
  //dobjFor(LookIn) {
  //  verify { asscDrawer.verifyDobjLookIn; }
  //  action { asscDrawer.actionDobjLookIn; }
  //}
  //dobjFor(Search) {
  //  verify { asscDrawer.verifyDobjSearch; }
  //  action { asscDrawer.actionDobjSearch; }
  //}
  //iobjFor(PutIn) maybeRemapTo(gDobj != nil, PutIn, gDobj, asscDrawer)
  //iobjFor(TakeFrom) maybeRemapTo(gDobj != nil && gDobj.isIn(asscDrawer), 
  //  TakeFrom, gDobj, asscDrawer)
  ////dobjFor(Unlock) remapTo(Unlock, asscDrawer)
  ////dobjFor(UnlockWith) remapTo (UnlockWith, asscDrawer, IndirectObject)  
  
  /*
  // ATTEMPT 2 TO MAP DESKS TO DRAWERS:
  dobjFor(Open) maybeRemapTo(gDobj != nil, Open, asscDrawer)
  dobjFor(Close) maybeRemapTo(gDobj != nil, Close, asscDrawer)
  dobjFor(LookIn) maybeRemapTo(gDobj != nil, LookIn, asscDrawer)
  dobjFor(Search) maybeRemapTo(gDobj != nil, Search, asscDrawer)
  iobjFor(PutIn) maybeRemapTo(gDobj != nil, PutIn, gDobj, asscDrawer)
  iobjFor(TakeFrom) maybeRemapTo(gDobj != nil && gDobj.isIn(asscDrawer), 
    TakeFrom, gDobj, asscDrawer)
  //dobjFor(Unlock) remapTo(Unlock, asscDrawer)
  //dobjFor(UnlockWith) remapTo (UnlockWith, asscDrawer, IndirectObject)  
  */
  
  /*
  // ATTEMPT 1 TO MAP DESKS TO DRAWERS:
  // I'm a little ticked that this remap didn't work as well as I'd hoped.
  // Namely, with simple remapping, OPEN OVAN'S yields "Which do you mean, 
  // Ovan's desk or Ovan's drawer?" That's no good.
  //dobjFor(Open) remapTo(Open, asscDrawer)
  dobjFor(Open) {
    verify {
      logicalRank(90, 'nominally openable');
    }
    action {
      asscDrawer.actionDobjOpen;
    }
  }
  // However, I'll settle for simple remapping with the other drawer verbs.
  dobjFor(Close) remapTo(Close, asscDrawer)
  dobjFor(LookIn) remapTo(LookIn, asscDrawer)
  dobjFor(Search) remapTo(Search, asscDrawer)
  iobjFor(PutIn) maybeRemapTo(gDobj != nil, PutIn, gDobj, asscDrawer)
  iobjFor(TakeFrom) maybeRemapTo(gDobj != nil && gDobj.isIn(asscDrawer), 
    TakeFrom, gDobj, asscDrawer)
  //dobjFor(Unlock) remapTo(Unlock, asscDrawer)
  //dobjFor(UnlockWith) remapTo (UnlockWith, asscDrawer, IndirectObject)  
  */
  
  dobjFor(Read) {
    verify {
      logicalRank(74, 'desk with nameplate');
    }
  }
  //considerReferringHereForXyValues = nil
  //examineStatus {
  //  inherited;
  //  if (asscDrawer.isOpen && asscDrawer.contents.length) {
  //    ".<p>";
  //    asscDrawer.examineStatus;
  //  }
  //}
  descPrefix =
    "The desk has a small nameplate that reads,
      <.q><<myOwner.name>>.<./q>
      It also has a large
      drawer<<!asscDrawer.isOpen || !asscDrawer.contents.length 
        ? ', which is presently ' + asscDrawer.openDesc : ''>>. "
    //"The desk has a small nameplate that reads,
    //  <.q><<myOwner.name>>,<./q>
    //  and a large drawer on one 
    //  side<<!asscDrawer.isOpen || !asscDrawer.contents.length 
    //    ? ', which is presently ' + asscDrawer.openDesc : ''>>. "
  wordName = 'desk'
  theWordName = 'the desk' // word name is not qualified
  zapT = nil // override "table -> A.B.L.E." behavior
;

netonDesk: AlienDesk
  vocabWords = 'north neton\'s desk desk/top/desktop/table/nameplate*desks*tops*desktops*tables'
  name = 'Neton<./s>s desk'
  //owner = neton
  myOwner = neton
  asscDrawer = netonDrawer
  yValue = 1
  desc {
    descPrefix;
  }
;

ovanDesk: AlienDesk
  vocabWords = 'south ovan\'s desk desk/top/desktop/table/nameplate*desks*tops*desktops*tables'
  name = 'Ovan<./s>s desk'
  //owner = ovan
  myOwner = ovan
  desc {
    descPrefix;
    "On the desk is ";
    if (ovanComputer.isIn(self))
      "a computer";
    if ((ovanComputer.isIn(self)) &&
        (ovanNotebooks.isIn(self) || ovanNoebooks.isIn(self)))
      ", surrounded by ";
    if (ovanNotebooks.isIn(self))
      "a huge heap of haphazardly arranged notebooks, folders, 
        and other miscellaneous junk";
    else if (ovanNoebooks.isIn(self))
      "a huge heap of haphazardly arranged noebooks, folders, 
        and other miscellaneous junk";
    ". ";
    //"On the desk is a computer, surrounded by 
    //  a huge heap of haphazardly arranged notebooks and folders, 
    //  a proliferation of sticky notes, 
    //  and other miscellaneous junk. ";
  }
  asscDrawer = ovanDrawer
  yValue = -1
  iobjFor(PutOn) {
    check {
      if (!ovanComputer.isIn(self))
        "Even without the computer, ";
      "Ovan<./s>s desktop is just about as full as it can possibly get. 
        Besides, if you put anything on there, it might
        get lost amidst the clutter. ";
      exit;
    }
  }
  // Perhaps it is bad form to lie and say this desktop has zero capacity,
  // but it's a simple way to prevent the PC from standing/sitting on it
  // or otherwise entering it.
  bulkCapacity = 0
  maxSingleBulk = 0
  noRoomToStandMsg = 
    (ovanComputer.isIn(self) ? '' : 'Even without the computer, ') 
    + 'Ovan<./s>s desktop is so cluttered, there<./s>s
    no easy way to stand on it. '
  noRoomToSitMsg =
    (ovanComputer.isIn(self) ? '' : 'Even without the computer, ') 
    + 'Ovan<./s>s desktop is so cluttered, there<./s>s
    no easy way to sit on it. '
  //dobjFor(Clean) {
  //  verify {
  //    // This is a logical action, but one that should not be 
  //    // preceded by "if (gDobj)".
  //    if (gDobj)
  //      illogical('Cleaning up after alien captors: 
  //        it<./s>s hard to think of a more thankless task,
  //        or a more pointless one. ');
  //  }
  //}
;



class Drawer: OpenableContainer
  // This is actually simpler than I thought at first.
  dobjFor(Pull) asDobjFor(Open)
  dobjFor(Push) asDobjFor(Close)
  dobjFor(LookIn) {
    verify {
      inherited;
      logicalRank(110, 'very searchable drawer');
    }
  }
  dobjFor(Search) asDobjFor(LookIn) // probably redundant
  //dobjFor(Push) {
  //  verify {
  //    if (!isOpen)
  //      illogicalNow('{The dobj/he} {is} already closed. ');
  //  }
  //  action {
  //    actionDobjClose;
  //  }
  //}
  //dobjFor(Pull) {
  //  verify {
  //    if (isOpen)
  //      illogicalNow('{The dobj/he} {is} already open. ');
  //  }
  //  action {
  //    actionDobjOpen;
  //  }
  //}
  theWordName = 'the drawer' // word name is not qualified
  zapAry = lose(
    'The drawer is transformed into a reward! '
    ,ftFauxVictory, 'reward', 'drawer'
  )
;

class AlienDeskDrawer: Drawer, Component
  asscDesk = location
  isQualifiedName = true
  //openStatus {
  //  return 'the desk drawer is ' + openDesc + '';
  //}
  wordName = 'drawer'
  // A coat or jacket is 40 bulk units. So we choose appropriate
  // bulk limitations for this "large drawer."
  bulkCapacity = 120
  maxSingleBulk = 60
  //theWordName = 'the drawer' // word name is not qualified
  //zapAry = lose(
  //  'The drawer is transformed into a reward! '
  //  ,ftFauxVictory
  //)
  // Vaporizing the desk drawers is problematic; it could make the game
  // unwinnable without warning, since the keycard is in one of the
  // drawers. The best way to solve this is to remap the action
  // to the desk itself, but we only want to do this when the weapon
  // in question is the phaser or the removing gun.
  transformObj {
    if (gIobj == phaser || gIobj == removingGun)
      return asscDesk;
    else
      return self;
  }
;

ftFauxVictory: FinishType
  finishMsg = 'You have won'
;

netonDrawer: AlienDeskDrawer
  // Parsing note: '(neton)' is needed as a weak token because apparently
  // (neton\'s) does not work as a weak token.
  '(north) (neton) (neton\'s) (desk) (table) drawer*drawers'
  'Neton<./s>s desk drawer'
  @netonDesk
  // Perhaps it is bad form to lie and say this drawer has zero capacity,
  // but it's a simple way to prevent the PC from putting anything into it.
  bulkCapacity  = 0 //(academicJournals.isIn(self) ? 0 : inherited)
  maxSingleBulk = 0 //(academicJournals.isIn(self) ? 0 : inherited)
  checkBulkInserted(insertedObj) {
    reportFailure(tooFullMsg, insertedObj, self);
    exit;
  }
  dobjFor(Open) {
    verify { inherited; }
    action {
      reportBefore('With much effort, you manage to pull 
        open the heavy drawer. ');
      inherited;
    }
  }
  okayCloseMsg = 'Straining a little, you push the drawer closed. '
;

ovanDrawer: AlienDeskDrawer
  // Parsing note: '(ovan)' is needed as a weak token because apparently
  // (ovan\'s) does not work as a weak token.
  '(south) (ovan) (ovan\'s) (desk) (table) drawer*drawers'
  'Ovan<./s>s desk drawer'
  @ovanDesk
  //openingLister : openableOpeningLister {
  //  
  //}
  
  //// We might want to handle SEARCH OVAN'S DRAWER (but not LOOK IN 
  //// OVAN'S DRAWER) as a search through the papers.
  //// We can't just remap because the drawer could be closed during the
  //// verify stage, and we can't remap to the papers when they're 
  //// not visible.
  //dobjFor(Search) {
  //  action {
  //    if (gActor.canSee(ovanPapers))
  //      ovanPapers.actionDobjExamine;
  //    else
  //      inherited;
  //  }
  //}
  
  // Perhaps it is bad form to lie and say this drawer has zero capacity,
  // but it's a simple way to prevent the PC from putting anything into it.
  bulkCapacity = 0
  maxSingleBulk = 0
  //containerTooFullMsg(obj, cont) {
  //    gMessageParams(obj, cont);
  //    return '{The cont/he} {is} already too full to hold {the obj/him}. ';
  //}
  checkBulkInserted(insertedObj) {
    reportFailure(tooFullMsg, insertedObj, self);
    exit;
  }
;

//class ComputerThing: object
//;

modify glob
  lockedComputerText = 
    '<.q>LOCKED. This workstation has been locked by user Neton. 
        To unlock the workstation, please type Neton<./s>s password.<./q> '
;

class OfficeComputer: Immovable
  myOwner = (location.myOwner)
  isQualifiedName = true
  wordName = 'computer'
  theWordName = 'the computer' // word name is not qualified
  desc {
    "\^<<theName>> is not terribly unlike a human computer,
        in that its most obvious components are a monitor and keyboard. 
        The monitor looks much like any you<./s>ve ever seen, 
        but the keyboard is 
        markedly different&mdash;almost three feet long, 
        with keys as big as matchbooks. 
        There are no apparent disk drives, 
        and no wires coming out. 
        Idly, you wonder where its 
        processor and power source are, 
        though the matter is of no real
        practical importance.
      <p>Looking closer at the monitor, you see the following words:
      <p><<glob.lockedComputerText>>";
  }
  dobjFor(Read) {
    verify {
      logicalRank(75, 'computer');
    }
  }
  dobjFor(EnterOn) asDobjFor(Use)
  dobjFor(TypeOn) asDobjFor(Use)
  dobjFor(TypeLiteralOn) asDobjFor(Use)
  dobjFor(Strike) asDobjFor(Use)
  dobjFor(Use) {
    verify { }
    check { }
    action {
      "You try typing in a few passwords into the keyboard, 
        but it<./s>s useless. 
        \^<<myOwner == ovan 
          ? 'Although the computer belongs to Ovan, it<./s>s' 
          : 'The computer is'>>
        asking for Neton<./s>s password.
        Until you know the password, you can<./s>t do anything
        with the computer. ";
    }
  }
  iobjFor(PutIn) {
    verify {
      illogicalNow('You can<./s>t seem to put anything in
        {the iobj/him}. There<./s>s no obvious disk drive
        or anything else of the kind. ');
    }
  }
  dobjFor(TurnOff) {
    verify { }
    check {
      "Experimentally, you push a few buttons on 
        <<myOwner.theName>><./s>s keyboard, 
        but it has no effect. You can<./s>t find any control
        that seems designed to turn the computer off. ";
      exit;
    }
  }
  dobjFor(TurnOn) {
    verify {
      illogicalAlready('{The dobj/he} is already on. ');
    }
  }
  cannotTakeMsg =
    'Both the monitor and the keyboard are bulky and quite heavy. 
      Carrying them would difficult in the extreme,
      and would slow you down a lot.
      Not a wise move when
      you<./s>re fleeing from enemy captors. '
  //cannotMoveMsg = &cannotMoveHeavyMsg
  //cannotPutMsg = &cannotPutHeavyMsg
;

netonComputer: OfficeComputer
  vocabWords = 'north neton\'s computer machine terminal screen (key) monitor keyboard (work) station workstation -*computers*machines*terminals*screens*(keys)*monitors*keyboards*stations*workstations'
  name = 'Neton<./s>s computer'
  zapT = transform(self, netonCompuer)
  location = netonDesk
  listName = 'an immaculately dusted computer'
  isListed = nil
  isListedInContents = true
  //owner = neton
  myOwner = neton
;

ovanComputer: OfficeComputer
  vocabWords = 'south ovan\'s computer machine terminal screen (key) monitor keyboard (work) station workstation -*computers*machines*terminals*screens*(keys)*monitors*keyboards*stations*workstations'
  name = 'Ovan<./s>s computer'
  zapT = transform(self, ovanCompuer)
  location = ovanDesk
  //owner = ovan
  myOwner = ovan
;

class Compuer: Nonsense
  isEquivalent = true
  //isListed = true
;

netonCompuer: Compuer
  'compuer*compuers'
  'compuer'
;

ovanCompuer: Compuer
  'compuer*compuers'
  'compuer'
;

class OvanDeskDecoration: NonPortable
  //hideFromAll(action) { return true; }
  //hideFromDefault(action) { return inherited(action); }
  dobjFor(Search) asDobjFor(Examine)
  dobjFor(LookIn) asDobjFor(Examine)
  dobjFor(Examine) {
    verify {
      if (hasBeenDescribed && gDobj && gActor.isIn(office)) illogical(desc2);
    }
    preCond = [touchObj]
  }
  desc {
    desc1;
    hasBeenDescribed = true;
  }
  hasBeenDescribed = nil
  triedToTake = nil
  //checkTravelerDirectlyInRoom(traveler, allowImplicit) {
  //  return office.checkTravelerDirectlyInRoom(traveler, allowImplicit);
  //}
  cannotMoveMsg = 
    'Moving ' + theName + ' around won<./s>t achieve anything. '
  dobjFor(Take) {
    verify {
      // if something is logical to take, but you know you don't 
      // want to take it, rule it out only after it's been resolved
      if (gDobj && (hasBeenDescribed || triedToTake))
        illogical(cannotTakeStr);
    }
    // if it's logical to take and you don't yet know it's not
    // worth taking, then perform any preconditions before giving
    // the message.
    check {
      say(initCannotTakeStr);
      triedToTake = true;
      exit;
    }
  }
;

ovanNotebooks: Inexhaustible, Stapleable, OvanDeskDecoration
  'notebook folder notebooks folders (and) miscellaneous junk -'
  'notebooks and folders'
  location = ovanDesk
  isPlural = true
  desc1 =
    "You open up one of the folders 
      on Ovan<./s>s desk. It seems to contain nothing but 
      notes and sketched maps of computer games he<./s>s
      played, from <i>Cave Maze VII</i> to <i>Adventureland.</i>
      Then, glancing through a random notebook, you see that it contains 
      more of the same. Leaving nothing to chance, 
      you then proceed to glance through every single notebook
      and folder on Ovan<./s>s desk. Without exception, 
      they contain nothing but useless notes and maps.
      This being the case, you conclude
      that you need not pay them any more attention. "
  desc2 =
    'No, no. You already looked through the ' + name 
      + ' quite thoroughly. They contain nothing but
      notes and maps of on computer games, perfectly
      useless to you. '
  initCannotTakeStr =
    'You take some notebooks and folders, but then,
      glancing through their contents, you note that they
      contain nothing but notes and maps on old computer games.
      Since you have no use for this type of thing,
      you put the items back. '
  cannotTakeStr =
    'No, no. As you already learned, the notebooks and folders
      are full of useless notes and maps on old computer games.
      You don<./s>t need to take them. '
  okayStapleMsg =
    'Wielding the stapler like a pro, you grab a '
      + rand('notebook, open it, staple its pages'
          ,'folder, open it, staple its contents')
      + ', then put it back where you found it. 
      Cowabunga! '
  zapT = transform(self, ovanNoebooks)
  removeName = (rand('notebooks','folders'))
  remainsPhrase = 'countless items remain on Ovan<./s>s desk'
;

ovanNoebooks: SemiNonsense, Inexhaustible, OvanDeskDecoration
  'noebook folder map maps note notes noebooks folders (and) miscellaneous junk -'
  'noebooks and folders'
  isPlural = true
  desc1 {
    if (!ovanNotebooks.described)
      "You open up one of the folders 
        on Ovan<./s>s desk. It seems to contain nothing but 
        notes and sketched maps of computer games he<./s>s
        played, from <i>Cave Maze VII</i> to <i>Adventureland.</i>
        Not leaving anything to chance, you glance through
        all the other folders and find more of the same.
        Then, turning your attention to the noebooks, 
        you see that they look like typical, average books.
        Opening each of them one by one, you find that 
        all their pages are entirely blank, without exception.
        Since you have no use for blank books 
        or adventure game maps, you conclude
        that you need not pay any more attention to the
        noebooks or folders. ";
    else
      "You turn to examine the noebooks. They look
        like typical, average books. Flipping through one of them,
        you find that all its pages are blank.
        Then you turn your attention to all the other noebooks
        on the desk. Every single one is entirely blank.
        Since you have no use for blank books, and since
        you know that the folders are just filled with 
        adventure game maps you don<./s>t need, you conclude
        you need not examine these items any further. ";
  }
  desc2 =
    'No, no. You already looked through the ' + name 
      + ' quite thoroughly. The noebooks are just blank books,
      and the folders contain nothing but
      adventure game maps. They are all perfectly useless to you. '
  initCannotTakeStr =
    'You take a noebook, which turns out to be a typical, 
      average book. However, when you glance closer at it, you 
      find that all its pages are blank, so you conclude you have
      no use for it, and you put it back.
      Then you pick up one of the folders, only to discover
      that it contains nothing but notes and maps of old computer games.
      Since these are useless to you, you put the folder back as well. '
  cannotTakeStr =
    'No, no. As you already learned, the noebooks are just
      ordinary books with blank pages, 
      and the folders
      are full of useless notes and maps on old computer games.
      You don<./s>t need to take them. '
  okayStapleMsg =
    'Wielding the stapler like a pro, you grab a '
      + rand('noebook, open it, staple its pages'
          ,'folder, open it, staple its contents')
      + ', then put it back where you found it. 
      Cowabunga! '
  removeName = (rand('noebooks','folders'))
  remainsPhrase = 'countless items remain on Ovan<./s>s desk'
;

academicJournals: DrawerFiller, Inexhaustible, Readable, Stapleable, NonPortable
  'academic journal journals -'
  'academic journals'
  @netonDrawer
  "Neton<./s>s drawer is full to the brim with 
    dozens and dozens of academic journals 
    on subjects as diverse as electronics, economics, and linguistics. "
  //isListed = 
  //  (gActionIs(Open) && gAction.isImplicit == nil && gDobj == ovanDrawer 
  //  ? true : nil)
  //isListedInContents = true
  listName = 'dozens, if not hundreds, of academic journals'
  isPlural = true
  readDesc {
    readCount++;
    if (readCount == 1) {
      "You search through the journals, but only one of them catches
          your eye. It<./s>s called,
          <i>Journal of the History of Earthological Philology.</i> 
          You pick it up and look at it closer. ";
      "<p>This issue of the journal is centered around
          the rediscovery of a paper written by one of the earliest
          Oo philologists studying the English language. ";
      //"The issue contains numerous articles about the historical significance
      //    of the paper, but you find the paper itself much more
      //    interesting. ";
      "<p>The paper dates to 2109, many decades ago, soon after
          the Oo landed on Earth. At that time, apparently, the Oo 
          could not yet read English,
          although they had begun to figure out its alphabet and 
          pronunication. It gives you a chuckle to read about 
          how hard it was for the Oo to learn English.
          The paper also contains a handy chart summarizing 
          English/Oo alphabet correspondences.";
      "<p>However, since you<./s>ve already learned
          the Oo alphabet, you have little need for 
          the journal. You put it back in the drawer. ";
      //"<p>[Author<./s>s note: Although this journal article is 
      //    not remotely 
      //    necessary for winning the game, you can obtain a copy of
      //    it, as well as other stuff, if you buy the feelies package 
      //    for the game. See
      //    <a href=\"<<versionInfo.gameUrl>>\">my web site</a>
      //    for more details.] ";
    }
    else {
      "You give another look through the academic journals.
          Nope, the only one that catches your eye is the one
          you already saw on early Oo research into the English langauge.
          And that one, while amusing, serves no practical purpose.
          You<./s>re pretty sure you can safely ignore the journals. ";
    }
  }
  readCount = 0
  //journalCount = 0
  //maxJournals = 2
  dobjFor(Take) asDobjFor(Read) 
  //dobjFor(Read) {
  //  verify {
  //    if (gDobj && pcKnowsBooksExhausted)
  //      illogical('No more of the books on the shelves catch your
  //        eye, and you have no further use for the ones you 
  //        already looked at. ');
  //  }
  //  preCond = [actorDirectlyInRoom]
  //}
  okayStapleMsg =
    'Wielding the stapler like a pro, you grab 
      one of the academic journals, open it, staple its pages, 
      then put it back where you found it. 
      Cowabunga! '
  removeName = 'journals'
  remainsPhrase = 'dozens, if not hundreds, of journals remain'
;

class DrawerFiller: object
  // This is a kludge, but it does work to ensure that the drawer-filler
  // (1) is listed as part of the drawer's contents when the drawer
  // and/or desk is opened and/or examined, but (2) is not listed 
  // in the room desription.
  isListed {
    if (location && 
        gActionIn(Examine, Open, Pull) && 
        gAction.isImplicit == nil &&
        gDobj is in (location, location.location))
      return true;
    return nil;
  }
  isListedInContents = true
;

ovanPapers: DrawerFiller, Inexhaustible, Stapleable, NonPortable
  'map maps list lists diagram diagrams (several) (hundred) loose papers'
  'loose papers'
  location = ovanDrawer
  isPlural = true
  listName = 'what must be several hundred loose papers'
  //hideFromAll(action) { return true; }
  //hideFromDefault(action) { return inherited(action); }
  dobjFor(Search) asDobjFor(Examine)
  dobjFor(LookIn) asDobjFor(Examine)
  dobjFor(Examine) {
    verify {
      if (hasBeenDescribed && gDobj && gActor.isIn(office))
        illogicalNow(
          'No, no. You<./s>ve conclusively proven that there<./s>s 
            nothing else hiding among the papers, and the papers
            themselves are just Ovan<./s>s old maze notes,
            not of any use to you. '
        );
    }
    preCond = [touchObj]
  }
  dobjFor(Push) asDobjFor(Examine)
  dobjFor(Move) asDobjFor(Examine)
  desc {
    if (!hasGivenKeycard) {
      "Rummaging through the papers in Ovan<./s>s drawer,
          you find a lot of strange miscellaneous stuff: 
          a list of countries in Africa, a big diagram of Nethack monsters,
          a list of movies, a huge printout of all the words in English
          beginning and ending with the letter S, and
          dozens and dozens of maps. 
          However, it doesn<./s>t seem to contain 
          anything of interest to you\ .\ .\ .
        <p>But wait! Just as you are getting to the bottom of Ovan<./s>s 
          drawer, you find something: a keycard!
        <p>With great care, you lift the beautiful, shining keycard 
          out of the drawer and carry it with you. ";
      keycard.moveInto(me);
      hasGivenKeycard = true;
    }
    else {
      "After discovering the keycard, you definitely think it might
          be worth searching through the papers again. This time 
          you hold nothing back, and physically remove the papers
          from the drawer, one by one in some cases, and put them on
          the floor. After several long and painstaking minutes,
          you have removed all the papers, revealing nothing else
          in Ovan<./s>s drawer.
        <p>Satisfied that you have conclusively proven that nothing else
          is hiding in Ovan<./s>s drawer, you painstakingly put all the papers
          back in the drawer; you don<./s>t have any use for them, 
          after all. When you have finished, everything looks 
          much as it did before. ";
      hasBeenDescribed = true;
    }
  }
  hasGivenKeycard = nil
  hasBeenDescribed = nil
  triedToTake = nil
  //checkTravelerDirectlyInRoom(traveler, allowImplicit) {
  //  return office.checkTravelerDirectlyInRoom(traveler, allowImplicit);
  //}
  //cannotMoveMsg = 
  //  'Moving ' + theName + ' around won<./s>t achieve anything. '
  dobjFor(Take) {
    verify {
      verifyDobjExamine;
      //if (hasBeenDescribed && gDobj && gActor.isIn(office))
      //  illogical(
      //    'No, no. You<./s>ve conclusively proven that there<./s>s 
      //      nothing else hiding among the papers, and the papers
      //      themselves are just Ovan<./s>s old maze notes,
      //      not of any use to you. '
      //  );
    }
    check { }
    action {
      if (!hasGivenKeycard) {
        "It<./s>s unlikely you<./s>d want to carry a whole drawerful
            of papers, but you start looking through them. ";
        desc;
        //"Rummaging through the papers in Ovan<./s>s drawer,
        //    you find a lot of strange miscellaneous stuff: 
        //    a list of countries in Africa, a big diagram of Nethack monsters,
        //    a list of movies, a huge printout of all the words in English
        //    beginning and ending with the letter S, and above all
        //    lots and lots of maps. Apparently this is Ovan<./s>s stash
        //    of information he used to create his maze game. It doesn<./s>t
        //    seem to contain anything of any practical value for you,
        //    though\ .\ .\ .
        //  <p>But wait! Just as you are getting to the bottom of Ovan<./s>s 
        //    drawer, you find something: a keycard!
        //  <p>With great care, you lift the keycard out of the drawer
        //    and carry it with you. ";
        //keycard.moveInto(me);
        //hasGivenKeycard = true;
      }
      else {
        desc;
      }
    }
  }
  removeName = 'papers'
  remainsPhrase = 'hundreds and hundreds of papers remain'
;

keycard: Thing
  '(plastic) (small) key card/keycard'
  'keycard'
  "The keycard is a thin, rectangular piece of plastic,
    about four inches by three inches. 
    Gleaming in the light of the room,
    it is sharp, clean, and beautiful. "
  obviouslyUnlocks = nil
  iobjFor(LockWith) {
    verify {
      //// If the gDobj is not resolved yet, just do nothing and wait
      //// for it to be resolved.
      //if (!gDobj)
      //  { }
      //else 
      // If we already know that the keycard unlocks the door, then
      // the keycard is obviously a logical choice for unlocking the door.
      if (gDobj && gDobj.ofKind(DoorNearCell) && obviouslyUnlocks) {
        // logical
      }
      // If we don't already know that the keycard unlocks the door, then
      // the keycard is **non-obvious** choice for unlocking the door.
      // We want the player to explicitly mention the keycard
      // as an unlocking instrument at least once.
      else if (gDobj && gDobj.ofKind(DoorNearCell)) {
        nonObvious;
      }
      // What if you type LOCK APPLE WITH KEYCARD? Let's try a nonObvious
      // verify result; that should work.
      else if (gDobj) {
        nonObvious;
      }
    }
  }
  iobjFor(UnlockWith) {
    verify { verifyIobjLockWith; }
  }
  bulk = 0
  zapAry = transform(self, dryCake)
;

//philologicalJournal: Readable
//  'philological academic journal'
//;

class PortableInitiallyOnNetonDesk: Thing
  location = netonDesk
  isListed {
    if (location == netonDesk //&& netonDesk.contents.length <= 3
        && !moved)
      return nil;
    else
      return true;
  }
  isListedInContents = true
;

class Stapleable: Thing
  dobjFor(StapleWith) {
    verify { }
    // Let the iobj handle it
    //action {
    //}
  }
  stapleCount = 0
  stapleMax = 50
  okayStapleMsg =
    'Wielding the stapler like a pro, you deftly punch 
      a couple of staples into {the dobj/him}. ';
;

ftStaplerKing: FinishType
  finishMsg = 'You are the stapler king'
;

stapler: PortableInitiallyOnNetonDesk
  'stapler'
  'stapler'
  "It<./s>s a little small, but still 
    surprisingly similar to a typical human stapler. "
  dobjFor(Use) {
    verify() { }
    action() { askForIobj(UseOn); }
  }
  dobjFor(UseOn) remapTo(StapleWith, IndirectObject, self)
  iobjFor(StapleWith) {
    verify {
      // obviously a logical choice, so don't report otherwise.
      
      //if (gDobj && stapleLackReported)
      //  illogicalNow('The stapler is out of staples. ');
    }
    check {
      if (stapleCount <= 0) {
        "You try stapling {the dobj/him}, only to find that 
            {the iobj/he} {is} empty. ";
        if (!stapleLackReported)
          "<p>Wow. That stapler had about <<spellInt(stapleMax)>> 
            staples, and you used them all. <i>That<./s>s</i>
            dedication. ";
        stapleLackReported = true;
        exit;
      }
    }
    action {
      say(gDobj.okayStapleMsg);
      gDobj.stapleCount += 2;
      self.stapleCount -= 2;
      //// This is kind of silly, but what the heck:
      //if (gDobj.stapleCount >= gDobj.stapleMax) {
      //  say('<p>Congratulations. In ' + libGlobal.totalTurns 
      //    + ' turns, you have stapled {the dobj/him} ' 
      //    + spellInt(gDobj.stapleCount)
      //    //+ gDobj.stapleCount + ' of a possible ' + gDobj.stapleMax
      //    + ' times. This gives you the rank of stapler king. ');
      //  endGame(ftStaplerKing);
      //}
    }
  }
  stapleMax = 100
  stapleCount = 100
  stapleLackReported = nil
  bulk = 3
  zapAry = transform(self, plaster)
  zapT = transform(self, sapler)
;

plaster: Thing
  'lump/chunk/hunk/plaster/paris'
  'chunk of plaster'
  "It<./s>s just a small chunk of ordinary plaster. "
  bulk = 3
  zapAry = transform(self, stapler)
  zapT = transform(self, plaser)
  wordName = 'plaster'
  aWordName = 'a chunk of plaster'
;

sapler: Nonsense
  'sapler'
  'sapler'
  bulk = 3
  // By parameterizing this with 'sapler or plaser', we intend to prevent 
  // you from getting credit for two different ways of turning nonsense into pearls.
  // Not sure if this was necessary, however...
  zapAry = transform(self, pearls, 'sapler or plaser') 
;

plaser: Nonsense
  'plaser'
  'plaser'
  bulk = 3
  // By parameterizing this with 'sapler or plaser', we intend to prevent 
  // you from getting credit for two different ways of turning nonsense into pearls.
  // Not sure if this was necessary, however...
  zapAry = transform(self, pearls, 'sapler or plaser')
;

pearls: Wearable
  'pearl pearls necklace string -'
  'string of pearls'
  "This string of pearls has been fashioned into a necklace.
    It<./s>s a handsome set of jewels, to say the least. "
  //isPlural = true
  bulk = 3
  okayWearMsg = 'Feeling as silly as you<./s>ve ever felt 
    in your life, you put the string of pearls around your neck. '
  okayDoffMsg {
    return playerActionMessages.okayDoffMsg + 'Ah, that feels better. ';
  }
  vickiShowResponse {
    if (!isWornBy(me))
      "<.q>Wow!<./q> says Vicki. <.q>That<./s>s one of the 
        prettiest pearl necklaces I<./s>ve ever seen. 
        Wherever did you find that, <<me.firstName>>?<./q> ";
    else
      "Vicki glances as you uncertainly. <.q>Well, 
        I wasn<./s>t going to say this. But since you raise the
        subject, why <i>are</i> you wearing that?<./q>
        Then, reconsidering, she adds, <.q>Well, nevermind, 
        <<me.firstName>>. You can wear what you like.<./q> ";
  }
  dianeShowResponse {
    if (!isWornBy(me))
      "<.q>It looks like a decent necklace, 
        if you<./s>re into that sort of thing,<./q>
        says Diane. ";
    else
      "<.q>A pearl necklace,<./q> says Diane. <.q>Not a 
        typical adornment for a man, but hey,
        to each his own.<./q> ";
  }
  vickiGiveResponse {
    "<.q>Wow, Gary, what a present! I really appreciate it!<./q> 
      says Vicki, taking the pearls and putting them around her neck.
      Having done this, she gives you a big smile. ";
    moveInto(vicki);
    makeWornBy(vicki);
  }
  dianeGiveResponse {
    "Diane regards the pearls for a long moment. Then she says,
      <.q>No thanks. I appreciate the offer, <<me.firstName>>, 
      but jewels aren<./s>t really my thing.<./q> ";
    //moveInto(diane);
  }
  wordName = 'pearls'
  aWordName = 'a string of pearls'
  wordNameIsPlural = true
;

// Note: As I was implementing the paper clips, I started to wonder
// whether people would want to try to use the paper clips to jimmy open
// the door of the cell. This made me decide not to include the paper clips.
// Also note that this object is unfinished; I never really decided
// whether I should make it belong to class OpenableContainer or not.

paperClips: /*OpenableContainer,*/ PortableInitiallyOnNetonDesk
  '(paper) clips/box'
  'box of paper clips'
  "This small box is adorned with a picture of an ordinary 
    Earth-style paper clip. "
  // I am removing this object from the game. Sadly, I see no
  // easy way to both include this object and also deal with 
  // the fact that the player may want
  location = nil
  dobjFor(Open) {
    verify {
      if (gDobj)
        illogical('As soon as you need a paper clip, this box 
          will be there for you. For now, however, don<./s>t 
          worry about it. ');
    }
  }
  dobjFor(LookIn) asDobjFor(Open)
  bulk = 2
  wordName = 'paper clips'
  aWordName = 'a box of paper clips'
  wordNameIsPlural = true
  zapAry = transform(self, crispApple)
;

crispApple: Satiating, Food
  'crisp apple/fruit'
  'crisp apple'
  smellDesc = "It smells faintly sweet. "
  // Override my usual handling of food taste. You can't taste
  // an apple without taking a bite, so don't do so.
  tasteDesc = "You could take a bite of the crisp apple,
    but then that part of it would grow stale. 
    If you want to taste it,
    it<./s>d be best just to eat the whole apple. "
  //foodEatDesc = (foodTasteDesc)
  foodTasteDesc = 'It<./s>s pretty good. '
  foodEatDescSuffix = 'You keep eating more and more of the ' + nameAbbr
    + ', until finally there<./s>s nothing left but the core.
    But you<./s>re still hungry, so you think, <.q>What the heck,<./q>
    and you eat the core too. '
  // isSweet is a bogus property, presently unused as far as I can tell.
  // When it was used, it referred to sweet junk food, so I think the apple
  // doesn't count.
  //isSweet = nil
  bulk = 2
  tastiness = 2
  foodName = 'apple'
  zapAry = transform(self, paperClips)
;

dryCake: Wrappable, Satiating, Food
  'dry cake*cakes'
  'dry cake'
  "It looks like a typical cake, though rather dry. "
  nameAbbr = 'cake'
  bulk = 2 // minimize the bulk difference between it and the keycard
  smellDesc = "It smells sweet. "
  foodTasteDesc = 'Despite the dryness, the cake isn<./s>t half bad. '
  // We don't want the wrapped/unwrapped status of the dry cake
  // to change when it appears/disappears.
  //dynamicWrapperForTransformation = nil
  tastiness = 3
  isSweet = true
  dobjFor(Eat) {
    action {
      inherited;
      if (glob.prisonersTrapped)
        noteMistake('Just as you finish');
    }
  }
  zapAry = transform(self, keycard)
;
+ Wrapper;

//stickyNotes: OvanDeskDecoration
//  desc1 =
//    "Looking through the adhesive notes stuck to Ovan<./s>s desk,
//      you find that they say things like <.q>do animal descriptions<./q>
//      and <.q>implement collapsing stairways.<./q> It would seem
//      that these are notes Ovan left to himself while working
//      on his maze game.  "
//  desc2 =
//    'The sticky notes are just notes Ovan wrote to himself while
//      working on his maze game. You don<./s>t need to worry
//      about them. '
//  dobjFor(Take) {
//    verify {
//      if (gDobj)
//        illogical('You can<./s>t think of anything more useless
//          than a collection of Ovan<./s>s used sticky notes. ');
//    }
//  }
//  zap
//;

class OfficeChair: AlienChair
  location = office
  isProperName = true
  desc =
    "It<./s>s a fairly typical office chair, except for the fact
      that it<./s>s bolted to the floor. "
  wordName = 'chair'
  theWordName = 'the chair'
  aWordName = 'a chair'
;

netonChair: OfficeChair
  'neton\'s (office) chair'
  'Neton<./s>s chair'
  yValue = 1
  asscDesk = netonDesk
  //owner = neton
;

ovanChair: OfficeChair
  'ovan\'s (office) chair'
  'Ovan<./s>s chair'
  yValue = -1
  asscDesk = ovanDesk
  //owner = ovan
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: CELL
// -------------------------------------------------------------------

// The cell and its contents are defined in 1prisoners.t.

modify cell
  vocabWords = 'cell/room'
  nearStateTokens = ['room']
  //shadowVocabWords = 'cell'
  //shadowList = [hallway1, hallway2, hallway3]
  nearestHallway = hallway3
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: BREAK ROOM, including G.E. fridge, etc.
// -------------------------------------------------------------------

breakRoom: FormerRoomShadowCaster, AlienRoom 'Break Room'
  vocabWords       = 'break room'
  shadowVocabWords = 'break (room)'
  shadowList = [hallway4, hallway7, hallway8]
  nearestHallway = hallway4
  desc = 
    "For a room built by aliens, this looks startlingly 
      similar to an ordinary human-style break room.
      In the middle of the room sits a table and chair.
      To the north<<breakDoor.isOpen 
        ? ', an open door leads into a hallway' 
        : ' stands a closed door'>>. "
  //desc = "If you were in a human building, you<./s>d call this a
  //  break room. In the middle of the room sits a table and chair.
  //  To the north<<breakDoor.isOpen 
  //    ? ', an open door leads into a hallway' 
  //    : ' stands a closed door'>>. "
  getDoorForLeavingRoom = breakDoor
  isInColumn = 2
  isInRow = 6
  north = breakDoor
  out asExit(north)
;

// Perhaps the fridge contents lister should work like a standard
// openableContentsLister after all.
fridgeContentsLister: openableContentsLister
  //showListEmpty(pov, parent) {
  //  "\^<<parent.theName>> <<parent.verbToBe>> <<parent.openDesc>>. ";
  //}
  //showListPrefixWide(itemCount, pov, parent) {
  //  "\^<<parent.theName>> <<parent.verbToBe>> <<parent.openDesc>>, and contain<<parent.verbEndingS>> ";
  //}
;

freezerContentsLister: thingContentsLister
  showListEmpty(pov, parent) {
    //"\^The upper part of the fridge consists of a freezer,
    //  which is <<geFreezer.subContainer.openDesc>>. ";
    "\^The upper part of the fridge consists of a freezer,
      which is <<freezerOpenDesc>>. ";
  }
  showListPrefixWide(itemCount, pov, parent) {
    //"\^The upper part of the fridge consists of a freezer,
    //  which is <<geFreezer.subContainer.openDesc>>, and contain<<geFreezer.verbEndingS>> ";
    "\^The upper part of the fridge consists of a freezer,
      which is <<freezerOpenDesc>>, and contain<<geFreezer.verbEndingS>> ";
  }
  freezerOpenDesc {
    if (geFridge.subContainer.isOpen && geFreezer.subContainer.isOpen)
      "open"; //"also open";
    else if (!geFridge.subContainer.isOpen && !geFreezer.subContainer.isOpen)
      "also closed";
    else if (geFreezer.subContainer.isOpen)
      "open";
    else
      "closed";
  }
;

modify Thing
  destinationForPutOn = (self)
;

modify npcActionMessages
  okayPutOnMsg = '{You/he} put{s} {the dobj/him} on ' 
    + gIobj.destinationForPutOn.theName + '. '
;

// Examine: descContentsLister
// Open: openingLister
// Look: roomContentsLister

geFridge: FormerShadowCaster, Fixture, ComplexContainer
  'ge (human) (human-style) g.e. general electric fridge/refrigerator'
  'G.E. fridge'
  @breakRoom
  desc {
    "The refrigerator bears the logo of General Electric. ";
    if (!geFreezer.isIn(self))
      "It includes a large, empty area, where
        a freezer used to be. ";
  }
  shadowVocabWords = 'ge (human) (human-style) g.e. general electric fridge/refrigerator/freezer'
  shadowList = [hallway4]
  
  // start ComplexContainer stuff
  specialDesc {
    "A large, human-style refrigerator stands here, which is 
      <<subContainer.openDesc>>. ";
    
    if (geFreezer.isIn(self)) {
      "The top part of it consists of 
        a freezer, which is ";
      if (subContainer.isOpen && geFreezer.subContainer.isOpen)
        "also open. ";
      else if (!subContainer.isOpen && !geFreezer.subContainer.isOpen)
        "also closed. ";
      else if (geFreezer.subContainer.isOpen)
        "open. ";
      else
        "closed. ";
    }
    //else {
    //}
  }
  specialDescOrder = 80
  examineStatus() {
    if (subContainer != nil)
      subContainer.examineStatus();
    
    // start hack
    if (geFreezer.isIn(self))
      geFreezer.subContainer.examineListContentsWith(freezerContentsLister);
    //else
    //  "The fridge also includes a large, empty area, where
    //    a freezer used to be. ";

    // end hack
    
    if (subSurface != nil)
      subSurface.examineStatus();
    if (subRear != nil)
      subRear.examineStatus();
    if (subUnderside != nil)
      subUnderside.examineStatus();
  }
  subContainer: ComplexComponent, OpenableContainer {
    examineStatus() {
      examineListContentsWith(fridgeContentsLister);
      //geFreezer.examineListContentsWith(fridgeDescContentsLister);
    }
    // addToContents is hacked to make the FridgePart objects appear
    // first, and in the proper order.
    addToContents(obj) {
      //if (obj == upperFridgeDrawer) {
      //  local k =0; k=k/k;
      //}
      if (obj == nil) {
        return;
      }
      else if (!obj.ofKind(FridgePart) || contents.length < 1) {
        contents += obj;
        return;
      }
      // FridgePart scenario
      else {
        for (local a = 1; a <= contents.length; a++) {
          if (obj.listPreceders.indexOf(contents[a]) == nil) {
            contents = contents.insertAt(a, obj);
            return;
          }
        }
        // if the FridgePart hasn't been added already, append it
        // to the end.
        contents += obj;
        return;
      }
    } // end addToContents
    // No bulkCapacity limits
    maxSingleBulk = 80
  }
  subSurface: ComplexComponent, Surface {
    // No limits on bulkCapacity or maxSingleBulk
  }
  // If I un-commented-out the following line, then putting something 
  // on the fridge would really mean putting it on the freezer.
  //iobjFor(PutOn) remapTo(PutOn, DirectObject, geFreezer)
  hasNonFridgePartContents() {
    foreach (local obj in contents) {
      if (!obj.ofKind(FridgePart)) {
        return true;
      }
    }
    return nil;
  }
  // This is quite a line. It transforms the entire refrigerator --
  // *and all of its contents* -- into a fried egg. Presently I can
  // foresee no unintended consequences in doing this. I think
  // this will work.
  zapAry = transform(self, friedEgg)
;

geFreezer: Fixture, ComplexContainer
  'ge (human) (human-style) g.e. general electric freezer'
  'G.E. freezer'
  "The freezer bears the logo of General Electric. "
  location = geFridge.subSurface
  subContainer: ComplexComponent, OpenableContainer {
    bulkCapacity = 180
    maxSingleBulk = 60
  }
  // This is a bogus subSurface. It's really only here because 
  // at one point I thought that people should be able to put
  // things down on top of the freezer, rather than the fridge.
  subSurface: ComplexComponent, Surface {
    // If anyone types PUT X ON FREEZER, make sure to put
    // the thing on the fridge instead.
    iobjFor(PutOn) {
      verify() {
        geFridge.subSurface.verifyPutInInterior();
      }
      action() {
        gDobj.moveInto(geFridge.subSurface);
        defaultReport(&okayPutOnMsg);
      }
    }
    // Explicitly state that the thing is going onto the fridge.
    okayPutOnMsg = '{You/he} put{s} {the dobj/him} on ' 
      + gIobj.destinationForPutOn.theName + '. '
    destinationForPutOn = geFridge
  }
;

cupboard: /*FormerShadowCaster,*/ Fixture, OpenableContainer // a *former* FormerShadowCaster
  '(white) (plastic) cupboard/cabinet' 'cupboard'
  @breakRoom
  "The cabinet is mounted against the wall, and is 
    made of white plastic. "
  specialDesc {
    "Mounted against one wall is a cupboard, which is ";
    //// Taking an axe to this. The "also" doesn't read well and isn't necessary.
    //if (geFreezer.getOutermostRoom == self.getOutermostRoom && 
    //    ((geFreezer.isOpen && self.isOpen) || (!geFreezer.isOpen && !self.isOpen)))
    //  "also ";
    "<<openDesc>>. ";
  }
  specialDescOrder = 90
  shadowList = [hallway4]
  bulkCapacity = 300
  maxSingleBulk = 60
  //canBeVaporized = nil
;

class AlienTable: Fixture, Platform
  allowedPostures = [sitting, standing]
  obviousPostures = [sitting, standing]
  // Let the table act like a chair when you stand on it
  // and then drop something.
  getDropDestination(obj, path) {
    return location != nil
      ? location.getDropDestination(obj, path)
      : self;
  }
  cannotMoveFixtureMsg = '{The dobj/he} is fixed to the floor. '
  cannotTakeFixtureMsg = '{The dobj/he} is fixed to the floor. '
  zapT = die(
    transformUnsimulated('an Advanced Biological Lifeform Exterminator')
      + '<p>For better or worse, ABLEs are much more efficient 
        than their BLE predecessors. Within 0.7 seconds, all
        carbon-based substances in the room have been transformed
        into ash. Including your body. '
    , 'ABLE', 'table', killEverybodyInRoom
  )
;

class AlienChair: Fixture, Chair
  cannotMoveFixtureMsg = '{The dobj/he} is fixed to the floor. '
  cannotTakeFixtureMsg = '{The dobj/he} is fixed to the floor. '
  // just for reference, bulk = 0, since this is a fixture
  bulkCapacity = 700
  bulkCapacityForThing = 100
  maxSingleBulk = 700
  maxSingleBulkForThing = 60
  // This must be hacked, because although it is possible for a 70-liter,
  // 150-lb. person to sit on a chair, that doesn't mean that 70 liters
  // or 150 lbs. of other stuff can easily sit on it. Hence also
  // the bulkCapacityForThing/maxSingleBulkForThing properties above.
  checkBulkInserted(insertedObj) {
    local objBulk;
    local objBulkCapacity;
    local objMaxSingleBulk;
    if (insertedObj.isActor) {
      objBulkCapacity = bulkCapacity;
      objMaxSingleBulk = maxSingleBulk;
    }
    else {
      objBulkCapacity = bulkCapacityForThing;
      objMaxSingleBulk = maxSingleBulkForThing;
    }
    
    objBulk = insertedObj.getBulk();
    if (objBulk > objMaxSingleBulk || objBulk > objBulkCapacity) {
      reportFailure(&tooLargeForContainerMsg, insertedObj, self);
      exit;
    }
    // As Mike Roberts says:
    // If our contained bulk is over our maximum, don't allow it.
    // Note that we merely need to check our current bulk within,
    // since this routine is called with the insertion already
    // tentatively in effect. 
    if (getBulkWithin() > objBulkCapacity) {
      reportFailure(tooFullMsg, insertedObj, self);
      exit;
    }
  }
;

breakTable: FormerShadowCaster, AlienTable
  '(black) (stone) (small) (square) table'
  'table'
  @breakRoom
  "The table is small, square, and made of black stone. "
  shadowList = [hallway4]
;

breakChair: AlienChair
  'chair'
  'chair'
  @breakRoom
  "It<./s>s a black chair, fastened to the ground beside
    the table. "
;

class FridgePart: object
  location = geFridge.subContainer
  partName = (name)
  labelName = (partName.toUpper())
  desc = "The <<partTypeName>> is made of clear plastic, and is 
    labeled with the words <.q><<partName.toUpper()>>.<./q> "
  // A fridge part's "master part" is the object that determines
  // whether it can be removed from the fridge.
  masterPart = nil
  dobjFor(Take) {
    check {
      if (contents.length() > 0 && isIn(geFridge)) {
        notEmptyForFridgeRemoval;
        exit;
      }
      if (ofKind(FridgeDrawer) && isIn(geFridge) && isOpen) {
        "You can<./s>t seem to remove {the dobj/him}
          while it<./s>s open. ";
        exit;
      }
      if (isIn(geFridge) && masterPart && masterPart.isIn(geFridge)) {
        "You tilt the <<name>> in an effort to remove it, 
          but it bumps up against the <<masterPart.name>> 
          and won<./s>t come out. ";
        exit;
      }
      inherited();
    }
    action {
      local str = '';
      if (self == lowerFridgeDrawer 
          && location == geFridge.subContainer
          && certificate.isIn(geFridge.subContainer)
          && !certificate.hasBeenNoticed) {
        str = 'As you do so, you notice something lying at the bottom
          of the fridge. ';
        certificate.hasBeenNoticed = true;
      }
      if (isIn(geFridge))
        mainReport('You tilt up the ' + name + ' and pull it
          out of the ' + geFridge.name + '. ' + str);
      inherited();
    }
  }
  dobjFor(PutIn) {
    check {
      if (gIobj == geFridge || gIobj == geFridge.subContainer) {
        // Note that the following condition only applies to shelves.
        if (ofKind(FridgeShelf) && contents.length() > 0 && isIn(geFridge)) {
          notEmptyForFridgeInsertion;
          exit;
        }
        if (masterPart && masterPart.isIn(geFridge)) {
          "You can<./s>t fit the <<name>> into the <<geFridge.name>>
            while the <<masterPart.name>> is in there. ";
          exit;
        }
      }
      inherited();
    }
    action {
      if (gIobj == geFridge || gIobj == geFridge.subContainer)
        mainReport('You tilt the ' + name + ' and slide it into the ' 
          + geFridge.name + '. It snaps sharply into place. ');
      inherited();
    }
  }
  giveShowType = FridgePart
  vickiGiveResponse {
    "<.q>I don<./s>t think I could carry that with both 
      my hands,<./q> says Vicki. <.q>I think you<./s>d better 
      hang on to it.<./q> ";
  }
  dianeGiveResponse {
    "<.q>I think you<./s>d better keep that, He-Man,<./q> 
      says Diane. <.q>I don<./s>t know if I could carry that 
      if I tried.<./q> ";
  }
;

class FridgeDrawer: FridgePart, Drawer
  partTypeName = 'drawer'
  material = glass
  bulk = 200
  bulkCapacity = 180
  maxSingleBulk = 60
  desc = "The bottom of the <<partTypeName>> is white, while 
    the rest of it is made of clear plastic. It is
    labeled with the words <.q><<partName.toUpper()>>.<./q> "
  //dobjFor(Pull) asDobjFor(Open)
  //dobjFor(Push) asDobjFor(Close)
  notEmptyForFridgeRemoval =
    "You try to remove the drawer from the GE fridge, but 
      it is extremely hard to get loose. Perhaps if 
      there were fewer items in it, you might be able 
      to pull it free. "
  wordName = 'drawer'
  //zapAry = lose(
  //  'The drawer is transformed into a reward! '
  //  ,ftFauxVictory
  //)
;

class FridgeShelf: FridgePart, Surface
  bulk = 180
  bulkCapacity = 180
  maxSingleBulk = 60
  partTypeName = 'shelf'
  notEmptyForFridgeRemoval =
    "It would be exceedingly difficult to remove the 
      <<name>> while anything is on top of it. "
  notEmptyForFridgeInsertion =
    "It would be exceedingly difficult to put the <<name>>
      into the <<geFridge.name>> while anything is on top 
      of it. "
  wordName = 'shelf'
  zapAry = die(
    'The shelf is transformed into flesh!
      <p>Judging by the size, this particular piece of flesh 
        appears have been butchered from the mammoth-like livestock
        of the planet Zdad. Zdadi meat is 
        not harmful to humans in and of itself,
        but unfortunately it often contains the virus known as
        Anthropophagus instantanius.
        This virus, though harmless to Zdadis, 
        is especially communicable and deadly
        to humans, causing death within minutes.
      <p>This flesh carries a good number 
        of the pathogens, so you die in short order. '
    // All the aliens will be dead by the time you get this item.
    // So if you can see any NPCs,
    // then they are humans, and should die along with you.
    , 'flesh', 'shelf', killEverybody
  )
;

upperFridgeShelf: FridgeShelf
  '(clear) (plastic) upper top shelf*shelves'
  'upper shelf'
  masterPart = nil
  listPreceders = []
  //zapAry = die(
  //  transformUnsimulated('a large puddle of Shrepp fuel')
  //    + '<p>Unfortunately, Shrepp fuel is extremely volatile,
  //      as any child on 18 Scorpii II could tell you. 
  //      For instance, under no circumstances
  //      should you put Shrepp fuel into an oxygen atmosphere,
  //      because then it is sure to explode. 
  //    <p>Well, at least your death is quick. '
  //  ,killEverybodyInRoom
  //)
;

lowerFridgeShelf: FridgeShelf
  '(clear) (plastic) lower bottom shelf*shelves'
  'lower shelf'
  masterPart = upperFridgeShelf
  listPreceders = [upperFridgeShelf]
  //zapAry = die(
  //  transformUnsimulated('an Ehler<./s>s wolf')
  //      + 'And boy, does it look mean. Snarling and baring 
  //      its teeth, the great beast turns its head, then locks eyes on you.
  //      The next instant, it pounces.
  //    <p>Considering the remarkable ferocity of Ehler<./s>s wolves,
  //      you never really stood a chance. '
  //)
;

upperFridgeDrawer: FridgeDrawer
  '(white) (clear) (plastic) upper top drawer*drawers'
  'upper drawer'
  masterPart = lowerFridgeShelf
  listPreceders = [upperFridgeShelf, lowerFridgeShelf]
;

lowerFridgeDrawer: FridgeDrawer
  '(white) (clear) (plastic) lower bottom drawer*drawers'
  'lower drawer'
  masterPart = upperFridgeDrawer
  listPreceders = [upperFridgeShelf, lowerFridgeShelf, upperFridgeDrawer]
  // I could let the ary ung turn this into a "were-warlord,"
  // but nah.
;

certificate: Stapleable, Readable 
  '(cheese) certificate'
  'certificate'
  location = geFridge.subContainer
  bulk = 0
  madeOfPaper = true
  desc {
    "The certificate bears the official seal of CESAC. It reads: ";
    //"<blockquote> ";
    "<p>The accompanying item has been examined by the 
        Office of the Deputy Provost of the Center for
        Earthological Studies, Australian Campus.
      <p>The accompanying item has been deemed 
        <.q>cheese-free.<./q>
      <p>Signed,
      \n Toova
      \n Second-Class Assistant to the Deputy Provost, 
        and Chief Anti-Cheese Official for
        the Center for Earthological Studies, Australian
        Campus ";
    //"</blockquote>";
    if (stapleCount > 0)
      "<p>The certificate also contains about <<spellInt(stapleCount)>>
        staples. ";
    //if (!feeliesNotification)
    //  "<p>[Author<./s>s note: You can get a physical copy of this
    //    certificate, plus other goodies, if you buy the feelies package 
    //    for this game. See
    //    <a href=\"http://www.gregboettcher.com/mazes/\">my web site</a>
    //    for more details.] ";
    feeliesNotification = true;
    cheeseAchievement.achieve();
  }
  feeliesNotification = nil
  //dobjFor(StapleWith) {
  //  action {
  //    inherited();
  //    if (stapleCount >= stapleMax) {
  //      say('<p>Congratulations. In ' + libGlobal.totalTurns 
  //        + ' turns, you have stapled {the dobj/him} ' 
  //        + stapleCount //+ ' of a possible ' + stapleMax +
  //        ' times. This gives you the rank of stapler king. ');
  //      endGame(ftStaplerKing);
  //    }
  //  }
  //}
  //stapleMax = 50
  hasBeenNoticed = nil
  zapT = transform(self, cerificae)
;

modify Thing
  canBeSensed(sense, trans, ambient) {
    
    
    // START HACK
    // Hacked to make it so nothing is visible (or otherwise 
    // perceptible) when it's (a) directly in the fridge
    // and (b) underneath the lower drawer.
    if (location == geFridge.subContainer
        && lowerFridgeDrawer.isIn(geFridge.subContainer)
        && !ofKind(FridgePart)) {
      return nil;
    }
    // END HACK
      
    
    // adjust the ambient level for the transparency path, if the
    // sense uses ambience at all 
    if (sense.ambienceProp != nil) {
      // adjust the ambient level for the transparency - if that
      // leaves a level of zero, the object can't be sensed 
      if (adjustBrightness(ambient, trans) == 0)
        return nil;
    }
    // check the viewing conditions
    switch(trans) {
      case transparent:
      case attenuated:
        // under transparent or attenuated conditions, I appear as
        // myself 
        return true;
      case obscured:
      case distant:
        // ask the sense to determine if I can be sensed under these
        // conditions 
        return sense.canObjBeSensed(self, trans, ambient);
      default:
        // for any other conditions, I can't be sensed at all
        return nil;
    }
  }
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: BATHROOM
// -------------------------------------------------------------------

bathroom: FormerRoomShadowCaster, AlienRoom 'Bathroom'
  "Apparently this room serves as a bathroom, although it has 
    few amenities. 
    <<bathToilet.isIn(bathroom)
      ? 'On one side of the room there is a toilet, while on 
          the other side a '
      : 'A '>>
    mirror hangs on the wall. 
    <<bathDoor.isOpen 
      ? 'An open door leads north to a hallway.' 
      : 'A closed door stands to the north.'>> "
  vocabWords       = 'bath bathroom/room'
  shadowVocabWords = 'bath bathroom/(room)'
  shadowList = [hallway5/*, dreamRoom*/]
  getDoorForLeavingRoom = bathDoor
  isInColumn = 3
  isInRow = 6
  north =   bathDoor
  out asExit(north)
  nearestHallway = hallway5
;

bathToilet: Toilet
  location = bathroom
  zapT = transform(self, bathOile)
;

mirror: /*SeeminglyFragile,*/ Fixture
  '(plate) glass mirror -' 'mirror'
  @bathroom
  desc {
    "It<./s>s a standard plate glass mirror. Looking into it,
      you see that "; //sic; finished by next line
    me.mirrorDesc;
  }
  shootEffectProp = &shootEffectMirror
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: CONFERENCE ROOM
// -------------------------------------------------------------------

// The conference room and its contents are defined in 1aliens.t.

modify confRoom
  vocabWords       = 'conference room'
  shadowVocabWords = 'conference (room)'
  shadowList = [museum, skyway, hallway9, stairs, hallway6]
  nearestHallway = hallway6
;

// -------------------------------------------------------------------
// BUILDING: ROOMS: MUSEUM
// -------------------------------------------------------------------

museum: FormerRoomShadowCaster, AlienRoom 'Museum'
  vocabWords       = 'museum/room'
  nearStateTokens = ['room']
  //shadowVocabWords = 'museum'
  //shadowList = [skyway, hallway9, stairs, hallway6, confRoom]
  desc {
    local occupiedPedestalCount = 0;
    local pluralPedestalArtifacts = nil;
    //local nominalArtifactInMuseumCount = 0;
    if (museumSign.isIn(self))
      "A large sign here welcomes you to the museum. ";
    "Much of this huge chamber is taken up by two platforms 
      that run the entire length of the western and eastern sides
      of the room. On display here are no fewer than 
      sixteen pedestals of various colors, 
      eight on each platform. ";
    "<p>The pedestals on the west platform are colored 
      (from left to right) black, navy, green, maroon, 
      teal, purple, olive, and silver. ";
    "<p>The pedestals on the east platform are colored
      (from left to right) gray, blue, lime, red, 
      aqua, fuchsia, yellow, and white. ";
    //for (local cur = firstObj(MaybeCountedAsArtifact); cur != nil; 
    //     cur = nextObj(cur, MaybeCountedAsArtifact)) {
    //  if (cur.countedAsArtifactForRoomDesc && cur.isIn(museum) 
    //      && cur.location.ofKind(Pedestal)) {
    //    occupiedPedestalCount++;
    //  }
    //}
    for (local cur = firstObj(Pedestal); cur != nil;
         cur = nextObj(cur, Pedestal)) {
      if (cur.isIn(museum) && 
          cur.contents.indexWhich({x: x.countedAsArtifactForRoomDesc}))
      {
        occupiedPedestalCount++;
        if (occupiedPedestalCount > 1)
          pluralPedestalArtifacts = true;
        if (!pluralPedestalArtifacts &&
            cur.contents.indexWhich({x: x.countedAsArtifactForRoomDesc}) !=
            cur.contents.lastIndexWhich({x: x.countedAsArtifactForRoomDesc}))
          pluralPedestalArtifacts = true;
      }
    }
    if (occupiedPedestalCount) {
      "<p>\^<<occupiedPedestalCount == 16 ? 'all ' : ''
        >><<spellInt(occupiedPedestalCount)>> of the pedestals
        contain<<occupiedPedestalCount == 1 ? 's' : ''>>
        <<pluralPedestalArtifacts ? 'artifacts' : 'an artifact'>> 
        on display. ";
    }
    //local k=inputManager.getKey(nil, nil);
    //if (k=='q') { k=0;k=k/k; }
    
    
    //"<p>Summary of things counted as artifacts for this room description: ";
    //for (local cur = firstObj(MaybeCountedAsArtifact); cur != nil; 
    //     cur = nextObj(cur, MaybeCountedAsArtifact)) {
    //  if (cur.countedAsArtifactForRoomDesc) {
    //    occupiedPedestalCount++;
    //    "<br><<cur.theName>> ";
    //    if (cur.isIn(museum)) {
    //      nominalArtifactInMuseumCount++;
    //      "(here in museum) ";
    //    }
    //  }
    //}
    //"<p>In the entire game there are <<occupiedPedestalCount>>
    //  nominal artifacts. Of those, <<nominalArtifactInMuseumCount>>
    //  are in the museum now. ";
  }
  isInColumn = 4
  isInRow = 1
  isInFishCorridor = true
  nearestHallway = hallway9
  south = skyway
  out asExit(south)
  adjustXYValuesOfAddedContents(newItem) {
    if (absVal(newItem.xValue) > 1)
      newItem.xBaseValue = 0;
    //callWithSenseContext(nil, nil, new function { "[museum.adjustXYValuesOfAddedContents] "; } );
  }
;

museumSign: Sign, Distant, Fixture
  '(museum) (welcome) sign/banner' 'sign'
  @museum
  "The sign is hung across the top of the ceiling. It reads, 
    <.q>Welcome to the Interactive Fiction Museum!<./q> "
;

class AlienPlatform: FormerShadowCaster, Platform, Fixture
  shadowList = [skyway, hallway9, stairs /*, hallway6, confRoom*/ ]
  objIsNearToThis(obj) {
    if (obj.getOutermostRoom != self.getOutermostRoom)
      return nil;
    // Let's be strict. To be near one of the platforms, you have to 
    // be on top of it. Not two inches to one side, but right on top 
    // of it. And not indirectly on top of it, either. 
    // Being on a pedestal on the platform doesn't count. 
    // Another point: ignore the yValue, since the platform runs 
    // vertically for the entire length of the room.
    if (obj.location == self)
      return true;
    return (obj.xValue == self.xValue);
  }
  dobjFor(Enter) asDobjFor(StandOn)
  dobjFor(Climb) asDobjFor(StandOn)
  dobjFor(ClimbUp) asDobjFor(StandOn)
  dobjFor(ClimbDown) asDobjFor(GetOffOf)
  // With this very simple implementation, just move the actor 
  // horizontally, not vertically, and hence onto to the nearest part
  // of the platform. Don't preferentially choose the middle of the 
  // platform or whatever.
  moveActorNearThis(actor) {
    if (getOutermostRoom != museum)
      return;
    actor.xBaseValue = self.xValue;
    //callWithSenseContext(nil, nil, new function { "[AlienPlatform.moveActorNearThis] "; } );
    actor.doXYConsequences;
  }
  adjustXYValuesOfAddedContents(newItem) {
    //callWithSenseContext(nil, nil, new function { "&lt;platform adjuster\&gt; "; } );
    newItem.xBaseValue = self.xValue;
    //callWithSenseContext(nil, nil, new function { "[AlienPlatform.adjustXYValuesOfAddedContents] "; } );
  }
  adjustXYValuesOfFallenContents(obj, target) {
    // adjusting the X value is presumably redundant, but here goes.
    obj.xBaseValue = self.xValue;
    // The Y value should be close to where the target was, unless
    // the platform itself was the target, in which case the Y value
    // will depend on where the actor threw from.
    if (target != self)
      obj.yBaseValue = target.goNearDest.proxyYValueForGoingNear;
    else if (gActor.getOutermostRoom != museum)
      obj.yBaseValue = -3;
    else 
      obj.yBaseValue = gActor.yValue;
  }
  yBaseValue = 0
  extendsOverAllYValues = true
  actorTravelingWithin(origin, dest) {
    if (self == dest && origin && origin.ofKind(Pedestal) && gActor == me &&
        me.yValue != origin.yValue)
      me.yBaseValue = origin.yValue;
  }
  getDropDestination(obj, path) {
    return self;
  }
  // I don't know for sure how getHitFallDestination works, but if
  // I understand it correctly, it seems to return the location that 
  // the projectile is supposed to fall onto, *assuming that no 
  // obstruction has prevented it from bouncing off this object*.
  // Therefore, under those circumstances, this object should
  // always have projectiles land upon it, so always return self.
  getHitFallDestination(thrownObj, path) {
    return self;
  }
  //dirAdj = 'west'
  //tRemAdj = 'wes'
;

// Modified so that throwing at the platforms (and anything else
// where getHitFallDestination == self) gives a suitable message.
modify DropTypeThrow
  standardReport(obj, dest) {
    if (target_ == dest.getNominalDropDestination())
      mainReport(&throwHitMsg, obj, target_);
    else
      mainReport(&throwHitFallMsg, obj, target_,
                 dest.getNominalDropDestination());
  }
;

//modify playerActionMessages
//  throwHitMsg(projectile, target) {
//    gMessageParams(projectile, target);
//    return '{The projectile/he} hit{s} {the target/him} without any
//      obvious effect. ';
//  }
//  throwHitFallMsg(projectile, target, dest) {
//    gMessageParams(projectile, target);
//    return '{The projectile/he} hit{s} {the target/him}
//      without any obvious effect, and fall{s projectile} '
//      + dest.putInName + '. ';
//  }
//  //customThrowHitMsg()
//;

westPlatform: AlienPlatform
  'west western left platform/dais*platforms*daises'
  'west platform'
  isInFishCorridor = true
  dirAdj = 'west'
  tRemAdj = 'Wesp'
  location = museum
  // This is too big to have a single yBaseValue. But I might as well
  // give it an xBaseValue.
  xBaseValue = -2
  zapT = die(
    'The ' + dirAdj + ' platform is transformed into '
        + Thing.aNameFrom(tRemAdj) + ' laform!
      <p>In case you didn<./s>t know, laforms are 
        a type of sailing vessel formerly used on the planet
        Zdad. What<./s>s more, this laform appears to have been
        built by the ' + tRemAdj + 's. This is highly significant, 
        because little is known about the ' + tRemAdj + 's, 
        an alien race who were always assumed to have died out before
        the great Zdadi age of shipbuilding. This 
        laform, however, single-handedly disconfirms
        all the usual assumptions about the ' + tRemAdj + 's. 
        This can only be called 
        the archaeological find of the decade.
      <p>Incidentally, another notable feature about this Wesp laform
        is that it has materialized right on top of you,
        crushing you and killing you instantly. '
    , 'Wesp laform', self, killEverybodyInRoom
  )
  zapAry = die(
    'The west platform is transformed into a pair of 
        pet flatworms!
      <p>Flatworms may not be common pets on Earth,
        but on the planet Zdad they are much prized
        and are bred for flatworm shows and other competitions.
      <p>Zdadi flatworms are not harmful to humans
        in and of themselves, but they often carry
        the virus known as Anthropophagus instantanius.
        This virus is especially communicable and deadly
        to humans, causing death within minutes.
      <p>These flatworms carry a typical complement 
        of the pathogens, so you die in short order. '
    , 'pet flatworms', self
    // Don't kill everybody in room, because only Neton or Ovan
    // could be in the room with you, and this is only deadly
    // to humans, not Oo.
    //,killEverybodyInRoom
  )
;

eastPlatform: AlienPlatform
  'east eastern right platform/dais*platforms*daises'
  'east platform'
  isInFishCorridor = true
  dirAdj = 'east'
  tRemAdj = 'Easp'
  location = museum
  // This is too big to have a single yBaseValue. But I might as well
  // give it an xBaseValue.
  xBaseValue = 2
  zapT = die(
    'The ' + dirAdj + ' platform is transformed into '
        + Thing.aNameFrom(tRemAdj) + ' laform!
      <p>In case you didn<./s>t know, laforms are 
        a type of sailing vessel formerly used on the planet
        Zdad. This one shows seems to have been built by
        the Easps, an ancient race well known for 
        having built ships on a truly monumental scale. 
        This laform is no exception; it must have capacity
        for eight hundred oarsmen, at least.
        Yes, this is a notable archaeological discovery. '
      //+ 'Easp ships like this one&huge and ungainly as they 
      //  were&mdash;ultimately contributed to the downfall
      //  of the Easps, who were defeated by more 
      //  the fatal Battle of Easptori Harbor.
      //  Sadly, the gargantuan size of such ships
      //  ultimately hurt the Easps more than it helped them,
      //  as demonstrated when the 
      //  good case in point;
      //  like most Easp laforms, this one was rather huge, 
      //  having been built to seat no fewer than four hundred oarmen.
      //  In this ship, as in all other Easp vessels, can be seen
      //  a preoccupation with size, rather than maneuverability.
      //  This vessel is a perfect example of how Easp shipwrights
      //  consistently focused on size, rather than maneuverability,
      //  which is one reason the Easps disappeared from history
      //  when they were defeated in naval warfare by the Hapnas. '
      + '<p>Incidentally, another notable feature about 
        this Easp laform
        is that it has materialized right on top of you,
        crushing you and killing you instantly. '
    , 'Easp laform', self, killEverybodyInRoom
  )
  // A non-functional red herring, so that when people decompile
  // my game, they may be tricked into thinking that I am actually
  // allowing this transformation:
  zapAry = die(
    'The east platform is transformed into foam splatter! 
        Since this foam is made of 
        a particularly dangerous kind of acid, it is 
        unfortunate that it has splattered all over you.
        You spend your last moments in agonizing pain. '
    , 'foam splatter', self
  )
;

modify Thing
  remoteSpecialDesc(pov) {
    if (getOutermostRoom.isAlienRoom && !isActor) return nil;
    return distantSpecialDesc;
  }
;

// -------------------------------------------------------------------
// BUILDING: DOORS AND DOORWAYS
// -------------------------------------------------------------------

modify Door
  lks = nil
  whatDesc = "Something which can be opened or closed, and
    which you can walk through to get from one place
    to another. "
;

class AlienDoor: Door
  vocabWords = '(green) (metal) door'
  name = 'door'
  desc = "The door is made of green metal. "
  makeOpen(stat) {
    inherited(stat);
    gPlayerChar.getOutermostRoom.doGlimpseFromHere;
  }
  hasBeenOpen = initiallyOpen
  dobjFor(KnockOn) {
    action {
      local dest = getDestination(gActor.getOutermostRoom, gActor);
      if (dest == cell && 
          (vicki.getOutermostRoom == dest 
           || diane.getOutermostRoom == dest)) {
        "You knock on <<theName>>. 
          <p>From behind <<theName>>, you hear a couple of voices
            excitedly murmur in reply. It<./s>s hard
            to tell, but the voices sound female. ";
      }
      else if (vicki.getOutermostRoom == dest 
          || diane.getOutermostRoom == dest) {
        "You knock on <<theName>>. 
          <p>From behind <<theName>>, you hear a voice yell
            something like, <.q>Stop fooling around.
            Come on, <<me.firstName>>!<./q> ";
      }
      else if (dest == bathroom && 
        (youngGuard.getOutermostRoom == dest 
         || oldGuard.getOutermostRoom == dest))
      {
        "You knock on <<theName>>. 
          <p>From behind <<theName>>, you hear a voice mumble
            a reply in Oo, something like, 
            <.q>Be out in a few minutes.<./q> ";
      }
      else if (assistant.getOutermostRoom == dest) {
        "You knock on <<theName>>. 
          <p>From behind <<theName>>, you hear a voice mumble
            a reply in Oo, something like, 
            <.q>The door<./s>s unlocked.<./q> ";
      }
      else {
        inherited;
      }
    }
  }
  wordName = 'door'
  zapAry = die(
    'The door disappears! Just as it does so, you smell
      a distinctive odor. It smells like nothing so much as 
      mustard gas. '
    , 'odor', 'door', killEverybody
  )
;

class AlienDoors: AlienDoor
  vocabWords = '(green) (metal) doors'
  name = 'doors'
  desc = "The doors are made of green metal. "
  isPlural = true
  // if I put "doors", it'll count as a second achievement point on top of "door"
  wordName = 'door' 
  zapAry = die(
    'The doors disappear! Just as they do so, you notice 
      a couple of distinctive odors. The first of them 
      smells like nothing so much as mustard gas.
      Then, as if this weren<./s>t enough, this 
      is overtaken by a second odor: the almond smell 
      of hydrogen cyanide. '
      // if I put "odors", it'll count as a second achievement point
    , 'odor', self, killEverybody
  )
;

officeDoor: AlienDoor
  location = office
  //initiallyOpen = true
;

officeDoor2: AlienDoor -> officeDoor
  location = hallway8
;

dreamDoor: AlienDoor
  location = dreamRoom
  noteTraversal(traveler) {
    // If I do a glimpse from Hallway 5 here and update the banner, 
    // it will set the banner to the new width before doing any
    // text output. This will set the text part of the main window
    // to the proper width for any calculations of when to say
    // "Press space to continue".
    if (!me.hasSeen(hallway5)) {
      hallway5.doGlimpseFromHere;
      nbmBanner.updateMe;
    }
    if (traveler == me && glob.endgameJeopardy && glob.enemyState == arguing) {
      "As you step through the door, you hear Ovan say 
          behind your back, <.q>What the&mdash;! 
          He<./s>s escaping!<./q>
        <p><.q>Grab your weapon!<./q> Neton cries. <.q>After him!<./q> ";
      letProfsExitOffice();
      glob.enemyState = waiting;
    }
  }
;

dreamDoor2: AlienDoor -> dreamDoor '(green) (metal) north door' 'north door'
  location = hallway5
;

//niftyBox: LockableWithKey, Thing
//  'nifty box'
//  'nifty box'
//  @dreamRoom
//;

class Slot: Slotlike, Fixture
  vocabWords = '(small) (keycard) slot/hole/slit/opening'
  name = 'slot'
  nameForRoom = 'small slot'
  iobjFor(PutIn) {
    verify {
      if (gDobj && gDobj != keycard)
        illogical('It doesn<./s>t look like {the dobj/he}
          would fit in {the iobj/him}. ');
    }
    check { }
    action {
      keycard.obviouslyUnlocks = true;
      // If the cell door is locked, inserting the keycard always
      // unlocks it.
      if (cellDoor.isLocked) {
        "As you insert the keycard, a bright green light flashes 
          from inside the slot, and <<asscDoor.theName>> 
          gives a quiet click. You retract the card. ";
        asscDoor.makeLocked(nil);
      }
      // If the cell door is unlocked, and if we're configured
      // so the keycard can lock the cell door, then lock the door.
      else if (canLockDoor) {
        "As you insert the keycard, a bright red light flashes 
          from inside the slot, and <<asscDoor.theName>> 
          gives a quiet click. You retract the card. ";
        asscDoor.makeLocked(true);
      }
      // Otherwise, do nothing.
      else {
        "You insert the keycard, but nothing happens. 
          You retract the card. ";
      }
    }
  }
  asscDoor {
    if (isIn(cell))
      return cellDoor;
    else
      return cellDoor2;
  }
  // I debated with myself whether I should do one or the other of
  // the following scenarios:
  // 1. The keycard can only be used to unlock the door, never
  //    to lock it. The door automatically locks itself whenever
  //    it is closed. (Slot.canLockDoor = nil)
  // 2. The keycard can be used to either lock or unlock the door.
  //    Closing the door does not automatically lock it.
  //    (Slot.canLockDoor = true)
  // Scenario 1 is more consistent with how keycards actually work
  // in my experience. But Scenario 2 has an **enormous** advantage:
  // If the door doesn't automatically lock itself when closed,
  // then you can't lock yourself in the cell, and in that case I don't have to
  // program a response to that circumstance. For instance, 
  // in that case I wouldn't have to deal with the question 
  // of whether Vicki and Diane should rescue you if you leave 
  // the keycard outside the cell where they're standing before 
  // you lock yourself in. Yeah, Scenario 2 looks better to me.
  canLockDoor = true
  zapT = transform(self, asscSlo)
  zapTCq {
    if (glob.prisonersTrapped)
      noteMistake('Now that you<./s>ve wrought this transformation');
  }
;

modify glob
  prisonersTrapped {
    return (vicki.getOutermostRoom == cell && me.getOutermostRoom != cell);
  }
;

class Slotlike: object
;

class Slo: Slotlike, Nonsense, Fixture
  '(small) slo'
  'slo'
  nameForRoom = 'small slo'
;

hallwaySlo: Slo
;

cellSlo: Slo
;

hallwaySlot: Slot
  location = hallway3
  asscSlo = hallwaySlo
  desc =
    "The slot is about three inches wide. It is embedded 
      in the wall, just to the right of the south door. "
;

cellSlot: Slot
  // I've decided I don't want a slot in the cell after all.
  //location = cell 
  asscSlo = cellSlo
  desc =
    "The slot is about three inches wide. It is embedded 
      in the wall, just to the left of the north door. "
;

class DoorNearCell: Lockable, AlienDoor
  basicExamine {
    inherited;
    if (asscSlotlike)
      "Beside the door is a <<asscSlotlike.nameForRoom>>. ";
  }
  dobjFor(Open) {
    preCond {
      local ret = nilToList(inherited());
      // When the door is locked and the player types OPEN DOOR
      // or GO THROUGH DOOR, should we make an automatic implicit
      // attempt to unlock the door? Not at first, no.
      // Don't do so until we already know that the keycard can be
      // used to unlock this door.
      if (keycard.obviouslyUnlocks) //if (autoUnlockOnOpen)
        ret += objUnlocked;
      return ret;
    }
    check {
      hasClearlyBeenLocked = true;
      inherited;
    }
  }
  dobjFor(Lock) {
    check {
      if (!asscSlot) {
        say(lockNoSlotMsg);
        exit;
      }
    }
    action {
      askForIobj(LockWith);
    }
  }
  dobjFor(LockWith) {
    verify { verifyDobjLock; } // makes sure it's not already locked
    check { checkDobjLock; } // makes sure there's actually a keycard slot.
    action {
      replaceAction(PutIn, gIobj, asscSlot);
    }
  }
  dobjFor(Unlock) {
    check {
      if (!asscSlot) {
        say(unlockNoSlotMsg);
        exit;
      }
    }
    action {
      askForIobj(UnlockWith);
    }
  }
  dobjFor(UnlockWith) {
    verify { verifyDobjUnlock; } // makes sure it's not already unlocked
    check { checkDobjUnlock; } // makes sure there's actually a keycard slot.
    action {
      replaceAction(PutIn, gIobj, asscSlot);
    }
  }
  asscSlot {
    if (isIn(cell)) {
      if (cellSlot.location != nil)
        return cellSlot;
      else
        return nil;
    }
    else {
      if (hallwaySlot.location != nil)
        return hallwaySlot;
      else
        return nil;
    }
  }
  asscSlotlike {
    local idx = location.contents.indexWhich({x: x.ofKind(Slotlike)});
    if (idx)
      return location.contents[idx];
    else
      return nil;
  }
  initiallyLocked = true
  hasClearlyBeenLocked = nil
  lockStatusObvious = nil
  cannotLockMsg = &unknownHowToLockMsg
  cannotUnlockMsg = &unknownHowToUnlockMsg
  //unknownHowToLockMsg = 'It<./s>s not clear how to lock {the dobj/him}' 
  //  + (glob.isInEndgame && isIn(cell) ? ' from this side' : ', DUDE') +  '. '
  //unknownHowToUnlockMsg = 'It<./s>s not clear how to unlock {the dobj/him}' 
  //  + (glob.isInEndgame && isIn(cell) ? ' from this side' : ', DUDE') +  '. '
  lockNoSlotMsg =
    'It<./s>s not clear how to lock the door' 
      + (glob.isInEndgame && isIn(cell) 
        ? ' from this side; there<./s>s no slot here' : '') + '. '
  unlockNoSlotMsg =
    'It<./s>s not clear how to unlock the door' 
      + (glob.isInEndgame && isIn(cell) 
        ? ' from this side; there<./s>s no slot here' : '') + '. '
;

modify cellDoor // see 1prisoners.t
;

cellDoor2: DoorNearCell -> cellDoor '(green) (metal) south door' 'south door'
  location = hallway3
#ifdef __DEBUG
  dobjFor(Open) {
    verify () {
      if (!isOpen)
        logicalRank(160, 'an especially good door to open');
    }
  }
#endif  // __DEBUG
  lockNoSlotMsg =
    'Without any slot near the door, it<./s>s not clear how to
      lock it. '
  unlockNoSlotMsg =
    'Without any slot near the door, it<./s>s not clear how to
      unlock it. '
;

breakDoor: AlienDoor
  location = breakRoom
  initiallyOpen = true
;

breakDoor2: AlienDoor -> breakDoor
  location = hallway4
  dobjFor(All) {
    action() {
      if ((youngGuard.isIn(breakRoom) || oldGuard.isIn(breakRoom)) && gAction &&
           (gAction.baseActionClass != ExamineAction
            && gAction.baseActionClass != ReadAction
            && gAction.baseActionClass != ListenToAction
            && gAction.baseActionClass != SmellAction
            && gAction.baseActionClass != AskForAction
            && gAction.baseActionClass != TalkToAction
            && gAction.baseActionClass != AskAboutAction
            && gAction.baseActionClass != TellAboutAction
            //Note: if there is ever a WhoIsAction, it should go here.
            ))
        uhOh;
      else
        inherited;
    }
  }
  iobjFor(All) {
    action() {
      if (youngGuard.isIn(breakRoom) || oldGuard.isIn(breakRoom))
        uhOh;
      else
        inherited;
    }
  }
  uhOh() {
    "As you turn towards the door, the alien guard turns
      and sees you! In a flash he grabs his gun and fires
      at you. For a moment you are engulfed in blinding light
      and agonizing pain. Then <<glob.youCollapseToTheFloor>>. ";
    youngGuard.killPcAmusingly;
    //"In case it matters to you, the guard did not intend to
    //  kill you. His weapon was set to <.q>stun,<./q> but it was 
    //  incorrectly callibrated for human beings. When Neton and
    //  Ovan find out about this, they sigh in frustration, 
    //  but they get over it soon enough. What<./s>s one human being, 
    //  more or less? ";
    endGame(ftDeath);
  }
;

bathDoor: AlienDoor
  location = bathroom
;

bathDoor2: AlienDoor -> bathDoor '(green) (metal) south door' 'south door'
  location = hallway5
;

modify confDoor // see 1aliens.t
;

confDoor2: AlienDoor -> confDoor
  location = hallway6
;

hallDoors: AlienDoors '(green) (metal) north doors' 'north doors'
  location = hallway3
;

hallDoors2: AlienDoors -> hallDoors
  location = hallway2
;

frontDoors: AlienDoors '(green) (metal) front doors' 'front doors'
  "The doors are made of green metal, and seem
    thicker and better insulated than the others in 
    the building. You guess that these doors might
    lead outside. "
  location = hallway1
  obviouslyLeadOutside = nil
  //makeOpen(stat) {
  //  inherited(stat);
  //  if (me.canSee(self))
  //    obviouslyLeadOutside = true;
  //}
  hasBeenOpenedByPc = nil
  hasWarnedOfAbandonment = nil
  okayOpenMessage {
    if (!hasBeenOpenedByPc)
      return
        'You open the front doors, letting in the bright sun
          of the outside world. ';
    else
      return inherited;
  }
  dobjFor(Open) {
    action {
      //makeOpen(true);
      //defaultReport(&okayOpenMsg);
      inherited;
      if (!gAction.isImplicit)
        hasBeenOpenedByPc = true;
    }
  }
  dobjFor(TravelVia) {
    check {
      if (!vicki.rescued && !hasWarnedOfAbandonment) {
        if (!hasBeenOpenedByPc)
          "As you open the doors, you see that they lead to the 
              bright sun of the outside world.
            <p>You start to walk through the doors, ";
        else
          "You start to walk through the doors into the 
            outside world, ";
        "but then you think. You<./s>re sure that Vicki and Diane are 
          imprisoned somewhere inside this building. 
          Before you abandon them, you might consider trying harder
          to find a way to rescue them. ";
        hasBeenOpenedByPc = true;
        hasWarnedOfAbandonment = true;
        exit;
      }
    }
    // If you go through this door, instead of going to
    // another room, you will simply finish the game. Therefore,
    // we override frontDoors.actionDobjTravelVia().
    // 
    // There are four possibilities here:
    // (1) You rescued Vicki and Diane, and they are
    // accompanying you as you leave. You win with the best 
    // ending.
    // (2) You leave without rescuing Vicki and Diane. You win, 
    // so to speak, but this is by no means the best ending.
    // (3) You rescued Vicki and Diane, but they are not 
    // accompanying you, because they got sick of waiting for you 
    // and left the building before you did. You win with the 
    // best ending, though it is worded a bit differently than #1.
    // (4) You rescued Vicki and Diane, but -- special case 
    // here -- you then shot at them using a range weapon. 
    // They will have left the building before you in this case, 
    // and when you leave the building, they'll ambush you and 
    // kill you.
    action {
      local scenario = 0;
      if (vicki.isAntagonized)
        scenario = 4;
      else if (vicki.getOutermostRoom == cell)
        scenario = 2;
      else if (vicki.getOutermostRoom)
        scenario = 1;
      else
        scenario = 3;
      // Move the PC and any NPCs out of the building, just
      // to clear the map.
      me.moveInto(northOfHallway1);
      if (vicki.getOutermostRoom)
        vicki.scMoveInto(nil);
      if (diane.getOutermostRoom)
        diane.scMoveInto(nil);
      //if (gKey()) { local k = 0; k=k/k; }
      // First, get the the least likely scenario out of the way.
      // If you have incurred Vicki and Diane's wrath, then
      // it's time to die. Or lose, anyway.
      if (scenario == 4) { // You attacked Vicki and Diane.
        "You walk out through the front doors 
            into the outside world.
          <p>You are only outside for a few seconds, however, 
            when suddenly Diane leaps out from behind a bush 
            and punches you in the face. 
            <.q>Take that, asshole!<./q> she shouts. 
          <p>Then, just as you<./s>re trying to think of a reply, 
            she hits you again. This time her blow is even harder, 
            knocking you off balance. 
            You fall, hit your head against the ground, 
            and lose consciousness.
          <p>Hours later, when you wake up, 
            you find that you are locked 
            in the cell once again. This time, however, 
            when your new alien captors come to greet you, 
            they are not so kind. ";
        // I suppose we should visually represent the fact
        // that you've been recaptured.
        me.moveInto(cell);
        cellDoor.makeOpen(nil);
        endGame(ftCaptured);
      }
      // In all other cases -- i.e., Scenarios 1-3 --
      // you are either victorious or semi-victorious.
      else {
        "\^";
        if (scenario == 1)
          "<.q>Wait here while I go through,<./q> you say.
            <p>And with that, ";
        "you walk out through the front doors 
            into the outside world. 
            For a moment you are struck by the beauty 
            of the world around you, 
            the trees and shrubs, the lawns and paths. 
            The bright sun is shining down. 
            It's a perfect spring day. ";
        if (scenario == 3)
          "Furthermore, you seem to have been 
              extraordinarily lucky. No aliens are in sight.
            <p>Then, suddenly, Vicki and Diane come out 
              from behind a nearby bush. 
            <p><.q>Finally you<./s>re here!<./q> says Vicki. 
            <p><.q>Come on! This way!<./q> says Diane urgently, 
              motioning in a direction that seems 
              relatively secluded. You and Vicki follow. 
            <p>";
        if (scenario == 1 || scenario == 2) {
          "<p>";
          if (scenario == 1)
            "But you don<./s>t forget your task for long.
              Glancing at the alien buildings nearby, you see that
              none of them ";
          else
            "There are alien buildings nearby, 
              but none ";
          "show any signs of life. 
              You squint off down the paths, 
              but they all seem deserted. 
              You seem to have been extraordinarily lucky. 
              No one is in sight. 
            <p>\^";
          if (scenario == 1)
            "<.q>Come on, the coast is clear!<./q> 
                you call to Vicki and Diane. 
              <p>Then the two of them follow you outside, and ";
          "you hurry off in a direction that seems 
              relatively secluded. ";
        }
        "By some miracle, 
            <<scenario == 3 ? 'the three of ' : ''>>you 
            work your way past several buildings without being seen. 
            Eventually you wander into farm country, 
            and from there to a wooded streambed, where 
            you camp for the night.
          <p>As you settle in to sleep, you reflect 
            that your troubles are far from over. 
            Life will be difficult in the hostile alien world 
            that Earth has become. ";
        if (scenario == 2)
          "<p>Furthermore, you can<./s>t help but be troubled 
              by the fact that you failed to rescue Vicki and Diane. 
              They might have helped you to survive in this 
              enemy territory. What<./s>s more, it<./s>s probably 
              too late to rescue them now. By this time, 
              the aliens will probably have added a lot more guards 
              around their cell, if they haven<./s>t done worse. 
            <p>You<./s>ll just have to get by on your own.
              As will they. ";
        if (scenario == 1 || scenario == 3)
          "<p>When you fall asleep, you hope to dream about your old
              twenty-first century home. To your disappointment, 
              however, you end up
              dreaming about fish pudding and strawberry yams. ";
        // If you didn't rescue Vicki and Diane, don't give a 
        // complete victory.
        if (scenario == 2) {
          // Note that ftEscape.isWinningEnding == nil.
          // The only practical upshot of this is that you won't 
          // see the AMUSING option at the end.
          endGame(ftEscape);
        }
        // If you did rescue Vicki and Diane, then you win with
        // the best ending!
        // 
        // ****************************
        // ** triumphant best ending **
        // ****************************
        else { // scenario == 1 or 3
          // We've just said that the PC (and maybe NPCs)
          // left the building. So before we pause for the player
          // to press a key, we should really update the banner
          // to reflect the changes.
          nbmBanner.updateMe;
          
          // Pause for input before showing the final graphics
          // and music.
          nbmPause();
          
          //// Clear the main window; banner is coming
          //nbmCls();
          
          // I think I should ensure the status line is blank
          glob.status = blank;
          statusLine.showStatusLineDaemon();
          
          // Remove the regular banner
          nbmBanner.removeBanner();
          
          // "The end," plus accompanying fanfare
          if (glob.imageSize == 1) {
            csDispImg('illustrations/theend1_0300.jpg');
          }
          else {
            csDispImg('illustrations/theend1_0469.jpg');
          }
          playSound('<sound src=\"sound/fanfare1.mp3\" layer=foreground>');
          
          // Pause for input
          nbmPause();
          
          // Clear the cut scene banner
          cutSceneBanner.clearWindow();
          
          // "Or is it?" plus accompanying fanfare
          if (glob.imageSize == 1) {
            csDispImg('illustrations/theend3_0300.jpg');
          }
          else {
            csDispImg('illustrations/theend3_0469.jpg');
          }
          playSound('<sound src=\"sound/fanfare2.mp3\" layer=foreground>');
          // Pause for input
          nbmPause();
          // Remove the cut scene banner
          cutSceneBanner.removeBanner();
          // Reinstate the regular banner
          nbmBanner.updateMe();
          
          // You win!
          endGame(ftVictory);
        }
      }
      //if (vicki.getOutermostRoom == cell) {
      //  "To heck with Vicki and Diane, you think. 
      //    And with that, you exit the building. ";
      //  //local k = inputManager.getKey(nil, nil);
      //  //if (k.toLower == 'q') { k=0; k=k/k; }
      //  me.moveInto(northOfHallway1);
      //  endGame(ftEscape);
      //}
      //else if (vicki.getOutermostRoom ||
      //         (!vicki.getOutermostRoom && !vicki.isAntagonized)) {
      //  if (vicki.getOutermostRoom) {
      //    "You step out of the building, with Vicki and Diane
      //      at your side. ";
      //    vicki.scMoveInto(nil);
      //    diane.scMoveInto(nil);
      //  }
      //  else {
      //    "You step out of the building, where you meet up
      //      with Vicki and Diane. ";
      //  }
      //  "<p>You've escaped the aliens. 
      //    What will life bring you now? Only time will tell! ";
      //  me.moveInto(northOfHallway1);
      //  endGame(ftVictory);
      //}
    }
  }
;

frontDoors2: AlienDoors -> frontDoors
  location = northOfHallway1
;

hallDoorway: ThroughPassage 'wide doorway' 'doorway'
  location = hallway6
;

hallDoorway2: ThroughPassage -> hallDoorway 'wide doorway' 'doorway'
  location = hallway5
;

// -------------------------------------------------------------------
// BUILDING: MISCELLANEOUS: ALIEN SENSE CONNECTOR
// -------------------------------------------------------------------

// For the sense connector, see 3endgame_old.t.

// -------------------------------------------------------------------
// BUILDING: MISCELLANEOUS: BULK STUFF
// -------------------------------------------------------------------

modify Thing
  weight = 1
  bulk = 3 // 3 deciliters
;

modify NestedRoom
  bulkCapacity = 2147483647
;

modify Chair
  bulkCapacity = 700
;

modify Actor
  bulkCapacity = 2147483647
  maxSingleBulk = 700
  weightCapacity = 2147483647
  bulk = 700 // 700 deciliters == 70 L ~= about 155 pounds.
;

modify Person
  bulk = 700 // 700 deciliters = 70 L ~= about 155 pounds.
;

modify NonPortable
  weight = 0
  bulk = 0
;

modify BulkLimiter
  bulkCapacity = 2147483647
  maxSingleBulk = 700
;

modify playerActionMessages
    cannotFitIntoOpeningMsg(obj, cont) {
        //return tooLargeForContainerMsg(obj, cont)
        gMessageParams(obj, cont);
        return '{The obj/he} {is} too big to fit into {the cont/him}. ';
    }
    tooLargeForContainerMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{The obj/he} {is} too big to fit ' 
          + (cont ? cont.objInPrep : 'in')
          + 'to {the cont/him}. ';
    }
;

// I'll have to be very careful to define the bulkCapacity
// and maxSingleBulk for all containers, surfaces, platforms, etc.
// It's really kind of weird that a platform has the same maxSingleBulk
// as a Container, for instance.


// -------------------------------------------------------------------
// INTRA-ROOM STUFF: xValue, yValue, etc.
// -------------------------------------------------------------------

modify Thing
  prevLoc = nil
;

modify Thing
  xBaseValue = 0
  yBaseValue = 0
  xValue() {
    if (!considerReferringHereForXyValues || location == nil)
      return 0;
    if (!location.considerReferringHereForXyValues)
      return xBaseValue;
    return location.xBaseValue;
  }
  yValue() {
    if (!considerReferringHereForXyValues || location == nil)
      return 0;
    if (!location.considerReferringHereForXyValues)
      return yBaseValue;
    return location.yBaseValue;
  }
  xOffset = 0
  yOffset = 0
  lkl = nil
  lkh = 0
  lkv = 0
;

modify Alien
  realLocationBeforeMove = nil
  getOutermostRoomBeforeMove = nil
  yValueBeforeMove = nil
  yOffsetBeforeMove = nil
  xValueBeforeMove = nil
  xOffsetBeforeMove = nil
;

modify Thing
  considerReferringHereForXyValues = true
;
modify Room
  considerReferringHereForXyValues = nil
;
modify AlienPlatform
  considerReferringHereForXyValues = nil
  xValue = xBaseValue
;

modify neton
  xBaseValue = -1
;
modify ovan
  xBaseValue = 1
;

modify Thing
  baseMoveInto(newContainer) {
    inherited(newContainer);
    if (newContainer && newContainer.ofKind(Thing))
      newContainer.adjustXYValuesOfAddedContents(self);
  }
  adjustXYValuesOfAddedContents(newItem) {
    // do nothing by default
  }
;

// Unfortunately, our modeling of actors' locations in the endgame
// is *vastly* complicated by the fact that we need to know not only
// what the actor's location value is (usually a Room), but also 
// where the actor is in that room.

//modify me
//    travelWithin(dest)
//    {
//        local origin;
//
//        /* if I'm not going anywhere, ignore the operation */
//        if (dest == location)
//            return;
//
//        /* remember my origin */
//        origin = location;
//        
//        /* notify the source that we're traveling within a room */
//        if (origin != nil)
//            origin.actorTravelingWithin(origin, dest);
//
//        /* 
//         *   if our origin and destination have different effective follow
//         *   locations, track the follow 
//         */
//        if (origin != nil
//            && dest != nil
//            && origin.effectiveFollowLocation != dest.effectiveFollowLocation)
//        {
//            /* 
//             *   notify observing objects of the travel; we're not moving
//             *   along a connector, so there is no connector associated
//             *   with the tracking information 
//             */
//            connectionTable().forEachAssoc(
//                {obj, val: obj.beforeTravel(self, nil)});
//        }
//        
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before moveInto&gt; "; } ); }
//        /* move me to the destination */
//        moveInto(dest);
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem after moveInto&gt; "; } ); }
//
//        /* 
//         *   recalculate the global sense context for message generation
//         *   purposes, since we've moved to a new location 
//         */
//        if (gAction != nil)
//            gAction.recalcSenseContext();
//
//        /* notify the destination of the interior travel */
//        if (dest != nil)
//            dest.actorTravelingWithin(origin, dest);
//    }
//    moveInto(newContainer) {
//        local origin = location;
//        local dest = newContainer;
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before moveIntoNotifyPath&gt; "; } ); }
//        moveIntoNotifyPath(newContainer);
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before mainMoveInto&gt; "; } ); }
//        mainMoveInto(newContainer);
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem after mainMoveInto&gt; "; } ); }
//    }
//    mainMoveInto(newContainer)
//    {
//        local origin = location;
//        local dest = newContainer;
//        
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before sendNotifyRemove&gt; "; } ); }
//            
//        sendNotifyRemove(self, newContainer, &notifyRemove);
//        
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before sendNotifyInsert&gt; "; } ); }
//            
//        if (newContainer != nil)
//            newContainer.sendNotifyInsert(self, newContainer, &notifyInsert);
//            
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before notifyMoveInto&gt; "; } ); }
//            
//        notifyMoveInto(newContainer);
//        
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem before baseMoveInto&gt; "; } ); }
//            
//        baseMoveInto(newContainer);
//        
//        if (origin && origin.ofKind(Pedestal) && dest && dest.ofKind(AlienPlatform) && 
//            me.yValue != origin.yValue)
//            { callWithSenseContext(nil, nil, new function { "&lt;yValue problem after baseMoveInto&gt; "; } ); }
//        moved = true;
//    }
//;

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: absoluteXValue, absoluteYValue
// -------------------------------------------------------------------

/*
                                    [400, 50]
                                        |
                                        |
                                    [400,200]
                                        |
                                        |
[100,300]   [200,300]---[300,300]   [400,300]
    |           |                       |
    |           |                       |
[100,400]   [200,400]   [300,400]   [400,400]
    |           |           |           |
    |           |           |           |
[100,500]---[200,500]---[300,500]---[400,500]
    |           |           |           |
    |           |           |           |
[100,600]   [200,600]   [300,600]   [400,600]
*/

modify Thing
  absoluteXValue {
    if (!getOutermostRoom || (getOutermostRoom == self && !self.ofKind(Room)))
      return -1000;
    return getOutermostRoom.isInColumn * 100 + (xValue * 25);
  }
  absoluteYValue {
    if (!getOutermostRoom || (getOutermostRoom == self && !self.ofKind(Room)))
      return -1000;
    if (getOutermostRoom == museum)
      return 50 - (yValue * 25);
    else
      return getOutermostRoom.isInRow * 100 - (yValue * 25);
  }
  absYValForShooting {
    if (getOutermostRoom == museum)
      return 100;
    else
      return absoluteYValue;
  }
;

modify RoomPart
  absoluteXValue {
    return gActor.getOutermostRoom.absoluteXValue;
  }
  absoluteYValue {
    return gActor.getOutermostRoom.absoluteYValue;
  }
;

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: Core code
// -------------------------------------------------------------------

// My comments, circa 2005-2006 or so:
// The following TIAction modifications were copied pretty much verbatim
// from commonSpace.t, part of Eric Eve's ConSpace extension.
// Unless I miss my guess, it will work as I want it to
// for my purposes.

// My comments, June 2010:
// Yikes! I've been updating my code from TADS 3.0.8 to 3.0.18, and 
// this section of code is the one that gives me the greatest worry.
// 
// This small section is pretty fundamental, or so I thought. It was 
// originally drawn from commonSpace.t, and yet the new version of 
// commonSpace.t (v2.1) completely omits it, while recent versions 
// of the TADS 3 library give a completely different implementation of 
// TIAction.checkPreconditions() and new ancillary methods to go 
// with it.
// 
// I guess the answer is to omit this section, cross my fingers, and 
// let the tests begin...

// Further thoughts, still June 2010:
// For future reference, the TADS 3 version that obviated the following code 
// was 3.0.9 (August 2005), and in the version comments it says this 
// regarding this particular change:
/*
It's now possible to control the order in which preconditions are executed, 
at the level of the individual preconditions. The new PreCondition property 
preCondOrder gives the order of execution of a given precondition. The 
default for most types of preconditions is 100; for TouchObjCondition (and 
thus for touchObj), it's 200, which means that touchObj conditions will 
execute after other conditions by default.

It's occasionally useful to be able to fine-tune precondition order because 
preconditions can sometimes interfere with one another. This is 
particularly a problem with implied actions that require the actor to be 
in a particular posture or location, because many of the standard 
preconditions can move the actor around as a side effect. For example, 
a doorOpen condition could execute an implied STAND as part of its implied 
OPEN DOOR; if another precondition requires the actor being to be sitting, 
its effect would be undone if the doorOpen were executed second. We can 
safely STAND and OPEN DOOR first, then SIT DOWN second, because we'll 
still satisfy the doorOpen condition even though we're no longer standing 
when we're done.

In addition to the new preCondOrder ordering, the default ordering has 
changed for two-object verbs (those with direct and indirect objects). 
By default, the direct object preconditions are now executed first, 
followed by the indirect preconditions; in the past this order was 
reversed. This is only the default order - the preCondOrder takes 
precedence. That is, the action builds a list consisting of the direct 
object preconditions followed by the indirect object preconditions, then 
sorts that list in ascending order of preCondOrder, preserving the 
existing relative order of objects with the same preCondOrder. 
*/

/*
modify TIAction
  checkPreConditions(allowImplicit) {
    local ret1;
    local ret2;         
    // If there's an objHeld precondition it needs to be dealt with first,
    // so that the actor collects any object that needs to be held before
    // taking it to the other object. We therefore check whether there's
    // an objHeld precondition on the indirect object.
    // 
    // We also check for the presence of the dummy objFirst precondition
    // on the indirect object. This allows the usual order to be reversed
    // on a custom basis for any other problem cases where the indirect 
    // object preconditions need to be taken first.
    local lst = getObjPreConditions(iobjCur_, preCondIobjProp, IndirectObject);         
    local checkIobjPreCondFirst = (lst != nil 
      && (lst.indexOf(objHeld) != nil || lst.indexOf(objFirst) != nil));
    // inherit default handling to check our action-level conditions
    // and our direct-object conditions. We do this before the indirect
    // object preconditions unless we found an objHeld or objFirst 
    // precondition on the indirect object.
    if(!checkIobjPreCondFirst)
      ret1 = delegated TAction(allowImplicit);
    // check conditions on the indirect object, if any
    ret2 = callPreConditions(iobjCur_, preCondIobjProp, iobjCur_,
                             allowImplicit, IndirectObject);
    if(checkIobjPreCondFirst)
      ret1 = delegated TAction(allowImplicit);         
    // return true if any implicit commands were executed
    return ret1 || ret2;
  }
;

// This dummy precondition is also copied verbatim from commonSpace.t, 
// part of Eric Eve's ConSpace extension.
objFirst: PreCondition
;
*/

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: implicitAnnouncementGrouper
// -------------------------------------------------------------------

// Modified to add "then's" as follows:
// >get pizza
// (first getting off of the black pedestal, *THEN* getting off of the west platform, 
// *THEN* standing on the east platform, then going over to the pizza)
// Taken.

// As of more recent TADS 3 versions, this modification is no longer necessary.

/*
modify implicitAnnouncementGrouper
    compositeMessage(lst)
    {
        local txt;
        local ctx = new ListImpCtx();
        for (txt = '', local i = 1, local len = lst.length() ; i <= len ; ++i)
        {
            local curTxt;
            local cur = lst[i];
            ctx.isInSublist = nil;
            ctx.setBaseCtx(cur);
            curTxt = cur.getMessageText(
                cur.getAction().getOriginalAction(), ctx);
            while ((cur.justTrying && i < len && lst[i+1].justTrying)
                   || (cur.justAsking && i < len && lst[i+1].justAsking))
            {
                local addTxt;
                ++i;
                cur = lst[i];
                ctx.isInSublist = true;
                if (keepAllFailures)
                {
                    addTxt = cur.getMessageText(
                        cur.getAction().getOriginalAction(), ctx);
                    if (addTxt != '' && curTxt != '')
                        curTxt += ' and then ' + addTxt;
                    else if (addTxt != '')
                        curTxt = addTxt;
                }
            }
            if (txt != '' && curTxt != '')
            {
                if (i + 1 <= len)
                    
                    
                    // BEGIN HACK
                    txt += ', then '; //txt += ', ';
                    // END HACK
                    
                    
                else
                    txt += ', then ';
            }
            txt += curTxt;
        }
        if (txt == '')
            return '';
        return standardImpCtx.buildImplicitAnnouncement(txt);
    }
;
*/

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: TouchObjCondition
// -------------------------------------------------------------------

// Note (written 2016-11-09): TouchObjCondition.checkPreCondition 
// is hacked both here and in 1conf.t. This works because of the use of 
// inherited() in this latter hack.

modify TouchObjCondition
  checkPreCondition(obj, allowImplicit) {
    //local pastObs;
//    // Within a particular set of rooms in the endgame, we completely
//    // replace the normal touchObj handling.
//    if (gActor.location != nil && gActor.getOutermostRoom.isInFishCorridor 
//        && obj && obj.location && obj.getOutermostRoom == gActor.getOutermostRoom 
//        && !(gActionIs(GoNear)) 
//        && (!gActionIs(StandOn) || !gAction.parentAction || !gAction.parentAction.ofKind(GoNearAction))) {
//      //callWithSenseContext(nil, nil, new function { "[TouchObjCondition special case] "; } );
//      if (gActor.pcIsNear(obj)) {
//        return true;
//      }
//      if (allowImplicit && tryImplicitAction(GoNear, obj)) {
//        // We just tried the implicit command. If it failed,
//        // abort.
//        if (!gActor.pcIsNear(obj))
//          exit;
//        // Otherwise, tell the caller we executed an implied
//        // command.
//        return true;
//      }
//      // I seriously hope this never happens, but we need to
//      // deal with the case where, for one reason or another,
//      // the necessary implicit action can't take place.
//      reportFailure('{You/he} won<./s>t be able to do that
//        until you go closer to ' + obj.theName + '. ');
//      exit;
//    }
//    else {
//      return inherited(obj, allowImplicit);
//    }
    // Within a particular set of rooms in the endgame, we completely
    // replace the normal touchObj handling.
    if (gActor.location != nil && gActor.getOutermostRoom.isInFishCorridor 
        && obj && obj.location && obj.getOutermostRoom == gActor.getOutermostRoom 
        && !(gActionIs(GoNear)) 
        && (!gActionIs(StandOn) || !gAction.parentAction || !gAction.parentAction.ofKind(GoNearAction)))
    {
      //callWithSenseContext(nil, nil, new function { "[TouchObjCondition special case] "; } );
      if (gActor.pcIsNear(obj)) {
        return true;
      }
      if (allowImplicit && tryImplicitAction(GoNear, obj)) {
        // We just tried the implicit command. If it failed,
        // abort.
        if (!gActor.pcIsNear(obj))
          exit;
        // Otherwise, tell the caller we executed an implied
        // command.
        return true;
      }
      // I seriously hope this never happens, but we need to
      // deal with the case where, for one reason or another,
      // the necessary implicit action can't take place.
      reportFailure('{You/he} won<./s>t be able to do that
        until you go closer to ' + obj.theName + '. ');
      exit;
    }
    // For the office: Get out of a chair or off a desk
    // before performing certain actions.
    else if (gActor.isIn(office) && obj && gActor.getOutermostNestedRoom.yValue != 0
             && gActor.getOutermostNestedRoom.yValue != obj.getOutermostNestedRoom.yValue) {
      return gActor.checkDirectlyInRoom(office, true);
    }
    else {
      return inherited(obj, allowImplicit);
    }
//    // If we can touch the object, we can proceed with no implicit
//    // actions.
//    if (sourceObj.canTouch(obj))
//        return nil;
//    // we haven't tried removing any obstructors yet
//    pastObs = new Vector(8);
//    // Repeatedly look for and attempt to remove obstructions.
//    // There could be multiple things in the way, so try to remove
//    // each one we find until either we fail to remove an
//    // obstruction or we run out of obstructions.  
//    for (;;) {
//      local stat;
//      local path;
//      local result;
//      local obs;
//      // get the path for reaching out and touching the object
//      path = sourceObj.getTouchPathTo(obj);
//      // if we have a path, look for an obstructor
//      if (path != nil) {
//        // traverse the path to find what blocks our touch
//        stat = sourceObj.traversePath(path, function(ele, op) {
//          // If we can continue the reach via this path element,
//          // simply keep going.  Otherwise, stop the reach here. 
//          result = ele.checkTouchViaPath(sourceObj, obj, op);
//          if (result.isSuccess) {
//            // no objection here - keep going
//            
//            
//            // BEGIN HACK
//            //
//            // If we reach this point, then the library thinks it's 
//            // done removing all obstructions. Therefore, we should
//            // do whatever we need to do here, and then, regardless 
//            // of the outcome, exit this method one way or another.
//            if (gActor.pcIsNear(obj)) {
//              return true;
//            }
//            if (allowImplicit && tryImplicitAction(GoNear, obj)) {
//              // We just tried the implicit command. If it failed,
//              // abort.
//              if (!gActor.pcIsNear(obj))
//                exit;
//              // Otherwise, tell the caller we executed an implied
//              // command.
//              return true;
//            }
//            // I seriously hope this never happens, but we need to
//            // deal with the case where, for one reason or another,
//            // the necessary implicit action can't take place.
//            reportFailure('{You/he} won<./s>t be able to do that
//              until you go closer to ' + obj.theName + '. ');
//            exit;
//            // THE FOLLOWING LINE HAS BEEN COMMENTED OUT:
//            //return true;
//            // END HACK
//            
//            
//            
//            
//          }
//          else {
//            // stop here, noting the obstruction
//            obs = ele;
//            return nil;
//          }
//        });
//        // if we now have a clear path, we're done - simply return
//        // true to indicate that we ran one or more implicit
//        // commands 
//        if (stat)
//          return true;
//      }
//      else {
//        // we have no path, so the object must be in an
//        // unconnected location; we don't know the obstructor in
//        // this case 
//        obs = nil;
//      }
//      // 'result' is a CheckStatus object explaining why we can't
//      // reach past 'obs', which is the first object that
//      // obstructs our reach.
//      // 
//      // If the obstructor is not visible or we couldn't find one,
//      // we can't do anything to try to remove it; simply report
//      // that we can't reach the target object and give up.  
//      if (obs == nil || !gActor.canSee(obs)) {
//        reportFailure(&cannotReachObjectMsg, obj);
//        exit;
//      }
//      // Ask the obstructor to get out of the way if possible.
//      // 
//      // If we've already tried to remove this same obstructor on
//      // a past iteration, don't try again, as there's no reason
//      // to think an implicit command will work any better this
//      // time.
//      if (pastObs.indexOf(obs) != nil
//          || !allowImplicit
//          || !obs.tryImplicitRemoveObstructor(touch, obj))
//      {
//        // We can't remove the obstruction - either we've tried
//        // an implicit command on this same obstructor and
//        // failed, or we can't try an implicit command at all.
//        // In any case, use the explanation of the problem from
//        // the CheckStatus result object.  
//        reportFailure(result.msgProp, result.msgParams...);
//        exit;
//      }
//      // if the implied command failed, simply give up now -
//      // there's no need to go on, since the implied command will
//      // have already explained why it failed 
//      if (gTranscript.isFailure)
//        exit;
//      // We've tried an implied command to remove this obstructor,
//      // but that isn't guaranteed to make the target touchable,
//      // as there could be further obstrutions, or the implied
//      // command could have failed to actually remove the
//      // obstruction.  Keep iterating.  To avoid looping forever
//      // in the event the implicit command we just tried isn't
//      // good enough to remove this obstruction, make a note of
//      // the obstruction we just tried to remove; if we find it
//      // again on a subsequent iteration, we'll know that we've
//      // tried before to remove it and failed, and thus we'll know
//      // to give up without making the same doomed attempt again. 
//      pastObs.append(obs);
//    }
  }
  // The following attempt failed.
  //checkPreCondition(obj, allowImplicit) {
  //  local actionAttempted = nil;
  //  if (!gActor.pcIsNear(obj) && allowImplicit) {
  //    if (tryImplicitAction(GoNear, obj)) {
  //      if (!gActor.pcIsNear(obj))
  //        exit;
  //      actionAttempted = true;    
  //    }
  //  }
  //  return inherited(obj, allowImplicit) || actionAttempted;
  //}
  // I don't think we need to modify verifyPreCondition here.
  // Stuff outside of the actor's getOutermostRoom is not deemed
  // touchable by either the standard library or by me.
  //verifyPreCondition(obj) {
  //  if(obj.nearLoc != nil && obj.autoApproach
  //      && gActor.getOutermostRoom.connectionGroup != nil
  //      && gActor.getOutermostRoom.connectionGroup
  //         == obj.getOutermostRoom.connectionGroup)
  //    return;
  //  inherited(obj);
  //}
;

modify Thing
  getOutermostNestedRoom {
    if (!location)
      return self;
    if (location.ofKind(Room))
      return self;
    return location.getOutermostNestedRoom;
  }
;

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: actorReadyToGoNear
// -------------------------------------------------------------------

actorReadyToGoNear: PreCondition
  // Remember that in a precondition one of three things should happen:
  // (1) if the desired condition is already true, *return nil*
  // (2) if you successfully execute implied commands to make the condition
  //     true, *return true*
  // (3) if you try to execute necessary implied commands and they don't 
  //     work, do a reportFailure() and exit.
  verifyPreCondition(obj) {
    if (!obj)
      return;
    //if (gActor.getOutermostRoom != museum)
    //  return;
    if (!gActor || !gActor.getOutermostRoom || 
        !gActor.getOutermostRoom.isInFishCorridor)
      return;
    
    //local goAroundTarget = nil;
    //local platformDest = nil;
    //local loopCt = 0;
    //local tried = nil;
    //local recentlyTried = nil;
    
    local profsNearMuseum = [];
    local profsNearObj = [];
    local northernmostProf = nil;
    local profsHorizontallyNearAndFarEnoughNorth = [];
    local nearMuseumThreshold = 475; //150;
    
    if (neton.realLocation && neton.realLocation.isInFishCorridor && neton.absoluteYValue <= nearMuseumThreshold)
      profsNearMuseum = profsNearMuseum + neton;
    if (ovan.realLocation && ovan.realLocation.isInFishCorridor && ovan.absoluteYValue <= nearMuseumThreshold)
      profsNearMuseum = profsNearMuseum + ovan;
    if (profsNearMuseum.length) {
      for (local a = 1; a <= profsNearMuseum.length; a++) {
        if (!northernmostProf || profsNearMuseum[a].absoluteYValue < northernmostProf.absoluteYValue)
          northernmostProf = profsNearMuseum[a];
        if (profsNearMuseum[a].npcIsNear(obj))
          profsNearObj = profsNearObj + profsNearMuseum[a];
        if (absVal(profsNearMuseum[a].xValue - obj.xValueForGoingNear) <= 2 &&
            !obj.extendsOverAllYValues &&
            (profsNearMuseum[a].npcIsNear(obj) || 
            profsNearMuseum[a].absoluteYValue <= obj.absoluteYValue + 25))
          profsHorizontallyNearAndFarEnoughNorth =
            profsHorizontallyNearAndFarEnoughNorth + profsNearMuseum[a];
      }
    }
//    // If there are any professors near the object, then it should be
//    // clear to the player that it's dangerous to go near the object.
//    if (profsNearObj.length) {
//      illogical('Doing that would force you to walk within arm<./s>s reach of '
//        + profsNearObj[1].theName 
//        + (profsNearObj.length >= 2 ? ' and ' + profsNearObj[2].theName : '')
//        + ', and that hardly seems wise. ');
//    }
//    // If the object is well north of any hostile NPCs, then it both
//    // *is* safe to touch and also *appears* safe to touch.
//    else if (obj.extendsOverAllYValues || !northernmostProf || 
//             obj.absoluteYValue < northernmostProf.absoluteYValue - 25) {
//    }
//    // If the object is separated from the PC by a solid wall of squares
//    // that are within reach of hostile NPCs, then it not only *is*
//    // dangerous to touch, but it also *appears* dangerous to touch.
//    // Rule it out during verify().
//    // 
//    // Note that this will not prevent the player from trying to go around
//    // NPCs sometimes, which might seem safe, but is in fact deadly.
//    else if (profsHorizontallyNearAndFarEnoughNorth.length && 
//             profsNearMuseum.length >= 2 && 
//             absVal(profsNearMuseum[1].absoluteYValue 
//               - profsNearMuseum[2].absoluteYValue) <= 75)
//    {
//      illogical('Doing that would force you to walk within arm<./s>s reach of '
//        + profsNearMuseum[1].theName 
//        + (profsNearMuseum.length >= 2 ? ' and ' + profsNearMuseum[2].theName : '')
//        + ', and that hardly seems wise. ');
//    }
  }
  checkPreCondition(obj, allowImplicit) {
    local goAroundTarget = nil;
    local profsNearMuseum = [];
    local profsNearObj = [];
    local profsHorizontallyNearAndFarEnoughNorth = [];
    local northernmostProf = nil;
    local platformDest = nil;
    local loopCt = 0;
    local tried = nil;
    local recentlyTried = nil;
    local nearMuseumThreshold = 475; //150;
    
    //glob.actorReadyLoopCt = 0;
    glob.actorReadyPrecondHasBeenRunThisTurn = true;
    
    // First determine what the desired outcome is. Either we want to 
    // go on top of the platform nearest the object (or get off of 
    // all platforms, as the case may be) (goAroundTarget == nil), 
    // or we want to get to the outermost room and then try to go 
    // around the NPC (goAroundTarget == [that NPC]).
    // 
    if (!obj)
      return nil;
    //if (gActor.getOutermostRoom != museum)
    //  return;
    if (!gActor || !gActor.getOutermostRoom || 
        !gActor.getOutermostRoom.isInFishCorridor)
      return nil;
    /*
    Find out:
    The absoluteYValue of the northernmost professor.
    The list of aliens who are within arm's reach of the museum.
    Whether at least one horizontally-near professor is at least as far north as (dest.yValue - 1)
    */
    if (neton.realLocation != nil && neton.realLocation.isInFishCorridor
        && neton.absoluteYValue <= nearMuseumThreshold)
      profsNearMuseum = profsNearMuseum + neton;
    if (ovan.realLocation != nil && ovan.realLocation.isInFishCorridor
        && ovan.absoluteYValue <= nearMuseumThreshold)
      profsNearMuseum = profsNearMuseum + ovan;
    if (profsNearMuseum.length) {
      for (local a = 1; a <= profsNearMuseum.length; a++) {
        if (!northernmostProf || profsNearMuseum[a].absoluteYValue < northernmostProf.absoluteYValue)
          northernmostProf = profsNearMuseum[a];
        if (profsNearMuseum[a].npcIsNear(obj))
          profsNearObj = profsNearObj + profsNearMuseum[a];
        if (absVal(profsNearMuseum[a].xValue - obj.xValueForGoingNear) <= 2 &&
            !obj.extendsOverAllYValues &&
            (profsNearMuseum[a].npcIsNear(obj) || 
            profsNearMuseum[a].absoluteYValue <= obj.absoluteYValue + 25))
          profsHorizontallyNearAndFarEnoughNorth =
            profsHorizontallyNearAndFarEnoughNorth + profsNearMuseum[a];
      }
    }
    // If there are any professors near the object, then it should be
    // clear to the player that it's dangerous to go near the object.
    if (profsNearObj.length) {
      //"Doing that would force you to walk within arm<./s>s reach of ";
      //simpleLister(profsNearObj, &theName);
      //", and that hardly seems wise. ";
      
      //pleaseSay('<.p><font color=red>&lt;Profsnearobj problem&gt;</font> ');
      //exit;
    }
    // If the object is touchable without a problem -- i.e. if it's
    // well north of any hostile NPCs -- then great, that's easy.
    else if (obj.extendsOverAllYValues || !northernmostProf || 
             obj.absoluteYValue < northernmostProf.absoluteYValue - 25) {
      goAroundTarget = nil;
    }
    // If the object is separated from the PC by a solid wall of squares
    // that are within reach of hostile NPCs, then it should be clear 
    // to the player that going near the object is dangerous.
    else if (profsHorizontallyNearAndFarEnoughNorth.length && 
             profsNearMuseum.length >= 2 && 
             absVal(profsNearMuseum[1].absoluteYValue 
               - profsNearMuseum[2].absoluteYValue) <= 75)
    {
      //"Doing that would force you to walk within arm<./s>s reach of ";
      //simpleLister(profsNearMuseum, &theName);
      //", and that hardly seems wise. ";
      
      //pleaseSay('<.p><font color=red>Horizontal problem</font> ');
      //exit;
    }
    // If there are any professors who are horizontally near to the obj
    // and are also farther north than the obj, and if none of the above
    // cases apply, then it probably *appears* that the PC can get to 
    // the obj if only he goes around the professor. It is not *actually* 
    // that way, but it may *appear* that way. In this case, allow the 
    // PC to march to his destruction with the "go around" strategy.
    else if (profsHorizontallyNearAndFarEnoughNorth.length) {
      goAroundTarget = true;
    }
    // In all other cases, it will probably appear that the PC can get
    // to the obj without going around it. Therefore, let him try.
    // It will kill him, but let him try.
    else {
      goAroundTarget = nil;
    }
    // If we have NOT specifically formulated the ill-fated intention of 
    // trying to go around the alien, then all we need to do is go to 
    // the right platform, or to the outermost room. So do it.
    if (!goAroundTarget) {
      if (obj.xValueForGoingNear < -1)
        platformDest = westPlatform;
      else if (obj.xValueForGoingNear > 1)
        platformDest = eastPlatform;
      else
        platformDest = museum;
    }
    else {
      platformDest = museum;
    }
    
    // ---------------
    // Okay, enough messing around. Time to get to work.
    if (allowImplicit) {
      loopCt = 0;
      glob.actorReadyLoopCt = 0;
      while (me.location != platformDest && loopCt <= 6) {
        //callWithSenseContext(nil, nil, new function { "&lt;actorReadyToGoNear loop iteration\&gt; "; } );
        glob.actorReadyLoopCt++;
        loopCt++;
        if (me.location != me.getOutermostRoom)
          recentlyTried = tryImplicitAction(GetOffOf, me.location);
        else
          recentlyTried = tryImplicitAction(StandOn, platformDest);
        if (recentlyTried)
          tried = true;
      }
    }
    // I seriously hope these stupid-ass messages never get printed.
    if (me.getOutermostRoom == museum && (!allowImplicit || !tried) && me.location != platformDest) {
      "To do that, you<./s>d have to ";
      if (platformDest.ofKind(Platform))
        "be standing on the <<platformDest.name>>. ";
      else
        "be standing in the middle of the room, clear of both platforms. ";
      exit;
      //return;
    }
    else if (me.getOutermostRoom == museum && me.location != platformDest) {
      //callWithSenseContext(nil, nil, new function { "&lt;unusual eventuality&gt; "; } );
      exit;
      //return;
    }
    // In this case, we either didn't have to do any implicit commands,
    // or else we did them and they succeeded. This is certainly the 
    // most likely scenario.
    // 
    // If goAroundTarget is not nil, then send the PC to his destruction.
    if (goAroundTarget) {
      tryImplicitAction(GoAround, northernmostProf);
      exit;
    }
    // 
    if (!obj.extendsOverAllYValues && northernmostProf &&
        northernmostProf.absoluteYValue <= obj.absoluteYValue + 25) {
      //local attemptedMelee = nil;
      if (gAction.parentAction.baseActionClass is in
          (AttackAction, AttackWithAction, CutAction, CutWithAction, StrikeAction)) {
        northernmostProf.standardWeapon.attackPcAfterPcStumblesNear(true);
        //attemptedMelee = true;
      }
      else {
        northernmostProf.standardWeapon.attackPcAfterPcStumblesNear(nil);
      }
      "<p>";
      northernmostProf.standardWeapon.rangeAttackSomehowSucceeds;
      northernmostProf.killPcAmusingly;
      //if (!attemptedMelee)
      //  reportFailure('');
      endGame(ftDeath);
      exit;
    }
    return true;
//    // if gActor is already not wearing a costume, we're already done 
//    if (gActor.curCostume == nil) 
//      return nil; 
//    // try to implicitly remove the costume 
//    if (allowImplicit && tryImplicitAction(Doff, gActor.curCostume)) { 
//      // We just tried the implicit command. If it didn't work, 
//      // abort.
//      if (gActor.curCostume != nil) 
//        exit; 
//      // tell the caller we executed an implied command 
//      return true; 
//    } 
//    // can't remove the costume implicitly; report the failure 
//    conditionFailed(obj); 
//    exit;
  }
;

modify glob
  actorReadyLoopCt = 0
;

function absVal(num) {
  if (num < 0)
    return 0 - num;
  else
    return num;
}

//modify me
//  canTouch(obj) {
//    if (location != nil && getOutermostRoom.isInFishCorridor) {
//      return pcIsNear(obj);
//    }
//    return inherited(obj);
//  }
//;
//modify me
//  travelWithin(dest) {
//    inherited(dest);
//    if (isIn(office))
//      me.yBaseValue = dest.yValue;
//  }
//;

modify Thing
  // The "go near destination" of any given thing is either the thing
  // itself -- or else, if the thing is inside of anything that wants 
  // to act as the goNearDest for its contents, then choose the 
  // outermost such container.
  goNearDest {
    local a = self;
    local dest = self;
    while (a.realLocation && !a.realLocation.ofKind(Room)) {
      a = a.realLocation;
      if (a.isGoNearDestForContents)
        dest = a;
    }
    return dest;
  }
  xValueForGoingNear = goNearDest.proxyXValueForGoingNear
  yValueForGoingNear = goNearDest.proxyYValueForGoingNear
  proxyXValueForGoingNear = xValue
  proxyYValueForGoingNear = yValue
  isGoNearDestForContents = nil
  //objIsNearToThis(obj) {
  //}
  moveActorNearThis(actor) {
    local dest = goNearDest;
    if (!dest.getOutermostRoom.isInFishCorridor) {
      return;
    }
    if (dest.getOutermostRoom != museum && dest.getOutermostRoom != hallway6) {
      actor.yBaseValue = self.yValue;
      //callWithSenseContext(nil, nil, new function { "[Thing.moveActorNearThis] "; } );
      return;
    }
    if (dest.getOutermostRoom == hallway6) {
      if (((actor.yValue >= 2 && dest.yValue <= 1) ||
           (actor.yValue <= 0 && dest.yValue >= 1))
          && slowingField.isOn) {
        //nestedAction(Enter, slowingField);
        //"";
      }
      else {
        actor.yBaseValue = dest.yValue;
      }
      //callWithSenseContext(nil, nil, new function { "[Thing.moveActorNearThis] "; } );
      return;
    }
    if (dest.getOutermostRoom == museum) {
      actor.xBaseValue = dest.xValueForGoingNear;
      actor.yBaseValue = dest.yValueForGoingNear;
      // I really hope I succeeded at making it so that the PC 
      // is in the proper nested room, or out of all nested rooms 
      // if need be, before this point. But just in case:
      //callWithSenseContext(nil, nil, new function { "[Thing.moveActorNearThis] "; } );
      actor.doXYConsequences;
      return;
    }
  }
;

modify Actor
  pcIsNear(obj) {
    if (!obj)
      return nil;
    if (obj == self)
      return true;
    if (obj.isIn(self))
      return true;
    if (!getOutermostRoom)
      return nil;
    if (getOutermostRoom != obj.getOutermostRoom)
      return nil;
    if (obj.goNearDest.propDefined(&objIsNearToThis)) {
      return obj.goNearDest.objIsNearToThis(self);
    }
    if (!getOutermostRoom.isInFishCorridor)
      return true;
    // In the non-museum fish corridor rooms, the xValue doesn't
    // matter; only the yValue does.
    if (getOutermostRoom != museum)
      return (obj.yValue == self.yValue);
    // All other cases are in the museum, and apply to things that
    // don't have a custom handling.
    return (obj.yValue == self.yValue && obj.xValue == self.xValue);
  }
  // This is intended for use with professors who are near the museum.
  // It may not work perfectly otherwise.
  npcIsNear(obj) {
    if (obj == self)
      return true;
    if (obj.isIn(self))
      return true;
    if (!self.getOutermostRoom || !self.getOutermostRoom.isInFishCorridor)
      return (obj.getOutermostRoom == self.getOutermostRoom);
    if (!self.getOutermostRoom == museum &&
        !(self.getOutermostRoom == skyway && self.yValue == 2)) {
      return (absVal(self.absoluteYValue - obj.absoluteYValue) <= 25);
    }
    // otherwise, self is near museum
    if (obj.getOutermostRoom != museum && obj.getOutermostRoom != skyway)
      return nil;
    if (obj.extendsOverAllYValues == true)
      return (absVal(self.absoluteYValue - obj.absoluteYValue) <= 25);
    return
      (absVal(self.absoluteYValue - obj.absoluteYValue) <= 25 &&
       absVal(self.xValue - obj.xValue) <= 2);
  }
  // Assume that the actor's xValue and yValue properties are what
  // they should be. Based on this, follow out the logical consequences
  // as to what platform/pedestal the actor should be situated upon.
  // (This only matters in the museum; there are no such consequences
  // anywhere else.)
  doXYConsequences {
    if (getOutermostRoom != museum)
      return;
    if (xBaseValue == -2)
      moveInto(westPlatform);
    else if (xBaseValue == 2)
      moveInto(eastPlatform);
    else if (xBaseValue is in (-3, 3)) {
      for (local cur = firstObj(Pedestal); cur != nil; cur = nextObj(cur,Pedestal)) {
        if (cur.xValue == xValue && cur.yValue == yValue)
          moveInto(cur);
      }
    }
    else {
      moveInto(museum);
    }
    //callWithSenseContext(nil, nil, new function { "[Actor.doXYConsequences] "; } );
  }
;

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: actorNotStretchingGunCable
// -------------------------------------------------------------------

actorNotStretchingGunCable: PreCondition 
  checkPreCondition(obj, allowImplicit) { 
    local acn;
    local actionRefsPGun = nil;
    local actionInvolvesExiting = nil;
    
    //local k = inputManager.getKey(nil, nil);
    //if (k.toLower == 'q') { k=0;k=k/k; }
    
    // In most cases, this precondition will not apply. If
    // it is not applicable, we're finished, and we want to
    // return nil.
    if (!gActor || !obj || !getPGun)
      return nil;
    // First of all, if the actor is not carrying a gun with a cable,
    // then there's no problem. Return nil.
    if (!getPGun.isIn(gActor))
      return nil;
    // If the actor is already near obj, there's usually no
    // problem either, regardless of any gun cables.
    // The major exception is if obj is a platform and the PC
    // is getting off of it. Otherwise, however, if obj is near,
    // then there's no problem.
    if (gActor.pcIsNear(obj) && !(obj.ofKind(AlienPlatform)))
      return nil;
    acn = gAction;
    do {
      if ((acn.ofKind(GetOutOfAction) || acn.ofKind(GetOffOfAction)) &&
          acn.dobjCur_ && acn.dobjCur_.ofKind(AlienPlatform))
        actionInvolvesExiting = true;
      if (acn.dobjCur_ == getPGun)
        actionRefsPGun = true;
      if (dataType(acn.dobjCur_) == TypeList && acn.dobjCur_.indexOf(getPGun))
        actionRefsPGun = true;
      if (acn.iobjCur_ == getPGun)
        actionRefsPGun = true;
      if (dataType(acn.iobjCur_) == TypeList && acn.iobjCur_.indexOf(getPGun))
        actionRefsPGun = true;
      acn = acn.parentAction;
    } while (acn != nil);
    // As a final case, if the obj is the very platform that the actor 
    // is standing on, and if the verb has nothing to do with exiting,
    // there's no conflict either. 
    if (obj.ofKind(AlienPlatform) && !actionInvolvesExiting)
      return nil;
    // In all remaining cases, the actor is carrying a gun with a cable
    // while trying to do something that requires traveling beyond
    // the cable's reach (either by getting off the platform, or by doing
    // something that requires touching an object that's not near).
    // Therefore, we have a conflict.
    // 
    // Should we try to resolve the conflict by trying to implicitly
    // put the cabled gun back on its pedestal? Usually, yes.
    // We make an exception, though, if gDobj or gIobj is the cabled gun 
    // in question, because we want to avoid situations like this:
    //   >PUT PARTICLE GUN ON OLIVE PEDESTAL
    //   (first putting the particle gun on the silver pedestal, then
    //   going over to the olive pedestal)
    //   You must be holding the particle gun to do that.
    if (allowImplicit && !actionRefsPGun 
        && tryImplicitAction(PutOn, getPGun, getPGun.asscPed)) { 
      // We just tried the implicit command. If it didn't work, 
      // abort. 
      if (getPGun.isIn(gActor)) 
        exit; 
      // tell the caller we executed an implied command 
      return true; 
    } 
    // can't remove the hat implicitly; report the failure 
    conditionFailed(obj); 
    exit; 
  } 
  // The condition failed; report the failure and give up. 
  conditionFailed(obj) { 
    //local k =0; k=k/k;
    // can't open it implicitly - report failure and give up 
    if (obj && getPGun)
      reportFailure('{You/he} {can\'t} go over to ' + obj.theName 
        + ' while {you\'re} carrying ' + getPGun.theName 
        + '; a cable attaches the gun to the power cell on ' 
        + getPGun.asscPed.theName + '. '); 
    else if (getPGun)
      reportFailure('{You/he} {can\'t} do that while 
        {you\'re} carrying ' + getPGun.theName 
        + '; a cable attaches the gun to the power cell on ' 
        + getPGun.asscPed.theName + '. ');
    else
      // Hopefully this vague message will never get printed.
      reportFailure('{You/he} {can\'t} do that while 
        {you\'re} carrying a gun that<./s>s attached
        to something nearby. ');
    // make it the pronoun 
    gActor.setPronounObj(obj); 
  }
  getPGun {
    if (paricleGun.isIn(museum))
      return paricleGun;
    else
      return particleGun;
  }
;

// Modify all travel connectors to try to force the actor
// to put down cabled guns, if applicable.
modify TravelConnector
  actorTravelPreCond(actor) {
    return [actorNotStretchingGunCable, 
            new ObjectPreCondition(self, actorTravelReady)];
  }
;

//modify museum
//  roomTravelPreCond = [actorNotStretchingGunCable]
//;

modify AlienPlatform
  // After thinking a bit, I realized I didn't know how to use 
  // actorTravelingWithin() to impose actorNotStretchingGunCable
  // as a precondition on all instances of moving from a platform
  // into the museum.
  // Therefore, I will have to impose the precondition on the 
  // verbs GetOffOf and GetOutOf instead, and hope it works.
  dobjFor(GetOutOf) {
    preCond {
      return [actorNotStretchingGunCable] + nilToList(inherited);
    }
  }
  dobjFor(GetOffOf) {
    preCond { return preCondDobjGetOutOf; }
  }
  //actorTravelingWithin(origin, dest) {
  //}
;

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: Implicit actions
// -------------------------------------------------------------------

DefineTAction(GoNear);

VerbRule(GoNear)
  //( 'approach' | ('walk' | 'stroll' | 'amble') ('near' | ('over' | 'across') 'to')) singleDobj
  'go' 'near' singleDobj
  : GoNearAction
  verbPhrase = 'go/going (over to what)'
;

//modify glob
//  iHaveBeenOnAquaPed = nil
//;

modify Thing
  dobjFor(GoNear) {
    verify {
      //if (me.isIn(aquaPed))
      //  glob.iHaveBeenOnAquaPed = true;
      local dest = goNearDest;
      if (!dest)
        illogical('{You/he} see{s} no way of getting close to 
          {that dobj/him}. ');
      else if (dest.getOutermostRoom != gActor.getOutermostRoom)
        illogicalNow('{That\'s dobj} too far away. ');
      else if (gActor.pcIsNear(dest) && !glob.actorReadyPrecondHasBeenRunThisTurn 
        && !gAction.isImplicit)
      {
          illogicalNow('{You/he} can<./s>t get much closer to
            {the dobj/him} than {you/he} already {is}. ');
//          if (gDobj) { local k=0; k=k/k; }
//        else
//          illogicalNow('This implicit action is forbidden. ');
        //illogicalNow('<font color=red>{You/he} can<./s>t get much closer to
        //  {the dobj/him} than {you/he} already {is}.
        //  And, incidentally, the loop in actorReadyToGoNear was
        //  executed ' + glob.actorReadyLoopCt + ' time(s).</font> ');
        //local k=0;k=k/k;
      }
    }
    preCond = [objVisible, actorNotStretchingGunCable, 
               actorReadyToGoNear, actorStanding]
    check {
//      "GoNear.check. ";
//      if (me.location == eastPlatform) {
//        "You fail. ";
//        exit;
//      }
    }
    action {
      defaultReport('Okay, {you/he} walk{s} over to {the dobj/him}. ');
      //"Okay, {you/he} walk{s} over to {the dobj/him}. ";
      moveActorNearThis(gActor);
      //if (!gAction.isImplicit)
      //  "Okay, {you/he} walk{s} over to {the dobj/him}. ";
      //mainReport('Okay, {you/he} walk{s} over to {the dobj/him}. 
      //  <font color=red>And, incidentally, the loop in actorReadyToGoNear was
      //  executed ' + glob.actorReadyLoopCt + ' time(s).</font> ');
      //mainReport('Okay, {you/he} walk{s} over to ' + goNearDest.theName + '. ');
    }
  }
;

modify glob
  actorReadyPrecondHasBeenRunThisTurn = nil
;

DefineTAction(GoAround);

VerbRule(GoAround)
  ' ' //'go' 'around' singleDobj
  : GoAroundAction
  verbPhrase = 'go/going (around what)'
;

modify Thing
  dobjFor(GoAround) {
    verify {
      illogical('{You/he} can<./s>t go around {that dobj/him}. ');
    }
  }
;

modify Alien
  // Since GoAround will NEVER be used except implicitly, and then
  // only in very specific cases (i.e., both the PC and the NPC have
  // to be in the fish corridor, etc.), we don't need to allow for 
  // every possible scenario. Just kill the PC whenever we execute 
  // this command.
  dobjFor(GoAround) {
    verify { }
    check {
      self.standardWeapon.attackPcAfterPcStumblesNear(nil);
      "<p>";
      self.standardWeapon.rangeAttackSomehowSucceeds;
      self.killPcAmusingly;
      // reportFailure ensures that we will get "(first trying to go around..."
      // rather than "(first going around..."
      reportFailure('');
      endGame(ftDeath);
    }
  }
;

// -------------------------------------------------------------------
// INTRA-ROOM STUFF: INTRA-ROOM PRECONDITIONS: Drop/throw consequences
// -------------------------------------------------------------------

modify Thing
  // We modify receiveDrop to make sure that the dropped/thrown
  // thing will have the proper xValue/yValue after it is moved.
  receiveDrop(obj, desc) {
    //local objloc = obj.location;
    //gMessageParams(obj, self, objloc);
    //mainReport('Prior to being thrown/dropped, the location 
    //  of {the obj/him} location was {the objloc/he}. Afterward, 
    //  the location was {the self/he}. ');
    //local prevLoc = obj.location;
    local catching = nil;
    local retrieving = nil;
    local passThrough = nil;
    obj.moveInto(self);
    if (getOutermostRoom.isInFishCorridor) {
      if (desc == dropTypeDrop) {
        if (gActor.location == obj.location) {
          obj.xBaseValue = gActor.xValue;
          obj.yBaseValue = gActor.yValue;
        }
        // If you drop something while standing on a pedestal,
        // it falls to the platform below. Make sure the xValue/yValue
        // of the dropped object reflects this.
        else {
          obj.xBaseValue = gActor.location.proxyXValueForGoingNear;
          obj.yBaseValue = gActor.location.proxyYValueForGoingNear;
        }
      }
      else if (desc.ofKind(DropTypeThrow) && !desc.ofKind(DropTypeShortThrow)) {
        adjustXYValuesOfFallenContents(obj, desc.target_);
      }
    }
    if (desc.ofKind(DropTypeThrow) && !desc.ofKind(DropTypeShortThrow)) {
      adjustXYValuesOfFallenContents(obj, desc.target_);
    }
    // Deal with the custom description. This will vary depending on
    // a lot of things.
    if (desc.ofKind(DropTypeThrow) && !desc.ofKind(DropTypeShortThrow)) {
      // If you throw a gun at one of the aliens, they'll catch it.
      // The sole exception would be if you throw the disrupter when
      // it's set to explode; then they are too fearful to catch it.
      if (desc.target_ && desc.target_.ofKind(Alien)) {
        if (obj && obj.ofKind(Gun) && (obj != disrupter || !obj.isSetToExplode)) {
          catching = true;
        }
        // None of the aliens especially need to pick up a dagger 
        // or icepick. The guards and assistant already have range
        // weapons, and as for Neton and Ovan -- well, let's just
        // assume they are not very adept at dagger-throwing.
        // Besides, this is an incredibly unlikely scenario anyway.
        //if (obj == dagger || obj == netonIcepick || obj == ovanIcepick) {
        //  retrieving = true;
        //}
      }
      // Deal with dagger and icepicks later
      //if (desc.target_ == dagger || desc.target_ == neton.weapon 
      //    || desc.target_ == ovan.weapon)
      
      
      
      // Deal with catching and passThrough values here.
      // I'll save that for later, though.
      // Make sure you satisfactorily deal with the scenario where 
      // you throw a photonic disrupter at Vicki and Diane when it's set
      // to overload.
      if (desc.target_ == slowingField)
        passThrough == true;
      //if (desc.target_ && desc.target_.ofKind(Prisoner) && obj &&
      //    (obj.ofKind(Bomb) || obj == dagger || obj == neton.weapon || obj == ovan.weapon)) {
      //  vicki.isAntagonized = true;
      //  diane.isAntagonized = true;
      //}
      giveThrowReport(obj, self, desc, catching, retrieving, passThrough);
      if (catching || retrieving) {
        obj.moveInto(desc.target_);
        // Add any caught/retrieved weapons to the Alien.weapons list.
        if (obj.ofKind(Weapon)) {
          desc.target_.weapons = [obj] + desc.target_.weapons;
        }
      }
    }
    else {
      desc.standardReport(obj, self);
    }
  }
  // Most things don't need to adjust X
  adjustXYValuesOfFallenContents(obj, target) {
    obj.xBaseValue = target.goNearDest.proxyXValueForGoingNear;
    obj.yBaseValue = target.goNearDest.proxyYValueForGoingNear;
  }
  // separatorFromThing should return either nil, or else the slowing
  // field or some kind of window. Windows and slowing fields are the
  // only kinds of "separators" in my game.
  separatorFromPov(pov) { // pov here will usually be gActor.
    if (self.getOutermostRoom == office && 
        pov.getOutermostRoom is in (dreamRoom, hallway5, bathroom))
      return dreamWindow;
    if (pov.getOutermostRoom == office && 
        self.getOutermostRoom is in (dreamRoom, hallway5, bathroom))
      return officeWindow;
    if ((self.getOutermostRoom.isInFishCorridor || self.getOutermostRoom == confRoom) &&
        (pov.getOutermostRoom.isInFishCorridor || pov.getOutermostRoom == confRoom) &&
        slowingField.isOn)
    {
      // If there are bogus absoluteYValues, return nil.
      if (self.absoluteYValue < -500 ||
          pov.absoluteYValue < -500)
        return nil;
      // If either of the objects is *in the middle of* the slowing field,
      // then the slowing field doesn't separate the two objects.
      if (self.absoluteYValue == 475 ||
          pov.absoluteYValue == 475)
        return nil;
      // If the objects are on the same side of the slowing field,
      // return nil.
      if ((self.absoluteYValue - 475 < 0) == (pov.absoluteYValue - 475 < 0))
        return nil;
      // Otherwise, the slowing field separates self from pov.
      return slowingField;
    }
    return nil;
  }
  separatedBySlowingField(x, y) {
    if (!slowingField.isOn)
      return nil;
    // If either of the objects are absent from the line of rooms
    // between the museum and the conference room, return nil.
    if (x.getOutermostRoom.absoluteXValue != 400 ||
        y.getOutermostRoom.absoluteXValue != 400)
      return nil;
    // If there are bogus absoluteYValues, return nil.
    if (x.absoluteYValue < -500 ||
        y.absoluteYValue < -500)
      return nil;
    // If either of the objects is *in the middle of* the slowing field,
    // then the slowing field doesn't exactly separate the two objects.
    if (x.absoluteYValue == 475 ||
        y.absoluteYValue == 475)
      return nil;
    // If the objects are on the same side of the slowing field,
    // return nil.
    if ((x.absoluteYValue - 475 < 0) == (y.absoluteYValue - 475 < 0))
      return nil;
    // Otherwise, return true.
    return true;
  }
  giveThrowReport(projectile, dropdest, dropObj, catching, retrieving, passThrough) {
    local dist;
    local evasion = nil;
    local target = dropObj.target_;
    //local nomdropdest = dropdest.getNominalDropDestination;
    gMessageParams(projectile, target);
    if (gActor.getOutermostRoom == target.getOutermostRoom ||
        gActor.isNearForExplosion(target) ||
        target.absoluteYValue < -500)
      dist = 0;
    else if (absVal(gActor.getOutermostRoom.absoluteYValue
              - target.getOutermostRoom.absoluteYValue) <= 125
             && absVal(gActor.getOutermostRoom.absoluteXValue
              - target.getOutermostRoom.absoluteXValue) <= 125)
      dist = 1;
    else
      dist = 2;
    if (projectile == dagger || projectile == neton.standardWeapon || projectile == ovan.standardWeapon)
      evasion = true;
    // Deal with the prefix: "You throw the thing."
    if (dist == 0) {
      "{You/he} throw{s} {the projectile/him}";
      if (catching || evasion) ". ";
      else ", which ";
    }
    else {
      "{You/he} haul{s} back and throw{s} {the projectile/him}
        as hard as you can";
      if (catching || evasion) ". ";
      else ". {It projectile/he} ";
    }
    // Deal with the decription of what happens when the thrown
    // thing touches down.
    if (passThrough) {
      "pass{es projectile} through {the target/him} 
        without any obvious effect and land{s projectile} 
        on the other side. ";
      return;
    }
    else if (catching) {
      "{The target/he}, seeing {the projectile/him} coming, 
        hold{s target} out {its target/her} hands";
      if (dist == 0) {
        if (separatedBySlowingField(gActor, target)) {
          ", wait{s target} for {it projectile/him} to 
            pass through the slowing field,";
        }
        " and catch{es target} {it projectile/him} out of the air. ";
      }
      else {
        ". <<dist >= 2 ? 'Miraculously' : 'Surprisingly'>>, ";
        if (separatedBySlowingField(gActor, target)) {
          "just as {the projectile/he} 
            pass{es projectile} through the slowing field, ";
        }
        "{the target/he} manage{s} to catch {it projectile/him} 
          out of the air. ";
      }
      return;
    }
    else if (evasion) {
      "{The target/he}, seeing {the projectile/him} coming, 
        step{s target} aside";
      if (separatedBySlowingField(gActor, target))
        ", while {the projectile/he} pass{es projectile}
          through the slowing field and 
          just barely misses {it target/him}. ";
      else
        ", and {the projectile/him} 
          just barely misses {it target/him}. ";
      if (retrieving) {
        "<p>No sooner has {the target/he} done this than 
          {it target/he} bend{s} 
          down<<target.isSlowed ? ' rather slowly' : ''>>
          and pick{s} up {the projectile/him}. ";
      }
      return;
    }
    // With the above exceptions (passing through, being caught,
    // and being evaded), the remaining cases are fairly similar.
    else {
      if (separatedBySlowingField(gActor, target))
        "pass{es projectile} through the slowing field and ";
      if (target == dropdest || target.isRoomSymbol) {
        "hit{s projectile} without any obvious effect. ";
      }
      else if (dist >= 2 || target.ofKind(Prisoner) || projectile.ofKind(Bomb)) {
        "miss{es projectile} {the target/him}, but still 
          manage{s projectile} to land close to {it target/him}. ";
      }
      else {
        if (target.ofKind(SeeminglyFragile))
          "bounce{s projectile} off the surprisingly strong <<target.name>> ";
        else
          "hit{s projectile} {the target/him} ";
        if (target.ofKind(Actor))
          "without causing any serious injury, ";
        else
          "without any obvious effect, ";
        "then fall{s projectile} 
          <<dropdest.getNominalDropDestination.putInName>>. ";
      }
      // Deal with any after-effects of the projectile landing where it does
      if (retrieving) {
        "<p>Immediately {the target/he} bend{s} 
          down<<target.isSlowed ? ' rather slowly' : ''>>
          and pick{s} up {the projectile/him}. ";
      }
      else if (target.ofKind(Alien)) {
        if (projectile.ofKind(Bomb) && projectile.isSetToExplode) {
          "<p>{The target/he} stares at {the projectile/him} in dismay. ";
        }
        else {
          "<p>{The target/he} glances at {the projectile/him}
            for a moment, but decides not to pick 
            {it projectile/him} up. ";
          if (projectile.ofKind(Bomb) && !projectile.isSetToExplode)
            "Perhaps he<./s>s not prepared 
              to risk blowing up his own university campus
              just to kill you. ";
        }
      }
      return;
    }
  }
;





// -------------------------------------------------------------------
// INTER-ROOM STUFF: endgameOccluder
// -------------------------------------------------------------------

endgameOccluder: Occluder, Component
  occludeObj(obj, sense, pov) {
    // If the obj specifically tells us to occlude it, then do so.
    if (obj.occludeMe)
      return true;
    // If the obj in question is not a ShadowCaster, don't occlude it.
    if (!obj.ofKind(ShadowCaster))
      return nil;
    // If the ShadowCaster can be seen, don't occlude it.
    if (gActor.getOutermostRoom.canGlimpse(obj.realLocation.getOutermostRoom))
      return nil;
    // Otherwise, obj is a ShadowCaster that can't presently be seen
    // (most likely because it's behind a closed door). Occlude it.
    return true;
  }
;

modify Thing
  occludeMe = nil
;

// -------------------------------------------------------------------
// INTER-ROOM STUFF: SometimesDistant class
// -------------------------------------------------------------------

class SometimesDistant: object
  isDistant {
    //if (!realLocation)
    //  return true;
    if (gPlayerChar.getOutermostRoom == getOutermostRoom)
      return nil;
    return true;
  }
  hideFromAll(action) {
    if (isDistant)
      return true;
    else
      return inherited(action);
  }
  dobjFor(All) {
    verify {
      //if (isDistant && !distantActionsDobj.indexOf(gAction.baseActionClass))
      //  illogical(&tooDistantMsg, self);
      if (isDistant && !distantActionsDobj.indexOf(gAction.baseActionClass)) {
        if (ofKind(Actor) && gAction.baseActionClass is in 
            (AttackAction, AttackWithAction, CutAction, CutWithAction))
          illogical('{The dobj/he} {is} standing ' + relLocStr(nil) 
            + ', too far away for that kind of melee attack. ');
        else
          illogical(&tooDistantMsg, self);
      }
    }
  }
  iobjFor(All) {
    verify {
      if (isDistant && !distantActionsIobj.indexOf(gAction.baseActionClass))
        illogical(&tooDistantMsg, self);
    }
  }
  distantActionsDobj = [
     ExamineAction
    ,ListenToAction
    ,ShowToAction
#ifdef __DEBUG
    ,ShoveAction
    ,YBudgeAction
    ,XBudgeAction
    ,SnarfAction
#endif // __DEBUG
    ,ShootWithAction
    ,ShootAction
    ,AskForAction
    ,AskAboutAction
    ,TellAboutAction
    ,TalkToAction
    //,AttackAction
    //,AttackWithAction
    //,HitAction
    //,HitWithAction
  ]
  distantActionsIobj = [
     ShowToAction
    ,ThrowAtAction
    ,ThrowToAction
  ]
  //dobjFor(Default) {
  //  verify() {
  //    if (isDistant) {
  //      illogical(&tooDistantMsg, self);
  //      //illogical('NO!!!!! ');
  //      //local k=0;k=k/k;
  //    }
  //    else
  //      inherited();
  //  }
  //}
  //iobjFor(Default) {
  //  verify() {
  //    if (isDistant) {
  //      illogical(&tooDistantMsg, self);
  //      //illogical('NO!!!!! ');
  //    }
  //    else
  //      inherited();
  //  }
  //}
  //dobjFor(Examine) {
  //  verify { inherited; }
  //}
  //dobjFor(ListenTo) {
  //  verify { inherited; }
  //}
  //dobjFor(ShowTo) {
  //  verify { inherited; }
  //}
  //dobjFor(Shove) {
  //  verify { inherited; }
  //}
  //dobjFor(YBudge) {
  //  verify { inherited; }
  //}
  //dobjFor(XBudge) {
  //  verify { inherited; }
  //}
  //iobjFor(ThrowAt) {
  //  verify { inherited; }
  //}
  //iobjFor(ThrowTo) {
  //  verify { inherited; }
  //}
  //dobjFor(ShootWith) {
  //  verify { inherited; }
  //}
  //dobjFor(Shoot) {
  //  verify { inherited; }
  //}
  // Description when examined
  basicExamine()
  {
    local info;
    local t;
    info = getVisualSenseInfo();
    t = info.trans;
    if (getOutermostRoom() != getPOVDefault(gActor).getOutermostRoom()
        && propDefined(&remoteDesc)) {
      remoteDesc(getPOVDefault(gActor));
    }
    else if (t == obscured && propDefined(&obscuredDesc)) {
      obscuredDesc(info.obstructor);
    }
    else if (t == distant && propDefined(&distantDesc)) {
      distantDesc;
    }
    else if (canDetailsBeSensed(sight, info, getPOVDefault(gActor))) {
      if (useInitDesc())
        initDesc;
      else {
        
        
        
        // START HACK
        if (isDistant)
          farDesc;
        else if (propDefined(&nearDesc))
          nearDesc;
        else
          desc;
        // END HACK
        
        
        
      }
      described = true;
      examineStatus();
    }
    else if (t == obscured) {
      defaultObscuredDesc(info.obstructor);
    }
    else if (t == distant) {
      defaultDistantDesc;
    }
  }
  //desc {
  //  if (isDistant)
  //    farDesc;
  //  else if (propDefined(&nearDesc))
  //    nearDesc;
  //  else
  //    desc;
  //    //defaultDescReport(&thingDescMsg, self);
  //}
  farDesc {
    "\^<<theName>> <<verbToBe>> 
      visible <<relativeLocationStr>>. ";
  }
  relativeLocationStr {
    if ((getOutermostRoom == office && (gPlayerChar.getOutermostRoom == bathroom || 
                                        gPlayerChar.getOutermostRoom == dreamRoom || 
                                        gPlayerChar.getOutermostRoom == hallway5))
     || (gPlayerChar.getOutermostRoom == office && (getOutermostRoom == bathroom || 
                                                    getOutermostRoom == dreamRoom || 
                                                    getOutermostRoom == hallway5)))
      return 'through the window to the ' + shadowDirectionStr;
    else if (isRoomSymbol)
      return 'to the ' + shadowDirectionStr;
    else
      return getOutermostRoom.getOutermostRoom.actorInName 
        + ' to the ' + shadowDirectionStr;
  }
  //throughDescStr {
  //}
  shadowDirectionStr {
    // This is kludgey, but it works, if you make one assumption.
    // We assume that when one room can glimpse another, then it is
    // always directly north, due south, due east, or due west of
    // the other (never at a diagonal). If that weren't the case, 
    // there wouldn't be a clear line of sight between the rooms.
    local shadowRow = getOutermostRoom.getOutermostRoom.isInRow;
    local actorRow  = gPlayerChar.getOutermostRoom.isInRow;
    if (shadowRow < actorRow)
      return 'north';
    if (shadowRow > actorRow)
      return 'south';
    local shadowColumn = getOutermostRoom.isInColumn;
    local actorColumn  = gPlayerChar.getOutermostRoom.isInColumn;
    if (shadowColumn < actorColumn)
      return 'west';
    if (shadowColumn > actorColumn)
      return 'east';
    return 'south';
  }
;

modify Thing
  isDistant = nil
;
modify Distant
  isDistant = true
;

// -------------------------------------------------------------------
// INTER-ROOM STUFF: ShadowCaster class
// -------------------------------------------------------------------

class ShadowCaster: SometimesDistant, MultiLoc
  // This is the property to override to make the ShadowCaster
  // actually exist anywhere.
  // You may also override locationList if you want the ShadowCaster
  // to "cast a shadow" over a different set of locations than
  // would otherwise be expected.
  realLocation = nil
  // Although ShadowCasters are MultiLocs, we do not want to inherit
  // MultiLocs' complicated handling of getDropDestination. ShadowCasters
  // have a "real location," so we simply defer to that real location's
  // drop destination whenever possible.
  getDropDestination(obj, path) {
    if (ofKind(Room) || !realLocation)
      return inherited(obj, path);
    else
      return realLocation.getDropDestination(obj, path);
  }
  // For some reason, a ShadowCaster's getHitFallDestination does not
  // always turn out to be the same as its getDropDestination. Change this.
  getHitFallDestination(obj, path) {
    return getDropDestination(obj, path);
  }
  getOutermostRoom {
    if (!realLocation)
      return nil;
    else
      return realLocation.getOutermostRoom;
  }
  // This is a MultiLoc library method which I am modifying.
  initializeLocation() {
    inherited();
    //locationList.forEach({loc: loc.addToContents(self)});
  }
  // If the normal procedure of inferring the locationList from the
  // realLocation doesn't work, and if simply overriding locationList 
  // doesn't work (perhaps because the thing will repeatedly appear
  // and disappear), and -- importantly -- if the ShadowCaster in 
  // question will never be in more than one room, then you can use
  // scLocationList to make sure that the locationList is initialized
  // correctly. Be sure to include realLocation in scLocationList.
  scLocationList = nil
  // This is a BaseMultiLoc library method which I am overriding.
  buildLocationList() {
    local lst;
    // if scLocationList exists, use it.
    if (scLocationList)
      return scLocationList;
    // If we can't figure out anything that makes sense for the 
    // locationList, return [].
    if (!realLocation || !realLocation.getOutermostRoom.glimpseableRooms
        || !realLocation.getOutermostRoom.glimpseableRooms.length == 0)
      return [];
    // Otherwise, build the list.
    lst = [realLocation];
    // If we've gotten this far, I think we can assume that glimpseableRooms 
    // is a list with more than one element.
    for (local a = 1; a <= realLocation.getOutermostRoom.glimpseableRooms.length; a++) {
      lst = lst + realLocation.getOutermostRoom.glimpseableRooms[a][1];
    }
    if (ofKind(BasicLocation))
      lst = lst.subset({x: x != self});
    return lst;
  }
  //location = realLocation
  // scMoveInto moves a ShadowCaster to a new realLocation, 
  // updating the locationList as appropriate.
  scMoveInto(newRoom) {
    local lst = [];
    // set realLocation
    realLocation = newRoom;
    // It seems a little dicey to set the location of this MultiLoc 
    // to anything, but sometimes the MultiLoc will be an actor,
    // and actors can't seem to work unless they have a location 
    // property specified. This is dicey, but I think it will work.
    // 
    // On second thought, I'll wager that anything could benefit from this.
    if (ofKind(Thing)) {
      location = realLocation;
    }
    // Momentarily remove this thing from the game.
    baseMoveInto(nil);
    // If newRoom is nil, we're done.
    if (!newRoom) {
      //agendaList = new Vector(10);
      return;
    }
    // Make "lst" equal to a list of all the rooms visible from the
    // NPC's new realLocation (realLocation itself should be part of the list),
    // with no elements of the list repeated.
    lst = buildLocationList();
    // Here's a strategy that might work: simply make it so that
    // locationList equals "lst", then initializeLocation
    locationList = lst;
    initializeLocation();
    //if (self == dragon && newRoom != hacRoomH10) { local k=0;k=k/k; }
  }
//  // Description when examined
//  desc {
//    if (isDistant)
//      farDesc;
//    else if (propDefined(&nearDesc))
//      nearDesc;
//    else
//      defaultDescReport(&thingDescMsg, self);
//  }
//  farDesc {
//    "\^<<theName>> <<verbToBe>> 
//      visible <<relativeLocationStr>>. ";
//  }
//  relativeLocationStr {
//    if ((realLocation == office && (gPlayerChar.getOutermostRoom == bathroom || 
//                                    gPlayerChar.getOutermostRoom == dreamRoom || 
//                                    gPlayerChar.getOutermostRoom == hallway5))
//     || (gPlayerChar.getOutermostRoom == office && (realLocation == bathroom || 
//                                                    realLocation == dreamRoom || 
//                                                    realLocation == hallway5)))
//      return 'through the window to the ' + shadowDirectionStr;
//    else if (isRoomSymbol)
//      return 'to the ' + shadowDirectionStr;
//    else
//      return realLocation.getOutermostRoom.actorInName 
//        + ' to the ' + shadowDirectionStr;
//  }
//  //throughDescStr {
//  //}
//  shadowDirectionStr {
//    // This is kludgey, but it works, if you make one assumption.
//    // We assume that when one room can glimpse another, then it is
//    // always directly north, due south, due east, or due west of
//    // the other (never at a diagonal). If that weren't the case, 
//    // there wouldn't be a clear line of sight between the rooms.
//    local shadowRow = realLocation.getOutermostRoom.isInRow;
//    local actorRow  = gPlayerChar.getOutermostRoom.isInRow;
//    if (shadowRow < actorRow)
//      return 'north';
//    if (shadowRow > actorRow)
//      return 'south';
//    local shadowColumn = realLocation.getOutermostRoom.isInColumn;
//    local actorColumn  = gPlayerChar.getOutermostRoom.isInColumn;
//    if (shadowColumn < actorColumn)
//      return 'west';
//    if (shadowColumn > actorColumn)
//      return 'east';
//    return 'south';
//  }
  // Feel free to override this as needed.
  //nearDesc {
  //}
//  // BEGIN PSEUDO-DISTANT STUFF: Stuff to make the ShadowCaster
//  // behave as if it belonged to class Distant when appropriate
//  // (but not otherwise).
//  isDistant {
//    if (!realLocation)
//      return true;
//    if (gPlayerChar.getOutermostRoom == realLocation.getOutermostRoom)
//      return nil;
//    return true;
//  }
//  hideFromAll(action) {
//    if (isDistant)
//      return true;
//    else
//      return inherited(action);
//  }
//  dobjFor(All) {
//    verify {
//      if (isDistant && !distantActionsDobj.indexOf(gAction.baseActionClass))
//        illogical(&tooDistantMsg, self);
//    }
//  }
//  iobjFor(All) {
//    verify {
//      if (isDistant && !distantActionsIobj.indexOf(gAction.baseActionClass))
//        illogical(&tooDistantMsg, self);
//    }
//  }
//  distantActionsDobj = [
//     ExamineAction
//    ,ListenToAction
//    ,ShowToAction
//    ,ShoveAction
//    ,YBudgeAction
//    ,XBudgeAction
//    ,ShootWithAction
//    ,ShootAction
//    ,AskForAction
//    ,AskAboutAction
//    ,TellAboutAction
//    ,TalkToAction
//    //,AttackAction
//    //,AttackWithAction
//    //,HitAction
//    //,HitWithAction
//  ]
//  distantActionsIobj = [
//     ShowToAction
//    ,ThrowAtAction
//    ,ThrowToAction
//  ]
//  //dobjFor(Default) {
//  //  verify() {
//  //    if (isDistant) {
//  //      illogical(&tooDistantMsg, self);
//  //      //illogical('NO!!!!! ');
//  //      //local k=0;k=k/k;
//  //    }
//  //    else
//  //      inherited();
//  //  }
//  //}
//  //iobjFor(Default) {
//  //  verify() {
//  //    if (isDistant) {
//  //      illogical(&tooDistantMsg, self);
//  //      //illogical('NO!!!!! ');
//  //    }
//  //    else
//  //      inherited();
//  //  }
//  //}
//  //dobjFor(Examine) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(ListenTo) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(ShowTo) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(Shove) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(YBudge) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(XBudge) {
//  //  verify { inherited; }
//  //}
//  //iobjFor(ThrowAt) {
//  //  verify { inherited; }
//  //}
//  //iobjFor(ThrowTo) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(ShootWith) {
//  //  verify { inherited; }
//  //}
//  //dobjFor(Shoot) {
//  //  verify { inherited; }
//  //}
  // END PSEUDO-DISTANT STUFF
  // BEGIN THE SECTION THAT ALLOWS FOR EASIER VARIATION OF VOCABULARY
  // OF SHADOWCASTERS THAT ARE NEAR VS. FAR
  nearStateTokens = nil
  farStateTokens = nil
  getState = (isDistant ? farState : nearState)
  nearState = nil
  farState = nil
  allStates = []
  initializeThing() {
    inherited();
    nearState = new NearState;
    farState = new FarState;
    if (nearStateTokens != nil)
      nearState.stateTokens = nearStateTokens;
    if (farStateTokens != nil)
      farState.stateTokens = farStateTokens;
    allStates = [nearState, farState];
    //if (nearStateTokens != nil || farStateTokens != nil) {
    //  nearState = new NearState;
    //  farState = new FarState;
    //  if (nearStateTokens != nil)
    //    nearState.stateTokens = nearStateTokens;
    //  if (farStateTokens != nil)
    //    farState.stateTokens = farStateTokens;
    //  allStates = [nearState, farState];
    //}
  }
  //matchNameCommon(origTokens, adjustedTokens) {
  //  local st = (isOpen ? openState : closedState);
  //  if (st.matchName(self, origTokens, adjustedTokens,
  //                   [openState, closedState]) == nil)
  //    return nil;
  //  return inherited(origTokens, adjustedTokens);
  //}
  nearStrongStateTokens = []
  farStrongStateTokens = []
  matchName(origTokens, adjustedTokens) {
  weakTest:
    if (weakTokens != nil) {
      local sc = languageGlobals.dictComparator;
      
      for (local i = 1, local len = origTokens.length() ;
           i <= len ; ++i)
      {
        local tok = getTokVal(origTokens[i]);
        if (getTokType(origTokens[i]) == &miscWord)
          continue;
      
        // In the library, this condition is true if any only if 
        // the "origToken" in question is not in the weakTokens list.
        // I must make it so that it's true if and only if
        // (a) the "origToken" in question is not in the weakTokens list,
        // *OR* (b) the "origToken" is in nearStrongStateTokens or
        // farStrongStateTokens, as applicable.
        if (weakTokens.indexWhich({x: sc.matchValues(tok, x) != 0}) == nil
           // BEGIN HACK
           || self.(getState.strongTokensProp).indexWhich({x: sc.matchValues(tok, x) != 0}) != nil
           // END HACK
        ) {
          break weakTest;
        }
      }
      // If we get here, it means we got through the loop without
      // finding any non-weak tokens.  This means the entire
      // phrase is weak, which means that we don't match it.
      // Return nil to indicate that this is not a match.  
      return nil;
    }
    // invoke the common handling
    return matchNameCommon(origTokens, adjustedTokens);
  }
  // END VOCABULARY SECTION
//  construct {
//    inherited();
//    glob.asdfasdfModComplete = true;
//    local k=0;k=k/k;
//    if (nearStateTokens != nil || farStateTokens != nil) {
//      nearState = new ThingState;
//      farState = new ThingState;
//      if (nearStateTokens != nil)
//        nearState.stateTokens = nearStateTokens;
//      if (farStateTokens != nil)
//        farState.stateTokens = farStateTokens;
//    }
//  }
;

//modify glob
//  asdfasdfModComplete = nil
//;

class FormerShadowCaster: object
;
class FormerRoomShadowCaster: FormerShadowCaster
;

class NearState: ThingState
  strongTokensProp = &nearStrongStateTokens
;
class FarState: ThingState
  strongTokensProp = &farStrongStateTokens
;

//flashlight: Flashlight
//  'flashlight' 'flashlight'
//  @me
//;

/*
class ShadowCaster: object
  asscShadow = nil
  shadowLocationStr {
    return asscShadow.realLocation.getOutermostRoom.actorInName 
      + ' to the ' + shadowDirectionStr;
  }
  startShadow {
    //local obj;
    if (asscShadow == nil) {
      asscShadow = new Shadow(self);
      asscShadow.asscThing = self;
      //self.asscShadow = obj;
    }
    if (location != nil) {
      for (local a = 1; a <= shadowList.length; a++) {
        asscShadow.baseMoveIntoAdd(shadowList[a]);
      }
    }
  }
  endShadow {
    asscShadow.baseMoveInto(nil);
  }
  // Hack the ShadowCaster so that it can't be moved into play, 
  // or moved out of play, without making appropriate changes to
  // its associated shadow.
  baseMoveInto(newContainer) {
    inherited(newContainer);
    
    if (newContainer != nil)
      startShadow;
    else
      endShadow;
  }
  shadowDirectionStr {
    // This is kludgey, but it works, if you make one assumption.
    // We assume that when one room can glimpse another, then it is
    // always directly north, due south, due east, or due west of
    // the other (never at a diagonal). If that weren't the case, 
    // there wouldn't be a clear line of sight between the rooms.
    local shadowRow = asscShadow.realLocation.getOutermostRoom.isInRow;
    local actorRow  = gActor.getOutermostRoom.isInRow;
    if (shadowRow < actorRow)
      return 'north';
    if (shadowRow > actorRow)
      return 'south';
    local shadowColumn = asscShadow.realLocation.getOutermostRoom.isInColumn;
    local actorColumn  = gActor.getOutermostRoom.isInColumn;
    if (shadowColumn < actorColumn)
      return 'west';
    if (shadowColumn > actorColumn)
      return 'east';
    return 'south';
  }
  shadowVocabWords = ''
  shadowDesc = "\^<<asscShadow.theName>> <<asscShadow.verbToBe>> 
    visible <<shadowLocationStr>>. "
  shadowLocation = location
  initShadow(obj) { }
  occludeShadow { return nil; }
  shadowIsListed = true
  throughWhatStr {
    local rm1 = gActor.getOutermostRoom;
    local rm2 = getOutermostRoom;
    local howManyDoorways = howManyDoorwaysBetween(rm1, rm2);
    local throughWhat = '';
    if (rm1 == office && rm2 == dreamRoom ||
        rm2 == office && rm1 == dreamRoom)
      throughWhat = 'through the window ';
    else if (howManyDoorways > 1)
      throughWhat = 'through the doorways ';
    else if (howManyDoorways == 1)
      throughWhat = 'through the doorway ';
    else // presumably, howManyDoorways == 0
      throughWhat = '';
    return throughWhat;
  }
;

class ActorShadowCaster: ShadowCaster
  shadowList = [
    // hallway1,
    // hallway2,
    // hallway3,
     hallway4
    ,hallway5
    ,hallway6
    //,hallway7
    //,hallway8
    ,hallway9
    ,stairs
    ,skyway
    ,museum
    //,office
    ,dreamRoom
    //,cell
    //,breakRoom
    //,bathroom
    ,confRoom
  ]
;

class RoomShadowCaster: ShadowCaster
  // When a room itself is the ShadowCaster, there's never any point in
  // saying "You can see the museum in the museum to the north." So change 
  // this.
  shadowLocationStr {
    return throughWhatStr + 'to the ' + shadowDirectionStr;
  }
  shadowDesc {
    //local k = 0; k=k/k;
    local lst;
    lst = gActor.scopeList();
    lst = lst.subset(
      { x: x.isShadow
        && !x.asscThing.ofKind(Room)
        && x.realLocation == self.getOutermostRoom 
        && x.shadowIsListed 
        && me.canSee(x) }
    );
    local thingLst = lst.subset({x:!x.isActorShadow});
    local actorLst = lst.subset({x: x.isActorShadow});
    "\^<<asscShadow.theName>> <<asscShadow.verbToBe>> 
      visible <<shadowLocationStr>>. ";
    if (thingLst.length > 0) {
      "\^<<asscShadow.realLocation.getOutermostRoom.objInPrep>> 
        <<asscShadow.realLocation.getOutermostRoom.itObj>>
        you see ";
      simpleLister(thingLst, &aName);
      ". ";
    }
    if (actorLst.length > 0) {
      if (thingLst.length > 0)
        "Also ";
      else
        "\^";
      "<<asscShadow.realLocation.getOutermostRoom.actorInName>> ";
      if (actorLst.length > 1)
        "are ";
      else
        "is ";
      simpleLister(actorLst, &theName);
      ". ";
    }
    if (lst.length == 0)
      "You can<./s>t make out any details from here. ";
    else
      "You can<./s>t make out much more than that from here. ";
  }
  //shadowDesc = "\^<<asscShadow.theName>> <<asscShadow.verbToBe>> 
  //  visible <<shadowLocationStr>>, although you can<./s>t 
  //  make out much from here. "
  shadowLocation {
    if (ofKind(Room))
      return self;
    else
      return location;
  }
;

//class BasicShadow: MultiLoc, Distant
//;

modify Thing
  realLocation = location
;

class Shadow: MultiLoc, Distant
  // We need this. ShadowCaster.startShadow may not be enough, since
  // it may not guarantee that the Shadow.vocabWords get initialized
  // in time.
  construct(obj) {
    asscThing = obj;
    asscThing.initShadow(self);
    if (obj.shadowVocabWords != '')
      vocabWords = obj.shadowVocabWords;
    else
      vocabWords = obj.vocabWords;
    inherited;
  }
  isShadow = true
  asscThing = Thing // override
  realLocation = (asscThing.shadowLocation)
  //locationList = (asscThing.shadowList)
  shadowIsListed = (asscThing.shadowIsListed)
  
  // This line is overridden in construct; I could delete it.
  vocabWords = (asscThing.vocabWords)
  name = (asscThing.name)
  isProperName = (asscThing.isProperName)
  isQualifiedName = (asscThing.isQualifiedName)
  isPlural = (asscThing.isPlural)
  isMassNoun = (asscThing.isMassNoun)
  isHim = (asscThing.isHim)
  isHer = (asscThing.isHer)
  occludeMe {
    return asscThing.occludeShadow;
  }
  // Normally this should be overridden.
  desc {
    if (asscThing.propDefined(&shadowDesc))
      return asscThing.shadowDesc;
    else
      return asscThing.desc;
  }
  isListed = nil
  isListedInContents = nil
  //isListedInInventory = nil
;

class ActorShadow: Shadow
  isActorShadow = true
;

InitObject
  execute {
    //local obj;
    for(local cur = firstObj(ShadowCaster); cur != nil; 
        cur = nextObj(cur, ShadowCaster)) {
      cur.startShadow;
      //if (cur.asscShadow == nil) {
      //  
      //  
      //  obj = new Shadow(cur);
      //  //if (!cur.isActor)
      //  //  obj = new Shadow(cur);
      //  //else
      //  //  obj = new ActorShadow(cur);
      //  
      //  
      //  obj.asscThing = cur;
      //  cur.asscShadow = obj;
      //}
    } 
  }
;

modify Thing
  occludeMe { return nil; }
;

// This endgameOccluder is put into "me" as a component during the
// end of the game.
endgameOccluder: Occluder, Component
  occludeObj(obj, sense, pov) {
    // If the obj specifically tells us to occlude it, then do so.
    if (obj.occludeMe)
      return true;
    // If that's not the case, and if the obj in question is not 
    // a shadow, then don't occlude it.
    if (!obj.isShadow)
      return nil;
    // If the real location of the shadow in question can be 
    // glimpsed from the PC's vantage point, don't occlude it.
    if (gActor.getOutermostRoom.canGlimpse(obj.realLocation.getOutermostRoom))
      return nil;
    // Otherwise, obj is a shadow whose real location can't be
    // glimpsed by the actor. Occlude it.
    return true;
  }
;

function howManyDoorwaysBetween(rm1, rm2) {
  local elmt;
  elmt = rm1.glimpseableRooms.indexWhich({x:x[1]==rm2});
  if (!elmt) return 0;
  return rm1.glimpseableRooms[elmt][2].length();
}
*/

// -------------------------------------------------------------------
// INTER-ROOM STUFF: Room symbols
// -------------------------------------------------------------------

class RoomSymbol: ShadowCaster, NonPortable
  realLocation = nil // override with the room that this symbol represents
  isRoomSymbol = true
  signified = realLocation
  name = signified.name
  occludeMe {
    if (gActor.getOutermostRoom == signified)
      return true;
    else
      return nil;
  }
  canBeVaporized = nil
  __name = ''
  __isPlural = nil
  beforeBeingShot(weapon) {
    __name = name;
    __isPlural = isPlural;
    name = 'walls of the ' + name;
    isPlural = true;
  }
  afterBeingShot(weapon) {
    name = __name;
    isPlural = __isPlural;
  }
  distantActionsDobj = inherited + [
     ClimbAction
    ,ClimbUpAction
    ,ClimbDownAction
    ,EnterAction
    ,GoThroughAction
  ]
  dobjFor(Enter) {
    verify {
      local dirAction = mustGoWhichDirToComeHere(gActor);
      if (dirAction == WaitAction)
        illogicalAlready('{You\'re} already ' + objInPrep
          + ' ' + theName + '. ');
      else if (!dirAction)
        illogical(&tooDistantMsg, self);
      else
        { }
    }
    action {
      local dirAction = mustGoWhichDirToComeHere(gActor);
      if (dirAction == WaitAction)
        say('{You\'re} already ' + objInPrep
          + ' ' + theName + '. ');
      else if (dirAction)
        _replaceAction(gActor, dirAction);
      else
        inherited;
      
    }
  }
  dobjFor(GoThrough) asDobjFor(Enter)
  mustGoWhichDirToComeHere(actor) {
    local xDiff, yDiff;
    xDiff = gActor.getOutermostRoom.isInColumn
      - self.getOutermostRoom.isInColumn;
    yDiff = gActor.getOutermostRoom.isInRow
      - self.getOutermostRoom.isInRow;
    if (xDiff ==  0 && yDiff == -1) return SouthAction;
    if (xDiff ==  0 && yDiff ==  1) return NorthAction;
    if (xDiff == -1 && yDiff ==  0) return EastAction;
    if (xDiff ==  1 && yDiff ==  0) return WestAction;
    if (xDiff ==  0 && yDiff ==  0) return WaitAction; // a special case
    return nil;
  }
//  transformObj {
//    farWalls.name = 'walls of ' + signified.theName;
//    return farWalls;
//  }
//  transformObj = farWalls
//  askAry  = signified.askAry
//  zapAry  = signified.zapAry
//  zapAry2 = signified.zapAry2
//  zapAryCq  { signified.zapAryCq; }
//  zapAry2Cq { signified.zapAry2Cq; }
//  nilAry    { signified.nilAry; }
//  askT    = signified.askT
//  zapT    = signified.zapT
//  zapT2   = signified.zapT2
//  zapTCq    { signified.zapTCq; }
//  zapT2Cq   { signified.zapT2Cq; }
//  nilT      { signified.nilT; }
//  zapRemoveCq { signified.zapRemoveCq; }
//  askAry  = farWalls.askAry
//  zapAry  = farWalls.zapAry
//  zapAry2 = farWalls.zapAry2
//  zapAryCq  { farWalls.zapAryCq; }
//  zapAry2Cq { farWalls.zapAry2Cq; }
//  nilAry    { farWalls.nilAry; }
//  askT    = farWalls.askT
//  zapT    = farWalls.zapT
//  zapT2   = farWalls.zapT2
//  zapTCq    { farWalls.zapTCq; }
//  zapT2Cq   { farWalls.zapT2Cq; }
//  nilT      { farWalls.nilT; }
//  zapRemoveCq { farWalls.zapRemoveCq; }
;

modify Thing
  realLocation = location
  isRoomSymbol = nil
;

// RoomShadowCaster is no longer used. RoomSymbol is used instead.

class RoomShadowCaster: ShadowCaster
  realLocation = self
;

dreamRoomSymbol: RoomSymbol 'dream (room)' realLocation = dreamRoom;
officeSymbol: RoomSymbol 'office' realLocation = office;
cellSymbol: RoomSymbol 'cell' realLocation = cell;
breakRoomSymbol: RoomSymbol 'break (room)' realLocation = breakRoom;
bathroomSymbol: RoomSymbol 'bath bathroom/(room)' realLocation = bathroom;
confRoomSymbol: RoomSymbol 'conf conference (room)' realLocation = confRoom;
museumSymbol: RoomSymbol 'museum' realLocation = museum;
skywaySymbol: RoomSymbol 'skyway' realLocation = skyway;
stairsSymbol: RoomSymbol 'stair/stairs' realLocation = stairs
  isPlural = true
  objInPrep = 'on'
  beforeBeingShot(weapon) {
  }
  afterBeingShot(weapon) {
  }
  dobjFor(Climb) asDobjFor(Enter)
  dobjFor(ClimbUp) {
    verify {
      local dirAction = mustGoWhichDirToComeHere(gActor);
      if (dirAction == SouthAction)
        illogicalAlready('{You\'re} already at the top 
          of the stairs. ');
      else
        verifyDobjEnter;
    }
    action {
      actionDobjEnter;
    }
  }
  dobjFor(ClimbDown) {
    verify {
      local dirAction = mustGoWhichDirToComeHere(gActor);
      if (dirAction == NorthAction)
        illogicalAlready('{You\'re} already at the bottom 
          of the stairs. ');
      else
        verifyDobjEnter;
    }
    action {
      actionDobjEnter;
    }
  }
  zapT { return stairsFloor.zapT; }
  zapAry { return stairsFloor.zapAry; }
;
//farWalls: MultiLoc, Fixture
//  //vocabWords = nil
//  name = 'far walls'
//  isPlural = true
//  initialLocationClass = AlienRoom
//  canBeVaporized = nil
//;

hallwaySymbol: RoomSymbol, NonPortable
  vocabWords = 'hallway/hall/corridor'
  name = 'hallway'
  // Probably moot:
  nearDesc = "This is the hallway which you presently inhabit. "
  isRoomSymbol = true
  realLocation = (gActor.getOutermostRoom.nearestHallway)
  //dobjFor(All) {
  //  verify { }
  //  preCond = []
  //  check { }
  //  action {
  //    replaceAction();
  //  }
  //}
  scLocationList = [
     hallway1
    ,hallway2
    ,hallway3
    ,hallway4
    ,hallway5
    ,hallway6
    ,hallway7
    ,hallway8
    ,hallway9
    ,cell
    ,breakRoom
    ,bathroom
    ,confRoom
    ,office
    ,dreamRoom
    ,stairs
    ,skyway
    ,museum
  ]
  occludeMe {
    if (gActor.getOutermostRoom.nearestHallway == gActor.getOutermostRoom)
      return true;
    else
      return nil;
  }
  //nearStateTokens = ['near']
  //farStateTokens = ['far']
;

// -------------------------------------------------------------------
// INTER-ROOM STUFF: Room symbols
// -------------------------------------------------------------------

//class Listed: object
//  isListed = true
//  isListedInContents = true
//  isListedInInventory = true
//;

// Note to self: I don't know what this is here for.

//alienThingState: ThingState
//;

//fooState: ThingState 'fooed'
//  stateTokens = ['fooed']//['fooed', 'foo']
//;
//barState: ThingState 'barred'
//  stateTokens = ['barred']//['barred', 'bar']
//;

//nearState: ThingState
//  stateTokens = ['near']
//;
//farState: ThingState
//  stateTokens = ['farthing']
//;

//#ifdef __DEBUG
//
////fauxBunkBed: ShadowCaster, Fixture
////  name = 'bunk bed'
////  realLocation = hallway6
////  vocabWords = '(bunk) bed'
////  nearStrongStateTokens = []
////  farStrongStateTokens = ['bunk']
////;
//
//anvil: ShadowCaster, Heavy
//  vocabWords = 'near far anvil/farthing'
//  //nearDesc = "Anvil anvil anvil!!! "
//  name = 'anvil'
//  realLocation = hallway6
//  //scLocationList = [hallway6, stairs, confRoom]
//  nearStateTokens = ['near']
//  farStateTokens = ['far', 'farthing']
//;
//
//DefineIAction(Zowie)
//  execAction() {
//    local dest;
//    if (anvil.isIn(hallway6))
//      dest = hallway7;
//    else if (anvil.isIn(hallway7))
//      dest = dreamRoom;
//    else
//      dest = hallway6;
//    "Moving the anvil to <<dest.roomIdentifierStr>>. ";
//    anvil.scMoveInto(dest);
//    //"Soccer ball created in bathroom. ";
//    //local soc = new Thing {
//    //  name = 'soccer ball'
//    //  vocabWords = 'soccer ball'
//    //};
//    //soc.moveInto(bathroom);
//  }
//;
//VerbRule(Zowie)
//  'zowie'
//  : ZowieAction
//  verbPhrase = 'zowie/zowieing'
//;
//
//#endif // __DEBUG





// -------------------------------------------------------------------
// JUNK: Notes to myself
// -------------------------------------------------------------------


// -------------------------------------------------------------------
// 
//           #####  #####     #####  #####     #####  #####    ######
//           #####  #####     #####  ######    #####  #####   ###### 
//           #####  #####     #####  ######    #####  #####  ######  
//           #####  #####     #####  #######   #####  ##### ######   
//           #####  #####     #####  ########  #####  ###########    
//           #####  #####     #####  ########  #####  ##########     
//           #####  #####     #####  ######### #####  ##########     
//           #####  #####     #####  ###############  ###########    
//           #####  #####     #####  ###############  ###########    
//           #####  #####     #####  ###############  ##### ######   
// #####     #####  #####     #####  ##### #########  #####  #####   
// ######   ######  ######   ######  #####  ########  #####  ######  
// ###############  ###############  #####  ########  #####   #####  
//  #############    #############   #####   #######  #####   ###### 
//  #############    #############   #####    ######  #####    ##### 
//   ###########      ###########    #####    ######  #####    ######
//     #######          #######      #####     #####  #####     #####

/*
PRE-2007 NOTES:

Do a MultiLoc hallway object.
Do T-removing stuff for stairs and bathroom.
slowingField.shadowDesc
drain.shadowDesc

Plans for doing the stuff where you implicitly go to a location:
modify TouchObjCondition to enforce proximity and do implicit actions accordingly.
Which implicit actions? GoNear.
GoNear.preCond includes actorOutOfNested (a la ConSpace.t) or actorDirectlyInRoom (a la precond.t)

Problems:
When in a nested room, and when you want to touch/get objects 
  outside of that nested room, make it so it will neither 
  do so from the present location (as is default), nor simply 
  say "That's too far away" (as normally happens when using
  the OutOfReach class). Instead, make it so the player
  leaves/enters nested rooms as necessary to be near the 
  object before picking it up.
Make it so the preceding thing happens not only when there is
  a touchObj precondition, but also when there is a 
I'm confused as all hell now about the distinction between
  xValue and and xBaseValue, and between yValue and yBaseValue.  
  I'm not sure I used them right in all cases. Investigate this.
When you go to the north of the activated slowing field and 
  turn it off, one of the pictures generated thereafter is
  hugely inappropriate. Fix this.
Make it so not all verbs are prohibited across the 
  slowingField. Examine, Read, etc., should work.
Make it so that when anything is dropped, its xBaseValue and
  yBaseValue become identical to that of the dropper.
Make it so that when anything is successfully thrown at 
  something else, its xBaseValue and yBaseValue become
  identical to, or similar to, that of the thing it was thrown
  at.
Make it so that during verification, a nearby object is
  preferred over a distant/remote one.
Ideally, when trying to interact with something in another
  room, instead of saying "That's too far away", say
  "That's further west, down the hallway. You'd have to
  walk over to reach it."
*/

/*
                   museum
                     |
                   skyway
  D                  |
 hw1   hw8--office  hw9
  |     |            |
 hw2   hw7  dream  stairs
  D     |     |      |
 hw3---hw4---hw5----hw6
  |     |     |      |
cell  break  bath   conf
*/

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineIAction(Antagonize)
  execAction() {
    vicki.isAntagonized = true;
    diane.isAntagonized = true;
    mainReport('Okay, Vicki and Diane are now antagonized. ');
  }
;

VerbRule(Antagonize)
  'antagonize'
  : AntagonizeAction
  verbPhrase = 'antagonize/antagonizing'
;

DefineTAction(Munlock);
VerbRule(Munlock)
  ('munlock' | 'mun' | 'munl' | 'munlo' | 'munloc') singleDobj
  : MunlockAction
  verbPhrase = 'magically unlock/unlocking (what)'
;
modify Thing
  dobjFor(Munlock) {
    verify() {
      illogical('{You/he} do{es}n<./s>t know how to magically unlock 
                {that dobj/him}. ');
    }
  }
;
modify cellDoor
  dobjFor(Munlock) {
    verify() { }
    action {
      "Okay, you magically unlock the door. ";
      makeLocked(nil);
    }
  }
;
modify cellDoor2
  dobjFor(Munlock) {
    verify() { }
    action {
      "Okay, you magically unlock the door. ";
      makeLocked(nil);
    }
  }
;

pizza: Thing 'pizza' 'pizza';

//qwerty: object
//  execute {
//    glob.getFormattedNpcList;
////    "<.p>[LOOK]\n
////      <b>Room Name</b>\n
////      Room description.\b
////      \^<<neton.relLocStr>>, you see Neton. ";
////    "<.p>[X NETON]\n
////      You see Neton <<neton.relLocForNpcDesc>>. ";
//    //for(local cur = firstObj(ShadowCaster); cur != nil; cur = nextObj(cur, ShadowCaster)) { 
//    //  "<<cur.name>>\b";
//    //} 
//  }
//;
//qwerty3: object
//  execute {
//    for(local cur = firstObj(AlienRoom); cur != nil; cur = nextObj(cur, AlienRoom)) { 
//      if (cur.ofKind(ShadowCaster))
//        "<<cur.roomIdentifierStr>>\b";
//    } 
//  }
//;
//qwerty2: object
//  execute {
//    "<font face=\"Courier New\" >";
//    for (local a = 1; a <= 18; a++) {
//      local rm;
//      switch (a) {
//        case  1: rm = hallway1 ; break;
//        case  2: rm = hallway2 ; break;
//        case  3: rm = hallway3 ; break;
//        case  4: rm = cell     ; break;
//        case  5: rm = hallway8 ; break;
//        case  6: rm = hallway7 ; break;
//        case  7: rm = hallway4 ; break;
//        case  8: rm = breakRoom; break;
//        case  9: rm = office   ; break;
//        case 10: rm = dreamRoom; break;
//        case 11: rm = hallway5 ; break;
//        case 12: rm = bathroom ; break;
//        case 13: rm = museum   ; break;
//        case 14: rm = skyway   ; break;
//        case 15: rm = hallway9 ; break;
//        case 16: rm = stairs   ; break;
//        case 17: rm = hallway6 ; break;
//        case 18: rm = confRoom ; break;
//      }
//      "<b><<rm.roomIdentifierStr>>:</b>\b";
//      me.moveInto(rm);
//      me.lookAround(true);
//      "<.p>";
//      //"<<rm.roomIdentifierStr>>";
//      //for (local b = 15; b >= 1; b--) {
//      //  if (rm.roomIdentifierStr.length < b)
//      //    "&nbsp;";
//      //  else
//      //    break;
//      //}
//      //": column=<<rm.isInColumn>>; row=<<rm.isInRow>> \n";
//      //if (a == 4 || a == 8 || a == 12)
//      //  "<p>";
//    }
//    "</font>";
//  }
//;
//
//DefineIAction(Zowie)
//  execAction() {
//    qwerty.execute;
//  }
//;
//VerbRule(Zowie)
//  'zowie'
//  : ZowieAction
//  verbPhrase = 'sleep/sleeping'
//;


//theFixture: ShadowCaster, Fixture 'fixture' 'fixture'
//  desc = "It looks just like a fixture. "
//  location = hallway3
//  shadowVocabWords = 'fixture shadow'
//  shadowList = [hallway4, hallway5, hallway6, hallway1, hallway2]
//  shadowDesc = "You can see the fixture <<shadowLocationStr>>. "
//  isListed = true
//  isListedInContents { return isListed; }
//;

// move this into "me" during the endgame



//theHeavyThing: ShadowCaster, Heavy 'heavy thing' 'heavy thing'
//  desc = "It looks just like a heavy thing. "
//  location = hallway3
//  asscShadow = heavyThingShadow
//  shadowList = [hallway4, hallway5, hallway6, hallway1, hallway2]
//  shadowDesc = "You can see the heavy thing <<shadowLocationStr>>. "
//  isListed = true
//  isListedInContents { return isListed; }
//;
//
//heavyThingShadow: Shadow
//  'heavy thing shadow' 'heavy thing'
//  locationList = [hallway4, hallway5, hallway6, hallway1, hallway2]
//  asscThing = theHeavyThing
//;

DefineTAction(Ary);
VerbRule(Ary)
  ('ary' /*| 'ung' | 'ary' 'ung'*/) singleDobj
  : AryAction
  verbPhrase = 'ary/arying (what)'
;
modify Thing
  dobjFor(Ary) {
    verify() { }
    check() { }
    action() {
      transformObj.hitByAry;
    }
  }
;
modify Distant
  dobjFor(Ary) {
    verify() { }
  }
  dobjFor(Tr) {
    verify() { }
  }
;

DefineTAction(Tr);
VerbRule(Tr)
  ('tr' | 'rt') singleDobj
  : TrAction
  verbPhrase = 'TR/TRing (what)'
;
modify Thing
  dobjFor(Tr) {
    verify() { }
    check() { }
    action() {
      transformObj.hitByT;
    }
  }
;

DefineLiteralTAction(Shove, DirectObject)
  objInScope( obj ) { return true; }
  resemblesShoveAction = true
;
//DefineLiteralTAction(YShove, DirectObject);
//DefineLiteralTAction(HShove, DirectObject);
DefineLiteralTAction(YBudge, DirectObject)
  objInScope( obj ) { return true; }
  resemblesShoveAction = true
;
DefineLiteralTAction(XBudge, DirectObject)
  objInScope( obj ) { return true; }
  resemblesShoveAction = true
;

VerbRule(Shove)
  ('shove') 
    singleDobj (singleLiteral | 'to' singleLiteral)
  : ShoveAction
  verbPhrase = 'shove/shoving (what) (to what)'
;
//VerbRule(YShove)
//  ('shove' | 'yshove' | 'shovey' | 'vshove' | 'shovev') 
//    singleDobj (singleLiteral | 'to' singleLiteral)
//  : YShoveAction
//  verbPhrase = 'shove/shoving (what) vertically (to what)'
//;
//VerbRule(XShove)
//  ('xshove' | 'shovex' | 'hshove' | 'shoveh') 
//    singleDobj (singleLiteral | 'to' singleLiteral)
//  : XShoveAction
//  verbPhrase = 'shove/shoving (what) horizontally (to what)'
//;
VerbRule(YBudge)
  ('budge' | 'ybudge' | 'budgey' | 'vbudge' | 'budgev' | 'by' | 'yb' | 'bv' | 'vb'
  |'nudge' | 'ynudge' | 'nudgey' | 'vnudge' | 'nudgev' | 'ny' | 'yn' | 'nv' | 'vn')
    singleDobj (singleLiteral | 'to' singleLiteral)
  : YBudgeAction
  verbPhrase = 'budge/budging (what) vertically (to what)'
;
VerbRule(XBudge)
  ('xbudge' | 'budgex' | 'hbudge' | 'budgeh' | 'bx' | 'xb' | 'bh' | 'hb'
  |'xnudge' | 'nudgex' | 'hnudge' | 'nudgeh' | 'nx' | 'xn' | 'nh' | 'hn')
    singleDobj (singleLiteral | 'to' singleLiteral)
  : XBudgeAction
  verbPhrase = 'budge/budging (what) horizontally (to what)'
;

modify Thing
  dobjFor(Shove) {
    verify() { 
      illogical('You can<./s>t shove {that dobj/him}. ');
    }
  }
  //dobjFor(YShove) {
  //  verify() { 
  //    illogical('You can<./s>t shove {that dobj/him}. ');
  //  }
  //}
  //dobjFor(XShove) {
  //  verify() { 
  //    illogical('You can<./s>t shove {that dobj/him}. ');
  //  }
  //}
  dobjFor(YBudge) {
    verify() {
      illogical('You can<./s>t budge {that dobj/him}. ');
    }
  }
  dobjFor(XBudge) {
    verify() {
      illogical('You can<./s>t budge {that dobj/him}. ');
    }
  }
;
enum nothingness;
function roomFromLiteral(ltrl) {
  ltrl = ltrl.toLower();
  // if 'ltrl' is a match for a non-hallway room, return that room
  switch (ltrl.substr(1,2)) {
    case 'ce': return cell     ;
    case 'br': return breakRoom;
    case 'of': return office   ;
    case 'dr': return dreamRoom;
    case 'ba': return bathroom ;
    case 'mu': return museum   ;
    case 'sk': return skyway   ;
    case 'st': return stairs   ;
    case 'co': return confRoom ;
  }
  // if 'ltrl' begins with 'h', look for any appropriate hallway to return
  if (ltrl.substr(1,1) == 'h' && ltrl.length > 1) {
    for (local a = 1; a <= ltrl.length; a++) {
      switch (ltrl.substr(a,1)) {
        case '1': return hallway1;
        case '2': return hallway2;
        case '3': return hallway3;
        case '4': return hallway4;
        case '5': return hallway5;
        case '6': return hallway6;
        case '7': return hallway7;
        case '8': return hallway8;
        case '9': return hallway9;
      }
    }
  }
  // if 'literal' indicates no room, return the nothingness value
  if (ltrl.substr(1,1) == '0' || ltrl.substr(1,1) == 'n')
    return nothingness;
  // if we've found no match for 'ltrl' yet, there is no match at all
  return nil;
}
// This is awful, but I can't presently find anything in the library
// to convert strings to numbers. This is good enough.
function nudgeValueFromString(str) {
  local val;
  if (!str || str.length < 1) return nil;
  if (str.substr(1,1) == '+' || str.substr(1,1) == '-')
    val = 2;
  else
    val = 1;
  if (str.length < val) return nil;
  switch (str.substr(val,1)) {
    case '1': if (str.substr(1,1)=='-') return -1; else return 1;
    case '2': if (str.substr(1,1)=='-') return -2; else return 2;
    case '3': if (str.substr(1,1)=='-') return -3; else return 3;
    case '4': if (str.substr(1,1)=='-') return -4; else return 4;
    case '5': if (str.substr(1,1)=='-') return -5; else return 5;
    case '6': if (str.substr(1,1)=='-') return -6; else return 6;
    case '7': if (str.substr(1,1)=='-') return -7; else return 7;
    case '8': if (str.substr(1,1)=='-') return -8; else return 8;
    case '9': if (str.substr(1,1)=='-') return -9; else return 9;
    case '0': return 0;
    default:  return nil;
  }
}
modify Actor
  dobjFor(Shove) {
    verify { }
    check { }
    action() {
      local rm = roomFromLiteral(gLiteral);
      // Change xBaseValue and yBaseValue as appropriate for the room.
      switch (rm) {
        // Never change anything if the room is undetermined.
        case nil:
          break;
        case museum:
          //xBaseValue = 0; yBaseValue = 0; // not sure why this is here
          break;
        case skyway:
        case hallway9:
        case stairs:
          if (yBaseValue < -1) yBaseValue = -1;
          if (yBaseValue >  2) yBaseValue =  2;
          if (xBaseValue < -1) xBaseValue = -1;
          if (xBaseValue >  1) xBaseValue =  1;
          break;
        case hallway6:
          if (yBaseValue <  0) yBaseValue =  0;
          if (yBaseValue >  2) yBaseValue =  2;
          if (xBaseValue < -1) xBaseValue = -1;
          if (xBaseValue >  1) xBaseValue =  1;
          break;
        default:
          xBaseValue = 0; yBaseValue = 0;
          break;
      }
      switch (rm) {
        case nothingness:
          "Okay, you shove {the dobj/him}. New location: Nothingness. ";
          moveIntoForTravel(nil);
          break;
        default:
          if (rm == nil || !rm.ofKind(AlienRoom)) {
            "It<./s>s not clear where you want to shove {the dobj/him} to. ";
          }
          else {
            "Okay, you shove {the dobj/him}. New location: <<rm.roomIdentifierStr>>. ";
            moveIntoForTravel(rm);
            if (self == neton)
              netonIcepick.moveInto(neton);
            else if (self == ovan)
              ovanIcepick.moveInto(ovan);
            else if (self == assistant)
              dagger.moveInto(assistant);
          }
      }
      //callWithSenseContext(nil, nil, new function { "[Actor.dobjFor(Shove).action] "; } );
    }
  }
  dobjFor(YBudge) {
    verify { }
    check { }
    action() {
      local val = nudgeValueFromString(gLiteral);
      local mnmX, mxmX, mnmY, mxmY;
      switch (getOutermostRoom) {
        case museum:
          mnmX=-3; mxmX=3; mnmY=-3; mxmY=4; break;
        case skyway:
        case hallway9:
        case stairs:
          mnmX=-1; mxmX=1; mnmY=-1; mxmY=2; break;
        case hallway6:
          mnmX=-1; mxmX=1; mnmY= 0; mxmY=2; break;
        case hallway4:
          mnmX= 0; mxmX=1; mnmY= 0; mxmY=0; break;
        default:
          mnmX= 0; mxmX=0; mnmY= 0; mxmY=0; break;
      }
      // squash compiler warnings
      mnmX=mnmX+0;mxmX=mxmX+0;
      if (val == nil || val > mxmY || val < mnmY) {
        "<.q><<val>><./q> doesn<./s>t work as a vertical budge value
          in the room where {the dobj/he} {is} located. ";
      }
      else {
        yBaseValue = val;
        "You budge {the dobj/him} vertically. ";
      }
      //callWithSenseContext(nil, nil, new function { "[Actor.dobjFor(YBudge).action] "; } );
    }
  }
  dobjFor(XBudge) {
    verify { }
    check { }
    action() {
      local val = nudgeValueFromString(gLiteral);
      local mnmX, mxmX, mnmY, mxmY;
      switch (getOutermostRoom) {
        case museum:
          mnmX=-3; mxmX=3; mnmY=-3; mxmY=4; break;
        case skyway:
        case hallway9:
        case stairs:
          mnmX=-1; mxmX=1; mnmY=-1; mxmY=2; break;
        case hallway6:
          mnmX=-1; mxmX=1; mnmY= 0; mxmY=2; break;
        case hallway4:
          mnmX= 0; mxmX=1; mnmY= 0; mxmY=0; break;
        default:
          mnmX= 0; mxmX=0; mnmY= 0; mxmY=0; break;
      }
      // squash compiler warnings
      mnmY=mnmY+0;mxmY=mxmY+0;
      if (val == nil || val > mxmX || val < mnmX) {
        "<.q><<val>><./q> doesn<./s>t work as a horizontal budge value
          in the room where {the dobj/he} {is} located. ";
      }
      else {
        xBaseValue = val;
        "You budge {the dobj/him} horizontally. ";
      }
      //callWithSenseContext(nil, nil, new function { "[Actor.dobjFor(XBudge).action] "; } );
    }
  }
;

DefineIAction(WordNameInventory)
  // source of truth for this list is "nbm transformations 2016.xlsx"
  // hopefully this is all of the non-vr Thing objects in the game.
  execAction() {
    local objectList = [
       hallway1
      ,hallway2
      ,hallway3
      ,hallway4
      ,hallway7
      ,hallway5
      ,arrowSign
      ,hallway6
      ,slowingSign
      ,apparatus
      ,apparaus
      ,slowingBuon
      ,slowingButton
      ,slowingField
      ,noDrain
      ,drain
      ,nadir
      ,stairs
      ,stairsFloor
      ,hallway9
      ,skyway
      ,skywayWindows
      ,skywayOutside
      ,dreamRoom
      ,officeWindow
      ,dreamWindow
      ,dreamCouch
      ,dreamArm
      ,office
      ,officeShelves
      ,officeDevices
      ,stacksOfFiles
      ,sacksOfFiles
      ,casksOfFiles
      ,officeBooks
      ,netonDesk
      ,ovanDesk
      ,netonDrawer
      ,ovanDrawer
      ,netonComputer
      ,ovanComputer
      ,netonCompuer
      ,ovanCompuer
      ,ovanNotebooks
      ,ovanNoebooks
      ,academicJournals
      ,ovanPapers
      ,keycard
      ,stapler
      ,plaster
      ,sapler
      ,plaser
      ,pearls
      ,paperClips
      ,crispApple
      ,dryCake
      ,netonChair
      ,breakRoom
      ,geFridge
      ,geFreezer
      ,cupboard
      ,breakTable
      ,breakChair
      ,upperFridgeShelf
      ,lowerFridgeShelf
      ,upperFridgeDrawer
      ,lowerFridgeDrawer
      ,certificate
      ,bathroom
      ,bathToilet
      ,mirror
      ,museum
      ,museumSign
      ,westPlatform
      ,eastPlatform
      ,officeDoor
      ,officeDoor2
      ,dreamDoor
      ,dreamDoor2
      ,hallwaySlo
      ,cellSlo
      ,hallwaySlot
      ,cellSlot
      ,cellDoor2
      ,breakDoor
      ,breakDoor2
      ,bathDoor
      ,bathDoor2
      ,confDoor2
      ,hallDoors
      ,hallDoors2
      ,frontDoors
      ,frontDoors2
      ,hallDoorway
      ,hallDoorway2
      ,minnow
      ,trout
      ,tuna
      ,gar
      ,northernPike
      ,tetra
      ,stickleback
      ,seahorse
      ,sturgeon
      ,oceanPerch
      ,char
      ,bobtailSnipeEel
      ,bream
      ,oregonChub
      ,tarpon
      ,carp
      ,atlanticSalmon
      ,africanLungfish
      ,rou
      ,tutor
      ,una
      ,aunt
      ,rag
      ,norhernPike
      ,kennethPrior
      ,treat
      ,sickleback
      ,surgeon
      ,nachoCrepe
      ,arch
      ,bobailSnipeEel
      ,alienBiblePoets
      ,amber
      ,hugeBronco
      ,patron
      ,arpon
      ,crap
      ,alanicSalmon
      ,satanicTollman
      ,guacamoleSubstance
      ,crapSubstance
      ,bitters
      ,vegetableOil
      ,vegeableOil
      ,dietPepsi
      ,chocolateMilk
      ,chocolaeMilk
      ,truffles
      ,ruffles
      ,specialK
      ,minestroneSoup
      ,minesroneSoup
      ,chickenNoodleSoup
      ,clamChowder
      ,sake
      ,tableSalt
      ,roundFlask
      ,conicalFlask
      ,tallBottle
      ,wideBottle
      ,shortBottle
      ,narrowBottle
      ,largeGlass
      ,smallGlass
      ,greenBag
      ,blueBag
      ,lavenderBag
      ,redBowl
      ,pinkBowl
      ,yellowBowl
      ,orangeBowl
      ,milkChocolate
      ,torte
      ,carrotCake
      ,carroCake
      ,brats
      ,bras
      ,mutton
      ,steak
      ,taco
      ,roastBeefSandwich
      ,roasBeefSandwich
      ,iceCreamBar
      ,woodenStick
      ,oatCracker
      ,oaCracker
      ,friedEgg
      ,lemon
      ,melon
      ,beets
      ,bakedBeans
      ,chocolateSyrup
      ,chocolaeSyrup
      ,ceramicBear
      ,ore
      ,stake
      ,tiedPipes
      ,coat
      ,silkCape
      ,shogun
      ,crysal
      ,milkChocolae
      ,cerificae
      ,woodenSick
      ,seak
      ,aco
      ,coa
      ,wideBole
      ,shorBole
      ,narrowBole
      ,elecricPisol
      ,silencedPisol
      ,phoonicDisruper
      ,xenie
      ,blaser
      ,blackPed
      ,navyPed
      ,greenPed
      ,maroonPed
      ,tealPed
      ,purplePed
      ,olivePed
      ,silverPed
      ,grayPed
      ,bluePed
      ,limePed
      ,redPed
      ,aquaPed
      ,fuchsiaPed
      ,yellowPed
      ,whitePed
      ,cyanPed
      ,magentaPed
      ,blankPed
      ,blackPlq
      ,navyPlq
      ,greenPlq
      ,maroonPlq
      ,tealPlq
      ,purplePlq
      ,olivePlq
      ,silverPlq
      ,grayPlq
      ,bluePlq
      ,limePlq
      ,redPlq
      ,aquaPlq
      ,fuchsiaPlq
      ,yellowPlq
      ,whitePlq
      ,cyanPlq
      ,magentaPlq
      ,blankPlq
      ,shotgun
      ,phaser
      ,explosive
      ,handgun
      ,laser
      ,dispenser
      ,dispenserButton
      ,dispenserBuon
      ,crystal
      ,particleGun
      ,paricleGun
      ,particleCell
      ,paricleCell
      ,xenite
      ,aryUng
      ,rayGun
      ,pulseGun
      ,electricPistol
      ,silencedPistol
      ,disrupter
      ,missileLauncher
      ,launcherKeypad
      ,launcherDisplay
      ,tRemovingGun
      ,removingGun
      ,netonCorpse
      ,ovanCorpse
      ,youngGuardCorpse
      ,oldGuardCorpse
      ,assistantCorpse
      ,oldGuardSandwich
      ,dagger
      ,netonIcepick
      ,ovanIcepick
      ,cell
      ,cellFloor
      ,bunkBed
      ,lowerBunk
      ,middleBunk
      ,upperBunk
      ,cellToilet
      ,cellOile
      ,bathOile
      ,closedPanel
      ,foodDispenser
      ,foodMonitor
      ,foodKeyboard
      ,foodBin
      ,cellDoor
      ,foodCube
      ,coffin
      ,coffinThing
      ,coffinCeiling
      ,coffinFloor
      ,coffinWalls
      ,confRoom
      ,firstConfChair
      ,secondConfChair
      ,thirdConfChair
      ,confTable
      ,confDoor
      ,defaultWalls
      ,me
      ,myShirt
      ,myPants
      ,neton
      ,ovan
      ,assistant
      ,assisan
      ,youngGuard
      ,oldGuard
      ,greenJacket
      ,yellowJacket
      ,beigeJacket
      ,greenJacke
      ,yellowJacke
      ,beigeJacke
      ,ovanPda
      ,pad
      ,ovanPdaButtons
      ,cryoPapers
      ,netonBooks
      ,youngGuardUniform
      ,oldGuardUniform
      ,oldGuardHandCannon
      ,youngGuardHandCannon
      ,vicki
      ,diane
      ,vickiShirt
      ,dianeShirt
      ,vickiPants
      ,dianePants
    ];
    local objectNameList = [
       'hallway1'
      ,'hallway2'
      ,'hallway3'
      ,'hallway4'
      ,'hallway7'
      ,'hallway5'
      ,'arrowSign'
      ,'hallway6'
      ,'slowingSign'
      ,'apparatus'
      ,'apparaus'
      ,'slowingBuon'
      ,'slowingButton'
      ,'slowingField'
      ,'noDrain'
      ,'drain'
      ,'nadir'
      ,'stairs'
      ,'stairsFloor'
      ,'hallway9'
      ,'skyway'
      ,'skywayWindows'
      ,'skywayOutside'
      ,'dreamRoom'
      ,'officeWindow'
      ,'dreamWindow'
      ,'dreamCouch'
      ,'dreamArm'
      ,'office'
      ,'officeShelves'
      ,'officeDevices'
      ,'stacksOfFiles'
      ,'sacksOfFiles'
      ,'casksOfFiles'
      ,'officeBooks'
      ,'netonDesk'
      ,'ovanDesk'
      ,'netonDrawer'
      ,'ovanDrawer'
      ,'netonComputer'
      ,'ovanComputer'
      ,'netonCompuer'
      ,'ovanCompuer'
      ,'ovanNotebooks'
      ,'ovanNoebooks'
      ,'academicJournals'
      ,'ovanPapers'
      ,'keycard'
      ,'stapler'
      ,'plaster'
      ,'sapler'
      ,'plaser'
      ,'pearls'
      ,'paperClips'
      ,'crispApple'
      ,'dryCake'
      ,'netonChair'
      ,'breakRoom'
      ,'geFridge'
      ,'geFreezer'
      ,'cupboard'
      ,'breakTable'
      ,'breakChair'
      ,'upperFridgeShelf'
      ,'lowerFridgeShelf'
      ,'upperFridgeDrawer'
      ,'lowerFridgeDrawer'
      ,'certificate'
      ,'bathroom'
      ,'bathToilet'
      ,'mirror'
      ,'museum'
      ,'museumSign'
      ,'westPlatform'
      ,'eastPlatform'
      ,'officeDoor'
      ,'officeDoor2'
      ,'dreamDoor'
      ,'dreamDoor2'
      ,'hallwaySlo'
      ,'cellSlo'
      ,'hallwaySlot'
      ,'cellSlot'
      ,'cellDoor2'
      ,'breakDoor'
      ,'breakDoor2'
      ,'bathDoor'
      ,'bathDoor2'
      ,'confDoor2'
      ,'hallDoors'
      ,'hallDoors2'
      ,'frontDoors'
      ,'frontDoors2'
      ,'hallDoorway'
      ,'hallDoorway2'
      ,'minnow'
      ,'trout'
      ,'tuna'
      ,'gar'
      ,'northernPike'
      ,'tetra'
      ,'stickleback'
      ,'seahorse'
      ,'sturgeon'
      ,'oceanPerch'
      ,'char'
      ,'bobtailSnipeEel'
      ,'bream'
      ,'oregonChub'
      ,'tarpon'
      ,'carp'
      ,'atlanticSalmon'
      ,'africanLungfish'
      ,'rou'
      ,'tutor'
      ,'una'
      ,'aunt'
      ,'rag'
      ,'norhernPike'
      ,'kennethPrior'
      ,'treat'
      ,'sickleback'
      ,'surgeon'
      ,'nachoCrepe'
      ,'arch'
      ,'bobailSnipeEel'
      ,'alienBiblePoets'
      ,'amber'
      ,'hugeBronco'
      ,'patron'
      ,'arpon'
      ,'crap'
      ,'alanicSalmon'
      ,'satanicTollman'
      ,'guacamoleSubstance'
      ,'crapSubstance'
      ,'bitters'
      ,'vegetableOil'
      ,'vegeableOil'
      ,'dietPepsi'
      ,'chocolateMilk'
      ,'chocolaeMilk'
      ,'truffles'
      ,'ruffles'
      ,'specialK'
      ,'minestroneSoup'
      ,'minesroneSoup'
      ,'chickenNoodleSoup'
      ,'clamChowder'
      ,'sake'
      ,'tableSalt'
      ,'roundFlask'
      ,'conicalFlask'
      ,'tallBottle'
      ,'wideBottle'
      ,'shortBottle'
      ,'narrowBottle'
      ,'largeGlass'
      ,'smallGlass'
      ,'greenBag'
      ,'blueBag'
      ,'lavenderBag'
      ,'redBowl'
      ,'pinkBowl'
      ,'yellowBowl'
      ,'orangeBowl'
      ,'milkChocolate'
      ,'torte'
      ,'carrotCake'
      ,'carroCake'
      ,'brats'
      ,'bras'
      ,'mutton'
      ,'steak'
      ,'taco'
      ,'roastBeefSandwich'
      ,'roasBeefSandwich'
      ,'iceCreamBar'
      ,'woodenStick'
      ,'oatCracker'
      ,'oaCracker'
      ,'friedEgg'
      ,'lemon'
      ,'melon'
      ,'beets'
      ,'bakedBeans'
      ,'chocolateSyrup'
      ,'chocolaeSyrup'
      ,'ceramicBear'
      ,'ore'
      ,'stake'
      ,'tiedPipes'
      ,'coat'
      ,'silkCape'
      ,'shogun'
      ,'crysal'
      ,'milkChocolae'
      ,'cerificae'
      ,'woodenSick'
      ,'seak'
      ,'aco'
      ,'coa'
      ,'wideBole'
      ,'shorBole'
      ,'narrowBole'
      ,'elecricPisol'
      ,'silencedPisol'
      ,'phoonicDisruper'
      ,'xenie'
      ,'blaser'
      ,'blackPed'
      ,'navyPed'
      ,'greenPed'
      ,'maroonPed'
      ,'tealPed'
      ,'purplePed'
      ,'olivePed'
      ,'silverPed'
      ,'grayPed'
      ,'bluePed'
      ,'limePed'
      ,'redPed'
      ,'aquaPed'
      ,'fuchsiaPed'
      ,'yellowPed'
      ,'whitePed'
      ,'cyanPed'
      ,'magentaPed'
      ,'blankPed'
      ,'blackPlq'
      ,'navyPlq'
      ,'greenPlq'
      ,'maroonPlq'
      ,'tealPlq'
      ,'purplePlq'
      ,'olivePlq'
      ,'silverPlq'
      ,'grayPlq'
      ,'bluePlq'
      ,'limePlq'
      ,'redPlq'
      ,'aquaPlq'
      ,'fuchsiaPlq'
      ,'yellowPlq'
      ,'whitePlq'
      ,'cyanPlq'
      ,'magentaPlq'
      ,'blankPlq'
      ,'shotgun'
      ,'phaser'
      ,'explosive'
      ,'handgun'
      ,'laser'
      ,'dispenser'
      ,'dispenserButton'
      ,'dispenserBuon'
      ,'crystal'
      ,'particleGun'
      ,'paricleGun'
      ,'particleCell'
      ,'paricleCell'
      ,'xenite'
      ,'aryUng'
      ,'rayGun'
      ,'pulseGun'
      ,'electricPistol'
      ,'silencedPistol'
      ,'disrupter'
      ,'missileLauncher'
      ,'launcherKeypad'
      ,'launcherDisplay'
      ,'tRemovingGun'
      ,'removingGun'
      ,'netonCorpse'
      ,'ovanCorpse'
      ,'youngGuardCorpse'
      ,'oldGuardCorpse'
      ,'assistantCorpse'
      ,'oldGuardSandwich'
      ,'dagger'
      ,'netonIcepick'
      ,'ovanIcepick'
      ,'cell'
      ,'cellFloor'
      ,'bunkBed'
      ,'lowerBunk'
      ,'middleBunk'
      ,'upperBunk'
      ,'cellToilet'
      ,'cellOile'
      ,'bathOile'
      ,'closedPanel'
      ,'foodDispenser'
      ,'foodMonitor'
      ,'foodKeyboard'
      ,'foodBin'
      ,'cellDoor'
      ,'foodCube'
      ,'coffin'
      ,'coffinThing'
      ,'coffinCeiling'
      ,'coffinFloor'
      ,'coffinWalls'
      ,'confRoom'
      ,'firstConfChair'
      ,'secondConfChair'
      ,'thirdConfChair'
      ,'confTable'
      ,'confDoor'
      ,'defaultWalls'
      ,'me'
      ,'myShirt'
      ,'myPants'
      ,'neton'
      ,'ovan'
      ,'assistant'
      ,'assisan'
      ,'youngGuard'
      ,'oldGuard'
      ,'greenJacket'
      ,'yellowJacket'
      ,'beigeJacket'
      ,'greenJacke'
      ,'yellowJacke'
      ,'beigeJacke'
      ,'ovanPda'
      ,'pad'
      ,'ovanPdaButtons'
      ,'cryoPapers'
      ,'netonBooks'
      ,'youngGuardUniform'
      ,'oldGuardUniform'
      ,'oldGuardHandCannon'
      ,'youngGuardHandCannon'
      ,'vicki'
      ,'diane'
      ,'vickiShirt'
      ,'dianeShirt'
      ,'vickiPants'
      ,'dianePants'
    ];
    
    //for (local i = 1; i <= objectNameList.length; i++) {
    //  say(objectNameList[i] + ':' + objectList[i].wordName + '\n');
    //}
    
    for (local i = 1; i <= objectNameList.length; i++) {
      local obj = objectList[i];
      local gun = tRemovingGun;
      gun.moveInto(gPlayerChar);
      glob.doingWordNameInventory = true;
      netonDrawer.makeOpen(true);
      ovanDrawer.makeOpen(true);
      geFridge.makeOpen(true);
      geFreezer.makeOpen(true);
      cupboard.makeOpen(true);
      upperFridgeDrawer.makeOpen(true);
      lowerFridgeDrawer.makeOpen(true);
      initArtLocations();
      
      if (obj && obj.getOutermostRoom != nil && !obj.ofKind(Room)
        && obj.ofKind(Plaque))
      {
        say('<hr>');
        obj.moveInto(gPlayerChar.getOutermostRoom());
        nestedAction(ShootWith, obj, gun);
      }
      
      glob.doingWordNameInventory = nil;
    }
  }
;
VerbRule(WordNameInventory)
  'wordnameinventory'
  : WordNameInventoryAction
  verbPhrase = 'do/doing word name inventory'
;

modify glob
  doingWordNameInventory = nil
;




#endif // __DEBUG

