#include "xlib.h"
#include "sb1misc.h"

extern yakLib sb1Lib;
extern grumPlayer player1;

void loadIcons(void)
{
  factor::loadFactor(0, "", "swgrum", "sgrumjug", "segrum", "lgrumjug", "cgrumjug",
			"grumjug", "nwgrum", "ngrumjug", "negrum", &sb1Lib);
  factor::loadFactor(1, "", "", "", "", "", "wclub", "", "","","", &sb1Lib);
  factor::loadFactor(2, "", "", "", "", "", "blob", "", "", "", "", &sb1Lib);
}

void drawBorder(void)
{
  icon * currentIcon = NULL;
  currentIcon = new icon;
  currentIcon->load("nwbord.yak", icon::normal, &sb1Lib);
  currentIcon->show(0,0,SplitScrnOffs);
  currentIcon->load("nebord.yak", icon::normal, &sb1Lib);
  currentIcon->show(303,0, SplitScrnOffs);
  currentIcon->load("swbord.yak", icon::normal, &sb1Lib);
  currentIcon->show(0, 32, SplitScrnOffs);
  currentIcon->load("sebord.yak", icon::normal, &sb1Lib);
  currentIcon->show(303, 32, SplitScrnOffs);
  currentIcon->load("hbord.yak", icon::normal, &sb1Lib);
  for(int counter = 0; counter < 18; ++counter)
  {
    currentIcon->show(15 + (counter*16), 0, SplitScrnOffs);
    currentIcon->show(15 + (counter*16), 32, SplitScrnOffs);
  }
  currentIcon->load("vbord.yak", icon::normal, &sb1Lib);
  currentIcon->show(0, 16, SplitScrnOffs);
  currentIcon->show(303, 16, SplitScrnOffs);
  delete currentIcon;
}

grumPlayer::grumPlayer(void) : player()
{
  missileType = CLUB;
  moveIncrement = 5;
  jumpIncrement = 12;
  numMissiles = 3;
  hitPoints = 24;
  gravity=1;
};

missile * grumPlayer::missileGenerator(int missileType)
{
  switch (missileType)
  {
    case CLUB: return new club(this);
  }
  return NULL;
}