#ifndef FACTOR.H

#define FACTOR.H

#include "actor.h"


#define MAX_FACTORS 10

typedef animicon directionTable[10];

class factor : public animactor //facing-actor
{
public:
  enum direction {special, southwest, south, southeast, west, center, east,
		  northwest, north, northeast};
  enum type {eightFace, twoFace, oneFace, fourFace};
  animiconNode * directionIcons[10];
  byte direction;
  factor() {direction = 5;};
  virtual void advance();
  void turn(byte idirection);
  virtual void spawn(animactor * spawnactor);
  void assignIcon(int icon_number, type mode, char identity = 255);
  static directionTable * ficonTable;
  static void loadFactor(int position, char * special, char * sw, char * s,
			char * se, char * w, char * center, char * e,
			char * nw, char * n, char * ne, yakLib * myYakLib = NULL,
			icon::flagType flags = icon::normal);
  static void clearFactor(int position);
};

#endif