#ifndef SCRIPT.H

#define SCRIPT.H

#include <stddef.h>
#include "stddefs.h"

class scriptNode
{
public:
  enum scriptCommand {doNothing, fineMoveRel, fineSlide, turn};
  scriptNode * nextLine; // what it should do next.
  byte command;
  int mapX, mapY;
  int squareX, squareY;
  scriptNode() {nextLine = NULL; command = mapX = mapY = squareX = squareY = 0;};
  scriptNode(byte icommand, int ix, int iy, int isquareX, int isquareY);
};

class script
{
public:
  scriptNode * firstLine, * lastLine, * thisLine;
  script() {firstLine = thisLine = lastLine = NULL;}
  void addLine(byte command, int mapX, int mapY, int squareX, int squareY);
  void addCommand(scriptNode::scriptCommand command, int mapX, int mapY, int squareX, int squareY);
  void advanceLine(void);
};
#endif
