#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void main(int argCount, char ** argVector)
{
  char filename[20], *myCharPointer;
  int myChar;
  int myOtherCounter = 0;
  if (argCount < 2)
  {
    cout << "Yak2Hdr: .yak to header file conversion tool\n\n";
    cout << "USAGE:\nC>yak2hdr <fileSpec>\n";
    cout << "where <fileSpec> is the name of the first file to convert.\n";
    cout << "output goes to file <fileSpec>.h, eliminating extension of <fileSpec>.\n";
    cout << "WARNING: Will overwrite destination file!  Be careful!\n\n";
    exit(0);
  }
  ifstream myInStream;
  ofstream myOutStream;
  for (int counter = 1; counter < argCount; ++counter)
    {
    myInStream.open(argVector[counter]);
    if (myInStream)
    {
      strcpy(filename, argVector[counter]);
      myCharPointer = strchr(filename, '.');
      if (myCharPointer != NULL)
      {
        ++myCharPointer;
        *myCharPointer = 'h';
        ++myCharPointer;
        *myCharPointer = 0;
      }
      myOutStream.open(filename);
      strcpy(filename, argVector[counter]);
      for (myCharPointer = filename; *myCharPointer != 0; ++myCharPointer)
        *myCharPointer = tolower(*myCharPointer);
      myCharPointer = strchr(filename, '.');
      if (myCharPointer != NULL)
      {
        *myCharPointer = toupper(*(myCharPointer + 1));
        ++myCharPointer;
        while(*(myCharPointer) != 0)
        {
          *myCharPointer = *(myCharPointer + 1);
          ++myCharPointer;
        }
      }
      myOutStream << "//header file translated from binary file " << argVector[counter] << "\n\n";
      myOutStream << "unsigned char " << filename << "[] = {\n";
      myOtherCounter = 1;
      while ((myChar = myInStream.get()) != EOF)
      {
        myOutStream << myChar << ", ";
        if (!(myOtherCounter % 10))
          myOutStream << "\n";
        ++myOtherCounter;
      }
      myOutStream << "\n};\n";
      myOutStream.close();
      myInStream.close();
    }
  }
}