#define YAKSTICKUNIT
//yakIcons implementation of Christopher Christensen's joystick routines
#include "yakstick.h"

yakStick joyStick1(1), joyStick2(2);

extern int jstk1_x;
extern int jstk2_x;
extern int jstk1_y;
extern int jstk2_y;
extern "C" int read_jstk(void);

int yakStick::read(void)
{
  int buttons = read_jstk();
  x = (stickNumber == 1) ? jstk1_x : jstk2_x;
  y = (stickNumber == 1) ? jstk1_y : jstk2_y;
  if (stickNumber != 1)
    buttons >>= 2;
  button1 = buttons & 0x01;
  button2 = buttons & 0x02;
}

int yakStick::readX(void)
{
  read();
  return x;
}

int yakStick::readY(void)
{
  read();
  return y;
}

byte yakStick::readButton1(void)
{
  read();
  return button1;
}

byte yakStick::readButton2(void)
{
  read();
  return button2;
}
