#include <iostream.h>
#include <malloc.h>
#include <string.h>
#include "yakwin.h"
#include "yakMouse.h"
#include "xlib.h"
#include "xpbitmap.h"
#include "xrect.h"
#include "xtext.h"
#include "xline.h"
#include <conio.h>

extern yakMouse mouse;

yakWindow * yakWindow::killPointer = NULL;

//yakWindowPane functions follow------------------------------------->
yakWindowPane::yakWindowPane(word x1, word y1, word x2, word y2)
{
  width = x2-x1;
  bWidth = (width + (((4-(width % 4)) == 4) ? 0 : (4-(width%4))))/4;  //smallest mult of 4 > width!
  x=x1; y=y1; height = y2-y1;
  myGraphicData = NULL;
}

void yakWindowPane::save(word x1, word y1, word ioffset)
{
  if (myGraphicData)
  {
    delete myGraphicData;
    myGraphicData = NULL;
  }
  x = x1; y = y1; myOffset = ioffset;
  if (!myGraphicData)
    myGraphicData = new byte[bWidth*4*height + 4];
  x_get_pbm(x1, y1, bWidth, height, myOffset, myGraphicData);
}

void yakWindowPane::save(void)
{
  if (myGraphicData)
  {
    delete myGraphicData;
    myGraphicData = NULL;
  }
  if (!myGraphicData)
    myGraphicData = new byte[bWidth*4*height + 4];
  if (myGraphicData == NULL)
    exit(EXIT_FAILURE);

  x_get_pbm(x, y, bWidth, height, myOffset, myGraphicData);
}

void yakWindowPane::restore(word ioffset)
{
  x_put_pbm(x, y, ioffset, myGraphicData);
}

void yakWindowPane::restore(void)
{
  if (myGraphicData == NULL)
    exit(EXIT_FAILURE);
  x_put_pbm(x, y, VisiblePageOffs, myGraphicData);
  if (VisiblePageOffs != HiddenPageOffs)
    x_put_pbm(x, y, HiddenPageOffs, myGraphicData);
}

//yakWindow definitions follow--------------------------------------->

yakWindow * yakWindow::topWindow = NULL;
yakWindow * yakWindow::bottomWindow = NULL;
yakWindow * yakWindow::activeWindow = NULL;

yakWindow::yakWindow(int x1, int y1, int x2, int y2) :
yakWindowPane(x1, y1, x2, y2)
{
  myOffset = VisiblePageOffs;
  textColor = 15;
  titleBarColor = 63;
  boxColor = 0;
  title[0]= 0;
  myFlags = isSizeable | isDraggable | isCloseable;
}


void yakWindow::open(void) //can only open on top...
{
  mouse.hide();
  if (bottomWindow == NULL)  //then we're the bottom window!
  {
    bottomWindow = this;
    prevWindow = NULL;
    nextWindow = NULL;
  }
  if (topWindow) //if there is a top window, set up accordingly.
  {
    topWindow->showDeActivated();
    topWindow->nextWindow = this;
    prevWindow = topWindow;
    nextWindow = NULL;
  }
  topWindow = this;
  save();
  draw();
  showActivated();
  activeWindow = this;
  mouse.show();
}

void yakWindow::close(void)  //can only close on top too.
{
  mouse.hide();
  if (topWindow != this)
    shuffleToTop();       //now we know we're topWindow.
  topWindow = prevWindow; //which should be null if we're on bottom.
  if (bottomWindow == this)
    bottomWindow = NULL;  //we're closing the last window.
  if (topWindow)          //if there's still a top window,
    topWindow->nextWindow = NULL;  //make sure it doesn't think there's a next!
  restore();
  if (myGraphicData)
  {
    delete myGraphicData;
    myGraphicData = NULL;
  }
  activeWindow = topWindow;
  topWindow->showActivated();
  if (myFlags & isTemporary)
    killPointer = this;
  mouse.show();
}

void yakWindow::shuffleToTop(void)
{
  mouse.hide(); //so we don't disrupt everything!
  yakWindow * myYakWindowPointer = topWindow;
  if (myYakWindowPointer == NULL)
  {
    mouse.show();
    return; //if there're no windows,  we can't do much!
  }
  if (myYakWindowPointer == this)
  {
    mouse.show();
    return; //we're already on top.
  }
  while ((myYakWindowPointer != this) && (myYakWindowPointer != NULL))
  {
    myYakWindowPointer->restore();   //restore screen from top window down.
    myYakWindowPointer = myYakWindowPointer->prevWindow;
  }
  if (myYakWindowPointer == NULL)
  {
    drawAll();
    open(); //put this window on top...
    mouse.show();
    return; //this window wasn't in the list!
  }
  restore(); //now restore this window.
  if (prevWindow)  //if we're not the bottom
    prevWindow->nextWindow = nextWindow;  //eliminate this window from list
  else
    bottomWindow = nextWindow;        //we are the bottom, so make next
  if (nextWindow)
    nextWindow->prevWindow = prevWindow;
  myYakWindowPointer = nextWindow; //now look at next window
  while (myYakWindowPointer != topWindow)
  {
    myYakWindowPointer->save();
    myYakWindowPointer->draw();
    myYakWindowPointer = myYakWindowPointer->nextWindow;
  }
  myYakWindowPointer->save();  //now save top window
  myYakWindowPointer->draw();
  open();  //now add our new window.
  mouse.show();
}

void yakWindow::drawAll(void)
{
  yakWindow * myYakWindowPointer = bottomWindow;
  if (myYakWindowPointer)
    while (myYakWindowPointer != NULL)
    {
      myYakWindowPointer->save();
      myYakWindowPointer->draw();
      myYakWindowPointer = myYakWindowPointer->nextWindow;
    }
}

void yakWindow::draw(word offset)
{
  x = x;
  y = y;
  x_rect_fill(x, y, x+width, y+height, offset, 10);
  x_rect_fill(x+2, y+2, x+width-2, y+height-2, offset, boxColor);
  x_line(x,y, x+width-1, y, 15, offset); //top
  x_line(x,y, x, y+height-1, 15, offset); //left
  x_line(x,y+height-1, x+width-1, y+height-1, 5, offset); //bottom
  x_line(x+width-1,y, x+width-1, y+height-1, 5, offset); //right
  x_line(x+width - 2, y + height - 4, x+width-1, y+height - 4, 0, offset); //size box
  x_line(x+width - 4, y+height - 2, x+width-4, y+height-1, 0, offset); //size box
  x_line(x+3, y, x+3, y+2, 0, offset); //close box
  x_line(x, y+3, x+2, y+3, 0, offset); //close box
  showDeActivated(offset);
}

void yakWindow::draw(void)
{
  draw(VisiblePageOffs);
  if (VisiblePageOffs != HiddenPageOffs)
    draw(HiddenPageOffs);
}

void yakWindow::showActivated(word offset)
{
  x_rect_fill(x+2, y+2, x+width - 2, y+2+CharHeight, offset, titleBarColor);
  x_bgprintf(x+2, y+2, offset, textColor, titleBarColor, title);
}

void yakWindow::showActivated(void)
{
  showActivated(VisiblePageOffs);
  if (VisiblePageOffs != HiddenPageOffs)
    showActivated(HiddenPageOffs);
}

void yakWindow::showDeActivated(word offset)
{
  x_rect_fill(x+2, y+2, x+width - 2, y+2+CharHeight, offset, titleBarColor-5);
  x_bgprintf(x+2, y+2, offset, textColor-5, titleBarColor-5, title);
}

void yakWindow::showDeActivated(void)
{
  showDeActivated(VisiblePageOffs);
  if (VisiblePageOffs != HiddenPageOffs)
    showDeActivated(HiddenPageOffs);
}

word yakWindow::interpretMouseClick(void)
{
  if (isDragSelected())
    drag();
  if (isSizeSelected())
    size();
  if (isCloseSelected())
    close();
  return 0;
}

word yakWindow::interpretKeyStroke(char myChar)
{
  return 0;
}

void yakWindow::drag(void)
{
  int oldX = mouse.x();
  int oldY = mouse.y();
  int deltaX, deltaY;
  mouse.hide();
  while(mouse.isPressed(yakMouse::leftButton))
  {
    deltaX = mouse.x() - oldX;
    deltaY = mouse.y() - oldY;
    oldX = mouse.x();
    oldY = mouse.y();
    restore();
    x += ((((int)x + deltaX) >= 0) && (((int)x + deltaX + width) <= ScrnLogicalPixelWidth)) ? deltaX : 0;
    y += ((((int)y + deltaY) >= 0) && (((int)y + deltaY + height) <= ScrnLogicalHeight)) ? deltaY : 0;
    save();
    draw();
  }
  showActivated();
  mouse.show();
}

void yakWindow::size(void)
{
  int oldX = mouse.x();
  int oldY = mouse.y();
  int deltaX, deltaY;
  mouse.hide();
  while(mouse.isPressed(yakMouse::leftButton))
  {
    deltaX = mouse.x() - oldX;
    deltaY = mouse.y() - oldY;
    oldX = mouse.x();
    oldY = mouse.y();
    restore();
    width  += (((width + deltaX) < (strlen(title)*CharWidth + 4)) || (((int)x + deltaX + width) > ScrnLogicalPixelWidth)) ? 0: deltaX;
    bWidth = (width + (((4-(width % 4)) == 4) ? 0 : (4-(width%4))))/4;  //smallest mult of 4 > width!
    height += (((height + deltaY) < (CharHeight + 4)) || (((int)y + deltaY + height) > ScrnLogicalHeight)) ? 0 : deltaY;
    save();
    draw();
  }
  showActivated();
  mouse.show();
}

int yakWindow::isSelected(void)
{
  if (mouse.isInBox(x, y, x + width, y + height) && mouse.isPressed(yakMouse::leftButton))
    return 1;
  else return 0;
}

int yakWindow::isDragSelected(void)
{
  if (mouse.isInBox(x+2, y+2, x + width-2, y + 2 + CharHeight) && mouse.isPressed(yakMouse::leftButton) && (myFlags & isDraggable))
    return 1;
  else return 0;
}

int yakWindow::isSizeSelected(void)
{
  if (mouse.isInBox(x+width-5, y+height-5, x+width, y+height) &&
     !mouse.isInBox(x+width-5, y+height-5, x+width-3, y+height-3) &&
     (myFlags & isSizeable))
    return 1;
  else return 0;
}

int yakWindow::isCloseSelected(void)
{
  if (mouse.isInBox(x, y, x+5, y+5) &&
     !mouse.isInBox(x+2, y+2, x+5, y+5)&&
     (myFlags & isCloseable))
    return 1;
  else return 0;
}

void yakWindow::selectToTop(void)
{
  yakWindow * myYakWindowPointer = topWindow;
  while (myYakWindowPointer != NULL)
  {
    if (myYakWindowPointer->isSelected())
      break;
    myYakWindowPointer = myYakWindowPointer->prevWindow;
  }
  activeWindow = myYakWindowPointer;
  mouse.hide();
  if (activeWindow)
  {
    myYakWindowPointer->shuffleToTop();
    activeWindow->showActivated();
  }
  else
    topWindow->showDeActivated();
  mouse.show();
}

word yakWindow::advance(void)
{
  if (killPointer)
  {
    delete killPointer;
    killPointer = NULL; //delete the "killed" window
  }
  if (mouse.isPressed(yakMouse::eitherButton))
  {
//    if (mouse.isPressed(yakMouse::leftButton))
      selectToTop();
    if (activeWindow)
      return activeWindow->interpretMouseClick();
  }
  if (kbhit() && activeWindow)
    return(activeWindow->interpretKeyStroke(getch()));
  if (!(mouse.isPressed(yakMouse::eitherButton)))
    mouse.isClicked(yakMouse::reset);
  return 0;
}