package nFunk.JEP.postfixMathCommand;

import java.lang.Math;
import java.util.*;
import nFunk.JEP.*;

public class Modulus extends PostfixMathCommand implements PostfixMathCommandI
{
	public Modulus()
	{
		numberOfParameters = 2;
	}
	
	public void run(Stack inStack)
		throws ParseException 
	{
		checkStack(inStack);// check the stack
		double divisor = ((Double)inStack.pop()).doubleValue();
		double dividend = ((Double)inStack.pop()).doubleValue();
		
		double result = dividend % divisor;

		inStack.push(new Double(result));
		return;
	}
}