/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterLC;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterJAEUC
extends CharacterConverterLC {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int LEADINGCODE = 143;

    public CharacterConverterJAEUC() {
        this.m_groupId = 2;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    int toUnicode(int n) throws SQLException {
        int n2 = 0;
        if ((n >> 16 & 0xFFFF) == 143) {
            n2 = 256;
        }
        int n3 = n >> 8 & 255 + n2;
        int n4 = n & 0xFF;
        if (this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1) {
            return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
        }
        throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
    }

    int toUnicodeWithReplacement(int n) {
        int n2 = 0;
        if ((n >> 16 & 0xFFFF) == 143) {
            n2 = 256;
        }
        int n3 = n >> 8 & 255 + n2;
        int n4 = n & 0xFF;
        int n5 = this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] : this.m_ucsCharReplacement;
        return n5;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            int n5 = byArray[n] & 0xFF;
            int n6 = 0;
            if (n5 == 143) {
                if (n2 < 3) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                n5 = byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] & 0xFF;
                n4 = 3;
                n6 = 256;
            } else if (n5 > 127) {
                if (n2 < 2) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                n5 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
                n4 = 2;
            } else {
                n4 = 1;
            }
            int n7 = (n5 >> 8 & 0xFF) + n6;
            int n8 = n5 & 0xFF;
            if (this.m_ucsCharLevel1[n7] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] == -1) {
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            int n9 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8];
            if (((long)n9 & 0xFFFFFFFFL) > 65535L) {
                cArray[n3++] = (char)(n9 >>> 16);
                cArray[n3++] = (char)(n9 & 0xFFFF);
            } else {
                cArray[n3++] = (char)n9;
            }
            n2 -= n4;
            n += n4;
        }
        return new String(cArray, 0, n3);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            int n5 = byArray[n] & 0xFF;
            int n6 = 0;
            if (n5 == 143) {
                if (n2 < 3) break;
                n5 = byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] & 0xFF;
                n4 = 3;
                n6 = 256;
            } else if (n5 > 127) {
                if (n2 < 2) break;
                n5 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
                n4 = 2;
            } else {
                n4 = 1;
            }
            int n7 = (n5 >> 8 & 0xFF) + n6;
            int n8 = n5 & 0xFF;
            int n9 = this.m_ucsCharLevel1[n7] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] : this.m_ucsCharReplacement;
            if (((long)n9 & 0xFFFFFFFFL) > 65535L) {
                cArray[n3++] = (char)(n9 >>> 16);
                cArray[n3++] = (char)(n9 & 0xFFFF);
            } else {
                cArray[n3++] = (char)n9;
            }
            n2 -= n4;
            n += n4;
        }
        return new String(cArray, 0, n3);
    }

    public void extractCodepoints(Vector vector) {
        int[] nArray;
        int n;
        int n2 = 0;
        int n3 = 65535;
        for (n = n2; n <= n3; ++n) {
            try {
                nArray = new int[]{n, this.toUnicode(n)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        n2 = 0x8F0000;
        n3 = n2 + 65535;
        for (n = n2; n <= n3; ++n) {
            try {
                nArray = new int[]{n, this.toUnicode(n)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public int ByteToCharConvert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }
}

