/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import sqlj.framework.error.JSError;
import sqlj.framework.error.LogEntry;
import sqlj.mesg.SerProfileToClassErrors;
import sqlj.mesg.TranslatorErrors;
import sqlj.runtime.profile.Profile;
import sqlj.tools.RunCmd;
import sqlj.util.io.ErrorLogger;
import sqlj.util.io.OracleOutputStreamWriter;

public class SerProfileToClass {
    private static PrintWriter errorStream;
    private static PrintWriter statusStream;
    private static ErrorLogger log;
    private String m_profName;
    private String m_package = null;
    private String m_profClassName;

    public static void main(String[] stringArray) {
        System.exit(SerProfileToClass.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        SerProfileToClass.initializeErrors();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals("-help")) {
                SerProfileToClass.usage();
                return 0;
            }
            if (stringArray[n3].equals("-nc")) {
                bl = false;
            } else if (stringArray[n3].equals("-rj")) {
                bl2 = true;
            } else if (stringArray[n3].equals("-rs")) {
                bl3 = true;
            } else if (stringArray[n3].equals("-ms")) {
                bl4 = true;
            } else if (stringArray[n3].endsWith(".ser")) {
                vector.addElement(stringArray[n3]);
            } else if (stringArray[n3].endsWith("true")) {
                bl5 = true;
            } else if (stringArray[n3].endsWith("false")) {
                bl5 = false;
            } else {
                errorStream.println(SerProfileToClassErrors.unknown_option((String)stringArray[n3]));
                SerProfileToClass.usage();
                return 1;
            }
            ++n3;
        }
        int n4 = vector.size();
        if (n4 == 0) {
            SerProfileToClass.usage();
            return 1;
        }
        if (bl2 && !bl) {
            errorStream.println(SerProfileToClassErrors.compile_before_removing());
            SerProfileToClass.usage();
            return 1;
        }
        if (bl3 && bl4) {
            String string = SerProfileToClassErrors.incompatible_options((String)"-rs", (String)"-ms");
            errorStream.println(string);
            SerProfileToClass.usage();
            return 1;
        }
        n3 = 0;
        while (n3 < n4) {
            String string = (String)vector.elementAt(n3);
            String string2 = string.substring(0, string.length() - 4);
            String string3 = string2 + ".java";
            if (bl5) {
                statusStream.println(SerProfileToClassErrors.converting_profile((String)string));
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Profile profile = (Profile)objectInputStream.readObject();
                String string4 = profile.getProfileName();
                objectInputStream.close();
                fileInputStream.close();
                FileInputStream fileInputStream2 = new FileInputStream(string);
                FileWriter fileWriter = new FileWriter(string3);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                new SerProfileToClass(string4).writeProfile(printWriter, fileInputStream2);
                printWriter.flush();
                printWriter.close();
                fileWriter.close();
                fileInputStream2.close();
                if (bl) {
                    if (bl5) {
                        statusStream.println(SerProfileToClassErrors.compiling((String)string3));
                    }
                    n2 = RunCmd.exec((String)("javac " + string3), (OutputStream)System.out, (OutputStream)System.err);
                }
                if (bl2) {
                    if (bl5) {
                        statusStream.println(SerProfileToClassErrors.deleting((String)string3));
                    }
                    if (!new File(string3).delete()) {
                        errorStream.println(SerProfileToClassErrors.delete_error((String)string3));
                        n2 = 1;
                    }
                }
                if (bl3) {
                    if (bl5) {
                        statusStream.println(SerProfileToClassErrors.deleting((String)string));
                    }
                    if (!new File(string).delete()) {
                        errorStream.println(SerProfileToClassErrors.delete_error((String)string));
                        n2 = 1;
                    }
                }
                if (bl4) {
                    String string5 = SerProfileToClassErrors.moving((String)string, (String)(string + ".orig"));
                    if (bl5) {
                        statusStream.println(string5);
                    }
                    if (!new File(string).renameTo(new File(string + ".orig"))) {
                        String string6 = SerProfileToClassErrors.move_error((String)string, (String)(string + ".orig"));
                        errorStream.println(string6);
                        n2 = 1;
                    }
                }
            }
            catch (Exception exception) {
                errorStream.println(SerProfileToClassErrors.conversion_error((String)string));
                errorStream.println(exception);
                n2 = 1;
            }
            ++n3;
        }
        return n2;
    }

    private static void usage() {
        String string = SerProfileToClassErrors.usage();
        errorStream.println(string + ": profconv [-nc][-rj][-rs][-ms] profile.ser...");
        errorStream.println("  -nc : " + SerProfileToClassErrors.no_compile_desc());
        errorStream.println("  -rj : " + SerProfileToClassErrors.remove_java_desc());
        errorStream.println("  -rs : " + SerProfileToClassErrors.remove_ser_desc());
        errorStream.println("  -ms : " + SerProfileToClassErrors.rename_desc((String)".orig"));
    }

    public SerProfileToClass(String string) {
        this.m_profName = string;
        int n2 = this.m_profName.lastIndexOf(46);
        if (n2 != -1) {
            this.m_package = this.m_profName.substring(0, n2);
            this.m_profClassName = this.m_profName.substring(n2 + 1);
        } else {
            this.m_profClassName = this.m_profName;
        }
    }

    public void writeProfile(PrintWriter printWriter, InputStream inputStream) throws IOException {
        int n2;
        if (this.m_package != null) {
            printWriter.println("package " + this.m_package + ";");
        }
        printWriter.println("import java.io.*;");
        printWriter.println("public class " + this.m_profClassName + " implements sqlj.runtime.profile.SerializedProfile {");
        printWriter.print("private static final String m_profile = \"");
        while ((n2 = inputStream.read()) != -1) {
            printWriter.print("\\" + Integer.toOctalString(n2));
        }
        printWriter.println("\";");
        printWriter.println("public InputStream getProfileAsStream() throws IOException {");
        printWriter.println("return new ByteArrayInputStream(m_profile.getBytes(\"8859_1\"));");
        printWriter.println("}");
        printWriter.println("}");
    }

    private static void initializeErrors() {
        log = new ErrorLogger();
        errorStream = null;
        statusStream = null;
        try {
            statusStream = errorStream = new PrintWriter((Writer)new OracleOutputStreamWriter((OutputStream)System.out), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.addEntry((LogEntry)new JSError((Object)TranslatorErrors.unsupported_file_encoding((String)System.getProperty("file.encoding", "null"))));
            errorStream = new PrintWriter(System.out, true);
            statusStream = new PrintWriter(System.err, true);
        }
        catch (IOException iOException) {
            errorStream = new PrintWriter(System.out, true);
            statusStream = new PrintWriter(System.err, true);
        }
        catch (Exception exception) {
            errorStream = new PrintWriter(System.out, true);
            statusStream = new PrintWriter(System.out, true);
        }
    }
}

