<?php
// ! Support file only, run AjaxTable.html instead !
// This file is used as both Data_Url and Upload_Url
// Generates data for TreeGrid when no data received or saves received changes to database
// Single file, without using TreeGridFramework.php

// --- Database switching ---
require_once("IncDbTxt.php");                 // Routines to connect to database via text file database
$db = new Database("Database");               // Database in folder "Database"

header("Content-Type: text/xml; charset=utf-8"); 

// --------------------------------------------------------------------------
// --- Saves changes ---
$XML = array_key_exists("TGData",$_REQUEST) ? $_REQUEST["TGData"] : "";
if ($XML) { 
   if(get_magic_quotes_gpc()) $XML = stripslashes($XML);
   $LastCount = 0;
      
   // --- simple xml or php xml --- 
   $SXML = is_callable(simplexml_load_string);
   if(!$SXML) require_once("Xml.php");
   if($SXML){ 
      $Xml = simplexml_load_string(html_entity_decode($XML));
      $Xml = $Xml->Changes->I;
      }
   else { 
      $Xml = CreateXmlFromString(html_entity_decode($XML));
      $Xml = $Xml->getElementsByTagName("I");
      }
   foreach($Xml as $I){
      $A = $SXML ? $I->attributes() : $I->attributes;
      // --- end of simple xml or php xml --- 
      
      $id = $A["id"];
      $prj = strtok($id,"\$");
      $res = strtok("\$");
      
      // --- Project row ---
      if(!$res){
         $prj = "'" . str_replace("'","''",$prj) . "'";
         $where = " WHERE Project=" . $prj . " ";
         if($A["Deleted"]){
            $db->Exec("DELETE FROM TableData" . $where);
            }
         else if($A["Added"] || $A["Changed"]){
            $res = $A["Project"];                  // Changed resource name
            if($res!=NULL) {
               $res = "'" . str_replace("'","''",$res) . "'";
               $Last[$LastCount++] = "UPDATE TableData SET Project=" . $res . $where;
               }
            }
         }
      
      // --- Resource row ---
      else {
         $prj = "'" . str_replace("'","''",$prj) . "'";
         $res = "'" . str_replace("'","''",$res) . "'";
         $where = " WHERE Project=" . $prj . " AND Resource=" . $res . " ";
         if($A["Deleted"]){
            $db->Exec("DELETE FROM TableData" . $where);
            }
         else if($A["Added"] || $A["Changed"]){
            foreach($A as $name => $value){
               if($name[0]=="W"){                      // Hours number
                  $week = substr($name,1);
                  $rs = $db->Query("SELECT ID FROM TableData" . $where . " AND Week=" . $week);
                  if(!$rs->GetRowCount()){        // New item
                     $rs = $db->Query("SELECT MAX(ID) FROM TableData");          //Creates new id, but better is to define Id in database as incremental
                     $db->Exec("INSERT INTO TableData(ID,Project,Resource,Week,Hours) VALUES (" . ($rs->Get(0)+1) . "," . $prj . "," . $res . "," . $week . "," . $value . ")");
                     }     
                  else {                        // Existing item
                     $db->Exec("UPDATE TableData SET Hours=" . $value . $where . " AND Week=" . $week);
                     }
                  }
               }               
            $res = $A["Project"];                         // Changed resource name
            if($res!=NULL) {
               $res = "'" . str_replace(",","''",$res) . "'";
               $db->Exec("UPDATE TableData SET Resource=" . $res . $where);
               }
            }
         else if($A["Moved"]==2){
            $db->Exec ("UPDATE TableData SET Project='" . str_replace("'","''",$A["Parent"]) . "'" . $where);
            }
         }         
      }
   // --- Delayed changing project names ---'
   // It must be done after changing all resources for the project
   for($i=0;$i<$LastCount;$i++) $db->Exec($Last[$i]);
   }
echo "<Grid><IO Result='0'/></Grid>";

// --------------------------------------------------------------------------
?>