/* 1403, Fri 16 Oct 92

   SNMPD.C:  The AU accounting meter mainline;
		based on CMU's snmpd,
		PCIP's packet monitoring
		and Waterloo's TCP/IP.

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

/*
 * snmpd.c - send snmp GET requests to a network entity.
 *
 */
/***********************************************************
	Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include "ausnmp.h"
#define PKTSNAP
#include "pktsnap.h"
#include "flowtree.h"

extern char version_descr[];

#include <dos.h>
#include <alloc.h>
#include <ctype.h>

#include <sys/types.h>
/* #include <netinet/in.h> AU */
#include <stdio.h>
/* #include <sys/socket.h>  AU */
#include "tcp.h"

#include <errno.h>

#include "snmp.h"
#include "snmpimpl.h"  /* AU */
#include "asn1.h"

extern int errno;
int snmp_dump_packet = 0;

udp_Socket udpsock;
static udp_Socket *s;
int status;  /* For socket */

void init_snmp();
void receive();
void snmp_read();

void pkt_rcv_call2(handle, len, buffp)
unsigned int handle, len;
unsigned char far *buffp;
{
   unsigned char *buff = buffp;  /* TCP's buffers are in our data segment! */
   struct pkt far *pp;

   if (buff[0] == 0xFF && buff[1] == 0xFF && buff[2] == 0xFF &&
	 buff[3] == 0xFF && buff[4] == 0xFF && buff[5] == 0xFF) {
      if (buff[12] == 0x08 &&
	    (buff[13] == 0x00 || buff[13] == 0x06 )) {  /* IP or ARP */
	 buff[-2] = 1;  /* Ready for tcp/ip */
	 }
      else buff[-2] = 0;  /* Not for us; free the buffer */
      }
   else if (buff[5] == eth_addr[5] && buff[4] == eth_addr[4] &&
	 buff[3] == eth_addr[3] && buff[2] == eth_addr[2] &&
	 buff[1] == eth_addr[1] && buff[0] == eth_addr[0]) {
      if (buff[12] == 0x08 &&
	    (buff[13] == 0x00 || buff[13] == 0x06 )) {  /* IP or ARP */
	 buff[-2] = 1;  /* Ready for tcp/ip */
	 }
      else buff[-2] = 0;  /* Not for us; free the buffer */
      }
   else buff[-2] = 0;  /* Not for us; free the buffer */

   ++npackets;  nbytes += len;
   if(((pproc - prcv) & PKTMASK) == 1) {  /* No pkts free, ignore the data */
      ++lostpackets;
      }
   else {
      pp = &pkts[prcv];
      if (buff[12] == 0x08 && buff[13] == 0x00) pp->p_type = AT_IP;
      else if (buff[12] <= MAXPKTLEN/256) {  /* 802.3 */
	 if (buff[14] == 0xFF && buff[15] == 0xFF) pp->p_type = AT_NOVELL;
#ifdef APPLETALK
	 else if (buff[14] == 0xAA && buff[15] == 0xAA) {  /* SNAP */
	    if (buff[20] == 0x80 && buff[21] == 0x9B) pp->p_type = AT_ETHERTALK;
	    else return;
	    }
#else
	 else return;
#endif
	 }
      else if (buff[12] == 0x60 && buff[13] == 0x03) pp->p_type = AT_DECNET;
      else return;
      pp->p_len = len;
      qmove(&buffp[SNAPFROM], pp->p_data, SNAPLEN);
      prcv = (prcv+1) & PKTMASK;
      }
   }

void main(argc, argv)
    int	    argc;
    char    *argv[];
{
    int	arg;
    char cbuf[20];

   sclear();
   scpos(0,0);
   printf("Nevil's PC Accounting Meter");

   for(arg = 1; arg < argc; arg++){
      if (argv[arg][0] == '-') {
	 switch (argv[arg][1]) {
	 case 'd':
	    snmp_dump_packet++;
	    break;
	 case 'k':
	    kb_enabled = 1;
	    break;
	 default:
	    printf("invalid option: -%c\n", argv[arg][1]);
	    break;
	    }
	 }
      }

   pkts = (struct pkt far *)farmalloc(MAXPKT * sizeof(struct pkt));
   au_monitor = 1;

   sock_init();
   scpos(0,1);
   printf("Running on %s",inet_ntoa(cbuf,gethostid()));

   s = &udpsock;  /* myport        hisadr hisport */
   if (!udp_open( s, SNMP_PORT,  0, 0,        0 )) {
      puts("udp_open failed!\n");
      exit(1);
      }

   init_snmp();
   init_monitor();
   receive();
   }

int pkt_backlog;
long spackets,sbytes;

int mxmonpkts = 500;  /* Max nbr of packets per pkt_monitor call */

void receive()
{
   int startup, ch,n, x, sumx, minx, maxx, samples;
   long pd, bd;
   long tot = set_timeout(1);
   struct pkt far *pkp;
   int k;

   startup = 1;
   pproc = prcv;  /* Discard packets collected during initialisation */
   for (;;) {
      sock_tick(s, &status);
      if ((n = sock_dataready(s)) != 0) {
         snmp_read(n);
         sock_close(s);
         if (!udp_open( s, SNMP_PORT,  0, 0,        0 )) {
            puts("udp_open failed!\n");
            exit(1);
            }
	 }

      k = (prcv-pproc) & PKTMASK;
      if (k > pkt_backlog) pkt_backlog = k;
      for (k = mxmonpkts; pproc != prcv && k != 0; --k) {
	 pkp = &pkts[pproc];
	 pkt_monitor(pkp->p_data, pkp->p_len, pkp->p_type);
	 pproc = (pproc+1) & PKTMASK;
	 }

      if (chk_timeout(tot)) {
	 tot = set_timeout(1);  /* 1 second */
	 ++elapsed_sec;  set_tod();

	 if (startup) {
	    badpackets = nobufpackets = lostpackets = 0;
	    minx = 100;  sumx = samples = maxx = 0;
	    startup = 0;
	    }
	 else {
	    scpos(0,3);
	    printf("q=%4d",pkt_backlog);
	    scpos(23,3);
	    printf("%02d%02d:%02d", tod_h,tod_m,tod_s);
	    scpos(0,5);
	    pd = npackets-spackets;  bd = nbytes-sbytes;
	    x = util_pc(pd,bd);  /* % utilisation */
	    printf("p=%6lu, b=%10lu, u=%4d", pd,bd, x);
	    sumx += x;  ++samples;
	    if (x < minx) minx = x;
	    if (x > maxx) maxx = x;
	    if (tod_s != s_tod_s && tod_s%10 == 0) {
	       if (samples)  /* 30% in col 79 */
		  chart(41,0, 79,24, minx,(sumx+(samples>>1))/samples,maxx);
	       minx = 100;  sumx = samples = maxx = 0;
	       }
	    }
	 pkt_backlog = 0;
	 spackets = npackets;  sbytes = nbytes;

         if (kbhit()) {
	    if ((ch = getch()) == 27 && kb_enabled) {  /* ESC */
	       scpos(0,24);
	       printf("Shutting down\n");
               exit(0);
               }
	    w_clear(0,24, 40,24);  scpos(0,24);
	    switch (tolower(ch)) {
	    case '+':
	       mxmonpkts += 50;
	       printf("mxmonpkts = %d", mxmonpkts);
	       break;
	    case '-':
	       mxmonpkts -= 50;
	       printf("mxmonpkts = %d", mxmonpkts);
	       break;
	    case 'b':
	       printf("bad=%lu, nobuf=%lu, lost=%lu",
		  badpackets,nobufpackets,lostpackets);
	       break;
	    case 'm':
	       printf("%u near, %lu far bytes free",
		  coreleft(),farcoreleft());
	       break;
	    case 'v':
	       printf("Version %s", version_descr);
	       break;
	    default:
	       handle_kb(ch);
	       break;
	       }
            }
         }
      }

sock_err:
   switch (status) {
   case 1 : /* foreign host closed */
      exit(0);
   case -1: /* timeout */
      printf("\nConnection timed out!");
      exit(1);
   default: printf("Aborting");
      exit(1);
      }
}

char snmp_peer[30];  /* name of host which sent the snmp request */

void snmp_read(length)
int length;
{
   int out_length;
   u_char  packet[1500], outpacket[1500];
   int count;
   struct sockaddr from;
   int fromlen = sizeof(struct sockaddr);
   getpeername(s, &from,&fromlen);
   inet_ntoa(snmp_peer,from.s_ip);
   
   sock_read(s, packet,length);

   if (snmp_dump_packet) {
      printf("received %d bytes from %s:\n", length, snmp_peer);
      for (count = 0; count < length; count++) {
	 printf("%02X ", packet[count]);
	 if ((count % 16) == 15) printf("\n");
	 }
      printf("\n\n");
      }
   out_length = 1500;
   if (snmp_agent_parse(packet, length, outpacket, &out_length, from.s_ip)) {
      if (snmp_dump_packet) {
	 printf("sent %d bytes to %s:\n", out_length, snmp_peer);
	 for (count = 0; count < out_length; count++) {
	    printf("%02X ", outpacket[count]);
	    if ((count % 16) == 15) printf("\n");
	    }
         printf("\n\n");
	 }
      sock_write( s, (char *)outpacket, out_length);
      }
   }

