.NH 1
IMPROVING SECURITY
.PP
.SM UNIX
system security can be divided into three main areas of concern.
Two of these areas,
account security and network security,
are primarily concerned with keeping unauthorized users from gaining access
to the system.
The third area,
file system security,
is concerned with preventing unauthorized access,
either by legitimate users or crackers,
to the data stored in the system.
This section describes the
.SM UNIX
security tools provided to make each of these areas as secure as possible.
.NH 2
ACCOUNT SECURITY
.PP
One of the easiest ways for a cracker to get into a system is by breaking
into someone's account.
This is usually easy to do,
since many systems have old accounts whose users have left the organization,
accounts with easy-to-guess passwords,
and so on.
This section describes methods that can be used to avoid these problems.
.NH 3
Passwords
.PP
The password is the most vital part of
.SM UNIX
account security.
If a cracker can discover a user's password,
he can then log in to the system and operate with all the capabilities of
that user.
If the password obtained is that of the super-user,
the problem is more serious:
the cracker will have read and write access to every file on the system.
For this reason,
choosing secure passwords is extremely important.
.PP
The
.SM UNIX
.I passwd
program [Sun88a, 379] places very few restrictions on what may be used as a
password.
Generally,
it requires that passwords contain five or more lowercase letters,
or four characters if a nonalphabetic or uppercase letter is included.
However,
if the user ``insists'' that a shorter password be used (by entering it
three times),
the program will allow it.
No checks for obviously insecure passwords (see below) are performed.
Thus,
it is incumbent upon the system administrator to ensure that the passwords
in use on the system are secure.
.PP
In [Morr78],
the authors describe experiments conducted to determine typical users'
habits in the choice of passwords.
In a collection of 3,289 passwords,
16% of them contained three characters or less,
and an astonishing 86% were what could generally be described as insecure.
Additional experiments in [Gram84] show that by trying three simple
guesses on each account \-
the login name,
the login name in reverse,
and the two concatenated together \-
a cracker can expect to obtain access to between 8 and 30 percent of the
accounts on a typical system.
A second experiment showed that by trying the 20 most common female first
names,
followed by a single digit (a total of 200 passwords),
at least one password was valid on each of several dozen machines surveyed.
Further experimentation by the author has found that by trying variations on
the login name,
user's first and last names,
and a list of nearly 1800 common first names,
up to 50  percent of the passwords on any given system can be cracked in
a matter of two or three days.
.NH 4
Selecting Passwords
.PP
The object when choosing a password is to make it as difficult as possible
for a cracker to make educated guesses about what you've chosen.
This leaves him no alternative but a brute-force search,
trying every possible combination of letters, numbers, and punctuation.
A search of this sort,
even conducted on a machine that could try one million passwords per
second (most machines can try less than one hundred per second),
would require,
on the average,
over one hundred years to complete.
With this as our goal,
and by using the information in the preceding text,
a set of guidelines for password selection can be constructed:
.RS
.IP \(bu
.B Don't
use your login name in any form
(as-is,
reversed,
capitalized,
doubled,
etc.).
.IP \(bu
.B Don't
use your first or last name in any form.
.IP \(bu
.B Don't
use your spouse's or child's name.
.IP \(bu
.B Don't
use other information easily obtained about you.
This includes license plate numbers,
telephone numbers,
social security numbers,
the brand of your automobile,
the name of the street you live on,
etc.
.IP \(bu
.B Don't
use a password of all digits,
or all the same letter.
This significantly decreases the search time for a cracker.
.IP \(bu
.B Don't
use a word contained in (English or foreign language) dictionaries,
spelling lists,
or other lists of words.
.IP \(bu
.B Don't
use a password shorter than six characters.
.IP \(bu
.B Do
use a password with mixed-case alphabetics.
.IP \(bu
.B Do
use a password with nonalphabetic characters,
e.g., digits or punctuation.
.IP \(bu
.B Do
use a password that is easy to remember,
so you don't have to write it down.
.IP \(bu
.B Do
use a password that you can type quickly,
without having to look at the keyboard.
This makes it harder for someone to steal your password by watching
over your shoulder.
.RE
.PP
Although this list may seem to restrict passwords to an extreme,
there are several methods for choosing secure,
easy-to-remember passwords that obey the above rules.
Some of these include the following:
.RS
.IP \(bu
Choose a line or two from a song or poem,
and use the first letter of each word.
For example,
``In Xanadu did Kubla Kahn a stately pleasure dome decree'' becomes
``IXdKKaspdd.''
.IP \(bu
Alternate between one consonant and one or two vowels,
up to eight characters.
This provides nonsense words that are usually pronounceable,
and thus easily remembered.
Examples include ``routboo,''
``quadpop,''
and so on.
.IP \(bu
Choose two short words and concatenate them together with a punctation
character between them.
For example: ``dog;rain,''
``book+mug,''
``kid?goat.''
.RE
.PP
The importance of obeying these password selection rules cannot be
overemphasized.
The Internet worm,
as part of its strategy for breaking into new machines,
attempted to crack user passwords.
First,
the worm tried simple choices such as the login name,
user's first and last names,
and so on.
Next,
the worm tried each word present in an internal dictionary of 432 words
(presumably Morris considered these words to be ``good'' words to try).
If all else failed,
the worm tried going through the system dictionary,
.I /usr/dict/words ,
trying each word [Spaf88].
The password selection rules above successfully guard against all three of
these strategies.
.NH 4
Password Policies
.PP
Although asking users to select secure passwords will help improve security,
by itself it is not enough.
It is also important to form a set of password policies that all users
must obey,
in order to keep the passwords secure.
.PP
First and foremost,
it is important to impress on users the need to keep their passwords in
their minds only.
Passwords should never be written down on desk blotters,
calendars,
and the like.
Further,
storing passwords in files on the computer must be prohibited.
In either case,
by writing the password down on a piece of paper or storing it in a file,
the security of the user's account is totally dependent on the security
of the paper or file,
which is usually less than the security offered by the password encryption
software.
.PP
A second important policy is that users must never give out their passwords
to others.
Many times,
a user feels that it is easier to give someone else his password in order
to copy a file,
rather than to set up the permissions on the file so that it can be
copied.
Unfortunately,
by giving out the password to another person,
the user is placing his trust in this other person not to distribute the
password further,
write it down,
and so on.
.PP
Finally,
it is important to establish a policy that users must change their passwords
from time to time,
say twice a year.
This is difficult to enforce on
.SM UNIX ,
since in most implementations,
a password-expiration scheme is not available.
However,
there are ways to implement this policy,
either by using third-party software or by sending a memo to the users
requesting that they change their passwords.
.PP
This set of policies should be printed and distributed to all current users
of the system.
It should also be given to all new users when they receive their accounts.
The policy usually carries more weight if you can get it signed by the
most ``impressive'' person in your organization (e.g., the president of
the company).
.NH 4
Checking Password Security
.PP
The procedures and policies described in the previous sections,
when properly implemented,
will greatly reduce the chances of a cracker breaking into your system
via a stolen account.
However,
as with all security measures,
you as the system administrator must periodically check to be sure that
the policies and procedures are being adhered to.
One of the unfortunate truisms of password security is that,
``left to their own ways,
some people will still use cute doggie names as passwords'' [Gram84].
.PP
The best way to check the security of the passwords on your system is to use
a password-cracking program much like a real cracker would use.
If you succeed in cracking any passwords,
those passwords should be changed immediately.
There are a few freely available password cracking programs distributed
via various source archive sites;
these are described in more detail in Section 4.
A fairly extensive cracking program is also available from the author.
Alternatively,
you can write your own cracking program,
and tailor it to your own site.
For a list of things to check for,
see the list of guidelines above.
.NH 3
Expiration Dates
.PP
Many sites,
particularly those with a large number of users,
typically have several old accounts lying around whose owners have since
left the organization.
These accounts are a major security hole:
not only can they be broken into if the password is insecure,
but because nobody is using the account anymore,
it is unlikely that a break-in will be noticed.
.PP
The simplest way to prevent unused accounts from accumulating is to place
an expiration date on every account.
These expiration dates should be near enough in the future that old
accounts will be deleted in a timely manner,
yet far enough apart that the users will not become annoyed.
A good figure is usually one year from the date the account was installed.
This tends to spread the expirations out over the year,
rather than clustering them all at the beginning or end.
The expiration date can easily be stored in the password file (in the
full name field).
A simple shell script can be used to periodically check that all accounts
have expiration dates,
and that none of the dates has passed.
.PP
On the first day of each month,
any user whose account has expired should be contacted to be sure he
is still employed by the organization,
and that he is actively using the account.
Any user who cannot be contacted,
or who has not used his account recently,
should be deleted from the system.
If a user is unavailable for some reason (e.g., on vacation) and cannot
be contacted,
his account should be disabled by replacing the encrypted password in the
password file entry with an asterisk (*).
This makes it impossible to log in to the account,
yet leaves the account available to be re-enabled on the user's return.
.NH 3
Guest Accounts
.PP
Guest accounts present still another security hole.
By their nature,
these accounts are rarely used,
and are always used by people who should only have access to the machine
for the short period of time they are guests.
The most secure way to handle guest accounts is to install them on an
as-needed basis,
and delete them as soon as the people using them leave.
Guest accounts should never be given simple passwords such as ``guest''
or ``visitor,'' and should never be allowed to remain in the password file
when they are not being used.
.NH 3
Accounts Without Passwords
.PP
Some sites have installed accounts with names such as ``who,''
``date,''
``lpq,''
and so on that execute simple commands.
These accounts are intended to allow users to execute these commands without
having to log in to the machine.
Typically these accounts have no password associated with them,
and can thus be used by anyone.
Many of the accounts are given a user id of zero,
so that they execute with super-user permissions.
.PP
The problem with these accounts is that they open potential security holes.
By not having passwords on them,
and by having super-user permissions,
these accounts practically invite crackers to try to penetrate them.
Usually,
if the cracker can gain access to the system,
penetrating these accounts is simple,
because each account executes a different command.
If the cracker can replace any one of these commands with one of his own,
he can then use the unprotected account to execute his program with
super-user permissions.
.PP
Simply put,
accounts without passwords should not be allowed on any
.SM UNIX
system.
.NH 3
Group Accounts and Groups
.PP
Group accounts have become popular at many sites,
but are actually a break-in waiting to happen.
A group account is a single account shared by several people,
e.g., by all the collaborators on a project.
As mentioned in the section on password security,
users should not share passwords \-
the group account concept directly violates this policy.
The proper way to allow users to share information,
rather than giving them a group account to use,
is to place these users into a group.
This is done by editing the group file,
.I /etc/group
[Sun88a, 1390; Sun88b, 66],
and creating a new group with the users who wish to collaborate listed
as members.
.PP
A line in the group file looks like
.DS
.ft C
groupname:password:groupid:user1,user2,user3,...
.ft R
.DE
The
.I groupname
is the name assigned to the group,
much like a login name.
It may be the same as someone's login name,
or different.
The maximum length of a group name is eight characters.
The password field is unused in
.SM BSD -derived
versions of
.SM UNIX ,
and should contain an asterisk (*).
The
.I groupid
is a number from 0 to 65535 inclusive.
Generally,
numbers below 10 are reserved for special purposes,
but you may choose any unused number.
The last field is a comma-separated (no spaces) list of the login names of the
users in the group.
If no login names are listed,
then the group has no members.
To create a group called ``hackers'' with Huey,
Duey,
and Louie as members,
you would add a line such as this to the group file:
.DS
.ft C
hackers:*:100:huey,duey,louie
.ft R
.DE
.PP
After the group has been created,
the files and directories the members wish to share can then be changed
so that they are owned by this group,
and the group permission bits on the files and directories can be set to
allow sharing.
Each user retains his own account,
with his own password,
thus protecting the security of the system.
.PP
For example,
to change Huey's ``programs'' directory to be owned by the new group and
properly set up the permissions so that all members of the group may
access it,
the
.I chgrp
and
.I chmod
commands would be used as follows [Sun88a, 63-66]:
.DS
.ft C
# \f(CBchgrp hackers ~huey/programs\fP
# \f(CBchmod -R g+rw ~huey/programs\fP
.ft R
.DE
.NH 3
Yellow Pages
.PP
The Sun Yellow Pages system [Sun88b, 349-374] allows many hosts
to share password files,
group files,
and other files via the network,
while the files are stored on only a single host.
Unfortunately,
Yellow Pages also contains a few potential security holes.
.PP
The principal way Yellow Pages works is to have a special line in the
password or group file that begins with a ``+''.
In the password file,
this line looks like
.DS
.ft C
+::0:0:::
.ft R
.DE
and in the group file,
it looks like
.DS
.ft C
+:
.DE
These lines should only be present in the files stored on Yellow Pages
client machines.
They should not be present in the files on the Yellow Pages master machine(s).
When a program reads the password or group file and encounters one of these
lines,
it goes through the network and requests the information it wants from the
Yellow Pages server instead of trying to find it in the local file.
In this way,
the data does not have to be maintained on every host.
Since the master machine already has all the information,
there is no need for this special line to be present there.
.PP
Generally speaking,
the Yellow Pages service itself is reasonably secure.
There are a few openings that a sophisticated (and dedicated) cracker
could exploit,
but Sun is rapidly closing these.
The biggest problem with Yellow Pages is the ``+'' line in the password
file.
If the ``+'' is deleted from the front of the line,
then this line loses its special Yellow Pages meaning.
It instead becomes a regular password file line for an account with a
null login name,
no password,
and user id zero (super-user).
Thus,
if a careless system administrator accidentally deletes the ``+''.
the whole system is wide open to any attack.*
.FS *
Actually,
a line like this without a ``+'' is dangerous in any password file,
regardless of whether Yellow Pages is in use.
.FE
.PP
Yellow Pages is too useful a service to suggest turning it off,
although turning it off would make your system more secure.
Instead,
it is recommended that you read carefully the information in the Sun
manuals in order to be fully aware of Yellow Pages' abilities and
its limitations.
.NH 2
NETWORK SECURITY
.PP
As trends toward internetworking continue,
most sites will,
if they haven't already,
connect themselves to one of the numerous regional networks springing up
around the country.
Most of these regional networks are also interconnected,
forming the Internet [Hind83, Quar86].
This means that the users of your machine can access other hosts and
communicate with other users around the world.
Unfortunately,
it also means that other hosts and users from around the world can access
your machine,
and attempt to break into it.
.PP
Before internetworking became commonplace,
protecting a system from unauthorized access simply meant locking the
machine in a room by itself.
Now that machines are connected by networks,
however,
security is much more complex.
This section describes the tools and methods available to make your
.SM UNIX
networks as secure as possible.
.NH 3
Trusted Hosts
.PP
One of the most convenient features of the Berkeley (and Sun)
.SM UNIX
networking software is the concept of ``trusted'' hosts.
The software allows the specification of other hosts (and possibly users)
who are to be considered trusted \- remote logins and remote command
executions from these hosts will be permitted without requiring the user
to enter a password.
This is very convenient,
because users do not have to type their password every time they use the
network.
Unfortunately,
for the same reason,
the concept of a trusted host is also extremely insecure.
.PP
The Internet worm made extensive use of the trusted host concept to spread
itself throughout the network [Seel88].
Many sites that had already disallowed trusted hosts did
fairly well against the worm compared with those sites that did allow
trusted hosts.
Even though it is a security hole,
there are some valid uses for the trusted host concept.
This section describes how to properly implement the trusted hosts
facility while preserving as much security as possible.
.NH 4
The hosts.equiv File
.PP
The file
.I /etc/hosts.equiv
[Sun88a, 1397] can be used by the system administrator to indicate
trusted hosts.
Each trusted host is listed in the file,
one host per line.
If a user attempts to log in (using
.I rlogin )
or execute a command (using
.I rsh )
remotely from one of the systems listed in
.I hosts.equiv ,
and that user has an account on the local system with the same login name,
access is permitted without requiring a password.
.PP
Provided adequate care is taken to allow only local hosts in the
.I hosts.equiv
file,
a reasonable compromise between security and convenience can be achieved.
Nonlocal hosts (including hosts at remote sites of the same organization)
should never be trusted.
Also,
if there are any machines at your organization that are installed in
``public'' areas (e.g., terminal rooms) as opposed to private offices,
you should not trust these hosts.
.PP
On Sun systems,
.I hosts.equiv
is controlled with the Yellow Pages software.
As distributed,
the default
.I hosts.equiv
file distributed by Sun contains a single line:
.DS
.ft C
+
.ft R
.DE
This indicates that
.I "every known host"
(i.e., the complete contents of the host file) should be considered a trusted
host.
This is totally incorrect and a major security hole,
since hosts outside the local organization should never be trusted.
A correctly configured
.I hosts.equiv
should never list any ``wildcard'' hosts (such as the ``+'');
only specific host names should be used.
When installing a new system from Sun distribution tapes,
you should be sure to either replace the Sun default
.I hosts.equiv
with a correctly configured one,
or delete the file altogether.
.NH 4
The \&.rhosts File
.PP
The
.I \&.rhosts
file [Sun88a, 1397] is similar in concept and format to the
.I hosts.equiv
file,
but allows trusted access only to specific host-user combinations,
rather than to hosts in general.*
.FS *
Actually,
.I hosts.equiv
may be used to specify host-user combinations as well,
but this is rarely done.
.FE
Each user may create a
.I \&.rhosts
file in his home directory,
and allow access to her account without a password.
Most people use this mechanism to allow trusted access between accounts they
have on systems owned by different organizations who do not trust each
other's hosts in
.I hosts.equiv.
Unfortunately,
this file presents a major security problem:
While
.I hosts.equiv
is under the system administrator's control and can be managed effectively,
any user may create a
.I \&.rhosts
file granting access to whomever he chooses,
without the system administrator's knowledge.
.PP
The only secure way to manage
.I \&.rhosts
files is to completely disallow them on the system.
The system administrator should check the system often for violations of this
policy (see Section 3.3.1.4).
One possible exception to this rule is the ``root'' account;
a
.I \&.rhosts
file may be necessary to allow network backups and the like to be completed.
.NH 3
Secure Terminals
.PP
Under newer versions of
.SM UNIX ,
the concept of a ``secure'' terminal has been introduced.
Simply put,
the super-user (``root'') may not log in on a nonsecure terminal,
even with a password.
(Authorized users may still use the
.I su
command to become super-user,
however.)
The file
.I /etc/ttytab
[Sun88a, 1478] is used to control which terminals are considered secure.\(dg
.FS \(dg
Under non-Sun versions of Berkeley
.SM UNIX ,
this file is called
.I /etc/ttys .
.FE
A short excerpt from this file is shown below.
.DS
.ft C
console  "/usr/etc/getty std.9600"  sun      off secure
ttya     "/usr/etc/getty std.9600"  unknown  off secure
ttyb     "/usr/etc/getty std.9600"  unknown  off secure
ttyp0    none                       network  off secure
ttyp1    none                       network  off secure
ttyp2    none                       network  off secure
.ft R
.DE
The keyword ``secure'' at the end of each line indicates that the terminal
is considered secure.
To remove this designation,
simply edit the file and delete the ``secure'' keyword.
After saving the file,
type the command (as super-user):
.DS
.ft C
# \f(CBkill -HUP 1\fP
.ft R
.DE
This tells the
.I init
process to reread the
.I ttytab
file.
.PP
The Sun default configuration for
.I ttytab
is to consider all terminals secure,
including ``pseudo'' terminals used by the remote login software.
This means that ``root'' may log in remotely from any host on the network.
A more secure configuration would consider as secure only directly
connected terminals,
or perhaps only the console device.
This is how file servers and other machines with disks should be set up.
.PP
The most secure configuration is to remove the ``secure'' designation
from all terminals,
including the console device.
This requires that those users with super-user authority first log in
as themselves,
and then become the super-user via the
.I su
command.
It also requires the ``root'' password to be entered when rebooting in
single-user mode,
in order to prevent users from rebooting their desktop workstations and
obtaining super-user access.
This is how all diskless client machines should be set up.
.NH 3
The Network File System
.PP
The Network File System
.SM NFS ) (
[Sun88d] is designed to allow several hosts to share files over the network.
One of the most common uses of
.SM NFS
is to allow diskless workstations to be installed in offices,
while keeping all disk storage in a central location.
As distributed by Sun,
.SM NFS
has no security features enabled.
This means that any host on the Internet may access your files via
.SM NFS ,
regardless of whether you trust them or not.
.PP
Fortunately,
there are several easy ways to make
.SM NFS
more secure.
The more commonly used methods are described in this section,
and these can be used to make your files quite secure from unauthorized
access via
.SM NFS .
Secure
.SM NFS ,
introduced in
.SM OS "" Sun
Release 4.0,
takes security one step further,
using public-key encryption techniques to ensure authorized
access.
Discussion of secure
.SM NFS
is deferred until Section 4.
.NH 4
The exports File
.PP
The file
.I /etc/exports
[Sun88a, 1377] is perhaps one of the most important parts of
.SM NFS
configuration.
This file lists which file systems are exported (made available for mounting)
to other systems.
A typical
.I exports
file as installed by the Sun installation procedure looks something like this:
.DS
.ft C
/usr
/home
/var/spool/mail
#
/export/root/client1    -access=client1,root=client1
/export/swap/client1    -access=client1,root=client1
#
/export/root/client2    -access=client2,root=client2
/export/swap/client2    -access=client2,root=client2
.ft R
.DE
The
.I root=
keyword specifies the list of hosts that are allowed to have super-user
access to the files in the named file system.
This keyword is discussed in detail in Section 2.2.3.3.
The
.I access=
keyword specifies the list of hosts (separated by colons) that are allowed
to mount the named file system.
If no
.I access=
keyword is specified for a file system,
any host anywhere on the network may mount that file system via
.SM NFS .
.PP
Obviously,
this presents a major security problem,
since anyone who can mount your file systems via
.SM NFS
can then peruse them at her leisure.
Thus,
it is important that all file systems listed in
.I exports
have an
.I access=
keyword associated with them.
If you have only a few hosts which must mount a file system,
you can list them individually in the file:
.DS
.ft C
/usr    -access=host1:host2:host3:host4:host5
.ft R
.DE
However,
because the maximum number of hosts that can be listed this way is ten,
the
.I access=
keyword will also allow netgroups to be specified.
Netgroups are described in the next section.
.PP
After making any changes to the
.I exports
file,
you should run the command
.DS
.ft C
# \f(CBexportfs -a\fP
.ft R
.DE
in order to make the changes take effect.
.NH 4
The netgroup File
.PP
The file
.I /etc/netgroup
[Sun88a, 1407] is used to define netgroups.
This file is controlled by Yellow Pages,
and must be rebuilt in the Yellow Pages maps whenever it is modified.
Consider the following sample
.I netgroup
file:
.DS
.ft C
A_Group      (servera,,) (clienta1,,) (clienta2,,)

B_Group      (serverb,,) (clientb1,,) (clientb2,,)

AdminStaff   (clienta1,mary,) (clientb3,joan,)

AllSuns      A_Group B_Group
.ft R
.DE
This file defines four netgroups,
called
.I A_Group ,
.I B_Group ,
.I AdminStaff ,
and
.I AllSuns .
The
.I AllSuns
netgroup is actually a ``super group''
containing all the members of the
.I A_Group
and
.I B_Group
netgroups.
.PP
Each member of a netgroup is defined as a triple: (host, user, domain).
Typically,
the
.I domain
field is never used,
and is simply left blank.
If either the
.I host
or
.I user
field is left blank,
then any host or user is considered to match.
Thus the triple (host,,) matches any user on the named host,
while the triple (,user,) matches the named user on any host.
.PP
Netgroups are useful when restricting access to
.SM NFS
file systems via the
.I exports
file.
For example,
consider this modified version of the file from the previous section:
.DS
.ft C
/usr                    -access=A_Group
/home                   -access=A_Group:B_Group
/var/spool/mail         -access=AllSuns
#
/export/root/client1    -access=client1,root=client1
/export/swap/client1    -access=client1,root=client1
#
/export/root/client2    -access=client2,root=client2
/export/swap/client2    -access=client2,root=client2
.ft R
.DE
The
.I /usr
file system may now only be mounted by the hosts in the
.I A_Group
netgroup,
that is,
.I servera ,
.I clienta1 ,
and
.I clienta2 .
Any other host that tries to mount this file system will receive an ``access
denied'' error.
The
.I /home
file system may be mounted by any of the hosts in either the
.I A_Group
or
.I B_Group
netgroups.
The
.I /var/spool/mail
file system is also restricted to these hosts,
but in this example we used the ``super group'' called
.I AllSuns .
.PP
Generally,
the best way to configure the
.I netgroup
file is to make a single netgroup for each file server and its clients,
and then to make other super groups,
such as
.I AllSuns .
This allows you the flexibility to specify the smallest possible group of
hosts for each file system in
.I /etc/exports .
.PP
Netgroups can also be used in the password file to allow access to a
given host to be restricted to the members of that group,
and they can be used in the
.I hosts.equiv
file to centralize maintenance of the list of trusted hosts.
The procedures for doing this are defined in more detail in the Sun manual.
.NH 4
Restricting Super-User Access
.PP
Normally,
.SM NFS
translates the super-user id to a special id called ``nobody'' in order
to prevent a user with ``root'' on a remote workstation from accessing
other people's files.
This is good for security,
but sometimes a nuisance for system administration,
since you cannot make changes to files as ``root'' through
.SM NFS .
.PP
The
.I exports
file also allows you to grant super-user access to certain file systems
for certain hosts by using the
.I root=
keyword.
Following this keyword a colon-separated list of up to ten hosts may be
specified;
these hosts will be allowed to access the file system as ``root'' without
having the user id converted to ``nobody.''
Netgroups may not be specified to the
.I root=
keyword.
.PP
Granting ``root'' access to a host should not be
done lightly.
If a host has ``root'' access to a file system,
then the super-user on that host will have complete access to the file
system,
just as if you had given him the ``root'' password on the server.
Untrusted hosts should never be given ``root'' access to
.SM NFS
file systems.
.NH 3
FTP
.PP
The File Transfer Protocol,
implemented by the
.I ftp
and
.I ftpd
programs [Sun88a, 195-201, 1632-1634],
allows users to connect to remote
systems and transfer files back and forth.
Unfortunately,
older versions of these programs also had several bugs in them that
allowed crackers to break into a system.
These bugs have been fixed by Berkeley,
and new versions are available.
If your
.I ftpd *
.FS *
On Sun systems,
.I ftpd
is stored in the file
.I /usr/etc/in.ftpd .
On most other systems,
it is called
.I /etc/ftpd .
.FE
was obtained before December 1988,
you should get a newer version (see Section 4).
.PP
One of the more useful features of
.SM FTP
is the ``anonymous'' login.
This special login allows users who do not have an account on your machine
to have restricted access in order to transfer files from a specific
directory.
This is useful if you wish to distribute software to the public at large
without giving each person who wants the software an account on your machine.
In order to securely set up anonymous
.SM FTP
you should follow the specific instructions below:
.RS
.IP 1.
Create an account called ``ftp.''
Disable the account by placing an asterisk (*) in the password field.
Give the account a special home directory,
such as
.I /usr/ftp
or
.I /usr/spool/ftp .
.IP 2.
Make the home directory owned by ``ftp'' and unwritable by anyone:
.DS
.ft C
# \f(CBchown ftp ~ftp\fP
# \f(CBchmod 555 ~ftp\fP
.ft R
.DE
.IP 3.
Make the directory
.I ~ftp/bin ,
owned by the super-user and unwritable by anyone.
Place a copy of the
.I ls
program in this directory:
.DS
.ft C
# \f(CBmkdir ~ftp/bin\fP
# \f(CBchown root ~ftp/bin\fP
# \f(CBchmod 555 ~ftp/bin\fP
# \f(CBcp -p /bin/ls ~ftp/bin\fP
# \f(CBchmod 111 ~ftp/bin/ls\fP
.ft R
.DE
.IP 4.
Make the directory
.I ~ftp/etc ,
owned by the super-user and unwritable by anyone.
Place copies of the password and group files in this directory,
with all the password fields changed to asterisks (*).
You may wish to delete all but a few of the accounts and groups from these
files;
the only account that must be present is ``ftp.''
.DS
.ft C
# \f(CBmkdir ~ftp/etc\fP
# \f(CBchown root ~ftp/etc\fP
# \f(CBchmod 555 ~ftp/etc\fP
# \f(CBcp -p /etc/passwd /etc/group ~ftp/etc\fP
# \f(CBchmod 444 ~ftp/etc/passwd ~ftp/etc/group\fP
.ft R
.DE
.IP 5.
Make the directory
.I ~ftp/pub ,
owned by ``ftp'' and world-writable.
Users may then place files that are to be accessible via anonymous
.SM FTP
in this directory:
.DS
.ft C
# \f(CBmkdir ~ftp/pub\fP
# \f(CBchown ftp ~ftp/pub\fP
# \f(CBchmod 777 ~ftp/pub\fP
.ft R
.DE
.RE
.PP
Because the anonymous
.SM FTP
feature allows anyone to access your system (albeit in a very limited way),
it should not be made available on every host on the network.
Instead,
you should choose one machine (preferably a server or standalone host) on
which to allow this service.
This makes monitoring for security violations much easier.
If you allow people to transfer files to your machine (using the world-writable
.I pub
directory,
described above),
you should check often the contents of the directories into which they
are allowed to write.
Any suspicious files you find should be deleted.
.NH 4
Trivial FTP
.PP
The Trivial File Transfer Protocol,
.SM TFTP ,
is used on Sun workstations (and others) to allow diskless hosts to boot
from the network.
Basically,
.SM TFTP
is a stripped-down version of
.SM "FTP " \-
there is no user authentication,
and the connection is based on the User Datagram Protocol instead of the
Transmission Control Protocol.
Because they are so stripped-down,
many implementations of
.SM TFTP
have security holes.
You should check your hosts by executing the command sequence shown below.
.DS
.ft C
% \f(CBtftp\fP
tftp> \f(CBconnect\fP \fIyourhost\fP
tftp> \f(CBget /etc/motd tmp\fP
Error code 1: File not found
tftp> \f(CBquit\fP
%
.ft R
.DE
If your version does not respond with ``\fIFile not found\fP,''
and instead transfers the file,
you should replace your version of
.I tftpd *
.FS *
On Sun systems,
.I tftpd
is stored in the file
.I /usr/etc/in.tftpd .
On most other systems,
it is called
.I /etc/tftpd .
.FE
with a newer one.
In particular,
versions of
.SM OS "" Sun
prior to release 4.0 are known to have this problem.
.NH 3
Mail
.PP
Electronic mail is one of the main reasons for connecting to outside
networks.
On most versions of Berkeley-derived
.SM UNIX
systems,
including those from Sun,
the
.I sendmail
program [Sun88a, 1758-1760; Sun88b, 441-488] is used to enable the receipt
and delivery of mail.
As with the
.SM FTP
software,
older versions of
.I sendmail
have several bugs that allow security violations.
One of these bugs was used with great success by the Internet worm
[Seel88, Spaf88].
The current version of
.I sendmail
from Berkeley is version 5.61,
of January 1989.
Sun is,
as of this writing,
still shipping version 5.59,
which has a known security problem.
They have,
however,
made a fixed version available.
Section 4 details how to obtain these newer versions.
.PP
Generally,
with the exception of the security holes mentioned above,
.I sendmail
is reasonably secure when installed by most vendors' installation
procedures.
There are,
however,
a few precautions that should be taken to ensure secure operation:
.RS
.IP 1.
Remove the ``decode'' alias from the aliases file (\fI/etc/aliases\fP or
\fI/usr/lib/aliases\fP).
.IP 2.
If you create aliases that allow messages to be sent to programs,
be absolutely sure that there is no way to obtain a shell or send
commands to a shell from these programs.
.IP 3.
Make sure the ``wizard'' password is disabled in the configuration
file,
.I sendmail.cf .
(Unless you modify the distributed configuration files,
this shouldn't be a problem.)
.IP 4.
Make sure your
.I sendmail
does not support the ``debug'' command.
This can be done with the following commands:
.DS L
.ft C
% \f(CBtelnet localhost 25\fP
220 yourhost Sendmail 5.61 ready at 9 Mar 90 10:57:36 PST
\f(CBdebug\fP
500 Command unrecognized
\f(CBquit\fP
%
.ft R
.DE
.IP
If your
.I sendmail
responds to the ``debug'' command with ``\fI200 Debug set\fP,''
then you are vulnerable to attack and should replace your
.I sendmail
with a newer version.
.RE
.LP
By following the procedures above,
you can be sure that your mail system is secure.
.NH 3
Finger
.PP
The ``finger'' service,
provided by the
.I finger
program [Sun88a, 186-187],
allows you to obtain information about a user such as her full name,
home directory,
last login time,
and in some cases when she last received mail and/or read her mail.
The
.I fingerd
program [Sun88a, 1625]
allows users on remote hosts to obtain this information.
.PP
A bug in
.I fingerd
was also exercised with success by the Internet worm [Seel88, Spaf88].
If your version of
.I fingerd *
.FS *
On Sun systems,
.I fingerd
is stored in
.I /usr/etc/in.fingerd .
On most other systems,
it is called
.I /etc/fingerd .
.FE
is older than November 5, 1988,
it should be replaced with a newer version.
New versions are available from several of the sources described in
Section 4.
.NH 3
Modems and Terminal Servers
.PP
Modems and terminal servers (terminal switches,
Annex boxes,
etc.) present still another potential security problem.
The main problem with these devices is one of configuration \-
misconfigured hardware can allow security breaches.
Explaining how to configure every brand of modem and terminal server
would require volumes.
However,
the following items should be checked for on any modems or terminal servers
installed at your site:
.RS
.IP 1.
If a user dialed up to a modem hangs up the phone,
the system should log him out.
If it doesn't,
check the hardware connections and the kernel configuration of the serial
ports.
.IP 2.
If a user logs off,
the system should force the modem to hang up.
Again,
check the hardware connections if this doesn't work.
.IP 3.
If the connection from a terminal server to the system is broken,
the system should log the user off.
.IP 4.
If the terminal server is connected to modems,
and the user hangs up,
the terminal server should inform the system that the user has hung up.
.RE
.PP
Most modem and terminal server manuals cover in detail how to properly
connect these devices to your system.
In particular you should pay close attention to the ``Carrier Detect,''
``Clear to Send,''
and ``Request to Send'' connections.
.NH 3
Firewalls
.PP
One of the newer ideas in network security is that of a
.I firewall .
Basically,
a firewall is a special host that sits between your outside-world network
connection(s) and your internal network(s).
This host does not send out routing information about your internal network,
and thus the internal network is ``invisible'' from the outside.
In order to configure a firewall machine,
the following considerations need to be taken:
.RS
.IP 1.
The firewall does not advertise routes.
This means that users on the internal network must log in to the firewall
in order to access hosts on remote networks.
Likewise,
in order to log in to a host on the internal network from the outside,
a user must first log in to the firewall machine.
This is inconvenient,
but more secure.
.IP 2.
All electronic mail sent by your users must be forwarded to the firewall
machine if it is to be delivered outside your internal network.
The firewall must receive all incoming electronic mail,
and then redistribute it.
This can be done either with aliases for each user or by using name server
.SM MX
records.
.IP 3.
The firewall machine should not mount any file systems via
.SM NFS ,
or make any of its file systems available to be mounted.
.IP 4.
Password security on the firewall must be rigidly enforced.
.IP 5.
The firewall host should not trust any other hosts regardless of where they
are.
Furthermore,
the firewall should not be trusted by any other host.
.IP 6.
Anonymous
.SM FTP
and other similar services should only be provided by the firewall host,
if they are provided at all.
.RE
.PP
The purpose of the firewall is to prevent crackers from accessing other
hosts on your network.
This means,
in general,
that you must maintain strict and rigidly enforced security on the firewall,
but the other hosts are less vulnerable,
and hence security may be somewhat lax.
But it is important to remember that the firewall is not a complete cure
against crackers \- if a cracker can break into the firewall machine,
he can then try to break into any other host on your network.
.NH 2
FILE SYSTEM SECURITY
.PP
The last defense against system crackers are the permissions offered by
the file system.
Each file or directory has three sets of permission bits associated with it:
one set for the user who owns the file,
one set for the users in the group with which the file is associated,
and one set for all other users (the ``world'' permissions).
Each set contains three identical permission bits,
which control the following:
.RS
.IP \fIread\fP \w'executeXX'u
If set,
the file or directory may be read.
In the case of a directory,
read access allows a user to see the contents of a directory (the
names of the files contained therein),
but not to access them.
.IP \fIwrite\fP \w'executeXX'u
If set,
the file or directory may be written (modified).
In the case of a directory,
write permission implies the ability to create,
delete,
and rename files.
Note that the ability to remove a file is
.I not
controlled by the permissions on the file,
but rather the permissions on the directory containing the file.
.IP \fIexecute\fP \w'executeXX'u
If set,
the file or directory may be executed (searched).
In the case of a directory,
execute permission implies the ability to access files contained in
that directory.
.RE
.PP
In addition,
a fourth permission bit is available in each set of permissions.
This bit has a different meaning in each set of permission bits:
.RS
.IP \fIsetuid\fP \w'setuidXX'u
If set in the owner permissions,
this bit controls the ``set user id'' (setuid) status of a file.
Setuid status means that when a program is executed,
it executes with the permissions of the user owning the program,
in addition to the permissions of the user executing the program.
For example,
.I sendmail
is setuid ``root,''
allowing it to write files in the mail queue area,
which normal users are not allowed to do.
This bit is meaningless on nonexecutable files.
.IP \fIsetgid\fP \w'setuidXX'u
If set in the group permissions,
this bit controls the ``set group id'' (setgid) status of a file.
This behaves in exactly the same way as the setuid bit,
except that the group id is affected instead.
This bit is meaningless on non-executable files (but see below).
.IP \fIsticky\fP \w'setuidXX'u
If set in the world permissions,
the ``sticky'' bit tells the operating system to do special things
with the text image of an executable file.
It is mostly a holdover from older versions of
.SM UNIX ,
and has little if any use today.
This bit is also meaningless on nonexecutable files (but see below).
.RE
.in 0
.NH 3
Setuid Shell Scripts
.PP
Shell scripts that have the setuid or setgid bits set on them are
.I not
secure,
regardless of how many safeguards are taken when writing them.
There are numerous software packages available that claim to make shell
scripts secure,
but every one released so far has not managed to solve all the problems.
.PP
Setuid and setgid shell scripts should never be allowed on any
.SM UNIX
system.
.NH 3
The Sticky Bit on Directories
.PP
Newer versions of
.SM UNIX
have attached a new meaning to the sticky bit.
When this bit is set on a directory,
it means that users may not delete or rename other users' files in this
directory.
This is typically useful for the
.I /tmp
directory.
Normally,
.I /tmp
is world-writable,
enabling any user to delete another user's files.
By setting the sticky bit on
.I /tmp ,
users may only delete their own files from this directory.
.PP
To set the sticky bit on a directory,
use the command
.DS
.ft C
# \f(CBchmod o+t\fP \fIdirectory\fP
.ft R
.DE
.NH 3
The Setgid Bit on Directories
.PP
In
.SM OS "" Sun
4.0,
the setgid bit was also given a new meaning.
Two rules can be used for assigning group ownership to a file in
.SM OS : Sun
.RS
.IP 1.
The System V mechanism,
which says that a user's primary group id (the one listed in the password
file) is assigned to any file he creates.
.IP 2.
The Berkeley mechanism,
which says that the group id of a file is set to the group id of the
directory in which it is created.
.RE
.PP
If the setgid bit is set on a directory,
the Berkeley mechanism is enabled.
Otherwise,
the System V mechanism is enabled.
Normally,
the Berkeley mechanism is used;
this mechanism must be used if creating directories for use by more than
one member of a group (see Section 2.1.5).
.PP
To set the setgid bit on a directory,
use the command
.DS
.ft C
# \f(CBchmod g+s\fP \fIdirectory\fP
.ft R
.DE
.NH 3
The umask Value
.PP
When a file is created by a program,
say a text editor or a compiler,
it is typically created with all permissions enabled.
Since this is rarely desirable (you don't want other users to be able to
write your files),
the
.I umask
value is used to modify the set of permissions a file is created with.
Simply put,
while the
.I chmod
command [Sun88a, 65-66] specifies what bits should be turned
.I on ,
the umask value specifies what bits should be turned
.I off .
.PP
For example,
the default umask on most systems is 022.
This means that write permission for the group and world should be turned
off whenever a file is created.
If instead you wanted to turn off all group and world permission bits,
such that any file you created would not be readable,
writable,
or executable by anyone except yourself,
you would set your umask to 077.
.PP
The umask value is specified in the
.I \&.cshrc
or
.I \&.profile
files read by the shell using the
.I umask
command [Sun88a, 108, 459].
The ``root'' account should have the line
.DS
.ft C
umask 022
.ft R
.DE
in its
.I /.cshrc
file,
in order to prevent the accidental creation of world-writable files
owned by the super-user.
.NH 3
Encrypting Files
.PP
The standard
.SM UNIX
.I crypt
command [Sun88a, 95] is not at all secure.
Although it is reasonable to expect that
.I crypt
will keep the casual ``browser'' from reading a file,
it will present nothing more than a minor inconvenience to a determined
cracker.
.I Crypt
implements a one-rotor machine along the lines of the
German Enigma (broken in World War II).
The methods of attack on such a machine are well known,
and a sufficiently large file can usually be decrypted in a few hours
even without knowledge of what the file contains [Reed84].
In fact,
publicly available packages of programs designed to ``break'' files
encrypted with
.I crypt
have been around for several years.
.PP
There are software implementations of another algorithm,
the Data Encryption Standard
.SM DES ), (
available on some systems.
Although this algorithm is much more secure than
.I crypt ,
it has never been proven that it is totally secure,
and many doubts about its security have been raised in recent years.
.PP
Perhaps the best thing to say about encrypting files on a computer system
is this:
if you think you have a file whose contents are important enough to
encrypt,
then that file should not be stored on the computer in the first place.
This is especially true of systems with limited security,
such as
.SM UNIX
systems and personal computers.
.PP
It is important to note that
.SM UNIX
passwords are
.I not
encrypted with the
.I crypt
program.
Instead,
they are encrypted with a modified version of the
.SM DES
that generates one-way encryptions (that is,
the password cannot be decrypted).
When you log in,
the system does not decrypt your password.
Instead,
it encrypts your attempted password,
and if this comes out to the same result as encrypting your real password,
you are allowed to log in.
.NH 3
Devices
.PP
The security of devices is an important issue in
.SM UNIX .
Device files (usually residing in
.I /dev )
are used by various programs to access the data on the disk drives or in
memory.
If these device files are not properly protected,
your system is wide open to a cracker.
The entire list of devices is too long to go into here,
since it varies widely from system to system.
However,
the following guidelines apply to all systems:
.RS
.IP 1.
The files
.I /dev/kmem ,
.I /dev/mem ,
and
.I /dev/drum
should never be readable by the world.
If your system supports the notion of the ``kmem'' group (most newer
systems do) and utilities
such as
.I ps
are setgid ``kmem,''
then these files should be owned by user ``root'' and group ``kmem,''
and should be mode 640.
If your system does not support the notion of the ``kmem'' group,
and utilities such as
.I ps
are setuid ``root,''
then these files should be owned by user ``root'' and mode 600.
.IP 2.
The disk devices,
such as
.I /dev/sd0a ,
.I /dev/rxy1b ,
etc.,
should be owned by user ``root'' and group ``operator,''
and should be mode 640.
Note that each disk has eight partitions
and two device files for each partition.
Thus,
the disk ``sd0'' would have the following device files associated
with it in
.I /dev :
.DS
sd0a     sd0e     rsd0a     rsd0e
sd0b     sd0f     rsd0b     rsd0f
sd0c     sd0g     rsd0c     rsd0g
sd0d     sd0h     rsd0d     rsd0h
.DE
.IP 3.
With very few exceptions,
all other devices should be owned by user ``root.''
One exception is terminals,
which are changed to be owned by the user currently logged in on them.
When the user logs out,
the ownership of the terminal is automatically changed back to ``root.''
.RE
.NH 2
SECURITY IS YOUR RESPONSIBILITY
.PP
This section has detailed numerous tools for improving security provided
by the
.SM UNIX
operating system.
The most important thing to note about these tools is that although they
are available,
they are typically not put to use in most installations.
Therefore,
it is incumbent on you,
the system administrator,
to take the time and make the effort to enable these tools,
and thus to protect your system from unauthorized access.
