#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <pwd.h>
#include <sys/time.h>
#include <signal.h>
#include <netinet/in.h>
#include <netdb.h>

FILE	*Input, *Output;
int	Daemon = 0;
int	ReadOnly = 0;
int	TurnedOff = 0;
int	Initializing = 1;
int	Timeout = 0;
int	LockTimeout = 30;
int	DontLog = 0;

#ifdef RESTRICTED
int	OffCampus = 0;
#endif

#ifdef EMAIL_AUTH
struct hostent *TrustHp = NULL;
#endif

char	*DBState;

void	SetSignals();
void	cleanup __P((int));

/*
 * what am I talking to?
 */
int	InputType;
char	Foreign[80];

int 
qimain(argc, argv)
	int argc;
	char **argv;
{
	char	**opt;
	char	*equal;

#ifdef USE_GID
	setgid(USE_GID);
#endif
#ifdef USE_UID
	setuid(USE_UID);
#endif
#ifdef RUNDIR
	chdir(RUNDIR);
#endif

	Input = stdin;
	Output = stdout;

	for (argc--, argv++; argc && **argv == '-'; argc--, argv++)
	{
		for ((*argv)++; **argv; (*argv)++)
		{
			switch (**argv)
			{
			    case 'w':
				ReadOnly = 0;
				break;
			    case 'd':
				Daemon = 1;
				break;
			    case 't':
				Timeout = 60 * atoi((*argv) + 1);
				goto nextArg;
				break;
			    case 'k':
				LockTimeout = 60 * atoi((*argv) + 1);
				goto nextArg;
				break;
			    case 'l':
				DontLog = 1;
				break;
			    default:
				if (equal = index(*argv, '='))
				{
					*equal = 0;
					for (opt = Strings; *opt; opt += 2)
					{
						if (!strcmp(opt[0], *argv))
						{
							opt[1] = equal + 1;
							goto nextArg;
						}
					}
					fprintf(stderr, "%s: unknown string.\n", *argv);
				} else
					fprintf(stderr, "%c: unknown option.\n", **argv);
			}
		}
	      nextArg:;
	}
	if (!DontLog)
	{
#ifdef LOG_DAEMON
# ifndef LOG_QILOG
#  define	LOG_QILOG	LOG_DAEMON
# endif	/* !LOG_QILOG */
		openlog("tqi", LOG_PID, LOG_QILOG);
#else	/* !LOG_DAEMON */
		openlog("tqi", LOG_PID);
#endif	/* LOG_DAEMON */
	}
	WhoAreYou();
	IssueMessage(LOG_INFO, "begin %s", Foreign);
	InitializeOptions();
	SetSignals();

	/* get configuration */
	if (!GetFieldConfig())
	{
		fprintf(Output, "%d:Field config is missing.\n", LR_INTERNAL);
		exit(1);
	}
	if (Daemon && GetState())
	{
		fprintf(Output, "555:Database shut off (%s).\n", DBState);
		exit(0);
	}
	Initializing = 0;
	if (InputType == IT_TTY || InputType == IT_PIPE || InputType == IT_FILE)
		AmHero = 1;
	do
	{
		if (Timeout)
			alarm(0);
		fflush(Output);
		if (InputType == IT_TTY || InputType == IT_PIPE || InputType == IT_FILE)
			printf("\nmqi> ");
		if (Timeout)
			alarm(Timeout);
	}
	while (yylex());
	DoQuit(NULL);
	IssueMessage(LOG_INFO, "Done 0\n");
}

void
cleanup(sig)
	int sig;
{
	IssueMessage(LOG_INFO, "Done %d\n", sig);
	exit(1);
}

void 
SetSignals()
{
	(void) signal(SIGALRM, cleanup);
	(void) signal(SIGHUP, cleanup);
	(void) signal(SIGINT, cleanup);
	(void) signal(SIGQUIT, cleanup);
	(void) signal(SIGILL, cleanup);
	(void) signal(SIGTRAP, cleanup);
	(void) signal(SIGIOT, cleanup);
	(void) signal(SIGEMT, cleanup);
	(void) signal(SIGFPE, cleanup);
	(void) signal(SIGBUS, cleanup);
	(void) signal(SIGSEGV, cleanup);
	(void) signal(SIGSYS, cleanup);
}

#ifndef L_INCR
# define L_INCR 1
#endif /* !L_INCR */

/*
 * who am I talking to?
 */
void 
WhoAreYou()
{
	struct sockaddr From;
	struct sockaddr_in *sin = (struct sockaddr_in *) (&From);
	int	FromLen = sizeof (From);
	struct passwd *pwd;
	char	*hostname;
	char	errorstr[MAXSTR];
	struct hostent *hp = NULL;

	if (isatty(fileno(stdin)))
	{
		InputType = IT_TTY;
		pwd = getpwuid(getuid());
		(void) sprintf(Foreign, "%s %s", ttyname(fileno(stdin)), pwd->pw_name);
	} else if (getpeername(fileno(stdin), &From, &FromLen) == 0)
	{
		InputType = IT_NET;
		/* get name of connected client */
		hp = gethostbyaddr((char *)&sin->sin_addr, sizeof (sin->sin_addr), AF_INET);
#ifndef NOCHECKNET
		if (hp) {
			/*
			 * Attempt to verify that we haven't been fooled by
			 * someone in a remote net; look up the name and check
			 * that this address corresponds to the name.
			 */

			int	HostNameLen = strlen (hp->h_name);
			char	remotehost[2 * MAXHOSTNAMELEN + 1];

			hostname = hp->h_name;
			strncpy(remotehost, hp->h_name, sizeof(remotehost) - 1);
			remotehost[sizeof(remotehost) - 1] = 0;
			hp = gethostbyname(remotehost);
			if (hp == NULL) {
				(void) sprintf(errorstr, "Couldn't look up address for %s", remotehost);
				DoReply(LR_NOADDR, errorstr);
				IssueMessage(LOG_NOTICE, errorstr);
				DoQuit(NULL);
			} else for (; ; hp->h_addr_list++) {
				if (hp->h_addr_list[0] == NULL) {
					(void) sprintf(errorstr,
					    "Host addr %s not listed for host %s",
					    inet_ntoa(sin->sin_addr), hp->h_name);
					DoReply(LR_MISMATCH, errorstr);
					IssueMessage(LOG_NOTICE, errorstr);
					DoQuit(NULL);
				}
				if (!bcmp(hp->h_addr_list[0], (caddr_t)&sin->sin_addr,
				    sizeof(sin->sin_addr))) {
					hostname = hp->h_name;
					break;
				}
			}
		} else {
			IssueMessage(LOG_NOTICE, "Couldn't find hostname for address (%s)",
			    inet_ntoa(sin->sin_addr));
			DoReply(LR_NONAME, "No hostname found for IP address");
		}
#endif /* !NOCHECKNET */
#if defined(sparc) && __GNUC__ == 1
		(void) sprintf(Foreign, "NET %s", inet_ntoa(&sin->sin_addr));
#else
		(void) sprintf(Foreign, "NET %s", inet_ntoa(sin->sin_addr));
#endif
#ifdef EMAIL_AUTH
		if (ntohs(sin->sin_port) < IPPORT_RESERVED)
			TrustHp = hp;
#endif

#ifdef RESTRICTED
		{
			char	**local;

			for (local = OkAddrs; *local; local++)
				if (!strncmp(*local, Foreign + 4, strlen(*local)))
					return;
			OffCampus = 1;
		}
#endif
	} else if (lseek(fileno(stdin), 0, L_INCR) >= 0)
	{
		InputType = IT_FILE;
		pwd = getpwuid(getuid());
		(void) sprintf(Foreign, "FILE %s", pwd->pw_name);
	} else
	{
		InputType = IT_PIPE;
		pwd = getpwuid(getuid());
		(void) sprintf(Foreign, "PIPE %s", pwd->pw_name);
	}
}

/*
 * read the state of the database from a file
 */
int 
GetState()
{
	char	name[80];
	FILE	*fp;
	static char state[1024];
	char	*token;

	(void) sprintf(name, "%s.sta", Database);
	if ((fp = fopen(name, "r")) == NULL)
		return (0);

	if (fgets(state, 1024, fp))
	{
		fclose(fp);
		if (DBState = strtok(state, " \t\n"))
		{
			if (!strcmp(DBState, "off"))
			{
				DBState = (token = strtok(0, "\n")) ?
				    token : "for maintenance";
				return (1);
			} else
			{
				DBState = strtok(0, "\n");
				if (!ReadOnly && !Initializing)
					fprintf(Output, "100:The database is now read-only (%s).\n",
						DBState);
				ReadOnly = 1;
			}
		}
	} else
		(void) fclose(fp);

	return (0);
}

/*
 * exit cleanly when limit hit
 */
void 
LimitHit(sig)
	int sig;
{
	fprintf(Output, "%d: CPU time limit exceeded for this session.\n", LR_XCPU);
	DoQuit(NULL);
}
