/* 
   FLEETSTREET Install - script

   JUST RUN IT
   */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCls

Signal On Halt Name SignalHandler

CALL SysCls
SAY 'ͻ'
SAY '                                                           '
SAY '                FleetStreet Installation                   '
SAY '                                                           '
SAY 'ͼ'
SAY '                                                             '

/* get defaults
    */
Lang    =       Prompt( 'Sprache/Language (D/E)          [E]:', 'E',        'DE' )
SrcDir  = Directory()
IF Lang='D' THEN
      DestDir = Prompt( 'Zielverzeichnis          [C:\Fleet]:', 'C:\Fleet', ''   )
   ELSE
      DestDir = Prompt( 'Target directory         [C:\Fleet]:', 'C:\Fleet', ''   )
IF Lang='D' THEN
      Cr_Obj  = Prompt( 'WPS-Objekt erzeugen? (J/N)      [J]:', 'J',        'JN' )
   ELSE
      Cr_Obj  = Prompt( 'Create WPS object (Y/N)         [Y]:', 'Y',        'YN' )


/* correct pathnames
    */
IF RIGHT( SrcDir,  1) = '\' THEN
    SrcDir  = LEFT(SrcDir,  LENGTH(SrcDir) -1)
IF RIGHT( DestDir, 1) = '\' THEN
    DestDir = LEFT(DestDir, LENGTH(DestDir)-1)


/* All OK ?
    */
CALL SysCls
SAY 'ͻ'
SAY '                                                           '
SAY '                FleetStreet Installation                   '
SAY '                                                           '
SAY 'ͼ'
SAY '                                                             '
SAY '                                                             '
IF Lang='D' THEN
      SAY ' Sprache                : Deutsch'
   ELSE
      SAY ' Language               : English'
IF Lang='D' THEN
      SAY ' Quellverzeichnis       : 'SrcDir
   ELSE
      SAY ' Source Directory       : 'SrcDir
IF Lang='D' THEN
      SAY ' Zielverzeichnis        : 'DestDir
   ELSE
      SAY ' Installation Directory : 'DestDir
IF Lang='D' THEN
      SAY ' WPS-Objekt erzeugen    : 'Cr_Obj
   ELSE
      SAY ' create WPS object      : 'Cr_Obj
SAY
SAY
IF Lang='D' THEN
   reply = Prompt( 'In Ordnung? (J/N)   [J]:', 'J', 'JN', )
ELSE
   reply = Prompt( 'Correct? (Y/N)  [Y]:', 'Y', 'YN', )

IF reply = 'N' THEN
   EXIT


CALL SysCls
SAY 'ͻ'
SAY '                                                           '
SAY '                FleetStreet Installation                   '
SAY '                                                           '
SAY 'ͼ'
SAY '                                                             '
SAY '                                                             '

/* check destination directory
    */
Call SysFileTree DestDir, Dirs, 'D'

/* Directory nicht da  */
If Dirs.0 = '0' & Lang = 'D' THEN DO
   SAY 'Das Verzeichnis "'DestDir'" existiert nicht.'
   SAY
   answer = Prompt( 'Verzeichnis erstellen? (J/N)       [J]:', 'J', 'JN', )
   SAY
   IF answer = 'J' THEN DO
      SAY 'Erzeuge Verzeichnis 'DestDir' ....'
      rc = SysMkDir( DestDir )
      IF rc = 0 THEN
         SAY 'Das Verzeichnis "'DestDir'" wurde erzeugt.'
      ELSE DO
         SAY 'Fehler beim Erzeugen von "'DestDir'". Abbruch der Installation'
         EXIT
         END
      END /* do if answer */
    ELSE
      EXIT
END /* if dirs.0 */

If Dirs.0 = '0' & Lang = 'E' THEN DO
   SAY 'The "'DestDir'" directory does not exist on your hard drive.'
   SAY
   answer = Prompt( 'create directory? (Y/N)       [Y]:', 'Y', 'YN', )
   SAY
   IF answer = 'Y' THEN DO
      SAY 'Creating 'DestDir' ...'
      rc = SysMkDir( DestDir )
      IF rc = 0 THEN
         SAY 'The directory "'DestDir'" was created successfully.'
      ELSE DO
         SAY 'The directory "'DestDir'" could not be created. Exiting installation'
         EXIT
         END
      END /* do */
   ELSE
      EXIT
End /* if dirs.0 */



/* correct pathnames for copy
    */
SrcDir  = SrcDir||'\'
DestDir = DestDir||'\'

if translate(SrcDir) <> translate(DestDir) then
   do
   CALL FileCopy SrcDir||'FltStrt.exe'  DestDir||'FltStrt.exe'
   CALL FileCopy SrcDir||'EDITWIN.DLL'  DestDir||'EditWin.dll'
   CALL FileCopy SrcDir||'FLTV7.DLL'    DestDir||'FltV7.dll'
   CALL FileCopy SrcDir||'LAYOUTS.DLL'  DestDir||'Layouts.dll'
   CALL FileCopy SrcDir||'msgview.DLL'  DestDir||'MsgView.dll'
   CALL FileCopy SrcDir||'hmsg.DLL'     DestDir||'hmsg.dll'
   CALL FileCopy SrcDir||'statline.DLL' DestDir||'statline.dll'
   end

IF Lang = 'D' THEN DO
   CALL FileCopy SrcDir||'german.hlp'    DestDir||'FltStrt.hlp'
   CALL FileCopy SrcDir||'german.lng'    DestDir||'FleetLng.dll'
   CALL FileCopy SrcDir||'readme.txt'    DestDir||'"ReadMe"'
   CALL FileCopy SrcDir||'whatsnew.txt'  DestDir||'"WhatsNew"'
   END
ELSE DO
   CALL FileCopy SrcDir||'english.hlp'   DestDir||'FltStrt.hlp'
   CALL FileCopy SrcDir||'english.lng'   DestDir||'FleetLng.dll'
   CALL FileCopy SrcDir||'readme.eng'    DestDir||'"ReadMe"'
   CALL FileCopy SrcDir||'whatsnew.eng'  DestDir||'"WhatsNew"'
   END


/* Program objekt erstellen ? */
CALL SysCls
IF Cr_Obj = 'Y' | Cr_Obj = 'J' THEN
   IF Lang = 'D' THEN DO
      IF \SysCreateObject( "WPFolder",  "FleetStreet^Beta 0.87", "<WP_DESKTOP>" ,,
         "OBJECTID=<FleetFldr>" , "R") THEN DO
         SAY "Fehler beim Erzeugen des Ordners"
         EXIT
         END
      IF \SysCreateObject( "WPProgram", "FleetStreet", "<FleetFldr>",,
         "OBJECTID=<FleetPRG>;EXENAME="||DestDir||"\FltStrt.exe;STARTUPDIR="||DestDir, "R" ) THEN DO
         SAY "Fehler beim Erzeugen des Programmobjekts"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "ReadMe" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"ReadMe;OBJECTID=<FleetRdm>", "R" ) THEN DO
         SAY "Fehler beim Erzeugen des 1. Readme-Objekts"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "WhatsNew" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"WhatsNew;OBJECTID=<FleetNewRdm>", "R" ) THEN DO
         SAY "Fehler beim Erzeugen des 3. Readme-Objekts"
         EXIT
         END
      END
   ELSE DO                                  /* english version */
      IF \SysCreateObject( "WPFolder",  "FleetStreet^Beta 0.87", "<WP_DESKTOP>" ,,
         "OBJECTID=<FleetFldr>" , "R") THEN DO
         SAY "Error creating Folder"
         EXIT
         END
      IF \SysCreateObject( "WPProgram", "FleetStreet", "<FleetFldr>",,
         "OBJECTID=<FleetPRG>;EXENAME="||DestDir||"\FltStrt.exe;STARTUPDIR="||DestDir, "R" ) THEN DO
         SAY "Error creating program object"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "ReadMe" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"ReadMe;OBJECTID=<FleetRdm>", "R" ) THEN DO
         SAY "Error creating 1st readme object"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "WhatsNew" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"WhatsNew;OBJECTID=<FleetNewRdm>", "R" ) THEN DO
         SAY "Error creating 3rd readme object"
         EXIT
         END
      END

CALL SysCls
IF Lang = 'D' THEN DO
   Say 'ͻ'
   Say '                                                           '
   Say '   Die Installation von FleetStreet ist fertig.            '
   Say '                                                           '
   Say '   Fr neueste Infos lesen Sie die Dateien "ReadMe",       '
   Say '   und "WhatsNew".                                         '
   Say '                                                           '
   Say 'ͼ'
   END  /* Do */
ELSE DO
   Say 'ͻ'
   Say '                                                      '
   Say '   FleetStreet installation is complete               '
   Say '                                                      '
   Say '   For latest information read the files "ReadMe",    '
   Say '   and "WhatsNew".                                    '
   Say '                                                      '
   Say 'ͼ'
   END
Exit


/* 
   FileCopy
    */
   FileCopy:
   PARSE ARG SrcFile DestFile

       IF Lang = 'D' THEN
          SAY 'Kopiere 'SrcFile' nach 'DestFile
       ELSE
          SAY 'Copying 'SrcFile' to 'DestFile
       '@Copy' SrcFile DestFile '>NUL'
       if rc \= 0 Then Do
          SAY 'Warning! 'SrcFile' could not be copied properly. PRESS YOUR FAVOURITE <ANY-KEY>'
          Pull ConfirmIt
          End
       Return


/* 
   Prompt
    */
   Prompt:
   PARSE Arg PrText, DefVal,  PossVal

       PARSE VALUE SysCurPos() WITH Row .             /* position of cursor   */
       PARSE VALUE SysTextScreenSize() WITH NumRows . /* screen size          */
       IF Row = NumRows - 1 THEN Row = Row - 1        /* end of screen?       */
       Col = Length(PrText) + 2                       /* input                */
       DO UNTIL answer \= ''
          CALL SysCurPos Row, 1
          SAY PrText                                  /* show input           */
          CALL SysCurPos Row, Col
          PARSE PULL answer
          IF answer = '' THEN
             answer = DefVal
          IF PossVal \= '' THEN DO                    /* accept all inputs    */
             answer = TRANSLATE(answer)
             IF POS(answer,PossVal) = 0 THEN          /* if PossVal is empty  */
                answer = ''
             END
       END /* until */
    RETURN answer


/* 
   SignalHandler
    */
SignalHandler:
Call SysCls
Exit
