/* ENGLISH.CMD: Installation of CARDS.EXE in english. */
'@Echo Off'

/* load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisation */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation of CARDS 1.02a...'
Say ''


/* Check... */

Language = 'ENGLISH'

Result = SysFileTree( Language".EX_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.EX_ not found!'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PICTURES.DLL not found!'
  Signal DONE
  End

Result = SysFileTree( "README.TXT", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: README.TXT not found!'
  Signal DONE
  End

Result = SysFileTree( Language".HL_", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.HL_ not found!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */
 
Say 'Please enter the full target path for CARDS'
Say '  Default: C:\CARDS: '
Pull Directory
If Directory = "" Then Directory = 'C:\CARDS'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Can''t create target path.'
    Signal DONE
    End
  End
Say '';

/* Create desktop object */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Copying CARDS to ' Directory '...'
Copy Language".EX_" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy "README.TXT" Directory"\README.TXT" '1>NUL'
Copy Language".HL_" Directory"\CARDS.HLP" '1>NUL'

Say 'Creating desktop object...'
Type = 'WPProgram'
Title = 'Cardgames'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Desktop object was created!  Ready.'
Else             
  Say 'ERROR: Can''t create desktop object!'

Signal DONE

FAILURE:
Say 'Error while processing REXX.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxerror.'
Signal DONE

DONE:
Exit
