#ifndef GAME_INCLUDED
#define GAME_INCLUDED
class AGame
{
public:
  enum Piece {
    EMPTY = 0,
    B_ROO, B_KNI, B_BIS, B_QUE, B_KIN, B_PAW,
    W_ROO, W_KNI, W_BIS, W_QUE, W_KIN, W_PAW
    };
  enum Color {
    WHITE = 0,
    BLACK = 1
    };

  AGame();
  ~AGame();

  static Boolean isBlack(Piece p) { return p>=B_ROO && p<=B_PAW; }
  static Boolean isWhite(Piece p) { return p>=W_ROO && p<=W_PAW; }
  static Piece toPiece(char);		// convert 'R' to W_ROO, etc.

  Color onMove() { return onMoveColor; }
  void setOnMove(Color m) { onMoveColor = m; }

  void initialize();

  int moveNumber() { return movenum; }
  void setMoveNumber(int n) { movenum = n; }

  inline enum Piece piece(int file, int rank) { 
    return pieceArray[rank][file]; 
  }
  inline void setPiece(int file, int rank, Piece p) {
    pieceArray[rank][file] = p;
  }

  char *asString();

  static AGame* current();
private:
  enum Color    onMoveColor;
  int           movenum;
  enum Piece    pieceArray[8][8], opieceArray[8][8];
};
#endif
