#ifndef WPMICS_INCLUDED
#define WPMICS_INCLUDED
//**************************************************************************
// Class:   PmicsWindow                                                    *
//                                                                         *
// Purpose: Main window for PMICS, uses canvas to manage subwindows.       *
//                                                                         *
//**************************************************************************

#include <iframe.hpp>                   //IFrameWindow Class Header
#include <istattxt.hpp>                 //IStaticText Class Header
#include <imenubar.hpp>
#include <isplitcv.hpp>                 //ISplitCanvas Class Header
#include <isetcv.hpp>
#include <imcelcv.hpp>
#include <ilistbox.hpp>
#include <icmdhdr.hpp>
#include <ipushbut.hpp>

class BoardWindow;
class CommWindow;
class PmicsWindow;


class PmicsMsgHandler : public IHandler
{
public:
  PmicsMsgHandler(PmicsWindow *w) {}
protected:
  virtual Boolean dispatchHandlerEvent(IEvent &evt);
};


class PmicsWindow : public IFrameWindow, public ICommandHandler
{
  public:                               //Define the public Information
    PmicsWindow(unsigned long windowId);//Constructor for this class
    CommWindow    * commWindow;
    void updateStat(char *p);
    void updateClocks();
    void statWhiteTop();
    void statWhiteBottom();
    void statWhiteOnMove(unsigned int);
    void statBlackOnMove(unsigned int);

  protected:
    Boolean command (ICommandEvent& cmdEvent);

  private:                              //Define the private Information
    void setupStat(IWindow *parent);
    IString expandButtonAction(IString action);
    IMenuBar      * menuBar;            //Define an Information Area          
                                        //  Control to create an information   .
                                        //  area beneath the client area      
    ISplitCanvas  * horzCanvas;
    ISetCanvas  * vertCanvas;
    IMultiCellCanvas    * statCanvas;
    ISetCanvas    * buttCanvas,
                  * textWName,
                  * textBName;
    BoardWindow   * boardWindow;
    IListBox      * commList;
    IPushButton   * pushButton[NUM_PUSHBUTTONS];
    IListBox      * moveList;
    IStaticText   * textWClock,
                  * textBClock,
                  * textGameName,
                  * textMove;
    PmicsMsgHandler     * msgHandler;
    int           statWClock, 
                  statBClock,
                  *tickClock,
                  gameNum,
                  onMove;
};

class HelpCommandHandler : public ICommandHandler {
protected:
  virtual Boolean command (ICommandEvent &evt);
};
#endif
